/* $Id: alaw_ulaw_table.c 369517 2012-07-01 17:28:57Z file $ */
/* 
 * Copyright (C) 2008-2011 Teluu Inc. (http://www.teluu.com)
 * Copyright (C) 2003-2008 Benny Prijono <benny@prijono.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

/*
 * The tables here and also the conversion ideas are contributed by 
 * Toni Rutar <toni at aufbix.org>. Many thanks!
 */
#include <pjmedia/alaw_ulaw.h>

#if defined(PJMEDIA_HAS_ALAW_ULAW_TABLE) && PJMEDIA_HAS_ALAW_ULAW_TABLE!=0

const pj_uint8_t pjmedia_linear2ulaw_tab[16384] = 
{
    0xff,0xfe,0xfe,0xfd,0xfd,0xfc,0xfc,0xfb,
    0xfb,0xfa,0xfa,0xf9,0xf9,0xf8,0xf8,0xf7,
    0xf7,0xf6,0xf6,0xf5,0xf5,0xf4,0xf4,0xf3,
    0xf3,0xf2,0xf2,0xf1,0xf1,0xf0,0xf0,0xef,
    0xef,0xef,0xef,0xee,0xee,0xee,0xee,0xed,
    0xed,0xed,0xed,0xec,0xec,0xec,0xec,0xeb,
    0xeb,0xeb,0xeb,0xea,0xea,0xea,0xea,0xe9,
    0xe9,0xe9,0xe9,0xe8,0xe8,0xe8,0xe8,0xe7,
    0xe7,0xe7,0xe7,0xe6,0xe6,0xe6,0xe6,0xe5,
    0xe5,0xe5,0xe5,0xe4,0xe4,0xe4,0xe4,0xe3,
    0xe3,0xe3,0xe3,0xe2,0xe2,0xe2,0xe2,0xe1,
    0xe1,0xe1,0xe1,0xe0,0xe0,0xe0,0xe0,0xdf,
    0xdf,0xdf,0xdf,0xdf,0xdf,0xdf,0xdf,0xde,
    0xde,0xde,0xde,0xde,0xde,0xde,0xde,0xdd,
    0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdc,
    0xdc,0xdc,0xdc,0xdc,0xdc,0xdc,0xdc,0xdb,
    0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,0xdb,0xda,
    0xda,0xda,0xda,0xda,0xda,0xda,0xda,0xd9,
    0xd9,0xd9,0xd9,0xd9,0xd9,0xd9,0xd9,0xd8,
    0xd8,0xd8,0xd8,0xd8,0xd8,0xd8,0xd8,0xd7,
    0xd7,0xd7,0xd7,0xd7,0xd7,0xd7,0xd7,0xd6,
    0xd6,0xd6,0xd6,0xd6,0xd6,0xd6,0xd6,0xd5,
    0xd5,0xd5,0xd5,0xd5,0xd5,0xd5,0xd5,0xd4,
    0xd4,0xd4,0xd4,0xd4,0xd4,0xd4,0xd4,0xd3,
    0xd3,0xd3,0xd3,0xd3,0xd3,0xd3,0xd3,0xd2,
    0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd2,0xd1,
    0xd1,0xd1,0xd1,0xd1,0xd1,0xd1,0xd1,0xd0,
    0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xd0,0xcf,
    0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,
    0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,0xce,
    0xce,0xce,0xce,0xce,0xce,0xce,0xce,0xce,
    0xce,0xce,0xce,0xce,0xce,0xce,0xce,0xcd,
    0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,
    0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcd,0xcc,
    0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,
    0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xcb,
    0xcb,0xcb,0xcb,0xcb,0xcb,0xcb,0xcb,0xcb,
    0xcb,0xcb,0xcb,0xcb,0xcb,0xcb,0xcb,0xca,
    0xca,0xca,0xca,0xca,0xca,0xca,0xca,0xca,
    0xca,0xca,0xca,0xca,0xca,0xca,0xca,0xc9,
    0xc9,0xc9,0xc9,0xc9,0xc9,0xc9,0xc9,0xc9,
    0xc9,0xc9,0xc9,0xc9,0xc9,0xc9,0xc9,0xc8,
    0xc8,0xc8,0xc8,0xc8,0xc8,0xc8,0xc8,0xc8,
    0xc8,0xc8,0xc8,0xc8,0xc8,0xc8,0xc8,0xc7,
    0xc7,0xc7,0xc7,0xc7,0xc7,0xc7,0xc7,0xc7,
    0xc7,0xc7,0xc7,0xc7,0xc7,0xc7,0xc7,0xc6,
    0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,
    0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc6,0xc5,
    0xc5,0xc5,0xc5,0xc5,0xc5,0xc5,0xc5,0xc5,
    0xc5,0xc5,0xc5,0xc5,0xc5,0xc5,0xc5,0xc4,
    0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,
    0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc4,0xc3,
    0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,
    0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc3,0xc2,
    0xc2,0xc2,0xc2,0xc2,0xc2,0xc2,0xc2,0xc2,
    0xc2,0xc2,0xc2,0xc2,0xc2,0xc2,0xc2,0xc1,
    0xc1,0xc1,0xc1,0xc1,0xc1,0xc1,0xc1,0xc1,
    0xc1,0xc1,0xc1,0xc1,0xc1,0xc1,0xc1,0xc0,
    0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,
    0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xc0,0xbf,
    0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,
    0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,
    0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,
    0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0xbe,
    0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,
    0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,
    0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,
    0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbe,0xbd,
    0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,
    0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,
    0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,
    0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xbc,
    0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,
    0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,
    0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,
    0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbc,0xbb,
    0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,
    0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,
    0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,
    0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xbb,0xba,
    0xba,0xba,0xba,0xba,0xba,0xba,0xba,0xba,
    0xba,0xba,0xba,0xba,0xba,0xba,0xba,0xba,
    0xba,0xba,0xba,0xba,0xba,0xba,0xba,0xba,
    0xba,0xba,0xba,0xba,0xba,0xba,0xba,0xb9,
    0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,
    0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,
    0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,
    0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb9,0xb8,
    0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,
    0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,
    0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,
    0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,0xb7,
    0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,
    0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,
    0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,
    0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb7,0xb6,
    0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,
    0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,
    0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,
    0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb6,0xb5,
    0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,
    0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,
    0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,
    0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb4,
    0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,
    0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,
    0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,
    0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,0xb3,
    0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,
    0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,
    0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,
    0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb3,0xb2,
    0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,
    0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,
    0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,
    0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb2,0xb1,
    0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,
    0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,
    0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,
    0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb1,0xb0,
    0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,
    0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,
    0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,
    0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xb0,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,
    0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xae,
    0xae,0xae,0xae,0xae,0xae,0xae,0xae,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xad,
    0xad,0xad,0xad,0xad,0xad,0xad,0xad,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xac,
    0xac,0xac,0xac,0xac,0xac,0xac,0xac,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,
    0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,
    0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,
    0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa9,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,
    0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,
    0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa7,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,
    0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa6,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,
    0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa5,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,
    0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa4,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,
    0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa3,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,
    0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa2,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,
    0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa1,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,
    0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0xa0,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,
    0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9f,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
    0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,
    0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9d,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,
    0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,
    0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9b,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,
    0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x9a,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
    0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
    0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
    0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
    0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
    0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
    0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
    0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
    0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
    0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
    0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,
    0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,
    0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8e,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,
    0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8d,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,
    0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8c,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,
    0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8b,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,
    0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x8a,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
    0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
    0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
    0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
    0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
    0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
    0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
    0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
    0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
    0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
    0x01,0x01,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
    0x02,0x02,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
    0x03,0x03,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
    0x04,0x04,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
    0x05,0x05,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
    0x06,0x06,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
    0x07,0x07,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
    0x08,0x08,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
    0x09,0x09,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
    0x0a,0x0a,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
    0x0b,0x0b,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,
    0x0c,0x0c,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,0x0d,
    0x0d,0x0d,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,0x0e,
    0x0e,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
    0x0f,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
    0x10,0x10,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
    0x11,0x11,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
    0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
    0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
    0x14,0x14,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
    0x15,0x15,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
    0x16,0x16,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
    0x17,0x17,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
    0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
    0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
    0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
    0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
    0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
    0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
    0x1e,0x1e,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,
    0x1f,0x1f,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
    0x20,0x20,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
    0x21,0x21,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
    0x22,0x22,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
    0x23,0x23,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
    0x24,0x24,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
    0x25,0x25,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
    0x26,0x26,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
    0x27,0x27,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
    0x28,0x28,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
    0x29,0x29,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,0x2a,
    0x2a,0x2a,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,0x2b,
    0x2b,0x2b,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,
    0x2c,0x2c,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,0x2d,
    0x2d,0x2d,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,0x2e,
    0x2e,0x2e,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,0x2f,
    0x2f,0x2f,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x31,0x31,0x31,0x31,0x31,
    0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
    0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
    0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
    0x31,0x31,0x32,0x32,0x32,0x32,0x32,0x32,
    0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
    0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
    0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
    0x32,0x32,0x33,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
    0x33,0x33,0x34,0x34,0x34,0x34,0x34,0x34,
    0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
    0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
    0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
    0x34,0x34,0x35,0x35,0x35,0x35,0x35,0x35,
    0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
    0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
    0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
    0x35,0x35,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
    0x36,0x36,0x37,0x37,0x37,0x37,0x37,0x37,
    0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
    0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
    0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
    0x37,0x37,0x38,0x38,0x38,0x38,0x38,0x38,
    0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
    0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
    0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
    0x38,0x38,0x39,0x39,0x39,0x39,0x39,0x39,
    0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
    0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
    0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
    0x39,0x39,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,
    0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,
    0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,
    0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,0x3a,
    0x3a,0x3a,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,
    0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,
    0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,
    0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,0x3b,
    0x3b,0x3b,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,
    0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,
    0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,
    0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,0x3c,
    0x3c,0x3c,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,
    0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,
    0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,
    0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,0x3d,
    0x3d,0x3d,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,
    0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,
    0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,
    0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,0x3e,
    0x3e,0x3e,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
    0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
    0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
    0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,
    0x3f,0x3f,0x40,0x40,0x40,0x40,0x40,0x40,
    0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
    0x40,0x40,0x41,0x41,0x41,0x41,0x41,0x41,
    0x41,0x41,0x41,0x41,0x41,0x41,0x41,0x41,
    0x41,0x41,0x42,0x42,0x42,0x42,0x42,0x42,
    0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,
    0x42,0x42,0x43,0x43,0x43,0x43,0x43,0x43,
    0x43,0x43,0x43,0x43,0x43,0x43,0x43,0x43,
    0x43,0x43,0x44,0x44,0x44,0x44,0x44,0x44,
    0x44,0x44,0x44,0x44,0x44,0x44,0x44,0x44,
    0x44,0x44,0x45,0x45,0x45,0x45,0x45,0x45,
    0x45,0x45,0x45,0x45,0x45,0x45,0x45,0x45,
    0x45,0x45,0x46,0x46,0x46,0x46,0x46,0x46,
    0x46,0x46,0x46,0x46,0x46,0x46,0x46,0x46,
    0x46,0x46,0x47,0x47,0x47,0x47,0x47,0x47,
    0x47,0x47,0x47,0x47,0x47,0x47,0x47,0x47,
    0x47,0x47,0x48,0x48,0x48,0x48,0x48,0x48,
    0x48,0x48,0x48,0x48,0x48,0x48,0x48,0x48,
    0x48,0x48,0x49,0x49,0x49,0x49,0x49,0x49,
    0x49,0x49,0x49,0x49,0x49,0x49,0x49,0x49,
    0x49,0x49,0x4a,0x4a,0x4a,0x4a,0x4a,0x4a,
    0x4a,0x4a,0x4a,0x4a,0x4a,0x4a,0x4a,0x4a,
    0x4a,0x4a,0x4b,0x4b,0x4b,0x4b,0x4b,0x4b,
    0x4b,0x4b,0x4b,0x4b,0x4b,0x4b,0x4b,0x4b,
    0x4b,0x4b,0x4c,0x4c,0x4c,0x4c,0x4c,0x4c,
    0x4c,0x4c,0x4c,0x4c,0x4c,0x4c,0x4c,0x4c,
    0x4c,0x4c,0x4d,0x4d,0x4d,0x4d,0x4d,0x4d,
    0x4d,0x4d,0x4d,0x4d,0x4d,0x4d,0x4d,0x4d,
    0x4d,0x4d,0x4e,0x4e,0x4e,0x4e,0x4e,0x4e,
    0x4e,0x4e,0x4e,0x4e,0x4e,0x4e,0x4e,0x4e,
    0x4e,0x4e,0x4f,0x4f,0x4f,0x4f,0x4f,0x4f,
    0x4f,0x4f,0x4f,0x4f,0x4f,0x4f,0x4f,0x4f,
    0x4f,0x4f,0x50,0x50,0x50,0x50,0x50,0x50,
    0x50,0x50,0x51,0x51,0x51,0x51,0x51,0x51,
    0x51,0x51,0x52,0x52,0x52,0x52,0x52,0x52,
    0x52,0x52,0x53,0x53,0x53,0x53,0x53,0x53,
    0x53,0x53,0x54,0x54,0x54,0x54,0x54,0x54,
    0x54,0x54,0x55,0x55,0x55,0x55,0x55,0x55,
    0x55,0x55,0x56,0x56,0x56,0x56,0x56,0x56,
    0x56,0x56,0x57,0x57,0x57,0x57,0x57,0x57,
    0x57,0x57,0x58,0x58,0x58,0x58,0x58,0x58,
    0x58,0x58,0x59,0x59,0x59,0x59,0x59,0x59,
    0x59,0x59,0x5a,0x5a,0x5a,0x5a,0x5a,0x5a,
    0x5a,0x5a,0x5b,0x5b,0x5b,0x5b,0x5b,0x5b,
    0x5b,0x5b,0x5c,0x5c,0x5c,0x5c,0x5c,0x5c,
    0x5c,0x5c,0x5d,0x5d,0x5d,0x5d,0x5d,0x5d,
    0x5d,0x5d,0x5e,0x5e,0x5e,0x5e,0x5e,0x5e,
    0x5e,0x5e,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,
    0x5f,0x5f,0x60,0x60,0x60,0x60,0x61,0x61,
    0x61,0x61,0x62,0x62,0x62,0x62,0x63,0x63,
    0x63,0x63,0x64,0x64,0x64,0x64,0x65,0x65,
    0x65,0x65,0x66,0x66,0x66,0x66,0x67,0x67,
    0x67,0x67,0x68,0x68,0x68,0x68,0x69,0x69,
    0x69,0x69,0x6a,0x6a,0x6a,0x6a,0x6b,0x6b,
    0x6b,0x6b,0x6c,0x6c,0x6c,0x6c,0x6d,0x6d,
    0x6d,0x6d,0x6e,0x6e,0x6e,0x6e,0x6f,0x6f,
    0x6f,0x6f,0x70,0x70,0x71,0x71,0x72,0x72,
    0x73,0x73,0x74,0x74,0x75,0x75,0x76,0x76,
    0x77,0x77,0x78,0x78,0x79,0x79,0x7a,0x7a,
    0x7b,0x7b,0x7c,0x7c,0x7d,0x7d,0x7e,0x7e
};


const pj_uint8_t pjmedia_linear2alaw_tab[16384] = 
{
     0xD5,0xD5,0xD5,0xD5,0xD4,0xD4,0xD4,0xD4,
     0xD7,0xD7,0xD7,0xD7,0xD6,0xD6,0xD6,0xD6,
     0xD1,0xD1,0xD1,0xD1,0xD0,0xD0,0xD0,0xD0,
     0xD3,0xD3,0xD3,0xD3,0xD2,0xD2,0xD2,0xD2,
     0xDD,0xDD,0xDD,0xDD,0xDC,0xDC,0xDC,0xDC,
     0xDF,0xDF,0xDF,0xDF,0xDE,0xDE,0xDE,0xDE,
     0xD9,0xD9,0xD9,0xD9,0xD8,0xD8,0xD8,0xD8,
     0xDB,0xDB,0xDB,0xDB,0xDA,0xDA,0xDA,0xDA,
     0xC5,0xC5,0xC5,0xC5,0xC4,0xC4,0xC4,0xC4,
     0xC7,0xC7,0xC7,0xC7,0xC6,0xC6,0xC6,0xC6,
     0xC1,0xC1,0xC1,0xC1,0xC0,0xC0,0xC0,0xC0,
     0xC3,0xC3,0xC3,0xC3,0xC2,0xC2,0xC2,0xC2,
     0xCD,0xCD,0xCD,0xCD,0xCC,0xCC,0xCC,0xCC,
     0xCF,0xCF,0xCF,0xCF,0xCE,0xCE,0xCE,0xCE,
     0xC9,0xC9,0xC9,0xC9,0xC8,0xC8,0xC8,0xC8,
     0xCB,0xCB,0xCB,0xCB,0xCA,0xCA,0xCA,0xCA,
     0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,0xF5,
     0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,0xF4,
     0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,0xF7,
     0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,0xF6,
     0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,0xF1,
     0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,0xF0,
     0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,0xF3,
     0xF2,0xF2,0xF2,0xF2,0xF2,0xF2,0xF2,0xF2,
     0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,0xFD,
     0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,0xFC,
     0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,
     0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,0xFE,
     0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,0xF9,
     0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,0xF8,
     0xFB,0xFB,0xFB,0xFB,0xFB,0xFB,0xFB,0xFB,
     0xFA,0xFA,0xFA,0xFA,0xFA,0xFA,0xFA,0xFA,
     0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,
     0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,0xE5,
     0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,
     0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,0xE4,
     0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,
     0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,0xE7,
     0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,
     0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,0xE6,
     0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,
     0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,0xE1,
     0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,
     0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,
     0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,
     0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,0xE3,
     0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,
     0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,0xE2,
     0xED,0xED,0xED,0xED,0xED,0xED,0xED,0xED,
     0xED,0xED,0xED,0xED,0xED,0xED,0xED,0xED,
     0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,
     0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,0xEC,
     0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,
     0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,0xEF,
     0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,
     0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,0xEE,
     0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,
     0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,0xE9,
     0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,
     0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,0xE8,
     0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,
     0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,0xEB,
     0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,
     0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,
     0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
     0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
     0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
     0x95,0x95,0x95,0x95,0x95,0x95,0x95,0x95,
     0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
     0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
     0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
     0x94,0x94,0x94,0x94,0x94,0x94,0x94,0x94,
     0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
     0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
     0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
     0x97,0x97,0x97,0x97,0x97,0x97,0x97,0x97,
     0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
     0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
     0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
     0x96,0x96,0x96,0x96,0x96,0x96,0x96,0x96,
     0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
     0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
     0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
     0x91,0x91,0x91,0x91,0x91,0x91,0x91,0x91,
     0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
     0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
     0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
     0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,
     0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
     0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
     0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
     0x93,0x93,0x93,0x93,0x93,0x93,0x93,0x93,
     0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
     0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
     0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
     0x92,0x92,0x92,0x92,0x92,0x92,0x92,0x92,
     0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,
     0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,
     0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,
     0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,0x9D,
     0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,
     0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,
     0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,
     0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,0x9C,
     0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,
     0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,
     0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,
     0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,0x9F,
     0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,
     0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,
     0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,
     0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,0x9E,
     0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
     0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
     0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
     0x99,0x99,0x99,0x99,0x99,0x99,0x99,0x99,
     0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
     0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
     0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
     0x98,0x98,0x98,0x98,0x98,0x98,0x98,0x98,
     0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,
     0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,
     0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,
     0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,0x9B,
     0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,
     0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,
     0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,
     0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,0x9A,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x85,0x85,0x85,0x85,0x85,0x85,0x85,0x85,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x87,0x87,0x87,0x87,0x87,0x87,0x87,0x87,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0x86,0x86,0x86,0x86,0x86,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x83,0x83,0x83,0x83,0x83,0x83,0x83,0x83,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x82,0x82,0x82,0x82,0x82,0x82,0x82,0x82,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,0x8D,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,0x8C,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,0x8F,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,0x8E,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x89,0x89,0x89,0x89,0x89,0x89,0x89,0x89,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,0x8B,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,0x8A,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,0xB5,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,0xB4,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,0xB7,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,0xB6,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,0xB1,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,0xB0,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,0xB3,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,0xB2,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,0xBD,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,0xBC,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,0xBF,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,0xBE,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,0xB9,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,0xB8,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,0xBB,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,0xBA,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,0xA5,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,0xA4,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,0xA7,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,0xA6,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,0xA1,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,0xA0,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,0xA3,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,0xA2,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,0xAD,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,0xAC,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,0xAF,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,0xAE,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,0xA9,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,0xA8,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,0xAB,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,0xAA,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,0x2A,
     0x2A,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,0x2B,
     0x2B,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x28,
     0x28,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x29,0x29,0x29,0x29,0x29,0x29,0x29,
     0x29,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,0x2E,
     0x2E,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,0x2F,
     0x2F,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,0x2C,
     0x2C,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,0x2D,
     0x2D,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x22,0x22,0x22,0x22,0x22,0x22,0x22,
     0x22,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x23,0x23,0x23,0x23,0x23,0x23,0x23,
     0x23,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,
     0x20,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x21,0x21,0x21,0x21,0x21,0x21,0x21,
     0x21,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x26,0x26,0x26,0x26,0x26,0x26,0x26,
     0x26,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x27,0x27,0x27,0x27,0x27,0x27,0x27,
     0x27,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x24,0x24,0x24,0x24,0x24,0x24,0x24,
     0x24,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x25,0x25,0x25,0x25,0x25,0x25,0x25,
     0x25,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,0x3A,
     0x3A,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,0x3B,
     0x3B,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,
     0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x39,0x39,0x39,0x39,0x39,0x39,0x39,
     0x39,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,0x3E,
     0x3E,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,0x3F,
     0x3F,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,0x3C,
     0x3C,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,0x3D,
     0x3D,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x32,0x32,0x32,0x32,0x32,0x32,0x32,
     0x32,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x33,0x33,0x33,0x33,0x33,0x33,0x33,
     0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
     0x30,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x31,0x31,0x31,0x31,0x31,0x31,0x31,
     0x31,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x36,0x36,0x36,0x36,0x36,0x36,0x36,
     0x36,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x37,0x37,0x37,0x37,0x37,0x37,0x37,
     0x37,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x34,0x34,0x34,0x34,0x34,0x34,0x34,
     0x34,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x35,0x35,0x35,0x35,0x35,0x35,0x35,
     0x35,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,0x0A,
     0x0A,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,0x0B,
     0x0B,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
     0x08,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
     0x09,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,
     0x0E,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
     0x0F,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,0x0D,
     0x0D,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x02,0x02,0x02,0x02,0x02,0x02,0x02,
     0x02,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,
     0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
     0x01,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x06,0x06,0x06,0x06,0x06,0x06,0x06,
     0x06,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
     0x07,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
     0x04,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,
     0x05,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,
     0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,
     0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,
     0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,0x1A,
     0x1A,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,
     0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,
     0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,
     0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,0x1B,
     0x1B,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
     0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
     0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
     0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,
     0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
     0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
     0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
     0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
     0x19,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,
     0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,
     0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,
     0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,0x1E,
     0x1E,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
     0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
     0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
     0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,0x1F,
     0x1F,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
     0x1C,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,
     0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,
     0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,
     0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,0x1D,
     0x1D,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
     0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
     0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
     0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
     0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
     0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
     0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
     0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
     0x13,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
     0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
     0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
     0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
     0x10,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
     0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
     0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
     0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,
     0x11,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
     0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
     0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
     0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
     0x16,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
     0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
     0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
     0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
     0x17,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
     0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
     0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
     0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
     0x14,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
     0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
     0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
     0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
     0x15,0x6A,0x6A,0x6A,0x6A,0x6A,0x6A,0x6A,
     0x6A,0x6A,0x6A,0x6A,0x6A,0x6A,0x6A,0x6A,
     0x6A,0x6B,0x6B,0x6B,0x6B,0x6B,0x6B,0x6B,
     0x6B,0x6B,0x6B,0x6B,0x6B,0x6B,0x6B,0x6B,
     0x6B,0x68,0x68,0x68,0x68,0x68,0x68,0x68,
     0x68,0x68,0x68,0x68,0x68,0x68,0x68,0x68,
     0x68,0x69,0x69,0x69,0x69,0x69,0x69,0x69,
     0x69,0x69,0x69,0x69,0x69,0x69,0x69,0x69,
     0x69,0x6E,0x6E,0x6E,0x6E,0x6E,0x6E,0x6E,
     0x6E,0x6E,0x6E,0x6E,0x6E,0x6E,0x6E,0x6E,
     0x6E,0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,
     0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,0x6F,
     0x6F,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,
     0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,0x6C,
     0x6C,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,
     0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,0x6D,
     0x6D,0x62,0x62,0x62,0x62,0x62,0x62,0x62,
     0x62,0x62,0x62,0x62,0x62,0x62,0x62,0x62,
     0x62,0x63,0x63,0x63,0x63,0x63,0x63,0x63,
     0x63,0x63,0x63,0x63,0x63,0x63,0x63,0x63,
     0x63,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
     0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
     0x60,0x61,0x61,0x61,0x61,0x61,0x61,0x61,
     0x61,0x61,0x61,0x61,0x61,0x61,0x61,0x61,
     0x61,0x66,0x66,0x66,0x66,0x66,0x66,0x66,
     0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,
     0x66,0x67,0x67,0x67,0x67,0x67,0x67,0x67,
     0x67,0x67,0x67,0x67,0x67,0x67,0x67,0x67,
     0x67,0x64,0x64,0x64,0x64,0x64,0x64,0x64,
     0x64,0x64,0x64,0x64,0x64,0x64,0x64,0x64,
     0x64,0x65,0x65,0x65,0x65,0x65,0x65,0x65,
     0x65,0x65,0x65,0x65,0x65,0x65,0x65,0x65,
     0x65,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,0x7A,
     0x7A,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,0x7B,
     0x7B,0x78,0x78,0x78,0x78,0x78,0x78,0x78,
     0x78,0x79,0x79,0x79,0x79,0x79,0x79,0x79,
     0x79,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,
     0x7E,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,
     0x7F,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,0x7C,
     0x7C,0x7D,0x7D,0x7D,0x7D,0x7D,0x7D,0x7D,
     0x7D,0x72,0x72,0x72,0x72,0x72,0x72,0x72,
     0x72,0x73,0x73,0x73,0x73,0x73,0x73,0x73,
     0x73,0x70,0x70,0x70,0x70,0x70,0x70,0x70,
     0x70,0x71,0x71,0x71,0x71,0x71,0x71,0x71,
     0x71,0x76,0x76,0x76,0x76,0x76,0x76,0x76,
     0x76,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
     0x77,0x74,0x74,0x74,0x74,0x74,0x74,0x74,
     0x74,0x75,0x75,0x75,0x75,0x75,0x75,0x75,
     0x75,0x4A,0x4A,0x4A,0x4A,0x4B,0x4B,0x4B,
     0x4B,0x48,0x48,0x48,0x48,0x49,0x49,0x49,
     0x49,0x4E,0x4E,0x4E,0x4E,0x4F,0x4F,0x4F,
     0x4F,0x4C,0x4C,0x4C,0x4C,0x4D,0x4D,0x4D,
     0x4D,0x42,0x42,0x42,0x42,0x43,0x43,0x43,
     0x43,0x40,0x40,0x40,0x40,0x41,0x41,0x41,
     0x41,0x46,0x46,0x46,0x46,0x47,0x47,0x47,
     0x47,0x44,0x44,0x44,0x44,0x45,0x45,0x45,
     0x45,0x5A,0x5A,0x5A,0x5A,0x5B,0x5B,0x5B,
     0x5B,0x58,0x58,0x58,0x58,0x59,0x59,0x59,
     0x59,0x5E,0x5E,0x5E,0x5E,0x5F,0x5F,0x5F,
     0x5F,0x5C,0x5C,0x5C,0x5C,0x5D,0x5D,0x5D,
     0x5D,0x52,0x52,0x52,0x52,0x53,0x53,0x53,
     0x53,0x50,0x50,0x50,0x50,0x51,0x51,0x51,
     0x51,0x56,0x56,0x56,0x56,0x57,0x57,0x57,
     0x57,0x54,0x54,0x54,0x54,0x55,0x55,0x55
};

const pj_int16_t pjmedia_ulaw2linear_tab[256] = 
{
   -32124,-31100,-30076,-29052,-28028,-27004,-25980,-24956,
   -23932,-22908,-21884,-20860,-19836,-18812,-17788,-16764,
   -15996,-15484,-14972,-14460,-13948,-13436,-12924,-12412,
   -11900,-11388,-10876,-10364, -9852, -9340, -8828, -8316,
    -7932, -7676, -7420, -7164, -6908, -6652, -6396, -6140,
    -5884, -5628, -5372, -5116, -4860, -4604, -4348, -4092,
    -3900, -3772, -3644, -3516, -3388, -3260, -3132, -3004,
    -2876, -2748, -2620, -2492, -2364, -2236, -2108, -1980,
    -1884, -1820, -1756, -1692, -1628, -1564, -1500, -1436,
    -1372, -1308, -1244, -1180, -1116, -1052,  -988,  -924,
     -876,  -844,  -812,  -780,  -748,  -716,  -684,  -652,
     -620,  -588,  -556,  -524,  -492,  -460,  -428,  -396,
     -372,  -356,  -340,  -324,  -308,  -292,  -276,  -260,
     -244,  -228,  -212,  -196,  -180,  -164,  -148,  -132,
     -120,  -112,  -104,   -96,   -88,   -80,   -72,   -64,
      -56,   -48,   -40,   -32,   -24,   -16,    -8,     0,
    32124, 31100, 30076, 29052, 28028, 27004, 25980, 24956,
    23932, 22908, 21884, 20860, 19836, 18812, 17788, 16764,
    15996, 15484, 14972, 14460, 13948, 13436, 12924, 12412,
    11900, 11388, 10876, 10364,  9852,  9340,  8828,  8316,
     7932,  7676,  7420,  7164,  6908,  6652,  6396,  6140,
     5884,  5628,  5372,  5116,  4860,  4604,  4348,  4092,
     3900,  3772,  3644,  3516,  3388,  3260,  3132,  3004,
     2876,  2748,  2620,  2492,  2364,  2236,  2108,  1980,
     1884,  1820,  1756,  1692,  1628,  1564,  1500,  1436,
     1372,  1308,  1244,  1180,  1116,  1052,   988,   924,
      876,   844,   812,   780,   748,   716,   684,   652,
      620,   588,   556,   524,   492,   460,   428,   396,
      372,   356,   340,   324,   308,   292,   276,   260,
      244,   228,   212,   196,   180,   164,   148,   132,
      120,   112,   104,    96,    88,    80,    72,    64,
       56,    48,    40,    32,    24,    16,     8,     0
};

const pj_int16_t pjmedia_alaw2linear_tab[256] = 
{
      -5504, -5248, -6016, -5760, -4480, -4224, -4992, -4736,
      -7552, -7296, -8064, -7808, -6528, -6272, -7040, -6784,
      -2752, -2624, -3008, -2880, -2240, -2112, -2496, -2368,
      -3776, -3648, -4032, -3904, -3264, -3136, -3520, -3392,
     -22016,-20992,-24064,-23040,-17920,-16896,-19968,-18944,
     -30208,-29184,-32256,-31232,-26112,-25088,-28160,-27136,
     -11008,-10496,-12032,-11520, -8960, -8448, -9984, -9472,
     -15104,-14592,-16128,-15616,-13056,-12544,-14080,-13568,
       -344,  -328,  -376,  -360,  -280,  -264,  -312,  -296,
       -472,  -456,  -504,  -488,  -408,  -392,  -440,  -424,
	-88,   -72,  -120,  -104,   -24,    -8,   -56,   -40,
       -216,  -200,  -248,  -232,  -152,  -136,  -184,  -168,
      -1376, -1312, -1504, -1440, -1120, -1056, -1248, -1184,
      -1888, -1824, -2016, -1952, -1632, -1568, -1760, -1696,
       -688,  -656,  -752,  -720,  -560,  -528,  -624,  -592,
       -944,  -912, -1008,  -976,  -816,  -784,  -880,  -848,
       5504,  5248,  6016,  5760,  4480,  4224,  4992,  4736,
       7552,  7296,  8064,  7808,  6528,  6272,  7040,  6784,
       2752,  2624,  3008,  2880,  2240,  2112,  2496,  2368,
       3776,  3648,  4032,  3904,  3264,  3136,  3520,  3392,
      22016, 20992, 24064, 23040, 17920, 16896, 19968, 18944,
      30208, 29184, 32256, 31232, 26112, 25088, 28160, 27136,
      11008, 10496, 12032, 11520,  8960,  8448,  9984,  9472,
      15104, 14592, 16128, 15616, 13056, 12544, 14080, 13568,
	344,   328,   376,   360,   280,   264,   312,   296,
	472,   456,   504,   488,   408,   392,   440,   424,
	 88,    72,   120,   104,    24,     8,    56,    40,
	216,   200,   248,   232,   152,   136,   184,   168,
       1376,  1312,  1504,  1440,  1120,  1056,  1248,  1184,
       1888,  1824,  2016,  1952,  1632,  1568,  1760,  1696,
	688,   656,   752,   720,   560,   528,   624,   592,
	944,   912,  1008,   976,   816,   784,   880,   848
};

#endif

