/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2016 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
    case 2:	/* sbc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
    case 4:	/* sbcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
    case 7:	/* adds */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
    case 10:	/* subs */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
    case 12:	/* add */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
    case 14:	/* adds */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
    case 17:	/* subs */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
    case 20:	/* adds */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
    case 22:	/* sub */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
    case 24:	/* subs */
      value = 24;	/* --> subs.  */
      break;
    case 150:	/* mov */
    case 149:	/* umov */
      value = 149;	/* --> umov.  */
      break;
    case 152:	/* mov */
    case 151:	/* ins */
      value = 151;	/* --> ins.  */
      break;
    case 154:	/* mov */
    case 153:	/* ins */
      value = 153;	/* --> ins.  */
      break;
    case 236:	/* mvn */
    case 235:	/* not */
      value = 235;	/* --> not.  */
      break;
    case 311:	/* mov */
    case 310:	/* orr */
      value = 310;	/* --> orr.  */
      break;
    case 380:	/* sxtl */
    case 379:	/* sshll */
      value = 379;	/* --> sshll.  */
      break;
    case 382:	/* sxtl2 */
    case 381:	/* sshll2 */
      value = 381;	/* --> sshll2.  */
      break;
    case 404:	/* uxtl */
    case 403:	/* ushll */
      value = 403;	/* --> ushll.  */
      break;
    case 406:	/* uxtl2 */
    case 405:	/* ushll2 */
      value = 405;	/* --> ushll2.  */
      break;
    case 527:	/* mov */
    case 526:	/* dup */
      value = 526;	/* --> dup.  */
      break;
    case 614:	/* sxtw */
    case 613:	/* sxth */
    case 612:	/* sxtb */
    case 615:	/* asr */
    case 611:	/* sbfx */
    case 610:	/* sbfiz */
    case 609:	/* sbfm */
      value = 609;	/* --> sbfm.  */
      break;
    case 618:	/* bfc */
    case 619:	/* bfxil */
    case 617:	/* bfi */
    case 616:	/* bfm */
      value = 616;	/* --> bfm.  */
      break;
    case 624:	/* uxth */
    case 623:	/* uxtb */
    case 626:	/* lsr */
    case 625:	/* lsl */
    case 622:	/* ubfx */
    case 621:	/* ubfiz */
    case 620:	/* ubfm */
      value = 620;	/* --> ubfm.  */
      break;
    case 644:	/* cset */
    case 643:	/* cinc */
    case 642:	/* csinc */
      value = 642;	/* --> csinc.  */
      break;
    case 647:	/* csetm */
    case 646:	/* cinv */
    case 645:	/* csinv */
      value = 645;	/* --> csinv.  */
      break;
    case 649:	/* cneg */
    case 648:	/* csneg */
      value = 648;	/* --> csneg.  */
      break;
    case 667:	/* rev */
    case 668:	/* rev64 */
      value = 667;	/* --> rev.  */
      break;
    case 675:	/* lsl */
    case 674:	/* lslv */
      value = 674;	/* --> lslv.  */
      break;
    case 677:	/* lsr */
    case 676:	/* lsrv */
      value = 676;	/* --> lsrv.  */
      break;
    case 679:	/* asr */
    case 678:	/* asrv */
      value = 678;	/* --> asrv.  */
      break;
    case 681:	/* ror */
    case 680:	/* rorv */
      value = 680;	/* --> rorv.  */
      break;
    case 691:	/* mul */
    case 690:	/* madd */
      value = 690;	/* --> madd.  */
      break;
    case 693:	/* mneg */
    case 692:	/* msub */
      value = 692;	/* --> msub.  */
      break;
    case 695:	/* smull */
    case 694:	/* smaddl */
      value = 694;	/* --> smaddl.  */
      break;
    case 697:	/* smnegl */
    case 696:	/* smsubl */
      value = 696;	/* --> smsubl.  */
      break;
    case 700:	/* umull */
    case 699:	/* umaddl */
      value = 699;	/* --> umaddl.  */
      break;
    case 702:	/* umnegl */
    case 701:	/* umsubl */
      value = 701;	/* --> umsubl.  */
      break;
    case 713:	/* ror */
    case 712:	/* extr */
      value = 712;	/* --> extr.  */
      break;
    case 920:	/* bic */
    case 919:	/* and */
      value = 919;	/* --> and.  */
      break;
    case 922:	/* mov */
    case 921:	/* orr */
      value = 921;	/* --> orr.  */
      break;
    case 925:	/* tst */
    case 924:	/* ands */
      value = 924;	/* --> ands.  */
      break;
    case 930:	/* uxtw */
    case 929:	/* mov */
    case 928:	/* orr */
      value = 928;	/* --> orr.  */
      break;
    case 932:	/* mvn */
    case 931:	/* orn */
      value = 931;	/* --> orn.  */
      break;
    case 936:	/* tst */
    case 935:	/* ands */
      value = 935;	/* --> ands.  */
      break;
    case 1062:	/* staddb */
    case 966:	/* ldaddb */
      value = 966;	/* --> ldaddb.  */
      break;
    case 1063:	/* staddh */
    case 967:	/* ldaddh */
      value = 967;	/* --> ldaddh.  */
      break;
    case 1064:	/* stadd */
    case 968:	/* ldadd */
      value = 968;	/* --> ldadd.  */
      break;
    case 1065:	/* staddlb */
    case 970:	/* ldaddlb */
      value = 970;	/* --> ldaddlb.  */
      break;
    case 1066:	/* staddlh */
    case 973:	/* ldaddlh */
      value = 973;	/* --> ldaddlh.  */
      break;
    case 1067:	/* staddl */
    case 976:	/* ldaddl */
      value = 976;	/* --> ldaddl.  */
      break;
    case 1068:	/* stclrb */
    case 978:	/* ldclrb */
      value = 978;	/* --> ldclrb.  */
      break;
    case 1069:	/* stclrh */
    case 979:	/* ldclrh */
      value = 979;	/* --> ldclrh.  */
      break;
    case 1070:	/* stclr */
    case 980:	/* ldclr */
      value = 980;	/* --> ldclr.  */
      break;
    case 1071:	/* stclrlb */
    case 982:	/* ldclrlb */
      value = 982;	/* --> ldclrlb.  */
      break;
    case 1072:	/* stclrlh */
    case 985:	/* ldclrlh */
      value = 985;	/* --> ldclrlh.  */
      break;
    case 1073:	/* stclrl */
    case 988:	/* ldclrl */
      value = 988;	/* --> ldclrl.  */
      break;
    case 1074:	/* steorb */
    case 990:	/* ldeorb */
      value = 990;	/* --> ldeorb.  */
      break;
    case 1075:	/* steorh */
    case 991:	/* ldeorh */
      value = 991;	/* --> ldeorh.  */
      break;
    case 1076:	/* steor */
    case 992:	/* ldeor */
      value = 992;	/* --> ldeor.  */
      break;
    case 1077:	/* steorlb */
    case 994:	/* ldeorlb */
      value = 994;	/* --> ldeorlb.  */
      break;
    case 1078:	/* steorlh */
    case 997:	/* ldeorlh */
      value = 997;	/* --> ldeorlh.  */
      break;
    case 1079:	/* steorl */
    case 1000:	/* ldeorl */
      value = 1000;	/* --> ldeorl.  */
      break;
    case 1080:	/* stsetb */
    case 1002:	/* ldsetb */
      value = 1002;	/* --> ldsetb.  */
      break;
    case 1081:	/* stseth */
    case 1003:	/* ldseth */
      value = 1003;	/* --> ldseth.  */
      break;
    case 1082:	/* stset */
    case 1004:	/* ldset */
      value = 1004;	/* --> ldset.  */
      break;
    case 1083:	/* stsetlb */
    case 1006:	/* ldsetlb */
      value = 1006;	/* --> ldsetlb.  */
      break;
    case 1084:	/* stsetlh */
    case 1009:	/* ldsetlh */
      value = 1009;	/* --> ldsetlh.  */
      break;
    case 1085:	/* stsetl */
    case 1012:	/* ldsetl */
      value = 1012;	/* --> ldsetl.  */
      break;
    case 1086:	/* stsmaxb */
    case 1014:	/* ldsmaxb */
      value = 1014;	/* --> ldsmaxb.  */
      break;
    case 1087:	/* stsmaxh */
    case 1015:	/* ldsmaxh */
      value = 1015;	/* --> ldsmaxh.  */
      break;
    case 1088:	/* stsmax */
    case 1016:	/* ldsmax */
      value = 1016;	/* --> ldsmax.  */
      break;
    case 1089:	/* stsmaxlb */
    case 1018:	/* ldsmaxlb */
      value = 1018;	/* --> ldsmaxlb.  */
      break;
    case 1090:	/* stsmaxlh */
    case 1021:	/* ldsmaxlh */
      value = 1021;	/* --> ldsmaxlh.  */
      break;
    case 1091:	/* stsmaxl */
    case 1024:	/* ldsmaxl */
      value = 1024;	/* --> ldsmaxl.  */
      break;
    case 1092:	/* stsminb */
    case 1026:	/* ldsminb */
      value = 1026;	/* --> ldsminb.  */
      break;
    case 1093:	/* stsminh */
    case 1027:	/* ldsminh */
      value = 1027;	/* --> ldsminh.  */
      break;
    case 1094:	/* stsmin */
    case 1028:	/* ldsmin */
      value = 1028;	/* --> ldsmin.  */
      break;
    case 1095:	/* stsminlb */
    case 1030:	/* ldsminlb */
      value = 1030;	/* --> ldsminlb.  */
      break;
    case 1096:	/* stsminlh */
    case 1033:	/* ldsminlh */
      value = 1033;	/* --> ldsminlh.  */
      break;
    case 1097:	/* stsminl */
    case 1036:	/* ldsminl */
      value = 1036;	/* --> ldsminl.  */
      break;
    case 1098:	/* stumaxb */
    case 1038:	/* ldumaxb */
      value = 1038;	/* --> ldumaxb.  */
      break;
    case 1099:	/* stumaxh */
    case 1039:	/* ldumaxh */
      value = 1039;	/* --> ldumaxh.  */
      break;
    case 1100:	/* stumax */
    case 1040:	/* ldumax */
      value = 1040;	/* --> ldumax.  */
      break;
    case 1101:	/* stumaxlb */
    case 1042:	/* ldumaxlb */
      value = 1042;	/* --> ldumaxlb.  */
      break;
    case 1102:	/* stumaxlh */
    case 1045:	/* ldumaxlh */
      value = 1045;	/* --> ldumaxlh.  */
      break;
    case 1103:	/* stumaxl */
    case 1048:	/* ldumaxl */
      value = 1048;	/* --> ldumaxl.  */
      break;
    case 1104:	/* stuminb */
    case 1050:	/* lduminb */
      value = 1050;	/* --> lduminb.  */
      break;
    case 1105:	/* stuminh */
    case 1051:	/* lduminh */
      value = 1051;	/* --> lduminh.  */
      break;
    case 1106:	/* stumin */
    case 1052:	/* ldumin */
      value = 1052;	/* --> ldumin.  */
      break;
    case 1107:	/* stuminlb */
    case 1054:	/* lduminlb */
      value = 1054;	/* --> lduminlb.  */
      break;
    case 1108:	/* stuminlh */
    case 1057:	/* lduminlh */
      value = 1057;	/* --> lduminlh.  */
      break;
    case 1109:	/* stuminl */
    case 1060:	/* lduminl */
      value = 1060;	/* --> lduminl.  */
      break;
    case 1111:	/* mov */
    case 1110:	/* movn */
      value = 1110;	/* --> movn.  */
      break;
    case 1113:	/* mov */
    case 1112:	/* movz */
      value = 1112;	/* --> movz.  */
      break;
    case 1126:	/* psb */
    case 1125:	/* esb */
    case 1124:	/* sevl */
    case 1123:	/* sev */
    case 1122:	/* wfi */
    case 1121:	/* wfe */
    case 1120:	/* yield */
    case 1119:	/* nop */
    case 1118:	/* hint */
      value = 1118;	/* --> hint.  */
      break;
    case 1135:	/* tlbi */
    case 1134:	/* ic */
    case 1133:	/* dc */
    case 1132:	/* at */
    case 1131:	/* sys */
      value = 1131;	/* --> sys.  */
      break;
    case 1881:	/* bic */
    case 1186:	/* and */
      value = 1186;	/* --> and.  */
      break;
    case 1169:	/* mov */
    case 1188:	/* and */
      value = 1188;	/* --> and.  */
      break;
    case 1173:	/* movs */
    case 1189:	/* ands */
      value = 1189;	/* --> ands.  */
      break;
    case 1882:	/* cmple */
    case 1224:	/* cmpge */
      value = 1224;	/* --> cmpge.  */
      break;
    case 1885:	/* cmplt */
    case 1227:	/* cmpgt */
      value = 1227;	/* --> cmpgt.  */
      break;
    case 1883:	/* cmplo */
    case 1229:	/* cmphi */
      value = 1229;	/* --> cmphi.  */
      break;
    case 1884:	/* cmpls */
    case 1232:	/* cmphs */
      value = 1232;	/* --> cmphs.  */
      break;
    case 1166:	/* mov */
    case 1254:	/* cpy */
      value = 1254;	/* --> cpy.  */
      break;
    case 1168:	/* mov */
    case 1255:	/* cpy */
      value = 1255;	/* --> cpy.  */
      break;
    case 1892:	/* fmov */
    case 1171:	/* mov */
    case 1256:	/* cpy */
      value = 1256;	/* --> cpy.  */
      break;
    case 1161:	/* mov */
    case 1268:	/* dup */
      value = 1268;	/* --> dup.  */
      break;
    case 1163:	/* mov */
    case 1160:	/* mov */
    case 1269:	/* dup */
      value = 1269;	/* --> dup.  */
      break;
    case 1891:	/* fmov */
    case 1165:	/* mov */
    case 1270:	/* dup */
      value = 1270;	/* --> dup.  */
      break;
    case 1164:	/* mov */
    case 1271:	/* dupm */
      value = 1271;	/* --> dupm.  */
      break;
    case 1886:	/* eon */
    case 1273:	/* eor */
      value = 1273;	/* --> eor.  */
      break;
    case 1174:	/* not */
    case 1275:	/* eor */
      value = 1275;	/* --> eor.  */
      break;
    case 1175:	/* nots */
    case 1276:	/* eors */
      value = 1276;	/* --> eors.  */
      break;
    case 1887:	/* facle */
    case 1281:	/* facge */
      value = 1281;	/* --> facge.  */
      break;
    case 1888:	/* faclt */
    case 1282:	/* facgt */
      value = 1282;	/* --> facgt.  */
      break;
    case 1889:	/* fcmle */
    case 1291:	/* fcmge */
      value = 1291;	/* --> fcmge.  */
      break;
    case 1890:	/* fcmlt */
    case 1293:	/* fcmgt */
      value = 1293;	/* --> fcmgt.  */
      break;
    case 1158:	/* fmov */
    case 1299:	/* fcpy */
      value = 1299;	/* --> fcpy.  */
      break;
    case 1157:	/* fmov */
    case 1316:	/* fdup */
      value = 1316;	/* --> fdup.  */
      break;
    case 1159:	/* mov */
    case 1614:	/* orr */
      value = 1614;	/* --> orr.  */
      break;
    case 1893:	/* orn */
    case 1615:	/* orr */
      value = 1615;	/* --> orr.  */
      break;
    case 1162:	/* mov */
    case 1617:	/* orr */
      value = 1617;	/* --> orr.  */
      break;
    case 1172:	/* movs */
    case 1618:	/* orrs */
      value = 1618;	/* --> orrs.  */
      break;
    case 1167:	/* mov */
    case 1674:	/* sel */
      value = 1674;	/* --> sel.  */
      break;
    case 1170:	/* mov */
    case 1675:	/* sel */
      value = 1675;	/* --> sel.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 14:
    case 15:
    case 16:
    case 17:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 35:
    case 36:
    case 139:
    case 140:
    case 141:
    case 142:
    case 143:
    case 144:
    case 145:
    case 146:
    case 147:
    case 148:
    case 161:
    case 162:
    case 163:
    case 164:
    case 165:
    case 166:
    case 167:
    case 168:
    case 169:
    case 170:
    case 173:
      return aarch64_ins_regno (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 13:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 18:
      return aarch64_ins_ft (self, info, code, inst);
    case 28:
    case 29:
    case 30:
      return aarch64_ins_reglane (self, info, code, inst);
    case 31:
      return aarch64_ins_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 34:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 37:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 68:
    case 69:
    case 70:
    case 71:
    case 136:
    case 138:
    case 153:
    case 154:
    case 155:
    case 156:
    case 157:
    case 158:
    case 159:
    case 160:
      return aarch64_ins_imm (self, info, code, inst);
    case 38:
    case 39:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 40:
    case 41:
    case 42:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 46:
    case 129:
      return aarch64_ins_fpimm (self, info, code, inst);
    case 60:
    case 134:
      return aarch64_ins_limm (self, info, code, inst);
    case 61:
      return aarch64_ins_aimm (self, info, code, inst);
    case 62:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 63:
      return aarch64_ins_fbits (self, info, code, inst);
    case 65:
    case 66:
      return aarch64_ins_cond (self, info, code, inst);
    case 72:
    case 78:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 73:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 74:
    case 75:
    case 76:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 77:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 79:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 80:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 81:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 82:
    case 83:
    case 84:
    case 85:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 86:
    case 87:
      return aarch64_ins_barrier (self, info, code, inst);
    case 88:
      return aarch64_ins_prfop (self, info, code, inst);
    case 89:
      return aarch64_ins_hint (self, info, code, inst);
    case 90:
    case 91:
    case 92:
    case 93:
      return aarch64_ins_sve_addr_ri_s4xvl (self, info, code, inst);
    case 94:
      return aarch64_ins_sve_addr_ri_s6xvl (self, info, code, inst);
    case 95:
      return aarch64_ins_sve_addr_ri_s9xvl (self, info, code, inst);
    case 96:
    case 97:
    case 98:
    case 99:
      return aarch64_ins_sve_addr_ri_u6 (self, info, code, inst);
    case 100:
    case 101:
    case 102:
    case 103:
    case 104:
    case 105:
    case 106:
    case 107:
    case 108:
    case 109:
    case 110:
    case 111:
      return aarch64_ins_sve_addr_rr_lsl (self, info, code, inst);
    case 112:
    case 113:
    case 114:
    case 115:
    case 116:
    case 117:
    case 118:
    case 119:
      return aarch64_ins_sve_addr_rz_xtw (self, info, code, inst);
    case 120:
    case 121:
    case 122:
    case 123:
      return aarch64_ins_sve_addr_zi_u5 (self, info, code, inst);
    case 124:
      return aarch64_ins_sve_addr_zz_lsl (self, info, code, inst);
    case 125:
      return aarch64_ins_sve_addr_zz_sxtw (self, info, code, inst);
    case 126:
      return aarch64_ins_sve_addr_zz_uxtw (self, info, code, inst);
    case 127:
      return aarch64_ins_sve_aimm (self, info, code, inst);
    case 128:
      return aarch64_ins_sve_asimm (self, info, code, inst);
    case 130:
      return aarch64_ins_sve_float_half_one (self, info, code, inst);
    case 131:
      return aarch64_ins_sve_float_half_two (self, info, code, inst);
    case 132:
      return aarch64_ins_sve_float_zero_one (self, info, code, inst);
    case 133:
      return aarch64_ins_inv_limm (self, info, code, inst);
    case 135:
      return aarch64_ins_sve_limm_mov (self, info, code, inst);
    case 137:
      return aarch64_ins_sve_scale (self, info, code, inst);
    case 149:
    case 150:
      return aarch64_ins_sve_shlimm (self, info, code, inst);
    case 151:
    case 152:
      return aarch64_ins_sve_shrimm (self, info, code, inst);
    case 171:
      return aarch64_ins_sve_index (self, info, code, inst);
    case 172:
    case 174:
      return aarch64_ins_sve_reglist (self, info, code, inst);
    default: assert (0); abort ();
    }
}
