#ifndef DRV_TAPI_STREAM_H
#define DRV_TAPI_STREAM_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_tapi_stream.h
   Contains TAPI functions declaration for fifo, bufferpool.
*/

/* ============================= */
/* Includes                      */
/* ============================= */

/* ============================= */
/* Local definitions             */
/* ============================= */

/* ============================= */
/* Local structures              */
/* ============================= */

/* ============================= */
/* Local variable definition     */
/* ============================= */

/* ============================= */
/* Global variable definition    */
/* ============================= */

/* ============================= */
/* Local function declaration    */
/* ============================= */


/* Used only on TAPI side */
extern IFX_return_t IFX_TAPI_UpStreamFifo_Create(TAPI_CHANNEL* pTapiCh);
extern IFX_return_t IFX_TAPI_UpStreamFifo_Delete(TAPI_CHANNEL* pTapiCh);
extern IFX_void_t * IFX_TAPI_UpStreamFifo_Get(TAPI_CHANNEL* pTapiCh,
                                              IFX_TAPI_STREAM_t nStream,
                                              IFX_uint32_t *pLength,
                                              IFX_uint32_t *pOffset);
#ifdef TAPI_POLL
extern IFX_return_t IFX_TAPI_DownStreamFifo_Create(TAPI_DEV* pTapiDev);
extern IFX_return_t IFX_TAPI_DownStreamFifo_Delete(TAPI_DEV* pTapiDev);
#endif /* TAPI_POLL */

/* global buffer pool for voice packets of all devices of all drivers */
extern IFX_return_t IFX_TAPI_VoiceBufferPool_Create(IFX_void_t);
extern IFX_return_t IFX_TAPI_VoiceBufferPool_Delete(IFX_void_t);
#ifdef TAPI_PACKET_OWNID
extern IFX_void_t   IFX_TAPI_VoiceBufferPoolStatusShow(IFX_void_t);
#endif /* TAPI_PACKET_OWNID */
extern IFX_uint32_t IFX_TAPI_VoiceBufferPool_ElementSizeGet(IFX_void_t);
extern IFX_int32_t  IFX_TAPI_VoiceBufferPool_ElementCountGet(IFX_void_t);
extern IFX_int32_t  IFX_TAPI_VoiceBufferPool_ElementAvailCountGet(IFX_void_t);

#endif /* DRV_TAPI_STREAM_H */
