#ifndef _DRV_VMMC_AUDIO_PRIV_H
#define _DRV_VMMC_AUDIO_PRIV_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_vmmc_audio_priv.h
   This file contains the the defines and structures declarations of the
   Audio module.
*/


/* ============================= */
/* Includes                      */
/* ============================= */
#include "drv_vmmc_fw_commands.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* Global Types                  */
/* ============================= */

/** Internally used audio channel operation modes.
*/
typedef enum
{
   /**  */
   VMMC_IPPHONE_IDLE_MODE    = -1,
   VMMC_IPPHONE_HANDSET_MODE = 0,
   VMMC_IPPHONE_HEADSET_MODE,
   VMMC_IPPHONE_HANDSFREE_MUFFLED_MODE,
   VMMC_IPPHONE_HANDSFREE_NORMAL_MODE,
   VMMC_IPPHONE_HANDSFREE_ECHOIC_MODE,
   VMMC_IPPHONE_HANDSET_OPENLISTENING_MODE,
   VMMC_IPPHONE_HEADSET_OPENLISTENING_MODE,
   VMMC_IPPHONE_HANDSET_WIDEBAND_MODE,
   VMMC_IPPHONE_HEADSET_WIDEBAND_MODE,
   VMMC_IPPHONE_HANDSFREE_WIDEBAND_MUFFLED_MODE,
   VMMC_IPPHONE_HANDSFREE_WIDEBAND_NORMAL_MODE,
   VMMC_IPPHONE_HANDSFREE_WIDEBAND_ECHOIC_MODE,
   VMMC_IPPHONE_HANDSET_WIDEBAND_OPENLISTENING_MODE,
   VMMC_IPPHONE_HEADSET_WIDEBAND_OPENLISTENING_MODE,

   VMMC_IPPHONE_ICVA_HANDSET_MODE,
   VMMC_IPPHONE_ICVA_HEADSET_MODE,
   VMMC_IPPHONE_ICVA_HANDSET_WIDEBAND_MODE,
   VMMC_IPPHONE_ICVA_HEADSET_WIDEBAND_MODE,

   VMMC_IPPHONE_NR_OPMODES
} VMMC_IPPHONE_OPERATION_MODE;

/** Internally used audio volumes.
    The volumes listed in this enumeration are used as column selectors for
    voice and ringing parameter array accesses. */
typedef enum
{
   /**  */
   VMMC_IPPHONE_VOL_UNKNOWN = -1,
   VMMC_IPPHONE_VOL1 = 0,
   VMMC_IPPHONE_VOL2,
   VMMC_IPPHONE_VOL3,
   VMMC_IPPHONE_VOL4,
   VMMC_IPPHONE_VOL5,
   VMMC_IPPHONE_VOL6,
   VMMC_IPPHONE_VOL7,
   VMMC_IPPHONE_VOL8,
   VMMC_IPPHONE_NR_VOL_LEVELS  /* used in for loops that process volume info */
} VMMC_IPPHONE_VOLUME_LEVEL;

/** Internally used mute state. */
typedef enum
{
   /**  */
   VMMC_IPPHONE_MUTE_UNKNOWN = -1,
   VMMC_IPPHONE_UNMUTED,
   VMMC_IPPHONE_MUTED
} VMMC_IPPHONE_MUTE_STATE;

/** Internally used handsfree room type. */
typedef enum
{
   VMMC_IPPHONE_NORMAL_ROOM  = 0,
   VMMC_IPPHONE_MUFFLED_ROOM = 1,
   VMMC_IPPHONE_ECHOIC_ROOM  = 2
} VMMC_IPPHONE_HF_ROOM_TYPE;

/** Operating Mode Configuration Parameters.
    List of FW messages used for audio operation mode configuration.*/
typedef struct
{
   RES_EQU_IIR_COEF_t    equ1_iir;
   RES_EQU_FIR_COEF_t    equ1_fir;
   RES_EQU_IIR_COEF_t    equ2_iir;
   RES_EQU_FIR_COEF_t    equ2_fir;
   RES_EQU_IIR_COEF_t    equ3_iir;
   RES_EQU_FIR_COEF_t    equ3_fir;
   RES_EQU_IIR_COEF_t    equ4_iir;
   RES_EQU_FIR_COEF_t    equ4_fir;
   RES_AGC_COEF_t        agc1;
   RES_AGC_COEF_t        agc2;
   RES_SPK_HDX_COEF_t    spk_hdk;
   RES_SPK_AGCX_COEF_t   spk_agcx;
   AUDIO_SPK_AGCR_COEF_t spk_agcr;
   RES_SPK_FDX_COEF_t    spk_fdx;
   RES_SPK_WF_COEF_t     spk_wf;
   RES_SPK_NR_COEF_t     spk_nr;
   /* */
   RES_SPK_NLP_COEF_t    spk_nlp;
   RES_HEC_COEF_t        spk_hec;
   /* audio channel command */
   AUDIO_CHAN_t          ad_chan;
   /* ring amplitude */
   AUDIO_SPK_CTRL_t      ad_spk;
} VMMC_OperatingModeCfg_t;


/** Defines for FW message positions within a voice parameter set
    (-> VMMC_OperatingModeCfg_t) */
#define EQU1_IIR_POS    0x00000001
#define EQU1_FIR_POS    0x00000002
#define EQU2_IIR_POS    0x00000004
#define EQU2_FIR_POS    0x00000008
#define EQU3_IIR_POS    0x00000010
#define EQU3_FIR_POS    0x00000020
#define EQU4_IIR_POS    0x00000040
#define EQU4_FIR_POS    0x00000080
#define AGC1_POS        0x00000100
#define AGC2_POS        0x00000200
#define SPK_HDK_POS     0x00000400
#define AGCX_POS        0x00000800
#define AGCR_POS        0x00001000
#define FDX_POS         0x00002000
#define WF_POS          0x00004000
#define NR_POS          0x00008000
#define NLP_POS         0x00010000
#define HEC_POS         0x00020000
#define ACHAN_POS       0x00040000
#define ASPK_POS        0x00080000


/** Voice Parameter set. */
typedef struct
{
   /* msg to send for operation mode change control word  */
   IFX_uint32_t            valid;
   /* msg to send for volume change control word  */
   IFX_uint32_t            volume_level_change;
   /* voice parameters */
   VMMC_OperatingModeCfg_t params;
} VMMC_OpModeCtrl_t;


/** Voice Parameter Array.
    For voice parameter access the operation mode (VMMC_IPPHONE_OPERATION_MODE)
    and volume levels (VMMC_IPPHONE_VOLUME_LEVEL) have to  be used as row
    resp. column index.
    Since idle parameters are not volume dependent VMMC_IPPHONE_IDLE_MODE
    is located seperate from the active mode parameters  */
typedef struct
{
   VMMC_OpModeCtrl_t    idle_params;
   VMMC_OpModeCtrl_t    opmode_params[VMMC_IPPHONE_NR_OPMODES][VMMC_IPPHONE_NR_VOL_LEVELS];
} VMMC_OpModeParamSet_t;


/** Ringing Parameter Set */
typedef struct
{
   /** utg coefficients command */
   RES_UTG_COEF_t        utg_coeff;
   /** audio channel command */
   AUDIO_CHAN_t          ad_chan;
   /** utg control command*/
   AUDIO_UTG_CTRL_t      ad_utg;
} VMMC_RingVolCfg_t;


/** Ringing Parameter Array */
typedef struct
{
   VMMC_RingVolCfg_t    ring_params[VMMC_IPPHONE_NR_VOL_LEVELS];
} VMMC_RingParamSet_t;


/** Structure for the coder channel including firmware message cache */
struct VMMC_AUDIOCH
{
   /* pointer to array of voice parameter sets */
   VMMC_OpModeParamSet_t       *param_set_ptr;
   /* current voice volume */
   VMMC_IPPHONE_VOLUME_LEVEL   current_vol;
   /* current operation mode */
   VMMC_IPPHONE_OPERATION_MODE current_opmode;
   /* current mute state */
   VMMC_IPPHONE_MUTE_STATE     current_mute_state;
   /* current handsfree room type */
   VMMC_IPPHONE_HF_ROOM_TYPE   current_hf_room_type;
   /* current handsfree microphone input */
   IFX_uint8_t  nHFMic;
   /* current handsfree output */
   IFX_uint8_t  nHFOut;
   /* current handset microphone input */
   IFX_uint8_t  nHNMic;
   /* current handset output */
   IFX_uint8_t  nHNOut;
   /* current headset microphone input */
   IFX_uint8_t  nHDMic;
   /* current headset output */
   IFX_uint8_t  nHDOut;
   /* active call flag */
   IFX_boolean_t               call_active;
   /* pointer to ring parameter array */
   VMMC_RingParamSet_t         *ring_param_ptr;
   /* current ringing volume */
   VMMC_IPPHONE_VOLUME_LEVEL   current_ring_vol;
   /* active ringing mode identifier */
   IFX_boolean_t               ringing_active;
   /* tone table index for audio ringing */
   IFX_uint8_t                 ring_table_index;
   /* active In Call Announcement/Off Hook Voice Announcement flag */
   IFX_boolean_t               ica_active;
   /* cache for audio channel control message */
   AUDIO_CHAN_t                audio_ch;
   /* cache for audio channel misc. control message */
   AUDIO_MISC_CTRL_t           audio_misc;
};

/* ============================= */
/* Global Variables              */
/* ============================= */

/* ============================= */
/* Global function declaration   */
/* ============================= */

#endif /* _DRV_VMMC_AUDIO_PRIV_H */
