#ifndef _DRV_VMMC_BBD_H
#define _DRV_VMMC_BBD_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************
   Module      : drv_vmmc_bbd.h
   Description :
*******************************************************************************/

/* ============================= */
/* Includes                      */
/* ============================= */

#include "lib_bbd.h"
#include "drv_mps_vmmc.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* VMMC firmware download structure */
typedef struct
{
   /* user download flag
      - VMMC_IO_BBD
      - VMMC_IO_PRAM
      - VMMC_IO_DRAM
      - VMMC_IO_AC
      - VMMC_IO_CRAM
   */
   IFX_uint8_t         nIODwld;
   /* BBD data format, with blocks to download */
   bbd_format_t         bbdDwld;
   /* EDSP firmware download */
   mps_fw               fwDwld;
   /* AC download in BBD format */
   bbd_format_t         acDwld;
   /* CRAM download in BBD format */
   bbd_block_t          cramBlock;
   /* Ring Config block in BBD format */
   bbd_block_t          ringCfgBlock;
   /* DC Threshold block in BBD format */
   bbd_block_t          dcThrBlock;
} VMMC_DOWNLOAD;


/* ============================= */
/* Global Structures             */
/* ============================= */


/* ============================= */
/* Global function declaration   */
/* ============================= */

extern IFX_int32_t VMMC_TAPI_LL_BBD_Dnld(IFX_TAPI_LL_DEV_t *pLLDev,
                                         IFX_void_t const *pProc);

extern IFX_int32_t VMMC_BBD_Download(VMMC_CHANNEL *pCh, bbd_format_t *pBBD);
#endif /* _DRV_VMMC_BBD_H */
