#ifndef _DRV_MPS_VMMC_DEVICE_H
#define _DRV_MPS_VMMC_DEVICE_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

****************************************************************************
   Module      : drv_mps_vmmc_device.h
   Description : This file contains the defines, the structures declarations
                 the tables declarations and the device specific functions
                 declarations.
*******************************************************************************/

#include <asm/ifx/ifx_regs.h>
#include <asm/ifx_vpe.h>

/* ============================= */
/* MPS Common defines            */
/* ============================= */

#define MPS_BASEADDRESS 0xBF107000
#define MPS_RAD0SR      MPS_BASEADDRESS + 0x0004

#define MPS_RAD0SR_DU   (1<<0)
#define MPS_RAD0SR_CU   (1<<1)

#define MBX_BASEADDRESS 0xBF200000
#define VCPU_BASEADDRESS 0xBF208000     /* 0xBF108000 */
/*---------------------------------------------------------------------------*/
#if defined(SYSTEM_AR9) || defined(SYSTEM_VR9)
/* TODO: doublecheck - IM4 or different! */
#define MPS_INTERRUPTS_ENABLE(X)  *((volatile IFX_uint32_t*) IFX_ICU_IM4_IER) |= X;
#define MPS_INTERRUPTS_DISABLE(X) *((volatile IFX_uint32_t*) IFX_ICU_IM4_IER) &= ~X;
#define MPS_INTERRUPTS_CLEAR(X)   *((volatile IFX_uint32_t*) IFX_ICU_IM4_ISR) = X;
#define MPS_INTERRUPTS_SET(X)     *((volatile IFX_uint32_t*) IFX_ICU_IM4_IRSR) = X;/* |= ? */
#else /* Danube */
/* TODO: possibly needs to be changed to IM4 !!!!!! */
#ifdef LINUX_2_6
#define MPS_INTERRUPTS_ENABLE(X)  *((volatile IFX_uint32_t*) IFX_ICU_IM4_IER) |= X;
#define MPS_INTERRUPTS_DISABLE(X) *((volatile IFX_uint32_t*) IFX_ICU_IM4_IER) &= ~X;
#define MPS_INTERRUPTS_CLEAR(X)   *((volatile IFX_uint32_t*) IFX_ICU_IM4_ISR) = X;
#define MPS_INTERRUPTS_SET(X)     *((volatile IFX_uint32_t*) IFX_ICU_IM4_IRSR) = X;/* |= ? */
#else /* */
#define MPS_INTERRUPTS_ENABLE(X)  *((volatile IFX_uint32_t*) DANUBE_ICU_IM5_IER) |= X;
#define MPS_INTERRUPTS_DISABLE(X) *((volatile IFX_uint32_t*) DANUBE_ICU_IM5_IER) &= ~X;
#define MPS_INTERRUPTS_CLEAR(X)   *((volatile IFX_uint32_t*) DANUBE_ICU_IM5_ISR) = X;
#define MPS_INTERRUPTS_SET(X)     *((volatile IFX_uint32_t*) DANUBE_ICU_IM5_IRSR) = X;/* |= ? */
#endif /* LINUX_2_6 */
#endif /* SYSTEM_AR9 || SYSTEM_VR9 */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Interrupt register values for ICU                                         */
/*---------------------------------------------------------------------------*/
#define DANUBE_MPS_VC0_IR0 (1 << 0)     /* Voice channel 0 */
#define DANUBE_MPS_VC1_IR1 (1 << 1)     /* Voice channel 1 */
#define DANUBE_MPS_VC2_IR2 (1 << 2)     /* Voice channel 2 */
#define DANUBE_MPS_VC3_IR3 (1 << 3)     /* Voice channel 3 */
#define DANUBE_MPS_AD0_IR4 (1 << 4)     /* AFE/DFE Status 0 */
#define DANUBE_MPS_AD1_IR5 (1 << 5)     /* AFE/DFE Status 1 */
#define DANUBE_MPS_VC_AD_ALL_IR6 (1 << 6)       /* ored VC and AD interrupts */
#define DANUBE_MPS_SEM_IR7 (1 << 7)     /* Semaphore Interrupt */
#define DANUBE_MPS_GLB_IR8 (1 << 8)     /* Global Interrupt */

/*---------------------------------------------------------------------------*/
/* Mailbox definitions                                                       */
/*---------------------------------------------------------------------------*/

#ifdef CONFIG_MPS_EVENT_MBX

#define MBX_CMD_FIFO_SIZE  64 /**< Size of command FIFO in bytes */
#define MBX_DATA_UPSTRM_FIFO_SIZE 64
#define MBX_DATA_DNSTRM_FIFO_SIZE 128
#define MBX_EVENT_FIFO_SIZE 32
#define MBX_DEFINITION_AREA_SIZE 32
#define MBX_RW_POINTER_AREA_SIZE 32
#define MBX_EVENT_POINTER_AREA_SIZE 16

/* base addresses for command and voice mailboxes (upstream and downstream ) */
#define MBX_UPSTRM_CMD_FIFO_BASE   (MBX_BASEADDRESS + MBX_DEFINITION_AREA_SIZE + MBX_RW_POINTER_AREA_SIZE)
#define MBX_DNSTRM_CMD_FIFO_BASE   (MBX_UPSTRM_CMD_FIFO_BASE + MBX_CMD_FIFO_SIZE)
#define MBX_UPSTRM_DATA_FIFO_BASE  (MBX_DNSTRM_CMD_FIFO_BASE + MBX_CMD_FIFO_SIZE)
#define MBX_DNSTRM_DATA_FIFO_BASE  (MBX_UPSTRM_DATA_FIFO_BASE + MBX_DATA_UPSTRM_FIFO_SIZE)
#define MBX_UPSTRM_EVENT_FIFO_BASE (MBX_DNSTRM_DATA_FIFO_BASE + MBX_DATA_DNSTRM_FIFO_SIZE + MBX_EVENT_POINTER_AREA_SIZE)

#define MBX_DATA_WORDS 80
#define MBX_EVENT_DATA_WORDS 8

#define NUM_VOICE_CHANNEL     9 /**< nr of voice channels  */
#define NR_CMD_MAILBOXES      2 /**< nr of command mailboxes  */

#define MAX_UPSTRM_DATAWORDS   15
#define MAX_FIFO_WRITE_RETRIES 80

#else /* CONFIG_MPS_EVENT_MBX */

#define MBX_CMD_FIFO_SIZE  64 /**< Size of command FIFO in bytes */
#define MBX_DATA_UPSTRM_FIFO_SIZE 128
#define MBX_DATA_DNSTRM_FIFO_SIZE 128
#define MBX_DEFINITION_AREA_SIZE 32
#define MBX_RW_POINTER_AREA_SIZE 32

/* base addresses for command and voice mailboxes (upstream and downstream ) */
#define MBX_UPSTRM_CMD_FIFO_BASE   (MBX_BASEADDRESS + MBX_DEFINITION_AREA_SIZE + MBX_RW_POINTER_AREA_SIZE)
#define MBX_DNSTRM_CMD_FIFO_BASE   (MBX_UPSTRM_CMD_FIFO_BASE + MBX_CMD_FIFO_SIZE)
#define MBX_UPSTRM_DATA_FIFO_BASE  (MBX_DNSTRM_CMD_FIFO_BASE + MBX_CMD_FIFO_SIZE)
#define MBX_DNSTRM_DATA_FIFO_BASE  (MBX_UPSTRM_DATA_FIFO_BASE + MBX_DATA_UPSTRM_FIFO_SIZE)

#define MBX_DATA_WORDS 96

#define NUM_VOICE_CHANNEL     9 /**< nr of voice channels +1 */
#define NR_CMD_MAILBOXES      2 /**< nr of command mailboxes  */

#define MAX_UPSTRM_DATAWORDS 30
#define MAX_FIFO_WRITE_RETRIES 80

#endif /* CONFIG_MPS_EVENT_MBX */

/*---------------------------------------------------------------------------*/
/* MPS buffer provision management structure definitions                   */
/*---------------------------------------------------------------------------*/

#define MPS_BUFFER_INITIAL                 36
#define MPS_BUFFER_THRESHOLD               24

#define MPS_DEFAULT_PROVISION_SEGMENTS_PER_MSG 12

#define MPS_MAX_PROVISION_SEGMENTS_PER_MSG 60
#define MPS_BUFFER_MAX_LEVEL               64

#define MPS_MEM_SEG_DATASIZE 512
#define MAX_MEM_SEG_DATASIZE 4095

/*---------------------------------------------------------------------------*/
/* DEVICE DEPENDENCIES                                                       */
/*---------------------------------------------------------------------------*/
#if defined(SYSTEM_AR9) || defined(SYSTEM_VR9)
/* ***** Amazon-S specific defines ***** */
#define IFX_MPS_Base      AMAZON_S_MPS

//#define IFX_MPS_CHIPID              AMAZON_S_MPS_CHIPID
//#define IFX_MPS_CHIPID_VERSION_GET  AMAZON_S_MPS_CHIPID_VERSION_GET

//#define IFX_MPS_AD0ENR    AMAZON_S_MPS_AD0ENR
//#define IFX_MPS_AD1ENR    AMAZON_S_MPS_AD1ENR
//#define IFX_MPS_VC0ENR    AMAZON_S_MPS_VC0ENR
//#define IFX_MPS_SAD0SR    AMAZON_S_MPS_SAD0SR
//#define IFX_MPS_RAD0SR    AMAZON_S_MPS_RAD0SR
//#define IFX_MPS_CAD0SR    AMAZON_S_MPS_CAD0SR
//#define IFX_MPS_RAD1SR    AMAZON_S_MPS_RAD1SR
//#define IFX_MPS_CAD1SR    AMAZON_S_MPS_CAD1SR
//#define IFX_MPS_RVC0SR    AMAZON_S_MPS_RVC0SR
//#define IFX_MPS_CVC0SR    AMAZON_S_MPS_CVC0SR
//#define IFX_MPS_CVC1SR    AMAZON_S_MPS_CVC1SR
//#define IFX_MPS_CVC2SR    AMAZON_S_MPS_CVC2SR
//#define IFX_MPS_CVC3SR    AMAZON_S_MPS_CVC3SR

//#define IFX_MPS_SRAM      AMAZON_S_MPS_SRAM
#else /* */
/* ***** DANUBE specific defines ***** */
#define IFX_MPS_Base      DANUBE_MPS

//#define IFX_MPS_CHIPID    DANUBE_MPS_CHIPID
//#define IFX_MPS_CHIPID_VERSION_GET  DANUBE_MPS_CHIPID_VERSION_GET
//#define IFX_MPS_CHIPID_VERSION_SET  DANUBE_MPS_CHIPID_VERSION_SET
//#define IFX_MPS_CHIPID_PARTNUM_GET  DANUBE_MPS_CHIPID_PARTNUM_GET
//#define IFX_MPS_CHIPID_PARTNUM_SET  DANUBE_MPS_CHIPID_PARTNUM_SET
//#define IFX_MPS_CHIPID_MANID_GET    DANUBE_MPS_CHIPID_MANID_GET
//#define IFX_MPS_CHIPID_MANID_SET    DANUBE_MPS_CHIPID_MANID_SET
//#define IFX_MPS_SUBVER              DANUBE_MPS_SUBVER

//#define IFX_MPS_AD0ENR    DANUBE_MPS_AD0ENR
//#define IFX_MPS_AD1ENR    DANUBE_MPS_AD1ENR
//#define IFX_MPS_VC0ENR    DANUBE_MPS_VC0ENR
//#define IFX_MPS_SAD0SR    DANUBE_MPS_SAD0SR
//#define IFX_MPS_RAD0SR    DANUBE_MPS_RAD0SR
//#define IFX_MPS_CAD0SR    DANUBE_MPS_CAD0SR
//#define IFX_MPS_RAD1SR    DANUBE_MPS_RAD1SR
//#define IFX_MPS_CAD1SR    DANUBE_MPS_CAD1SR
//#define IFX_MPS_RVC0SR    DANUBE_MPS_RVC0SR
//#define IFX_MPS_CVC0SR    DANUBE_MPS_CVC0SR
//#define IFX_MPS_CVC1SR    DANUBE_MPS_CVC1SR
//#define IFX_MPS_CVC2SR    DANUBE_MPS_CVC2SR
//#define IFX_MPS_CVC3SR    DANUBE_MPS_CVC3SR

//#define IFX_MPS_SRAM      DANUBE_MPS_SRAM
#endif /* SYSTEM_AR9 || SYSTEM_VR9 */
typedef enum
{
   MPS_BUF_UNINITIALIZED,
   MPS_BUF_EMPTY,
   MPS_BUF_LOW,
   MPS_BUF_OK,
   MPS_BUF_OV,
   MPS_BUF_ERR
} mps_buffer_state_e;

typedef struct /**< mps buffer monitoring structure */
{
   IFX_int32_t buf_level;                  /**< Current bufffer level */
   IFX_uint32_t buf_threshold;              /**< Minimum buffer count */
   IFX_uint32_t buf_initial;                /**< Initial buffer count */
   IFX_uint32_t buf_size;                   /**< Buffer size for voice cpu */
   mps_buffer_state_e buf_state;
   IFX_void_t *(*malloc) (IFX_size_t size, IFX_int32_t priority); /**< Buffer alloc function (def. kmalloc) */
   IFX_void_t (*free) (const IFX_void_t *ptr);  /**< Buffer free  function (def. kfree) */
   IFX_int32_t (*init) (IFX_void_t); /** Manager init function */
   IFX_int32_t (*close) (IFX_void_t); /** Manager shutdown function */
} mps_buf_mng_t;

typedef IFX_uint32_t *mem_seg_t[MPS_MAX_PROVISION_SEGMENTS_PER_MSG];

/*---------------------------------------------------------------------------*/
/* Register structure definitions                                            */
/*---------------------------------------------------------------------------*/
typedef enum
{
   COMMAND = 1,
   VOICE
} MbxMessageType_e;

typedef enum
{
   UPSTREAM,
   DOWNSTREAM
} MbxDirection_e;

typedef struct
{
   IFX_uint32_t rw:1;
   IFX_uint32_t res1:2;
   IFX_uint32_t type:5;
   IFX_uint32_t res2:4;
   IFX_uint32_t chan:4;
   IFX_uint32_t res3:1;
   IFX_uint32_t odd:2;
   IFX_uint32_t res4:5;
   IFX_uint32_t plength:8;
} MbxMsgHd_s;

typedef union
{
   IFX_uint32_t val;
   MbxMsgHd_s hd;
} MbxMsgHd_u;

typedef struct
{
   MbxMsgHd_u header;
   IFX_uint32_t data[MAX_UPSTRM_DATAWORDS];
} MbxMsg_s;

/*---------------------------------------------------------------------------*/
/* FIFO structure                                                            */
/*---------------------------------------------------------------------------*/
typedef struct
{
   volatile IFX_uint32_t *volatile pstart;     /**< Pointer to FIFO's read/write start address */
   volatile IFX_uint32_t *volatile  pend;       /**< Pointer to FIFO's read/write end address */
   volatile IFX_uint32_t *volatile pwrite_off; /**< Pointer to FIFO's write index location */
   volatile IFX_uint32_t *volatile pread_off;  /**< Pointer to FIFO's read index location */
   volatile IFX_uint32_t size;        /**< FIFO size */
   volatile IFX_uint32_t min_space;   /**< FIFO size */
   volatile IFX_uint32_t bytes;
   volatile IFX_uint32_t pkts;
   volatile IFX_uint32_t discards;
} mps_fifo;

typedef struct
{
   volatile IFX_uint32_t MPS_BOOT_RVEC;    /**< CPU reset vector */
   volatile IFX_uint32_t MPS_BOOT_NVEC;    /**<  */
   volatile IFX_uint32_t MPS_BOOT_EVEC;    /**<  */
   volatile IFX_uint32_t MPS_CP0_STATUS;   /**<  */
   volatile IFX_uint32_t MPS_CP0_EEPC;     /**<  */
   volatile IFX_uint32_t MPS_CP0_EPC;      /**<  */
   volatile IFX_uint32_t MPS_BOOT_SIZE;    /**<  */
   volatile IFX_uint32_t MPS_CFG_STAT;     /**<  */
} mps_boot_cfg_reg;

/*
 * This structure represents the MPS mailbox definition area that is shared
 * by CCPU and VCPU. It comprises the mailboxes' base addresses and sizes in bytes as well as the
 *
 *
 */
#ifdef CONFIG_MPS_EVENT_MBX
typedef struct
{
   volatile IFX_uint32_t *MBX_UPSTR_CMD_BASE;  /**< Upstream Command FIFO Base Address */
   volatile IFX_uint32_t MBX_UPSTR_CMD_SIZE;   /**< Upstream Command FIFO size in byte */
   volatile IFX_uint32_t *MBX_DNSTR_CMD_BASE;  /**< Downstream Command FIFO Base Address */
   volatile IFX_uint32_t MBX_DNSTR_CMD_SIZE;   /**< Downstream Command FIFO size in byte */
   volatile IFX_uint32_t *MBX_UPSTR_DATA_BASE; /**< Upstream Data FIFO Base Address */
   volatile IFX_uint32_t MBX_UPSTR_DATA_SIZE;  /**< Upstream Data FIFO size in byte */
   volatile IFX_uint32_t *MBX_DNSTR_DATA_BASE; /**< Downstream Data FIFO Base Address */
   volatile IFX_uint32_t MBX_DNSTR_DATA_SIZE;  /**< Downstream Data FIFO size in byte */
   volatile IFX_uint32_t MBX_UPSTR_CMD_READ;   /**< Upstream Command FIFO Read Index */
   volatile IFX_uint32_t MBX_UPSTR_CMD_WRITE;  /**< Upstream Command FIFO Write Index */
   volatile IFX_uint32_t MBX_DNSTR_CMD_READ;   /**< Downstream Command FIFO Read Index */
   volatile IFX_uint32_t MBX_DNSTR_CMD_WRITE;  /**< Downstream Command FIFO Write Index */
   volatile IFX_uint32_t MBX_UPSTR_DATA_READ;   /**< Upstream Data FIFO Read Index */
   volatile IFX_uint32_t MBX_UPSTR_DATA_WRITE;  /**< Upstream Data FIFO Write Index */
   volatile IFX_uint32_t MBX_DNSTR_DATA_READ;   /**< Downstream Data FIFO Read Index */
   volatile IFX_uint32_t MBX_DNSTR_DATA_WRITE;  /**< Downstream Data FIFO Write Index */
   volatile IFX_uint32_t MBX_DATA[MBX_DATA_WORDS];
   volatile IFX_uint32_t *MBX_UPSTR_EVENT_BASE; /**< Upstream Event FIFO Base Address */
   volatile IFX_uint32_t MBX_UPSTR_EVENT_SIZE;  /**< Upstream Event FIFO size in byte */
   volatile IFX_uint32_t MBX_UPSTR_EVENT_READ;  /**< Upstream Event FIFO Read Index */
   volatile IFX_uint32_t MBX_UPSTR_EVENT_WRITE; /**< Upstream Event FIFO Write Index */
   volatile IFX_uint32_t MBX_EVENT[MBX_EVENT_DATA_WORDS];
   volatile IFX_uint32_t reserved[4];
   mps_boot_cfg_reg MBX_CPU0_BOOT_CFG; /**< CPU0 Boot Configuration */
   mps_boot_cfg_reg MBX_CPU1_BOOT_CFG; /**< CPU1 Boot Configuration */
} mps_mbx_reg;

#else /* */
typedef struct
{
   volatile IFX_uint32_t *MBX_UPSTR_CMD_BASE;  /**< Upstream Command FIFO Base Address */
   volatile IFX_uint32_t MBX_UPSTR_CMD_SIZE;   /**< Upstream Command FIFO size in byte */
   volatile IFX_uint32_t *MBX_DNSTR_CMD_BASE;  /**< Downstream Command FIFO Base Address */
   volatile IFX_uint32_t MBX_DNSTR_CMD_SIZE;   /**< Downstream Command FIFO size in byte */
   volatile IFX_uint32_t *MBX_UPSTR_DATA_BASE; /**< Upstream Data FIFO Base Address */
   volatile IFX_uint32_t MBX_UPSTR_DATA_SIZE;  /**< Upstream Data FIFO size in byte */
   volatile IFX_uint32_t *MBX_DNSTR_DATA_BASE; /**< Downstream Data FIFO Base Address */
   volatile IFX_uint32_t MBX_DNSTR_DATA_SIZE;  /**< Downstream Data FIFO size in byte */
   volatile IFX_uint32_t MBX_UPSTR_CMD_READ;   /**< Upstream Command FIFO Read Index */
   volatile IFX_uint32_t MBX_UPSTR_CMD_WRITE;  /**< Upstream Command FIFO Write Index */
   volatile IFX_uint32_t MBX_DNSTR_CMD_READ;   /**< Downstream Command FIFO Read Index */
   volatile IFX_uint32_t MBX_DNSTR_CMD_WRITE;  /**< Downstream Command FIFO Write Index */
   volatile IFX_uint32_t MBX_UPSTR_DATA_READ;   /**< Upstream Data FIFO Read Index */
   volatile IFX_uint32_t MBX_UPSTR_DATA_WRITE;  /**< Upstream Data FIFO Write Index */
   volatile IFX_uint32_t MBX_DNSTR_DATA_READ;   /**< Downstream Data FIFO Read Index */
   volatile IFX_uint32_t MBX_DNSTR_DATA_WRITE;  /**< Downstream Data FIFO Write Index */
   volatile IFX_uint32_t MBX_DATA[MBX_DATA_WORDS];
   mps_boot_cfg_reg MBX_CPU0_BOOT_CFG; /**< CPU0 Boot Configuration */
   mps_boot_cfg_reg MBX_CPU1_BOOT_CFG; /**< CPU1 Boot Configuration */
} mps_mbx_reg;
#endif /* CONFIG_MPS_EVENT_MBX */

/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Device connection structure                                               */
/*---------------------------------------------------------------------------*/

/**
 * Mailbox Device Structure.
 * This Structure holds top level parameters of the mailboxes used to allow
 * the communication between the control CPU and the Voice CPU
 */
typedef struct
{
   /* void pointer to the base device driver structure */
   IFX_void_t *pVCPU_DEV;

   /* Mutex semaphore to access the device */
   IFXOS_lock_t *sem_dev;

   /* Mutex semaphore to access the device */
   IFXOS_lock_t *sem_read_fifo;

   /* Wakeuplist for the select mechanism */
   IFXOS_drvSelectQueue_t mps_wakeuplist;

   /* Base Address of the Global Register Access */
   mps_mbx_reg *base_global;
   mps_fifo *upstrm_fifo;    /**< Data exchange FIFO for read (upstream) */
   mps_fifo *dwstrm_fifo;    /**< Data exchange FIFO for write (downstream) */

#ifdef MPS_FIFO_BLOCKING_WRITE
   IFXOS_lock_t *sem_write_fifo;
   volatile IFX_boolean_t full_write_fifo;

   /* variable if the driver should block on write to the transmit FIFO */
   IFX_boolean_t bBlockWriteMB;
#endif                          /* MPS_FIFO_BLOCKING_WRITE */

   mps_devices devID;   /**< Device ID  1->command
                                        2->voice chan 0
                                        3->voice chan 1
                                        4->voice chan 2
                                        5->voice chan 3
                                        6->event  */
   volatile IFX_int32_t Installed;
               IFX_void_t (*down_callback) (mps_devices type);
               IFX_void_t (*up_callback) (mps_devices type);
   MbxEventRegs_s event_mask;
   MbxEventRegs_s callback_event_mask;
                  IFX_void_t (*event_callback) (MbxEventRegs_s * events);

#ifdef CONFIG_MPS_EVENT_MBX
   IFX_uint32_t event_callback_handle;
                IFX_void_t (*event_mbx_callback) (IFX_uint32_t
                                                  event_callback_handle,
                                                  mps_event_msg * msg);
#endif                          /* */
} mps_mbx_dev;

/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Device structure                                                          */
/*---------------------------------------------------------------------------*/

/**
 * Mailbox Device Structure.
 * This Structure represents the communication device that provides the resources
 * for the communication between CPU0 and CPU1
 */
typedef struct
{
   mps_mbx_reg *base_global;   /**< global register pointer for the ISR */
   IFX_uint32_t flags;                   /**< Pointer to private date of the specific handler */
   mps_mbx_dev voice_mb[NUM_VOICE_CHANNEL];     /**< Data upstream and downstream mailboxes */
   mps_mbx_dev command_mb;                      /**< Command upstream and downstream mailbox */
   MbxEventRegs_s event;  /**< global structure holding the interrupt status */
   mps_fifo cmd_upstrm_fifo;
   mps_fifo cmd_dwstrm_fifo;
   mps_fifo voice_upstrm_fifo;
   mps_fifo voice_dwstrm_fifo;
   mps_fifo sw_upstrm_fifo[NUM_VOICE_CHANNEL];
   IFXOS_lock_t *provide_buffer;

#ifdef CONFIG_MPS_EVENT_MBX
   mps_mbx_dev event_mbx;         /**< Event upstream mailbox */
   mps_fifo event_upstrm_fifo;    /**< Mailbox FIFO structure */
   mps_fifo sw_event_upstrm_fifo; /** Software FIFO used for user space access */
#endif                          /* */
} mps_comm_dev;

/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* VoIP firmware CRC-32 checksum calculation                                 */
/*---------------------------------------------------------------------------*/
/* VoIP firmware image footer format */
typedef struct
{
   /* CRC-32 checksum */
   IFX_uint32_t crc32;
   /* start address for CRC32 checksum calculation */
   IFX_uint32_t st_addr_crc;
   /* end address for CRC32 checksum calculation */
   IFX_uint32_t en_addr_crc;
   /* firmware version */
   IFX_uint32_t fw_vers;
   /* plain/encrypted: 0-plain, 1-encrypted */
   IFX_uint32_t enc;
   /* magic word 0xCC123456 */
   IFX_uint32_t magic;
   /* firmware memory requirement */
   IFX_uint32_t mem;
} FW_image_ftr_t;
extern FW_image_ftr_t *pFW_img_data;
#define FW_MAGIC_NUM 0xcc123456
#define FW_FORMAT_NEW (pFW_img_data->magic==FW_MAGIC_NUM)
#define FW_AR9_OLD_FMT_XCPT_AREA_SZ 28
#define FW_DANUBE_OLD_FMT_XCPT_AREA_SZ 20
#define FW_XCPT_AREA_OFFSET 8
#define FW_PLT_INCA_IP2 0
#define FW_PLT_DANUBE   1
#define FW_PLT_ARX      4
#define FW_PLT_VRX      7
/*---------------------------------------------------------------------------*/
IFX_int32_t ifx_mps_common_open (mps_comm_dev * pDev, mps_mbx_dev * pMBDev,
                                 IFX_int32_t bcommand,
                                 IFX_boolean_t from_kernel);
IFX_int32_t ifx_mps_common_close (mps_mbx_dev * pMBDev,
                                  IFX_boolean_t from_kernel);
IFX_int32_t ifx_mps_mbx_read (mps_mbx_dev * pMBDev, mps_message * pPkg,
                              IFX_int32_t timeout);
IFX_int32_t ifx_mps_mbx_write_cmd (mps_mbx_dev * pMBDev,
                                   mps_message * readWrite);
IFX_int32_t ifx_mps_mbx_write_data (mps_mbx_dev * pMBDev,
                                    mps_message * readWrite);
IFX_uint32_t ifx_mps_init_structures (mps_comm_dev * pDev);
IFX_void_t ifx_mps_release_structures (mps_comm_dev * pDev);
IFX_int32_t ifx_mps_restart (IFX_void_t);
IFX_void_t ifx_mps_reset (IFX_void_t);
IFX_int32_t ifx_mps_download_firmware (mps_mbx_dev * pDev, mps_fw * pFWDwnld);
IFX_uint32_t ifx_mps_fifo_mem_available (mps_fifo * mbx);
IFX_return_t ifx_mps_init_gpt (IFX_void_t);
IFX_void_t ifx_mps_shutdown_gpt (IFX_void_t);
IFX_int32_t ifx_mps_bufman_init (IFX_void_t);
IFX_int32_t ifx_mps_get_fw_version (IFX_int32_t print);
IFX_void_t ifx_mps_bufman_free (const IFX_void_t * ptr);
IFX_void_t *ifx_mps_bufman_malloc (IFX_size_t size, IFX_int32_t priority);
IFX_void_t ifx_mps_disable_mailbox_int (IFX_void_t);
IFX_void_t ifx_mps_disable_all_int (IFX_void_t);
IFX_void_t ifx_mps_enable_mailbox_int (IFX_void_t);
#if defined(SYSTEM_AR9) || defined(SYSTEM_VR9)
IFX_int32_t
ifx_mps_register_wdog_callback (IFX_int32_t (*pfn) (IFX_uint32_t flags));
#else
IFX_void_t ifx_mps_wdog_expiry(IFX_void_t);
#endif /* SYSTEM_AR9 || SYSTEM_VR9 */
DECLARE_TRACE_GROUP (MPS);
IFX_void_t ifx_mps_register_bufman_freeall_callback (IFX_void_t (*pfn)(IFX_void_t));
extern IFX_void_t (*ifx_mps_bufman_freeall)(IFX_void_t);
IFX_uint32_t ifx_mps_fw_crc32(volatile IFX_uint32_t *cpu1_base_addr, FW_image_ftr_t *pFW_img_data);
IFX_void_t ifx_mps_fw_crc_compare(volatile IFX_uint32_t  *cpu1_base_addr, FW_image_ftr_t *pFW_img_data);
IFX_void_t ifx_mps_dump_fw_xcpt(volatile IFX_uint32_t *cpu1_base_addr, FW_image_ftr_t *pFW_img_data);
extern volatile IFX_uint32_t *cpu1_base_addr;
#if defined(CONFIG_MIPS) && !defined(CONFIG_MIPS_UNCACHED)
#define MVPCONTROL_CPA_BIT (1 << 3)
#define VPEOPT_DWX_MASK 0xf
extern IFX_boolean_t bDoCacheOps;
#endif /*defined(CONFIG_MIPS) && !defined(CONFIG_MIPS_UNCACHED)*/

#endif /* _DRV_MPS_VMMC_DEVICE_H */
