/*
 * firewall3 - 3rd OpenWrt UCI firewall implementation
 *
 *   Copyright (C) 2013 Jo-Philipp Wich <jo@mein.io>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef __FW3_RULES_H
#define __FW3_RULES_H

#include "options.h"
#include "zones.h"
#include "ipsets.h"
#include "utils.h"
#include "iptables.h"

extern const struct fw3_option fw3_rule_opts[];

void fw3_load_rules(struct fw3_state *state, struct uci_package *p, struct blob_attr *a);
void fw3_print_rules(struct fw3_ipt_handle *handle, struct fw3_state *state);

static inline void fw3_free_rule(struct fw3_rule *rule)
{
	list_del(&rule->list);
	fw3_free_object(rule, fw3_rule_opts);
}

#endif
