/*
 * eap_ttls.h
 *
 * Version:     $Id: 1525092cdea045da956274437a0efd02e7d94798 $
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * Copyright 2003 Alan DeKok <aland@freeradius.org>
 * Copyright 2006 The FreeRADIUS server project
 */
#ifndef _EAP_TTLS_H
#define _EAP_TTLS_H

#include <freeradius-devel/ident.h>
RCSIDH(eap_ttls_h, "$Id: 1525092cdea045da956274437a0efd02e7d94798 $")

#include "eap_tls.h"

typedef struct ttls_tunnel_t {
	VALUE_PAIR	*username;
	VALUE_PAIR	*state;
	VALUE_PAIR	*accept_vps;
	int		authenticated;
	int		default_eap_type;
	int		copy_request_to_tunnel;
	int		use_tunneled_reply;
	const char	*virtual_server;
} ttls_tunnel_t;

/*
 *	Process the TTLS portion of an EAP-TTLS request.
 */
int eapttls_process(EAP_HANDLER *handler, tls_session_t *tls_session);

#endif /* _EAP_TTLS_H */
