/*
 * Copyright 2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
////////////////////////////////////////////////////////////////////////////////
//
// WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
//                DO NOT MODIFY THIS FILE DIRECTLY.
//
////////////////////////////////////////////////////////////////////////////////
//
// The following naming conventions are followed in this file.
//      XX_<module>_<regname>_<field>
//
// XX specifies the define / macro class
//      HW pertains to a register
//      BM indicates a Bit Mask
//      BF indicates a Bit Field macro
//
// <module> is the hardware module name which can be any of the following...
//      USB20 (Note when there is more than one copy of a given module, the
//      module name includes a number starting from 0 for the first instance
//      of that module)
//
// <regname> is the specific register within that module
//
// <field> is the specific bitfield within that <module>_<register>
//
// We also define the following...
//      hw_<module>_<regname>_t is typedef of anonymous union
//
////////////////////////////////////////////////////////////////////////////////

#ifndef _REGSPWM_H
#define _REGSPWM_H  1

#include "regs.h"

#ifndef REGS_PWM_BASE
#define REGS_PWM_BASE (REGS_BASE + 0x00064000)
#endif

////////////////////////////////////////////////////////////////////////////////
//// HW_PWM_CTRL - PWM Control and Status Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PWM0_ENABLE           :  1;
        unsigned PWM1_ENABLE           :  1;
        unsigned PWM2_ENABLE           :  1;
        unsigned PWM3_ENABLE           :  1;
        unsigned PWM4_ENABLE           :  1;
        unsigned PWM2_ANA_CTRL_ENABLE  :  1;
        unsigned OUTPUT_CUTOFF_EN      :  1;
        unsigned RSRVD1                : 18;
        unsigned PWM0_PRESENT          :  1;
        unsigned PWM1_PRESENT          :  1;
        unsigned PWM2_PRESENT          :  1;
        unsigned PWM3_PRESENT          :  1;
        unsigned PWM4_PRESENT          :  1;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_pwm_ctrl_t;
#endif


//
// constants & macros for entire HW_PWM_CTRL register
//

#define HW_PWM_CTRL_ADDR      (REGS_PWM_BASE + 0x00000000)
#define HW_PWM_CTRL_SET_ADDR  (REGS_PWM_BASE + 0x00000004)
#define HW_PWM_CTRL_CLR_ADDR  (REGS_PWM_BASE + 0x00000008)
#define HW_PWM_CTRL_TOG_ADDR  (REGS_PWM_BASE + 0x0000000C)

#ifndef __LANGUAGE_ASM__
#define HW_PWM_CTRL           (*(volatile hw_pwm_ctrl_t *) HW_PWM_CTRL_ADDR)
#define HW_PWM_CTRL_RD()      (HW_PWM_CTRL.U)
#define HW_PWM_CTRL_WR(v)     (HW_PWM_CTRL.U = (v))
#define HW_PWM_CTRL_SET(v)    ((*(volatile reg32_t *) HW_PWM_CTRL_SET_ADDR) = (v))
#define HW_PWM_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_PWM_CTRL_CLR_ADDR) = (v))
#define HW_PWM_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_PWM_CTRL_TOG_ADDR) = (v))
#endif


//
// constants & macros for individual HW_PWM_CTRL bitfields
//

//--- Register HW_PWM_CTRL, field SFTRST

#define BP_PWM_CTRL_SFTRST      31
#define BM_PWM_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_PWM_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_PWM_CTRL_SFTRST)
#else
#define BF_PWM_CTRL_SFTRST(v)   (((v) << 31) & BM_PWM_CTRL_SFTRST)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_SFTRST(v)   BF_CS1(PWM_CTRL, SFTRST, v)
#endif

//--- Register HW_PWM_CTRL, field CLKGATE

#define BP_PWM_CTRL_CLKGATE      30
#define BM_PWM_CTRL_CLKGATE      0x40000000

#define BF_PWM_CTRL_CLKGATE(v)   (((v) << 30) & BM_PWM_CTRL_CLKGATE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_CLKGATE(v)   BF_CS1(PWM_CTRL, CLKGATE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM4_PRESENT

#define BP_PWM_CTRL_PWM4_PRESENT      29
#define BM_PWM_CTRL_PWM4_PRESENT      0x20000000

#define BF_PWM_CTRL_PWM4_PRESENT(v)   (((v) << 29) & BM_PWM_CTRL_PWM4_PRESENT)

//--- Register HW_PWM_CTRL, field PWM3_PRESENT

#define BP_PWM_CTRL_PWM3_PRESENT      28
#define BM_PWM_CTRL_PWM3_PRESENT      0x10000000

#define BF_PWM_CTRL_PWM3_PRESENT(v)   (((v) << 28) & BM_PWM_CTRL_PWM3_PRESENT)

//--- Register HW_PWM_CTRL, field PWM2_PRESENT

#define BP_PWM_CTRL_PWM2_PRESENT      27
#define BM_PWM_CTRL_PWM2_PRESENT      0x08000000

#define BF_PWM_CTRL_PWM2_PRESENT(v)   (((v) << 27) & BM_PWM_CTRL_PWM2_PRESENT)

//--- Register HW_PWM_CTRL, field PWM1_PRESENT

#define BP_PWM_CTRL_PWM1_PRESENT      26
#define BM_PWM_CTRL_PWM1_PRESENT      0x04000000

#define BF_PWM_CTRL_PWM1_PRESENT(v)   (((v) << 26) & BM_PWM_CTRL_PWM1_PRESENT)

//--- Register HW_PWM_CTRL, field PWM0_PRESENT

#define BP_PWM_CTRL_PWM0_PRESENT      25
#define BM_PWM_CTRL_PWM0_PRESENT      0x02000000

#define BF_PWM_CTRL_PWM0_PRESENT(v)   (((v) << 25) & BM_PWM_CTRL_PWM0_PRESENT)

//--- Register HW_PWM_CTRL, field OUTPUT_CUTOFF_EN

#define BP_PWM_CTRL_OUTPUT_CUTOFF_EN      6
#define BM_PWM_CTRL_OUTPUT_CUTOFF_EN      0x00000040

#define BF_PWM_CTRL_OUTPUT_CUTOFF_EN(v)   (((v) << 6) & BM_PWM_CTRL_OUTPUT_CUTOFF_EN)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_OUTPUT_CUTOFF_EN(v)   BF_CS1(PWM_CTRL, OUTPUT_CUTOFF_EN, v)
#endif

//--- Register HW_PWM_CTRL, field PWM2_ANA_CTRL_ENABLE

#define BP_PWM_CTRL_PWM2_ANA_CTRL_ENABLE      5
#define BM_PWM_CTRL_PWM2_ANA_CTRL_ENABLE      0x00000020

#define BF_PWM_CTRL_PWM2_ANA_CTRL_ENABLE(v)   (((v) << 5) & BM_PWM_CTRL_PWM2_ANA_CTRL_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM2_ANA_CTRL_ENABLE(v)   BF_CS1(PWM_CTRL, PWM2_ANA_CTRL_ENABLE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM4_ENABLE

#define BP_PWM_CTRL_PWM4_ENABLE      4
#define BM_PWM_CTRL_PWM4_ENABLE      0x00000010

#define BF_PWM_CTRL_PWM4_ENABLE(v)   (((v) << 4) & BM_PWM_CTRL_PWM4_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM4_ENABLE(v)   BF_CS1(PWM_CTRL, PWM4_ENABLE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM3_ENABLE

#define BP_PWM_CTRL_PWM3_ENABLE      3
#define BM_PWM_CTRL_PWM3_ENABLE      0x00000008

#define BF_PWM_CTRL_PWM3_ENABLE(v)   (((v) << 3) & BM_PWM_CTRL_PWM3_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM3_ENABLE(v)   BF_CS1(PWM_CTRL, PWM3_ENABLE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM2_ENABLE

#define BP_PWM_CTRL_PWM2_ENABLE      2
#define BM_PWM_CTRL_PWM2_ENABLE      0x00000004

#define BF_PWM_CTRL_PWM2_ENABLE(v)   (((v) << 2) & BM_PWM_CTRL_PWM2_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM2_ENABLE(v)   BF_CS1(PWM_CTRL, PWM2_ENABLE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM1_ENABLE

#define BP_PWM_CTRL_PWM1_ENABLE      1
#define BM_PWM_CTRL_PWM1_ENABLE      0x00000002

#define BF_PWM_CTRL_PWM1_ENABLE(v)   (((v) << 1) & BM_PWM_CTRL_PWM1_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM1_ENABLE(v)   BF_CS1(PWM_CTRL, PWM1_ENABLE, v)
#endif

//--- Register HW_PWM_CTRL, field PWM0_ENABLE

#define BP_PWM_CTRL_PWM0_ENABLE      0
#define BM_PWM_CTRL_PWM0_ENABLE      0x00000001

#define BF_PWM_CTRL_PWM0_ENABLE(v)   (((v) << 0) & BM_PWM_CTRL_PWM0_ENABLE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_CTRL_PWM0_ENABLE(v)   BF_CS1(PWM_CTRL, PWM0_ENABLE, v)
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PWM_ACTIVEn : base 0x80064010 : count 5 : offset 0x20
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  ACTIVE;
        reg16_t  INACTIVE;
    } B;
} hw_pwm_activen_t;
#endif


//
// constants & macros for entire HW_PWM_ACTIVEn multi-register
//

#define HW_PWM_ACTIVEn_COUNT        5
#define HW_PWM_ACTIVEn_ADDR(n)      (REGS_PWM_BASE + 0x00000010 + ((n) * 0x20))
#define HW_PWM_ACTIVEn_SET_ADDR(n)  (REGS_PWM_BASE + 0x00000014 + ((n) * 0x20))
#define HW_PWM_ACTIVEn_CLR_ADDR(n)  (REGS_PWM_BASE + 0x00000018 + ((n) * 0x20))
#define HW_PWM_ACTIVEn_TOG_ADDR(n)  (REGS_PWM_BASE + 0x0000001C + ((n) * 0x20))

#ifndef __LANGUAGE_ASM__
#define HW_PWM_ACTIVEn(n)           (*(volatile hw_pwm_activen_t *) HW_PWM_ACTIVEn_ADDR(n))
#define HW_PWM_ACTIVEn_RD(n)        (HW_PWM_ACTIVEn(n).U)
#define HW_PWM_ACTIVEn_WR(n, v)     (HW_PWM_ACTIVEn(n).U = (v))
#define HW_PWM_ACTIVEn_SET(n, v)    ((*(volatile reg32_t *) HW_PWM_ACTIVEn_SET_ADDR(n)) = (v))
#define HW_PWM_ACTIVEn_CLR(n, v)    ((*(volatile reg32_t *) HW_PWM_ACTIVEn_CLR_ADDR(n)) = (v))
#define HW_PWM_ACTIVEn_TOG(n, v)    ((*(volatile reg32_t *) HW_PWM_ACTIVEn_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_PWM_ACTIVEn multi-register bitfields
//

//--- Register HW_PWM_ACTIVEn, field INACTIVE

#define BP_PWM_ACTIVEn_INACTIVE      16
#define BM_PWM_ACTIVEn_INACTIVE      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_PWM_ACTIVEn_INACTIVE(v)   ((((reg32_t) v) << 16) & BM_PWM_ACTIVEn_INACTIVE)
#else
#define BF_PWM_ACTIVEn_INACTIVE(v)   (((v) << 16) & BM_PWM_ACTIVEn_INACTIVE)
#endif

#ifndef __LANGUAGE_ASM__
#define BW_PWM_ACTIVEn_INACTIVE(n, v)  (HW_PWM_ACTIVEn(n).B.INACTIVE = (v))
#endif

//--- Register HW_PWM_ACTIVEn, field ACTIVE

#define BP_PWM_ACTIVEn_ACTIVE      0
#define BM_PWM_ACTIVEn_ACTIVE      0x0000FFFF

#define BF_PWM_ACTIVEn_ACTIVE(v)   (((v) << 0) & BM_PWM_ACTIVEn_ACTIVE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_ACTIVEn_ACTIVE(n, v)  (HW_PWM_ACTIVEn(n).B.ACTIVE = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// multi-register-define name HW_PWM_PERIODn : base 0x80064020 : count 5 : offset 0x20
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  PERIOD;
        unsigned ACTIVE_STATE    :  2;
        unsigned INACTIVE_STATE  :  2;
        unsigned CDIV            :  3;
        unsigned MATT            :  1;
        unsigned MATT_SEL        :  1;
        unsigned RSRVD2          :  7;
    } B;
} hw_pwm_periodn_t;
#endif


//
// constants & macros for entire HW_PWM_PERIODn multi-register
//

#define HW_PWM_PERIODn_COUNT        5
#define HW_PWM_PERIODn_ADDR(n)      (REGS_PWM_BASE + 0x00000020 + ((n) * 0x20))
#define HW_PWM_PERIODn_SET_ADDR(n)  (REGS_PWM_BASE + 0x00000024 + ((n) * 0x20))
#define HW_PWM_PERIODn_CLR_ADDR(n)  (REGS_PWM_BASE + 0x00000028 + ((n) * 0x20))
#define HW_PWM_PERIODn_TOG_ADDR(n)  (REGS_PWM_BASE + 0x0000002C + ((n) * 0x20))

#ifndef __LANGUAGE_ASM__
#define HW_PWM_PERIODn(n)           (*(volatile hw_pwm_periodn_t *) HW_PWM_PERIODn_ADDR(n))
#define HW_PWM_PERIODn_RD(n)        (HW_PWM_PERIODn(n).U)
#define HW_PWM_PERIODn_WR(n, v)     (HW_PWM_PERIODn(n).U = (v))
#define HW_PWM_PERIODn_SET(n, v)    ((*(volatile reg32_t *) HW_PWM_PERIODn_SET_ADDR(n)) = (v))
#define HW_PWM_PERIODn_CLR(n, v)    ((*(volatile reg32_t *) HW_PWM_PERIODn_CLR_ADDR(n)) = (v))
#define HW_PWM_PERIODn_TOG(n, v)    ((*(volatile reg32_t *) HW_PWM_PERIODn_TOG_ADDR(n)) = (v))
#endif


//
// constants & macros for individual HW_PWM_PERIODn multi-register bitfields
//

//--- Register HW_PWM_PERIODn, field MATT_SEL

#define BP_PWM_PERIODn_MATT_SEL      24
#define BM_PWM_PERIODn_MATT_SEL      0x01000000

#define BF_PWM_PERIODn_MATT_SEL(v)   (((v) << 24) & BM_PWM_PERIODn_MATT_SEL)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_MATT_SEL(n, v)  BF_CS1n(PWM_PERIODn, n, MATT_SEL, v)
#endif

//--- Register HW_PWM_PERIODn, field MATT

#define BP_PWM_PERIODn_MATT      23
#define BM_PWM_PERIODn_MATT      0x00800000

#define BF_PWM_PERIODn_MATT(v)   (((v) << 23) & BM_PWM_PERIODn_MATT)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_MATT(n, v)  BF_CS1n(PWM_PERIODn, n, MATT, v)
#endif

//--- Register HW_PWM_PERIODn, field CDIV

#define BP_PWM_PERIODn_CDIV      20
#define BM_PWM_PERIODn_CDIV      0x00700000

#define BF_PWM_PERIODn_CDIV(v)   (((v) << 20) & BM_PWM_PERIODn_CDIV)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_CDIV(n, v)  BF_CS1n(PWM_PERIODn, n, CDIV, v)
#endif

#define BV_PWM_PERIODn_CDIV__DIV_1     0x0
#define BV_PWM_PERIODn_CDIV__DIV_2     0x1
#define BV_PWM_PERIODn_CDIV__DIV_4     0x2
#define BV_PWM_PERIODn_CDIV__DIV_8     0x3
#define BV_PWM_PERIODn_CDIV__DIV_16    0x4
#define BV_PWM_PERIODn_CDIV__DIV_64    0x5
#define BV_PWM_PERIODn_CDIV__DIV_256   0x6
#define BV_PWM_PERIODn_CDIV__DIV_1024  0x7

//--- Register HW_PWM_PERIODn, field INACTIVE_STATE

#define BP_PWM_PERIODn_INACTIVE_STATE      18
#define BM_PWM_PERIODn_INACTIVE_STATE      0x000C0000

#define BF_PWM_PERIODn_INACTIVE_STATE(v)   (((v) << 18) & BM_PWM_PERIODn_INACTIVE_STATE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_INACTIVE_STATE(n, v)  BF_CS1n(PWM_PERIODn, n, INACTIVE_STATE, v)
#endif

#define BV_PWM_PERIODn_INACTIVE_STATE__HI_Z  0x0
#define BV_PWM_PERIODn_INACTIVE_STATE__0     0x2
#define BV_PWM_PERIODn_INACTIVE_STATE__1     0x3

//--- Register HW_PWM_PERIODn, field ACTIVE_STATE

#define BP_PWM_PERIODn_ACTIVE_STATE      16
#define BM_PWM_PERIODn_ACTIVE_STATE      0x00030000

#define BF_PWM_PERIODn_ACTIVE_STATE(v)   (((v) << 16) & BM_PWM_PERIODn_ACTIVE_STATE)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_ACTIVE_STATE(n, v)  BF_CS1n(PWM_PERIODn, n, ACTIVE_STATE, v)
#endif

#define BV_PWM_PERIODn_ACTIVE_STATE__HI_Z  0x0
#define BV_PWM_PERIODn_ACTIVE_STATE__0     0x2
#define BV_PWM_PERIODn_ACTIVE_STATE__1     0x3

//--- Register HW_PWM_PERIODn, field PERIOD

#define BP_PWM_PERIODn_PERIOD      0
#define BM_PWM_PERIODn_PERIOD      0x0000FFFF

#define BF_PWM_PERIODn_PERIOD(v)   (((v) << 0) & BM_PWM_PERIODn_PERIOD)

#ifndef __LANGUAGE_ASM__
#define BW_PWM_PERIODn_PERIOD(n, v)  (HW_PWM_PERIODn(n).B.PERIOD = (v))
#endif


////////////////////////////////////////////////////////////////////////////////
//// HW_PWM_VERSION - PWM Version Register
////////////////////////////////////////////////////////////////////////////////

#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        reg16_t  STEP;
        reg8_t   MINOR;
        reg8_t   MAJOR;
    } B;
} hw_pwm_version_t;
#endif


//
// constants & macros for entire HW_PWM_VERSION register
//

#define HW_PWM_VERSION_ADDR      (REGS_PWM_BASE + 0x000000B0)

#ifndef __LANGUAGE_ASM__
#define HW_PWM_VERSION           (*(volatile hw_pwm_version_t *) HW_PWM_VERSION_ADDR)
#define HW_PWM_VERSION_RD()      (HW_PWM_VERSION.U)
#endif


//
// constants & macros for individual HW_PWM_VERSION bitfields
//

//--- Register HW_PWM_VERSION, field MAJOR

#define BP_PWM_VERSION_MAJOR      24
#define BM_PWM_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_PWM_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_PWM_VERSION_MAJOR)
#else
#define BF_PWM_VERSION_MAJOR(v)   (((v) << 24) & BM_PWM_VERSION_MAJOR)
#endif

//--- Register HW_PWM_VERSION, field MINOR

#define BP_PWM_VERSION_MINOR      16
#define BM_PWM_VERSION_MINOR      0x00FF0000

#define BF_PWM_VERSION_MINOR(v)   (((v) << 16) & BM_PWM_VERSION_MINOR)

//--- Register HW_PWM_VERSION, field STEP

#define BP_PWM_VERSION_STEP      0
#define BM_PWM_VERSION_STEP      0x0000FFFF

#define BF_PWM_VERSION_STEP(v)   (((v) << 0) & BM_PWM_VERSION_STEP)


#endif // _REGSPWM_H

////////////////////////////////////////////////////////////////////////////////
