/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.32
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _LCDIF_H
#define _LCDIF_H  1

#include "regs.h"

#ifndef REGS_LCDIF_BASE
#define REGS_LCDIF_BASE (REGS_BASE + 0x30000)
#endif

/*
 * HW_LCDIF_CTRL - LCDIF General Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RUN                   :  1;
        unsigned DATA_FORMAT_24_BIT    :  1;
        unsigned DATA_FORMAT_18_BIT    :  1;
        unsigned DATA_FORMAT_16_BIT    :  1;
        unsigned RSRVD0                :  1;
        unsigned LCDIF_MASTER          :  1;
        unsigned ENABLE_PXP_HANDSHAKE  :  1;
        unsigned RGB_TO_YCBCR422_CSC   :  1;
        unsigned WORD_LENGTH           :  2;
        unsigned LCD_DATABUS_WIDTH     :  2;
        unsigned CSC_DATA_SWIZZLE      :  2;
        unsigned INPUT_DATA_SWIZZLE    :  2;
        unsigned DATA_SELECT           :  1;
        unsigned DOTCLK_MODE           :  1;
        unsigned VSYNC_MODE            :  1;
        unsigned BYPASS_COUNT          :  1;
        unsigned DVI_MODE              :  1;
        unsigned SHIFT_NUM_BITS        :  5;
        unsigned DATA_SHIFT_DIR        :  1;
        unsigned WAIT_FOR_VSYNC_EDGE   :  1;
        unsigned READ_WRITEB           :  1;
        unsigned YCBCR422_INPUT        :  1;
        unsigned CLKGATE               :  1;
        unsigned SFTRST                :  1;
    } B;
} hw_lcdif_ctrl_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CTRL register
 */
#define HW_LCDIF_CTRL_ADDR         (REGS_LCDIF_BASE + 0x0)
#define HW_LCDIF_CTRL_SET_ADDR     (HW_LCDIF_CTRL_ADDR + 4)
#define HW_LCDIF_CTRL_CLR_ADDR     (HW_LCDIF_CTRL_ADDR + 8)
#define HW_LCDIF_CTRL_TOG_ADDR     (HW_LCDIF_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CTRL           (*(volatile hw_lcdif_ctrl_t *) HW_LCDIF_CTRL_ADDR)
#define HW_LCDIF_CTRL_RD()      (HW_LCDIF_CTRL.U)
#define HW_LCDIF_CTRL_WR(v)     (HW_LCDIF_CTRL.U = (v))
#define HW_LCDIF_CTRL_SET(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL_SET_ADDR) = (v))
#define HW_LCDIF_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL_CLR_ADDR) = (v))
#define HW_LCDIF_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_LCDIF_CTRL bitfields
 */
/* --- Register HW_LCDIF_CTRL, field SFTRST */

#define BP_LCDIF_CTRL_SFTRST      31
#define BM_LCDIF_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_LCDIF_CTRL_SFTRST)
#else
#define BF_LCDIF_CTRL_SFTRST(v)   (((v) << 31) & BM_LCDIF_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_SFTRST(v)   BF_CS1(LCDIF_CTRL, SFTRST, v)
#endif

/* --- Register HW_LCDIF_CTRL, field CLKGATE */

#define BP_LCDIF_CTRL_CLKGATE      30
#define BM_LCDIF_CTRL_CLKGATE      0x40000000

#define BF_LCDIF_CTRL_CLKGATE(v)   (((v) << 30) & BM_LCDIF_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_CLKGATE(v)   BF_CS1(LCDIF_CTRL, CLKGATE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field YCBCR422_INPUT */

#define BP_LCDIF_CTRL_YCBCR422_INPUT      29
#define BM_LCDIF_CTRL_YCBCR422_INPUT      0x20000000

#define BF_LCDIF_CTRL_YCBCR422_INPUT(v)   (((v) << 29) & BM_LCDIF_CTRL_YCBCR422_INPUT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_YCBCR422_INPUT(v)   BF_CS1(LCDIF_CTRL, YCBCR422_INPUT, v)
#endif

/* --- Register HW_LCDIF_CTRL, field READ_WRITEB */

#define BP_LCDIF_CTRL_READ_WRITEB      28
#define BM_LCDIF_CTRL_READ_WRITEB      0x10000000

#define BF_LCDIF_CTRL_READ_WRITEB(v)   (((v) << 28) & BM_LCDIF_CTRL_READ_WRITEB)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_READ_WRITEB(v)   BF_CS1(LCDIF_CTRL, READ_WRITEB, v)
#endif

/* --- Register HW_LCDIF_CTRL, field WAIT_FOR_VSYNC_EDGE */

#define BP_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE      27
#define BM_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE      0x08000000

#define BF_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE(v)   (((v) << 27) & BM_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_WAIT_FOR_VSYNC_EDGE(v)   BF_CS1(LCDIF_CTRL, WAIT_FOR_VSYNC_EDGE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field DATA_SHIFT_DIR */

#define BP_LCDIF_CTRL_DATA_SHIFT_DIR      26
#define BM_LCDIF_CTRL_DATA_SHIFT_DIR      0x04000000

#define BF_LCDIF_CTRL_DATA_SHIFT_DIR(v)   (((v) << 26) & BM_LCDIF_CTRL_DATA_SHIFT_DIR)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DATA_SHIFT_DIR(v)   BF_CS1(LCDIF_CTRL, DATA_SHIFT_DIR, v)
#endif

#define BV_LCDIF_CTRL_DATA_SHIFT_DIR__TXDATA_SHIFT_LEFT   0x0
#define BV_LCDIF_CTRL_DATA_SHIFT_DIR__TXDATA_SHIFT_RIGHT  0x1

/* --- Register HW_LCDIF_CTRL, field SHIFT_NUM_BITS */

#define BP_LCDIF_CTRL_SHIFT_NUM_BITS      21
#define BM_LCDIF_CTRL_SHIFT_NUM_BITS      0x03E00000

#define BF_LCDIF_CTRL_SHIFT_NUM_BITS(v)   (((v) << 21) & BM_LCDIF_CTRL_SHIFT_NUM_BITS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_SHIFT_NUM_BITS(v)   BF_CS1(LCDIF_CTRL, SHIFT_NUM_BITS, v)
#endif

/* --- Register HW_LCDIF_CTRL, field DVI_MODE */

#define BP_LCDIF_CTRL_DVI_MODE      20
#define BM_LCDIF_CTRL_DVI_MODE      0x00100000

#define BF_LCDIF_CTRL_DVI_MODE(v)   (((v) << 20) & BM_LCDIF_CTRL_DVI_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DVI_MODE(v)   BF_CS1(LCDIF_CTRL, DVI_MODE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field BYPASS_COUNT */

#define BP_LCDIF_CTRL_BYPASS_COUNT      19
#define BM_LCDIF_CTRL_BYPASS_COUNT      0x00080000

#define BF_LCDIF_CTRL_BYPASS_COUNT(v)   (((v) << 19) & BM_LCDIF_CTRL_BYPASS_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_BYPASS_COUNT(v)   BF_CS1(LCDIF_CTRL, BYPASS_COUNT, v)
#endif

/* --- Register HW_LCDIF_CTRL, field VSYNC_MODE */

#define BP_LCDIF_CTRL_VSYNC_MODE      18
#define BM_LCDIF_CTRL_VSYNC_MODE      0x00040000

#define BF_LCDIF_CTRL_VSYNC_MODE(v)   (((v) << 18) & BM_LCDIF_CTRL_VSYNC_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_VSYNC_MODE(v)   BF_CS1(LCDIF_CTRL, VSYNC_MODE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field DOTCLK_MODE */

#define BP_LCDIF_CTRL_DOTCLK_MODE      17
#define BM_LCDIF_CTRL_DOTCLK_MODE      0x00020000

#define BF_LCDIF_CTRL_DOTCLK_MODE(v)   (((v) << 17) & BM_LCDIF_CTRL_DOTCLK_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DOTCLK_MODE(v)   BF_CS1(LCDIF_CTRL, DOTCLK_MODE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field DATA_SELECT */

#define BP_LCDIF_CTRL_DATA_SELECT      16
#define BM_LCDIF_CTRL_DATA_SELECT      0x00010000

#define BF_LCDIF_CTRL_DATA_SELECT(v)   (((v) << 16) & BM_LCDIF_CTRL_DATA_SELECT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DATA_SELECT(v)   BF_CS1(LCDIF_CTRL, DATA_SELECT, v)
#endif

#define BV_LCDIF_CTRL_DATA_SELECT__CMD_MODE   0x0
#define BV_LCDIF_CTRL_DATA_SELECT__DATA_MODE  0x1

/* --- Register HW_LCDIF_CTRL, field INPUT_DATA_SWIZZLE */

#define BP_LCDIF_CTRL_INPUT_DATA_SWIZZLE      14
#define BM_LCDIF_CTRL_INPUT_DATA_SWIZZLE      0x0000C000

#define BF_LCDIF_CTRL_INPUT_DATA_SWIZZLE(v)   (((v) << 14) & BM_LCDIF_CTRL_INPUT_DATA_SWIZZLE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_INPUT_DATA_SWIZZLE(v)   BF_CS1(LCDIF_CTRL, INPUT_DATA_SWIZZLE, v)
#endif

#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__NO_SWAP          0x0
#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__LITTLE_ENDIAN    0x0
#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__BIG_ENDIAN_SWAP  0x1
#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__SWAP_ALL_BYTES   0x1
#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__HWD_SWAP         0x2
#define BV_LCDIF_CTRL_INPUT_DATA_SWIZZLE__HWD_BYTE_SWAP    0x3

/* --- Register HW_LCDIF_CTRL, field CSC_DATA_SWIZZLE */

#define BP_LCDIF_CTRL_CSC_DATA_SWIZZLE      12
#define BM_LCDIF_CTRL_CSC_DATA_SWIZZLE      0x00003000

#define BF_LCDIF_CTRL_CSC_DATA_SWIZZLE(v)   (((v) << 12) & BM_LCDIF_CTRL_CSC_DATA_SWIZZLE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_CSC_DATA_SWIZZLE(v)   BF_CS1(LCDIF_CTRL, CSC_DATA_SWIZZLE, v)
#endif

#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__NO_SWAP          0x0
#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__LITTLE_ENDIAN    0x0
#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__BIG_ENDIAN_SWAP  0x1
#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__SWAP_ALL_BYTES   0x1
#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__HWD_SWAP         0x2
#define BV_LCDIF_CTRL_CSC_DATA_SWIZZLE__HWD_BYTE_SWAP    0x3

/* --- Register HW_LCDIF_CTRL, field LCD_DATABUS_WIDTH */

#define BP_LCDIF_CTRL_LCD_DATABUS_WIDTH      10
#define BM_LCDIF_CTRL_LCD_DATABUS_WIDTH      0x00000C00

#define BF_LCDIF_CTRL_LCD_DATABUS_WIDTH(v)   (((v) << 10) & BM_LCDIF_CTRL_LCD_DATABUS_WIDTH)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_LCD_DATABUS_WIDTH(v)   BF_CS1(LCDIF_CTRL, LCD_DATABUS_WIDTH, v)
#endif

#define BV_LCDIF_CTRL_LCD_DATABUS_WIDTH__16_BIT  0x0
#define BV_LCDIF_CTRL_LCD_DATABUS_WIDTH__8_BIT   0x1
#define BV_LCDIF_CTRL_LCD_DATABUS_WIDTH__18_BIT  0x2
#define BV_LCDIF_CTRL_LCD_DATABUS_WIDTH__24_BIT  0x3

/* --- Register HW_LCDIF_CTRL, field WORD_LENGTH */

#define BP_LCDIF_CTRL_WORD_LENGTH      8
#define BM_LCDIF_CTRL_WORD_LENGTH      0x00000300

#define BF_LCDIF_CTRL_WORD_LENGTH(v)   (((v) << 8) & BM_LCDIF_CTRL_WORD_LENGTH)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_WORD_LENGTH(v)   BF_CS1(LCDIF_CTRL, WORD_LENGTH, v)
#endif

#define BV_LCDIF_CTRL_WORD_LENGTH__16_BIT  0x0
#define BV_LCDIF_CTRL_WORD_LENGTH__8_BIT   0x1
#define BV_LCDIF_CTRL_WORD_LENGTH__18_BIT  0x2
#define BV_LCDIF_CTRL_WORD_LENGTH__24_BIT  0x3

/* --- Register HW_LCDIF_CTRL, field RGB_TO_YCBCR422_CSC */

#define BP_LCDIF_CTRL_RGB_TO_YCBCR422_CSC      7
#define BM_LCDIF_CTRL_RGB_TO_YCBCR422_CSC      0x00000080

#define BF_LCDIF_CTRL_RGB_TO_YCBCR422_CSC(v)   (((v) << 7) & BM_LCDIF_CTRL_RGB_TO_YCBCR422_CSC)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_RGB_TO_YCBCR422_CSC(v)   BF_CS1(LCDIF_CTRL, RGB_TO_YCBCR422_CSC, v)
#endif

/* --- Register HW_LCDIF_CTRL, field ENABLE_PXP_HANDSHAKE */

#define BP_LCDIF_CTRL_ENABLE_PXP_HANDSHAKE      6
#define BM_LCDIF_CTRL_ENABLE_PXP_HANDSHAKE      0x00000040

#define BF_LCDIF_CTRL_ENABLE_PXP_HANDSHAKE(v)   (((v) << 6) & BM_LCDIF_CTRL_ENABLE_PXP_HANDSHAKE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_ENABLE_PXP_HANDSHAKE(v)   BF_CS1(LCDIF_CTRL, ENABLE_PXP_HANDSHAKE, v)
#endif

/* --- Register HW_LCDIF_CTRL, field LCDIF_MASTER */

#define BP_LCDIF_CTRL_LCDIF_MASTER      5
#define BM_LCDIF_CTRL_LCDIF_MASTER      0x00000020

#define BF_LCDIF_CTRL_LCDIF_MASTER(v)   (((v) << 5) & BM_LCDIF_CTRL_LCDIF_MASTER)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_LCDIF_MASTER(v)   BF_CS1(LCDIF_CTRL, LCDIF_MASTER, v)
#endif

/* --- Register HW_LCDIF_CTRL, field RSRVD0 */

#define BP_LCDIF_CTRL_RSRVD0      4
#define BM_LCDIF_CTRL_RSRVD0      0x00000010

#define BF_LCDIF_CTRL_RSRVD0(v)   (((v) << 4) & BM_LCDIF_CTRL_RSRVD0)
/* --- Register HW_LCDIF_CTRL, field DATA_FORMAT_16_BIT */

#define BP_LCDIF_CTRL_DATA_FORMAT_16_BIT      3
#define BM_LCDIF_CTRL_DATA_FORMAT_16_BIT      0x00000008

#define BF_LCDIF_CTRL_DATA_FORMAT_16_BIT(v)   (((v) << 3) & BM_LCDIF_CTRL_DATA_FORMAT_16_BIT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DATA_FORMAT_16_BIT(v)   BF_CS1(LCDIF_CTRL, DATA_FORMAT_16_BIT, v)
#endif

/* --- Register HW_LCDIF_CTRL, field DATA_FORMAT_18_BIT */

#define BP_LCDIF_CTRL_DATA_FORMAT_18_BIT      2
#define BM_LCDIF_CTRL_DATA_FORMAT_18_BIT      0x00000004

#define BF_LCDIF_CTRL_DATA_FORMAT_18_BIT(v)   (((v) << 2) & BM_LCDIF_CTRL_DATA_FORMAT_18_BIT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DATA_FORMAT_18_BIT(v)   BF_CS1(LCDIF_CTRL, DATA_FORMAT_18_BIT, v)
#endif

#define BV_LCDIF_CTRL_DATA_FORMAT_18_BIT__LOWER_18_BITS_VALID  0x0
#define BV_LCDIF_CTRL_DATA_FORMAT_18_BIT__UPPER_18_BITS_VALID  0x1

/* --- Register HW_LCDIF_CTRL, field DATA_FORMAT_24_BIT */

#define BP_LCDIF_CTRL_DATA_FORMAT_24_BIT      1
#define BM_LCDIF_CTRL_DATA_FORMAT_24_BIT      0x00000002

#define BF_LCDIF_CTRL_DATA_FORMAT_24_BIT(v)   (((v) << 1) & BM_LCDIF_CTRL_DATA_FORMAT_24_BIT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_DATA_FORMAT_24_BIT(v)   BF_CS1(LCDIF_CTRL, DATA_FORMAT_24_BIT, v)
#endif

#define BV_LCDIF_CTRL_DATA_FORMAT_24_BIT__ALL_24_BITS_VALID           0x0
#define BV_LCDIF_CTRL_DATA_FORMAT_24_BIT__DROP_UPPER_2_BITS_PER_BYTE  0x1

/* --- Register HW_LCDIF_CTRL, field RUN */

#define BP_LCDIF_CTRL_RUN      0
#define BM_LCDIF_CTRL_RUN      0x00000001

#define BF_LCDIF_CTRL_RUN(v)   (((v) << 0) & BM_LCDIF_CTRL_RUN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL_RUN(v)   BF_CS1(LCDIF_CTRL, RUN, v)
#endif



/*
 * HW_LCDIF_CTRL1 - LCDIF General Control1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RESET                              :  1;
        unsigned MODE86                             :  1;
        unsigned BUSY_ENABLE                        :  1;
        unsigned RSRVD0                             :  5;
        unsigned VSYNC_EDGE_IRQ                     :  1;
        unsigned CUR_FRAME_DONE_IRQ                 :  1;
        unsigned UNDERFLOW_IRQ                      :  1;
        unsigned OVERFLOW_IRQ                       :  1;
        unsigned VSYNC_EDGE_IRQ_EN                  :  1;
        unsigned CUR_FRAME_DONE_IRQ_EN              :  1;
        unsigned UNDERFLOW_IRQ_EN                   :  1;
        unsigned OVERFLOW_IRQ_EN                    :  1;
        unsigned BYTE_PACKING_FORMAT                :  4;
        unsigned IRQ_ON_ALTERNATE_FIELDS            :  1;
        unsigned FIFO_CLEAR                         :  1;
        unsigned START_INTERLACE_FROM_SECOND_FIELD  :  1;
        unsigned INTERLACE_FIELDS                   :  1;
        unsigned RECOVER_ON_UNDERFLOW               :  1;
        unsigned BM_ERROR_IRQ                       :  1;
        unsigned BM_ERROR_IRQ_EN                    :  1;
        unsigned COMBINE_MPU_WR_STRB                :  1;
        unsigned RSRVD1                             :  4;
    } B;
} hw_lcdif_ctrl1_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CTRL1 register
 */
#define HW_LCDIF_CTRL1_ADDR         (REGS_LCDIF_BASE + 0x10)
#define HW_LCDIF_CTRL1_SET_ADDR     (HW_LCDIF_CTRL1_ADDR + 4)
#define HW_LCDIF_CTRL1_CLR_ADDR     (HW_LCDIF_CTRL1_ADDR + 8)
#define HW_LCDIF_CTRL1_TOG_ADDR     (HW_LCDIF_CTRL1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CTRL1           (*(volatile hw_lcdif_ctrl1_t *) HW_LCDIF_CTRL1_ADDR)
#define HW_LCDIF_CTRL1_RD()      (HW_LCDIF_CTRL1.U)
#define HW_LCDIF_CTRL1_WR(v)     (HW_LCDIF_CTRL1.U = (v))
#define HW_LCDIF_CTRL1_SET(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL1_SET_ADDR) = (v))
#define HW_LCDIF_CTRL1_CLR(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL1_CLR_ADDR) = (v))
#define HW_LCDIF_CTRL1_TOG(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_LCDIF_CTRL1 bitfields
 */
/* --- Register HW_LCDIF_CTRL1, field RSRVD1 */

#define BP_LCDIF_CTRL1_RSRVD1      28
#define BM_LCDIF_CTRL1_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CTRL1_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_LCDIF_CTRL1_RSRVD1)
#else
#define BF_LCDIF_CTRL1_RSRVD1(v)   (((v) << 28) & BM_LCDIF_CTRL1_RSRVD1)
#endif
/* --- Register HW_LCDIF_CTRL1, field COMBINE_MPU_WR_STRB */

#define BP_LCDIF_CTRL1_COMBINE_MPU_WR_STRB      27
#define BM_LCDIF_CTRL1_COMBINE_MPU_WR_STRB      0x08000000

#define BF_LCDIF_CTRL1_COMBINE_MPU_WR_STRB(v)   (((v) << 27) & BM_LCDIF_CTRL1_COMBINE_MPU_WR_STRB)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_COMBINE_MPU_WR_STRB(v)   BF_CS1(LCDIF_CTRL1, COMBINE_MPU_WR_STRB, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field BM_ERROR_IRQ_EN */

#define BP_LCDIF_CTRL1_BM_ERROR_IRQ_EN      26
#define BM_LCDIF_CTRL1_BM_ERROR_IRQ_EN      0x04000000

#define BF_LCDIF_CTRL1_BM_ERROR_IRQ_EN(v)   (((v) << 26) & BM_LCDIF_CTRL1_BM_ERROR_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_BM_ERROR_IRQ_EN(v)   BF_CS1(LCDIF_CTRL1, BM_ERROR_IRQ_EN, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field BM_ERROR_IRQ */

#define BP_LCDIF_CTRL1_BM_ERROR_IRQ      25
#define BM_LCDIF_CTRL1_BM_ERROR_IRQ      0x02000000

#define BF_LCDIF_CTRL1_BM_ERROR_IRQ(v)   (((v) << 25) & BM_LCDIF_CTRL1_BM_ERROR_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_BM_ERROR_IRQ(v)   BF_CS1(LCDIF_CTRL1, BM_ERROR_IRQ, v)
#endif

#define BV_LCDIF_CTRL1_BM_ERROR_IRQ__NO_REQUEST  0x0
#define BV_LCDIF_CTRL1_BM_ERROR_IRQ__REQUEST     0x1

/* --- Register HW_LCDIF_CTRL1, field RECOVER_ON_UNDERFLOW */

#define BP_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW      24
#define BM_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW      0x01000000

#define BF_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW(v)   (((v) << 24) & BM_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_RECOVER_ON_UNDERFLOW(v)   BF_CS1(LCDIF_CTRL1, RECOVER_ON_UNDERFLOW, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field INTERLACE_FIELDS */

#define BP_LCDIF_CTRL1_INTERLACE_FIELDS      23
#define BM_LCDIF_CTRL1_INTERLACE_FIELDS      0x00800000

#define BF_LCDIF_CTRL1_INTERLACE_FIELDS(v)   (((v) << 23) & BM_LCDIF_CTRL1_INTERLACE_FIELDS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_INTERLACE_FIELDS(v)   BF_CS1(LCDIF_CTRL1, INTERLACE_FIELDS, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field START_INTERLACE_FROM_SECOND_FIELD */

#define BP_LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD      22
#define BM_LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD      0x00400000

#define BF_LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD(v)   (((v) << 22) & BM_LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_START_INTERLACE_FROM_SECOND_FIELD(v)   BF_CS1(LCDIF_CTRL1, START_INTERLACE_FROM_SECOND_FIELD, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field FIFO_CLEAR */

#define BP_LCDIF_CTRL1_FIFO_CLEAR      21
#define BM_LCDIF_CTRL1_FIFO_CLEAR      0x00200000

#define BF_LCDIF_CTRL1_FIFO_CLEAR(v)   (((v) << 21) & BM_LCDIF_CTRL1_FIFO_CLEAR)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_FIFO_CLEAR(v)   BF_CS1(LCDIF_CTRL1, FIFO_CLEAR, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field IRQ_ON_ALTERNATE_FIELDS */

#define BP_LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS      20
#define BM_LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS      0x00100000

#define BF_LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS(v)   (((v) << 20) & BM_LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_IRQ_ON_ALTERNATE_FIELDS(v)   BF_CS1(LCDIF_CTRL1, IRQ_ON_ALTERNATE_FIELDS, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field BYTE_PACKING_FORMAT */

#define BP_LCDIF_CTRL1_BYTE_PACKING_FORMAT      16
#define BM_LCDIF_CTRL1_BYTE_PACKING_FORMAT      0x000F0000

#define BF_LCDIF_CTRL1_BYTE_PACKING_FORMAT(v)   (((v) << 16) & BM_LCDIF_CTRL1_BYTE_PACKING_FORMAT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_BYTE_PACKING_FORMAT(v)   BF_CS1(LCDIF_CTRL1, BYTE_PACKING_FORMAT, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field OVERFLOW_IRQ_EN */

#define BP_LCDIF_CTRL1_OVERFLOW_IRQ_EN      15
#define BM_LCDIF_CTRL1_OVERFLOW_IRQ_EN      0x00008000

#define BF_LCDIF_CTRL1_OVERFLOW_IRQ_EN(v)   (((v) << 15) & BM_LCDIF_CTRL1_OVERFLOW_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_OVERFLOW_IRQ_EN(v)   BF_CS1(LCDIF_CTRL1, OVERFLOW_IRQ_EN, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field UNDERFLOW_IRQ_EN */

#define BP_LCDIF_CTRL1_UNDERFLOW_IRQ_EN      14
#define BM_LCDIF_CTRL1_UNDERFLOW_IRQ_EN      0x00004000

#define BF_LCDIF_CTRL1_UNDERFLOW_IRQ_EN(v)   (((v) << 14) & BM_LCDIF_CTRL1_UNDERFLOW_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_UNDERFLOW_IRQ_EN(v)   BF_CS1(LCDIF_CTRL1, UNDERFLOW_IRQ_EN, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field CUR_FRAME_DONE_IRQ_EN */

#define BP_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN      13
#define BM_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN      0x00002000

#define BF_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN(v)   (((v) << 13) & BM_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ_EN(v)   BF_CS1(LCDIF_CTRL1, CUR_FRAME_DONE_IRQ_EN, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field VSYNC_EDGE_IRQ_EN */

#define BP_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN      12
#define BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN      0x00001000

#define BF_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN(v)   (((v) << 12) & BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_VSYNC_EDGE_IRQ_EN(v)   BF_CS1(LCDIF_CTRL1, VSYNC_EDGE_IRQ_EN, v)
#endif

/* --- Register HW_LCDIF_CTRL1, field OVERFLOW_IRQ */

#define BP_LCDIF_CTRL1_OVERFLOW_IRQ      11
#define BM_LCDIF_CTRL1_OVERFLOW_IRQ      0x00000800

#define BF_LCDIF_CTRL1_OVERFLOW_IRQ(v)   (((v) << 11) & BM_LCDIF_CTRL1_OVERFLOW_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_OVERFLOW_IRQ(v)   BF_CS1(LCDIF_CTRL1, OVERFLOW_IRQ, v)
#endif

#define BV_LCDIF_CTRL1_OVERFLOW_IRQ__NO_REQUEST  0x0
#define BV_LCDIF_CTRL1_OVERFLOW_IRQ__REQUEST     0x1

/* --- Register HW_LCDIF_CTRL1, field UNDERFLOW_IRQ */

#define BP_LCDIF_CTRL1_UNDERFLOW_IRQ      10
#define BM_LCDIF_CTRL1_UNDERFLOW_IRQ      0x00000400

#define BF_LCDIF_CTRL1_UNDERFLOW_IRQ(v)   (((v) << 10) & BM_LCDIF_CTRL1_UNDERFLOW_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_UNDERFLOW_IRQ(v)   BF_CS1(LCDIF_CTRL1, UNDERFLOW_IRQ, v)
#endif

#define BV_LCDIF_CTRL1_UNDERFLOW_IRQ__NO_REQUEST  0x0
#define BV_LCDIF_CTRL1_UNDERFLOW_IRQ__REQUEST     0x1

/* --- Register HW_LCDIF_CTRL1, field CUR_FRAME_DONE_IRQ */

#define BP_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ      9
#define BM_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ      0x00000200

#define BF_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ(v)   (((v) << 9) & BM_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ(v)   BF_CS1(LCDIF_CTRL1, CUR_FRAME_DONE_IRQ, v)
#endif

#define BV_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ__NO_REQUEST  0x0
#define BV_LCDIF_CTRL1_CUR_FRAME_DONE_IRQ__REQUEST     0x1

/* --- Register HW_LCDIF_CTRL1, field VSYNC_EDGE_IRQ */

#define BP_LCDIF_CTRL1_VSYNC_EDGE_IRQ      8
#define BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ      0x00000100

#define BF_LCDIF_CTRL1_VSYNC_EDGE_IRQ(v)   (((v) << 8) & BM_LCDIF_CTRL1_VSYNC_EDGE_IRQ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_VSYNC_EDGE_IRQ(v)   BF_CS1(LCDIF_CTRL1, VSYNC_EDGE_IRQ, v)
#endif

#define BV_LCDIF_CTRL1_VSYNC_EDGE_IRQ__NO_REQUEST  0x0
#define BV_LCDIF_CTRL1_VSYNC_EDGE_IRQ__REQUEST     0x1

/* --- Register HW_LCDIF_CTRL1, field RSRVD0 */

#define BP_LCDIF_CTRL1_RSRVD0      3
#define BM_LCDIF_CTRL1_RSRVD0      0x000000F8

#define BF_LCDIF_CTRL1_RSRVD0(v)   (((v) << 3) & BM_LCDIF_CTRL1_RSRVD0)
/* --- Register HW_LCDIF_CTRL1, field BUSY_ENABLE */

#define BP_LCDIF_CTRL1_BUSY_ENABLE      2
#define BM_LCDIF_CTRL1_BUSY_ENABLE      0x00000004

#define BF_LCDIF_CTRL1_BUSY_ENABLE(v)   (((v) << 2) & BM_LCDIF_CTRL1_BUSY_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_BUSY_ENABLE(v)   BF_CS1(LCDIF_CTRL1, BUSY_ENABLE, v)
#endif

#define BV_LCDIF_CTRL1_BUSY_ENABLE__BUSY_DISABLED  0x0
#define BV_LCDIF_CTRL1_BUSY_ENABLE__BUSY_ENABLED   0x1

/* --- Register HW_LCDIF_CTRL1, field MODE86 */

#define BP_LCDIF_CTRL1_MODE86      1
#define BM_LCDIF_CTRL1_MODE86      0x00000002

#define BF_LCDIF_CTRL1_MODE86(v)   (((v) << 1) & BM_LCDIF_CTRL1_MODE86)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_MODE86(v)   BF_CS1(LCDIF_CTRL1, MODE86, v)
#endif

#define BV_LCDIF_CTRL1_MODE86__8080_MODE  0x0
#define BV_LCDIF_CTRL1_MODE86__6800_MODE  0x1

/* --- Register HW_LCDIF_CTRL1, field RESET */

#define BP_LCDIF_CTRL1_RESET      0
#define BM_LCDIF_CTRL1_RESET      0x00000001

#define BF_LCDIF_CTRL1_RESET(v)   (((v) << 0) & BM_LCDIF_CTRL1_RESET)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL1_RESET(v)   BF_CS1(LCDIF_CTRL1, RESET, v)
#endif

#define BV_LCDIF_CTRL1_RESET__LCDRESET_LOW   0x0
#define BV_LCDIF_CTRL1_RESET__LCDRESET_HIGH  0x1



/*
 * HW_LCDIF_CTRL2 - LCDIF General Control2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0                          :  1;
        unsigned INITIAL_DUMMY_READ              :  3;
        unsigned READ_MODE_NUM_PACKED_SUBWORDS   :  3;
        unsigned RSRVD1                          :  1;
        unsigned READ_MODE_6_BIT_INPUT           :  1;
        unsigned READ_MODE_OUTPUT_IN_RGB_FORMAT  :  1;
        unsigned READ_PACK_DIR                   :  1;
        unsigned RSRVD2                          :  1;
        unsigned EVEN_LINE_PATTERN               :  3;
        unsigned RSRVD3                          :  1;
        unsigned ODD_LINE_PATTERN                :  3;
        unsigned RSRVD4                          :  1;
        unsigned BURST_LEN_8                     :  1;
        unsigned OUTSTANDING_REQS                :  3;
        unsigned RSRVD5                          :  8;
    } B;
} hw_lcdif_ctrl2_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CTRL2 register
 */
#define HW_LCDIF_CTRL2_ADDR         (REGS_LCDIF_BASE + 0x20)
#define HW_LCDIF_CTRL2_SET_ADDR     (HW_LCDIF_CTRL2_ADDR + 4)
#define HW_LCDIF_CTRL2_CLR_ADDR     (HW_LCDIF_CTRL2_ADDR + 8)
#define HW_LCDIF_CTRL2_TOG_ADDR     (HW_LCDIF_CTRL2_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CTRL2           (*(volatile hw_lcdif_ctrl2_t *) HW_LCDIF_CTRL2_ADDR)
#define HW_LCDIF_CTRL2_RD()      (HW_LCDIF_CTRL2.U)
#define HW_LCDIF_CTRL2_WR(v)     (HW_LCDIF_CTRL2.U = (v))
#define HW_LCDIF_CTRL2_SET(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL2_SET_ADDR) = (v))
#define HW_LCDIF_CTRL2_CLR(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL2_CLR_ADDR) = (v))
#define HW_LCDIF_CTRL2_TOG(v)    ((*(volatile reg32_t *) HW_LCDIF_CTRL2_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_LCDIF_CTRL2 bitfields
 */
/* --- Register HW_LCDIF_CTRL2, field RSRVD5 */

#define BP_LCDIF_CTRL2_RSRVD5      24
#define BM_LCDIF_CTRL2_RSRVD5      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CTRL2_RSRVD5(v)   ((((reg32_t) v) << 24) & BM_LCDIF_CTRL2_RSRVD5)
#else
#define BF_LCDIF_CTRL2_RSRVD5(v)   (((v) << 24) & BM_LCDIF_CTRL2_RSRVD5)
#endif
/* --- Register HW_LCDIF_CTRL2, field OUTSTANDING_REQS */

#define BP_LCDIF_CTRL2_OUTSTANDING_REQS      21
#define BM_LCDIF_CTRL2_OUTSTANDING_REQS      0x00E00000

#define BF_LCDIF_CTRL2_OUTSTANDING_REQS(v)   (((v) << 21) & BM_LCDIF_CTRL2_OUTSTANDING_REQS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_OUTSTANDING_REQS(v)   BF_CS1(LCDIF_CTRL2, OUTSTANDING_REQS, v)
#endif

#define BV_LCDIF_CTRL2_OUTSTANDING_REQS__REQ_1   0x0
#define BV_LCDIF_CTRL2_OUTSTANDING_REQS__REQ_2   0x1
#define BV_LCDIF_CTRL2_OUTSTANDING_REQS__REQ_4   0x2
#define BV_LCDIF_CTRL2_OUTSTANDING_REQS__REQ_8   0x3
#define BV_LCDIF_CTRL2_OUTSTANDING_REQS__REQ_16  0x4

/* --- Register HW_LCDIF_CTRL2, field BURST_LEN_8 */

#define BP_LCDIF_CTRL2_BURST_LEN_8      20
#define BM_LCDIF_CTRL2_BURST_LEN_8      0x00100000

#define BF_LCDIF_CTRL2_BURST_LEN_8(v)   (((v) << 20) & BM_LCDIF_CTRL2_BURST_LEN_8)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_BURST_LEN_8(v)   BF_CS1(LCDIF_CTRL2, BURST_LEN_8, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field RSRVD4 */

#define BP_LCDIF_CTRL2_RSRVD4      19
#define BM_LCDIF_CTRL2_RSRVD4      0x00080000

#define BF_LCDIF_CTRL2_RSRVD4(v)   (((v) << 19) & BM_LCDIF_CTRL2_RSRVD4)
/* --- Register HW_LCDIF_CTRL2, field ODD_LINE_PATTERN */

#define BP_LCDIF_CTRL2_ODD_LINE_PATTERN      16
#define BM_LCDIF_CTRL2_ODD_LINE_PATTERN      0x00070000

#define BF_LCDIF_CTRL2_ODD_LINE_PATTERN(v)   (((v) << 16) & BM_LCDIF_CTRL2_ODD_LINE_PATTERN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_ODD_LINE_PATTERN(v)   BF_CS1(LCDIF_CTRL2, ODD_LINE_PATTERN, v)
#endif

#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__RGB  0x0
#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__RBG  0x1
#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__GBR  0x2
#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__GRB  0x3
#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__BRG  0x4
#define BV_LCDIF_CTRL2_ODD_LINE_PATTERN__BGR  0x5

/* --- Register HW_LCDIF_CTRL2, field RSRVD3 */

#define BP_LCDIF_CTRL2_RSRVD3      15
#define BM_LCDIF_CTRL2_RSRVD3      0x00008000

#define BF_LCDIF_CTRL2_RSRVD3(v)   (((v) << 15) & BM_LCDIF_CTRL2_RSRVD3)
/* --- Register HW_LCDIF_CTRL2, field EVEN_LINE_PATTERN */

#define BP_LCDIF_CTRL2_EVEN_LINE_PATTERN      12
#define BM_LCDIF_CTRL2_EVEN_LINE_PATTERN      0x00007000

#define BF_LCDIF_CTRL2_EVEN_LINE_PATTERN(v)   (((v) << 12) & BM_LCDIF_CTRL2_EVEN_LINE_PATTERN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_EVEN_LINE_PATTERN(v)   BF_CS1(LCDIF_CTRL2, EVEN_LINE_PATTERN, v)
#endif

#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__RGB  0x0
#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__RBG  0x1
#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__GBR  0x2
#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__GRB  0x3
#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__BRG  0x4
#define BV_LCDIF_CTRL2_EVEN_LINE_PATTERN__BGR  0x5

/* --- Register HW_LCDIF_CTRL2, field RSRVD2 */

#define BP_LCDIF_CTRL2_RSRVD2      11
#define BM_LCDIF_CTRL2_RSRVD2      0x00000800

#define BF_LCDIF_CTRL2_RSRVD2(v)   (((v) << 11) & BM_LCDIF_CTRL2_RSRVD2)
/* --- Register HW_LCDIF_CTRL2, field READ_PACK_DIR */

#define BP_LCDIF_CTRL2_READ_PACK_DIR      10
#define BM_LCDIF_CTRL2_READ_PACK_DIR      0x00000400

#define BF_LCDIF_CTRL2_READ_PACK_DIR(v)   (((v) << 10) & BM_LCDIF_CTRL2_READ_PACK_DIR)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_READ_PACK_DIR(v)   BF_CS1(LCDIF_CTRL2, READ_PACK_DIR, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field READ_MODE_OUTPUT_IN_RGB_FORMAT */

#define BP_LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT      9
#define BM_LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT      0x00000200

#define BF_LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT(v)   (((v) << 9) & BM_LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_READ_MODE_OUTPUT_IN_RGB_FORMAT(v)   BF_CS1(LCDIF_CTRL2, READ_MODE_OUTPUT_IN_RGB_FORMAT, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field READ_MODE_6_BIT_INPUT */

#define BP_LCDIF_CTRL2_READ_MODE_6_BIT_INPUT      8
#define BM_LCDIF_CTRL2_READ_MODE_6_BIT_INPUT      0x00000100

#define BF_LCDIF_CTRL2_READ_MODE_6_BIT_INPUT(v)   (((v) << 8) & BM_LCDIF_CTRL2_READ_MODE_6_BIT_INPUT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_READ_MODE_6_BIT_INPUT(v)   BF_CS1(LCDIF_CTRL2, READ_MODE_6_BIT_INPUT, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field RSRVD1 */

#define BP_LCDIF_CTRL2_RSRVD1      7
#define BM_LCDIF_CTRL2_RSRVD1      0x00000080

#define BF_LCDIF_CTRL2_RSRVD1(v)   (((v) << 7) & BM_LCDIF_CTRL2_RSRVD1)
/* --- Register HW_LCDIF_CTRL2, field READ_MODE_NUM_PACKED_SUBWORDS */

#define BP_LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS      4
#define BM_LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS      0x00000070

#define BF_LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS(v)   (((v) << 4) & BM_LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_READ_MODE_NUM_PACKED_SUBWORDS(v)   BF_CS1(LCDIF_CTRL2, READ_MODE_NUM_PACKED_SUBWORDS, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field INITIAL_DUMMY_READ */

#define BP_LCDIF_CTRL2_INITIAL_DUMMY_READ      1
#define BM_LCDIF_CTRL2_INITIAL_DUMMY_READ      0x0000000E

#define BF_LCDIF_CTRL2_INITIAL_DUMMY_READ(v)   (((v) << 1) & BM_LCDIF_CTRL2_INITIAL_DUMMY_READ)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CTRL2_INITIAL_DUMMY_READ(v)   BF_CS1(LCDIF_CTRL2, INITIAL_DUMMY_READ, v)
#endif

/* --- Register HW_LCDIF_CTRL2, field RSRVD0 */

#define BP_LCDIF_CTRL2_RSRVD0      0
#define BM_LCDIF_CTRL2_RSRVD0      0x00000001

#define BF_LCDIF_CTRL2_RSRVD0(v)   (((v) << 0) & BM_LCDIF_CTRL2_RSRVD0)


/*
 * HW_LCDIF_TRANSFER_COUNT - LCDIF Horizontal and Vertical Valid Data Count Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned H_COUNT  : 16;
        unsigned V_COUNT  : 16;
    } B;
} hw_lcdif_transfer_count_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_TRANSFER_COUNT register
 */
#define HW_LCDIF_TRANSFER_COUNT_ADDR         (REGS_LCDIF_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_TRANSFER_COUNT           (*(volatile hw_lcdif_transfer_count_t *) HW_LCDIF_TRANSFER_COUNT_ADDR)
#define HW_LCDIF_TRANSFER_COUNT_RD()      (HW_LCDIF_TRANSFER_COUNT.U)
#define HW_LCDIF_TRANSFER_COUNT_WR(v)     (HW_LCDIF_TRANSFER_COUNT.U = (v))
#define HW_LCDIF_TRANSFER_COUNT_SET(v)    (HW_LCDIF_TRANSFER_COUNT_WR(HW_LCDIF_TRANSFER_COUNT_RD() |  (v)))
#define HW_LCDIF_TRANSFER_COUNT_CLR(v)    (HW_LCDIF_TRANSFER_COUNT_WR(HW_LCDIF_TRANSFER_COUNT_RD() & ~(v)))
#define HW_LCDIF_TRANSFER_COUNT_TOG(v)    (HW_LCDIF_TRANSFER_COUNT_WR(HW_LCDIF_TRANSFER_COUNT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_TRANSFER_COUNT bitfields
 */
/* --- Register HW_LCDIF_TRANSFER_COUNT, field V_COUNT */

#define BP_LCDIF_TRANSFER_COUNT_V_COUNT      16
#define BM_LCDIF_TRANSFER_COUNT_V_COUNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_TRANSFER_COUNT_V_COUNT(v)   ((((reg32_t) v) << 16) & BM_LCDIF_TRANSFER_COUNT_V_COUNT)
#else
#define BF_LCDIF_TRANSFER_COUNT_V_COUNT(v)   (((v) << 16) & BM_LCDIF_TRANSFER_COUNT_V_COUNT)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TRANSFER_COUNT_V_COUNT(v)   (HW_LCDIF_TRANSFER_COUNT.B.V_COUNT = (v))
#endif

/* --- Register HW_LCDIF_TRANSFER_COUNT, field H_COUNT */

#define BP_LCDIF_TRANSFER_COUNT_H_COUNT      0
#define BM_LCDIF_TRANSFER_COUNT_H_COUNT      0x0000FFFF

#define BF_LCDIF_TRANSFER_COUNT_H_COUNT(v)   (((v) << 0) & BM_LCDIF_TRANSFER_COUNT_H_COUNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TRANSFER_COUNT_H_COUNT(v)   (HW_LCDIF_TRANSFER_COUNT.B.H_COUNT = (v))
#endif



/*
 * HW_LCDIF_CUR_BUF - LCD Interface Current Buffer Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_lcdif_cur_buf_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CUR_BUF register
 */
#define HW_LCDIF_CUR_BUF_ADDR         (REGS_LCDIF_BASE + 0x40)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CUR_BUF           (*(volatile hw_lcdif_cur_buf_t *) HW_LCDIF_CUR_BUF_ADDR)
#define HW_LCDIF_CUR_BUF_RD()      (HW_LCDIF_CUR_BUF.U)
#define HW_LCDIF_CUR_BUF_WR(v)     (HW_LCDIF_CUR_BUF.U = (v))
#define HW_LCDIF_CUR_BUF_SET(v)    (HW_LCDIF_CUR_BUF_WR(HW_LCDIF_CUR_BUF_RD() |  (v)))
#define HW_LCDIF_CUR_BUF_CLR(v)    (HW_LCDIF_CUR_BUF_WR(HW_LCDIF_CUR_BUF_RD() & ~(v)))
#define HW_LCDIF_CUR_BUF_TOG(v)    (HW_LCDIF_CUR_BUF_WR(HW_LCDIF_CUR_BUF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CUR_BUF bitfields
 */
/* --- Register HW_LCDIF_CUR_BUF, field ADDR */

#define BP_LCDIF_CUR_BUF_ADDR      0
#define BM_LCDIF_CUR_BUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CUR_BUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_LCDIF_CUR_BUF_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CUR_BUF_ADDR(v)   (HW_LCDIF_CUR_BUF.B.ADDR = (v))
#endif



/*
 * HW_LCDIF_NEXT_BUF - LCD Interface Next Buffer Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_lcdif_next_buf_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_NEXT_BUF register
 */
#define HW_LCDIF_NEXT_BUF_ADDR         (REGS_LCDIF_BASE + 0x50)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_NEXT_BUF           (*(volatile hw_lcdif_next_buf_t *) HW_LCDIF_NEXT_BUF_ADDR)
#define HW_LCDIF_NEXT_BUF_RD()      (HW_LCDIF_NEXT_BUF.U)
#define HW_LCDIF_NEXT_BUF_WR(v)     (HW_LCDIF_NEXT_BUF.U = (v))
#define HW_LCDIF_NEXT_BUF_SET(v)    (HW_LCDIF_NEXT_BUF_WR(HW_LCDIF_NEXT_BUF_RD() |  (v)))
#define HW_LCDIF_NEXT_BUF_CLR(v)    (HW_LCDIF_NEXT_BUF_WR(HW_LCDIF_NEXT_BUF_RD() & ~(v)))
#define HW_LCDIF_NEXT_BUF_TOG(v)    (HW_LCDIF_NEXT_BUF_WR(HW_LCDIF_NEXT_BUF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_NEXT_BUF bitfields
 */
/* --- Register HW_LCDIF_NEXT_BUF, field ADDR */

#define BP_LCDIF_NEXT_BUF_ADDR      0
#define BM_LCDIF_NEXT_BUF_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_NEXT_BUF_ADDR(v)   ((reg32_t) v)
#else
#define BF_LCDIF_NEXT_BUF_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_NEXT_BUF_ADDR(v)   (HW_LCDIF_NEXT_BUF.B.ADDR = (v))
#endif



/*
 * HW_LCDIF_TIMING - LCD Interface Timing Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA_SETUP  :  8;
        unsigned DATA_HOLD   :  8;
        unsigned CMD_SETUP   :  8;
        unsigned CMD_HOLD    :  8;
    } B;
} hw_lcdif_timing_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_TIMING register
 */
#define HW_LCDIF_TIMING_ADDR         (REGS_LCDIF_BASE + 0x60)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_TIMING           (*(volatile hw_lcdif_timing_t *) HW_LCDIF_TIMING_ADDR)
#define HW_LCDIF_TIMING_RD()      (HW_LCDIF_TIMING.U)
#define HW_LCDIF_TIMING_WR(v)     (HW_LCDIF_TIMING.U = (v))
#define HW_LCDIF_TIMING_SET(v)    (HW_LCDIF_TIMING_WR(HW_LCDIF_TIMING_RD() |  (v)))
#define HW_LCDIF_TIMING_CLR(v)    (HW_LCDIF_TIMING_WR(HW_LCDIF_TIMING_RD() & ~(v)))
#define HW_LCDIF_TIMING_TOG(v)    (HW_LCDIF_TIMING_WR(HW_LCDIF_TIMING_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_TIMING bitfields
 */
/* --- Register HW_LCDIF_TIMING, field CMD_HOLD */

#define BP_LCDIF_TIMING_CMD_HOLD      24
#define BM_LCDIF_TIMING_CMD_HOLD      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_TIMING_CMD_HOLD(v)   ((((reg32_t) v) << 24) & BM_LCDIF_TIMING_CMD_HOLD)
#else
#define BF_LCDIF_TIMING_CMD_HOLD(v)   (((v) << 24) & BM_LCDIF_TIMING_CMD_HOLD)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TIMING_CMD_HOLD(v)   (HW_LCDIF_TIMING.B.CMD_HOLD = (v))
#endif

/* --- Register HW_LCDIF_TIMING, field CMD_SETUP */

#define BP_LCDIF_TIMING_CMD_SETUP      16
#define BM_LCDIF_TIMING_CMD_SETUP      0x00FF0000

#define BF_LCDIF_TIMING_CMD_SETUP(v)   (((v) << 16) & BM_LCDIF_TIMING_CMD_SETUP)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TIMING_CMD_SETUP(v)   (HW_LCDIF_TIMING.B.CMD_SETUP = (v))
#endif

/* --- Register HW_LCDIF_TIMING, field DATA_HOLD */

#define BP_LCDIF_TIMING_DATA_HOLD      8
#define BM_LCDIF_TIMING_DATA_HOLD      0x0000FF00

#define BF_LCDIF_TIMING_DATA_HOLD(v)   (((v) << 8) & BM_LCDIF_TIMING_DATA_HOLD)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TIMING_DATA_HOLD(v)   (HW_LCDIF_TIMING.B.DATA_HOLD = (v))
#endif

/* --- Register HW_LCDIF_TIMING, field DATA_SETUP */

#define BP_LCDIF_TIMING_DATA_SETUP      0
#define BM_LCDIF_TIMING_DATA_SETUP      0x000000FF

#define BF_LCDIF_TIMING_DATA_SETUP(v)   (((v) << 0) & BM_LCDIF_TIMING_DATA_SETUP)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_TIMING_DATA_SETUP(v)   (HW_LCDIF_TIMING.B.DATA_SETUP = (v))
#endif



/*
 * HW_LCDIF_VDCTRL0 - LCDIF VSYNC Mode and Dotclk Mode Control Register0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VSYNC_PULSE_WIDTH       : 18;
        unsigned HALF_LINE_MODE          :  1;
        unsigned HALF_LINE               :  1;
        unsigned VSYNC_PULSE_WIDTH_UNIT  :  1;
        unsigned VSYNC_PERIOD_UNIT       :  1;
        unsigned RSRVD1                  :  2;
        unsigned ENABLE_POL              :  1;
        unsigned DOTCLK_POL              :  1;
        unsigned HSYNC_POL               :  1;
        unsigned VSYNC_POL               :  1;
        unsigned ENABLE_PRESENT          :  1;
        unsigned VSYNC_OEB               :  1;
        unsigned RSRVD2                  :  2;
    } B;
} hw_lcdif_vdctrl0_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VDCTRL0 register
 */
#define HW_LCDIF_VDCTRL0_ADDR         (REGS_LCDIF_BASE + 0x70)
#define HW_LCDIF_VDCTRL0_SET_ADDR     (HW_LCDIF_VDCTRL0_ADDR + 4)
#define HW_LCDIF_VDCTRL0_CLR_ADDR     (HW_LCDIF_VDCTRL0_ADDR + 8)
#define HW_LCDIF_VDCTRL0_TOG_ADDR     (HW_LCDIF_VDCTRL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VDCTRL0           (*(volatile hw_lcdif_vdctrl0_t *) HW_LCDIF_VDCTRL0_ADDR)
#define HW_LCDIF_VDCTRL0_RD()      (HW_LCDIF_VDCTRL0.U)
#define HW_LCDIF_VDCTRL0_WR(v)     (HW_LCDIF_VDCTRL0.U = (v))
#define HW_LCDIF_VDCTRL0_SET(v)    ((*(volatile reg32_t *) HW_LCDIF_VDCTRL0_SET_ADDR) = (v))
#define HW_LCDIF_VDCTRL0_CLR(v)    ((*(volatile reg32_t *) HW_LCDIF_VDCTRL0_CLR_ADDR) = (v))
#define HW_LCDIF_VDCTRL0_TOG(v)    ((*(volatile reg32_t *) HW_LCDIF_VDCTRL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_LCDIF_VDCTRL0 bitfields
 */
/* --- Register HW_LCDIF_VDCTRL0, field RSRVD2 */

#define BP_LCDIF_VDCTRL0_RSRVD2      30
#define BM_LCDIF_VDCTRL0_RSRVD2      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VDCTRL0_RSRVD2(v)   ((((reg32_t) v) << 30) & BM_LCDIF_VDCTRL0_RSRVD2)
#else
#define BF_LCDIF_VDCTRL0_RSRVD2(v)   (((v) << 30) & BM_LCDIF_VDCTRL0_RSRVD2)
#endif
/* --- Register HW_LCDIF_VDCTRL0, field VSYNC_OEB */

#define BP_LCDIF_VDCTRL0_VSYNC_OEB      29
#define BM_LCDIF_VDCTRL0_VSYNC_OEB      0x20000000

#define BF_LCDIF_VDCTRL0_VSYNC_OEB(v)   (((v) << 29) & BM_LCDIF_VDCTRL0_VSYNC_OEB)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_VSYNC_OEB(v)   BF_CS1(LCDIF_VDCTRL0, VSYNC_OEB, v)
#endif

#define BV_LCDIF_VDCTRL0_VSYNC_OEB__VSYNC_OUTPUT  0x0
#define BV_LCDIF_VDCTRL0_VSYNC_OEB__VSYNC_INPUT   0x1

/* --- Register HW_LCDIF_VDCTRL0, field ENABLE_PRESENT */

#define BP_LCDIF_VDCTRL0_ENABLE_PRESENT      28
#define BM_LCDIF_VDCTRL0_ENABLE_PRESENT      0x10000000

#define BF_LCDIF_VDCTRL0_ENABLE_PRESENT(v)   (((v) << 28) & BM_LCDIF_VDCTRL0_ENABLE_PRESENT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_ENABLE_PRESENT(v)   BF_CS1(LCDIF_VDCTRL0, ENABLE_PRESENT, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field VSYNC_POL */

#define BP_LCDIF_VDCTRL0_VSYNC_POL      27
#define BM_LCDIF_VDCTRL0_VSYNC_POL      0x08000000

#define BF_LCDIF_VDCTRL0_VSYNC_POL(v)   (((v) << 27) & BM_LCDIF_VDCTRL0_VSYNC_POL)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_VSYNC_POL(v)   BF_CS1(LCDIF_VDCTRL0, VSYNC_POL, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field HSYNC_POL */

#define BP_LCDIF_VDCTRL0_HSYNC_POL      26
#define BM_LCDIF_VDCTRL0_HSYNC_POL      0x04000000

#define BF_LCDIF_VDCTRL0_HSYNC_POL(v)   (((v) << 26) & BM_LCDIF_VDCTRL0_HSYNC_POL)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_HSYNC_POL(v)   BF_CS1(LCDIF_VDCTRL0, HSYNC_POL, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field DOTCLK_POL */

#define BP_LCDIF_VDCTRL0_DOTCLK_POL      25
#define BM_LCDIF_VDCTRL0_DOTCLK_POL      0x02000000

#define BF_LCDIF_VDCTRL0_DOTCLK_POL(v)   (((v) << 25) & BM_LCDIF_VDCTRL0_DOTCLK_POL)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_DOTCLK_POL(v)   BF_CS1(LCDIF_VDCTRL0, DOTCLK_POL, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field ENABLE_POL */

#define BP_LCDIF_VDCTRL0_ENABLE_POL      24
#define BM_LCDIF_VDCTRL0_ENABLE_POL      0x01000000

#define BF_LCDIF_VDCTRL0_ENABLE_POL(v)   (((v) << 24) & BM_LCDIF_VDCTRL0_ENABLE_POL)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_ENABLE_POL(v)   BF_CS1(LCDIF_VDCTRL0, ENABLE_POL, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field RSRVD1 */

#define BP_LCDIF_VDCTRL0_RSRVD1      22
#define BM_LCDIF_VDCTRL0_RSRVD1      0x00C00000

#define BF_LCDIF_VDCTRL0_RSRVD1(v)   (((v) << 22) & BM_LCDIF_VDCTRL0_RSRVD1)
/* --- Register HW_LCDIF_VDCTRL0, field VSYNC_PERIOD_UNIT */

#define BP_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT      21
#define BM_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT      0x00200000

#define BF_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT(v)   (((v) << 21) & BM_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_VSYNC_PERIOD_UNIT(v)   BF_CS1(LCDIF_VDCTRL0, VSYNC_PERIOD_UNIT, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field VSYNC_PULSE_WIDTH_UNIT */

#define BP_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT      20
#define BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT      0x00100000

#define BF_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT(v)   (((v) << 20) & BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH_UNIT(v)   BF_CS1(LCDIF_VDCTRL0, VSYNC_PULSE_WIDTH_UNIT, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field HALF_LINE */

#define BP_LCDIF_VDCTRL0_HALF_LINE      19
#define BM_LCDIF_VDCTRL0_HALF_LINE      0x00080000

#define BF_LCDIF_VDCTRL0_HALF_LINE(v)   (((v) << 19) & BM_LCDIF_VDCTRL0_HALF_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_HALF_LINE(v)   BF_CS1(LCDIF_VDCTRL0, HALF_LINE, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field HALF_LINE_MODE */

#define BP_LCDIF_VDCTRL0_HALF_LINE_MODE      18
#define BM_LCDIF_VDCTRL0_HALF_LINE_MODE      0x00040000

#define BF_LCDIF_VDCTRL0_HALF_LINE_MODE(v)   (((v) << 18) & BM_LCDIF_VDCTRL0_HALF_LINE_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_HALF_LINE_MODE(v)   BF_CS1(LCDIF_VDCTRL0, HALF_LINE_MODE, v)
#endif

/* --- Register HW_LCDIF_VDCTRL0, field VSYNC_PULSE_WIDTH */

#define BP_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH      0
#define BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH      0x0003FFFF

#define BF_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH(v)   (((v) << 0) & BM_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL0_VSYNC_PULSE_WIDTH(v)   BF_CS1(LCDIF_VDCTRL0, VSYNC_PULSE_WIDTH, v)
#endif



/*
 * HW_LCDIF_VDCTRL1 - LCDIF VSYNC Mode and Dotclk Mode Control Register1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VSYNC_PERIOD  : 32;
    } B;
} hw_lcdif_vdctrl1_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VDCTRL1 register
 */
#define HW_LCDIF_VDCTRL1_ADDR         (REGS_LCDIF_BASE + 0x80)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VDCTRL1           (*(volatile hw_lcdif_vdctrl1_t *) HW_LCDIF_VDCTRL1_ADDR)
#define HW_LCDIF_VDCTRL1_RD()      (HW_LCDIF_VDCTRL1.U)
#define HW_LCDIF_VDCTRL1_WR(v)     (HW_LCDIF_VDCTRL1.U = (v))
#define HW_LCDIF_VDCTRL1_SET(v)    (HW_LCDIF_VDCTRL1_WR(HW_LCDIF_VDCTRL1_RD() |  (v)))
#define HW_LCDIF_VDCTRL1_CLR(v)    (HW_LCDIF_VDCTRL1_WR(HW_LCDIF_VDCTRL1_RD() & ~(v)))
#define HW_LCDIF_VDCTRL1_TOG(v)    (HW_LCDIF_VDCTRL1_WR(HW_LCDIF_VDCTRL1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_VDCTRL1 bitfields
 */
/* --- Register HW_LCDIF_VDCTRL1, field VSYNC_PERIOD */

#define BP_LCDIF_VDCTRL1_VSYNC_PERIOD      0
#define BM_LCDIF_VDCTRL1_VSYNC_PERIOD      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VDCTRL1_VSYNC_PERIOD(v)   ((reg32_t) v)
#else
#define BF_LCDIF_VDCTRL1_VSYNC_PERIOD(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL1_VSYNC_PERIOD(v)   (HW_LCDIF_VDCTRL1.B.VSYNC_PERIOD = (v))
#endif



/*
 * HW_LCDIF_VDCTRL2 - LCDIF VSYNC Mode and Dotclk Mode Control Register2
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned HSYNC_PERIOD       : 18;
        unsigned HSYNC_PULSE_WIDTH  : 14;
    } B;
} hw_lcdif_vdctrl2_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VDCTRL2 register
 */
#define HW_LCDIF_VDCTRL2_ADDR         (REGS_LCDIF_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VDCTRL2           (*(volatile hw_lcdif_vdctrl2_t *) HW_LCDIF_VDCTRL2_ADDR)
#define HW_LCDIF_VDCTRL2_RD()      (HW_LCDIF_VDCTRL2.U)
#define HW_LCDIF_VDCTRL2_WR(v)     (HW_LCDIF_VDCTRL2.U = (v))
#define HW_LCDIF_VDCTRL2_SET(v)    (HW_LCDIF_VDCTRL2_WR(HW_LCDIF_VDCTRL2_RD() |  (v)))
#define HW_LCDIF_VDCTRL2_CLR(v)    (HW_LCDIF_VDCTRL2_WR(HW_LCDIF_VDCTRL2_RD() & ~(v)))
#define HW_LCDIF_VDCTRL2_TOG(v)    (HW_LCDIF_VDCTRL2_WR(HW_LCDIF_VDCTRL2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_VDCTRL2 bitfields
 */
/* --- Register HW_LCDIF_VDCTRL2, field HSYNC_PULSE_WIDTH */

#define BP_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH      18
#define BM_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH      0xFFFC0000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH(v)   ((((reg32_t) v) << 18) & BM_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH)
#else
#define BF_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH(v)   (((v) << 18) & BM_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL2_HSYNC_PULSE_WIDTH(v)   BF_CS1(LCDIF_VDCTRL2, HSYNC_PULSE_WIDTH, v)
#endif

/* --- Register HW_LCDIF_VDCTRL2, field HSYNC_PERIOD */

#define BP_LCDIF_VDCTRL2_HSYNC_PERIOD      0
#define BM_LCDIF_VDCTRL2_HSYNC_PERIOD      0x0003FFFF

#define BF_LCDIF_VDCTRL2_HSYNC_PERIOD(v)   (((v) << 0) & BM_LCDIF_VDCTRL2_HSYNC_PERIOD)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL2_HSYNC_PERIOD(v)   BF_CS1(LCDIF_VDCTRL2, HSYNC_PERIOD, v)
#endif



/*
 * HW_LCDIF_VDCTRL3 - LCDIF VSYNC Mode and Dotclk Mode Control Register3
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VERTICAL_WAIT_CNT    : 16;
        unsigned HORIZONTAL_WAIT_CNT  : 12;
        unsigned VSYNC_ONLY           :  1;
        unsigned MUX_SYNC_SIGNALS     :  1;
        unsigned RSRVD0               :  2;
    } B;
} hw_lcdif_vdctrl3_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VDCTRL3 register
 */
#define HW_LCDIF_VDCTRL3_ADDR         (REGS_LCDIF_BASE + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VDCTRL3           (*(volatile hw_lcdif_vdctrl3_t *) HW_LCDIF_VDCTRL3_ADDR)
#define HW_LCDIF_VDCTRL3_RD()      (HW_LCDIF_VDCTRL3.U)
#define HW_LCDIF_VDCTRL3_WR(v)     (HW_LCDIF_VDCTRL3.U = (v))
#define HW_LCDIF_VDCTRL3_SET(v)    (HW_LCDIF_VDCTRL3_WR(HW_LCDIF_VDCTRL3_RD() |  (v)))
#define HW_LCDIF_VDCTRL3_CLR(v)    (HW_LCDIF_VDCTRL3_WR(HW_LCDIF_VDCTRL3_RD() & ~(v)))
#define HW_LCDIF_VDCTRL3_TOG(v)    (HW_LCDIF_VDCTRL3_WR(HW_LCDIF_VDCTRL3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_VDCTRL3 bitfields
 */
/* --- Register HW_LCDIF_VDCTRL3, field RSRVD0 */

#define BP_LCDIF_VDCTRL3_RSRVD0      30
#define BM_LCDIF_VDCTRL3_RSRVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VDCTRL3_RSRVD0(v)   ((((reg32_t) v) << 30) & BM_LCDIF_VDCTRL3_RSRVD0)
#else
#define BF_LCDIF_VDCTRL3_RSRVD0(v)   (((v) << 30) & BM_LCDIF_VDCTRL3_RSRVD0)
#endif
/* --- Register HW_LCDIF_VDCTRL3, field MUX_SYNC_SIGNALS */

#define BP_LCDIF_VDCTRL3_MUX_SYNC_SIGNALS      29
#define BM_LCDIF_VDCTRL3_MUX_SYNC_SIGNALS      0x20000000

#define BF_LCDIF_VDCTRL3_MUX_SYNC_SIGNALS(v)   (((v) << 29) & BM_LCDIF_VDCTRL3_MUX_SYNC_SIGNALS)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL3_MUX_SYNC_SIGNALS(v)   BF_CS1(LCDIF_VDCTRL3, MUX_SYNC_SIGNALS, v)
#endif

/* --- Register HW_LCDIF_VDCTRL3, field VSYNC_ONLY */

#define BP_LCDIF_VDCTRL3_VSYNC_ONLY      28
#define BM_LCDIF_VDCTRL3_VSYNC_ONLY      0x10000000

#define BF_LCDIF_VDCTRL3_VSYNC_ONLY(v)   (((v) << 28) & BM_LCDIF_VDCTRL3_VSYNC_ONLY)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL3_VSYNC_ONLY(v)   BF_CS1(LCDIF_VDCTRL3, VSYNC_ONLY, v)
#endif

/* --- Register HW_LCDIF_VDCTRL3, field HORIZONTAL_WAIT_CNT */

#define BP_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT      16
#define BM_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT      0x0FFF0000

#define BF_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT(v)   (((v) << 16) & BM_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL3_HORIZONTAL_WAIT_CNT(v)   BF_CS1(LCDIF_VDCTRL3, HORIZONTAL_WAIT_CNT, v)
#endif

/* --- Register HW_LCDIF_VDCTRL3, field VERTICAL_WAIT_CNT */

#define BP_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT      0
#define BM_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT      0x0000FFFF

#define BF_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT(v)   (((v) << 0) & BM_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL3_VERTICAL_WAIT_CNT(v)   (HW_LCDIF_VDCTRL3.B.VERTICAL_WAIT_CNT = (v))
#endif



/*
 * HW_LCDIF_VDCTRL4 - LCDIF VSYNC Mode and Dotclk Mode Control Register4
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DOTCLK_H_VALID_DATA_CNT  : 18;
        unsigned SYNC_SIGNALS_ON          :  1;
        unsigned RSRVD0                   : 10;
        unsigned DOTCLK_DLY_SEL           :  3;
    } B;
} hw_lcdif_vdctrl4_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VDCTRL4 register
 */
#define HW_LCDIF_VDCTRL4_ADDR         (REGS_LCDIF_BASE + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VDCTRL4           (*(volatile hw_lcdif_vdctrl4_t *) HW_LCDIF_VDCTRL4_ADDR)
#define HW_LCDIF_VDCTRL4_RD()      (HW_LCDIF_VDCTRL4.U)
#define HW_LCDIF_VDCTRL4_WR(v)     (HW_LCDIF_VDCTRL4.U = (v))
#define HW_LCDIF_VDCTRL4_SET(v)    (HW_LCDIF_VDCTRL4_WR(HW_LCDIF_VDCTRL4_RD() |  (v)))
#define HW_LCDIF_VDCTRL4_CLR(v)    (HW_LCDIF_VDCTRL4_WR(HW_LCDIF_VDCTRL4_RD() & ~(v)))
#define HW_LCDIF_VDCTRL4_TOG(v)    (HW_LCDIF_VDCTRL4_WR(HW_LCDIF_VDCTRL4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_VDCTRL4 bitfields
 */
/* --- Register HW_LCDIF_VDCTRL4, field DOTCLK_DLY_SEL */

#define BP_LCDIF_VDCTRL4_DOTCLK_DLY_SEL      29
#define BM_LCDIF_VDCTRL4_DOTCLK_DLY_SEL      0xE0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VDCTRL4_DOTCLK_DLY_SEL(v)   ((((reg32_t) v) << 29) & BM_LCDIF_VDCTRL4_DOTCLK_DLY_SEL)
#else
#define BF_LCDIF_VDCTRL4_DOTCLK_DLY_SEL(v)   (((v) << 29) & BM_LCDIF_VDCTRL4_DOTCLK_DLY_SEL)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL4_DOTCLK_DLY_SEL(v)   BF_CS1(LCDIF_VDCTRL4, DOTCLK_DLY_SEL, v)
#endif

/* --- Register HW_LCDIF_VDCTRL4, field RSRVD0 */

#define BP_LCDIF_VDCTRL4_RSRVD0      19
#define BM_LCDIF_VDCTRL4_RSRVD0      0x1FF80000

#define BF_LCDIF_VDCTRL4_RSRVD0(v)   (((v) << 19) & BM_LCDIF_VDCTRL4_RSRVD0)
/* --- Register HW_LCDIF_VDCTRL4, field SYNC_SIGNALS_ON */

#define BP_LCDIF_VDCTRL4_SYNC_SIGNALS_ON      18
#define BM_LCDIF_VDCTRL4_SYNC_SIGNALS_ON      0x00040000

#define BF_LCDIF_VDCTRL4_SYNC_SIGNALS_ON(v)   (((v) << 18) & BM_LCDIF_VDCTRL4_SYNC_SIGNALS_ON)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL4_SYNC_SIGNALS_ON(v)   BF_CS1(LCDIF_VDCTRL4, SYNC_SIGNALS_ON, v)
#endif

/* --- Register HW_LCDIF_VDCTRL4, field DOTCLK_H_VALID_DATA_CNT */

#define BP_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT      0
#define BM_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT      0x0003FFFF

#define BF_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT(v)   (((v) << 0) & BM_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_VDCTRL4_DOTCLK_H_VALID_DATA_CNT(v)   BF_CS1(LCDIF_VDCTRL4, DOTCLK_H_VALID_DATA_CNT, v)
#endif



/*
 * HW_LCDIF_DVICTRL0 - Digital Video Interface Control0 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned H_BLANKING_CNT  : 12;
        unsigned RSRVD0          :  4;
        unsigned H_ACTIVE_CNT    : 12;
        unsigned RSRVD1          :  4;
    } B;
} hw_lcdif_dvictrl0_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DVICTRL0 register
 */
#define HW_LCDIF_DVICTRL0_ADDR         (REGS_LCDIF_BASE + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DVICTRL0           (*(volatile hw_lcdif_dvictrl0_t *) HW_LCDIF_DVICTRL0_ADDR)
#define HW_LCDIF_DVICTRL0_RD()      (HW_LCDIF_DVICTRL0.U)
#define HW_LCDIF_DVICTRL0_WR(v)     (HW_LCDIF_DVICTRL0.U = (v))
#define HW_LCDIF_DVICTRL0_SET(v)    (HW_LCDIF_DVICTRL0_WR(HW_LCDIF_DVICTRL0_RD() |  (v)))
#define HW_LCDIF_DVICTRL0_CLR(v)    (HW_LCDIF_DVICTRL0_WR(HW_LCDIF_DVICTRL0_RD() & ~(v)))
#define HW_LCDIF_DVICTRL0_TOG(v)    (HW_LCDIF_DVICTRL0_WR(HW_LCDIF_DVICTRL0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DVICTRL0 bitfields
 */
/* --- Register HW_LCDIF_DVICTRL0, field RSRVD1 */

#define BP_LCDIF_DVICTRL0_RSRVD1      28
#define BM_LCDIF_DVICTRL0_RSRVD1      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DVICTRL0_RSRVD1(v)   ((((reg32_t) v) << 28) & BM_LCDIF_DVICTRL0_RSRVD1)
#else
#define BF_LCDIF_DVICTRL0_RSRVD1(v)   (((v) << 28) & BM_LCDIF_DVICTRL0_RSRVD1)
#endif
/* --- Register HW_LCDIF_DVICTRL0, field H_ACTIVE_CNT */

#define BP_LCDIF_DVICTRL0_H_ACTIVE_CNT      16
#define BM_LCDIF_DVICTRL0_H_ACTIVE_CNT      0x0FFF0000

#define BF_LCDIF_DVICTRL0_H_ACTIVE_CNT(v)   (((v) << 16) & BM_LCDIF_DVICTRL0_H_ACTIVE_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL0_H_ACTIVE_CNT(v)   BF_CS1(LCDIF_DVICTRL0, H_ACTIVE_CNT, v)
#endif

/* --- Register HW_LCDIF_DVICTRL0, field RSRVD0 */

#define BP_LCDIF_DVICTRL0_RSRVD0      12
#define BM_LCDIF_DVICTRL0_RSRVD0      0x0000F000

#define BF_LCDIF_DVICTRL0_RSRVD0(v)   (((v) << 12) & BM_LCDIF_DVICTRL0_RSRVD0)
/* --- Register HW_LCDIF_DVICTRL0, field H_BLANKING_CNT */

#define BP_LCDIF_DVICTRL0_H_BLANKING_CNT      0
#define BM_LCDIF_DVICTRL0_H_BLANKING_CNT      0x00000FFF

#define BF_LCDIF_DVICTRL0_H_BLANKING_CNT(v)   (((v) << 0) & BM_LCDIF_DVICTRL0_H_BLANKING_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL0_H_BLANKING_CNT(v)   BF_CS1(LCDIF_DVICTRL0, H_BLANKING_CNT, v)
#endif



/*
 * HW_LCDIF_DVICTRL1 - Digital Video Interface Control1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned F2_START_LINE  : 10;
        unsigned F1_END_LINE    : 10;
        unsigned F1_START_LINE  : 10;
        unsigned RSRVD0         :  2;
    } B;
} hw_lcdif_dvictrl1_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DVICTRL1 register
 */
#define HW_LCDIF_DVICTRL1_ADDR         (REGS_LCDIF_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DVICTRL1           (*(volatile hw_lcdif_dvictrl1_t *) HW_LCDIF_DVICTRL1_ADDR)
#define HW_LCDIF_DVICTRL1_RD()      (HW_LCDIF_DVICTRL1.U)
#define HW_LCDIF_DVICTRL1_WR(v)     (HW_LCDIF_DVICTRL1.U = (v))
#define HW_LCDIF_DVICTRL1_SET(v)    (HW_LCDIF_DVICTRL1_WR(HW_LCDIF_DVICTRL1_RD() |  (v)))
#define HW_LCDIF_DVICTRL1_CLR(v)    (HW_LCDIF_DVICTRL1_WR(HW_LCDIF_DVICTRL1_RD() & ~(v)))
#define HW_LCDIF_DVICTRL1_TOG(v)    (HW_LCDIF_DVICTRL1_WR(HW_LCDIF_DVICTRL1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DVICTRL1 bitfields
 */
/* --- Register HW_LCDIF_DVICTRL1, field RSRVD0 */

#define BP_LCDIF_DVICTRL1_RSRVD0      30
#define BM_LCDIF_DVICTRL1_RSRVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DVICTRL1_RSRVD0(v)   ((((reg32_t) v) << 30) & BM_LCDIF_DVICTRL1_RSRVD0)
#else
#define BF_LCDIF_DVICTRL1_RSRVD0(v)   (((v) << 30) & BM_LCDIF_DVICTRL1_RSRVD0)
#endif
/* --- Register HW_LCDIF_DVICTRL1, field F1_START_LINE */

#define BP_LCDIF_DVICTRL1_F1_START_LINE      20
#define BM_LCDIF_DVICTRL1_F1_START_LINE      0x3FF00000

#define BF_LCDIF_DVICTRL1_F1_START_LINE(v)   (((v) << 20) & BM_LCDIF_DVICTRL1_F1_START_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL1_F1_START_LINE(v)   BF_CS1(LCDIF_DVICTRL1, F1_START_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL1, field F1_END_LINE */

#define BP_LCDIF_DVICTRL1_F1_END_LINE      10
#define BM_LCDIF_DVICTRL1_F1_END_LINE      0x000FFC00

#define BF_LCDIF_DVICTRL1_F1_END_LINE(v)   (((v) << 10) & BM_LCDIF_DVICTRL1_F1_END_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL1_F1_END_LINE(v)   BF_CS1(LCDIF_DVICTRL1, F1_END_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL1, field F2_START_LINE */

#define BP_LCDIF_DVICTRL1_F2_START_LINE      0
#define BM_LCDIF_DVICTRL1_F2_START_LINE      0x000003FF

#define BF_LCDIF_DVICTRL1_F2_START_LINE(v)   (((v) << 0) & BM_LCDIF_DVICTRL1_F2_START_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL1_F2_START_LINE(v)   BF_CS1(LCDIF_DVICTRL1, F2_START_LINE, v)
#endif



/*
 * HW_LCDIF_DVICTRL2 - Digital Video Interface Control2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned V1_BLANK_END_LINE    : 10;
        unsigned V1_BLANK_START_LINE  : 10;
        unsigned F2_END_LINE          : 10;
        unsigned RSRVD0               :  2;
    } B;
} hw_lcdif_dvictrl2_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DVICTRL2 register
 */
#define HW_LCDIF_DVICTRL2_ADDR         (REGS_LCDIF_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DVICTRL2           (*(volatile hw_lcdif_dvictrl2_t *) HW_LCDIF_DVICTRL2_ADDR)
#define HW_LCDIF_DVICTRL2_RD()      (HW_LCDIF_DVICTRL2.U)
#define HW_LCDIF_DVICTRL2_WR(v)     (HW_LCDIF_DVICTRL2.U = (v))
#define HW_LCDIF_DVICTRL2_SET(v)    (HW_LCDIF_DVICTRL2_WR(HW_LCDIF_DVICTRL2_RD() |  (v)))
#define HW_LCDIF_DVICTRL2_CLR(v)    (HW_LCDIF_DVICTRL2_WR(HW_LCDIF_DVICTRL2_RD() & ~(v)))
#define HW_LCDIF_DVICTRL2_TOG(v)    (HW_LCDIF_DVICTRL2_WR(HW_LCDIF_DVICTRL2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DVICTRL2 bitfields
 */
/* --- Register HW_LCDIF_DVICTRL2, field RSRVD0 */

#define BP_LCDIF_DVICTRL2_RSRVD0      30
#define BM_LCDIF_DVICTRL2_RSRVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DVICTRL2_RSRVD0(v)   ((((reg32_t) v) << 30) & BM_LCDIF_DVICTRL2_RSRVD0)
#else
#define BF_LCDIF_DVICTRL2_RSRVD0(v)   (((v) << 30) & BM_LCDIF_DVICTRL2_RSRVD0)
#endif
/* --- Register HW_LCDIF_DVICTRL2, field F2_END_LINE */

#define BP_LCDIF_DVICTRL2_F2_END_LINE      20
#define BM_LCDIF_DVICTRL2_F2_END_LINE      0x3FF00000

#define BF_LCDIF_DVICTRL2_F2_END_LINE(v)   (((v) << 20) & BM_LCDIF_DVICTRL2_F2_END_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL2_F2_END_LINE(v)   BF_CS1(LCDIF_DVICTRL2, F2_END_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL2, field V1_BLANK_START_LINE */

#define BP_LCDIF_DVICTRL2_V1_BLANK_START_LINE      10
#define BM_LCDIF_DVICTRL2_V1_BLANK_START_LINE      0x000FFC00

#define BF_LCDIF_DVICTRL2_V1_BLANK_START_LINE(v)   (((v) << 10) & BM_LCDIF_DVICTRL2_V1_BLANK_START_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL2_V1_BLANK_START_LINE(v)   BF_CS1(LCDIF_DVICTRL2, V1_BLANK_START_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL2, field V1_BLANK_END_LINE */

#define BP_LCDIF_DVICTRL2_V1_BLANK_END_LINE      0
#define BM_LCDIF_DVICTRL2_V1_BLANK_END_LINE      0x000003FF

#define BF_LCDIF_DVICTRL2_V1_BLANK_END_LINE(v)   (((v) << 0) & BM_LCDIF_DVICTRL2_V1_BLANK_END_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL2_V1_BLANK_END_LINE(v)   BF_CS1(LCDIF_DVICTRL2, V1_BLANK_END_LINE, v)
#endif



/*
 * HW_LCDIF_DVICTRL3 - Digital Video Interface Control3 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned V_LINES_CNT          : 10;
        unsigned V2_BLANK_END_LINE    : 10;
        unsigned V2_BLANK_START_LINE  : 10;
        unsigned RSRVD0               :  2;
    } B;
} hw_lcdif_dvictrl3_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DVICTRL3 register
 */
#define HW_LCDIF_DVICTRL3_ADDR         (REGS_LCDIF_BASE + 0xf0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DVICTRL3           (*(volatile hw_lcdif_dvictrl3_t *) HW_LCDIF_DVICTRL3_ADDR)
#define HW_LCDIF_DVICTRL3_RD()      (HW_LCDIF_DVICTRL3.U)
#define HW_LCDIF_DVICTRL3_WR(v)     (HW_LCDIF_DVICTRL3.U = (v))
#define HW_LCDIF_DVICTRL3_SET(v)    (HW_LCDIF_DVICTRL3_WR(HW_LCDIF_DVICTRL3_RD() |  (v)))
#define HW_LCDIF_DVICTRL3_CLR(v)    (HW_LCDIF_DVICTRL3_WR(HW_LCDIF_DVICTRL3_RD() & ~(v)))
#define HW_LCDIF_DVICTRL3_TOG(v)    (HW_LCDIF_DVICTRL3_WR(HW_LCDIF_DVICTRL3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DVICTRL3 bitfields
 */
/* --- Register HW_LCDIF_DVICTRL3, field RSRVD0 */

#define BP_LCDIF_DVICTRL3_RSRVD0      30
#define BM_LCDIF_DVICTRL3_RSRVD0      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DVICTRL3_RSRVD0(v)   ((((reg32_t) v) << 30) & BM_LCDIF_DVICTRL3_RSRVD0)
#else
#define BF_LCDIF_DVICTRL3_RSRVD0(v)   (((v) << 30) & BM_LCDIF_DVICTRL3_RSRVD0)
#endif
/* --- Register HW_LCDIF_DVICTRL3, field V2_BLANK_START_LINE */

#define BP_LCDIF_DVICTRL3_V2_BLANK_START_LINE      20
#define BM_LCDIF_DVICTRL3_V2_BLANK_START_LINE      0x3FF00000

#define BF_LCDIF_DVICTRL3_V2_BLANK_START_LINE(v)   (((v) << 20) & BM_LCDIF_DVICTRL3_V2_BLANK_START_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL3_V2_BLANK_START_LINE(v)   BF_CS1(LCDIF_DVICTRL3, V2_BLANK_START_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL3, field V2_BLANK_END_LINE */

#define BP_LCDIF_DVICTRL3_V2_BLANK_END_LINE      10
#define BM_LCDIF_DVICTRL3_V2_BLANK_END_LINE      0x000FFC00

#define BF_LCDIF_DVICTRL3_V2_BLANK_END_LINE(v)   (((v) << 10) & BM_LCDIF_DVICTRL3_V2_BLANK_END_LINE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL3_V2_BLANK_END_LINE(v)   BF_CS1(LCDIF_DVICTRL3, V2_BLANK_END_LINE, v)
#endif

/* --- Register HW_LCDIF_DVICTRL3, field V_LINES_CNT */

#define BP_LCDIF_DVICTRL3_V_LINES_CNT      0
#define BM_LCDIF_DVICTRL3_V_LINES_CNT      0x000003FF

#define BF_LCDIF_DVICTRL3_V_LINES_CNT(v)   (((v) << 0) & BM_LCDIF_DVICTRL3_V_LINES_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL3_V_LINES_CNT(v)   BF_CS1(LCDIF_DVICTRL3, V_LINES_CNT, v)
#endif



/*
 * HW_LCDIF_DVICTRL4 - Digital Video Interface Control4 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned H_FILL_CNT     :  8;
        unsigned CR_FILL_VALUE  :  8;
        unsigned CB_FILL_VALUE  :  8;
        unsigned Y_FILL_VALUE   :  8;
    } B;
} hw_lcdif_dvictrl4_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DVICTRL4 register
 */
#define HW_LCDIF_DVICTRL4_ADDR         (REGS_LCDIF_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DVICTRL4           (*(volatile hw_lcdif_dvictrl4_t *) HW_LCDIF_DVICTRL4_ADDR)
#define HW_LCDIF_DVICTRL4_RD()      (HW_LCDIF_DVICTRL4.U)
#define HW_LCDIF_DVICTRL4_WR(v)     (HW_LCDIF_DVICTRL4.U = (v))
#define HW_LCDIF_DVICTRL4_SET(v)    (HW_LCDIF_DVICTRL4_WR(HW_LCDIF_DVICTRL4_RD() |  (v)))
#define HW_LCDIF_DVICTRL4_CLR(v)    (HW_LCDIF_DVICTRL4_WR(HW_LCDIF_DVICTRL4_RD() & ~(v)))
#define HW_LCDIF_DVICTRL4_TOG(v)    (HW_LCDIF_DVICTRL4_WR(HW_LCDIF_DVICTRL4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DVICTRL4 bitfields
 */
/* --- Register HW_LCDIF_DVICTRL4, field Y_FILL_VALUE */

#define BP_LCDIF_DVICTRL4_Y_FILL_VALUE      24
#define BM_LCDIF_DVICTRL4_Y_FILL_VALUE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DVICTRL4_Y_FILL_VALUE(v)   ((((reg32_t) v) << 24) & BM_LCDIF_DVICTRL4_Y_FILL_VALUE)
#else
#define BF_LCDIF_DVICTRL4_Y_FILL_VALUE(v)   (((v) << 24) & BM_LCDIF_DVICTRL4_Y_FILL_VALUE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL4_Y_FILL_VALUE(v)   (HW_LCDIF_DVICTRL4.B.Y_FILL_VALUE = (v))
#endif

/* --- Register HW_LCDIF_DVICTRL4, field CB_FILL_VALUE */

#define BP_LCDIF_DVICTRL4_CB_FILL_VALUE      16
#define BM_LCDIF_DVICTRL4_CB_FILL_VALUE      0x00FF0000

#define BF_LCDIF_DVICTRL4_CB_FILL_VALUE(v)   (((v) << 16) & BM_LCDIF_DVICTRL4_CB_FILL_VALUE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL4_CB_FILL_VALUE(v)   (HW_LCDIF_DVICTRL4.B.CB_FILL_VALUE = (v))
#endif

/* --- Register HW_LCDIF_DVICTRL4, field CR_FILL_VALUE */

#define BP_LCDIF_DVICTRL4_CR_FILL_VALUE      8
#define BM_LCDIF_DVICTRL4_CR_FILL_VALUE      0x0000FF00

#define BF_LCDIF_DVICTRL4_CR_FILL_VALUE(v)   (((v) << 8) & BM_LCDIF_DVICTRL4_CR_FILL_VALUE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL4_CR_FILL_VALUE(v)   (HW_LCDIF_DVICTRL4.B.CR_FILL_VALUE = (v))
#endif

/* --- Register HW_LCDIF_DVICTRL4, field H_FILL_CNT */

#define BP_LCDIF_DVICTRL4_H_FILL_CNT      0
#define BM_LCDIF_DVICTRL4_H_FILL_CNT      0x000000FF

#define BF_LCDIF_DVICTRL4_H_FILL_CNT(v)   (((v) << 0) & BM_LCDIF_DVICTRL4_H_FILL_CNT)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DVICTRL4_H_FILL_CNT(v)   (HW_LCDIF_DVICTRL4.B.H_FILL_CNT = (v))
#endif



/*
 * HW_LCDIF_CSC_COEFF0 - RGB to YCbCr 4:2:2 CSC Coefficient0 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CSC_SUBSAMPLE_FILTER  :  2;
        unsigned RSRVD0                : 14;
        unsigned C0                    : 10;
        unsigned RSRVD1                :  6;
    } B;
} hw_lcdif_csc_coeff0_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_COEFF0 register
 */
#define HW_LCDIF_CSC_COEFF0_ADDR         (REGS_LCDIF_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_COEFF0           (*(volatile hw_lcdif_csc_coeff0_t *) HW_LCDIF_CSC_COEFF0_ADDR)
#define HW_LCDIF_CSC_COEFF0_RD()      (HW_LCDIF_CSC_COEFF0.U)
#define HW_LCDIF_CSC_COEFF0_WR(v)     (HW_LCDIF_CSC_COEFF0.U = (v))
#define HW_LCDIF_CSC_COEFF0_SET(v)    (HW_LCDIF_CSC_COEFF0_WR(HW_LCDIF_CSC_COEFF0_RD() |  (v)))
#define HW_LCDIF_CSC_COEFF0_CLR(v)    (HW_LCDIF_CSC_COEFF0_WR(HW_LCDIF_CSC_COEFF0_RD() & ~(v)))
#define HW_LCDIF_CSC_COEFF0_TOG(v)    (HW_LCDIF_CSC_COEFF0_WR(HW_LCDIF_CSC_COEFF0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_COEFF0 bitfields
 */
/* --- Register HW_LCDIF_CSC_COEFF0, field RSRVD1 */

#define BP_LCDIF_CSC_COEFF0_RSRVD1      26
#define BM_LCDIF_CSC_COEFF0_RSRVD1      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_COEFF0_RSRVD1(v)   ((((reg32_t) v) << 26) & BM_LCDIF_CSC_COEFF0_RSRVD1)
#else
#define BF_LCDIF_CSC_COEFF0_RSRVD1(v)   (((v) << 26) & BM_LCDIF_CSC_COEFF0_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_COEFF0, field C0 */

#define BP_LCDIF_CSC_COEFF0_C0      16
#define BM_LCDIF_CSC_COEFF0_C0      0x03FF0000

#define BF_LCDIF_CSC_COEFF0_C0(v)   (((v) << 16) & BM_LCDIF_CSC_COEFF0_C0)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF0_C0(v)   BF_CS1(LCDIF_CSC_COEFF0, C0, v)
#endif

/* --- Register HW_LCDIF_CSC_COEFF0, field RSRVD0 */

#define BP_LCDIF_CSC_COEFF0_RSRVD0      2
#define BM_LCDIF_CSC_COEFF0_RSRVD0      0x0000FFFC

#define BF_LCDIF_CSC_COEFF0_RSRVD0(v)   (((v) << 2) & BM_LCDIF_CSC_COEFF0_RSRVD0)
/* --- Register HW_LCDIF_CSC_COEFF0, field CSC_SUBSAMPLE_FILTER */

#define BP_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER      0
#define BM_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER      0x00000003

#define BF_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER(v)   (((v) << 0) & BM_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER(v)   BF_CS1(LCDIF_CSC_COEFF0, CSC_SUBSAMPLE_FILTER, v)
#endif

#define BV_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER__SAMPLE_AND_HOLD  0x0
#define BV_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER__RSRVD            0x1
#define BV_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER__INTERSTITIAL     0x2
#define BV_LCDIF_CSC_COEFF0_CSC_SUBSAMPLE_FILTER__COSITED          0x3



/*
 * HW_LCDIF_CSC_COEFF1 - RGB to YCbCr 4:2:2 CSC Coefficient1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C1      : 10;
        unsigned RSRVD0  :  6;
        unsigned C2      : 10;
        unsigned RSRVD1  :  6;
    } B;
} hw_lcdif_csc_coeff1_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_COEFF1 register
 */
#define HW_LCDIF_CSC_COEFF1_ADDR         (REGS_LCDIF_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_COEFF1           (*(volatile hw_lcdif_csc_coeff1_t *) HW_LCDIF_CSC_COEFF1_ADDR)
#define HW_LCDIF_CSC_COEFF1_RD()      (HW_LCDIF_CSC_COEFF1.U)
#define HW_LCDIF_CSC_COEFF1_WR(v)     (HW_LCDIF_CSC_COEFF1.U = (v))
#define HW_LCDIF_CSC_COEFF1_SET(v)    (HW_LCDIF_CSC_COEFF1_WR(HW_LCDIF_CSC_COEFF1_RD() |  (v)))
#define HW_LCDIF_CSC_COEFF1_CLR(v)    (HW_LCDIF_CSC_COEFF1_WR(HW_LCDIF_CSC_COEFF1_RD() & ~(v)))
#define HW_LCDIF_CSC_COEFF1_TOG(v)    (HW_LCDIF_CSC_COEFF1_WR(HW_LCDIF_CSC_COEFF1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_COEFF1 bitfields
 */
/* --- Register HW_LCDIF_CSC_COEFF1, field RSRVD1 */

#define BP_LCDIF_CSC_COEFF1_RSRVD1      26
#define BM_LCDIF_CSC_COEFF1_RSRVD1      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_COEFF1_RSRVD1(v)   ((((reg32_t) v) << 26) & BM_LCDIF_CSC_COEFF1_RSRVD1)
#else
#define BF_LCDIF_CSC_COEFF1_RSRVD1(v)   (((v) << 26) & BM_LCDIF_CSC_COEFF1_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_COEFF1, field C2 */

#define BP_LCDIF_CSC_COEFF1_C2      16
#define BM_LCDIF_CSC_COEFF1_C2      0x03FF0000

#define BF_LCDIF_CSC_COEFF1_C2(v)   (((v) << 16) & BM_LCDIF_CSC_COEFF1_C2)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF1_C2(v)   BF_CS1(LCDIF_CSC_COEFF1, C2, v)
#endif

/* --- Register HW_LCDIF_CSC_COEFF1, field RSRVD0 */

#define BP_LCDIF_CSC_COEFF1_RSRVD0      10
#define BM_LCDIF_CSC_COEFF1_RSRVD0      0x0000FC00

#define BF_LCDIF_CSC_COEFF1_RSRVD0(v)   (((v) << 10) & BM_LCDIF_CSC_COEFF1_RSRVD0)
/* --- Register HW_LCDIF_CSC_COEFF1, field C1 */

#define BP_LCDIF_CSC_COEFF1_C1      0
#define BM_LCDIF_CSC_COEFF1_C1      0x000003FF

#define BF_LCDIF_CSC_COEFF1_C1(v)   (((v) << 0) & BM_LCDIF_CSC_COEFF1_C1)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF1_C1(v)   BF_CS1(LCDIF_CSC_COEFF1, C1, v)
#endif



/*
 * HW_LCDIF_CSC_COEFF2 - RGB to YCbCr 4:2:2 CSC Coefficent2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C3      : 10;
        unsigned RSRVD0  :  6;
        unsigned C4      : 10;
        unsigned RSRVD1  :  6;
    } B;
} hw_lcdif_csc_coeff2_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_COEFF2 register
 */
#define HW_LCDIF_CSC_COEFF2_ADDR         (REGS_LCDIF_BASE + 0x130)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_COEFF2           (*(volatile hw_lcdif_csc_coeff2_t *) HW_LCDIF_CSC_COEFF2_ADDR)
#define HW_LCDIF_CSC_COEFF2_RD()      (HW_LCDIF_CSC_COEFF2.U)
#define HW_LCDIF_CSC_COEFF2_WR(v)     (HW_LCDIF_CSC_COEFF2.U = (v))
#define HW_LCDIF_CSC_COEFF2_SET(v)    (HW_LCDIF_CSC_COEFF2_WR(HW_LCDIF_CSC_COEFF2_RD() |  (v)))
#define HW_LCDIF_CSC_COEFF2_CLR(v)    (HW_LCDIF_CSC_COEFF2_WR(HW_LCDIF_CSC_COEFF2_RD() & ~(v)))
#define HW_LCDIF_CSC_COEFF2_TOG(v)    (HW_LCDIF_CSC_COEFF2_WR(HW_LCDIF_CSC_COEFF2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_COEFF2 bitfields
 */
/* --- Register HW_LCDIF_CSC_COEFF2, field RSRVD1 */

#define BP_LCDIF_CSC_COEFF2_RSRVD1      26
#define BM_LCDIF_CSC_COEFF2_RSRVD1      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_COEFF2_RSRVD1(v)   ((((reg32_t) v) << 26) & BM_LCDIF_CSC_COEFF2_RSRVD1)
#else
#define BF_LCDIF_CSC_COEFF2_RSRVD1(v)   (((v) << 26) & BM_LCDIF_CSC_COEFF2_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_COEFF2, field C4 */

#define BP_LCDIF_CSC_COEFF2_C4      16
#define BM_LCDIF_CSC_COEFF2_C4      0x03FF0000

#define BF_LCDIF_CSC_COEFF2_C4(v)   (((v) << 16) & BM_LCDIF_CSC_COEFF2_C4)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF2_C4(v)   BF_CS1(LCDIF_CSC_COEFF2, C4, v)
#endif

/* --- Register HW_LCDIF_CSC_COEFF2, field RSRVD0 */

#define BP_LCDIF_CSC_COEFF2_RSRVD0      10
#define BM_LCDIF_CSC_COEFF2_RSRVD0      0x0000FC00

#define BF_LCDIF_CSC_COEFF2_RSRVD0(v)   (((v) << 10) & BM_LCDIF_CSC_COEFF2_RSRVD0)
/* --- Register HW_LCDIF_CSC_COEFF2, field C3 */

#define BP_LCDIF_CSC_COEFF2_C3      0
#define BM_LCDIF_CSC_COEFF2_C3      0x000003FF

#define BF_LCDIF_CSC_COEFF2_C3(v)   (((v) << 0) & BM_LCDIF_CSC_COEFF2_C3)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF2_C3(v)   BF_CS1(LCDIF_CSC_COEFF2, C3, v)
#endif



/*
 * HW_LCDIF_CSC_COEFF3 - RGB to YCbCr 4:2:2 CSC Coefficient3 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C5      : 10;
        unsigned RSRVD0  :  6;
        unsigned C6      : 10;
        unsigned RSRVD1  :  6;
    } B;
} hw_lcdif_csc_coeff3_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_COEFF3 register
 */
#define HW_LCDIF_CSC_COEFF3_ADDR         (REGS_LCDIF_BASE + 0x140)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_COEFF3           (*(volatile hw_lcdif_csc_coeff3_t *) HW_LCDIF_CSC_COEFF3_ADDR)
#define HW_LCDIF_CSC_COEFF3_RD()      (HW_LCDIF_CSC_COEFF3.U)
#define HW_LCDIF_CSC_COEFF3_WR(v)     (HW_LCDIF_CSC_COEFF3.U = (v))
#define HW_LCDIF_CSC_COEFF3_SET(v)    (HW_LCDIF_CSC_COEFF3_WR(HW_LCDIF_CSC_COEFF3_RD() |  (v)))
#define HW_LCDIF_CSC_COEFF3_CLR(v)    (HW_LCDIF_CSC_COEFF3_WR(HW_LCDIF_CSC_COEFF3_RD() & ~(v)))
#define HW_LCDIF_CSC_COEFF3_TOG(v)    (HW_LCDIF_CSC_COEFF3_WR(HW_LCDIF_CSC_COEFF3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_COEFF3 bitfields
 */
/* --- Register HW_LCDIF_CSC_COEFF3, field RSRVD1 */

#define BP_LCDIF_CSC_COEFF3_RSRVD1      26
#define BM_LCDIF_CSC_COEFF3_RSRVD1      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_COEFF3_RSRVD1(v)   ((((reg32_t) v) << 26) & BM_LCDIF_CSC_COEFF3_RSRVD1)
#else
#define BF_LCDIF_CSC_COEFF3_RSRVD1(v)   (((v) << 26) & BM_LCDIF_CSC_COEFF3_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_COEFF3, field C6 */

#define BP_LCDIF_CSC_COEFF3_C6      16
#define BM_LCDIF_CSC_COEFF3_C6      0x03FF0000

#define BF_LCDIF_CSC_COEFF3_C6(v)   (((v) << 16) & BM_LCDIF_CSC_COEFF3_C6)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF3_C6(v)   BF_CS1(LCDIF_CSC_COEFF3, C6, v)
#endif

/* --- Register HW_LCDIF_CSC_COEFF3, field RSRVD0 */

#define BP_LCDIF_CSC_COEFF3_RSRVD0      10
#define BM_LCDIF_CSC_COEFF3_RSRVD0      0x0000FC00

#define BF_LCDIF_CSC_COEFF3_RSRVD0(v)   (((v) << 10) & BM_LCDIF_CSC_COEFF3_RSRVD0)
/* --- Register HW_LCDIF_CSC_COEFF3, field C5 */

#define BP_LCDIF_CSC_COEFF3_C5      0
#define BM_LCDIF_CSC_COEFF3_C5      0x000003FF

#define BF_LCDIF_CSC_COEFF3_C5(v)   (((v) << 0) & BM_LCDIF_CSC_COEFF3_C5)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF3_C5(v)   BF_CS1(LCDIF_CSC_COEFF3, C5, v)
#endif



/*
 * HW_LCDIF_CSC_COEFF4 - RGB to YCbCr 4:2:2 CSC Coefficient4 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned C7      : 10;
        unsigned RSRVD0  :  6;
        unsigned C8      : 10;
        unsigned RSRVD1  :  6;
    } B;
} hw_lcdif_csc_coeff4_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_COEFF4 register
 */
#define HW_LCDIF_CSC_COEFF4_ADDR         (REGS_LCDIF_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_COEFF4           (*(volatile hw_lcdif_csc_coeff4_t *) HW_LCDIF_CSC_COEFF4_ADDR)
#define HW_LCDIF_CSC_COEFF4_RD()      (HW_LCDIF_CSC_COEFF4.U)
#define HW_LCDIF_CSC_COEFF4_WR(v)     (HW_LCDIF_CSC_COEFF4.U = (v))
#define HW_LCDIF_CSC_COEFF4_SET(v)    (HW_LCDIF_CSC_COEFF4_WR(HW_LCDIF_CSC_COEFF4_RD() |  (v)))
#define HW_LCDIF_CSC_COEFF4_CLR(v)    (HW_LCDIF_CSC_COEFF4_WR(HW_LCDIF_CSC_COEFF4_RD() & ~(v)))
#define HW_LCDIF_CSC_COEFF4_TOG(v)    (HW_LCDIF_CSC_COEFF4_WR(HW_LCDIF_CSC_COEFF4_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_COEFF4 bitfields
 */
/* --- Register HW_LCDIF_CSC_COEFF4, field RSRVD1 */

#define BP_LCDIF_CSC_COEFF4_RSRVD1      26
#define BM_LCDIF_CSC_COEFF4_RSRVD1      0xFC000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_COEFF4_RSRVD1(v)   ((((reg32_t) v) << 26) & BM_LCDIF_CSC_COEFF4_RSRVD1)
#else
#define BF_LCDIF_CSC_COEFF4_RSRVD1(v)   (((v) << 26) & BM_LCDIF_CSC_COEFF4_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_COEFF4, field C8 */

#define BP_LCDIF_CSC_COEFF4_C8      16
#define BM_LCDIF_CSC_COEFF4_C8      0x03FF0000

#define BF_LCDIF_CSC_COEFF4_C8(v)   (((v) << 16) & BM_LCDIF_CSC_COEFF4_C8)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF4_C8(v)   BF_CS1(LCDIF_CSC_COEFF4, C8, v)
#endif

/* --- Register HW_LCDIF_CSC_COEFF4, field RSRVD0 */

#define BP_LCDIF_CSC_COEFF4_RSRVD0      10
#define BM_LCDIF_CSC_COEFF4_RSRVD0      0x0000FC00

#define BF_LCDIF_CSC_COEFF4_RSRVD0(v)   (((v) << 10) & BM_LCDIF_CSC_COEFF4_RSRVD0)
/* --- Register HW_LCDIF_CSC_COEFF4, field C7 */

#define BP_LCDIF_CSC_COEFF4_C7      0
#define BM_LCDIF_CSC_COEFF4_C7      0x000003FF

#define BF_LCDIF_CSC_COEFF4_C7(v)   (((v) << 0) & BM_LCDIF_CSC_COEFF4_C7)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_COEFF4_C7(v)   BF_CS1(LCDIF_CSC_COEFF4, C7, v)
#endif



/*
 * HW_LCDIF_CSC_OFFSET - RGB to YCbCr 4:2:2 CSC Offset Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned Y_OFFSET     :  9;
        unsigned RSRVD0       :  7;
        unsigned CBCR_OFFSET  :  9;
        unsigned RSRVD1       :  7;
    } B;
} hw_lcdif_csc_offset_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_OFFSET register
 */
#define HW_LCDIF_CSC_OFFSET_ADDR         (REGS_LCDIF_BASE + 0x160)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_OFFSET           (*(volatile hw_lcdif_csc_offset_t *) HW_LCDIF_CSC_OFFSET_ADDR)
#define HW_LCDIF_CSC_OFFSET_RD()      (HW_LCDIF_CSC_OFFSET.U)
#define HW_LCDIF_CSC_OFFSET_WR(v)     (HW_LCDIF_CSC_OFFSET.U = (v))
#define HW_LCDIF_CSC_OFFSET_SET(v)    (HW_LCDIF_CSC_OFFSET_WR(HW_LCDIF_CSC_OFFSET_RD() |  (v)))
#define HW_LCDIF_CSC_OFFSET_CLR(v)    (HW_LCDIF_CSC_OFFSET_WR(HW_LCDIF_CSC_OFFSET_RD() & ~(v)))
#define HW_LCDIF_CSC_OFFSET_TOG(v)    (HW_LCDIF_CSC_OFFSET_WR(HW_LCDIF_CSC_OFFSET_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_OFFSET bitfields
 */
/* --- Register HW_LCDIF_CSC_OFFSET, field RSRVD1 */

#define BP_LCDIF_CSC_OFFSET_RSRVD1      25
#define BM_LCDIF_CSC_OFFSET_RSRVD1      0xFE000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_OFFSET_RSRVD1(v)   ((((reg32_t) v) << 25) & BM_LCDIF_CSC_OFFSET_RSRVD1)
#else
#define BF_LCDIF_CSC_OFFSET_RSRVD1(v)   (((v) << 25) & BM_LCDIF_CSC_OFFSET_RSRVD1)
#endif
/* --- Register HW_LCDIF_CSC_OFFSET, field CBCR_OFFSET */

#define BP_LCDIF_CSC_OFFSET_CBCR_OFFSET      16
#define BM_LCDIF_CSC_OFFSET_CBCR_OFFSET      0x01FF0000

#define BF_LCDIF_CSC_OFFSET_CBCR_OFFSET(v)   (((v) << 16) & BM_LCDIF_CSC_OFFSET_CBCR_OFFSET)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_OFFSET_CBCR_OFFSET(v)   BF_CS1(LCDIF_CSC_OFFSET, CBCR_OFFSET, v)
#endif

/* --- Register HW_LCDIF_CSC_OFFSET, field RSRVD0 */

#define BP_LCDIF_CSC_OFFSET_RSRVD0      9
#define BM_LCDIF_CSC_OFFSET_RSRVD0      0x0000FE00

#define BF_LCDIF_CSC_OFFSET_RSRVD0(v)   (((v) << 9) & BM_LCDIF_CSC_OFFSET_RSRVD0)
/* --- Register HW_LCDIF_CSC_OFFSET, field Y_OFFSET */

#define BP_LCDIF_CSC_OFFSET_Y_OFFSET      0
#define BM_LCDIF_CSC_OFFSET_Y_OFFSET      0x000001FF

#define BF_LCDIF_CSC_OFFSET_Y_OFFSET(v)   (((v) << 0) & BM_LCDIF_CSC_OFFSET_Y_OFFSET)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_OFFSET_Y_OFFSET(v)   BF_CS1(LCDIF_CSC_OFFSET, Y_OFFSET, v)
#endif



/*
 * HW_LCDIF_CSC_LIMIT - RGB to YCbCr 4:2:2 CSC Limit Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned Y_MAX     :  8;
        unsigned Y_MIN     :  8;
        unsigned CBCR_MAX  :  8;
        unsigned CBCR_MIN  :  8;
    } B;
} hw_lcdif_csc_limit_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CSC_LIMIT register
 */
#define HW_LCDIF_CSC_LIMIT_ADDR         (REGS_LCDIF_BASE + 0x170)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CSC_LIMIT           (*(volatile hw_lcdif_csc_limit_t *) HW_LCDIF_CSC_LIMIT_ADDR)
#define HW_LCDIF_CSC_LIMIT_RD()      (HW_LCDIF_CSC_LIMIT.U)
#define HW_LCDIF_CSC_LIMIT_WR(v)     (HW_LCDIF_CSC_LIMIT.U = (v))
#define HW_LCDIF_CSC_LIMIT_SET(v)    (HW_LCDIF_CSC_LIMIT_WR(HW_LCDIF_CSC_LIMIT_RD() |  (v)))
#define HW_LCDIF_CSC_LIMIT_CLR(v)    (HW_LCDIF_CSC_LIMIT_WR(HW_LCDIF_CSC_LIMIT_RD() & ~(v)))
#define HW_LCDIF_CSC_LIMIT_TOG(v)    (HW_LCDIF_CSC_LIMIT_WR(HW_LCDIF_CSC_LIMIT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CSC_LIMIT bitfields
 */
/* --- Register HW_LCDIF_CSC_LIMIT, field CBCR_MIN */

#define BP_LCDIF_CSC_LIMIT_CBCR_MIN      24
#define BM_LCDIF_CSC_LIMIT_CBCR_MIN      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CSC_LIMIT_CBCR_MIN(v)   ((((reg32_t) v) << 24) & BM_LCDIF_CSC_LIMIT_CBCR_MIN)
#else
#define BF_LCDIF_CSC_LIMIT_CBCR_MIN(v)   (((v) << 24) & BM_LCDIF_CSC_LIMIT_CBCR_MIN)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_LIMIT_CBCR_MIN(v)   (HW_LCDIF_CSC_LIMIT.B.CBCR_MIN = (v))
#endif

/* --- Register HW_LCDIF_CSC_LIMIT, field CBCR_MAX */

#define BP_LCDIF_CSC_LIMIT_CBCR_MAX      16
#define BM_LCDIF_CSC_LIMIT_CBCR_MAX      0x00FF0000

#define BF_LCDIF_CSC_LIMIT_CBCR_MAX(v)   (((v) << 16) & BM_LCDIF_CSC_LIMIT_CBCR_MAX)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_LIMIT_CBCR_MAX(v)   (HW_LCDIF_CSC_LIMIT.B.CBCR_MAX = (v))
#endif

/* --- Register HW_LCDIF_CSC_LIMIT, field Y_MIN */

#define BP_LCDIF_CSC_LIMIT_Y_MIN      8
#define BM_LCDIF_CSC_LIMIT_Y_MIN      0x0000FF00

#define BF_LCDIF_CSC_LIMIT_Y_MIN(v)   (((v) << 8) & BM_LCDIF_CSC_LIMIT_Y_MIN)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_LIMIT_Y_MIN(v)   (HW_LCDIF_CSC_LIMIT.B.Y_MIN = (v))
#endif

/* --- Register HW_LCDIF_CSC_LIMIT, field Y_MAX */

#define BP_LCDIF_CSC_LIMIT_Y_MAX      0
#define BM_LCDIF_CSC_LIMIT_Y_MAX      0x000000FF

#define BF_LCDIF_CSC_LIMIT_Y_MAX(v)   (((v) << 0) & BM_LCDIF_CSC_LIMIT_Y_MAX)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CSC_LIMIT_Y_MAX(v)   (HW_LCDIF_CSC_LIMIT.B.Y_MAX = (v))
#endif



/*
 * HW_LCDIF_DATA - LCD Interface Data Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DATA_ZERO   :  8;
        unsigned DATA_ONE    :  8;
        unsigned DATA_TWO    :  8;
        unsigned DATA_THREE  :  8;
    } B;
} hw_lcdif_data_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DATA register
 */
#define HW_LCDIF_DATA_ADDR         (REGS_LCDIF_BASE + 0x180)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DATA           (*(volatile hw_lcdif_data_t *) HW_LCDIF_DATA_ADDR)
#define HW_LCDIF_DATA_RD()      (HW_LCDIF_DATA.U)
#define HW_LCDIF_DATA_WR(v)     (HW_LCDIF_DATA.U = (v))
#define HW_LCDIF_DATA_SET(v)    (HW_LCDIF_DATA_WR(HW_LCDIF_DATA_RD() |  (v)))
#define HW_LCDIF_DATA_CLR(v)    (HW_LCDIF_DATA_WR(HW_LCDIF_DATA_RD() & ~(v)))
#define HW_LCDIF_DATA_TOG(v)    (HW_LCDIF_DATA_WR(HW_LCDIF_DATA_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_DATA bitfields
 */
/* --- Register HW_LCDIF_DATA, field DATA_THREE */

#define BP_LCDIF_DATA_DATA_THREE      24
#define BM_LCDIF_DATA_DATA_THREE      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DATA_DATA_THREE(v)   ((((reg32_t) v) << 24) & BM_LCDIF_DATA_DATA_THREE)
#else
#define BF_LCDIF_DATA_DATA_THREE(v)   (((v) << 24) & BM_LCDIF_DATA_DATA_THREE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DATA_DATA_THREE(v)   (HW_LCDIF_DATA.B.DATA_THREE = (v))
#endif

/* --- Register HW_LCDIF_DATA, field DATA_TWO */

#define BP_LCDIF_DATA_DATA_TWO      16
#define BM_LCDIF_DATA_DATA_TWO      0x00FF0000

#define BF_LCDIF_DATA_DATA_TWO(v)   (((v) << 16) & BM_LCDIF_DATA_DATA_TWO)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DATA_DATA_TWO(v)   (HW_LCDIF_DATA.B.DATA_TWO = (v))
#endif

/* --- Register HW_LCDIF_DATA, field DATA_ONE */

#define BP_LCDIF_DATA_DATA_ONE      8
#define BM_LCDIF_DATA_DATA_ONE      0x0000FF00

#define BF_LCDIF_DATA_DATA_ONE(v)   (((v) << 8) & BM_LCDIF_DATA_DATA_ONE)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DATA_DATA_ONE(v)   (HW_LCDIF_DATA.B.DATA_ONE = (v))
#endif

/* --- Register HW_LCDIF_DATA, field DATA_ZERO */

#define BP_LCDIF_DATA_DATA_ZERO      0
#define BM_LCDIF_DATA_DATA_ZERO      0x000000FF

#define BF_LCDIF_DATA_DATA_ZERO(v)   (((v) << 0) & BM_LCDIF_DATA_DATA_ZERO)
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_DATA_DATA_ZERO(v)   (HW_LCDIF_DATA.B.DATA_ZERO = (v))
#endif



/*
 * HW_LCDIF_BM_ERROR_STAT - Bus Master Error Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned ADDR  : 32;
    } B;
} hw_lcdif_bm_error_stat_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_BM_ERROR_STAT register
 */
#define HW_LCDIF_BM_ERROR_STAT_ADDR         (REGS_LCDIF_BASE + 0x190)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_BM_ERROR_STAT           (*(volatile hw_lcdif_bm_error_stat_t *) HW_LCDIF_BM_ERROR_STAT_ADDR)
#define HW_LCDIF_BM_ERROR_STAT_RD()      (HW_LCDIF_BM_ERROR_STAT.U)
#define HW_LCDIF_BM_ERROR_STAT_WR(v)     (HW_LCDIF_BM_ERROR_STAT.U = (v))
#define HW_LCDIF_BM_ERROR_STAT_SET(v)    (HW_LCDIF_BM_ERROR_STAT_WR(HW_LCDIF_BM_ERROR_STAT_RD() |  (v)))
#define HW_LCDIF_BM_ERROR_STAT_CLR(v)    (HW_LCDIF_BM_ERROR_STAT_WR(HW_LCDIF_BM_ERROR_STAT_RD() & ~(v)))
#define HW_LCDIF_BM_ERROR_STAT_TOG(v)    (HW_LCDIF_BM_ERROR_STAT_WR(HW_LCDIF_BM_ERROR_STAT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_BM_ERROR_STAT bitfields
 */
/* --- Register HW_LCDIF_BM_ERROR_STAT, field ADDR */

#define BP_LCDIF_BM_ERROR_STAT_ADDR      0
#define BM_LCDIF_BM_ERROR_STAT_ADDR      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_BM_ERROR_STAT_ADDR(v)   ((reg32_t) v)
#else
#define BF_LCDIF_BM_ERROR_STAT_ADDR(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_BM_ERROR_STAT_ADDR(v)   (HW_LCDIF_BM_ERROR_STAT.B.ADDR = (v))
#endif



/*
 * HW_LCDIF_CRC_STAT - CRC Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CRC_VALUE  : 32;
    } B;
} hw_lcdif_crc_stat_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_CRC_STAT register
 */
#define HW_LCDIF_CRC_STAT_ADDR         (REGS_LCDIF_BASE + 0x1a0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_CRC_STAT           (*(volatile hw_lcdif_crc_stat_t *) HW_LCDIF_CRC_STAT_ADDR)
#define HW_LCDIF_CRC_STAT_RD()      (HW_LCDIF_CRC_STAT.U)
#define HW_LCDIF_CRC_STAT_WR(v)     (HW_LCDIF_CRC_STAT.U = (v))
#define HW_LCDIF_CRC_STAT_SET(v)    (HW_LCDIF_CRC_STAT_WR(HW_LCDIF_CRC_STAT_RD() |  (v)))
#define HW_LCDIF_CRC_STAT_CLR(v)    (HW_LCDIF_CRC_STAT_WR(HW_LCDIF_CRC_STAT_RD() & ~(v)))
#define HW_LCDIF_CRC_STAT_TOG(v)    (HW_LCDIF_CRC_STAT_WR(HW_LCDIF_CRC_STAT_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_LCDIF_CRC_STAT bitfields
 */
/* --- Register HW_LCDIF_CRC_STAT, field CRC_VALUE */

#define BP_LCDIF_CRC_STAT_CRC_VALUE      0
#define BM_LCDIF_CRC_STAT_CRC_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_CRC_STAT_CRC_VALUE(v)   ((reg32_t) v)
#else
#define BF_LCDIF_CRC_STAT_CRC_VALUE(v)   (v)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_LCDIF_CRC_STAT_CRC_VALUE(v)   (HW_LCDIF_CRC_STAT.B.CRC_VALUE = (v))
#endif



/*
 * HW_LCDIF_STAT - LCD Interface Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LFIFO_COUNT        :  9;
        unsigned RSRVD0             : 15;
        unsigned DVI_CURRENT_FIELD  :  1;
        unsigned BUSY               :  1;
        unsigned TXFIFO_EMPTY       :  1;
        unsigned TXFIFO_FULL        :  1;
        unsigned LFIFO_EMPTY        :  1;
        unsigned LFIFO_FULL         :  1;
        unsigned DMA_REQ            :  1;
        unsigned PRESENT            :  1;
    } B;
} hw_lcdif_stat_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_STAT register
 */
#define HW_LCDIF_STAT_ADDR         (REGS_LCDIF_BASE + 0x1b0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_STAT           (*(volatile hw_lcdif_stat_t *) HW_LCDIF_STAT_ADDR)
#define HW_LCDIF_STAT_RD()      (HW_LCDIF_STAT.U)
#endif


/*
 * constants & macros for individual HW_LCDIF_STAT bitfields
 */
/* --- Register HW_LCDIF_STAT, field PRESENT */

#define BP_LCDIF_STAT_PRESENT      31
#define BM_LCDIF_STAT_PRESENT      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_STAT_PRESENT(v)   ((((reg32_t) v) << 31) & BM_LCDIF_STAT_PRESENT)
#else
#define BF_LCDIF_STAT_PRESENT(v)   (((v) << 31) & BM_LCDIF_STAT_PRESENT)
#endif
/* --- Register HW_LCDIF_STAT, field DMA_REQ */

#define BP_LCDIF_STAT_DMA_REQ      30
#define BM_LCDIF_STAT_DMA_REQ      0x40000000

#define BF_LCDIF_STAT_DMA_REQ(v)   (((v) << 30) & BM_LCDIF_STAT_DMA_REQ)
/* --- Register HW_LCDIF_STAT, field LFIFO_FULL */

#define BP_LCDIF_STAT_LFIFO_FULL      29
#define BM_LCDIF_STAT_LFIFO_FULL      0x20000000

#define BF_LCDIF_STAT_LFIFO_FULL(v)   (((v) << 29) & BM_LCDIF_STAT_LFIFO_FULL)
/* --- Register HW_LCDIF_STAT, field LFIFO_EMPTY */

#define BP_LCDIF_STAT_LFIFO_EMPTY      28
#define BM_LCDIF_STAT_LFIFO_EMPTY      0x10000000

#define BF_LCDIF_STAT_LFIFO_EMPTY(v)   (((v) << 28) & BM_LCDIF_STAT_LFIFO_EMPTY)
/* --- Register HW_LCDIF_STAT, field TXFIFO_FULL */

#define BP_LCDIF_STAT_TXFIFO_FULL      27
#define BM_LCDIF_STAT_TXFIFO_FULL      0x08000000

#define BF_LCDIF_STAT_TXFIFO_FULL(v)   (((v) << 27) & BM_LCDIF_STAT_TXFIFO_FULL)
/* --- Register HW_LCDIF_STAT, field TXFIFO_EMPTY */

#define BP_LCDIF_STAT_TXFIFO_EMPTY      26
#define BM_LCDIF_STAT_TXFIFO_EMPTY      0x04000000

#define BF_LCDIF_STAT_TXFIFO_EMPTY(v)   (((v) << 26) & BM_LCDIF_STAT_TXFIFO_EMPTY)
/* --- Register HW_LCDIF_STAT, field BUSY */

#define BP_LCDIF_STAT_BUSY      25
#define BM_LCDIF_STAT_BUSY      0x02000000

#define BF_LCDIF_STAT_BUSY(v)   (((v) << 25) & BM_LCDIF_STAT_BUSY)
/* --- Register HW_LCDIF_STAT, field DVI_CURRENT_FIELD */

#define BP_LCDIF_STAT_DVI_CURRENT_FIELD      24
#define BM_LCDIF_STAT_DVI_CURRENT_FIELD      0x01000000

#define BF_LCDIF_STAT_DVI_CURRENT_FIELD(v)   (((v) << 24) & BM_LCDIF_STAT_DVI_CURRENT_FIELD)
/* --- Register HW_LCDIF_STAT, field RSRVD0 */

#define BP_LCDIF_STAT_RSRVD0      9
#define BM_LCDIF_STAT_RSRVD0      0x00FFFE00

#define BF_LCDIF_STAT_RSRVD0(v)   (((v) << 9) & BM_LCDIF_STAT_RSRVD0)
/* --- Register HW_LCDIF_STAT, field LFIFO_COUNT */

#define BP_LCDIF_STAT_LFIFO_COUNT      0
#define BM_LCDIF_STAT_LFIFO_COUNT      0x000001FF

#define BF_LCDIF_STAT_LFIFO_COUNT(v)   (((v) << 0) & BM_LCDIF_STAT_LFIFO_COUNT)


/*
 * HW_LCDIF_VERSION - LCD Interface Version  Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_lcdif_version_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_VERSION register
 */
#define HW_LCDIF_VERSION_ADDR         (REGS_LCDIF_BASE + 0x1c0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_VERSION           (*(volatile hw_lcdif_version_t *) HW_LCDIF_VERSION_ADDR)
#define HW_LCDIF_VERSION_RD()      (HW_LCDIF_VERSION.U)
#endif


/*
 * constants & macros for individual HW_LCDIF_VERSION bitfields
 */
/* --- Register HW_LCDIF_VERSION, field MAJOR */

#define BP_LCDIF_VERSION_MAJOR      24
#define BM_LCDIF_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_LCDIF_VERSION_MAJOR)
#else
#define BF_LCDIF_VERSION_MAJOR(v)   (((v) << 24) & BM_LCDIF_VERSION_MAJOR)
#endif
/* --- Register HW_LCDIF_VERSION, field MINOR */

#define BP_LCDIF_VERSION_MINOR      16
#define BM_LCDIF_VERSION_MINOR      0x00FF0000

#define BF_LCDIF_VERSION_MINOR(v)   (((v) << 16) & BM_LCDIF_VERSION_MINOR)
/* --- Register HW_LCDIF_VERSION, field STEP */

#define BP_LCDIF_VERSION_STEP      0
#define BM_LCDIF_VERSION_STEP      0x0000FFFF

#define BF_LCDIF_VERSION_STEP(v)   (((v) << 0) & BM_LCDIF_VERSION_STEP)


/*
 * HW_LCDIF_DEBUG0 - LCD Interface Debug0 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MST_WORDS                :  4;
        unsigned MST_OUTSTANDING_REQS     :  5;
        unsigned MST_AVALID               :  1;
        unsigned CUR_REQ_STATE            :  2;
        unsigned LCDIF_PXP_B1_DONE        :  1;
        unsigned PXP_LCDIF_B1_READY       :  1;
        unsigned LCDIF_PXP_B0_DONE        :  1;
        unsigned PXP_LCDIF_B0_READY       :  1;
        unsigned CUR_STATE                :  7;
        unsigned EMPTY_WORD               :  1;
        unsigned CUR_FRAME_TX             :  1;
        unsigned VSYNC                    :  1;
        unsigned HSYNC                    :  1;
        unsigned ENABLE                   :  1;
        unsigned DMACMDKICK               :  1;
        unsigned SYNC_SIGNALS_ON_REG      :  1;
        unsigned WAIT_FOR_VSYNC_EDGE_OUT  :  1;
        unsigned STREAMING_END_DETECTED   :  1;
    } B;
} hw_lcdif_debug0_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DEBUG0 register
 */
#define HW_LCDIF_DEBUG0_ADDR         (REGS_LCDIF_BASE + 0x1d0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DEBUG0           (*(volatile hw_lcdif_debug0_t *) HW_LCDIF_DEBUG0_ADDR)
#define HW_LCDIF_DEBUG0_RD()      (HW_LCDIF_DEBUG0.U)
#endif


/*
 * constants & macros for individual HW_LCDIF_DEBUG0 bitfields
 */
/* --- Register HW_LCDIF_DEBUG0, field STREAMING_END_DETECTED */

#define BP_LCDIF_DEBUG0_STREAMING_END_DETECTED      31
#define BM_LCDIF_DEBUG0_STREAMING_END_DETECTED      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DEBUG0_STREAMING_END_DETECTED(v)   ((((reg32_t) v) << 31) & BM_LCDIF_DEBUG0_STREAMING_END_DETECTED)
#else
#define BF_LCDIF_DEBUG0_STREAMING_END_DETECTED(v)   (((v) << 31) & BM_LCDIF_DEBUG0_STREAMING_END_DETECTED)
#endif
/* --- Register HW_LCDIF_DEBUG0, field WAIT_FOR_VSYNC_EDGE_OUT */

#define BP_LCDIF_DEBUG0_WAIT_FOR_VSYNC_EDGE_OUT      30
#define BM_LCDIF_DEBUG0_WAIT_FOR_VSYNC_EDGE_OUT      0x40000000

#define BF_LCDIF_DEBUG0_WAIT_FOR_VSYNC_EDGE_OUT(v)   (((v) << 30) & BM_LCDIF_DEBUG0_WAIT_FOR_VSYNC_EDGE_OUT)
/* --- Register HW_LCDIF_DEBUG0, field SYNC_SIGNALS_ON_REG */

#define BP_LCDIF_DEBUG0_SYNC_SIGNALS_ON_REG      29
#define BM_LCDIF_DEBUG0_SYNC_SIGNALS_ON_REG      0x20000000

#define BF_LCDIF_DEBUG0_SYNC_SIGNALS_ON_REG(v)   (((v) << 29) & BM_LCDIF_DEBUG0_SYNC_SIGNALS_ON_REG)
/* --- Register HW_LCDIF_DEBUG0, field DMACMDKICK */

#define BP_LCDIF_DEBUG0_DMACMDKICK      28
#define BM_LCDIF_DEBUG0_DMACMDKICK      0x10000000

#define BF_LCDIF_DEBUG0_DMACMDKICK(v)   (((v) << 28) & BM_LCDIF_DEBUG0_DMACMDKICK)
/* --- Register HW_LCDIF_DEBUG0, field ENABLE */

#define BP_LCDIF_DEBUG0_ENABLE      27
#define BM_LCDIF_DEBUG0_ENABLE      0x08000000

#define BF_LCDIF_DEBUG0_ENABLE(v)   (((v) << 27) & BM_LCDIF_DEBUG0_ENABLE)
/* --- Register HW_LCDIF_DEBUG0, field HSYNC */

#define BP_LCDIF_DEBUG0_HSYNC      26
#define BM_LCDIF_DEBUG0_HSYNC      0x04000000

#define BF_LCDIF_DEBUG0_HSYNC(v)   (((v) << 26) & BM_LCDIF_DEBUG0_HSYNC)
/* --- Register HW_LCDIF_DEBUG0, field VSYNC */

#define BP_LCDIF_DEBUG0_VSYNC      25
#define BM_LCDIF_DEBUG0_VSYNC      0x02000000

#define BF_LCDIF_DEBUG0_VSYNC(v)   (((v) << 25) & BM_LCDIF_DEBUG0_VSYNC)
/* --- Register HW_LCDIF_DEBUG0, field CUR_FRAME_TX */

#define BP_LCDIF_DEBUG0_CUR_FRAME_TX      24
#define BM_LCDIF_DEBUG0_CUR_FRAME_TX      0x01000000

#define BF_LCDIF_DEBUG0_CUR_FRAME_TX(v)   (((v) << 24) & BM_LCDIF_DEBUG0_CUR_FRAME_TX)
/* --- Register HW_LCDIF_DEBUG0, field EMPTY_WORD */

#define BP_LCDIF_DEBUG0_EMPTY_WORD      23
#define BM_LCDIF_DEBUG0_EMPTY_WORD      0x00800000

#define BF_LCDIF_DEBUG0_EMPTY_WORD(v)   (((v) << 23) & BM_LCDIF_DEBUG0_EMPTY_WORD)
/* --- Register HW_LCDIF_DEBUG0, field CUR_STATE */

#define BP_LCDIF_DEBUG0_CUR_STATE      16
#define BM_LCDIF_DEBUG0_CUR_STATE      0x007F0000

#define BF_LCDIF_DEBUG0_CUR_STATE(v)   (((v) << 16) & BM_LCDIF_DEBUG0_CUR_STATE)
/* --- Register HW_LCDIF_DEBUG0, field PXP_LCDIF_B0_READY */

#define BP_LCDIF_DEBUG0_PXP_LCDIF_B0_READY      15
#define BM_LCDIF_DEBUG0_PXP_LCDIF_B0_READY      0x00008000

#define BF_LCDIF_DEBUG0_PXP_LCDIF_B0_READY(v)   (((v) << 15) & BM_LCDIF_DEBUG0_PXP_LCDIF_B0_READY)
/* --- Register HW_LCDIF_DEBUG0, field LCDIF_PXP_B0_DONE */

#define BP_LCDIF_DEBUG0_LCDIF_PXP_B0_DONE      14
#define BM_LCDIF_DEBUG0_LCDIF_PXP_B0_DONE      0x00004000

#define BF_LCDIF_DEBUG0_LCDIF_PXP_B0_DONE(v)   (((v) << 14) & BM_LCDIF_DEBUG0_LCDIF_PXP_B0_DONE)
/* --- Register HW_LCDIF_DEBUG0, field PXP_LCDIF_B1_READY */

#define BP_LCDIF_DEBUG0_PXP_LCDIF_B1_READY      13
#define BM_LCDIF_DEBUG0_PXP_LCDIF_B1_READY      0x00002000

#define BF_LCDIF_DEBUG0_PXP_LCDIF_B1_READY(v)   (((v) << 13) & BM_LCDIF_DEBUG0_PXP_LCDIF_B1_READY)
/* --- Register HW_LCDIF_DEBUG0, field LCDIF_PXP_B1_DONE */

#define BP_LCDIF_DEBUG0_LCDIF_PXP_B1_DONE      12
#define BM_LCDIF_DEBUG0_LCDIF_PXP_B1_DONE      0x00001000

#define BF_LCDIF_DEBUG0_LCDIF_PXP_B1_DONE(v)   (((v) << 12) & BM_LCDIF_DEBUG0_LCDIF_PXP_B1_DONE)
/* --- Register HW_LCDIF_DEBUG0, field CUR_REQ_STATE */

#define BP_LCDIF_DEBUG0_CUR_REQ_STATE      10
#define BM_LCDIF_DEBUG0_CUR_REQ_STATE      0x00000C00

#define BF_LCDIF_DEBUG0_CUR_REQ_STATE(v)   (((v) << 10) & BM_LCDIF_DEBUG0_CUR_REQ_STATE)
/* --- Register HW_LCDIF_DEBUG0, field MST_AVALID */

#define BP_LCDIF_DEBUG0_MST_AVALID      9
#define BM_LCDIF_DEBUG0_MST_AVALID      0x00000200

#define BF_LCDIF_DEBUG0_MST_AVALID(v)   (((v) << 9) & BM_LCDIF_DEBUG0_MST_AVALID)
/* --- Register HW_LCDIF_DEBUG0, field MST_OUTSTANDING_REQS */

#define BP_LCDIF_DEBUG0_MST_OUTSTANDING_REQS      4
#define BM_LCDIF_DEBUG0_MST_OUTSTANDING_REQS      0x000001F0

#define BF_LCDIF_DEBUG0_MST_OUTSTANDING_REQS(v)   (((v) << 4) & BM_LCDIF_DEBUG0_MST_OUTSTANDING_REQS)
/* --- Register HW_LCDIF_DEBUG0, field MST_WORDS */

#define BP_LCDIF_DEBUG0_MST_WORDS      0
#define BM_LCDIF_DEBUG0_MST_WORDS      0x0000000F

#define BF_LCDIF_DEBUG0_MST_WORDS(v)   (((v) << 0) & BM_LCDIF_DEBUG0_MST_WORDS)


/*
 * HW_LCDIF_DEBUG1 - LCD Interface Debug1 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned V_DATA_COUNT  : 16;
        unsigned H_DATA_COUNT  : 16;
    } B;
} hw_lcdif_debug1_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DEBUG1 register
 */
#define HW_LCDIF_DEBUG1_ADDR         (REGS_LCDIF_BASE + 0x1e0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DEBUG1           (*(volatile hw_lcdif_debug1_t *) HW_LCDIF_DEBUG1_ADDR)
#define HW_LCDIF_DEBUG1_RD()      (HW_LCDIF_DEBUG1.U)
#endif


/*
 * constants & macros for individual HW_LCDIF_DEBUG1 bitfields
 */
/* --- Register HW_LCDIF_DEBUG1, field H_DATA_COUNT */

#define BP_LCDIF_DEBUG1_H_DATA_COUNT      16
#define BM_LCDIF_DEBUG1_H_DATA_COUNT      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DEBUG1_H_DATA_COUNT(v)   ((((reg32_t) v) << 16) & BM_LCDIF_DEBUG1_H_DATA_COUNT)
#else
#define BF_LCDIF_DEBUG1_H_DATA_COUNT(v)   (((v) << 16) & BM_LCDIF_DEBUG1_H_DATA_COUNT)
#endif
/* --- Register HW_LCDIF_DEBUG1, field V_DATA_COUNT */

#define BP_LCDIF_DEBUG1_V_DATA_COUNT      0
#define BM_LCDIF_DEBUG1_V_DATA_COUNT      0x0000FFFF

#define BF_LCDIF_DEBUG1_V_DATA_COUNT(v)   (((v) << 0) & BM_LCDIF_DEBUG1_V_DATA_COUNT)


/*
 * HW_LCDIF_DEBUG2 - LCD Interface Debug2 Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned MST_ADDRESS  : 32;
    } B;
} hw_lcdif_debug2_t;
#endif

/*
 * constants & macros for entire HW_LCDIF_DEBUG2 register
 */
#define HW_LCDIF_DEBUG2_ADDR         (REGS_LCDIF_BASE + 0x1f0)

#ifndef __LANGUAGE_ASM__
#define HW_LCDIF_DEBUG2           (*(volatile hw_lcdif_debug2_t *) HW_LCDIF_DEBUG2_ADDR)
#define HW_LCDIF_DEBUG2_RD()      (HW_LCDIF_DEBUG2.U)
#endif


/*
 * constants & macros for individual HW_LCDIF_DEBUG2 bitfields
 */
/* --- Register HW_LCDIF_DEBUG2, field MST_ADDRESS */

#define BP_LCDIF_DEBUG2_MST_ADDRESS      0
#define BM_LCDIF_DEBUG2_MST_ADDRESS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_LCDIF_DEBUG2_MST_ADDRESS(v)   ((reg32_t) v)
#else
#define BF_LCDIF_DEBUG2_MST_ADDRESS(v)   (v)
#endif

#endif /* _LCDIF_H */

////////////////////////////////////////////////////////////////////////////////
