/*
 * Decompiled with CFR 0.152.
 */
package org.iotivity.cloud.accountserver.oauth;

import java.util.HashMap;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.iotivity.cloud.accountserver.db.TokenTable;
import org.iotivity.cloud.accountserver.db.UserTable;
import org.iotivity.cloud.accountserver.oauth.OAuthProvider;
import org.iotivity.cloud.base.exception.ServerException;
import org.iotivity.cloud.util.JSONUtil;
import org.iotivity.cloud.util.Log;

public class Google
implements OAuthProvider {
    private static final String client_id = "447649044559-f9r5sl6op3kkk0312u384o4g6hhucje1.apps.googleusercontent.com";
    private static final String secret = "LyTe5_EQkv8-v9Zbq20PSCLR";
    private static final String redirect_url = "http://www.example.com/oauth2callback";
    private static final String resource_url = "https://www.googleapis.com/userinfo/v2/me";

    public TokenTable requestAccessTokenInfo(String authCode, Object options) {
        TokenTable tokenInfo = new TokenTable();
        if (authCode == null) {
            Log.w((String)"authCode is null!");
            return tokenInfo;
        }
        try {
            OAuthClientRequest request = OAuthClientRequest.tokenProvider((OAuthProviderType)OAuthProviderType.GOOGLE).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(client_id).setClientSecret(secret).setCode(authCode).setRedirectURI(redirect_url).buildBodyMessage();
            OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthAccessTokenResponse oauthResponse = null;
            Class<OAuthJSONAccessTokenResponse> cl = OAuthJSONAccessTokenResponse.class;
            oauthResponse = oauthClient.accessToken(request, cl);
            Log.d((String)("OAuth response: " + oauthResponse.getBody()));
            tokenInfo.setAccesstoken((Object)oauthResponse.getAccessToken());
            tokenInfo.setRefreshtoken((Object)oauthResponse.getRefreshToken());
            tokenInfo.setExpiredtime((Object)oauthResponse.getExpiresIn());
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            e.printStackTrace();
            throw new ServerException.InternalServerErrorException("OAuth provider(Google) error");
        }
        return tokenInfo;
    }

    public TokenTable requestRefreshTokenInfo(String refreshToken) {
        TokenTable tokenInfo = new TokenTable();
        if (refreshToken == null) {
            Log.w((String)"refreshToken is null!");
            return tokenInfo;
        }
        try {
            OAuthClientRequest request = OAuthClientRequest.tokenProvider((OAuthProviderType)OAuthProviderType.GOOGLE).setGrantType(GrantType.REFRESH_TOKEN).setClientId(client_id).setClientSecret(secret).setRefreshToken(refreshToken).buildBodyMessage();
            OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthAccessTokenResponse oauthResponse = null;
            Class<OAuthJSONAccessTokenResponse> cl = OAuthJSONAccessTokenResponse.class;
            oauthResponse = oauthClient.accessToken(request, cl);
            Log.d((String)("OAuth response: " + oauthResponse.getBody()));
            tokenInfo.setAccesstoken((Object)oauthResponse.getAccessToken());
            tokenInfo.setRefreshtoken((Object)refreshToken);
            tokenInfo.setExpiredtime((Object)oauthResponse.getExpiresIn());
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            e.printStackTrace();
            throw new ServerException.InternalServerErrorException("OAuth provider(Google) error");
        }
        return tokenInfo;
    }

    public UserTable requestGetUserInfo(String accessToken, Object options) {
        UserTable userInfo = new UserTable();
        if (accessToken == null) {
            Log.w((String)"accessToken is null!");
            return userInfo;
        }
        String response = null;
        try {
            OAuthClientRequest request = new OAuthBearerClientRequest(resource_url).setAccessToken(accessToken).buildQueryMessage();
            OAuthClient oAuthClient = new OAuthClient((HttpClient)new URLConnectionClient());
            OAuthResourceResponse resourceResponse = (OAuthResourceResponse)oAuthClient.resource(request, "GET", OAuthResourceResponse.class);
            response = resourceResponse.getBody();
            Log.d((String)("response: " + response));
        }
        catch (OAuthProblemException | OAuthSystemException e) {
            e.printStackTrace();
            throw new ServerException.InternalServerErrorException("OAuth provider(Github) error");
        }
        String userIdKey = "name";
        JSONUtil util = new JSONUtil();
        HashMap parsedData = (HashMap)util.parseJSON(response, HashMap.class);
        if (parsedData == null) {
            Log.d((String)"parsedData is null!");
            return userInfo;
        }
        String userId = (String)parsedData.get(userIdKey);
        userInfo.setUserid((Object)userId);
        return userInfo;
    }
}

