/* state-play.c generated by valac 0.32.1, the Vala compiler
 * generated from state-play.vala, do not modify */

/*   FILE: state-play.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <grilo.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;

#define TYPE_STATE_PLAY (state_play_get_type ())
#define STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_PLAY, StatePlay))
#define STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_PLAY, StatePlayClass))
#define IS_STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_PLAY))
#define IS_STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_PLAY))
#define STATE_PLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_PLAY, StatePlayClass))

typedef struct _StatePlay StatePlay;
typedef struct _StatePlayClass StatePlayClass;
typedef struct _StatePlayPrivate StatePlayPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StatePlay {
	State parent_instance;
	StatePlayPrivate * priv;
};

struct _StatePlayClass {
	StateClass parent_class;
};

struct _StatePlayPrivate {
	GMainLoop* loop;
	GeeArrayList* playlist;
	gint current;
	guint watch_id;
};

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};


static gpointer state_play_parent_class = NULL;
static GOnce state_play_instance;
static GOnce state_play_instance = G_ONCE_INIT;

#define SCAN_JUMP_SECONDS ((gint64) 5)
#define FORWARD TRUE
#define BACKWARD FALSE
GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType state_play_get_type (void) G_GNUC_CONST;
#define STATE_PLAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATE_PLAY, StatePlayPrivate))
enum  {
	STATE_PLAY_DUMMY_PROPERTY
};
static StatePlay* state_play_new (void);
static StatePlay* state_play_construct (GType object_type);
State* state_construct (GType object_type);
StatePlay* state_play_get_instance (GMainLoop* loop, LCDPlayer* player, GeeArrayList* playlist);
static StatePlay* __lambda6_ (void);
static gpointer ___lambda6__gthread_func (gpointer self);
static gboolean state_play_play (StatePlay* self);
static gboolean _state_play_play_gsource_func (gpointer self);
static void state_play_real_print_selected (State* base);
void state_output (State* self, const gchar* str);
static gboolean state_play_bus_callback (StatePlay* self, GstBus* bus, GstMessage* message);
static void state_play_forward_track (StatePlay* self);
static void state_play_real_seekback (State* base);
static void state_play_back_track (StatePlay* self);
static void state_play_real_seekforward (State* base);
static void state_play_real_next (State* base);
static gint64 state_play_seek (StatePlay* self, gboolean forward);
static void state_play_real_previous (State* base);
static inline void _dynamic_set_uri0 (GstElement* obj, const gchar* value);
static inline void _dynamic_set_current_audio1 (GstElement* obj, gint value);
static gboolean _state_play_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
static State* state_play_real_transition (State* base);
void state_print_selected (State* self);
static void state_play_finalize (GObject* obj);


static StatePlay* state_play_construct (GType object_type) {
	StatePlay * self = NULL;
	self = (StatePlay*) state_construct (object_type);
	return self;
}


static StatePlay* state_play_new (void) {
	return state_play_construct (TYPE_STATE_PLAY);
}


static StatePlay* __lambda6_ (void) {
	StatePlay* result = NULL;
	StatePlay* _tmp0_ = NULL;
	_tmp0_ = state_play_new ();
	result = _tmp0_;
	return result;
}


static gpointer ___lambda6__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda6_ ();
	return result;
}


static gpointer _g_main_loop_ref0 (gpointer self) {
	return self ? g_main_loop_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _state_play_play_gsource_func (gpointer self) {
	gboolean result;
	result = state_play_play ((StatePlay*) self);
	return result;
}


StatePlay* state_play_get_instance (GMainLoop* loop, LCDPlayer* player, GeeArrayList* playlist) {
	StatePlay* result = NULL;
	StatePlay* state_play = NULL;
	gconstpointer _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	GMainLoop* _tmp2_ = NULL;
	LCDPlayer* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	g_return_val_if_fail (loop != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (playlist != NULL, NULL);
	_tmp0_ = g_once (&state_play_instance, ___lambda6__gthread_func, NULL);
	state_play = (StatePlay*) _tmp0_;
	state_play->priv->current = 0;
	_tmp1_ = loop;
	_tmp2_ = _g_main_loop_ref0 (_tmp1_);
	_g_main_loop_unref0 (state_play->priv->loop);
	state_play->priv->loop = _tmp2_;
	_tmp3_ = player;
	((State*) state_play)->player = _tmp3_;
	_tmp4_ = playlist;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (state_play->priv->playlist);
	state_play->priv->playlist = _tmp5_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _state_play_play_gsource_func, g_object_ref (state_play), g_object_unref);
	result = state_play;
	return result;
}


static void state_play_real_print_selected (State* base) {
	StatePlay * self;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GrlMedia* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	self = (StatePlay*) base;
	_tmp0_ = self->priv->playlist;
	_tmp1_ = self->priv->current;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
	_tmp3_ = (GrlMedia*) _tmp2_;
	_tmp4_ = grl_media_get_title (_tmp3_);
	state_output ((State*) self, _tmp4_);
	_g_object_unref0 (_tmp3_);
}


static gboolean state_play_bus_callback (StatePlay* self, GstBus* bus, GstMessage* message) {
	gboolean result = FALSE;
	gboolean fnval = FALSE;
	GstMessage* _tmp0_ = NULL;
	GstMessageType _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	fnval = TRUE;
	_tmp0_ = message;
	_tmp1_ = _tmp0_->type;
	switch (_tmp1_) {
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug = NULL;
			GstMessage* _tmp2_ = NULL;
			GError* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			GString* builder = NULL;
			GString* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp2_ = message;
			gst_message_parse_error (_tmp2_, &_tmp3_, &_tmp4_);
			_g_error_free0 (err);
			err = _tmp3_;
			_g_free0 (debug);
			debug = _tmp4_;
			_tmp5_ = g_string_new ("");
			builder = _tmp5_;
			_tmp6_ = err->message;
			g_string_printf (builder, "Error: %s\n", _tmp6_);
			_tmp7_ = builder->str;
			state_output ((State*) self, _tmp7_);
			exit (1);
			_g_string_free0 (builder);
			_g_free0 (debug);
			_g_error_free0 (err);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			state_play_forward_track (self);
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _state_play_play_gsource_func, g_object_ref (self), g_object_unref);
			fnval = FALSE;
			break;
		}
		default:
		{
			break;
		}
	}
	result = fnval;
	return result;
}


static void state_play_real_seekback (State* base) {
	StatePlay * self;
	self = (StatePlay*) base;
	state_play_back_track (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _state_play_play_gsource_func, g_object_ref (self), g_object_unref);
}


static void state_play_real_seekforward (State* base) {
	StatePlay * self;
	self = (StatePlay*) base;
	state_play_forward_track (self);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _state_play_play_gsource_func, g_object_ref (self), g_object_unref);
}


static void state_play_real_next (State* base) {
	StatePlay * self;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gint64 position = 0LL;
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	self = (StatePlay*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state_play_seek (self, FORWARD);
	position = _tmp1_;
	g_string_printf (builder, "%" G_GINT64_FORMAT ":%.2" G_GINT64_FORMAT, position / (GST_SECOND * 60), (position / GST_SECOND) % 60);
	_tmp2_ = builder->str;
	state_output ((State*) self, _tmp2_);
	_g_string_free0 (builder);
}


static void state_play_real_previous (State* base) {
	StatePlay * self;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gint64 position = 0LL;
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	self = (StatePlay*) base;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = state_play_seek (self, BACKWARD);
	position = _tmp1_;
	g_string_printf (builder, "%" G_GINT64_FORMAT ":%.2" G_GINT64_FORMAT, position / (GST_SECOND * 60), (position / GST_SECOND) % 60);
	_tmp2_ = builder->str;
	state_output ((State*) self, _tmp2_);
	_g_string_free0 (builder);
}


static inline void _dynamic_set_uri0 (GstElement* obj, const gchar* value) {
	g_object_set (obj, "uri", value, NULL);
}


static inline void _dynamic_set_current_audio1 (GstElement* obj, gint value) {
	g_object_set (obj, "current-audio", value, NULL);
}


static gboolean _state_play_bus_callback_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
	gboolean result;
	result = state_play_bus_callback ((StatePlay*) self, bus, message);
	return result;
}


static gboolean state_play_play (StatePlay* self) {
	gboolean result = FALSE;
	GrlMedia* media = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	LCDPlayer* _tmp3_ = NULL;
	GstElement* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	LCDPlayer* _tmp6_ = NULL;
	GstElement* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	LCDPlayer* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	GrlKeyID _tmp11_ = 0U;
	gint _tmp12_ = 0;
	GstBus* bus = NULL;
	LCDPlayer* _tmp13_ = NULL;
	GstElement* _tmp14_ = NULL;
	GstBus* _tmp15_ = NULL;
	guint _tmp16_ = 0U;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	LCDPlayer* _tmp20_ = NULL;
	GstElement* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->playlist;
	_tmp1_ = self->priv->current;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
	media = (GrlMedia*) _tmp2_;
	_tmp3_ = ((State*) self)->player;
	_tmp4_ = _tmp3_->element;
	gst_element_set_state (_tmp4_, GST_STATE_NULL);
	_tmp5_ = self->priv->watch_id;
	g_source_remove (_tmp5_);
	_tmp6_ = ((State*) self)->player;
	_tmp7_ = _tmp6_->element;
	_tmp8_ = grl_media_get_url (media);
	_dynamic_set_uri0 (_tmp7_, _tmp8_);
	_tmp9_ = ((State*) self)->player;
	_tmp10_ = _tmp9_->element;
	_tmp11_ = GRL_METADATA_KEY_AUDIO_TRACK;
	_tmp12_ = grl_data_get_int ((GrlData*) media, _tmp11_);
	_dynamic_set_current_audio1 (_tmp10_, _tmp12_);
	_tmp13_ = ((State*) self)->player;
	_tmp14_ = _tmp13_->element;
	_tmp15_ = gst_element_get_bus (_tmp14_);
	bus = _tmp15_;
	_tmp16_ = gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _state_play_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
	self->priv->watch_id = _tmp16_;
	_tmp17_ = grl_media_get_title (media);
	_tmp18_ = g_strconcat ("Playing ", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	state_output ((State*) self, _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = ((State*) self)->player;
	_tmp21_ = _tmp20_->element;
	gst_element_set_state (_tmp21_, GST_STATE_PLAYING);
	result = FALSE;
	_g_object_unref0 (bus);
	_g_object_unref0 (media);
	return result;
}


static State* state_play_real_transition (State* base) {
	StatePlay * self;
	State* result = NULL;
	State* _tmp0_ = NULL;
	self = (StatePlay*) base;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _state_play_play_gsource_func, g_object_ref (self), g_object_unref);
	_tmp0_ = _g_object_ref0 ((State*) self);
	result = _tmp0_;
	return result;
}


static void state_play_forward_track (StatePlay* self) {
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->playlist;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->current = (_tmp0_ + 1) % _tmp3_;
	state_print_selected ((State*) self);
}


static void state_play_back_track (StatePlay* self) {
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->playlist;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->playlist;
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->current = (_tmp0_ + (_tmp3_ - 1)) % _tmp6_;
	state_print_selected ((State*) self);
}


static gint64 state_play_seek (StatePlay* self, gboolean forward) {
	gint64 result = 0LL;
	gint64 current_position = 0LL;
	gint64 next_position = 0LL;
	LCDPlayer* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	LCDPlayer* _tmp9_ = NULL;
	GstElement* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = ((State*) self)->player;
	_tmp1_ = _tmp0_->element;
	gst_element_query_position (_tmp1_, GST_FORMAT_TIME, &_tmp2_);
	current_position = _tmp2_;
	_tmp4_ = forward;
	if (_tmp4_) {
		_tmp3_ = 1;
	} else {
		_tmp3_ = -1;
	}
	_tmp5_ = current_position;
	next_position = _tmp5_ + ((SCAN_JUMP_SECONDS * GST_SECOND) * _tmp3_);
	_tmp7_ = next_position;
	if (_tmp7_ < ((gint64) 0)) {
		_tmp6_ = (gint64) 0;
	} else {
		gint64 _tmp8_ = 0LL;
		_tmp8_ = next_position;
		_tmp6_ = _tmp8_;
	}
	next_position = _tmp6_;
	_tmp9_ = ((State*) self)->player;
	_tmp10_ = _tmp9_->element;
	_tmp11_ = next_position;
	gst_element_seek_simple (_tmp10_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, _tmp11_);
	result = next_position;
	return result;
}


static void state_play_class_init (StatePlayClass * klass) {
	state_play_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatePlayPrivate));
	((StateClass *) klass)->print_selected = state_play_real_print_selected;
	((StateClass *) klass)->seekback = state_play_real_seekback;
	((StateClass *) klass)->seekforward = state_play_real_seekforward;
	((StateClass *) klass)->next = state_play_real_next;
	((StateClass *) klass)->previous = state_play_real_previous;
	((StateClass *) klass)->transition = state_play_real_transition;
	G_OBJECT_CLASS (klass)->finalize = state_play_finalize;
}


static void state_play_instance_init (StatePlay * self) {
	self->priv = STATE_PLAY_GET_PRIVATE (self);
	self->priv->watch_id = (guint) 0;
}


static void state_play_finalize (GObject* obj) {
	StatePlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATE_PLAY, StatePlay);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->playlist);
	G_OBJECT_CLASS (state_play_parent_class)->finalize (obj);
}


GType state_play_get_type (void) {
	static volatile gsize state_play_type_id__volatile = 0;
	if (g_once_init_enter (&state_play_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StatePlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_play_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatePlay), 0, (GInstanceInitFunc) state_play_instance_init, NULL };
		GType state_play_type_id;
		state_play_type_id = g_type_register_static (TYPE_STATE, "StatePlay", &g_define_type_info, 0);
		g_once_init_leave (&state_play_type_id__volatile, state_play_type_id);
	}
	return state_play_type_id__volatile;
}



