/*
 * ndpi_content_match.c
 *
 * Copyright (C) 2011-16 - ntop.org
 *
 * nDPI is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * nDPI is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with nDPI.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/* ****************************************************** */

static ndpi_network host_protocol_list[] = {

 /*
   OpenDNS
   208.67.216.0/21
 */
   { 0xD043D800 /* 208.67.216.0/21 */, 21, NDPI_SERVICE_OPENDNS },

 /*   
    Microsoft Corporation (MS One Drive)
    204.79.195.0/24
    204.79.196.0/23
    134.170.0.0/16
    131.253.12.0/22
    131.253.16.0/23
    131.253.18.0/24
    65.54.191.0/24 
  */
  { 0xCC4FC300 /* 204.79.195.0/24 */, 24, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0xCC4FC400 /* 204.79.196.0/23 */, 23, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0x86AA0000 /* 134.170.0.0/16  */, 16, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0x83FD0C00 /* 131.253.12.0/22 */, 22, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0x83FD1000 /* 131.253.16.0/23 */, 23, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0x83FD1200 /* 131.253.18.0/24 */, 24, NDPI_SERVICE_MS_ONE_DRIVE },
  { 0x4136BF00 /* 65.54.191.0/24   */, 24, NDPI_SERVICE_MS_ONE_DRIVE },

 /*    
    Amazon-EU-AWS Elastic Compute Cloud, EC2 (also used by Netflix)
    46.137.128.0/18
  */
  { 0x2E898000 /* 46.137.128.0/18 */, 18, NDPI_SERVICE_AMAZON },
  
 /*    
    Amazon-EU (also used by Netflix)
    176.34.184.0/21
  */
  { 0xB022B800 /* 176.34.184.0/21 */, 21, NDPI_SERVICE_AMAZON },

 /*    
    Netflix
    23.246.0.0/18
    23.21.190.124/32
  */
  { 0x17F60000 /* 23.246.0.0/18 */, 18, NDPI_SERVICE_NETFLIX },
  { 0x1715BE7C /* 23.21.190.124/32 */, 32, NDPI_SERVICE_NETFLIX },

  /*    
    Cloudflare
    104.16.0.0/12
    173.245.48.0/20
    162.158.0.0/15
    141.101.125.0/24 CLOUDFLARE-EU CDN network
  */
  { 0x68100000 /* 104.16.0.0/12 */, 12, NDPI_SERVICE_CLOUDFLARE },
  { 0xADF53000 /* 173.245.48.0/20 */, 20, NDPI_SERVICE_CLOUDFLARE },
  { 0xA29E0000 /* 162.158.0.0/15 */, 15, NDPI_SERVICE_CLOUDFLARE },
  { 0x8D657D00 /* 141.101.125.0/24 */, 24, NDPI_SERVICE_CLOUDFLARE },

 /*    
    OFFICE 365
    13.107.1.0/24
    13.107.3.0/24
    13.107.4.0/24
    13.107.5.0/24
    13.107.6.0/24
    13.107.7.0/24
    13.107.9.0/24
    13.107.12.0/24
    13.107.13.0/24
    13.107.15.0/24
    13.107.16.0/24
  */
  { 0x0D6B0100 /* 13.107.1.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0300 /* 13.107.3.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0400 /* 13.107.4.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0500 /* 13.107.5.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0600 /* 13.107.6.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0700 /* 13.107.7.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0900 /* 13.107.9.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0C00 /* 13.107.12.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0D00 /* 13.107.13.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B0F00 /* 13.107.15.0 */, 24 , NDPI_SERVICE_OFFICE_365 },
  { 0x0D6B1000 /* 13.107.16.0 */, 24 , NDPI_SERVICE_OFFICE_365 },

  /*    
    OCS GO (Orange Cinéma Séries)
    178.248.208.0/21
  */
  { 0xB2F8D000 /* 178.248.208.0 */, 21, NDPI_SERVICE_OCS },

  /*
    Citrix GotoMeeting (AS16815, AS21866)
    216.115.208.0/20
    216.219.112.0/20
  */
  { 0xD873D000 /* 216.115.208.0 */, 20, NDPI_PROTOCOL_CITRIX_ONLINE },
  { 0xD8DB7000 /* 216.219.112.0 */, 20, NDPI_PROTOCOL_CITRIX_ONLINE },

  /*
    Webex
    66.114.160.0/20
  */
  { 0x4272A000 /* 66.114.160.0 */, 20, NDPI_PROTOCOL_WEBEX },

  /*
    Viber Media AWS-VIBER-MEDIA (NET-54-169-63-160-1) 54.169.63.160 - 54.169.63.191
    Viber Media S a r l AWS-VIBER-MEDIA-S-A-R-L (NET-54-93-255-64-1) 54.93.255.64 - 54.93.255.127
    Crittercism AWS-VIBER-MEDIA (NET-52-0-252-0-1) 52.0.252.0 - 52.0.255.255
    54.169.63.160/27
    54.93.255.64/26
    52.0.252.0/22
  */
  { 0x36A93FA0 /* 54.169.63.160 */, 27, NDPI_PROTOCOL_VIBER },
  { 0x365DFF40 /* 54.93.255.64 */, 26, NDPI_PROTOCOL_VIBER },
  { 0x3400FC00 /* 52.0.252.0 */, 22, NDPI_PROTOCOL_VIBER },

  /*
    Apple (FaceTime, iMessage,...)
    17.0.0.0/8
  */
  { 0x11000000 /* 17.0.0.0 */, 8, NDPI_SERVICE_APPLE },

  /*
    Dropbox
    108.160.160.0/20
    199.47.216.0/22
    45.58.64.0/20
  */
  { 0x6CA0A000 /* 108.160.160.0 */, 20, NDPI_PROTOCOL_DROPBOX },
  { 0xC72FD800 /* 199.47.216.0 */, 22, NDPI_PROTOCOL_DROPBOX },
  { 0x2D3A4000 /* 45.58.64.0 */, 20, NDPI_PROTOCOL_DROPBOX },

  /*
    Skype (Microsoft CDN)
    157.56.0.0/14, 157.60.0.0/16, 157.54.0.0/15
    111.221.64.0 - 111.221.127.255
    91.190.216.0/21 (AS198015 Skype Communications Sarl)
    40.126.129.109/32
  */
  { 0x9D380000 /* 157.56.0.0 */, 14, NDPI_PROTOCOL_SKYPE },
  { 0x9D3C0000 /* 157.60.0.0 */, 16, NDPI_PROTOCOL_SKYPE },
  { 0x9D360000 /* 157.54.0.0 */, 15, NDPI_PROTOCOL_SKYPE },
  { 0x6FDD4000 /* 111.221.64.0 */, 18, NDPI_PROTOCOL_SKYPE },
  { 0x5BBED800 /* 91.190.216.0 */, 21, NDPI_PROTOCOL_SKYPE },
  { 0x287F816D /* 40.126.129.109 */, 32, NDPI_PROTOCOL_SKYPE },
  

  /*
    route:          5.42.160.0/19
    descr:          Blizzard Entertainment, Inc
    origin:         AS57976
  */
  { 0x052AA000 /* 5.42.160.0 */, 19, NDPI_PROTOCOL_STARCRAFT },

  /*
    Google
    173.194.0.0/16
    74.125.0.0/16
    64.233.160.0/19
    216.58.192.0/19
  */
  { 0xADC20000 /* 173.194.0.0 */, 16, NDPI_SERVICE_GOOGLE },
  { 0x4A7D0000 /* 74.125.0.0  */, 16, NDPI_SERVICE_GOOGLE },
  { 0x40E91600 /* 64.233.160.0 */, 19, NDPI_SERVICE_GOOGLE },
  { 0xD83AC000 /* 216.58.192.0 */, 19, NDPI_SERVICE_GOOGLE },
  
  /*
    Ubuntu One
    91.189.89.0/21 (255.255.248.0)
  */
  { 0x5BBD5900 /* 91.189.89.0 */, 21, NDPI_PROTOCOL_UBUNTUONE},

  /*
    Telegram
    route:          149.154.164.0/22
    descr:          Telegram Messenger Amsterdam Network
    origin:         AS62041
    mnt-by:         MNT-TELEGRAM
    source:         RIPE # Filtered

    route:          149.154.168.0/22
    descr:          Telegram Messenger DC5 Network
    origin:         AS62014
    mnt-by:         MNT-TELEGRAM
    source:         RIPE # Filtered

    http://myip.ms/view/web_hosting/363906/Telegram_Messenger_Network.html
  */
  { 0x959AA400 /* 149.154.164.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM},
  { 0x959AA800 /* 149.154.168.0/22 */, 22, NDPI_PROTOCOL_TELEGRAM},

  /* TOR  */
  { 0x012A1231, 32, NDPI_PROTOCOL_TOR },
  { 0x01E69FA1, 32, NDPI_PROTOCOL_TOR },
  { 0x020DE985, 32, NDPI_PROTOCOL_TOR },
  { 0x021D88C5, 32, NDPI_PROTOCOL_TOR },
  { 0x0221585B, 32, NDPI_PROTOCOL_TOR },
  { 0x023E1975, 32, NDPI_PROTOCOL_TOR },
  { 0x0255D62F, 32, NDPI_PROTOCOL_TOR },
  { 0x025B6A07, 32, NDPI_PROTOCOL_TOR },
  { 0x025CB2FE, 32, NDPI_PROTOCOL_TOR },
  { 0x025DFEE6, 32, NDPI_PROTOCOL_TOR },
  { 0x025E83A7, 32, NDPI_PROTOCOL_TOR },
  { 0x02683058, 32, NDPI_PROTOCOL_TOR },
  { 0x026AEE77, 32, NDPI_PROTOCOL_TOR },
  { 0x026B16BA, 32, NDPI_PROTOCOL_TOR },
  { 0x028BD8A9, 32, NDPI_PROTOCOL_TOR },
  { 0x02D9E930, 32, NDPI_PROTOCOL_TOR },
  { 0x02E18D86, 32, NDPI_PROTOCOL_TOR },
  { 0x02E1E75C, 32, NDPI_PROTOCOL_TOR },
  { 0x02E688B0, 32, NDPI_PROTOCOL_TOR },
  { 0x02E6A4FE, 32, NDPI_PROTOCOL_TOR },
  { 0x02E7F51D, 32, NDPI_PROTOCOL_TOR },
  { 0x02EAEAFB, 32, NDPI_PROTOCOL_TOR },
  { 0x02EB2A85, 32, NDPI_PROTOCOL_TOR },
  { 0x02F04269, 32, NDPI_PROTOCOL_TOR },
  { 0x02F0667E, 32, NDPI_PROTOCOL_TOR },
  { 0x02F0DA7F, 32, NDPI_PROTOCOL_TOR },
  { 0x02F183CC, 32, NDPI_PROTOCOL_TOR },
  { 0x02F1A8DE, 32, NDPI_PROTOCOL_TOR },
  { 0x02F2F217, 32, NDPI_PROTOCOL_TOR },
  { 0x02F2FBEB, 32, NDPI_PROTOCOL_TOR },
  { 0x02F4CD37, 32, NDPI_PROTOCOL_TOR },
  { 0x02F779C1, 32, NDPI_PROTOCOL_TOR },
  { 0x0422C8FD, 32, NDPI_PROTOCOL_TOR },
  { 0x0422C8FD, 32, NDPI_PROTOCOL_TOR },
  { 0x0501547D, 32, NDPI_PROTOCOL_TOR },
  { 0x05021027, 32, NDPI_PROTOCOL_TOR },
  { 0x050902CC, 32, NDPI_PROTOCOL_TOR },
  { 0x050906A3, 32, NDPI_PROTOCOL_TOR },
  { 0x05091513, 32, NDPI_PROTOCOL_TOR },
  { 0x05091ADB, 32, NDPI_PROTOCOL_TOR },
  { 0x05091ADB, 32, NDPI_PROTOCOL_TOR },
  { 0x0509254B, 32, NDPI_PROTOCOL_TOR },
  { 0x05092771, 32, NDPI_PROTOCOL_TOR },
  { 0x05092B03, 32, NDPI_PROTOCOL_TOR },
  { 0x05092B50, 32, NDPI_PROTOCOL_TOR },
  { 0x05093176, 32, NDPI_PROTOCOL_TOR },
  { 0x05093394, 32, NDPI_PROTOCOL_TOR },
  { 0x050933AE, 32, NDPI_PROTOCOL_TOR },
  { 0x0509362C, 32, NDPI_PROTOCOL_TOR },
  { 0x05093B4E, 32, NDPI_PROTOCOL_TOR },
  { 0x0509437C, 32, NDPI_PROTOCOL_TOR },
  { 0x05094F06, 32, NDPI_PROTOCOL_TOR },
  { 0x05094F9A, 32, NDPI_PROTOCOL_TOR },
  { 0x0509501C, 32, NDPI_PROTOCOL_TOR },
  { 0x050953CC, 32, NDPI_PROTOCOL_TOR },
  { 0x05095812, 32, NDPI_PROTOCOL_TOR },
  { 0x050959BD, 32, NDPI_PROTOCOL_TOR },
  { 0x05096C4A, 32, NDPI_PROTOCOL_TOR },
  { 0x05096C56, 32, NDPI_PROTOCOL_TOR },
  { 0x05096E85, 32, NDPI_PROTOCOL_TOR },
  { 0x05096EEC, 32, NDPI_PROTOCOL_TOR },
  { 0x050975D4, 32, NDPI_PROTOCOL_TOR },
  { 0x05097B51, 32, NDPI_PROTOCOL_TOR },
  { 0x050981DA, 32, NDPI_PROTOCOL_TOR },
  { 0x05098A9B, 32, NDPI_PROTOCOL_TOR },
  { 0x05098CC3, 32, NDPI_PROTOCOL_TOR },
  { 0x050997F1, 32, NDPI_PROTOCOL_TOR },
  { 0x05099C11, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E44, 32, NDPI_PROTOCOL_TOR },
  { 0x05099E4B, 32, NDPI_PROTOCOL_TOR },
  { 0x0509A92E, 32, NDPI_PROTOCOL_TOR },
  { 0x0509A92E, 32, NDPI_PROTOCOL_TOR },
  { 0x0509BF34, 32, NDPI_PROTOCOL_TOR },
  { 0x0509C38C, 32, NDPI_PROTOCOL_TOR },
  { 0x0509D4CE, 32, NDPI_PROTOCOL_TOR },
  { 0x0509D642, 32, NDPI_PROTOCOL_TOR },
  { 0x0509E35E, 32, NDPI_PROTOCOL_TOR },
  { 0x0509EAEE, 32, NDPI_PROTOCOL_TOR },
  { 0x050D3E81, 32, NDPI_PROTOCOL_TOR },
  { 0x050E066C, 32, NDPI_PROTOCOL_TOR },
  { 0x050E30B4, 32, NDPI_PROTOCOL_TOR },
  { 0x050E476B, 32, NDPI_PROTOCOL_TOR },
  { 0x050ECAE6, 32, NDPI_PROTOCOL_TOR },
  { 0x0513A267, 32, NDPI_PROTOCOL_TOR },
  { 0x0513B30A, 32, NDPI_PROTOCOL_TOR },
  { 0x0513EC45, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B70F, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B7CD, 32, NDPI_PROTOCOL_TOR },
  { 0x0522B7CF, 32, NDPI_PROTOCOL_TOR },
  { 0x05272D98, 32, NDPI_PROTOCOL_TOR },
  { 0x05273CF1, 32, NDPI_PROTOCOL_TOR },
  { 0x0527465F, 32, NDPI_PROTOCOL_TOR },
  { 0x05274C24, 32, NDPI_PROTOCOL_TOR },
  { 0x05274CB6, 32, NDPI_PROTOCOL_TOR },
  { 0x05274DD0, 32, NDPI_PROTOCOL_TOR },
  { 0x05274E65, 32, NDPI_PROTOCOL_TOR },
  { 0x05274FB5, 32, NDPI_PROTOCOL_TOR },
  { 0x0527501C, 32, NDPI_PROTOCOL_TOR },
  { 0x05275087, 32, NDPI_PROTOCOL_TOR },
  { 0x05275087, 32, NDPI_PROTOCOL_TOR },
  { 0x052752C0, 32, NDPI_PROTOCOL_TOR },
  { 0x052753D9, 32, NDPI_PROTOCOL_TOR },
  { 0x052754D9, 32, NDPI_PROTOCOL_TOR },
  { 0x052756CE, 32, NDPI_PROTOCOL_TOR },
  { 0x0527579C, 32, NDPI_PROTOCOL_TOR },
  { 0x05275808, 32, NDPI_PROTOCOL_TOR },
  { 0x05275813, 32, NDPI_PROTOCOL_TOR },
  { 0x05275836, 32, NDPI_PROTOCOL_TOR },
  { 0x0527597C, 32, NDPI_PROTOCOL_TOR },
  { 0x05277240, 32, NDPI_PROTOCOL_TOR },
  { 0x05277A42, 32, NDPI_PROTOCOL_TOR },
  { 0x05277A42, 32, NDPI_PROTOCOL_TOR },
  { 0x052A0AE5, 32, NDPI_PROTOCOL_TOR },
  { 0x052C634D, 32, NDPI_PROTOCOL_TOR },
  { 0x052C63A1, 32, NDPI_PROTOCOL_TOR },
  { 0x052C6B17, 32, NDPI_PROTOCOL_TOR },
  { 0x052D4824, 32, NDPI_PROTOCOL_TOR },
  { 0x052D4909, 32, NDPI_PROTOCOL_TOR },
  { 0x052D4D11, 32, NDPI_PROTOCOL_TOR },
  { 0x052D617F, 32, NDPI_PROTOCOL_TOR },
  { 0x052D626F, 32, NDPI_PROTOCOL_TOR },
  { 0x052D634B, 32, NDPI_PROTOCOL_TOR },
  { 0x052D688D, 32, NDPI_PROTOCOL_TOR },
  { 0x052D6CBD, 32, NDPI_PROTOCOL_TOR },
  { 0x0536FAC4, 32, NDPI_PROTOCOL_TOR },
  { 0x0538E13D, 32, NDPI_PROTOCOL_TOR },
  { 0x0538E4D0, 32, NDPI_PROTOCOL_TOR },
  { 0x053D223F, 32, NDPI_PROTOCOL_TOR },
  { 0x053D260B, 32, NDPI_PROTOCOL_TOR },
  { 0x053DA005, 32, NDPI_PROTOCOL_TOR },
  { 0x054F44A1, 32, NDPI_PROTOCOL_TOR },
  { 0x054F44A1, 32, NDPI_PROTOCOL_TOR },
  { 0x054F47C3, 32, NDPI_PROTOCOL_TOR },
  { 0x054F4E61, 32, NDPI_PROTOCOL_TOR },
  { 0x054F51C0, 32, NDPI_PROTOCOL_TOR },
  { 0x054F56A8, 32, NDPI_PROTOCOL_TOR },
  { 0x056476A6, 32, NDPI_PROTOCOL_TOR },
  { 0x056565E9, 32, NDPI_PROTOCOL_TOR },
  { 0x05656652, 32, NDPI_PROTOCOL_TOR },
  { 0x05656746, 32, NDPI_PROTOCOL_TOR },
  { 0x0567688C, 32, NDPI_PROTOCOL_TOR },
  { 0x0567E82F, 32, NDPI_PROTOCOL_TOR },
  { 0x05685A1D, 32, NDPI_PROTOCOL_TOR },
  { 0x05686A26, 32, NDPI_PROTOCOL_TOR },
  { 0x0581F54D, 32, NDPI_PROTOCOL_TOR },
  { 0x0581FAAD, 32, NDPI_PROTOCOL_TOR },
  { 0x058706AC, 32, NDPI_PROTOCOL_TOR },
  { 0x05873DD1, 32, NDPI_PROTOCOL_TOR },
  { 0x05873DDA, 32, NDPI_PROTOCOL_TOR },
  { 0x05875517, 32, NDPI_PROTOCOL_TOR },
  { 0x05878F54, 32, NDPI_PROTOCOL_TOR },
  { 0x0587917D, 32, NDPI_PROTOCOL_TOR },
  { 0x058794AB, 32, NDPI_PROTOCOL_TOR },
  { 0x058798B2, 32, NDPI_PROTOCOL_TOR },
  { 0x058798D0, 32, NDPI_PROTOCOL_TOR },
  { 0x05879ACF, 32, NDPI_PROTOCOL_TOR },
  { 0x05879B79, 32, NDPI_PROTOCOL_TOR },
  { 0x05879E65, 32, NDPI_PROTOCOL_TOR },
  { 0x05879F04, 32, NDPI_PROTOCOL_TOR },
  { 0x05879F6E, 32, NDPI_PROTOCOL_TOR },
  { 0x05879FCF, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A046, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A21C, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A2D9, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A393, 32, NDPI_PROTOCOL_TOR },
  { 0x0587A5E1, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B1B7, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B209, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B5D5, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B818, 32, NDPI_PROTOCOL_TOR },
  { 0x0587B991, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BA49, 32, NDPI_PROTOCOL_TOR },
  { 0x0587BA9D, 32, NDPI_PROTOCOL_TOR },
  { 0x058B66B7, 32, NDPI_PROTOCOL_TOR },
  { 0x0591316A, 32, NDPI_PROTOCOL_TOR },
  { 0x05922138, 32, NDPI_PROTOCOL_TOR },
  { 0x05930EA4, 32, NDPI_PROTOCOL_TOR },
  { 0x0593158F, 32, NDPI_PROTOCOL_TOR },
  { 0x05937036, 32, NDPI_PROTOCOL_TOR },
  { 0x0595FA35, 32, NDPI_PROTOCOL_TOR },
  { 0x0595FAA4, 32, NDPI_PROTOCOL_TOR },
  { 0x0595FE6D, 32, NDPI_PROTOCOL_TOR },
  { 0x0595FE72, 32, NDPI_PROTOCOL_TOR },
  { 0x0596CC95, 32, NDPI_PROTOCOL_TOR },
  { 0x0596D5F4, 32, NDPI_PROTOCOL_TOR },
  { 0x0596DE9A, 32, NDPI_PROTOCOL_TOR },
  { 0x0596EF88, 32, NDPI_PROTOCOL_TOR },
  { 0x05A4F0C9, 32, NDPI_PROTOCOL_TOR },
  { 0x05A6DDC2, 32, NDPI_PROTOCOL_TOR },
  { 0x05A72D58, 32, NDPI_PROTOCOL_TOR },
  { 0x05A76C53, 32, NDPI_PROTOCOL_TOR },
  { 0x05A79195, 32, NDPI_PROTOCOL_TOR },
  { 0x05AC8CC1, 32, NDPI_PROTOCOL_TOR },
  { 0x05AF714C, 32, NDPI_PROTOCOL_TOR },
  { 0x05AFC17A, 32, NDPI_PROTOCOL_TOR },
  { 0x05AFC245, 32, NDPI_PROTOCOL_TOR },
  { 0x05B256DC, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD82BB, 32, NDPI_PROTOCOL_TOR },
  { 0x05BD8738, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4007B, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40181, 32, NDPI_PROTOCOL_TOR },
  { 0x05C404D0, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40A96, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40BD0, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40C4F, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40C9C, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40C9F, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40D1A, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40E33, 32, NDPI_PROTOCOL_TOR },
  { 0x05C40EEA, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41405, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41455, 32, NDPI_PROTOCOL_TOR },
  { 0x05C41AC6, 32, NDPI_PROTOCOL_TOR },
  { 0x05C44134, 32, NDPI_PROTOCOL_TOR },
  { 0x05C441E9, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4426D, 32, NDPI_PROTOCOL_TOR },
  { 0x05C469E5, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4C4A8, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4E3A1, 32, NDPI_PROTOCOL_TOR },
  { 0x05C4E51D, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78181, 32, NDPI_PROTOCOL_TOR },
  { 0x05C782BC, 32, NDPI_PROTOCOL_TOR },
  { 0x05C785C1, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78E5D, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78E7C, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EC3, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EE6, 32, NDPI_PROTOCOL_TOR },
  { 0x05C78EEC, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7A208, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7A51B, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7A621, 32, NDPI_PROTOCOL_TOR },
  { 0x05C7A78A, 32, NDPI_PROTOCOL_TOR },
  { 0x05E4618A, 32, NDPI_PROTOCOL_TOR },
  { 0x05E4CC86, 32, NDPI_PROTOCOL_TOR },
  { 0x05F6674A, 32, NDPI_PROTOCOL_TOR },
  { 0x05F91F00, 32, NDPI_PROTOCOL_TOR },
  { 0x05F99676, 32, NDPI_PROTOCOL_TOR },
  { 0x05FE818A, 32, NDPI_PROTOCOL_TOR },
  { 0x05FF57A9, 32, NDPI_PROTOCOL_TOR },
  { 0x05FF57D5, 32, NDPI_PROTOCOL_TOR },
  { 0x081C576C, 32, NDPI_PROTOCOL_TOR },
  { 0x0C845D90, 32, NDPI_PROTOCOL_TOR },
  { 0x0E20584A, 32, NDPI_PROTOCOL_TOR },
  { 0x0EA2AFC9, 32, NDPI_PROTOCOL_TOR },
  { 0x0EC771B3, 32, NDPI_PROTOCOL_TOR },
  { 0x0ECAE0FB, 32, NDPI_PROTOCOL_TOR },
  { 0x0ECAE0FB, 32, NDPI_PROTOCOL_TOR },
  { 0x0F7EF324, 32, NDPI_PROTOCOL_TOR },
  { 0x12520388, 32, NDPI_PROTOCOL_TOR },
  { 0x125203C4, 32, NDPI_PROTOCOL_TOR },
  { 0x125203CD, 32, NDPI_PROTOCOL_TOR },
  { 0x127D01DE, 32, NDPI_PROTOCOL_TOR },
  { 0x12B5051C, 32, NDPI_PROTOCOL_TOR },
  { 0x12B50525, 32, NDPI_PROTOCOL_TOR },
  { 0x12BB0144, 32, NDPI_PROTOCOL_TOR },
  { 0x12BD4791, 32, NDPI_PROTOCOL_TOR },
  { 0x12E400BC, 32, NDPI_PROTOCOL_TOR },
  { 0x12EE0155, 32, NDPI_PROTOCOL_TOR },
  { 0x12EE0255, 32, NDPI_PROTOCOL_TOR },
  { 0x12EF008C, 32, NDPI_PROTOCOL_TOR },
  { 0x12EF009B, 32, NDPI_PROTOCOL_TOR },
  { 0x12F3001E, 32, NDPI_PROTOCOL_TOR },
  { 0x17159AC2, 32, NDPI_PROTOCOL_TOR },
  { 0x17162143, 32, NDPI_PROTOCOL_TOR },
  { 0x17198709, 32, NDPI_PROTOCOL_TOR },
  { 0x1750E204, 32, NDPI_PROTOCOL_TOR },
  { 0x1758E805, 32, NDPI_PROTOCOL_TOR },
  { 0x175B15E5, 32, NDPI_PROTOCOL_TOR },
  { 0x175B420B, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1308, 32, NDPI_PROTOCOL_TOR },
  { 0x175C144D, 32, NDPI_PROTOCOL_TOR },
  { 0x175C154A, 32, NDPI_PROTOCOL_TOR },
  { 0x175C1A72, 32, NDPI_PROTOCOL_TOR },
  { 0x175CDC55, 32, NDPI_PROTOCOL_TOR },
  { 0x175E1BE3, 32, NDPI_PROTOCOL_TOR },
  { 0x175E2B4C, 32, NDPI_PROTOCOL_TOR },
  { 0x175E3FA2, 32, NDPI_PROTOCOL_TOR },
  { 0x175E6595, 32, NDPI_PROTOCOL_TOR },
  { 0x175ED723, 32, NDPI_PROTOCOL_TOR },
  { 0x175F092F, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2687, 32, NDPI_PROTOCOL_TOR },
  { 0x175F26A0, 32, NDPI_PROTOCOL_TOR },
  { 0x175F27A1, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B1D, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B49, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B4B, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B4C, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B4D, 32, NDPI_PROTOCOL_TOR },
  { 0x175F2B52, 32, NDPI_PROTOCOL_TOR },
  { 0x175F6E41, 32, NDPI_PROTOCOL_TOR },
  { 0x175F6F50, 32, NDPI_PROTOCOL_TOR },
  { 0x175F70C0, 32, NDPI_PROTOCOL_TOR },
  { 0x1763514C, 32, NDPI_PROTOCOL_TOR },
  { 0x1766A02E, 32, NDPI_PROTOCOL_TOR },
  { 0x177A8D00, 32, NDPI_PROTOCOL_TOR },
  { 0x17E283AF, 32, NDPI_PROTOCOL_TOR },
  { 0x17E28484, 32, NDPI_PROTOCOL_TOR },
  { 0x17E94164, 32, NDPI_PROTOCOL_TOR },
  { 0x17E96B78, 32, NDPI_PROTOCOL_TOR },
  { 0x17EE11E5, 32, NDPI_PROTOCOL_TOR },
  { 0x17EEE636, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF045E, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF0590, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF0A90, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1378, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1378, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1399, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1B1C, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1D41, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1D41, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF1DE2, 32, NDPI_PROTOCOL_TOR },
  { 0x17EF7165, 32, NDPI_PROTOCOL_TOR },
  { 0x17FA079F, 32, NDPI_PROTOCOL_TOR },
  { 0x17FC36AA, 32, NDPI_PROTOCOL_TOR },
  { 0x17FE8026, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA584, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA5FA, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA6DE, 32, NDPI_PROTOCOL_TOR },
  { 0x17FEA7E7, 32, NDPI_PROTOCOL_TOR },
  { 0x17FFC32F, 32, NDPI_PROTOCOL_TOR },
  { 0x17FFCC6C, 32, NDPI_PROTOCOL_TOR },
  { 0x17FFF26D, 32, NDPI_PROTOCOL_TOR },
  { 0x18015D49, 32, NDPI_PROTOCOL_TOR },
  { 0x18041FF9, 32, NDPI_PROTOCOL_TOR },
  { 0x18048A52, 32, NDPI_PROTOCOL_TOR },
  { 0x18084CAE, 32, NDPI_PROTOCOL_TOR },
  { 0x180AEB3E, 32, NDPI_PROTOCOL_TOR },
  { 0x180CFAC8, 32, NDPI_PROTOCOL_TOR },
  { 0x180D9384, 32, NDPI_PROTOCOL_TOR },
  { 0x1810444C, 32, NDPI_PROTOCOL_TOR },
  { 0x1811131D, 32, NDPI_PROTOCOL_TOR },
  { 0x18140EAF, 32, NDPI_PROTOCOL_TOR },
  { 0x18153FC2, 32, NDPI_PROTOCOL_TOR },
  { 0x18157F86, 32, NDPI_PROTOCOL_TOR },
  { 0x18158EEB, 32, NDPI_PROTOCOL_TOR },
  { 0x1815BE96, 32, NDPI_PROTOCOL_TOR },
  { 0x1815EACE, 32, NDPI_PROTOCOL_TOR },
  { 0x18166B48, 32, NDPI_PROTOCOL_TOR },
  { 0x1816B6B0, 32, NDPI_PROTOCOL_TOR },
  { 0x18228E2D, 32, NDPI_PROTOCOL_TOR },
  { 0x1833357C, 32, NDPI_PROTOCOL_TOR },
  { 0x1834CE43, 32, NDPI_PROTOCOL_TOR },
  { 0x1834DF47, 32, NDPI_PROTOCOL_TOR },
  { 0x1834F2AC, 32, NDPI_PROTOCOL_TOR },
  { 0x183E84AB, 32, NDPI_PROTOCOL_TOR },
  { 0x183ECD0A, 32, NDPI_PROTOCOL_TOR },
  { 0x18405FB8, 32, NDPI_PROTOCOL_TOR },
  { 0x18446509, 32, NDPI_PROTOCOL_TOR },
  { 0x185AC5F6, 32, NDPI_PROTOCOL_TOR },
  { 0x18601285, 32, NDPI_PROTOCOL_TOR },
  { 0x186339F8, 32, NDPI_PROTOCOL_TOR },
  { 0x1868D868, 32, NDPI_PROTOCOL_TOR },
  { 0x186BDA67, 32, NDPI_PROTOCOL_TOR },
  { 0x187950A5, 32, NDPI_PROTOCOL_TOR },
  { 0x1880EB2A, 32, NDPI_PROTOCOL_TOR },
  { 0x18815804, 32, NDPI_PROTOCOL_TOR },
  { 0x188628E9, 32, NDPI_PROTOCOL_TOR },
  { 0x1886424B, 32, NDPI_PROTOCOL_TOR },
  { 0x1886A34A, 32, NDPI_PROTOCOL_TOR },
  { 0x1887456F, 32, NDPI_PROTOCOL_TOR },
  { 0x188CE8A3, 32, NDPI_PROTOCOL_TOR },
  { 0x18943BB9, 32, NDPI_PROTOCOL_TOR },
  { 0x18973BA8, 32, NDPI_PROTOCOL_TOR },
  { 0x189C1043, 32, NDPI_PROTOCOL_TOR },
  { 0x18A0A2C8, 32, NDPI_PROTOCOL_TOR },
  { 0x18A2F56C, 32, NDPI_PROTOCOL_TOR },
  { 0x18A57BA7, 32, NDPI_PROTOCOL_TOR },
  { 0x18A6420B, 32, NDPI_PROTOCOL_TOR },
  { 0x18AA2AAE, 32, NDPI_PROTOCOL_TOR },
  { 0x18B5AF66, 32, NDPI_PROTOCOL_TOR },
  { 0x18B93E50, 32, NDPI_PROTOCOL_TOR },
  { 0x18BB1408, 32, NDPI_PROTOCOL_TOR },
  { 0x18BE411A, 32, NDPI_PROTOCOL_TOR },
  { 0x18C05C02, 32, NDPI_PROTOCOL_TOR },
  { 0x18C1E947, 32, NDPI_PROTOCOL_TOR },
  { 0x18C4398A, 32, NDPI_PROTOCOL_TOR },
  { 0x18CB1026, 32, NDPI_PROTOCOL_TOR },
  { 0x18CBAD0C, 32, NDPI_PROTOCOL_TOR },
  { 0x18D48CD3, 32, NDPI_PROTOCOL_TOR },
  { 0x18D67228, 32, NDPI_PROTOCOL_TOR },
  { 0x18D921A8, 32, NDPI_PROTOCOL_TOR },
  { 0x18DCAE5D, 32, NDPI_PROTOCOL_TOR },
  { 0x18E94A6F, 32, NDPI_PROTOCOL_TOR },
  { 0x18EFCCC4, 32, NDPI_PROTOCOL_TOR },
  { 0x18FBC42B, 32, NDPI_PROTOCOL_TOR },
  { 0x18FC70B1, 32, NDPI_PROTOCOL_TOR },
  { 0x1B6D75D6, 32, NDPI_PROTOCOL_TOR },
  { 0x1B78549C, 32, NDPI_PROTOCOL_TOR },
  { 0x1B7C7C7A, 32, NDPI_PROTOCOL_TOR },
  { 0x1F036525, 32, NDPI_PROTOCOL_TOR },
  { 0x1F07B826, 32, NDPI_PROTOCOL_TOR },
  { 0x1F07B84C, 32, NDPI_PROTOCOL_TOR },
  { 0x1F07BADF, 32, NDPI_PROTOCOL_TOR },
  { 0x1F088004, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0A4D53, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0B41C6, 32, NDPI_PROTOCOL_TOR },
  { 0x1F0BF184, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1018A6, 32, NDPI_PROTOCOL_TOR },
  { 0x1F10AE02, 32, NDPI_PROTOCOL_TOR },
  { 0x1F11CDA0, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1269A3, 32, NDPI_PROTOCOL_TOR },
  { 0x1F12A967, 32, NDPI_PROTOCOL_TOR },
  { 0x1F12B428, 32, NDPI_PROTOCOL_TOR },
  { 0x1F12FBBE, 32, NDPI_PROTOCOL_TOR },
  { 0x1F13D492, 32, NDPI_PROTOCOL_TOR },
  { 0x1F17E469, 32, NDPI_PROTOCOL_TOR },
  { 0x1F180C17, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1979DC, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1E2413, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1E2E44, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4A40, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4A71, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4B54, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4BB5, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4CA9, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4DDE, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4E31, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4E8D, 32, NDPI_PROTOCOL_TOR },
  { 0x1F1F4F98, 32, NDPI_PROTOCOL_TOR },
  { 0x1F205448, 32, NDPI_PROTOCOL_TOR },
  { 0x1F21B915, 32, NDPI_PROTOCOL_TOR },
  { 0x1F22B6B1, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2AA922, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2CE29C, 32, NDPI_PROTOCOL_TOR },
  { 0x1F2D7B2D, 32, NDPI_PROTOCOL_TOR },
  { 0x1F30B0E8, 32, NDPI_PROTOCOL_TOR },
  { 0x1F326CF7, 32, NDPI_PROTOCOL_TOR },
  { 0x1F338AC8, 32, NDPI_PROTOCOL_TOR },
  { 0x1F81A64E, 32, NDPI_PROTOCOL_TOR },
  { 0x1F86556D, 32, NDPI_PROTOCOL_TOR },
  { 0x1FAC1FCF, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB29AE6, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB8C367, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB8C370, 32, NDPI_PROTOCOL_TOR },
  { 0x1FB91BCB, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC06934, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC06C42, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC0E4B9, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC18B0E, 32, NDPI_PROTOCOL_TOR },
  { 0x1FC9B5F1, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCC966A, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCC968A, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCC9866, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCF8399, 32, NDPI_PROTOCOL_TOR },
  { 0x1FCFF1A8, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD2636A, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD263D2, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD2694A, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD269BA, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD26E3A, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD26E82, 32, NDPI_PROTOCOL_TOR },
  { 0x1FD27FBA, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0580, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0586, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC0599, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC05C8, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC073F, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC078F, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC07C9, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC2AC2, 32, NDPI_PROTOCOL_TOR },
  { 0x1FDC326D, 32, NDPI_PROTOCOL_TOR },
  { 0x20D7A24A, 32, NDPI_PROTOCOL_TOR },
  { 0x23007F34, 32, NDPI_PROTOCOL_TOR },
  { 0x23007F34, 32, NDPI_PROTOCOL_TOR },
  { 0x2437F025, 32, NDPI_PROTOCOL_TOR },
  { 0x2450B024, 32, NDPI_PROTOCOL_TOR },
  { 0x25007B98, 32, NDPI_PROTOCOL_TOR },
  { 0x25007BCF, 32, NDPI_PROTOCOL_TOR },
  { 0x2501C2B6, 32, NDPI_PROTOCOL_TOR },
  { 0x2501D288, 32, NDPI_PROTOCOL_TOR },
  { 0x2501D569, 32, NDPI_PROTOCOL_TOR },
  { 0x2501D799, 32, NDPI_PROTOCOL_TOR },
  { 0x25041A62, 32, NDPI_PROTOCOL_TOR },
  { 0x25041BED, 32, NDPI_PROTOCOL_TOR },
  { 0x2505A41C, 32, NDPI_PROTOCOL_TOR },
  { 0x250B231C, 32, NDPI_PROTOCOL_TOR },
  { 0x250B231C, 32, NDPI_PROTOCOL_TOR },
  { 0x250B480D, 32, NDPI_PROTOCOL_TOR },
  { 0x2511AD98, 32, NDPI_PROTOCOL_TOR },
  { 0x251816D1, 32, NDPI_PROTOCOL_TOR },
  { 0x2518F260, 32, NDPI_PROTOCOL_TOR },
  { 0x25223476, 32, NDPI_PROTOCOL_TOR },
  { 0x25223A38, 32, NDPI_PROTOCOL_TOR },
  { 0x252C2C0B, 32, NDPI_PROTOCOL_TOR },
  { 0x252EB809, 32, NDPI_PROTOCOL_TOR },
  { 0x25304046, 32, NDPI_PROTOCOL_TOR },
  { 0x2530417A, 32, NDPI_PROTOCOL_TOR },
  { 0x2530417A, 32, NDPI_PROTOCOL_TOR },
  { 0x253043AA, 32, NDPI_PROTOCOL_TOR },
  { 0x25304A4B, 32, NDPI_PROTOCOL_TOR },
  { 0x25304E9F, 32, NDPI_PROTOCOL_TOR },
  { 0x25305130, 32, NDPI_PROTOCOL_TOR },
  { 0x253056A0, 32, NDPI_PROTOCOL_TOR },
  { 0x25305A99, 32, NDPI_PROTOCOL_TOR },
  { 0x2530782F, 32, NDPI_PROTOCOL_TOR },
  { 0x253078C4, 32, NDPI_PROTOCOL_TOR },
  { 0x253110CB, 32, NDPI_PROTOCOL_TOR },
  { 0x253A70B2, 32, NDPI_PROTOCOL_TOR },
  { 0x253B0227, 32, NDPI_PROTOCOL_TOR },
  { 0x253B02BC, 32, NDPI_PROTOCOL_TOR },
  { 0x253B0EC9, 32, NDPI_PROTOCOL_TOR },
  { 0x253B1D49, 32, NDPI_PROTOCOL_TOR },
  { 0x253B24C6, 32, NDPI_PROTOCOL_TOR },
  { 0x253B2675, 32, NDPI_PROTOCOL_TOR },
  { 0x253B2E9F, 32, NDPI_PROTOCOL_TOR },
  { 0x253B2F1B, 32, NDPI_PROTOCOL_TOR },
  { 0x253B2F1B, 32, NDPI_PROTOCOL_TOR },
  { 0x253B4365, 32, NDPI_PROTOCOL_TOR },
  { 0x253B6052, 32, NDPI_PROTOCOL_TOR },
  { 0x253B60BF, 32, NDPI_PROTOCOL_TOR },
  { 0x253B63BF, 32, NDPI_PROTOCOL_TOR },
  { 0x253B640B, 32, NDPI_PROTOCOL_TOR },
  { 0x253B69D6, 32, NDPI_PROTOCOL_TOR },
  { 0x253B69E8, 32, NDPI_PROTOCOL_TOR },
  { 0x253B6FC0, 32, NDPI_PROTOCOL_TOR },
  { 0x253B704A, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7493, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7614, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7662, 32, NDPI_PROTOCOL_TOR },
  { 0x253B76F6, 32, NDPI_PROTOCOL_TOR },
  { 0x253B794E, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7B8E, 32, NDPI_PROTOCOL_TOR },
  { 0x253B7D1D, 32, NDPI_PROTOCOL_TOR },
  { 0x253B85D0, 32, NDPI_PROTOCOL_TOR },
  { 0x253B9010, 32, NDPI_PROTOCOL_TOR },
  { 0x253BA2DA, 32, NDPI_PROTOCOL_TOR },
  { 0x254BA34C, 32, NDPI_PROTOCOL_TOR },
  { 0x254CCFC4, 32, NDPI_PROTOCOL_TOR },
  { 0x256E0D88, 32, NDPI_PROTOCOL_TOR },
  { 0x256E3C0F, 32, NDPI_PROTOCOL_TOR },
  { 0x256EF1F9, 32, NDPI_PROTOCOL_TOR },
  { 0x25718DEE, 32, NDPI_PROTOCOL_TOR },
  { 0x2571B30C, 32, NDPI_PROTOCOL_TOR },
  { 0x25723407, 32, NDPI_PROTOCOL_TOR },
  { 0x25780229, 32, NDPI_PROTOCOL_TOR },
  { 0x25784275, 32, NDPI_PROTOCOL_TOR },
  { 0x2578A080, 32, NDPI_PROTOCOL_TOR },
  { 0x2578AC86, 32, NDPI_PROTOCOL_TOR },
  { 0x2578AC88, 32, NDPI_PROTOCOL_TOR },
  { 0x2578ACF2, 32, NDPI_PROTOCOL_TOR },
  { 0x257B700E, 32, NDPI_PROTOCOL_TOR },
  { 0x257B70FD, 32, NDPI_PROTOCOL_TOR },
  { 0x257B756F, 32, NDPI_PROTOCOL_TOR },
  { 0x257B924B, 32, NDPI_PROTOCOL_TOR },
  { 0x2582E385, 32, NDPI_PROTOCOL_TOR },
  { 0x2582E386, 32, NDPI_PROTOCOL_TOR },
  { 0x2585814C, 32, NDPI_PROTOCOL_TOR },
  { 0x25869E3E, 32, NDPI_PROTOCOL_TOR },
  { 0x258B03AB, 32, NDPI_PROTOCOL_TOR },
  { 0x258B03E7, 32, NDPI_PROTOCOL_TOR },
  { 0x258B0C33, 32, NDPI_PROTOCOL_TOR },
  { 0x258B0D4E, 32, NDPI_PROTOCOL_TOR },
  { 0x258B166E, 32, NDPI_PROTOCOL_TOR },
  { 0x258F094A, 32, NDPI_PROTOCOL_TOR },
  { 0x25904351, 32, NDPI_PROTOCOL_TOR },
  { 0x2591FF60, 32, NDPI_PROTOCOL_TOR },
  { 0x259267E1, 32, NDPI_PROTOCOL_TOR },
  { 0x25928712, 32, NDPI_PROTOCOL_TOR },
  { 0x25929590, 32, NDPI_PROTOCOL_TOR },
  { 0x25939A1B, 32, NDPI_PROTOCOL_TOR },
  { 0x2599010A, 32, NDPI_PROTOCOL_TOR },
  { 0x25993585, 32, NDPI_PROTOCOL_TOR },
  { 0x259DA955, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC059, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC2D2, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC30D, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC353, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC38F, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC3B2, 32, NDPI_PROTOCOL_TOR },
  { 0x259DC4DB, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0012, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB007E, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0255, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB02E5, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB02E6, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0303, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB0408, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB04DB, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB052C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB056D, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB074A, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB094F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB115F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB122B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB122B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB126D, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB12B4, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB143B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB144F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB151C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB159D, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB15B4, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1657, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1683, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB17E8, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB17E8, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1E4E, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB1F27, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB2693, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB27D2, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB33D2, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB3F72, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB4275, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB604E, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB611F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB615F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB62B9, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB638F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB63C1, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB666C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB66BA, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB675B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB679C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB692B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6941, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6944, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6B5B, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6BD2, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6BD2, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6C50, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6D13, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6D3A, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6D45, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6E3F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB6ED8, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7224, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB728C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB732F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7487, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB76EC, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7C84, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7CC6, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7DCF, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7DCF, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7DE4, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB7E15, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB8244, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB82E2, 32, NDPI_PROTOCOL_TOR },
  { 0x25BB89E1, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB023, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB040, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB404, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB41C, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBB441, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBC635, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBC69F, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBEFBF, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBF36D, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBF428, 32, NDPI_PROTOCOL_TOR },
  { 0x25BBF6DD, 32, NDPI_PROTOCOL_TOR },
  { 0x25BC44E4, 32, NDPI_PROTOCOL_TOR },
  { 0x25BED50A, 32, NDPI_PROTOCOL_TOR },
  { 0x25BF8A2B, 32, NDPI_PROTOCOL_TOR },
  { 0x25C08768, 32, NDPI_PROTOCOL_TOR },
  { 0x25C2350B, 32, NDPI_PROTOCOL_TOR },
  { 0x25C3C530, 32, NDPI_PROTOCOL_TOR },
  { 0x25C86205, 32, NDPI_PROTOCOL_TOR },
  { 0x25C863FB, 32, NDPI_PROTOCOL_TOR },
  { 0x25C939D9, 32, NDPI_PROTOCOL_TOR },
  { 0x25C98337, 32, NDPI_PROTOCOL_TOR },
  { 0x25C9DF9D, 32, NDPI_PROTOCOL_TOR },
  { 0x25CCA01C, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0983, 32, NDPI_PROTOCOL_TOR },
  { 0x25CD0B95, 32, NDPI_PROTOCOL_TOR },
  { 0x25D13BC6, 32, NDPI_PROTOCOL_TOR },
  { 0x25D14A11, 32, NDPI_PROTOCOL_TOR },
  { 0x25D16FE5, 32, NDPI_PROTOCOL_TOR },
  { 0x25D3561F, 32, NDPI_PROTOCOL_TOR },
  { 0x25DC233D, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA125, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA137, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA2E2, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA2E2, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA5E5, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDA5F6, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC114, 32, NDPI_PROTOCOL_TOR },
  { 0x25DDC5B7, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48203, 32, NDPI_PROTOCOL_TOR },
  { 0x25E48424, 32, NDPI_PROTOCOL_TOR },
  { 0x25E60143, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB30F7, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB312E, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB317C, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3443, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3753, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3C39, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3C3C, 32, NDPI_PROTOCOL_TOR },
  { 0x25EB3E07, 32, NDPI_PROTOCOL_TOR },
  { 0x25F71635, 32, NDPI_PROTOCOL_TOR },
  { 0x25F732A7, 32, NDPI_PROTOCOL_TOR },
  { 0x25F7348C, 32, NDPI_PROTOCOL_TOR },
  { 0x25F735A2, 32, NDPI_PROTOCOL_TOR },
  { 0x25FC0CBA, 32, NDPI_PROTOCOL_TOR },
  { 0x25FCBE85, 32, NDPI_PROTOCOL_TOR },
  { 0x264D16FB, 32, NDPI_PROTOCOL_TOR },
  { 0x266C0A8C, 32, NDPI_PROTOCOL_TOR },
  { 0x26825026, 32, NDPI_PROTOCOL_TOR },
  { 0x26825039, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5001C, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5001D, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54621, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54622, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5462A, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5462A, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54633, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54634, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54635, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54636, 32, NDPI_PROTOCOL_TOR },
  { 0x26E5463D, 32, NDPI_PROTOCOL_TOR },
  { 0x26E54F02, 32, NDPI_PROTOCOL_TOR },
  { 0x27775DC9, 32, NDPI_PROTOCOL_TOR },
  { 0x294885AE, 32, NDPI_PROTOCOL_TOR },
  { 0x294D88FA, 32, NDPI_PROTOCOL_TOR },
  { 0x2985828E, 32, NDPI_PROTOCOL_TOR },
  { 0x29B619B5, 32, NDPI_PROTOCOL_TOR },
  { 0x29D4257A, 32, NDPI_PROTOCOL_TOR },
  { 0x29D7F1EA, 32, NDPI_PROTOCOL_TOR },
  { 0x29DF358D, 32, NDPI_PROTOCOL_TOR },
  { 0x29F201F2, 32, NDPI_PROTOCOL_TOR },
  { 0x2A02EFEA, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7010C4, 32, NDPI_PROTOCOL_TOR },
  { 0x2A701341, 32, NDPI_PROTOCOL_TOR },
  { 0x2A7013C9, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFA082A, 32, NDPI_PROTOCOL_TOR },
  { 0x2BFA0842, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04009C, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0418A8, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0419D6, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0422F2, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0427EB, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0437B1, 32, NDPI_PROTOCOL_TOR },
  { 0x2E043C6A, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0457AC, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046723, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046A12, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046ACF, 32, NDPI_PROTOCOL_TOR },
  { 0x2E046F7C, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0474B0, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047AA2, 32, NDPI_PROTOCOL_TOR },
  { 0x2E047AAD, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04AE34, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04B777, 32, NDPI_PROTOCOL_TOR },
  { 0x2E04FDC2, 32, NDPI_PROTOCOL_TOR },
  { 0x2E051DC4, 32, NDPI_PROTOCOL_TOR },
  { 0x2E051E05, 32, NDPI_PROTOCOL_TOR },
  { 0x2E055F13, 32, NDPI_PROTOCOL_TOR },
  { 0x2E059971, 32, NDPI_PROTOCOL_TOR },
  { 0x2E09C314, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0ACDFC, 32, NDPI_PROTOCOL_TOR },
  { 0x2E0EF5CE, 32, NDPI_PROTOCOL_TOR },
  { 0x2E10EA83, 32, NDPI_PROTOCOL_TOR },
  { 0x2E113FD6, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138E1D, 32, NDPI_PROTOCOL_TOR },
  { 0x2E138E7E, 32, NDPI_PROTOCOL_TOR },
  { 0x2E14F675, 32, NDPI_PROTOCOL_TOR },
  { 0x2E167BDE, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1746C3, 32, NDPI_PROTOCOL_TOR },
  { 0x2E17551F, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C449E, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C4581, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6E81, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1C6EF4, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCAD6, 32, NDPI_PROTOCOL_TOR },
  { 0x2E1CCF78, 32, NDPI_PROTOCOL_TOR },
  { 0x2E20E8EE, 32, NDPI_PROTOCOL_TOR },
  { 0x2E20EABD, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2423D5, 32, NDPI_PROTOCOL_TOR },
  { 0x2E24251B, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2425B7, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2425D6, 32, NDPI_PROTOCOL_TOR },
  { 0x2E24271A, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2639C4, 32, NDPI_PROTOCOL_TOR },
  { 0x2E263E1E, 32, NDPI_PROTOCOL_TOR },
  { 0x2E263F07, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26E9F2, 32, NDPI_PROTOCOL_TOR },
  { 0x2E26FA27, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2779BC, 32, NDPI_PROTOCOL_TOR },
  { 0x2E298244, 32, NDPI_PROTOCOL_TOR },
  { 0x2E298454, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2B325C, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2D0F7B, 32, NDPI_PROTOCOL_TOR },
  { 0x2E2F133A, 32, NDPI_PROTOCOL_TOR },
  { 0x2E37146D, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B27B9, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B3A75, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B8EEC, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B9439, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3B9998, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3BB9D7, 32, NDPI_PROTOCOL_TOR },
  { 0x2E3BF04E, 32, NDPI_PROTOCOL_TOR },
  { 0x2E48594D, 32, NDPI_PROTOCOL_TOR },
  { 0x2E49F960, 32, NDPI_PROTOCOL_TOR },
  { 0x2E691148, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6960BE, 32, NDPI_PROTOCOL_TOR },
  { 0x2E69AC56, 32, NDPI_PROTOCOL_TOR },
  { 0x2E69E8BC, 32, NDPI_PROTOCOL_TOR },
  { 0x2E6C27DB, 32, NDPI_PROTOCOL_TOR },
  { 0x2E76110C, 32, NDPI_PROTOCOL_TOR },
  { 0x2E762709, 32, NDPI_PROTOCOL_TOR },
  { 0x2E76A38F, 32, NDPI_PROTOCOL_TOR },
  { 0x2E76E5C9, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7E47AA, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7FC664, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7FCB2F, 32, NDPI_PROTOCOL_TOR },
  { 0x2E7FD0F8, 32, NDPI_PROTOCOL_TOR },
  { 0x2E800457, 32, NDPI_PROTOCOL_TOR },
  { 0x2E802D63, 32, NDPI_PROTOCOL_TOR },
  { 0x2E802D76, 32, NDPI_PROTOCOL_TOR },
  { 0x2E80D52B, 32, NDPI_PROTOCOL_TOR },
  { 0x2E81138F, 32, NDPI_PROTOCOL_TOR },
  { 0x2E8115E6, 32, NDPI_PROTOCOL_TOR },
  { 0x2E817C16, 32, NDPI_PROTOCOL_TOR },
  { 0x2E84BCDD, 32, NDPI_PROTOCOL_TOR },
  { 0x2E92E027, 32, NDPI_PROTOCOL_TOR },
  { 0x2E95120A, 32, NDPI_PROTOCOL_TOR },
  { 0x2E97D0D5, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA25245, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA26191, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA340CA, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA341A0, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA3449C, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA34C20, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA34CFA, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA3DB56, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5C560, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DDA6, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DDA6, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DFD6, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DFD9, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5DFE3, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F08F, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F2A6, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5F9E4, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA5FAEB, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA6A127, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F533, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F545, 32, NDPI_PROTOCOL_TOR },
  { 0x2EA7F5AC, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB5EEA4, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61224, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6126F, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB612F5, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61303, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB61563, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB66ABE, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6845A, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB6D01C, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7D9F4, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DA8D, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DBC4, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB7DC84, 32, NDPI_PROTOCOL_TOR },
  { 0x2EB9E185, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBB039C, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC0425, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC0A17, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC2510, 32, NDPI_PROTOCOL_TOR },
  { 0x2EBC2AB0, 32, NDPI_PROTOCOL_TOR },
  { 0x2EC29854, 32, NDPI_PROTOCOL_TOR },
  { 0x2ED80D2F, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF485B, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF4FDF, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDF8DA7, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDFCD19, 32, NDPI_PROTOCOL_TOR },
  { 0x2EDFF71E, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE26D30, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE26EB9, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE360DA, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE4045B, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE4C713, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE5EEAC, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE90046, 32, NDPI_PROTOCOL_TOR },
  { 0x2EE9EDBB, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEBE346, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEC95E0, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF62AC, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF6472, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF6B4A, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF6CC2, 32, NDPI_PROTOCOL_TOR },
  { 0x2EEF75B4, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF2623D, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF48AFB, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF5C841, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF61484, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF6220C, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF623E5, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF62E1B, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF659A9, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF66CAE, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF66FCF, 32, NDPI_PROTOCOL_TOR },
  { 0x2EF9258F, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC1838, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC18F6, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC19F9, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC1A02, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFC98C0, 32, NDPI_PROTOCOL_TOR },
  { 0x2EFE4BA8, 32, NDPI_PROTOCOL_TOR },
  { 0x2F376EBC, 32, NDPI_PROTOCOL_TOR },
  { 0x31CD342B, 32, NDPI_PROTOCOL_TOR },
  { 0x31D4A626, 32, NDPI_PROTOCOL_TOR },
  { 0x31D4ADDE, 32, NDPI_PROTOCOL_TOR },
  { 0x31D4C271, 32, NDPI_PROTOCOL_TOR },
  { 0x320163E9, 32, NDPI_PROTOCOL_TOR },
  { 0x32070872, 32, NDPI_PROTOCOL_TOR },
  { 0x32073D6A, 32, NDPI_PROTOCOL_TOR },
  { 0x3207A1DA, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03B, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03B, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03C, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03D, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03D, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B03E, 32, NDPI_PROTOCOL_TOR },
  { 0x3207B83A, 32, NDPI_PROTOCOL_TOR },
  { 0x3207C27A, 32, NDPI_PROTOCOL_TOR },
  { 0x3207D2DA, 32, NDPI_PROTOCOL_TOR },
  { 0x3207F36B, 32, NDPI_PROTOCOL_TOR },
  { 0x3207F36B, 32, NDPI_PROTOCOL_TOR },
  { 0x32092FEE, 32, NDPI_PROTOCOL_TOR },
  { 0x321F4CC3, 32, NDPI_PROTOCOL_TOR },
  { 0x321FFF5E, 32, NDPI_PROTOCOL_TOR },
  { 0x322300F4, 32, NDPI_PROTOCOL_TOR },
  { 0x322554A1, 32, NDPI_PROTOCOL_TOR },
  { 0x322B0AF0, 32, NDPI_PROTOCOL_TOR },
  { 0x322B38B6, 32, NDPI_PROTOCOL_TOR },
  { 0x322EF39B, 32, NDPI_PROTOCOL_TOR },
  { 0x32354A02, 32, NDPI_PROTOCOL_TOR },
  { 0x32355AFB, 32, NDPI_PROTOCOL_TOR },
  { 0x323995CC, 32, NDPI_PROTOCOL_TOR },
  { 0x3245A0C6, 32, NDPI_PROTOCOL_TOR },
  { 0x3248C4CE, 32, NDPI_PROTOCOL_TOR },
  { 0x324C9FDA, 32, NDPI_PROTOCOL_TOR },
  { 0x324EC501, 32, NDPI_PROTOCOL_TOR },
  { 0x324F2036, 32, NDPI_PROTOCOL_TOR },
  { 0x32511947, 32, NDPI_PROTOCOL_TOR },
  { 0x32532059, 32, NDPI_PROTOCOL_TOR },
  { 0x32582849, 32, NDPI_PROTOCOL_TOR },
  { 0x3258C0F5, 32, NDPI_PROTOCOL_TOR },
  { 0x325A0246, 32, NDPI_PROTOCOL_TOR },
  { 0x325DF89A, 32, NDPI_PROTOCOL_TOR },
  { 0x325DF9E4, 32, NDPI_PROTOCOL_TOR },
  { 0x326F05DE, 32, NDPI_PROTOCOL_TOR },
  { 0x326FC86F, 32, NDPI_PROTOCOL_TOR },
  { 0x32710FAD, 32, NDPI_PROTOCOL_TOR },
  { 0x327375B9, 32, NDPI_PROTOCOL_TOR },
  { 0x32737A44, 32, NDPI_PROTOCOL_TOR },
  { 0x3273E93E, 32, NDPI_PROTOCOL_TOR },
  { 0x32740095, 32, NDPI_PROTOCOL_TOR },
  { 0x327403DF, 32, NDPI_PROTOCOL_TOR },
  { 0x3274048D, 32, NDPI_PROTOCOL_TOR },
  { 0x32740599, 32, NDPI_PROTOCOL_TOR },
  { 0x32740AF2, 32, NDPI_PROTOCOL_TOR },
  { 0x327415AC, 32, NDPI_PROTOCOL_TOR },
  { 0x32741D36, 32, NDPI_PROTOCOL_TOR },
  { 0x32741D36, 32, NDPI_PROTOCOL_TOR },
  { 0x327420D9, 32, NDPI_PROTOCOL_TOR },
  { 0x3274222C, 32, NDPI_PROTOCOL_TOR },
  { 0x32742806, 32, NDPI_PROTOCOL_TOR },
  { 0x32742AF5, 32, NDPI_PROTOCOL_TOR },
  { 0x32742E14, 32, NDPI_PROTOCOL_TOR },
  { 0x32742FAB, 32, NDPI_PROTOCOL_TOR },
  { 0x3274312E, 32, NDPI_PROTOCOL_TOR },
  { 0x3274320C, 32, NDPI_PROTOCOL_TOR },
  { 0x3274320C, 32, NDPI_PROTOCOL_TOR },
  { 0x32743687, 32, NDPI_PROTOCOL_TOR },
  { 0x32743830, 32, NDPI_PROTOCOL_TOR },
  { 0x327556D3, 32, NDPI_PROTOCOL_TOR },
  { 0x328293BF, 32, NDPI_PROTOCOL_TOR },
  { 0x328C5DDF, 32, NDPI_PROTOCOL_TOR },
  { 0x328F6411, 32, NDPI_PROTOCOL_TOR },
  { 0x3294BED5, 32, NDPI_PROTOCOL_TOR },
  { 0x3298F1C6, 32, NDPI_PROTOCOL_TOR },
  { 0x32A4685A, 32, NDPI_PROTOCOL_TOR },
  { 0x32A84435, 32, NDPI_PROTOCOL_TOR },
  { 0x32B12972, 32, NDPI_PROTOCOL_TOR },
  { 0x32B1AF1A, 32, NDPI_PROTOCOL_TOR },
  { 0x32B5B129, 32, NDPI_PROTOCOL_TOR },
  { 0x32C18F2A, 32, NDPI_PROTOCOL_TOR },
  { 0x32C701B2, 32, NDPI_PROTOCOL_TOR },
  { 0x32F11E91, 32, NDPI_PROTOCOL_TOR },
  { 0x32F57C83, 32, NDPI_PROTOCOL_TOR },
  { 0x32F74BCD, 32, NDPI_PROTOCOL_TOR },
  { 0x32F7C37C, 32, NDPI_PROTOCOL_TOR },
  { 0x32F90236, 32, NDPI_PROTOCOL_TOR },
  { 0x32FAC9FE, 32, NDPI_PROTOCOL_TOR },
  { 0x32FAD011, 32, NDPI_PROTOCOL_TOR },
  { 0x32FADAA1, 32, NDPI_PROTOCOL_TOR },
  { 0x32FF615D, 32, NDPI_PROTOCOL_TOR },
  { 0x340A7D8C, 32, NDPI_PROTOCOL_TOR },
  { 0x364023F4, 32, NDPI_PROTOCOL_TOR },
  { 0x3640E586, 32, NDPI_PROTOCOL_TOR },
  { 0x3641ACFE, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE17, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE2C, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE34, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE39, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE3C, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE43, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE4A, 32, NDPI_PROTOCOL_TOR },
  { 0x3641CE4F, 32, NDPI_PROTOCOL_TOR },
  { 0x3642A01A, 32, NDPI_PROTOCOL_TOR },
  { 0x3642ED8D, 32, NDPI_PROTOCOL_TOR },
  { 0x36431231, 32, NDPI_PROTOCOL_TOR },
  { 0x36441DAA, 32, NDPI_PROTOCOL_TOR },
  { 0x3645C64F, 32, NDPI_PROTOCOL_TOR },
  { 0x3649DA8A, 32, NDPI_PROTOCOL_TOR },
  { 0x364D068C, 32, NDPI_PROTOCOL_TOR },
  { 0x364D6EBC, 32, NDPI_PROTOCOL_TOR },
  { 0x364D7868, 32, NDPI_PROTOCOL_TOR },
  { 0x364D7DC1, 32, NDPI_PROTOCOL_TOR },
  { 0x364F7EC5, 32, NDPI_PROTOCOL_TOR },
  { 0x3652C35E, 32, NDPI_PROTOCOL_TOR },
  { 0x36542A9B, 32, NDPI_PROTOCOL_TOR },
  { 0x36546A29, 32, NDPI_PROTOCOL_TOR },
  { 0x36568324, 32, NDPI_PROTOCOL_TOR },
  { 0x36571DA1, 32, NDPI_PROTOCOL_TOR },
  { 0x36583B2D, 32, NDPI_PROTOCOL_TOR },
  { 0x36583F17, 32, NDPI_PROTOCOL_TOR },
  { 0x3658A5E5, 32, NDPI_PROTOCOL_TOR },
  { 0x365D2B6D, 32, NDPI_PROTOCOL_TOR },
  { 0x365E89A4, 32, NDPI_PROTOCOL_TOR },
  { 0x365E8BA7, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF005, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF097, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF100, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF1A2, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF1A8, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF1AB, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF1B5, 32, NDPI_PROTOCOL_TOR },
  { 0x365EF1B8, 32, NDPI_PROTOCOL_TOR },
  { 0x3692143E, 32, NDPI_PROTOCOL_TOR },
  { 0x3692CB7D, 32, NDPI_PROTOCOL_TOR },
  { 0x36941FE1, 32, NDPI_PROTOCOL_TOR },
  { 0x36946DAA, 32, NDPI_PROTOCOL_TOR },
  { 0x36949610, 32, NDPI_PROTOCOL_TOR },
  { 0x3695F2AE, 32, NDPI_PROTOCOL_TOR },
  { 0x369A0E1A, 32, NDPI_PROTOCOL_TOR },
  { 0x36A49C46, 32, NDPI_PROTOCOL_TOR },
  { 0x36AB5EF9, 32, NDPI_PROTOCOL_TOR },
  { 0x36AD6890, 32, NDPI_PROTOCOL_TOR },
  { 0x36AF0DB5, 32, NDPI_PROTOCOL_TOR },
  { 0x36AF5145, 32, NDPI_PROTOCOL_TOR },
  { 0x36B9A3E2, 32, NDPI_PROTOCOL_TOR },
  { 0x36BB371D, 32, NDPI_PROTOCOL_TOR },
  { 0x36BBEF10, 32, NDPI_PROTOCOL_TOR },
  { 0x36BF1132, 32, NDPI_PROTOCOL_TOR },
  { 0x36BF7203, 32, NDPI_PROTOCOL_TOR },
  { 0x36BF80E4, 32, NDPI_PROTOCOL_TOR },
  { 0x36C25AB0, 32, NDPI_PROTOCOL_TOR },
  { 0x36D05F8F, 32, NDPI_PROTOCOL_TOR },
  { 0x36D5A676, 32, NDPI_PROTOCOL_TOR },
  { 0x36E035C2, 32, NDPI_PROTOCOL_TOR },
  { 0x36E44160, 32, NDPI_PROTOCOL_TOR },
  { 0x36E8A7C8, 32, NDPI_PROTOCOL_TOR },
  { 0x36EBF7DC, 32, NDPI_PROTOCOL_TOR },
  { 0x36EDB868, 32, NDPI_PROTOCOL_TOR },
  { 0x36FBC11C, 32, NDPI_PROTOCOL_TOR },
  { 0x36FBD0B4, 32, NDPI_PROTOCOL_TOR },
  { 0x36FC6132, 32, NDPI_PROTOCOL_TOR },
  { 0x3A0775BC, 32, NDPI_PROTOCOL_TOR },
  { 0x3A604E5D, 32, NDPI_PROTOCOL_TOR },
  { 0x3AB78278, 32, NDPI_PROTOCOL_TOR },
  { 0x3B656242, 32, NDPI_PROTOCOL_TOR },
  { 0x3BA79B3B, 32, NDPI_PROTOCOL_TOR },
  { 0x3BB14C69, 32, NDPI_PROTOCOL_TOR },
  { 0x3C230879, 32, NDPI_PROTOCOL_TOR },
  { 0x3CEA7764, 32, NDPI_PROTOCOL_TOR },
  { 0x3CF2B70F, 32, NDPI_PROTOCOL_TOR },
  { 0x3CF8A2B3, 32, NDPI_PROTOCOL_TOR },
  { 0x3D56E640, 32, NDPI_PROTOCOL_TOR },
  { 0x3D5A3C79, 32, NDPI_PROTOCOL_TOR },
  { 0x3DCD303F, 32, NDPI_PROTOCOL_TOR },
  { 0x3DDB7725, 32, NDPI_PROTOCOL_TOR },
  { 0x3DE6AE3B, 32, NDPI_PROTOCOL_TOR },
  { 0x3DE6C615, 32, NDPI_PROTOCOL_TOR },
  { 0x3E040D0D, 32, NDPI_PROTOCOL_TOR },
  { 0x3E1E7D29, 32, NDPI_PROTOCOL_TOR },
  { 0x3E2BAF76, 32, NDPI_PROTOCOL_TOR },
  { 0x3E2C7FB8, 32, NDPI_PROTOCOL_TOR },
  { 0x3E315C96, 32, NDPI_PROTOCOL_TOR },
  { 0x3E3F9D4E, 32, NDPI_PROTOCOL_TOR },
  { 0x3E3FEFD7, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4B8EA6, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4B8FA7, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4B9617, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4B9DC5, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4B9FF9, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BB91A, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BBB2A, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BD198, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BEBDE, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BF147, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BF17F, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BF74A, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BFB9D, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4BFDF7, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4C20B3, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4C2C95, 32, NDPI_PROTOCOL_TOR },
  { 0x3E4D554A, 32, NDPI_PROTOCOL_TOR },
  { 0x3E5C6F2D, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6C249B, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6C2530, 32, NDPI_PROTOCOL_TOR },
  { 0x3E6CAB4C, 32, NDPI_PROTOCOL_TOR },
  { 0x3E70C338, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71DF9A, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71FA27, 32, NDPI_PROTOCOL_TOR },
  { 0x3E71FAB4, 32, NDPI_PROTOCOL_TOR },
  { 0x3E7A36A1, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D24D5, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D251E, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2574, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2CCE, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2E36, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8D2EC1, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8F7968, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8F8DEE, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8F91BE, 32, NDPI_PROTOCOL_TOR },
  { 0x3E8FDE16, 32, NDPI_PROTOCOL_TOR },
  { 0x3E92842F, 32, NDPI_PROTOCOL_TOR },
  { 0x3E93FB15, 32, NDPI_PROTOCOL_TOR },
  { 0x3E9502BC, 32, NDPI_PROTOCOL_TOR },
  { 0x3E950D39, 32, NDPI_PROTOCOL_TOR },
  { 0x3E982BCB, 32, NDPI_PROTOCOL_TOR },
  { 0x3EA803D4, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB0EFE5, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB287DB, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB5EEBA, 32, NDPI_PROTOCOL_TOR },
  { 0x3EB63D99, 32, NDPI_PROTOCOL_TOR },
  { 0x3EC5289B, 32, NDPI_PROTOCOL_TOR },
  { 0x3ECA279D, 32, NDPI_PROTOCOL_TOR },
  { 0x3ECB0AE6, 32, NDPI_PROTOCOL_TOR },
  { 0x3ECC6EC6, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED22410, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED22552, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24579, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED245EC, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24A37, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24A89, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24A8F, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24ABA, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24AC9, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED24C60, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2522C, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED252A9, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED252B1, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25404, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25414, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25C0B, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED25C0B, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28438, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED28990, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED289E6, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED289E6, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2AA0A, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2AA1B, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2AA8F, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2AC5E, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2B6BC, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2B6EF, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2BCDA, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2BD22, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2C698, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CC3D, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CE19, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CE19, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2CE35, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2D3ED, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2ECAE, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2ED55, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2EE32, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F088, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F3A7, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2F3B1, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED2FCAF, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED448F3, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED45233, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED454E5, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED45975, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED6063D, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED8D048, 32, NDPI_PROTOCOL_TOR },
  { 0x3ED97CFD, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDA4B01, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDB2E85, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDBB62A, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC8781, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC88FD, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC9457, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC945E, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC9460, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDC9461, 32, NDPI_PROTOCOL_TOR },
  { 0x3EDCB113, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE1CA01, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE2FA55, 32, NDPI_PROTOCOL_TOR },
  { 0x3EE47585, 32, NDPI_PROTOCOL_TOR },
  { 0x3EF1F052, 32, NDPI_PROTOCOL_TOR },
  { 0x3EFF6FC3, 32, NDPI_PROTOCOL_TOR },
  { 0x3F770D78, 32, NDPI_PROTOCOL_TOR },
  { 0x3F8EF878, 32, NDPI_PROTOCOL_TOR },
  { 0x3FE761E4, 32, NDPI_PROTOCOL_TOR },
  { 0x3FE7B589, 32, NDPI_PROTOCOL_TOR },
  { 0x3FF95AF8, 32, NDPI_PROTOCOL_TOR },
  { 0x400535AF, 32, NDPI_PROTOCOL_TOR },
  { 0x40167D28, 32, NDPI_PROTOCOL_TOR },
  { 0x4022A5ED, 32, NDPI_PROTOCOL_TOR },
  { 0x403AC85C, 32, NDPI_PROTOCOL_TOR },
  { 0x403EF9DE, 32, NDPI_PROTOCOL_TOR },
  { 0x404552A0, 32, NDPI_PROTOCOL_TOR },
  { 0x40478F7C, 32, NDPI_PROTOCOL_TOR },
  { 0x404A7772, 32, NDPI_PROTOCOL_TOR },
  { 0x404E969E, 32, NDPI_PROTOCOL_TOR },
  { 0x405713F4, 32, NDPI_PROTOCOL_TOR },
  { 0x405F3C4B, 32, NDPI_PROTOCOL_TOR },
  { 0x4071201D, 32, NDPI_PROTOCOL_TOR },
  { 0x40712CCE, 32, NDPI_PROTOCOL_TOR },
  { 0x407E2B54, 32, NDPI_PROTOCOL_TOR },
  { 0x40801EE8, 32, NDPI_PROTOCOL_TOR },
  { 0x4096D384, 32, NDPI_PROTOCOL_TOR },
  { 0x40ED332E, 32, NDPI_PROTOCOL_TOR },
  { 0x40FB0E11, 32, NDPI_PROTOCOL_TOR },
  { 0x4113B2B1, 32, NDPI_PROTOCOL_TOR },
  { 0x411DE8C4, 32, NDPI_PROTOCOL_TOR },
  { 0x4124628D, 32, NDPI_PROTOCOL_TOR },
  { 0x4132CB05, 32, NDPI_PROTOCOL_TOR },
  { 0x415E2693, 32, NDPI_PROTOCOL_TOR },
  { 0x416FBA42, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57080, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57159, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57188, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57BFE, 32, NDPI_PROTOCOL_TOR },
  { 0x41B57F76, 32, NDPI_PROTOCOL_TOR },
  { 0x41BF4B1E, 32, NDPI_PROTOCOL_TOR },
  { 0x4207CDA4, 32, NDPI_PROTOCOL_TOR },
  { 0x42088235, 32, NDPI_PROTOCOL_TOR },
  { 0x4208A63E, 32, NDPI_PROTOCOL_TOR },
  { 0x421F2F84, 32, NDPI_PROTOCOL_TOR },
  { 0x421FD0F6, 32, NDPI_PROTOCOL_TOR },
  { 0x422DF72A, 32, NDPI_PROTOCOL_TOR },
  { 0x424217DA, 32, NDPI_PROTOCOL_TOR },
  { 0x4244A7E8, 32, NDPI_PROTOCOL_TOR },
  { 0x42558348, 32, NDPI_PROTOCOL_TOR },
  { 0x426CCBC5, 32, NDPI_PROTOCOL_TOR },
  { 0x426D18CC, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0210, 32, NDPI_PROTOCOL_TOR },
  { 0x426F0214, 32, NDPI_PROTOCOL_TOR },
  { 0x42746CB3, 32, NDPI_PROTOCOL_TOR },
  { 0x4275090A, 32, NDPI_PROTOCOL_TOR },
  { 0x4283C0D3, 32, NDPI_PROTOCOL_TOR },
  { 0x4289E293, 32, NDPI_PROTOCOL_TOR },
  { 0x4292C11F, 32, NDPI_PROTOCOL_TOR },
  { 0x4294745A, 32, NDPI_PROTOCOL_TOR },
  { 0x42AB5188, 32, NDPI_PROTOCOL_TOR },
  { 0x42ABB3C2, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC0A43, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC0CAE, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC0CFE, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC216A, 32, NDPI_PROTOCOL_TOR },
  { 0x42AC21DC, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD3F2, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD3F9, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD695, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD695, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFD94E, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDC99, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDD18, 32, NDPI_PROTOCOL_TOR },
  { 0x42AFDF91, 32, NDPI_PROTOCOL_TOR },
  { 0x42B4C1DB, 32, NDPI_PROTOCOL_TOR },
  { 0x42C428FC, 32, NDPI_PROTOCOL_TOR },
  { 0x42DC03B3, 32, NDPI_PROTOCOL_TOR },
  { 0x42E421F8, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42752, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42772, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42CCC, 32, NDPI_PROTOCOL_TOR },
  { 0x42E42FFE, 32, NDPI_PROTOCOL_TOR },
  { 0x42E436C3, 32, NDPI_PROTOCOL_TOR },
  { 0x42E43B18, 32, NDPI_PROTOCOL_TOR },
  { 0x42E43E5B, 32, NDPI_PROTOCOL_TOR },
  { 0x42F64BA7, 32, NDPI_PROTOCOL_TOR },
  { 0x42F8CC47, 32, NDPI_PROTOCOL_TOR },
  { 0x4300A951, 32, NDPI_PROTOCOL_TOR },
  { 0x4301F94A, 32, NDPI_PROTOCOL_TOR },
  { 0x43125C8D, 32, NDPI_PROTOCOL_TOR },
  { 0x43172B2E, 32, NDPI_PROTOCOL_TOR },
  { 0x4317B5ED, 32, NDPI_PROTOCOL_TOR },
  { 0x4355853B, 32, NDPI_PROTOCOL_TOR },
  { 0x43564FB9, 32, NDPI_PROTOCOL_TOR },
  { 0x4395F029, 32, NDPI_PROTOCOL_TOR },
  { 0x439EE2CA, 32, NDPI_PROTOCOL_TOR },
  { 0x43A58EE2, 32, NDPI_PROTOCOL_TOR },
  { 0x43A864B7, 32, NDPI_PROTOCOL_TOR },
  { 0x43A92D7F, 32, NDPI_PROTOCOL_TOR },
  { 0x43AD3984, 32, NDPI_PROTOCOL_TOR },
  { 0x43AD4C19, 32, NDPI_PROTOCOL_TOR },
  { 0x43B43F19, 32, NDPI_PROTOCOL_TOR },
  { 0x43B799D5, 32, NDPI_PROTOCOL_TOR },
  { 0x43CD598E, 32, NDPI_PROTOCOL_TOR },
  { 0x43CD704A, 32, NDPI_PROTOCOL_TOR },
  { 0x43D7FF8C, 32, NDPI_PROTOCOL_TOR },
  { 0x43DC16BF, 32, NDPI_PROTOCOL_TOR },
  { 0x43F43639, 32, NDPI_PROTOCOL_TOR },
  { 0x43F98A71, 32, NDPI_PROTOCOL_TOR },
  { 0x43FDF527, 32, NDPI_PROTOCOL_TOR },
  { 0x43FF09CB, 32, NDPI_PROTOCOL_TOR },
  { 0x440440C6, 32, NDPI_PROTOCOL_TOR },
  { 0x440859BD, 32, NDPI_PROTOCOL_TOR },
  { 0x44094F72, 32, NDPI_PROTOCOL_TOR },
  { 0x440FB66B, 32, NDPI_PROTOCOL_TOR },
  { 0x442300D4, 32, NDPI_PROTOCOL_TOR },
  { 0x44238420, 32, NDPI_PROTOCOL_TOR },
  { 0x44240EFA, 32, NDPI_PROTOCOL_TOR },
  { 0x44342124, 32, NDPI_PROTOCOL_TOR },
  { 0x4434AFBE, 32, NDPI_PROTOCOL_TOR },
  { 0x443A307C, 32, NDPI_PROTOCOL_TOR },
  { 0x4440A1EE, 32, NDPI_PROTOCOL_TOR },
  { 0x44416405, 32, NDPI_PROTOCOL_TOR },
  { 0x44429AD6, 32, NDPI_PROTOCOL_TOR },
  { 0x44432303, 32, NDPI_PROTOCOL_TOR },
  { 0x44472E8A, 32, NDPI_PROTOCOL_TOR },
  { 0x445011A0, 32, NDPI_PROTOCOL_TOR },
  { 0x44590067, 32, NDPI_PROTOCOL_TOR },
  { 0x4461BFC0, 32, NDPI_PROTOCOL_TOR },
  { 0x44669EA3, 32, NDPI_PROTOCOL_TOR },
  { 0x4468364B, 32, NDPI_PROTOCOL_TOR },
  { 0x44706295, 32, NDPI_PROTOCOL_TOR },
  { 0x4471943A, 32, NDPI_PROTOCOL_TOR },
  { 0x4494A2D8, 32, NDPI_PROTOCOL_TOR },
  { 0x449528B7, 32, NDPI_PROTOCOL_TOR },
  { 0x44B7A9A7, 32, NDPI_PROTOCOL_TOR },
  { 0x44BB40FC, 32, NDPI_PROTOCOL_TOR },
  { 0x44E003CC, 32, NDPI_PROTOCOL_TOR },
  { 0x44E003CC, 32, NDPI_PROTOCOL_TOR },
  { 0x44E4F314, 32, NDPI_PROTOCOL_TOR },
  { 0x44E7DBD4, 32, NDPI_PROTOCOL_TOR },
  { 0x44E9EBD9, 32, NDPI_PROTOCOL_TOR },
  { 0x450C569F, 32, NDPI_PROTOCOL_TOR },
  { 0x450D2623, 32, NDPI_PROTOCOL_TOR },
  { 0x451B5416, 32, NDPI_PROTOCOL_TOR },
  { 0x451C5230, 32, NDPI_PROTOCOL_TOR },
  { 0x451C5A69, 32, NDPI_PROTOCOL_TOR },
  { 0x452731C9, 32, NDPI_PROTOCOL_TOR },
  { 0x4532A549, 32, NDPI_PROTOCOL_TOR },
  { 0x453EA2B2, 32, NDPI_PROTOCOL_TOR },
  { 0x45402255, 32, NDPI_PROTOCOL_TOR },
  { 0x454027B4, 32, NDPI_PROTOCOL_TOR },
  { 0x454030A8, 32, NDPI_PROTOCOL_TOR },
  { 0x45403430, 32, NDPI_PROTOCOL_TOR },
  { 0x4543FC87, 32, NDPI_PROTOCOL_TOR },
  { 0x45596485, 32, NDPI_PROTOCOL_TOR },
  { 0x455A97E5, 32, NDPI_PROTOCOL_TOR },
  { 0x455D7F39, 32, NDPI_PROTOCOL_TOR },
  { 0x45722B5C, 32, NDPI_PROTOCOL_TOR },
  { 0x45733217, 32, NDPI_PROTOCOL_TOR },
  { 0x4573C28D, 32, NDPI_PROTOCOL_TOR },
  { 0x4588E954, 32, NDPI_PROTOCOL_TOR },
  { 0x458A00E2, 32, NDPI_PROTOCOL_TOR },
  { 0x458AB189, 32, NDPI_PROTOCOL_TOR },
  { 0x458D2BC5, 32, NDPI_PROTOCOL_TOR },
  { 0x45928DBA, 32, NDPI_PROTOCOL_TOR },
  { 0x45A26B05, 32, NDPI_PROTOCOL_TOR },
  { 0x45A28B09, 32, NDPI_PROTOCOL_TOR },
  { 0x45A323DE, 32, NDPI_PROTOCOL_TOR },
  { 0x45A3640C, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C3F0, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C4EE, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C524, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C620, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4C696, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4CD93, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4CEB0, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4CFEA, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D108, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D197, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D312, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D4B4, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D6FA, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4D852, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD41, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD4E, 32, NDPI_PROTOCOL_TOR },
  { 0x45A4DD99, 32, NDPI_PROTOCOL_TOR },
  { 0x45AC94F2, 32, NDPI_PROTOCOL_TOR },
  { 0x45AC9C67, 32, NDPI_PROTOCOL_TOR },
  { 0x45ACE727, 32, NDPI_PROTOCOL_TOR },
  { 0x45B57E1B, 32, NDPI_PROTOCOL_TOR },
  { 0x45C38CAE, 32, NDPI_PROTOCOL_TOR },
  { 0x45C456D6, 32, NDPI_PROTOCOL_TOR },
  { 0x45C4AE92, 32, NDPI_PROTOCOL_TOR },
  { 0x45C5AF23, 32, NDPI_PROTOCOL_TOR },
  { 0x45C5AF24, 32, NDPI_PROTOCOL_TOR },
  { 0x45F5523E, 32, NDPI_PROTOCOL_TOR },
  { 0x460F3C1D, 32, NDPI_PROTOCOL_TOR },
  { 0x4618CF2E, 32, NDPI_PROTOCOL_TOR },
  { 0x462438C6, 32, NDPI_PROTOCOL_TOR },
  { 0x46261F79, 32, NDPI_PROTOCOL_TOR },
  { 0x462C2054, 32, NDPI_PROTOCOL_TOR },
  { 0x463D61E4, 32, NDPI_PROTOCOL_TOR },
  { 0x463D61E5, 32, NDPI_PROTOCOL_TOR },
  { 0x463FAA56, 32, NDPI_PROTOCOL_TOR },
  { 0x46551FF2, 32, NDPI_PROTOCOL_TOR },
  { 0x4663CC61, 32, NDPI_PROTOCOL_TOR },
  { 0x4670A038, 32, NDPI_PROTOCOL_TOR },
  { 0x4670A341, 32, NDPI_PROTOCOL_TOR },
  { 0x467176E8, 32, NDPI_PROTOCOL_TOR },
  { 0x46721018, 32, NDPI_PROTOCOL_TOR },
  { 0x46A22F33, 32, NDPI_PROTOCOL_TOR },
  { 0x46A2595A, 32, NDPI_PROTOCOL_TOR },
  { 0x46A56AAE, 32, NDPI_PROTOCOL_TOR },
  { 0x46A923AD, 32, NDPI_PROTOCOL_TOR },
  { 0x46B5013D, 32, NDPI_PROTOCOL_TOR },
  { 0x46BB9A33, 32, NDPI_PROTOCOL_TOR },
  { 0x46BED043, 32, NDPI_PROTOCOL_TOR },
  { 0x470EB6E8, 32, NDPI_PROTOCOL_TOR },
  { 0x47139515, 32, NDPI_PROTOCOL_TOR },
  { 0x4713954E, 32, NDPI_PROTOCOL_TOR },
  { 0x47139BBB, 32, NDPI_PROTOCOL_TOR },
  { 0x47139D7F, 32, NDPI_PROTOCOL_TOR },
  { 0x47139DD5, 32, NDPI_PROTOCOL_TOR },
  { 0x47236A50, 32, NDPI_PROTOCOL_TOR },
  { 0x4738B62B, 32, NDPI_PROTOCOL_TOR },
  { 0x474BC940, 32, NDPI_PROTOCOL_TOR },
  { 0x474F591F, 32, NDPI_PROTOCOL_TOR },
  { 0x474F9691, 32, NDPI_PROTOCOL_TOR },
  { 0x475ACDF8, 32, NDPI_PROTOCOL_TOR },
  { 0x475F28FC, 32, NDPI_PROTOCOL_TOR },
  { 0x47872D47, 32, NDPI_PROTOCOL_TOR },
  { 0x47A59723, 32, NDPI_PROTOCOL_TOR },
  { 0x47A79A15, 32, NDPI_PROTOCOL_TOR },
  { 0x47AE3E2D, 32, NDPI_PROTOCOL_TOR },
  { 0x47B1E232, 32, NDPI_PROTOCOL_TOR },
  { 0x47B76C25, 32, NDPI_PROTOCOL_TOR },
  { 0x47B8FBE9, 32, NDPI_PROTOCOL_TOR },
  { 0x47B9233B, 32, NDPI_PROTOCOL_TOR },
  { 0x47B9AB0D, 32, NDPI_PROTOCOL_TOR },
  { 0x47C3DB07, 32, NDPI_PROTOCOL_TOR },
  { 0x47C5EB05, 32, NDPI_PROTOCOL_TOR },
  { 0x47C5FE48, 32, NDPI_PROTOCOL_TOR },
  { 0x47C772A6, 32, NDPI_PROTOCOL_TOR },
  { 0x47CAB8E5, 32, NDPI_PROTOCOL_TOR },
  { 0x47CC7AF0, 32, NDPI_PROTOCOL_TOR },
  { 0x47D7CE97, 32, NDPI_PROTOCOL_TOR },
  { 0x47DBB265, 32, NDPI_PROTOCOL_TOR },
  { 0x47DE7EC5, 32, NDPI_PROTOCOL_TOR },
  { 0x47E0883A, 32, NDPI_PROTOCOL_TOR },
  { 0x47E6FD44, 32, NDPI_PROTOCOL_TOR },
  { 0x47E7BE7B, 32, NDPI_PROTOCOL_TOR },
  { 0x47EB4AB7, 32, NDPI_PROTOCOL_TOR },
  { 0x47F5506C, 32, NDPI_PROTOCOL_TOR },
  { 0x47FB9E4B, 32, NDPI_PROTOCOL_TOR },
  { 0x4800E332, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB0AC, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB1A4, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB30A, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB3A3, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB552, 32, NDPI_PROTOCOL_TOR },
  { 0x480EB83D, 32, NDPI_PROTOCOL_TOR },
  { 0x480EBAE2, 32, NDPI_PROTOCOL_TOR },
  { 0x481AD093, 32, NDPI_PROTOCOL_TOR },
  { 0x481DA212, 32, NDPI_PROTOCOL_TOR },
  { 0x482E9BBA, 32, NDPI_PROTOCOL_TOR },
  { 0x48332350, 32, NDPI_PROTOCOL_TOR },
  { 0x48344B1B, 32, NDPI_PROTOCOL_TOR },
  { 0x48345B16, 32, NDPI_PROTOCOL_TOR },
  { 0x48345B1D, 32, NDPI_PROTOCOL_TOR },
  { 0x48345B1E, 32, NDPI_PROTOCOL_TOR },
  { 0x48358586, 32, NDPI_PROTOCOL_TOR },
  { 0x484200E9, 32, NDPI_PROTOCOL_TOR },
  { 0x4845E5D5, 32, NDPI_PROTOCOL_TOR },
  { 0x4845F863, 32, NDPI_PROTOCOL_TOR },
  { 0x484E8BB9, 32, NDPI_PROTOCOL_TOR },
  { 0x48531759, 32, NDPI_PROTOCOL_TOR },
  { 0x4859E93A, 32, NDPI_PROTOCOL_TOR },
  { 0x485DF597, 32, NDPI_PROTOCOL_TOR },
  { 0x488184C2, 32, NDPI_PROTOCOL_TOR },
  { 0x488313EC, 32, NDPI_PROTOCOL_TOR },
  { 0x48A0F076, 32, NDPI_PROTOCOL_TOR },
  { 0x48AEAC8D, 32, NDPI_PROTOCOL_TOR },
  { 0x48B13B6E, 32, NDPI_PROTOCOL_TOR },
  { 0x48C0D011, 32, NDPI_PROTOCOL_TOR },
  { 0x48C105B0, 32, NDPI_PROTOCOL_TOR },
  { 0x48C5C123, 32, NDPI_PROTOCOL_TOR },
  { 0x48D1B426, 32, NDPI_PROTOCOL_TOR },
  { 0x48D1DB9A, 32, NDPI_PROTOCOL_TOR },
  { 0x48D8ECC2, 32, NDPI_PROTOCOL_TOR },
  { 0x48DCAD6B, 32, NDPI_PROTOCOL_TOR },
  { 0x48DE8A0C, 32, NDPI_PROTOCOL_TOR },
  { 0x48E1295B, 32, NDPI_PROTOCOL_TOR },
  { 0x48EFE271, 32, NDPI_PROTOCOL_TOR },
  { 0x48F9B964, 32, NDPI_PROTOCOL_TOR },
  { 0x48FAD50D, 32, NDPI_PROTOCOL_TOR },
  { 0x48FD5C2C, 32, NDPI_PROTOCOL_TOR },
  { 0x49041E43, 32, NDPI_PROTOCOL_TOR },
  { 0x49043472, 32, NDPI_PROTOCOL_TOR },
  { 0x4906D179, 32, NDPI_PROTOCOL_TOR },
  { 0x4908B6E5, 32, NDPI_PROTOCOL_TOR },
  { 0x490B9E26, 32, NDPI_PROTOCOL_TOR },
  { 0x490F96AC, 32, NDPI_PROTOCOL_TOR },
  { 0x490FFEF1, 32, NDPI_PROTOCOL_TOR },
  { 0x49134ECD, 32, NDPI_PROTOCOL_TOR },
  { 0x491610C3, 32, NDPI_PROTOCOL_TOR },
  { 0x492574A8, 32, NDPI_PROTOCOL_TOR },
  { 0x4926F8B6, 32, NDPI_PROTOCOL_TOR },
  { 0x49274DA6, 32, NDPI_PROTOCOL_TOR },
  { 0x492C8639, 32, NDPI_PROTOCOL_TOR },
  { 0x492D254B, 32, NDPI_PROTOCOL_TOR },
  { 0x492FF6DF, 32, NDPI_PROTOCOL_TOR },
  { 0x49304E30, 32, NDPI_PROTOCOL_TOR },
  { 0x49308BE2, 32, NDPI_PROTOCOL_TOR },
  { 0x498400F7, 32, NDPI_PROTOCOL_TOR },
  { 0x4984FA0B, 32, NDPI_PROTOCOL_TOR },
  { 0x49A3EC5F, 32, NDPI_PROTOCOL_TOR },
  { 0x49A5F4EE, 32, NDPI_PROTOCOL_TOR },
  { 0x49A64EFD, 32, NDPI_PROTOCOL_TOR },
  { 0x49A69CAC, 32, NDPI_PROTOCOL_TOR },
  { 0x49AA0647, 32, NDPI_PROTOCOL_TOR },
  { 0x49AC98E6, 32, NDPI_PROTOCOL_TOR },
  { 0x49C08B3F, 32, NDPI_PROTOCOL_TOR },
  { 0x49C0E718, 32, NDPI_PROTOCOL_TOR },
  { 0x49C6A499, 32, NDPI_PROTOCOL_TOR },
  { 0x49C7CBB9, 32, NDPI_PROTOCOL_TOR },
  { 0x49CAE19F, 32, NDPI_PROTOCOL_TOR },
  { 0x49D03060, 32, NDPI_PROTOCOL_TOR },
  { 0x49D0409E, 32, NDPI_PROTOCOL_TOR },
  { 0x49D0A2E1, 32, NDPI_PROTOCOL_TOR },
  { 0x49D932BB, 32, NDPI_PROTOCOL_TOR },
  { 0x49DE0E0A, 32, NDPI_PROTOCOL_TOR },
  { 0x4A03A527, 32, NDPI_PROTOCOL_TOR },
  { 0x4A323644, 32, NDPI_PROTOCOL_TOR },
  { 0x4A3BA760, 32, NDPI_PROTOCOL_TOR },
  { 0x4A3BCC47, 32, NDPI_PROTOCOL_TOR },
  { 0x4A436379, 32, NDPI_PROTOCOL_TOR },
  { 0x4A47FA54, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5203E0, 32, NDPI_PROTOCOL_TOR },
  { 0x4A536574, 32, NDPI_PROTOCOL_TOR },
  { 0x4A561813, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5B1B8D, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5B1B8E, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5E43C4, 32, NDPI_PROTOCOL_TOR },
  { 0x4A5FBB69, 32, NDPI_PROTOCOL_TOR },
  { 0x4A60E7B2, 32, NDPI_PROTOCOL_TOR },
  { 0x4A621760, 32, NDPI_PROTOCOL_TOR },
  { 0x4A65C9F9, 32, NDPI_PROTOCOL_TOR },
  { 0x4A677F7F, 32, NDPI_PROTOCOL_TOR },
  { 0x4A6DF071, 32, NDPI_PROTOCOL_TOR },
  { 0x4A74BA78, 32, NDPI_PROTOCOL_TOR },
  { 0x4A79B693, 32, NDPI_PROTOCOL_TOR },
  { 0x4A7CAB14, 32, NDPI_PROTOCOL_TOR },
  { 0x4A8AA23A, 32, NDPI_PROTOCOL_TOR },
  { 0x4AB9DBC9, 32, NDPI_PROTOCOL_TOR },
  { 0x4AC09417, 32, NDPI_PROTOCOL_TOR },
  { 0x4AC14C45, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACEB5A4, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE03F, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE03F, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE7BA, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE7FA, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFE998, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFECC5, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFED2C, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFEDA7, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFEDA7, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF207, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF86E, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFF9A9, 32, NDPI_PROTOCOL_TOR },
  { 0x4ACFFB6D, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD045C2, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD04E82, 32, NDPI_PROTOCOL_TOR },
  { 0x4AD2C50C, 32, NDPI_PROTOCOL_TOR },
  { 0x4B013890, 32, NDPI_PROTOCOL_TOR },
  { 0x4B09754D, 32, NDPI_PROTOCOL_TOR },
  { 0x4B435766, 32, NDPI_PROTOCOL_TOR },
  { 0x4B451E4D, 32, NDPI_PROTOCOL_TOR },
  { 0x4B488B38, 32, NDPI_PROTOCOL_TOR },
  { 0x4B4F23FE, 32, NDPI_PROTOCOL_TOR },
  { 0x4B50A0EC, 32, NDPI_PROTOCOL_TOR },
  { 0x4B5169DB, 32, NDPI_PROTOCOL_TOR },
  { 0x4B52A04D, 32, NDPI_PROTOCOL_TOR },
  { 0x4B54A327, 32, NDPI_PROTOCOL_TOR },
  { 0x4B6189EA, 32, NDPI_PROTOCOL_TOR },
  { 0x4B642932, 32, NDPI_PROTOCOL_TOR },
  { 0x4B65602F, 32, NDPI_PROTOCOL_TOR },
  { 0x4B7650AB, 32, NDPI_PROTOCOL_TOR },
  { 0x4B76EED4, 32, NDPI_PROTOCOL_TOR },
  { 0x4B77E8C9, 32, NDPI_PROTOCOL_TOR },
  { 0x4B7F0F49, 32, NDPI_PROTOCOL_TOR },
  { 0x4B82033A, 32, NDPI_PROTOCOL_TOR },
  { 0x4B849247, 32, NDPI_PROTOCOL_TOR },
  { 0x4B8567ED, 32, NDPI_PROTOCOL_TOR },
  { 0x4B8FB432, 32, NDPI_PROTOCOL_TOR },
  { 0x4B91CDB1, 32, NDPI_PROTOCOL_TOR },
  { 0x4B965B14, 32, NDPI_PROTOCOL_TOR },
  { 0x4B965B15, 32, NDPI_PROTOCOL_TOR },
  { 0x4BA665D5, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB117FE, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB38B1A, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB3AFC4, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB66C77, 32, NDPI_PROTOCOL_TOR },
  { 0x4BB93208, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0A8078, 32, NDPI_PROTOCOL_TOR },
  { 0x4C0CDB68, 32, NDPI_PROTOCOL_TOR },
  { 0x4C17D13D, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1ACBF3, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1CD1A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4C1CEA17, 32, NDPI_PROTOCOL_TOR },
  { 0x4C400D9B, 32, NDPI_PROTOCOL_TOR },
  { 0x4C490364, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4903AE, 32, NDPI_PROTOCOL_TOR },
  { 0x4C493996, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4AB2F6, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4ADB8A, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4C08E8, 32, NDPI_PROTOCOL_TOR },
  { 0x4C4F2E66, 32, NDPI_PROTOCOL_TOR },
  { 0x4C55CFD4, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5BCBA2, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5BE269, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5CE1D8, 32, NDPI_PROTOCOL_TOR },
  { 0x4C5DD733, 32, NDPI_PROTOCOL_TOR },
  { 0x4C63DE9C, 32, NDPI_PROTOCOL_TOR },
  { 0x4C66C7AA, 32, NDPI_PROTOCOL_TOR },
  { 0x4C6A2761, 32, NDPI_PROTOCOL_TOR },
  { 0x4C702F3C, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7153C2, 32, NDPI_PROTOCOL_TOR },
  { 0x4C732D7C, 32, NDPI_PROTOCOL_TOR },
  { 0x4C73829B, 32, NDPI_PROTOCOL_TOR },
  { 0x4C778735, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7A13E6, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7BBBD2, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7C660E, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7CAF69, 32, NDPI_PROTOCOL_TOR },
  { 0x4C7E0D52, 32, NDPI_PROTOCOL_TOR },
  { 0x4CAA4864, 32, NDPI_PROTOCOL_TOR },
  { 0x4CAEFDD2, 32, NDPI_PROTOCOL_TOR },
  { 0x4CB28C0E, 32, NDPI_PROTOCOL_TOR },
  { 0x4CB9120F, 32, NDPI_PROTOCOL_TOR },
  { 0x4CBAB2BC, 32, NDPI_PROTOCOL_TOR },
  { 0x4CBC4252, 32, NDPI_PROTOCOL_TOR },
  { 0x4CBFD7D7, 32, NDPI_PROTOCOL_TOR },
  { 0x4CD11461, 32, NDPI_PROTOCOL_TOR },
  { 0x4CD90D94, 32, NDPI_PROTOCOL_TOR },
  { 0x4CD90D94, 32, NDPI_PROTOCOL_TOR },
  { 0x4CD995F0, 32, NDPI_PROTOCOL_TOR },
  { 0x4D00C9A3, 32, NDPI_PROTOCOL_TOR },
  { 0x4D01045C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D04EB00, 32, NDPI_PROTOCOL_TOR },
  { 0x4D06EDF4, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0A7CF0, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0AAEE8, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0AD0A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C1CB8, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C1CB8, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C65BB, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0C84CC, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0DB854, 32, NDPI_PROTOCOL_TOR },
  { 0x4D0DBCEF, 32, NDPI_PROTOCOL_TOR },
  { 0x4D142DA8, 32, NDPI_PROTOCOL_TOR },
  { 0x4D1430C4, 32, NDPI_PROTOCOL_TOR },
  { 0x4D145762, 32, NDPI_PROTOCOL_TOR },
  { 0x4D149215, 32, NDPI_PROTOCOL_TOR },
  { 0x4D149784, 32, NDPI_PROTOCOL_TOR },
  { 0x4D14C9D3, 32, NDPI_PROTOCOL_TOR },
  { 0x4D1505EA, 32, NDPI_PROTOCOL_TOR },
  { 0x4D15295E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D154971, 32, NDPI_PROTOCOL_TOR },
  { 0x4D154D67, 32, NDPI_PROTOCOL_TOR },
  { 0x4D15D971, 32, NDPI_PROTOCOL_TOR },
  { 0x4D170724, 32, NDPI_PROTOCOL_TOR },
  { 0x4D170A99, 32, NDPI_PROTOCOL_TOR },
  { 0x4D171AE2, 32, NDPI_PROTOCOL_TOR },
  { 0x4D176F1E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D250CBF, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2588A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25B87E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25DA91, 32, NDPI_PROTOCOL_TOR },
  { 0x4D25F08E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D292F5B, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2DFD87, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2F7D6F, 32, NDPI_PROTOCOL_TOR },
  { 0x4D2FD16E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D32EB4C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D343FC5, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3856DC, 32, NDPI_PROTOCOL_TOR },
  { 0x4D396860, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3A033E, 32, NDPI_PROTOCOL_TOR },
  { 0x4D3AD4A9, 32, NDPI_PROTOCOL_TOR },
  { 0x4D40D46F, 32, NDPI_PROTOCOL_TOR },
  { 0x4D422DE3, 32, NDPI_PROTOCOL_TOR },
  { 0x4D422E18, 32, NDPI_PROTOCOL_TOR },
  { 0x4D44245D, 32, NDPI_PROTOCOL_TOR },
  { 0x4D463F8D, 32, NDPI_PROTOCOL_TOR },
  { 0x4D48932F, 32, NDPI_PROTOCOL_TOR },
  { 0x4D489696, 32, NDPI_PROTOCOL_TOR },
  { 0x4D4E77D3, 32, NDPI_PROTOCOL_TOR },
  { 0x4D51F029, 32, NDPI_PROTOCOL_TOR },
  { 0x4D56C546, 32, NDPI_PROTOCOL_TOR },
  { 0x4D56CC64, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6220E9, 32, NDPI_PROTOCOL_TOR },
  { 0x4D66D762, 32, NDPI_PROTOCOL_TOR },
  { 0x4D69D0D9, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8A2A, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8A2B, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8A2C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8B1A, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8B1B, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8B1C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8B57, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8D8A, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8D8B, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6D8D8C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D6DB99C, 32, NDPI_PROTOCOL_TOR },
  { 0x4D765894, 32, NDPI_PROTOCOL_TOR },
  { 0x4D7B5606, 32, NDPI_PROTOCOL_TOR },
  { 0x4D834130, 32, NDPI_PROTOCOL_TOR },
  { 0x4D86A910, 32, NDPI_PROTOCOL_TOR },
  { 0x4D98FB30, 32, NDPI_PROTOCOL_TOR },
  { 0x4DAA0102, 32, NDPI_PROTOCOL_TOR },
  { 0x4DAE88F2, 32, NDPI_PROTOCOL_TOR },
  { 0x4DAEB4C5, 32, NDPI_PROTOCOL_TOR },
  { 0x4DAEF986, 32, NDPI_PROTOCOL_TOR },
  { 0x4DC5A34D, 32, NDPI_PROTOCOL_TOR },
  { 0x4DCBDD5B, 32, NDPI_PROTOCOL_TOR },
  { 0x4DCF4DB2, 32, NDPI_PROTOCOL_TOR },
  { 0x4DCF6FCE, 32, NDPI_PROTOCOL_TOR },
  { 0x4DDF4BCF, 32, NDPI_PROTOCOL_TOR },
  { 0x4DE4A752, 32, NDPI_PROTOCOL_TOR },
  { 0x4DE4AF4A, 32, NDPI_PROTOCOL_TOR },
  { 0x4DE9EE82, 32, NDPI_PROTOCOL_TOR },
  { 0x4DEA31CE, 32, NDPI_PROTOCOL_TOR },
  { 0x4DEA947A, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF30962, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF4FEE3, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF4FEE4, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF4FEE5, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF4FEE6, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF6D813, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A2, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A3, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A3, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A4, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4DF7B5A6, 32, NDPI_PROTOCOL_TOR },
  { 0x4DFB6AF8, 32, NDPI_PROTOCOL_TOR },
  { 0x4DFEAE40, 32, NDPI_PROTOCOL_TOR },
  { 0x4E08A504, 32, NDPI_PROTOCOL_TOR },
  { 0x4E0D3D36, 32, NDPI_PROTOCOL_TOR },
  { 0x4E1506A1, 32, NDPI_PROTOCOL_TOR },
  { 0x4E18DA8A, 32, NDPI_PROTOCOL_TOR },
  { 0x4E1B6E57, 32, NDPI_PROTOCOL_TOR },
  { 0x4E1FA429, 32, NDPI_PROTOCOL_TOR },
  { 0x4E227847, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2917A2, 32, NDPI_PROTOCOL_TOR },
  { 0x4E29E9C0, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2A9D62, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2B689D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2B752E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2B8EB1, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2D136A, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E1188, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E2BDD, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E2DF2, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E337C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E350B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E3C1E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E40F5, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E4229, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E50F7, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E512D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E5F14, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E69F1, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E6A6F, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E6B0F, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E70DB, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E7B22, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E7BAC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E943A, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E970B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E9713, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2E989E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EA78D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EB0A9, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EC54B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDA0B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDC82, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EDD7D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EE185, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EEFB7, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF724, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2EF729, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F0406, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F10A6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F126E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F1BF6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F2323, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F273C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F27BC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F297D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F2CBC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F2CD4, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F31EB, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F325C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F35B7, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F3DDE, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F405B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F49B6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5462, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5699, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5D0C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5DC8, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F5F9C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F8606, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F8B62, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F9199, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F94AE, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2F963D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FA559, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FA844, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FABA6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FACF4, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FAE9B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FBAF3, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FBC04, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FBFDD, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FC5AC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FD81C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FDABE, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FDBA6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FDE4A, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE0DB, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE208, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE568, 32, NDPI_PROTOCOL_TOR },
  { 0x4E2FE56B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E301266, 32, NDPI_PROTOCOL_TOR },
  { 0x4E30213F, 32, NDPI_PROTOCOL_TOR },
  { 0x4E30E5E7, 32, NDPI_PROTOCOL_TOR },
  { 0x4E314714, 32, NDPI_PROTOCOL_TOR },
  { 0x4E337866, 32, NDPI_PROTOCOL_TOR },
  { 0x4E339FA4, 32, NDPI_PROTOCOL_TOR },
  { 0x4E341CCA, 32, NDPI_PROTOCOL_TOR },
  { 0x4E344588, 32, NDPI_PROTOCOL_TOR },
  { 0x4E345BC2, 32, NDPI_PROTOCOL_TOR },
  { 0x4E34709C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E3500BA, 32, NDPI_PROTOCOL_TOR },
  { 0x4E3543BB, 32, NDPI_PROTOCOL_TOR },
  { 0x4E3578C0, 32, NDPI_PROTOCOL_TOR },
  { 0x4E35D113, 32, NDPI_PROTOCOL_TOR },
  { 0x4E36B32D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E36B849, 32, NDPI_PROTOCOL_TOR },
  { 0x4E37167F, 32, NDPI_PROTOCOL_TOR },
  { 0x4E371BD3, 32, NDPI_PROTOCOL_TOR },
  { 0x4E37EECD, 32, NDPI_PROTOCOL_TOR },
  { 0x4E382816, 32, NDPI_PROTOCOL_TOR },
  { 0x4E38837E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E448EF1, 32, NDPI_PROTOCOL_TOR },
  { 0x4E455699, 32, NDPI_PROTOCOL_TOR },
  { 0x4E460AE6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E559863, 32, NDPI_PROTOCOL_TOR },
  { 0x4E55C395, 32, NDPI_PROTOCOL_TOR },
  { 0x4E582ECD, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5A0FE5, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5A8252, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5E71A9, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5EC2DB, 32, NDPI_PROTOCOL_TOR },
  { 0x4E5EFD61, 32, NDPI_PROTOCOL_TOR },
  { 0x4E66CF73, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6A9813, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BE9E5, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BED10, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BEFD5, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6BFE79, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C3F2C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6C3F2E, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6EA0B9, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6F4E8C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E6FEE6B, 32, NDPI_PROTOCOL_TOR },
  { 0x4E73B49D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E787A3F, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81891C, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81A639, 32, NDPI_PROTOCOL_TOR },
  { 0x4E81B421, 32, NDPI_PROTOCOL_TOR },
  { 0x4E833886, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8B7228, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8D50EC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E8EF6, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8E918D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E8EAF46, 32, NDPI_PROTOCOL_TOR },
  { 0x4E91349D, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9BA97A, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9C75EC, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9C77C8, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9DC871, 32, NDPI_PROTOCOL_TOR },
  { 0x4E9F3CC3, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC0BD4C, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC0F14B, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC1067E, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC128CD, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC128FE, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC14F78, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC15603, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC1674D, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC1A442, 32, NDPI_PROTOCOL_TOR },
  { 0x4EC6B4CD, 32, NDPI_PROTOCOL_TOR },
  { 0x4ECD5081, 32, NDPI_PROTOCOL_TOR },
  { 0x4EDA527F, 32, NDPI_PROTOCOL_TOR },
  { 0x4EDD8C72, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE030F7, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE0F0C4, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE2A060, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE588B8, 32, NDPI_PROTOCOL_TOR },
  { 0x4EE96597, 32, NDPI_PROTOCOL_TOR },
  { 0x4EEC369E, 32, NDPI_PROTOCOL_TOR },
  { 0x4EEF7556, 32, NDPI_PROTOCOL_TOR },
  { 0x4EF7B665, 32, NDPI_PROTOCOL_TOR },
  { 0x4EF8D759, 32, NDPI_PROTOCOL_TOR },
  { 0x4F4771F0, 32, NDPI_PROTOCOL_TOR },
  { 0x4F501132, 32, NDPI_PROTOCOL_TOR },
  { 0x4F59660B, 32, NDPI_PROTOCOL_TOR },
  { 0x4F621F2A, 32, NDPI_PROTOCOL_TOR },
  { 0x4F660402, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6D109F, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6D94CB, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6F13C2, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6F51A0, 32, NDPI_PROTOCOL_TOR },
  { 0x4F6FDA32, 32, NDPI_PROTOCOL_TOR },
  { 0x4F700984, 32, NDPI_PROTOCOL_TOR },
  { 0x4F716914, 32, NDPI_PROTOCOL_TOR },
  { 0x4F780A62, 32, NDPI_PROTOCOL_TOR },
  { 0x4F78282D, 32, NDPI_PROTOCOL_TOR },
  { 0x4F7851B7, 32, NDPI_PROTOCOL_TOR },
  { 0x4F825F7B, 32, NDPI_PROTOCOL_TOR },
  { 0x4F861BFF, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EAC8, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86EB05, 32, NDPI_PROTOCOL_TOR },
  { 0x4F86FF23, 32, NDPI_PROTOCOL_TOR },
  { 0x4F87465A, 32, NDPI_PROTOCOL_TOR },
  { 0x4F881D2B, 32, NDPI_PROTOCOL_TOR },
  { 0x4F882ABE, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8BBDB9, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C27CA, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2975, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C2976, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8C4005, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8E6A54, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB36A, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FB572, 32, NDPI_PROTOCOL_TOR },
  { 0x4F8FBC46, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA04C99, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA0A26A, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA438F1, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA45FB4, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA5B4F3, 32, NDPI_PROTOCOL_TOR },
  { 0x4FA5DFD1, 32, NDPI_PROTOCOL_TOR },
  { 0x4FAC1212, 32, NDPI_PROTOCOL_TOR },
  { 0x4FAC1CCD, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACC120, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACCC24, 32, NDPI_PROTOCOL_TOR },
  { 0x4FACF908, 32, NDPI_PROTOCOL_TOR },
  { 0x4FB73E97, 32, NDPI_PROTOCOL_TOR },
  { 0x4FBD0233, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC17B35, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC3BA9D, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC5C597, 32, NDPI_PROTOCOL_TOR },
  { 0x4FC8C7B3, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCA6B3A, 32, NDPI_PROTOCOL_TOR },
  { 0x4FCB519B, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD446F9, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD62F35, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD6C9C2, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD6E742, 32, NDPI_PROTOCOL_TOR },
  { 0x4FD7DEA0, 32, NDPI_PROTOCOL_TOR },
  { 0x4FDCC79F, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE25CA4, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE2CDCD, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE2DAE6, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE3BBBF, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE478A5, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE4EA15, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE5C024, 32, NDPI_PROTOCOL_TOR },
  { 0x4FE755CF, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEA50ED, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEB63B5, 32, NDPI_PROTOCOL_TOR },
  { 0x4FEC5A62, 32, NDPI_PROTOCOL_TOR },
  { 0x4FECD8B0, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF15810, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF19FF7, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF1D2DC, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF1D690, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF2515A, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF35735, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF5435F, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF58FAB, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF6CF32, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF77321, 32, NDPI_PROTOCOL_TOR },
  { 0x4FF87986, 32, NDPI_PROTOCOL_TOR },
  { 0x4FFBF5CA, 32, NDPI_PROTOCOL_TOR },
  { 0x4FFF9947, 32, NDPI_PROTOCOL_TOR },
  { 0x50025741, 32, NDPI_PROTOCOL_TOR },
  { 0x5004F810, 32, NDPI_PROTOCOL_TOR },
  { 0x500593F5, 32, NDPI_PROTOCOL_TOR },
  { 0x500C5EB8, 32, NDPI_PROTOCOL_TOR },
  { 0x502A9965, 32, NDPI_PROTOCOL_TOR },
  { 0x502AA456, 32, NDPI_PROTOCOL_TOR },
  { 0x50390AA9, 32, NDPI_PROTOCOL_TOR },
  { 0x50393FB3, 32, NDPI_PROTOCOL_TOR },
  { 0x50397C3A, 32, NDPI_PROTOCOL_TOR },
  { 0x5042877B, 32, NDPI_PROTOCOL_TOR },
  { 0x5043AC13, 32, NDPI_PROTOCOL_TOR },
  { 0x504459B6, 32, NDPI_PROTOCOL_TOR },
  { 0x50445CF9, 32, NDPI_PROTOCOL_TOR },
  { 0x50478577, 32, NDPI_PROTOCOL_TOR },
  { 0x504786B5, 32, NDPI_PROTOCOL_TOR },
  { 0x5049D3D9, 32, NDPI_PROTOCOL_TOR },
  { 0x5049F28E, 32, NDPI_PROTOCOL_TOR },
  { 0x504EF251, 32, NDPI_PROTOCOL_TOR },
  { 0x504EF656, 32, NDPI_PROTOCOL_TOR },
  { 0x504F1707, 32, NDPI_PROTOCOL_TOR },
  { 0x5051111F, 32, NDPI_PROTOCOL_TOR },
  { 0x5051F378, 32, NDPI_PROTOCOL_TOR },
  { 0x5051F3E2, 32, NDPI_PROTOCOL_TOR },
  { 0x5051F3EB, 32, NDPI_PROTOCOL_TOR },
  { 0x5052D7D2, 32, NDPI_PROTOCOL_TOR },
  { 0x50555448, 32, NDPI_PROTOCOL_TOR },
  { 0x505554DE, 32, NDPI_PROTOCOL_TOR },
  { 0x505554F0, 32, NDPI_PROTOCOL_TOR },
  { 0x50565329, 32, NDPI_PROTOCOL_TOR },
  { 0x50565CB5, 32, NDPI_PROTOCOL_TOR },
  { 0x50565D80, 32, NDPI_PROTOCOL_TOR },
  { 0x5059C09E, 32, NDPI_PROTOCOL_TOR },
  { 0x505A2B81, 32, NDPI_PROTOCOL_TOR },
  { 0x505A2BDD, 32, NDPI_PROTOCOL_TOR },
  { 0x50631FF8, 32, NDPI_PROTOCOL_TOR },
  { 0x5063FE73, 32, NDPI_PROTOCOL_TOR },
  { 0x50642620, 32, NDPI_PROTOCOL_TOR },
  { 0x50642CDB, 32, NDPI_PROTOCOL_TOR },
  { 0x50642CFD, 32, NDPI_PROTOCOL_TOR },
  { 0x50642D9C, 32, NDPI_PROTOCOL_TOR },
  { 0x50648003, 32, NDPI_PROTOCOL_TOR },
  { 0x5064BD03, 32, NDPI_PROTOCOL_TOR },
  { 0x5064CC04, 32, NDPI_PROTOCOL_TOR },
  { 0x5064CE96, 32, NDPI_PROTOCOL_TOR },
  { 0x506573AA, 32, NDPI_PROTOCOL_TOR },
  { 0x506C8F13, 32, NDPI_PROTOCOL_TOR },
  { 0x506DA2EA, 32, NDPI_PROTOCOL_TOR },
  { 0x506DE134, 32, NDPI_PROTOCOL_TOR },
  { 0x506E2316, 32, NDPI_PROTOCOL_TOR },
  { 0x506E37C4, 32, NDPI_PROTOCOL_TOR },
  { 0x506FEC0F, 32, NDPI_PROTOCOL_TOR },
  { 0x50709921, 32, NDPI_PROTOCOL_TOR },
  { 0x5071010B, 32, NDPI_PROTOCOL_TOR },
  { 0x50743860, 32, NDPI_PROTOCOL_TOR },
  { 0x50764CC5, 32, NDPI_PROTOCOL_TOR },
  { 0x50807E83, 32, NDPI_PROTOCOL_TOR },
  { 0x50814072, 32, NDPI_PROTOCOL_TOR },
  { 0x50868F7F, 32, NDPI_PROTOCOL_TOR },
  { 0x5087E176, 32, NDPI_PROTOCOL_TOR },
  { 0x508874C1, 32, NDPI_PROTOCOL_TOR },
  { 0x50894240, 32, NDPI_PROTOCOL_TOR },
  { 0x508AEC03, 32, NDPI_PROTOCOL_TOR },
  { 0x508AEFF3, 32, NDPI_PROTOCOL_TOR },
  { 0x508B637B, 32, NDPI_PROTOCOL_TOR },
  { 0x508B727D, 32, NDPI_PROTOCOL_TOR },
  { 0x508C6003, 32, NDPI_PROTOCOL_TOR },
  { 0x508F6A3C, 32, NDPI_PROTOCOL_TOR },
  { 0x5093219D, 32, NDPI_PROTOCOL_TOR },
  { 0x509325F7, 32, NDPI_PROTOCOL_TOR },
  { 0x5098EF17, 32, NDPI_PROTOCOL_TOR },
  { 0x50990704, 32, NDPI_PROTOCOL_TOR },
  { 0x50A19C30, 32, NDPI_PROTOCOL_TOR },
  { 0x50A20720, 32, NDPI_PROTOCOL_TOR },
  { 0x50A32958, 32, NDPI_PROTOCOL_TOR },
  { 0x50A770EE, 32, NDPI_PROTOCOL_TOR },
  { 0x50AB1353, 32, NDPI_PROTOCOL_TOR },
  { 0x50AB285B, 32, NDPI_PROTOCOL_TOR },
  { 0x50C3B7F0, 32, NDPI_PROTOCOL_TOR },
  { 0x50CAAF5A, 32, NDPI_PROTOCOL_TOR },
  { 0x50CAEE20, 32, NDPI_PROTOCOL_TOR },
  { 0x50CB102E, 32, NDPI_PROTOCOL_TOR },
  { 0x50D4A2ED, 32, NDPI_PROTOCOL_TOR },
  { 0x50D87BFC, 32, NDPI_PROTOCOL_TOR },
  { 0x50DA9F57, 32, NDPI_PROTOCOL_TOR },
  { 0x50DAD94E, 32, NDPI_PROTOCOL_TOR },
  { 0x50DB0244, 32, NDPI_PROTOCOL_TOR },
  { 0x50DB8C29, 32, NDPI_PROTOCOL_TOR },
  { 0x50DC5274, 32, NDPI_PROTOCOL_TOR },
  { 0x50DCE66B, 32, NDPI_PROTOCOL_TOR },
  { 0x50DCF46B, 32, NDPI_PROTOCOL_TOR },
  { 0x50DFA940, 32, NDPI_PROTOCOL_TOR },
  { 0x50DFB670, 32, NDPI_PROTOCOL_TOR },
  { 0x50DFD0F6, 32, NDPI_PROTOCOL_TOR },
  { 0x50E500D2, 32, NDPI_PROTOCOL_TOR },
  { 0x50EDE24B, 32, NDPI_PROTOCOL_TOR },
  { 0x50EEE5A1, 32, NDPI_PROTOCOL_TOR },
  { 0x50F08096, 32, NDPI_PROTOCOL_TOR },
  { 0x50F080E9, 32, NDPI_PROTOCOL_TOR },
  { 0x50F086F6, 32, NDPI_PROTOCOL_TOR },
  { 0x50F08D97, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1D942, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DA9A, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DCDD, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DE24, 32, NDPI_PROTOCOL_TOR },
  { 0x50F1DE62, 32, NDPI_PROTOCOL_TOR },
  { 0x50F4F39E, 32, NDPI_PROTOCOL_TOR },
  { 0x50F63BE9, 32, NDPI_PROTOCOL_TOR },
  { 0x50F8D083, 32, NDPI_PROTOCOL_TOR },
  { 0x50FEDB30, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF0BD3, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF0BE0, 32, NDPI_PROTOCOL_TOR },
  { 0x50FF0BED, 32, NDPI_PROTOCOL_TOR },
  { 0x5102C521, 32, NDPI_PROTOCOL_TOR },
  { 0x5102ECA5, 32, NDPI_PROTOCOL_TOR },
  { 0x5104655D, 32, NDPI_PROTOCOL_TOR },
  { 0x5104676A, 32, NDPI_PROTOCOL_TOR },
  { 0x51046810, 32, NDPI_PROTOCOL_TOR },
  { 0x51046852, 32, NDPI_PROTOCOL_TOR },
  { 0x510469C0, 32, NDPI_PROTOCOL_TOR },
  { 0x51046B24, 32, NDPI_PROTOCOL_TOR },
  { 0x51046B44, 32, NDPI_PROTOCOL_TOR },
  { 0x51046BBE, 32, NDPI_PROTOCOL_TOR },
  { 0x51046BE3, 32, NDPI_PROTOCOL_TOR },
  { 0x51046CC7, 32, NDPI_PROTOCOL_TOR },
  { 0x51046D2F, 32, NDPI_PROTOCOL_TOR },
  { 0x51046D7D, 32, NDPI_PROTOCOL_TOR },
  { 0x51046DD0, 32, NDPI_PROTOCOL_TOR },
  { 0x51046DFA, 32, NDPI_PROTOCOL_TOR },
  { 0x51046E5D, 32, NDPI_PROTOCOL_TOR },
  { 0x51046E95, 32, NDPI_PROTOCOL_TOR },
  { 0x51046F6B, 32, NDPI_PROTOCOL_TOR },
  { 0x51047930, 32, NDPI_PROTOCOL_TOR },
  { 0x510479B4, 32, NDPI_PROTOCOL_TOR },
  { 0x510479DE, 32, NDPI_PROTOCOL_TOR },
  { 0x510479E0, 32, NDPI_PROTOCOL_TOR },
  { 0x510479F3, 32, NDPI_PROTOCOL_TOR },
  { 0x51047D81, 32, NDPI_PROTOCOL_TOR },
  { 0x51047E79, 32, NDPI_PROTOCOL_TOR },
  { 0x51070777, 32, NDPI_PROTOCOL_TOR },
  { 0x51070865, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A11, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A1D, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A1D, 32, NDPI_PROTOCOL_TOR },
  { 0x51070A44, 32, NDPI_PROTOCOL_TOR },
  { 0x51070AFB, 32, NDPI_PROTOCOL_TOR },
  { 0x51070B46, 32, NDPI_PROTOCOL_TOR },
  { 0x51070BFD, 32, NDPI_PROTOCOL_TOR },
  { 0x51070D54, 32, NDPI_PROTOCOL_TOR },
  { 0x51070D5A, 32, NDPI_PROTOCOL_TOR },
  { 0x51070DF8, 32, NDPI_PROTOCOL_TOR },
  { 0x51070EF6, 32, NDPI_PROTOCOL_TOR },
  { 0x5107103B, 32, NDPI_PROTOCOL_TOR },
  { 0x510A9F12, 32, NDPI_PROTOCOL_TOR },
  { 0x511115F6, 32, NDPI_PROTOCOL_TOR },
  { 0x5114849E, 32, NDPI_PROTOCOL_TOR },
  { 0x51148B91, 32, NDPI_PROTOCOL_TOR },
  { 0x5115F642, 32, NDPI_PROTOCOL_TOR },
  { 0x511932A6, 32, NDPI_PROTOCOL_TOR },
  { 0x511CC585, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9858, 32, NDPI_PROTOCOL_TOR },
  { 0x511E9858, 32, NDPI_PROTOCOL_TOR },
  { 0x511F5A52, 32, NDPI_PROTOCOL_TOR },
  { 0x513842D5, 32, NDPI_PROTOCOL_TOR },
  { 0x5139852A, 32, NDPI_PROTOCOL_TOR },
  { 0x5139D087, 32, NDPI_PROTOCOL_TOR },
  { 0x514080DE, 32, NDPI_PROTOCOL_TOR },
  { 0x5140E6FD, 32, NDPI_PROTOCOL_TOR },
  { 0x51475D6A, 32, NDPI_PROTOCOL_TOR },
  { 0x51533A04, 32, NDPI_PROTOCOL_TOR },
  { 0x51544C43, 32, NDPI_PROTOCOL_TOR },
  { 0x51569E1B, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C3, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C4, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C5, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C6, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C7, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C8, 32, NDPI_PROTOCOL_TOR },
  { 0x515900C9, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CA, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CB, 32, NDPI_PROTOCOL_TOR },
  { 0x515900CC, 32, NDPI_PROTOCOL_TOR },
  { 0x51596058, 32, NDPI_PROTOCOL_TOR },
  { 0x51596059, 32, NDPI_PROTOCOL_TOR },
  { 0x51596535, 32, NDPI_PROTOCOL_TOR },
  { 0x515CACE7, 32, NDPI_PROTOCOL_TOR },
  { 0x515F0522, 32, NDPI_PROTOCOL_TOR },
  { 0x515F3444, 32, NDPI_PROTOCOL_TOR },
  { 0x5160DB54, 32, NDPI_PROTOCOL_TOR },
  { 0x5161B784, 32, NDPI_PROTOCOL_TOR },
  { 0x5163F715, 32, NDPI_PROTOCOL_TOR },
  { 0x51669B3F, 32, NDPI_PROTOCOL_TOR },
  { 0x5166F93D, 32, NDPI_PROTOCOL_TOR },
  { 0x516A0C3C, 32, NDPI_PROTOCOL_TOR },
  { 0x516B907F, 32, NDPI_PROTOCOL_TOR },
  { 0x516D69B6, 32, NDPI_PROTOCOL_TOR },
  { 0x51853556, 32, NDPI_PROTOCOL_TOR },
  { 0x518D6888, 32, NDPI_PROTOCOL_TOR },
  { 0x519840EA, 32, NDPI_PROTOCOL_TOR },
  { 0x519FC5DE, 32, NDPI_PROTOCOL_TOR },
  { 0x51A64037, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98234, 32, NDPI_PROTOCOL_TOR },
  { 0x51A982D6, 32, NDPI_PROTOCOL_TOR },
  { 0x51A988CE, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98D5C, 32, NDPI_PROTOCOL_TOR },
  { 0x51A98D5E, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9957C, 32, NDPI_PROTOCOL_TOR },
  { 0x51A99864, 32, NDPI_PROTOCOL_TOR },
  { 0x51A999A7, 32, NDPI_PROTOCOL_TOR },
  { 0x51A99F52, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9A86A, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9AFA4, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9B42B, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9B92C, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9D13A, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9D20B, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9D72F, 32, NDPI_PROTOCOL_TOR },
  { 0x51A9FFEB, 32, NDPI_PROTOCOL_TOR },
  { 0x51AA95F0, 32, NDPI_PROTOCOL_TOR },
  { 0x51AAD96B, 32, NDPI_PROTOCOL_TOR },
  { 0x51AAFFB8, 32, NDPI_PROTOCOL_TOR },
  { 0x51AC174F, 32, NDPI_PROTOCOL_TOR },
  { 0x51ADF051, 32, NDPI_PROTOCOL_TOR },
  { 0x51AEE712, 32, NDPI_PROTOCOL_TOR },
  { 0x51B0E436, 32, NDPI_PROTOCOL_TOR },
  { 0x51B73F2E, 32, NDPI_PROTOCOL_TOR },
  { 0x51B8EB2B, 32, NDPI_PROTOCOL_TOR },
  { 0x51BAF377, 32, NDPI_PROTOCOL_TOR },
  { 0x51BB1C09, 32, NDPI_PROTOCOL_TOR },
  { 0x51BBD20D, 32, NDPI_PROTOCOL_TOR },
  { 0x51BF7137, 32, NDPI_PROTOCOL_TOR },
  { 0x51C93CED, 32, NDPI_PROTOCOL_TOR },
  { 0x51CB9655, 32, NDPI_PROTOCOL_TOR },
  { 0x51CD17DA, 32, NDPI_PROTOCOL_TOR },
  { 0x51D91056, 32, NDPI_PROTOCOL_TOR },
  { 0x51D974C6, 32, NDPI_PROTOCOL_TOR },
  { 0x51D987C8, 32, NDPI_PROTOCOL_TOR },
  { 0x51D99D5A, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA5B9A, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA6D6A, 32, NDPI_PROTOCOL_TOR },
  { 0x51DA6DC3, 32, NDPI_PROTOCOL_TOR },
  { 0x51DAEBA2, 32, NDPI_PROTOCOL_TOR },
  { 0x51DB33CE, 32, NDPI_PROTOCOL_TOR },
  { 0x51DCA3CA, 32, NDPI_PROTOCOL_TOR },
  { 0x51DD555D, 32, NDPI_PROTOCOL_TOR },
  { 0x51DFD766, 32, NDPI_PROTOCOL_TOR },
  { 0x51E735A5, 32, NDPI_PROTOCOL_TOR },
  { 0x51E75573, 32, NDPI_PROTOCOL_TOR },
  { 0x51E7A4A1, 32, NDPI_PROTOCOL_TOR },
  { 0x51E7E226, 32, NDPI_PROTOCOL_TOR },
  { 0x51E9E3A1, 32, NDPI_PROTOCOL_TOR },
  { 0x51F285B4, 32, NDPI_PROTOCOL_TOR },
  { 0x51F6CAA9, 32, NDPI_PROTOCOL_TOR },
  { 0x51F777FC, 32, NDPI_PROTOCOL_TOR },
  { 0x52018046, 32, NDPI_PROTOCOL_TOR },
  { 0x5206BA74, 32, NDPI_PROTOCOL_TOR },
  { 0x5209EEF6, 32, NDPI_PROTOCOL_TOR },
  { 0x520CAF74, 32, NDPI_PROTOCOL_TOR },
  { 0x520DF0B2, 32, NDPI_PROTOCOL_TOR },
  { 0x5213FC52, 32, NDPI_PROTOCOL_TOR },
  { 0x52145714, 32, NDPI_PROTOCOL_TOR },
  { 0x52173C4E, 32, NDPI_PROTOCOL_TOR },
  { 0x5219BB97, 32, NDPI_PROTOCOL_TOR },
  { 0x521CC556, 32, NDPI_PROTOCOL_TOR },
  { 0x521E7362, 32, NDPI_PROTOCOL_TOR },
  { 0x521F29D7, 32, NDPI_PROTOCOL_TOR },
  { 0x52239D60, 32, NDPI_PROTOCOL_TOR },
  { 0x522BA860, 32, NDPI_PROTOCOL_TOR },
  { 0x522DB96B, 32, NDPI_PROTOCOL_TOR },
  { 0x522FE271, 32, NDPI_PROTOCOL_TOR },
  { 0x52303D0C, 32, NDPI_PROTOCOL_TOR },
  { 0x52343FD9, 32, NDPI_PROTOCOL_TOR },
  { 0x52424777, 32, NDPI_PROTOCOL_TOR },
  { 0x52449E7C, 32, NDPI_PROTOCOL_TOR },
  { 0x52450ECF, 32, NDPI_PROTOCOL_TOR },
  { 0x52453232, 32, NDPI_PROTOCOL_TOR },
  { 0x52462723, 32, NDPI_PROTOCOL_TOR },
  { 0x524805A4, 32, NDPI_PROTOCOL_TOR },
  { 0x52483D51, 32, NDPI_PROTOCOL_TOR },
  { 0x5248765A, 32, NDPI_PROTOCOL_TOR },
  { 0x52493309, 32, NDPI_PROTOCOL_TOR },
  { 0x5249DF9D, 32, NDPI_PROTOCOL_TOR },
  { 0x524A04F3, 32, NDPI_PROTOCOL_TOR },
  { 0x524C4802, 32, NDPI_PROTOCOL_TOR },
  { 0x52502163, 32, NDPI_PROTOCOL_TOR },
  { 0x525088B9, 32, NDPI_PROTOCOL_TOR },
  { 0x52532E63, 32, NDPI_PROTOCOL_TOR },
  { 0x525EF2DA, 32, NDPI_PROTOCOL_TOR },
  { 0x525EFBCB, 32, NDPI_PROTOCOL_TOR },
  { 0x525EFBCC, 32, NDPI_PROTOCOL_TOR },
  { 0x525EFBE3, 32, NDPI_PROTOCOL_TOR },
  { 0x525F42CB, 32, NDPI_PROTOCOL_TOR },
  { 0x525F6B33, 32, NDPI_PROTOCOL_TOR },
  { 0x525FEBF9, 32, NDPI_PROTOCOL_TOR },
  { 0x52624850, 32, NDPI_PROTOCOL_TOR },
  { 0x52668ED2, 32, NDPI_PROTOCOL_TOR },
  { 0x5270985F, 32, NDPI_PROTOCOL_TOR },
  { 0x52736339, 32, NDPI_PROTOCOL_TOR },
  { 0x52747803, 32, NDPI_PROTOCOL_TOR },
  { 0x52761386, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F21E, 32, NDPI_PROTOCOL_TOR },
  { 0x5276F24F, 32, NDPI_PROTOCOL_TOR },
  { 0x527E663F, 32, NDPI_PROTOCOL_TOR },
  { 0x5280FFFC, 32, NDPI_PROTOCOL_TOR },
  { 0x52821A24, 32, NDPI_PROTOCOL_TOR },
  { 0x5282285C, 32, NDPI_PROTOCOL_TOR },
  { 0x52886403, 32, NDPI_PROTOCOL_TOR },
  { 0x528B5EFC, 32, NDPI_PROTOCOL_TOR },
  { 0x528B6271, 32, NDPI_PROTOCOL_TOR },
  { 0x52921BD1, 32, NDPI_PROTOCOL_TOR },
  { 0x529EEB26, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1321E, 32, NDPI_PROTOCOL_TOR },
  { 0x52A13526, 32, NDPI_PROTOCOL_TOR },
  { 0x52A15B0D, 32, NDPI_PROTOCOL_TOR },
  { 0x52A16D47, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1B614, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1D257, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1D4D1, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1DF89, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1EFB1, 32, NDPI_PROTOCOL_TOR },
  { 0x52A1FCA2, 32, NDPI_PROTOCOL_TOR },
  { 0x52A41BE4, 32, NDPI_PROTOCOL_TOR },
  { 0x52A50F97, 32, NDPI_PROTOCOL_TOR },
  { 0x52A58E4F, 32, NDPI_PROTOCOL_TOR },
  { 0x52A5C581, 32, NDPI_PROTOCOL_TOR },
  { 0x52A898B2, 32, NDPI_PROTOCOL_TOR },
  { 0x52A92496, 32, NDPI_PROTOCOL_TOR },
  { 0x52A99B48, 32, NDPI_PROTOCOL_TOR },
  { 0x52B1EEF0, 32, NDPI_PROTOCOL_TOR },
  { 0x52B419BA, 32, NDPI_PROTOCOL_TOR },
  { 0x52B583A0, 32, NDPI_PROTOCOL_TOR },
  { 0x52B6B40F, 32, NDPI_PROTOCOL_TOR },
  { 0x52B70EC3, 32, NDPI_PROTOCOL_TOR },
  { 0x52C0F11E, 32, NDPI_PROTOCOL_TOR },
  { 0x52C409DF, 32, NDPI_PROTOCOL_TOR },
  { 0x52C40E41, 32, NDPI_PROTOCOL_TOR },
  { 0x52C5D42F, 32, NDPI_PROTOCOL_TOR },
  { 0x52C79B59, 32, NDPI_PROTOCOL_TOR },
  { 0x52C7C0A7, 32, NDPI_PROTOCOL_TOR },
  { 0x52CBC340, 32, NDPI_PROTOCOL_TOR },
  { 0x52D300C9, 32, NDPI_PROTOCOL_TOR },
  { 0x52D3138F, 32, NDPI_PROTOCOL_TOR },
  { 0x52D3C9BC, 32, NDPI_PROTOCOL_TOR },
  { 0x52D3DF03, 32, NDPI_PROTOCOL_TOR },
  { 0x52D8FE03, 32, NDPI_PROTOCOL_TOR },
  { 0x52D91190, 32, NDPI_PROTOCOL_TOR },
  { 0x52DB0959, 32, NDPI_PROTOCOL_TOR },
  { 0x52DC5914, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD64C9, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD6500, 32, NDPI_PROTOCOL_TOR },
  { 0x52DD693D, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF08FC, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF0A44, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF0B22, 32, NDPI_PROTOCOL_TOR },
  { 0x52DF179B, 32, NDPI_PROTOCOL_TOR },
  { 0x52E08A09, 32, NDPI_PROTOCOL_TOR },
  { 0x52E33F62, 32, NDPI_PROTOCOL_TOR },
  { 0x52E4FC14, 32, NDPI_PROTOCOL_TOR },
  { 0x52E53CF5, 32, NDPI_PROTOCOL_TOR },
  { 0x52E58A1F, 32, NDPI_PROTOCOL_TOR },
  { 0x52E97597, 32, NDPI_PROTOCOL_TOR },
  { 0x52EA8DC5, 32, NDPI_PROTOCOL_TOR },
  { 0x52EBD32A, 32, NDPI_PROTOCOL_TOR },
  { 0x52EC7EF6, 32, NDPI_PROTOCOL_TOR },
  { 0x52EC89EB, 32, NDPI_PROTOCOL_TOR },
  { 0x52EDD8E9, 32, NDPI_PROTOCOL_TOR },
  { 0x52EED0AD, 32, NDPI_PROTOCOL_TOR },
  { 0x52EF14AE, 32, NDPI_PROTOCOL_TOR },
  { 0x52F1EC57, 32, NDPI_PROTOCOL_TOR },
  { 0x52F298D3, 32, NDPI_PROTOCOL_TOR },
  { 0x52F313CC, 32, NDPI_PROTOCOL_TOR },
  { 0x52F34F09, 32, NDPI_PROTOCOL_TOR },
  { 0x52F4B127, 32, NDPI_PROTOCOL_TOR },
  { 0x52F5C791, 32, NDPI_PROTOCOL_TOR },
  { 0x52F76775, 32, NDPI_PROTOCOL_TOR },
  { 0x52FA311C, 32, NDPI_PROTOCOL_TOR },
  { 0x5306C520, 32, NDPI_PROTOCOL_TOR },
  { 0x5306EE3D, 32, NDPI_PROTOCOL_TOR },
  { 0x531BFBEF, 32, NDPI_PROTOCOL_TOR },
  { 0x53244725, 32, NDPI_PROTOCOL_TOR },
  { 0x532CE6B0, 32, NDPI_PROTOCOL_TOR },
  { 0x5335F24A, 32, NDPI_PROTOCOL_TOR },
  { 0x5338EA93, 32, NDPI_PROTOCOL_TOR },
  { 0x53451C51, 32, NDPI_PROTOCOL_TOR },
  { 0x534C9E3E, 32, NDPI_PROTOCOL_TOR },
  { 0x534E1005, 32, NDPI_PROTOCOL_TOR },
  { 0x535269F0, 32, NDPI_PROTOCOL_TOR },
  { 0x5352C0E6, 32, NDPI_PROTOCOL_TOR },
  { 0x5352F4DB, 32, NDPI_PROTOCOL_TOR },
  { 0x53530B96, 32, NDPI_PROTOCOL_TOR },
  { 0x535352B4, 32, NDPI_PROTOCOL_TOR },
  { 0x53542E39, 32, NDPI_PROTOCOL_TOR },
  { 0x53556653, 32, NDPI_PROTOCOL_TOR },
  { 0x5355D16B, 32, NDPI_PROTOCOL_TOR },
  { 0x5355FC5B, 32, NDPI_PROTOCOL_TOR },
  { 0x5357C9F9, 32, NDPI_PROTOCOL_TOR },
  { 0x53591FF9, 32, NDPI_PROTOCOL_TOR },
  { 0x535D3740, 32, NDPI_PROTOCOL_TOR },
  { 0x53638E4F, 32, NDPI_PROTOCOL_TOR },
  { 0x53650553, 32, NDPI_PROTOCOL_TOR },
  { 0x5365431F, 32, NDPI_PROTOCOL_TOR },
  { 0x537560B2, 32, NDPI_PROTOCOL_TOR },
  { 0x53809409, 32, NDPI_PROTOCOL_TOR },
  { 0x5380C8F4, 32, NDPI_PROTOCOL_TOR },
  { 0x5382722D, 32, NDPI_PROTOCOL_TOR },
  { 0x53857F91, 32, NDPI_PROTOCOL_TOR },
  { 0x5386DFC1, 32, NDPI_PROTOCOL_TOR },
  { 0x5387F0D5, 32, NDPI_PROTOCOL_TOR },
  { 0x538C0BFC, 32, NDPI_PROTOCOL_TOR },
  { 0x538FDBD4, 32, NDPI_PROTOCOL_TOR },
  { 0x5390693A, 32, NDPI_PROTOCOL_TOR },
  { 0x5391EDE0, 32, NDPI_PROTOCOL_TOR },
  { 0x5391F1E7, 32, NDPI_PROTOCOL_TOR },
  { 0x5391F3D7, 32, NDPI_PROTOCOL_TOR },
  { 0x539354E4, 32, NDPI_PROTOCOL_TOR },
  { 0x53957C88, 32, NDPI_PROTOCOL_TOR },
  { 0x53957C88, 32, NDPI_PROTOCOL_TOR },
  { 0x53957C89, 32, NDPI_PROTOCOL_TOR },
  { 0x53957C89, 32, NDPI_PROTOCOL_TOR },
  { 0x53957E1D, 32, NDPI_PROTOCOL_TOR },
  { 0x53957F8C, 32, NDPI_PROTOCOL_TOR },
  { 0x5395F9A5, 32, NDPI_PROTOCOL_TOR },
  { 0x5396023D, 32, NDPI_PROTOCOL_TOR },
  { 0x53961097, 32, NDPI_PROTOCOL_TOR },
  { 0x539610F4, 32, NDPI_PROTOCOL_TOR },
  { 0x53961184, 32, NDPI_PROTOCOL_TOR },
  { 0x5396527A, 32, NDPI_PROTOCOL_TOR },
  { 0x539C0058, 32, NDPI_PROTOCOL_TOR },
  { 0x53A05F63, 32, NDPI_PROTOCOL_TOR },
  { 0x53A19832, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2026F, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2BC64, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2C060, 32, NDPI_PROTOCOL_TOR },
  { 0x53A2CD44, 32, NDPI_PROTOCOL_TOR },
  { 0x53A34DC3, 32, NDPI_PROTOCOL_TOR },
  { 0x53A3C9A8, 32, NDPI_PROTOCOL_TOR },
  { 0x53A59347, 32, NDPI_PROTOCOL_TOR },
  { 0x53A6EA5C, 32, NDPI_PROTOCOL_TOR },
  { 0x53A6EA6C, 32, NDPI_PROTOCOL_TOR },
  { 0x53A7B923, 32, NDPI_PROTOCOL_TOR },
  { 0x53A7B964, 32, NDPI_PROTOCOL_TOR },
  { 0x53A7E46B, 32, NDPI_PROTOCOL_TOR },
  { 0x53A8C8CC, 32, NDPI_PROTOCOL_TOR },
  { 0x53A91607, 32, NDPI_PROTOCOL_TOR },
  { 0x53A92DE7, 32, NDPI_PROTOCOL_TOR },
  { 0x53AB9437, 32, NDPI_PROTOCOL_TOR },
  { 0x53ABBE6A, 32, NDPI_PROTOCOL_TOR },
  { 0x53AEFA7D, 32, NDPI_PROTOCOL_TOR },
  { 0x53D19271, 32, NDPI_PROTOCOL_TOR },
  { 0x53D454DF, 32, NDPI_PROTOCOL_TOR },
  { 0x53D460B7, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46270, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46344, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4637B, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46612, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4687C, 32, NDPI_PROTOCOL_TOR },
  { 0x53D46891, 32, NDPI_PROTOCOL_TOR },
  { 0x53D47185, 32, NDPI_PROTOCOL_TOR },
  { 0x53D47ED3, 32, NDPI_PROTOCOL_TOR },
  { 0x53D4A8BA, 32, NDPI_PROTOCOL_TOR },
  { 0x53D8F8E0, 32, NDPI_PROTOCOL_TOR },
  { 0x53DE8DEB, 32, NDPI_PROTOCOL_TOR },
  { 0x53E2EEA8, 32, NDPI_PROTOCOL_TOR },
  { 0x53E334A8, 32, NDPI_PROTOCOL_TOR },
  { 0x53E45D4C, 32, NDPI_PROTOCOL_TOR },
  { 0x53E71225, 32, NDPI_PROTOCOL_TOR },
  { 0x53E941D6, 32, NDPI_PROTOCOL_TOR },
  { 0x53E98714, 32, NDPI_PROTOCOL_TOR },
  { 0x53E9A8E7, 32, NDPI_PROTOCOL_TOR },
  { 0x53ECD04E, 32, NDPI_PROTOCOL_TOR },
  { 0x53ED1577, 32, NDPI_PROTOCOL_TOR },
  { 0x53F03D90, 32, NDPI_PROTOCOL_TOR },
  { 0x53F042A6, 32, NDPI_PROTOCOL_TOR },
  { 0x53F077B0, 32, NDPI_PROTOCOL_TOR },
  { 0x53F65317, 32, NDPI_PROTOCOL_TOR },
  { 0x53F6A4BB, 32, NDPI_PROTOCOL_TOR },
  { 0x53F6D985, 32, NDPI_PROTOCOL_TOR },
  { 0x53F74E5A, 32, NDPI_PROTOCOL_TOR },
  { 0x53F80E85, 32, NDPI_PROTOCOL_TOR },
  { 0x53F88441, 32, NDPI_PROTOCOL_TOR },
  { 0x53F8A214, 32, NDPI_PROTOCOL_TOR },
  { 0x53F8B2D6, 32, NDPI_PROTOCOL_TOR },
  { 0x53F946BE, 32, NDPI_PROTOCOL_TOR },
  { 0x53FA5511, 32, NDPI_PROTOCOL_TOR },
  { 0x53FB40E6, 32, NDPI_PROTOCOL_TOR },
  { 0x53FB515D, 32, NDPI_PROTOCOL_TOR },
  { 0x53FB5AA6, 32, NDPI_PROTOCOL_TOR },
  { 0x53FB864C, 32, NDPI_PROTOCOL_TOR },
  { 0x53FD36CE, 32, NDPI_PROTOCOL_TOR },
  { 0x53FDBBDA, 32, NDPI_PROTOCOL_TOR },
  { 0x53FE5430, 32, NDPI_PROTOCOL_TOR },
  { 0x53FF6645, 32, NDPI_PROTOCOL_TOR },
  { 0x53FFCBAC, 32, NDPI_PROTOCOL_TOR },
  { 0x540A6F0A, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B234, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B3E5, 32, NDPI_PROTOCOL_TOR },
  { 0x5413B450, 32, NDPI_PROTOCOL_TOR },
  { 0x54162AF6, 32, NDPI_PROTOCOL_TOR },
  { 0x54191CBA, 32, NDPI_PROTOCOL_TOR },
  { 0x541B5EF7, 32, NDPI_PROTOCOL_TOR },
  { 0x541EBB28, 32, NDPI_PROTOCOL_TOR },
  { 0x541FC855, 32, NDPI_PROTOCOL_TOR },
  { 0x54284D55, 32, NDPI_PROTOCOL_TOR },
  { 0x542862BB, 32, NDPI_PROTOCOL_TOR },
  { 0x54287046, 32, NDPI_PROTOCOL_TOR },
  { 0x542AA5A2, 32, NDPI_PROTOCOL_TOR },
  { 0x542D4C0A, 32, NDPI_PROTOCOL_TOR },
  { 0x542D4C0B, 32, NDPI_PROTOCOL_TOR },
  { 0x542D4C0C, 32, NDPI_PROTOCOL_TOR },
  { 0x542D4C0D, 32, NDPI_PROTOCOL_TOR },
  { 0x542E3EBA, 32, NDPI_PROTOCOL_TOR },
  { 0x54303AC3, 32, NDPI_PROTOCOL_TOR },
  { 0x54321453, 32, NDPI_PROTOCOL_TOR },
  { 0x54380652, 32, NDPI_PROTOCOL_TOR },
  { 0x54382C54, 32, NDPI_PROTOCOL_TOR },
  { 0x5439BD00, 32, NDPI_PROTOCOL_TOR },
  { 0x543BE658, 32, NDPI_PROTOCOL_TOR },
  { 0x543C046D, 32, NDPI_PROTOCOL_TOR },
  { 0x544815A3, 32, NDPI_PROTOCOL_TOR },
  { 0x5448B905, 32, NDPI_PROTOCOL_TOR },
  { 0x5448D5DD, 32, NDPI_PROTOCOL_TOR },
  { 0x5448DFC7, 32, NDPI_PROTOCOL_TOR },
  { 0x544980C3, 32, NDPI_PROTOCOL_TOR },
  { 0x544A0BDE, 32, NDPI_PROTOCOL_TOR },
  { 0x544A7D55, 32, NDPI_PROTOCOL_TOR },
  { 0x544AACE8, 32, NDPI_PROTOCOL_TOR },
  { 0x544B0C49, 32, NDPI_PROTOCOL_TOR },
  { 0x5454D02F, 32, NDPI_PROTOCOL_TOR },
  { 0x545C18D5, 32, NDPI_PROTOCOL_TOR },
  { 0x545C18D6, 32, NDPI_PROTOCOL_TOR },
  { 0x545C6C78, 32, NDPI_PROTOCOL_TOR },
  { 0x54674A57, 32, NDPI_PROTOCOL_TOR },
  { 0x5468A93B, 32, NDPI_PROTOCOL_TOR },
  { 0x5469DCFF, 32, NDPI_PROTOCOL_TOR },
  { 0x546A4A9E, 32, NDPI_PROTOCOL_TOR },
  { 0x546CCDB5, 32, NDPI_PROTOCOL_TOR },
  { 0x5470EE3A, 32, NDPI_PROTOCOL_TOR },
  { 0x5470EE3A, 32, NDPI_PROTOCOL_TOR },
  { 0x54711102, 32, NDPI_PROTOCOL_TOR },
  { 0x5471F5B1, 32, NDPI_PROTOCOL_TOR },
  { 0x5472F1DF, 32, NDPI_PROTOCOL_TOR },
  { 0x54732E95, 32, NDPI_PROTOCOL_TOR },
  { 0x5475164A, 32, NDPI_PROTOCOL_TOR },
  { 0x54767531, 32, NDPI_PROTOCOL_TOR },
  { 0x547688FC, 32, NDPI_PROTOCOL_TOR },
  { 0x54779B30, 32, NDPI_PROTOCOL_TOR },
  { 0x5477EDED, 32, NDPI_PROTOCOL_TOR },
  { 0x547BB3B6, 32, NDPI_PROTOCOL_TOR },
  { 0x547D73EA, 32, NDPI_PROTOCOL_TOR },
  { 0x5481A36E, 32, NDPI_PROTOCOL_TOR },
  { 0x5481DC92, 32, NDPI_PROTOCOL_TOR },
  { 0x548524F3, 32, NDPI_PROTOCOL_TOR },
  { 0x548A010A, 32, NDPI_PROTOCOL_TOR },
  { 0x5493E1C8, 32, NDPI_PROTOCOL_TOR },
  { 0x54947094, 32, NDPI_PROTOCOL_TOR },
  { 0x5499DCA5, 32, NDPI_PROTOCOL_TOR },
  { 0x549CFEEC, 32, NDPI_PROTOCOL_TOR },
  { 0x549FE146, 32, NDPI_PROTOCOL_TOR },
  { 0x549FEA53, 32, NDPI_PROTOCOL_TOR },
  { 0x549FEA53, 32, NDPI_PROTOCOL_TOR },
  { 0x54A202DA, 32, NDPI_PROTOCOL_TOR },
  { 0x54AD608B, 32, NDPI_PROTOCOL_TOR },
  { 0x54AEB5BD, 32, NDPI_PROTOCOL_TOR },
  { 0x54AFCF54, 32, NDPI_PROTOCOL_TOR },
  { 0x54AFF159, 32, NDPI_PROTOCOL_TOR },
  { 0x54B35824, 32, NDPI_PROTOCOL_TOR },
  { 0x54B46D3C, 32, NDPI_PROTOCOL_TOR },
  { 0x54B67B82, 32, NDPI_PROTOCOL_TOR },
  { 0x54B75D03, 32, NDPI_PROTOCOL_TOR },
  { 0x54B77113, 32, NDPI_PROTOCOL_TOR },
  { 0x54B771CE, 32, NDPI_PROTOCOL_TOR },
  { 0x54B7F756, 32, NDPI_PROTOCOL_TOR },
  { 0x54BA9896, 32, NDPI_PROTOCOL_TOR },
  { 0x54BAD4B7, 32, NDPI_PROTOCOL_TOR },
  { 0x54C14BF3, 32, NDPI_PROTOCOL_TOR },
  { 0x54C80821, 32, NDPI_PROTOCOL_TOR },
  { 0x54C808AF, 32, NDPI_PROTOCOL_TOR },
  { 0x54C808CF, 32, NDPI_PROTOCOL_TOR },
  { 0x54C80AD1, 32, NDPI_PROTOCOL_TOR },
  { 0x54C849EE, 32, NDPI_PROTOCOL_TOR },
  { 0x54C84DF3, 32, NDPI_PROTOCOL_TOR },
  { 0x54C852A3, 32, NDPI_PROTOCOL_TOR },
  { 0x54C853D6, 32, NDPI_PROTOCOL_TOR },
  { 0x54C90487, 32, NDPI_PROTOCOL_TOR },
  { 0x54C923CE, 32, NDPI_PROTOCOL_TOR },
  { 0x54CA3612, 32, NDPI_PROTOCOL_TOR },
  { 0x54D08C30, 32, NDPI_PROTOCOL_TOR },
  { 0x54D10F3F, 32, NDPI_PROTOCOL_TOR },
  { 0x54D14924, 32, NDPI_PROTOCOL_TOR },
  { 0x54D358E2, 32, NDPI_PROTOCOL_TOR },
  { 0x54D7D347, 32, NDPI_PROTOCOL_TOR },
  { 0x54DBAAE7, 32, NDPI_PROTOCOL_TOR },
  { 0x54DBC1BA, 32, NDPI_PROTOCOL_TOR },
  { 0x54E26D6D, 32, NDPI_PROTOCOL_TOR },
  { 0x54EA9B51, 32, NDPI_PROTOCOL_TOR },
  { 0x54EA9B51, 32, NDPI_PROTOCOL_TOR },
  { 0x54EA9B52, 32, NDPI_PROTOCOL_TOR },
  { 0x54EA9B52, 32, NDPI_PROTOCOL_TOR },
  { 0x54F270BE, 32, NDPI_PROTOCOL_TOR },
  { 0x54F41F34, 32, NDPI_PROTOCOL_TOR },
  { 0x54F520C3, 32, NDPI_PROTOCOL_TOR },
  { 0x54F52108, 32, NDPI_PROTOCOL_TOR },
  { 0x54F8529C, 32, NDPI_PROTOCOL_TOR },
  { 0x54F86B2C, 32, NDPI_PROTOCOL_TOR },
  { 0x54F8805F, 32, NDPI_PROTOCOL_TOR },
  { 0x54F9C0D5, 32, NDPI_PROTOCOL_TOR },
  { 0x54FA6A0D, 32, NDPI_PROTOCOL_TOR },
  { 0x54FB736F, 32, NDPI_PROTOCOL_TOR },
  { 0x54FB7CF4, 32, NDPI_PROTOCOL_TOR },
  { 0x550180C4, 32, NDPI_PROTOCOL_TOR },
  { 0x5502F728, 32, NDPI_PROTOCOL_TOR },
  { 0x55037656, 32, NDPI_PROTOCOL_TOR },
  { 0x5504E453, 32, NDPI_PROTOCOL_TOR },
  { 0x55082B53, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC409, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC40C, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC6EC, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC8E6, 32, NDPI_PROTOCOL_TOR },
  { 0x550AC92F, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACA57, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACB47, 32, NDPI_PROTOCOL_TOR },
  { 0x550ACBC5, 32, NDPI_PROTOCOL_TOR },
  { 0x550AD2C7, 32, NDPI_PROTOCOL_TOR },
  { 0x550AD335, 32, NDPI_PROTOCOL_TOR },
  { 0x550ADBA7, 32, NDPI_PROTOCOL_TOR },
  { 0x550AED68, 32, NDPI_PROTOCOL_TOR },
  { 0x550AF0FA, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF020, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF021, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF022, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF023, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF0BC, 32, NDPI_PROTOCOL_TOR },
  { 0x550EF0BC, 32, NDPI_PROTOCOL_TOR },
  { 0x5511185F, 32, NDPI_PROTOCOL_TOR },
  { 0x551184F5, 32, NDPI_PROTOCOL_TOR },
  { 0x551184F6, 32, NDPI_PROTOCOL_TOR },
  { 0x55118DAE, 32, NDPI_PROTOCOL_TOR },
  { 0x551194E6, 32, NDPI_PROTOCOL_TOR },
  { 0x5511A451, 32, NDPI_PROTOCOL_TOR },
  { 0x5511B149, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE4D, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE4D, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE4F, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE4F, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE52, 32, NDPI_PROTOCOL_TOR },
  { 0x5511BE53, 32, NDPI_PROTOCOL_TOR },
  { 0x5511F893, 32, NDPI_PROTOCOL_TOR },
  { 0x551590E2, 32, NDPI_PROTOCOL_TOR },
  { 0x5516679A, 32, NDPI_PROTOCOL_TOR },
  { 0x5517911A, 32, NDPI_PROTOCOL_TOR },
  { 0x5517F393, 32, NDPI_PROTOCOL_TOR },
  { 0x5518D772, 32, NDPI_PROTOCOL_TOR },
  { 0x5518D773, 32, NDPI_PROTOCOL_TOR },
  { 0x5518D774, 32, NDPI_PROTOCOL_TOR },
  { 0x5518D775, 32, NDPI_PROTOCOL_TOR },
  { 0x5519090B, 32, NDPI_PROTOCOL_TOR },
  { 0x55192D93, 32, NDPI_PROTOCOL_TOR },
  { 0x55192F35, 32, NDPI_PROTOCOL_TOR },
  { 0x55192FB4, 32, NDPI_PROTOCOL_TOR },
  { 0x5519305B, 32, NDPI_PROTOCOL_TOR },
  { 0x55195F5B, 32, NDPI_PROTOCOL_TOR },
  { 0x55195F95, 32, NDPI_PROTOCOL_TOR },
  { 0x55196777, 32, NDPI_PROTOCOL_TOR },
  { 0x5519829A, 32, NDPI_PROTOCOL_TOR },
  { 0x55198A5D, 32, NDPI_PROTOCOL_TOR },
  { 0x551995BF, 32, NDPI_PROTOCOL_TOR },
  { 0x55199678, 32, NDPI_PROTOCOL_TOR },
  { 0x5519994F, 32, NDPI_PROTOCOL_TOR },
  { 0x5519C155, 32, NDPI_PROTOCOL_TOR },
  { 0x5519C444, 32, NDPI_PROTOCOL_TOR },
  { 0x5519CB2A, 32, NDPI_PROTOCOL_TOR },
  { 0x5519D0C9, 32, NDPI_PROTOCOL_TOR },
  { 0x5519D256, 32, NDPI_PROTOCOL_TOR },
  { 0x551EA9E1, 32, NDPI_PROTOCOL_TOR },
  { 0x551EF8C1, 32, NDPI_PROTOCOL_TOR },
  { 0x551FBA5D, 32, NDPI_PROTOCOL_TOR },
  { 0x551FBAD3, 32, NDPI_PROTOCOL_TOR },
  { 0x551FBAFD, 32, NDPI_PROTOCOL_TOR },
  { 0x55455D2E, 32, NDPI_PROTOCOL_TOR },
  { 0x55496286, 32, NDPI_PROTOCOL_TOR },
  { 0x55510502, 32, NDPI_PROTOCOL_TOR },
  { 0x55513A3B, 32, NDPI_PROTOCOL_TOR },
  { 0x55580BF3, 32, NDPI_PROTOCOL_TOR },
  { 0x55581C88, 32, NDPI_PROTOCOL_TOR },
  { 0x555D1259, 32, NDPI_PROTOCOL_TOR },
  { 0x555DCBB6, 32, NDPI_PROTOCOL_TOR },
  { 0x555DDACC, 32, NDPI_PROTOCOL_TOR },
  { 0x55719152, 32, NDPI_PROTOCOL_TOR },
  { 0x55728560, 32, NDPI_PROTOCOL_TOR },
  { 0x55775204, 32, NDPI_PROTOCOL_TOR },
  { 0x5577532C, 32, NDPI_PROTOCOL_TOR },
  { 0x5577538D, 32, NDPI_PROTOCOL_TOR },
  { 0x557FC146, 32, NDPI_PROTOCOL_TOR },
  { 0x558DC913, 32, NDPI_PROTOCOL_TOR },
  { 0x558F5F32, 32, NDPI_PROTOCOL_TOR },
  { 0x5596D244, 32, NDPI_PROTOCOL_TOR },
  { 0x559F71E4, 32, NDPI_PROTOCOL_TOR },
  { 0x559FD180, 32, NDPI_PROTOCOL_TOR },
  { 0x559FD19A, 32, NDPI_PROTOCOL_TOR },
  { 0x559FD2EF, 32, NDPI_PROTOCOL_TOR },
  { 0x559FD337, 32, NDPI_PROTOCOL_TOR },
  { 0x55A452E7, 32, NDPI_PROTOCOL_TOR },
  { 0x55A8FF49, 32, NDPI_PROTOCOL_TOR },
  { 0x55A8FFCA, 32, NDPI_PROTOCOL_TOR },
  { 0x55AB1623, 32, NDPI_PROTOCOL_TOR },
  { 0x55B0BCF4, 32, NDPI_PROTOCOL_TOR },
  { 0x55B0E108, 32, NDPI_PROTOCOL_TOR },
  { 0x55B1669A, 32, NDPI_PROTOCOL_TOR },
  { 0x55B2425E, 32, NDPI_PROTOCOL_TOR },
  { 0x55B2CDC4, 32, NDPI_PROTOCOL_TOR },
  { 0x55B2F435, 32, NDPI_PROTOCOL_TOR },
  { 0x55B35A3B, 32, NDPI_PROTOCOL_TOR },
  { 0x55B42652, 32, NDPI_PROTOCOL_TOR },
  { 0x55B4F715, 32, NDPI_PROTOCOL_TOR },
  { 0x55C35D4D, 32, NDPI_PROTOCOL_TOR },
  { 0x55C51E77, 32, NDPI_PROTOCOL_TOR },
  { 0x55C6B4EF, 32, NDPI_PROTOCOL_TOR },
  { 0x55CAE1D1, 32, NDPI_PROTOCOL_TOR },
  { 0x55CC0B35, 32, NDPI_PROTOCOL_TOR },
  { 0x55D2AB44, 32, NDPI_PROTOCOL_TOR },
  { 0x55D408E8, 32, NDPI_PROTOCOL_TOR },
  { 0x55D414C0, 32, NDPI_PROTOCOL_TOR },
  { 0x55D42B5E, 32, NDPI_PROTOCOL_TOR },
  { 0x55D45466, 32, NDPI_PROTOCOL_TOR },
  { 0x55D610D4, 32, NDPI_PROTOCOL_TOR },
  { 0x55D617BC, 32, NDPI_PROTOCOL_TOR },
  { 0x55D61DD5, 32, NDPI_PROTOCOL_TOR },
  { 0x55D62891, 32, NDPI_PROTOCOL_TOR },
  { 0x55D62CAC, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6349C, 32, NDPI_PROTOCOL_TOR },
  { 0x55D636FE, 32, NDPI_PROTOCOL_TOR },
  { 0x55D63E30, 32, NDPI_PROTOCOL_TOR },
  { 0x55D64469, 32, NDPI_PROTOCOL_TOR },
  { 0x55D646BC, 32, NDPI_PROTOCOL_TOR },
  { 0x55D64748, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6492C, 32, NDPI_PROTOCOL_TOR },
  { 0x55D650F9, 32, NDPI_PROTOCOL_TOR },
  { 0x55D665E9, 32, NDPI_PROTOCOL_TOR },
  { 0x55D66C81, 32, NDPI_PROTOCOL_TOR },
  { 0x55D673D6, 32, NDPI_PROTOCOL_TOR },
  { 0x55D67EF9, 32, NDPI_PROTOCOL_TOR },
  { 0x55D680C7, 32, NDPI_PROTOCOL_TOR },
  { 0x55D68211, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6909F, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69242, 32, NDPI_PROTOCOL_TOR },
  { 0x55D692DD, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69748, 32, NDPI_PROTOCOL_TOR },
  { 0x55D69C1C, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6C1EA, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6C3C6, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6CEDB, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6D38C, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6DC01, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6E066, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6E20F, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6ECCF, 32, NDPI_PROTOCOL_TOR },
  { 0x55D6F0DF, 32, NDPI_PROTOCOL_TOR },
  { 0x55D82298, 32, NDPI_PROTOCOL_TOR },
  { 0x55D84A33, 32, NDPI_PROTOCOL_TOR },
  { 0x55D85282, 32, NDPI_PROTOCOL_TOR },
  { 0x55D8EF08, 32, NDPI_PROTOCOL_TOR },
  { 0x55D96A51, 32, NDPI_PROTOCOL_TOR },
  { 0x55DA8B87, 32, NDPI_PROTOCOL_TOR },
  { 0x55DE7764, 32, NDPI_PROTOCOL_TOR },
  { 0x55E00DE3, 32, NDPI_PROTOCOL_TOR },
  { 0x55E23FF3, 32, NDPI_PROTOCOL_TOR },
  { 0x55E23FF3, 32, NDPI_PROTOCOL_TOR },
  { 0x55E272EC, 32, NDPI_PROTOCOL_TOR },
  { 0x55E3B85B, 32, NDPI_PROTOCOL_TOR },
  { 0x55E4C664, 32, NDPI_PROTOCOL_TOR },
  { 0x55E52799, 32, NDPI_PROTOCOL_TOR },
  { 0x55E56B0F, 32, NDPI_PROTOCOL_TOR },
  { 0x55E5DB15, 32, NDPI_PROTOCOL_TOR },
  { 0x55E6FB1B, 32, NDPI_PROTOCOL_TOR },
  { 0x55E9156D, 32, NDPI_PROTOCOL_TOR },
  { 0x55E92788, 32, NDPI_PROTOCOL_TOR },
  { 0x55E9EC02, 32, NDPI_PROTOCOL_TOR },
  { 0x55E9F05E, 32, NDPI_PROTOCOL_TOR },
  { 0x55EA0282, 32, NDPI_PROTOCOL_TOR },
  { 0x55F262DD, 32, NDPI_PROTOCOL_TOR },
  { 0x55F2F9AE, 32, NDPI_PROTOCOL_TOR },
  { 0x55F3CFC9, 32, NDPI_PROTOCOL_TOR },
  { 0x55F4D455, 32, NDPI_PROTOCOL_TOR },
  { 0x55F5023D, 32, NDPI_PROTOCOL_TOR },
  { 0x55FB5633, 32, NDPI_PROTOCOL_TOR },
  { 0x5600D6BA, 32, NDPI_PROTOCOL_TOR },
  { 0x56017832, 32, NDPI_PROTOCOL_TOR },
  { 0x5608E378, 32, NDPI_PROTOCOL_TOR },
  { 0x560DA7C3, 32, NDPI_PROTOCOL_TOR },
  { 0x56137EFA, 32, NDPI_PROTOCOL_TOR },
  { 0x5616F4E3, 32, NDPI_PROTOCOL_TOR },
  { 0x56187315, 32, NDPI_PROTOCOL_TOR },
  { 0x561BF297, 32, NDPI_PROTOCOL_TOR },
  { 0x562C1E07, 32, NDPI_PROTOCOL_TOR },
  { 0x5634AE44, 32, NDPI_PROTOCOL_TOR },
  { 0x5634AE44, 32, NDPI_PROTOCOL_TOR },
  { 0x56387108, 32, NDPI_PROTOCOL_TOR },
  { 0x5638E449, 32, NDPI_PROTOCOL_TOR },
  { 0x563A3DBE, 32, NDPI_PROTOCOL_TOR },
  { 0x563B1526, 32, NDPI_PROTOCOL_TOR },
  { 0x563B15A3, 32, NDPI_PROTOCOL_TOR },
  { 0x563B15FB, 32, NDPI_PROTOCOL_TOR },
  { 0x563B4616, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7752, 32, NDPI_PROTOCOL_TOR },
  { 0x563B7753, 32, NDPI_PROTOCOL_TOR },
  { 0x563E75AB, 32, NDPI_PROTOCOL_TOR },
  { 0x5649B3AA, 32, NDPI_PROTOCOL_TOR },
  { 0x566187BA, 32, NDPI_PROTOCOL_TOR },
  { 0x56660386, 32, NDPI_PROTOCOL_TOR },
  { 0x56679157, 32, NDPI_PROTOCOL_TOR },
  { 0x5667972F, 32, NDPI_PROTOCOL_TOR },
  { 0x5667A17E, 32, NDPI_PROTOCOL_TOR },
  { 0x566A2A77, 32, NDPI_PROTOCOL_TOR },
  { 0x56791818, 32, NDPI_PROTOCOL_TOR },
  { 0x567B34BC, 32, NDPI_PROTOCOL_TOR },
  { 0x567EB91B, 32, NDPI_PROTOCOL_TOR },
  { 0x567FBE92, 32, NDPI_PROTOCOL_TOR },
  { 0x5681D4E1, 32, NDPI_PROTOCOL_TOR },
  { 0x5681D4E1, 32, NDPI_PROTOCOL_TOR },
  { 0x5697D436, 32, NDPI_PROTOCOL_TOR },
  { 0x569A0B2D, 32, NDPI_PROTOCOL_TOR },
  { 0x569BD0C5, 32, NDPI_PROTOCOL_TOR },
  { 0x569F0B08, 32, NDPI_PROTOCOL_TOR },
  { 0x56A1DCE0, 32, NDPI_PROTOCOL_TOR },
  { 0x56A2550C, 32, NDPI_PROTOCOL_TOR },
  { 0x56A27142, 32, NDPI_PROTOCOL_TOR },
  { 0x56AE29E4, 32, NDPI_PROTOCOL_TOR },
  { 0x56AF9CFB, 32, NDPI_PROTOCOL_TOR },
  { 0x56B00DD2, 32, NDPI_PROTOCOL_TOR },
  { 0x56B03E45, 32, NDPI_PROTOCOL_TOR },
  { 0x56B1719D, 32, NDPI_PROTOCOL_TOR },
  { 0x56B3ED06, 32, NDPI_PROTOCOL_TOR },
  { 0x56B43BD3, 32, NDPI_PROTOCOL_TOR },
  { 0x56B7FF53, 32, NDPI_PROTOCOL_TOR },
  { 0x56BABA50, 32, NDPI_PROTOCOL_TOR },
  { 0x56BDAAC7, 32, NDPI_PROTOCOL_TOR },
  { 0x56CDFD45, 32, NDPI_PROTOCOL_TOR },
  { 0x56D0805A, 32, NDPI_PROTOCOL_TOR },
  { 0x56D39F39, 32, NDPI_PROTOCOL_TOR },
  { 0x56D9692B, 32, NDPI_PROTOCOL_TOR },
  { 0x56EB2C1D, 32, NDPI_PROTOCOL_TOR },
  { 0x57214983, 32, NDPI_PROTOCOL_TOR },
  { 0x5740620E, 32, NDPI_PROTOCOL_TOR },
  { 0x5743BBE2, 32, NDPI_PROTOCOL_TOR },
  { 0x5743F359, 32, NDPI_PROTOCOL_TOR },
  { 0x574823EF, 32, NDPI_PROTOCOL_TOR },
  { 0x574849E7, 32, NDPI_PROTOCOL_TOR },
  { 0x574855D9, 32, NDPI_PROTOCOL_TOR },
  { 0x574855D9, 32, NDPI_PROTOCOL_TOR },
  { 0x5748EFBB, 32, NDPI_PROTOCOL_TOR },
  { 0x574933FE, 32, NDPI_PROTOCOL_TOR },
  { 0x574A4C6A, 32, NDPI_PROTOCOL_TOR },
  { 0x574E6298, 32, NDPI_PROTOCOL_TOR },
  { 0x574F4F5E, 32, NDPI_PROTOCOL_TOR },
  { 0x574FA117, 32, NDPI_PROTOCOL_TOR },
  { 0x574FBE6A, 32, NDPI_PROTOCOL_TOR },
  { 0x574FE6A9, 32, NDPI_PROTOCOL_TOR },
  { 0x57518B76, 32, NDPI_PROTOCOL_TOR },
  { 0x5751943D, 32, NDPI_PROTOCOL_TOR },
  { 0x575C404F, 32, NDPI_PROTOCOL_TOR },
  { 0x575C7E3B, 32, NDPI_PROTOCOL_TOR },
  { 0x57628430, 32, NDPI_PROTOCOL_TOR },
  { 0x57629FE7, 32, NDPI_PROTOCOL_TOR },
  { 0x5762B23D, 32, NDPI_PROTOCOL_TOR },
  { 0x5762B905, 32, NDPI_PROTOCOL_TOR },
  { 0x5762CE46, 32, NDPI_PROTOCOL_TOR },
  { 0x5762FADE, 32, NDPI_PROTOCOL_TOR },
  { 0x5762FAF4, 32, NDPI_PROTOCOL_TOR },
  { 0x57660FD8, 32, NDPI_PROTOCOL_TOR },
  { 0x576837CB, 32, NDPI_PROTOCOL_TOR },
  { 0x57686A90, 32, NDPI_PROTOCOL_TOR },
  { 0x57688562, 32, NDPI_PROTOCOL_TOR },
  { 0x576A0364, 32, NDPI_PROTOCOL_TOR },
  { 0x576A0E9F, 32, NDPI_PROTOCOL_TOR },
  { 0x576A10D6, 32, NDPI_PROTOCOL_TOR },
  { 0x576A1108, 32, NDPI_PROTOCOL_TOR },
  { 0x576A120D, 32, NDPI_PROTOCOL_TOR },
  { 0x576A14F6, 32, NDPI_PROTOCOL_TOR },
  { 0x576A154D, 32, NDPI_PROTOCOL_TOR },
  { 0x576A20BA, 32, NDPI_PROTOCOL_TOR },
  { 0x576A2567, 32, NDPI_PROTOCOL_TOR },
  { 0x576A2FBE, 32, NDPI_PROTOCOL_TOR },
  { 0x576A3528, 32, NDPI_PROTOCOL_TOR },
  { 0x576A3786, 32, NDPI_PROTOCOL_TOR },
  { 0x576A8C18, 32, NDPI_PROTOCOL_TOR },
  { 0x576A945A, 32, NDPI_PROTOCOL_TOR },
  { 0x576ABDEE, 32, NDPI_PROTOCOL_TOR },
  { 0x576ABF5F, 32, NDPI_PROTOCOL_TOR },
  { 0x576ABF9D, 32, NDPI_PROTOCOL_TOR },
  { 0x576AD0EC, 32, NDPI_PROTOCOL_TOR },
  { 0x576AF976, 32, NDPI_PROTOCOL_TOR },
  { 0x576AF9F8, 32, NDPI_PROTOCOL_TOR },
  { 0x57706F89, 32, NDPI_PROTOCOL_TOR },
  { 0x5772AA67, 32, NDPI_PROTOCOL_TOR },
  { 0x5775DB84, 32, NDPI_PROTOCOL_TOR },
  { 0x5775DB8C, 32, NDPI_PROTOCOL_TOR },
  { 0x57765454, 32, NDPI_PROTOCOL_TOR },
  { 0x577654B5, 32, NDPI_PROTOCOL_TOR },
  { 0x577654F6, 32, NDPI_PROTOCOL_TOR },
  { 0x577658DB, 32, NDPI_PROTOCOL_TOR },
  { 0x57765B8C, 32, NDPI_PROTOCOL_TOR },
  { 0x57765D7A, 32, NDPI_PROTOCOL_TOR },
  { 0x57765EE7, 32, NDPI_PROTOCOL_TOR },
  { 0x577670AD, 32, NDPI_PROTOCOL_TOR },
  { 0x57767286, 32, NDPI_PROTOCOL_TOR },
  { 0x577674E3, 32, NDPI_PROTOCOL_TOR },
  { 0x5776760C, 32, NDPI_PROTOCOL_TOR },
  { 0x5777BA76, 32, NDPI_PROTOCOL_TOR },
  { 0x5779348B, 32, NDPI_PROTOCOL_TOR },
  { 0x57793492, 32, NDPI_PROTOCOL_TOR },
  { 0x57793497, 32, NDPI_PROTOCOL_TOR },
  { 0x577FA5F4, 32, NDPI_PROTOCOL_TOR },
  { 0x578B21D9, 32, NDPI_PROTOCOL_TOR },
  { 0x5791BA0E, 32, NDPI_PROTOCOL_TOR },
  { 0x5792CEEC, 32, NDPI_PROTOCOL_TOR },
  { 0x57954623, 32, NDPI_PROTOCOL_TOR },
  { 0x57969A86, 32, NDPI_PROTOCOL_TOR },
  { 0x5796CE37, 32, NDPI_PROTOCOL_TOR },
  { 0x579737CB, 32, NDPI_PROTOCOL_TOR },
  { 0x5798EDA7, 32, NDPI_PROTOCOL_TOR },
  { 0x579B0B3B, 32, NDPI_PROTOCOL_TOR },
  { 0x579E1829, 32, NDPI_PROTOCOL_TOR },
  { 0x579E8E9E, 32, NDPI_PROTOCOL_TOR },
  { 0x579F41E5, 32, NDPI_PROTOCOL_TOR },
  { 0x579FA892, 32, NDPI_PROTOCOL_TOR },
  { 0x57A0D2C2, 32, NDPI_PROTOCOL_TOR },
  { 0x57A2CCAC, 32, NDPI_PROTOCOL_TOR },
  { 0x57A3F603, 32, NDPI_PROTOCOL_TOR },
  { 0x57A47E10, 32, NDPI_PROTOCOL_TOR },
  { 0x57A62B46, 32, NDPI_PROTOCOL_TOR },
  { 0x57A87901, 32, NDPI_PROTOCOL_TOR },
  { 0x57A97C46, 32, NDPI_PROTOCOL_TOR },
  { 0x57AC1458, 32, NDPI_PROTOCOL_TOR },
  { 0x57AE61DF, 32, NDPI_PROTOCOL_TOR },
  { 0x57AE69FB, 32, NDPI_PROTOCOL_TOR },
  { 0x57AEE582, 32, NDPI_PROTOCOL_TOR },
  { 0x57AEEF6C, 32, NDPI_PROTOCOL_TOR },
  { 0x57AEF49C, 32, NDPI_PROTOCOL_TOR },
  { 0x57B2A7F3, 32, NDPI_PROTOCOL_TOR },
  { 0x57B362F3, 32, NDPI_PROTOCOL_TOR },
  { 0x57B38736, 32, NDPI_PROTOCOL_TOR },
  { 0x57BA1D87, 32, NDPI_PROTOCOL_TOR },
  { 0x57BC52C0, 32, NDPI_PROTOCOL_TOR },
  { 0x57BC6D89, 32, NDPI_PROTOCOL_TOR },
  { 0x57BCC2CB, 32, NDPI_PROTOCOL_TOR },
  { 0x57BD56C4, 32, NDPI_PROTOCOL_TOR },
  { 0x57C1B3EE, 32, NDPI_PROTOCOL_TOR },
  { 0x57C1D00E, 32, NDPI_PROTOCOL_TOR },
  { 0x57C62255, 32, NDPI_PROTOCOL_TOR },
  { 0x57CBC2D4, 32, NDPI_PROTOCOL_TOR },
  { 0x57CFD9D4, 32, NDPI_PROTOCOL_TOR },
  { 0x57D430C9, 32, NDPI_PROTOCOL_TOR },
  { 0x57D8ABB3, 32, NDPI_PROTOCOL_TOR },
  { 0x57D93E0E, 32, NDPI_PROTOCOL_TOR },
  { 0x57DAA8EC, 32, NDPI_PROTOCOL_TOR },
  { 0x57E0D2F3, 32, NDPI_PROTOCOL_TOR },
  { 0x57E43BBD, 32, NDPI_PROTOCOL_TOR },
  { 0x57E611F5, 32, NDPI_PROTOCOL_TOR },
  { 0x57E6196D, 32, NDPI_PROTOCOL_TOR },
  { 0x57E619AC, 32, NDPI_PROTOCOL_TOR },
  { 0x57E6335F, 32, NDPI_PROTOCOL_TOR },
  { 0x57E64E6C, 32, NDPI_PROTOCOL_TOR },
  { 0x57E70AEB, 32, NDPI_PROTOCOL_TOR },
  { 0x57E77410, 32, NDPI_PROTOCOL_TOR },
  { 0x57EC1B9B, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECC3B9, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECC7A9, 32, NDPI_PROTOCOL_TOR },
  { 0x57ECD389, 32, NDPI_PROTOCOL_TOR },
  { 0x57EFA26E, 32, NDPI_PROTOCOL_TOR },
  { 0x57F38E21, 32, NDPI_PROTOCOL_TOR },
  { 0x57F4FFDA, 32, NDPI_PROTOCOL_TOR },
  { 0x57FB8C5D, 32, NDPI_PROTOCOL_TOR },
  { 0x57FE635F, 32, NDPI_PROTOCOL_TOR },
  { 0x580F9CD8, 32, NDPI_PROTOCOL_TOR },
  { 0x5811212D, 32, NDPI_PROTOCOL_TOR },
  { 0x58401AEB, 32, NDPI_PROTOCOL_TOR },
  { 0x58404EF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5840805B, 32, NDPI_PROTOCOL_TOR },
  { 0x58412604, 32, NDPI_PROTOCOL_TOR },
  { 0x5841F49C, 32, NDPI_PROTOCOL_TOR },
  { 0x5843639C, 32, NDPI_PROTOCOL_TOR },
  { 0x58458580, 32, NDPI_PROTOCOL_TOR },
  { 0x584862F4, 32, NDPI_PROTOCOL_TOR },
  { 0x584931A8, 32, NDPI_PROTOCOL_TOR },
  { 0x58493380, 32, NDPI_PROTOCOL_TOR },
  { 0x584C5C8E, 32, NDPI_PROTOCOL_TOR },
  { 0x584D2F56, 32, NDPI_PROTOCOL_TOR },
  { 0x584DC1AC, 32, NDPI_PROTOCOL_TOR },
  { 0x584DCB92, 32, NDPI_PROTOCOL_TOR },
  { 0x584E47B6, 32, NDPI_PROTOCOL_TOR },
  { 0x5850B95D, 32, NDPI_PROTOCOL_TOR },
  { 0x5850D6BD, 32, NDPI_PROTOCOL_TOR },
  { 0x58526C1A, 32, NDPI_PROTOCOL_TOR },
  { 0x5856D7D5, 32, NDPI_PROTOCOL_TOR },
  { 0x58574E68, 32, NDPI_PROTOCOL_TOR },
  { 0x585BD594, 32, NDPI_PROTOCOL_TOR },
  { 0x58614DFF, 32, NDPI_PROTOCOL_TOR },
  { 0x58690051, 32, NDPI_PROTOCOL_TOR },
  { 0x58719D6B, 32, NDPI_PROTOCOL_TOR },
  { 0x58726D58, 32, NDPI_PROTOCOL_TOR },
  { 0x5872759B, 32, NDPI_PROTOCOL_TOR },
  { 0x5872E33E, 32, NDPI_PROTOCOL_TOR },
  { 0x587E6C2D, 32, NDPI_PROTOCOL_TOR },
  { 0x587F6026, 32, NDPI_PROTOCOL_TOR },
  { 0x588201AE, 32, NDPI_PROTOCOL_TOR },
  { 0x58823273, 32, NDPI_PROTOCOL_TOR },
  { 0x58864FB5, 32, NDPI_PROTOCOL_TOR },
  { 0x588678F8, 32, NDPI_PROTOCOL_TOR },
  { 0x58869115, 32, NDPI_PROTOCOL_TOR },
  { 0x58894FA1, 32, NDPI_PROTOCOL_TOR },
  { 0x58959A20, 32, NDPI_PROTOCOL_TOR },
  { 0x58982F2D, 32, NDPI_PROTOCOL_TOR },
  { 0x5898FFF5, 32, NDPI_PROTOCOL_TOR },
  { 0x58996247, 32, NDPI_PROTOCOL_TOR },
  { 0x5899A4FF, 32, NDPI_PROTOCOL_TOR },
  { 0x5899AB6B, 32, NDPI_PROTOCOL_TOR },
  { 0x5899B4A5, 32, NDPI_PROTOCOL_TOR },
  { 0x589F4697, 32, NDPI_PROTOCOL_TOR },
  { 0x589F53F4, 32, NDPI_PROTOCOL_TOR },
  { 0x58A3E58B, 32, NDPI_PROTOCOL_TOR },
  { 0x58A5F4A9, 32, NDPI_PROTOCOL_TOR },
  { 0x58A6C0B5, 32, NDPI_PROTOCOL_TOR },
  { 0x58A8F257, 32, NDPI_PROTOCOL_TOR },
  { 0x58B0042F, 32, NDPI_PROTOCOL_TOR },
  { 0x58B0B407, 32, NDPI_PROTOCOL_TOR },
  { 0x58B256CA, 32, NDPI_PROTOCOL_TOR },
  { 0x58B99B86, 32, NDPI_PROTOCOL_TOR },
  { 0x58B9E31D, 32, NDPI_PROTOCOL_TOR },
  { 0x58BA120C, 32, NDPI_PROTOCOL_TOR },
  { 0x58BB785A, 32, NDPI_PROTOCOL_TOR },
  { 0x58BBBAD8, 32, NDPI_PROTOCOL_TOR },
  { 0x58BBE53B, 32, NDPI_PROTOCOL_TOR },
  { 0x58BD8A61, 32, NDPI_PROTOCOL_TOR },
  { 0x58C3CF75, 32, NDPI_PROTOCOL_TOR },
  { 0x58C60910, 32, NDPI_PROTOCOL_TOR },
  { 0x58C61304, 32, NDPI_PROTOCOL_TOR },
  { 0x58C617B3, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6194C, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6195C, 32, NDPI_PROTOCOL_TOR },
  { 0x58C628A5, 32, NDPI_PROTOCOL_TOR },
  { 0x58C63352, 32, NDPI_PROTOCOL_TOR },
  { 0x58C63436, 32, NDPI_PROTOCOL_TOR },
  { 0x58C636D4, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6388C, 32, NDPI_PROTOCOL_TOR },
  { 0x58C64689, 32, NDPI_PROTOCOL_TOR },
  { 0x58C664E6, 32, NDPI_PROTOCOL_TOR },
  { 0x58C664E8, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66D95, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66DE5, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66E98, 32, NDPI_PROTOCOL_TOR },
  { 0x58C66F77, 32, NDPI_PROTOCOL_TOR },
  { 0x58C67565, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6789B, 32, NDPI_PROTOCOL_TOR },
  { 0x58C67FE6, 32, NDPI_PROTOCOL_TOR },
  { 0x58C682D4, 32, NDPI_PROTOCOL_TOR },
  { 0x58C69A70, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6A363, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6A364, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6AF4C, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6C187, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6C259, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6C633, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6CFDE, 32, NDPI_PROTOCOL_TOR },
  { 0x58C6D6E9, 32, NDPI_PROTOCOL_TOR },
  { 0x58C8F312, 32, NDPI_PROTOCOL_TOR },
  { 0x58CC71BD, 32, NDPI_PROTOCOL_TOR },
  { 0x58D0CD8A, 32, NDPI_PROTOCOL_TOR },
  { 0x58D90267, 32, NDPI_PROTOCOL_TOR },
  { 0x58D92CAE, 32, NDPI_PROTOCOL_TOR },
  { 0x58D94FCA, 32, NDPI_PROTOCOL_TOR },
  { 0x58D98F35, 32, NDPI_PROTOCOL_TOR },
  { 0x58D9ABE1, 32, NDPI_PROTOCOL_TOR },
  { 0x58E44C31, 32, NDPI_PROTOCOL_TOR },
  { 0x59004F17, 32, NDPI_PROTOCOL_TOR },
  { 0x5900641C, 32, NDPI_PROTOCOL_TOR },
  { 0x5900878D, 32, NDPI_PROTOCOL_TOR },
  { 0x5900AD14, 32, NDPI_PROTOCOL_TOR },
  { 0x5900E463, 32, NDPI_PROTOCOL_TOR },
  { 0x5900E570, 32, NDPI_PROTOCOL_TOR },
  { 0x5900EA67, 32, NDPI_PROTOCOL_TOR },
  { 0x5900EC30, 32, NDPI_PROTOCOL_TOR },
  { 0x5900F2EF, 32, NDPI_PROTOCOL_TOR },
  { 0x5900F7A3, 32, NDPI_PROTOCOL_TOR },
  { 0x59039E31, 32, NDPI_PROTOCOL_TOR },
  { 0x590CF9FD, 32, NDPI_PROTOCOL_TOR },
  { 0x590D5330, 32, NDPI_PROTOCOL_TOR },
  { 0x590E57D6, 32, NDPI_PROTOCOL_TOR },
  { 0x590F649D, 32, NDPI_PROTOCOL_TOR },
  { 0x590F6BF1, 32, NDPI_PROTOCOL_TOR },
  { 0x590FC872, 32, NDPI_PROTOCOL_TOR },
  { 0x59108C47, 32, NDPI_PROTOCOL_TOR },
  { 0x5910B09E, 32, NDPI_PROTOCOL_TOR },
  { 0x59122A65, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AC8B, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AD29, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AE45, 32, NDPI_PROTOCOL_TOR },
  { 0x5912AE56, 32, NDPI_PROTOCOL_TOR },
  { 0x5912BE6B, 32, NDPI_PROTOCOL_TOR },
  { 0x5916602F, 32, NDPI_PROTOCOL_TOR },
  { 0x5916613A, 32, NDPI_PROTOCOL_TOR },
  { 0x591661C1, 32, NDPI_PROTOCOL_TOR },
  { 0x591B0DD9, 32, NDPI_PROTOCOL_TOR },
  { 0x591B4114, 32, NDPI_PROTOCOL_TOR },
  { 0x591B5146, 32, NDPI_PROTOCOL_TOR },
  { 0x591F3905, 32, NDPI_PROTOCOL_TOR },
  { 0x5924EB42, 32, NDPI_PROTOCOL_TOR },
  { 0x59284795, 32, NDPI_PROTOCOL_TOR },
  { 0x592E64A2, 32, NDPI_PROTOCOL_TOR },
  { 0x592E6524, 32, NDPI_PROTOCOL_TOR },
  { 0x592E65B5, 32, NDPI_PROTOCOL_TOR },
  { 0x59410727, 32, NDPI_PROTOCOL_TOR },
  { 0x59412546, 32, NDPI_PROTOCOL_TOR },
  { 0x59438C76, 32, NDPI_PROTOCOL_TOR },
  { 0x59438C76, 32, NDPI_PROTOCOL_TOR },
  { 0x5943B32A, 32, NDPI_PROTOCOL_TOR },
  { 0x5943FE26, 32, NDPI_PROTOCOL_TOR },
  { 0x5944BDD0, 32, NDPI_PROTOCOL_TOR },
  { 0x594669E7, 32, NDPI_PROTOCOL_TOR },
  { 0x5949B1EC, 32, NDPI_PROTOCOL_TOR },
  { 0x5949D520, 32, NDPI_PROTOCOL_TOR },
  { 0x594A6CCE, 32, NDPI_PROTOCOL_TOR },
  { 0x594D88AE, 32, NDPI_PROTOCOL_TOR },
  { 0x5959FD25, 32, NDPI_PROTOCOL_TOR },
  { 0x5962E64C, 32, NDPI_PROTOCOL_TOR },
  { 0x59639B85, 32, NDPI_PROTOCOL_TOR },
  { 0x59669393, 32, NDPI_PROTOCOL_TOR },
  { 0x5967B502, 32, NDPI_PROTOCOL_TOR },
  { 0x5967B832, 32, NDPI_PROTOCOL_TOR },
  { 0x5969C582, 32, NDPI_PROTOCOL_TOR },
  { 0x596AF415, 32, NDPI_PROTOCOL_TOR },
  { 0x596C560B, 32, NDPI_PROTOCOL_TOR },
  { 0x596C58E3, 32, NDPI_PROTOCOL_TOR },
  { 0x596E9CF7, 32, NDPI_PROTOCOL_TOR },
  { 0x596F1444, 32, NDPI_PROTOCOL_TOR },
  { 0x5978777D, 32, NDPI_PROTOCOL_TOR },
  { 0x59829E95, 32, NDPI_PROTOCOL_TOR },
  { 0x59845CDA, 32, NDPI_PROTOCOL_TOR },
  { 0x5985A952, 32, NDPI_PROTOCOL_TOR },
  { 0x598619DA, 32, NDPI_PROTOCOL_TOR },
  { 0x59869680, 32, NDPI_PROTOCOL_TOR },
  { 0x59879056, 32, NDPI_PROTOCOL_TOR },
  { 0x598C623C, 32, NDPI_PROTOCOL_TOR },
  { 0x598E23D1, 32, NDPI_PROTOCOL_TOR },
  { 0x59910E6C, 32, NDPI_PROTOCOL_TOR },
  { 0x599B990F, 32, NDPI_PROTOCOL_TOR },
  { 0x599C3EBE, 32, NDPI_PROTOCOL_TOR },
  { 0x599C5DDC, 32, NDPI_PROTOCOL_TOR },
  { 0x599ED03F, 32, NDPI_PROTOCOL_TOR },
  { 0x599F568B, 32, NDPI_PROTOCOL_TOR },
  { 0x59A0DE85, 32, NDPI_PROTOCOL_TOR },
  { 0x59A257B4, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3ABFA, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3B9BA, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D14F, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3D14F, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DD97, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3DD97, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E00A, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0A8, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E0BB, 32, NDPI_PROTOCOL_TOR },
  { 0x59A3E31C, 32, NDPI_PROTOCOL_TOR },
  { 0x59A6EAF6, 32, NDPI_PROTOCOL_TOR },
  { 0x59A9A5E9, 32, NDPI_PROTOCOL_TOR },
  { 0x59B08CBE, 32, NDPI_PROTOCOL_TOR },
  { 0x59B08D09, 32, NDPI_PROTOCOL_TOR },
  { 0x59B34E19, 32, NDPI_PROTOCOL_TOR },
  { 0x59B37F7C, 32, NDPI_PROTOCOL_TOR },
  { 0x59B3F11E, 32, NDPI_PROTOCOL_TOR },
  { 0x59B891D7, 32, NDPI_PROTOCOL_TOR },
  { 0x59BA8F86, 32, NDPI_PROTOCOL_TOR },
  { 0x59BB8ED0, 32, NDPI_PROTOCOL_TOR },
  { 0x59BC6DD2, 32, NDPI_PROTOCOL_TOR },
  { 0x59BFC7F5, 32, NDPI_PROTOCOL_TOR },
  { 0x59CF8537, 32, NDPI_PROTOCOL_TOR },
  { 0x59CF8799, 32, NDPI_PROTOCOL_TOR },
  { 0x59E31A37, 32, NDPI_PROTOCOL_TOR },
  { 0x59E7763D, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA8D65, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA9DFE, 32, NDPI_PROTOCOL_TOR },
  { 0x59EA9DFE, 32, NDPI_PROTOCOL_TOR },
  { 0x59EE455D, 32, NDPI_PROTOCOL_TOR },
  { 0x59EE4D04, 32, NDPI_PROTOCOL_TOR },
  { 0x59EE4E6C, 32, NDPI_PROTOCOL_TOR },
  { 0x59EEAC6C, 32, NDPI_PROTOCOL_TOR },
  { 0x59EFDAB4, 32, NDPI_PROTOCOL_TOR },
  { 0x59F8A679, 32, NDPI_PROTOCOL_TOR },
  { 0x59F8AC10, 32, NDPI_PROTOCOL_TOR },
  { 0x59F985A5, 32, NDPI_PROTOCOL_TOR },
  { 0x59FB968E, 32, NDPI_PROTOCOL_TOR },
  { 0x59FC0125, 32, NDPI_PROTOCOL_TOR },
  { 0x59FC028C, 32, NDPI_PROTOCOL_TOR },
  { 0x5A09C850, 32, NDPI_PROTOCOL_TOR },
  { 0x5A0A8BC7, 32, NDPI_PROTOCOL_TOR },
  { 0x5A0B5036, 32, NDPI_PROTOCOL_TOR },
  { 0x5A18B154, 32, NDPI_PROTOCOL_TOR },
  { 0x5A1B3C6B, 32, NDPI_PROTOCOL_TOR },
  { 0x5A1D82F0, 32, NDPI_PROTOCOL_TOR },
  { 0x5A1D9B54, 32, NDPI_PROTOCOL_TOR },
  { 0x5A20BA49, 32, NDPI_PROTOCOL_TOR },
  { 0x5A28F78E, 32, NDPI_PROTOCOL_TOR },
  { 0x5A3CABF0, 32, NDPI_PROTOCOL_TOR },
  { 0x5A3FA178, 32, NDPI_PROTOCOL_TOR },
  { 0x5A914577, 32, NDPI_PROTOCOL_TOR },
  { 0x5A921D38, 32, NDPI_PROTOCOL_TOR },
  { 0x5A92B569, 32, NDPI_PROTOCOL_TOR },
  { 0x5A951B7A, 32, NDPI_PROTOCOL_TOR },
  { 0x5A95517A, 32, NDPI_PROTOCOL_TOR },
  { 0x5A9B17DA, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB0A48F, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB50D30, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB88EE0, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8A455, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8DE74, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8DE75, 32, NDPI_PROTOCOL_TOR },
  { 0x5AB8DE76, 32, NDPI_PROTOCOL_TOR },
  { 0x5AC04EC5, 32, NDPI_PROTOCOL_TOR },
  { 0x5ADB84FD, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE14054, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE150DB, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE1558C, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE2B287, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE4CA9F, 32, NDPI_PROTOCOL_TOR },
  { 0x5AE7989F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B025570, 32, NDPI_PROTOCOL_TOR },
  { 0x5B02F637, 32, NDPI_PROTOCOL_TOR },
  { 0x5B041823, 32, NDPI_PROTOCOL_TOR },
  { 0x5B05878B, 32, NDPI_PROTOCOL_TOR },
  { 0x5B06757C, 32, NDPI_PROTOCOL_TOR },
  { 0x5B09C013, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0A081A, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0A45D7, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0A7B54, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0CD9A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0CEB4D, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0D634C, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0E755F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B0F4794, 32, NDPI_PROTOCOL_TOR },
  { 0x5B120251, 32, NDPI_PROTOCOL_TOR },
  { 0x5B129DE3, 32, NDPI_PROTOCOL_TOR },
  { 0x5B152C3D, 32, NDPI_PROTOCOL_TOR },
  { 0x5B21CED5, 32, NDPI_PROTOCOL_TOR },
  { 0x5B225C74, 32, NDPI_PROTOCOL_TOR },
  { 0x5B25E831, 32, NDPI_PROTOCOL_TOR },
  { 0x5B265CAF, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2C7D98, 32, NDPI_PROTOCOL_TOR },
  { 0x5B2DE1A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3249DA, 32, NDPI_PROTOCOL_TOR },
  { 0x5B334FF1, 32, NDPI_PROTOCOL_TOR },
  { 0x5B336B45, 32, NDPI_PROTOCOL_TOR },
  { 0x5B33E422, 32, NDPI_PROTOCOL_TOR },
  { 0x5B33FBDE, 32, NDPI_PROTOCOL_TOR },
  { 0x5B343F6F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B36DE01, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3B5350, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3D4574, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3D52E4, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3DF13E, 32, NDPI_PROTOCOL_TOR },
  { 0x5B3EE54E, 32, NDPI_PROTOCOL_TOR },
  { 0x5B406D9B, 32, NDPI_PROTOCOL_TOR },
  { 0x5B406F83, 32, NDPI_PROTOCOL_TOR },
  { 0x5B40EADB, 32, NDPI_PROTOCOL_TOR },
  { 0x5B41538E, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4160F6, 32, NDPI_PROTOCOL_TOR },
  { 0x5B424E8B, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4254DB, 32, NDPI_PROTOCOL_TOR },
  { 0x5B42CC01, 32, NDPI_PROTOCOL_TOR },
  { 0x5B434C46, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4D127A, 32, NDPI_PROTOCOL_TOR },
  { 0x5B4F6E29, 32, NDPI_PROTOCOL_TOR },
  { 0x5B52ED7F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B605C06, 32, NDPI_PROTOCOL_TOR },
  { 0x5B60BC9F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B614084, 32, NDPI_PROTOCOL_TOR },
  { 0x5B6DF7AD, 32, NDPI_PROTOCOL_TOR },
  { 0x5B711952, 32, NDPI_PROTOCOL_TOR },
  { 0x5B77D141, 32, NDPI_PROTOCOL_TOR },
  { 0x5B77E5A1, 32, NDPI_PROTOCOL_TOR },
  { 0x5B790114, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791043, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7915E0, 32, NDPI_PROTOCOL_TOR },
  { 0x5B791C40, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794CCC, 32, NDPI_PROTOCOL_TOR },
  { 0x5B794CCF, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795210, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795219, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79545C, 32, NDPI_PROTOCOL_TOR },
  { 0x5B795582, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7964C8, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7968A8, 32, NDPI_PROTOCOL_TOR },
  { 0x5B796AB2, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79734F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B797422, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799255, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799275, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799341, 32, NDPI_PROTOCOL_TOR },
  { 0x5B799FC4, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A5DF, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A698, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79A921, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79B857, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79C584, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79CF22, 32, NDPI_PROTOCOL_TOR },
  { 0x5B79E9F2, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7A640D, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7BC8A8, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7BC8EB, 32, NDPI_PROTOCOL_TOR },
  { 0x5B7EFFCD, 32, NDPI_PROTOCOL_TOR },
  { 0x5B88A44D, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8A448F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8A9B09, 32, NDPI_PROTOCOL_TOR },
  { 0x5B8C31D6, 32, NDPI_PROTOCOL_TOR },
  { 0x5B917635, 32, NDPI_PROTOCOL_TOR },
  { 0x5B927903, 32, NDPI_PROTOCOL_TOR },
  { 0x5B927A2D, 32, NDPI_PROTOCOL_TOR },
  { 0x5B95AD4F, 32, NDPI_PROTOCOL_TOR },
  { 0x5B9A9932, 32, NDPI_PROTOCOL_TOR },
  { 0x5B9BBD6B, 32, NDPI_PROTOCOL_TOR },
  { 0x5BB9C8DD, 32, NDPI_PROTOCOL_TOR },
  { 0x5BB9E123, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBA2710, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBC7D80, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBDB576, 32, NDPI_PROTOCOL_TOR },
  { 0x5BBE754D, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC2546A, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC25A27, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC25A67, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC7C54C, 32, NDPI_PROTOCOL_TOR },
  { 0x5BC85544, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCA2D9C, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCBD4EE, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCDAD52, 32, NDPI_PROTOCOL_TOR },
  { 0x5BCE8E46, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD05448, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD26A1B, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD33ED4, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD5082B, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50854, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50859, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD50874, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD508EB, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD508EB, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD508EC, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD6A8F0, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD6CB90, 32, NDPI_PROTOCOL_TOR },
  { 0x5BD6CBE9, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED13, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBED6E, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDCF, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDDA, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDE5, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEDF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDBEEDD, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDCA33E, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDD6F07, 32, NDPI_PROTOCOL_TOR },
  { 0x5BDEDA85, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09509, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09521, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE0952D, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE09537, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE25911, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE434BA, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE49734, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE4B382, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE5141B, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE6CCC6, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE8D912, 32, NDPI_PROTOCOL_TOR },
  { 0x5BE97444, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEA1630, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEAE223, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECEF87, 32, NDPI_PROTOCOL_TOR },
  { 0x5BECEF8C, 32, NDPI_PROTOCOL_TOR },
  { 0x5BED34AA, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEDF43E, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEDF73E, 32, NDPI_PROTOCOL_TOR },
  { 0x5BEE3C64, 32, NDPI_PROTOCOL_TOR },
  { 0x5BF0E5C3, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFA7026, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFA73B9, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF20A, 32, NDPI_PROTOCOL_TOR },
  { 0x5BFAF267, 32, NDPI_PROTOCOL_TOR },
  { 0x5C002464, 32, NDPI_PROTOCOL_TOR },
  { 0x5C0124D4, 32, NDPI_PROTOCOL_TOR },
  { 0x5C01DCB8, 32, NDPI_PROTOCOL_TOR },
  { 0x5C07A833, 32, NDPI_PROTOCOL_TOR },
  { 0x5C0A3BD5, 32, NDPI_PROTOCOL_TOR },
  { 0x5C0EC83C, 32, NDPI_PROTOCOL_TOR },
  { 0x5C14074D, 32, NDPI_PROTOCOL_TOR },
  { 0x5C14CB4C, 32, NDPI_PROTOCOL_TOR },
  { 0x5C15F357, 32, NDPI_PROTOCOL_TOR },
  { 0x5C18851F, 32, NDPI_PROTOCOL_TOR },
  { 0x5C18851F, 32, NDPI_PROTOCOL_TOR },
  { 0x5C27F38B, 32, NDPI_PROTOCOL_TOR },
  { 0x5C27F62D, 32, NDPI_PROTOCOL_TOR },
  { 0x5C2869CC, 32, NDPI_PROTOCOL_TOR },
  { 0x5C32581A, 32, NDPI_PROTOCOL_TOR },
  { 0x5C34249B, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3C05EE, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3C05EE, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3F582D, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3F582F, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3F6E7C, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAB2D, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FABCF, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAC96, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAE24, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAE46, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAE47, 32, NDPI_PROTOCOL_TOR },
  { 0x5C3FAF05, 32, NDPI_PROTOCOL_TOR },
  { 0x5C484CE3, 32, NDPI_PROTOCOL_TOR },
  { 0x5C487B89, 32, NDPI_PROTOCOL_TOR },
  { 0x5C48FF4A, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4A357A, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4AE372, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4B0EC2, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4C7C06, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4CC040, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4D2D74, 32, NDPI_PROTOCOL_TOR },
  { 0x5C4DB1FE, 32, NDPI_PROTOCOL_TOR },
  { 0x5C59AD55, 32, NDPI_PROTOCOL_TOR },
  { 0x5C5B7942, 32, NDPI_PROTOCOL_TOR },
  { 0x5C5B9C44, 32, NDPI_PROTOCOL_TOR },
  { 0x5C645773, 32, NDPI_PROTOCOL_TOR },
  { 0x5C647BD0, 32, NDPI_PROTOCOL_TOR },
  { 0x5C68349B, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6893A0, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6977C0, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6AE25D, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6C364C, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6C7829, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6D0707, 32, NDPI_PROTOCOL_TOR },
  { 0x5C6F8E21, 32, NDPI_PROTOCOL_TOR },
  { 0x5C81AF11, 32, NDPI_PROTOCOL_TOR },
  { 0x5C83BD03, 32, NDPI_PROTOCOL_TOR },
  { 0x5C89D859, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC240C3, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC328D6, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC941B7, 32, NDPI_PROTOCOL_TOR },
  { 0x5CC94BCD, 32, NDPI_PROTOCOL_TOR },
  { 0x5CCA214F, 32, NDPI_PROTOCOL_TOR },
  { 0x5CCD15C1, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD13085, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD3AE6A, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD6A588, 32, NDPI_PROTOCOL_TOR },
  { 0x5CD6ADD8, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE016C, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE0352, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE0466, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE04B2, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE0935, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE0946, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1385, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1482, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1625, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1671, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE19E1, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1A24, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1A51, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1C5A, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1C8F, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1CF3, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE1D22, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE2211, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE2643, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE27B7, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE2DC7, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE45BC, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDE9993, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEA236, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEACE5, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEB57B, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDEC022, 32, NDPI_PROTOCOL_TOR },
  { 0x5CDECC60, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE09A94, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE0A09F, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE0B392, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE10C0D, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE169B5, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE389A3, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE4B19B, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE52412, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE59221, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE68415, 32, NDPI_PROTOCOL_TOR },
  { 0x5CE86216, 32, NDPI_PROTOCOL_TOR },
  { 0x5CED16DA, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF31ED0, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF34569, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF3BC10, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF6147E, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF733A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF79DB0, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF96241, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF98F77, 32, NDPI_PROTOCOL_TOR },
  { 0x5CF9BCF6, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFC2031, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFE18CB, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFE3951, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFEB874, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFC311, 32, NDPI_PROTOCOL_TOR },
  { 0x5CFFCF59, 32, NDPI_PROTOCOL_TOR },
  { 0x5D134D18, 32, NDPI_PROTOCOL_TOR },
  { 0x5D1F9BAF, 32, NDPI_PROTOCOL_TOR },
  { 0x5D328CAA, 32, NDPI_PROTOCOL_TOR },
  { 0x5D48650E, 32, NDPI_PROTOCOL_TOR },
  { 0x5D515FF8, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5A73BC, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5B3291, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5CCC06, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5E922B, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE37F, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE3F5, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE405, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE433, 32, NDPI_PROTOCOL_TOR },
  { 0x5D5FE452, 32, NDPI_PROTOCOL_TOR },
  { 0x5D63058C, 32, NDPI_PROTOCOL_TOR },
  { 0x5D64A738, 32, NDPI_PROTOCOL_TOR },
  { 0x5D6797A7, 32, NDPI_PROTOCOL_TOR },
  { 0x5D688049, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68A671, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D13D, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D19E, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D3A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5D68D4FD, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73569C, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735EF3, 32, NDPI_PROTOCOL_TOR },
  { 0x5D735EF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5D73F102, 32, NDPI_PROTOCOL_TOR },
  { 0x5D760C01, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7C3305, 32, NDPI_PROTOCOL_TOR },
  { 0x5D7E65DF, 32, NDPI_PROTOCOL_TOR },
  { 0x5D804CF1, 32, NDPI_PROTOCOL_TOR },
  { 0x5D81945A, 32, NDPI_PROTOCOL_TOR },
  { 0x5D8456CA, 32, NDPI_PROTOCOL_TOR },
  { 0x5D84AC51, 32, NDPI_PROTOCOL_TOR },
  { 0x5D867771, 32, NDPI_PROTOCOL_TOR },
  { 0x5D8712F4, 32, NDPI_PROTOCOL_TOR },
  { 0x5D8BDD63, 32, NDPI_PROTOCOL_TOR },
  { 0x5D98C554, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9C28A3, 32, NDPI_PROTOCOL_TOR },
  { 0x5D9C4AEF, 32, NDPI_PROTOCOL_TOR },
  { 0x5DA33850, 32, NDPI_PROTOCOL_TOR },
  { 0x5DA7F5B2, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE5A1E, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE5D15, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAE5D3F, 32, NDPI_PROTOCOL_TOR },
  { 0x5DAF0C52, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49A5E, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49C54, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49C63, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49D28, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB49D9A, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB81566, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB842E3, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB9654C, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB965AC, 32, NDPI_PROTOCOL_TOR },
  { 0x5DB96DBF, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBAC8D5, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBCA2EB, 32, NDPI_PROTOCOL_TOR },
  { 0x5DBF0D22, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC06F39, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC0AAC8, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC0CA0C, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC16D99, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC2904C, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC5E303, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC5F098, 32, NDPI_PROTOCOL_TOR },
  { 0x5DC8C66B, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCBFB93, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCD0C3A, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCF14E7, 32, NDPI_PROTOCOL_TOR },
  { 0x5DCF46AC, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD3F085, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD47CEB, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD71649, 32, NDPI_PROTOCOL_TOR },
  { 0x5DD740AF, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDA6C31, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDB7692, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDC0F3B, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDC7449, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDCD36F, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDCEB0C, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDF509D, 32, NDPI_PROTOCOL_TOR },
  { 0x5DDFCC89, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE44D4E, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE62635, 32, NDPI_PROTOCOL_TOR },
  { 0x5DE95360, 32, NDPI_PROTOCOL_TOR },
  { 0x5E05D57B, 32, NDPI_PROTOCOL_TOR },
  { 0x5E09C10C, 32, NDPI_PROTOCOL_TOR },
  { 0x5E104BE2, 32, NDPI_PROTOCOL_TOR },
  { 0x5E137BC2, 32, NDPI_PROTOCOL_TOR },
  { 0x5E160545, 32, NDPI_PROTOCOL_TOR },
  { 0x5E168F9E, 32, NDPI_PROTOCOL_TOR },
  { 0x5E16A01D, 32, NDPI_PROTOCOL_TOR },
  { 0x5E170291, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1712A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17141C, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1714BE, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17194E, 32, NDPI_PROTOCOL_TOR },
  { 0x5E171E35, 32, NDPI_PROTOCOL_TOR },
  { 0x5E172434, 32, NDPI_PROTOCOL_TOR },
  { 0x5E172599, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1730BA, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17360C, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17381F, 32, NDPI_PROTOCOL_TOR },
  { 0x5E1746DE, 32, NDPI_PROTOCOL_TOR },
  { 0x5E175892, 32, NDPI_PROTOCOL_TOR },
  { 0x5E176919, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17A2E3, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17AB60, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17C221, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17C636, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17CCAF, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17D0BC, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17D2A3, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17ECBB, 32, NDPI_PROTOCOL_TOR },
  { 0x5E17FC1F, 32, NDPI_PROTOCOL_TOR },
  { 0x5E188C4A, 32, NDPI_PROTOCOL_TOR },
  { 0x5E22964B, 32, NDPI_PROTOCOL_TOR },
  { 0x5E29C2EE, 32, NDPI_PROTOCOL_TOR },
  { 0x5E2D3BF0, 32, NDPI_PROTOCOL_TOR },
  { 0x5E33CEA8, 32, NDPI_PROTOCOL_TOR },
  { 0x5E46889C, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4BCF64, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4F89B6, 32, NDPI_PROTOCOL_TOR },
  { 0x5E4FB906, 32, NDPI_PROTOCOL_TOR },
  { 0x5E6412A2, 32, NDPI_PROTOCOL_TOR },
  { 0x5E6635B1, 32, NDPI_PROTOCOL_TOR },
  { 0x5E663CAC, 32, NDPI_PROTOCOL_TOR },
  { 0x5E67AF55, 32, NDPI_PROTOCOL_TOR },
  { 0x5E716902, 32, NDPI_PROTOCOL_TOR },
  { 0x5E71E6DD, 32, NDPI_PROTOCOL_TOR },
  { 0x5E7CF603, 32, NDPI_PROTOCOL_TOR },
  { 0x5E7EB201, 32, NDPI_PROTOCOL_TOR },
  { 0x5E878697, 32, NDPI_PROTOCOL_TOR },
  { 0x5E88612A, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8DACF0, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF18A, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF1F1, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF21E, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF5CE, 32, NDPI_PROTOCOL_TOR },
  { 0x5E8EF5E7, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9B5D2D, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9ED927, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9FCE6E, 32, NDPI_PROTOCOL_TOR },
  { 0x5E9FDCF2, 32, NDPI_PROTOCOL_TOR },
  { 0x5EAE9EF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB4D2CA, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB4D8D9, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB4E868, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB51414, 32, NDPI_PROTOCOL_TOR },
  { 0x5EB95202, 32, NDPI_PROTOCOL_TOR },
  { 0x5EBC1C88, 32, NDPI_PROTOCOL_TOR },
  { 0x5EBC39EC, 32, NDPI_PROTOCOL_TOR },
  { 0x5EBEE03A, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC6440D, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66247, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC66411, 32, NDPI_PROTOCOL_TOR },
  { 0x5EC73365, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED0E3DD, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED2001C, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED2BE2C, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED3C0CA, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED61659, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED6179F, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED9C67E, 32, NDPI_PROTOCOL_TOR },
  { 0x5ED9FE19, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDA142C, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDC49D6, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDD6472, 32, NDPI_PROTOCOL_TOR },
  { 0x5EDD9651, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE19A57, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE4560B, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE4DEC0, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE6CB1F, 32, NDPI_PROTOCOL_TOR },
  { 0x5EE72228, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23915, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23926, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239A4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239A9, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239C4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF239D4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF23A46, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2C6A4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2CC84, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2D178, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2D1F4, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2DE1B, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2DED7, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F342, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F3A2, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F617, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2F618, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FB70, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FC29, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FE51, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FE51, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF2FEBF, 32, NDPI_PROTOCOL_TOR },
  { 0x5EF72982, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFD0E62, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFD4CD2, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE1877, 32, NDPI_PROTOCOL_TOR },
  { 0x5EFE30C2, 32, NDPI_PROTOCOL_TOR },
  { 0x5F122587, 32, NDPI_PROTOCOL_TOR },
  { 0x5F17F611, 32, NDPI_PROTOCOL_TOR },
  { 0x5F182884, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1931B0, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1BE179, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1C5963, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1EAD45, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F1B6C, 32, NDPI_PROTOCOL_TOR },
  { 0x5F1F2E02, 32, NDPI_PROTOCOL_TOR },
  { 0x5F25A84D, 32, NDPI_PROTOCOL_TOR },
  { 0x5F40CB0E, 32, NDPI_PROTOCOL_TOR },
  { 0x5F477EE6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F480939, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4892AD, 32, NDPI_PROTOCOL_TOR },
  { 0x5F491AE8, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4931BA, 32, NDPI_PROTOCOL_TOR },
  { 0x5F49EB59, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4D914B, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4E3856, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4F19B6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4F605F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F4F89F8, 32, NDPI_PROTOCOL_TOR },
  { 0x5F500A2E, 32, NDPI_PROTOCOL_TOR },
  { 0x5F52F5EA, 32, NDPI_PROTOCOL_TOR },
  { 0x5F549049, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5494AD, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54C634, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54C806, 32, NDPI_PROTOCOL_TOR },
  { 0x5F54D17E, 32, NDPI_PROTOCOL_TOR },
  { 0x5F550367, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5503BF, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5505D3, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55075A, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5508E2, 32, NDPI_PROTOCOL_TOR },
  { 0x5F550A47, 32, NDPI_PROTOCOL_TOR },
  { 0x5F550E4F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F551449, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55150E, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5517BD, 32, NDPI_PROTOCOL_TOR },
  { 0x5F552522, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55256F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F552673, 32, NDPI_PROTOCOL_TOR },
  { 0x5F55271C, 32, NDPI_PROTOCOL_TOR },
  { 0x5F552A24, 32, NDPI_PROTOCOL_TOR },
  { 0x5F553605, 32, NDPI_PROTOCOL_TOR },
  { 0x5F553C17, 32, NDPI_PROTOCOL_TOR },
  { 0x5F594A54, 32, NDPI_PROTOCOL_TOR },
  { 0x5F599862, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5A0C37, 32, NDPI_PROTOCOL_TOR },
  { 0x5F5B83B6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F61A0CC, 32, NDPI_PROTOCOL_TOR },
  { 0x5F69A188, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6A1BC6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F6D7A90, 32, NDPI_PROTOCOL_TOR },
  { 0x5F7008D0, 32, NDPI_PROTOCOL_TOR },
  { 0x5F71E203, 32, NDPI_PROTOCOL_TOR },
  { 0x5F72385D, 32, NDPI_PROTOCOL_TOR },
  { 0x5F741FDB, 32, NDPI_PROTOCOL_TOR },
  { 0x5F76808A, 32, NDPI_PROTOCOL_TOR },
  { 0x5F802BA4, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8137AD, 32, NDPI_PROTOCOL_TOR },
  { 0x5F81CD53, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820959, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820959, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820979, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8209BE, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820A0F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B05, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B0F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B2A, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B2E, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820B93, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820BA2, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820BAA, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820BD6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820C2F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820C77, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820F60, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820F61, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820FFB, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820FFC, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820FFD, 32, NDPI_PROTOCOL_TOR },
  { 0x5F820FFE, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8387B3, 32, NDPI_PROTOCOL_TOR },
  { 0x5F83EA02, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8429AB, 32, NDPI_PROTOCOL_TOR },
  { 0x5F843460, 32, NDPI_PROTOCOL_TOR },
  { 0x5F851927, 32, NDPI_PROTOCOL_TOR },
  { 0x5F872D77, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8BE024, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8C2AB7, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8D5392, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8DE895, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EA13F, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8EAD12, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACD4, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACD6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FACF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FC191, 32, NDPI_PROTOCOL_TOR },
  { 0x5F8FE1C6, 32, NDPI_PROTOCOL_TOR },
  { 0x5F91E0D0, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9A1849, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9A58FC, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9A6A86, 32, NDPI_PROTOCOL_TOR },
  { 0x5F9D0C83, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA01056, 32, NDPI_PROTOCOL_TOR },
  { 0x5FA9BC67, 32, NDPI_PROTOCOL_TOR },
  { 0x5FAAB5D0, 32, NDPI_PROTOCOL_TOR },
  { 0x5FACEC76, 32, NDPI_PROTOCOL_TOR },
  { 0x5FAEE547, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3079E, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD31B0A, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD349ED, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3629F, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38811, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD38A1B, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3A923, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3CD97, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3D865, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3DE93, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E1A7, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E408, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E59E, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3E781, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD3F153, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD701B5, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C66, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C69, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C6E, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C6F, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C7A, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72C91, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CBA, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CBB, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CBD, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CC2, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CE8, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72CF9, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D2F, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D41, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D44, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D80, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72D8E, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72DBC, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72DC3, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72DC5, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E24, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E54, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E5A, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E67, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E7B, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72E96, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72EF4, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F75, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F80, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F8B, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72F96, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FB1, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FBB, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FC7, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FCE, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FD8, 32, NDPI_PROTOCOL_TOR },
  { 0x5FD72FF2, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDC69CA, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDC822D, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDE9C03, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDE9C04, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDEE336, 32, NDPI_PROTOCOL_TOR },
  { 0x5FDFD887, 32, NDPI_PROTOCOL_TOR },
  { 0x5FEEE099, 32, NDPI_PROTOCOL_TOR },
  { 0x5FEFE676, 32, NDPI_PROTOCOL_TOR },
  { 0x601390C6, 32, NDPI_PROTOCOL_TOR },
  { 0x601CBD5E, 32, NDPI_PROTOCOL_TOR },
  { 0x601F430F, 32, NDPI_PROTOCOL_TOR },
  { 0x60210687, 32, NDPI_PROTOCOL_TOR },
  { 0x60238283, 32, NDPI_PROTOCOL_TOR },
  { 0x60253C3F, 32, NDPI_PROTOCOL_TOR },
  { 0x6028292D, 32, NDPI_PROTOCOL_TOR },
  { 0x60290DA2, 32, NDPI_PROTOCOL_TOR },
  { 0x6029718C, 32, NDPI_PROTOCOL_TOR },
  { 0x602A211B, 32, NDPI_PROTOCOL_TOR },
  { 0x602CBD64, 32, NDPI_PROTOCOL_TOR },
  { 0x602CBD65, 32, NDPI_PROTOCOL_TOR },
  { 0x602CBD66, 32, NDPI_PROTOCOL_TOR },
  { 0x602F411A, 32, NDPI_PROTOCOL_TOR },
  { 0x602FE214, 32, NDPI_PROTOCOL_TOR },
  { 0x602FE215, 32, NDPI_PROTOCOL_TOR },
  { 0x602FE216, 32, NDPI_PROTOCOL_TOR },
  { 0x602FEC7E, 32, NDPI_PROTOCOL_TOR },
  { 0x60303837, 32, NDPI_PROTOCOL_TOR },
  { 0x60341169, 32, NDPI_PROTOCOL_TOR },
  { 0x60362A0F, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6009, 32, NDPI_PROTOCOL_TOR },
  { 0x607E605A, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6688, 32, NDPI_PROTOCOL_TOR },
  { 0x607E69DB, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6E3C, 32, NDPI_PROTOCOL_TOR },
  { 0x607E6E3C, 32, NDPI_PROTOCOL_TOR },
  { 0x607E76E3, 32, NDPI_PROTOCOL_TOR },
  { 0x607E7AA6, 32, NDPI_PROTOCOL_TOR },
  { 0x607E7F58, 32, NDPI_PROTOCOL_TOR },
  { 0x60E26D05, 32, NDPI_PROTOCOL_TOR },
  { 0x60E29C48, 32, NDPI_PROTOCOL_TOR },
  { 0x60E53297, 32, NDPI_PROTOCOL_TOR },
  { 0x60E6398D, 32, NDPI_PROTOCOL_TOR },
  { 0x60E85742, 32, NDPI_PROTOCOL_TOR },
  { 0x60E932CF, 32, NDPI_PROTOCOL_TOR },
  { 0x60EE056F, 32, NDPI_PROTOCOL_TOR },
  { 0x60EE23B4, 32, NDPI_PROTOCOL_TOR },
  { 0x60F19A42, 32, NDPI_PROTOCOL_TOR },
  { 0x60FA5604, 32, NDPI_PROTOCOL_TOR },
  { 0x60FD4E6B, 32, NDPI_PROTOCOL_TOR },
  { 0x60FF47C9, 32, NDPI_PROTOCOL_TOR },
  { 0x6155B286, 32, NDPI_PROTOCOL_TOR },
  { 0x61570E0F, 32, NDPI_PROTOCOL_TOR },
  { 0x61573D40, 32, NDPI_PROTOCOL_TOR },
  { 0x615D1FB9, 32, NDPI_PROTOCOL_TOR },
  { 0x615F20B2, 32, NDPI_PROTOCOL_TOR },
  { 0x61664AC2, 32, NDPI_PROTOCOL_TOR },
  { 0x61664F0E, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8418, 32, NDPI_PROTOCOL_TOR },
  { 0x616B867F, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8A44, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B1C, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8B6C, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8E85, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8EDA, 32, NDPI_PROTOCOL_TOR },
  { 0x616B8EEA, 32, NDPI_PROTOCOL_TOR },
  { 0x61761E24, 32, NDPI_PROTOCOL_TOR },
  { 0x62181813, 32, NDPI_PROTOCOL_TOR },
  { 0x62185496, 32, NDPI_PROTOCOL_TOR },
  { 0x621CA618, 32, NDPI_PROTOCOL_TOR },
  { 0x621CF5EC, 32, NDPI_PROTOCOL_TOR },
  { 0x6241C4D2, 32, NDPI_PROTOCOL_TOR },
  { 0x6245AA0A, 32, NDPI_PROTOCOL_TOR },
  { 0x626538B2, 32, NDPI_PROTOCOL_TOR },
  { 0x626D3882, 32, NDPI_PROTOCOL_TOR },
  { 0x626D7511, 32, NDPI_PROTOCOL_TOR },
  { 0x62726199, 32, NDPI_PROTOCOL_TOR },
  { 0x6274DF81, 32, NDPI_PROTOCOL_TOR },
  { 0x627C74C6, 32, NDPI_PROTOCOL_TOR },
  { 0x628E2F36, 32, NDPI_PROTOCOL_TOR },
  { 0x6296DFDD, 32, NDPI_PROTOCOL_TOR },
  { 0x629B1EED, 32, NDPI_PROTOCOL_TOR },
  { 0x629D1940, 32, NDPI_PROTOCOL_TOR },
  { 0x629D41CC, 32, NDPI_PROTOCOL_TOR },
  { 0x62B436C1, 32, NDPI_PROTOCOL_TOR },
  { 0x62B790F7, 32, NDPI_PROTOCOL_TOR },
  { 0x62C1C54A, 32, NDPI_PROTOCOL_TOR },
  { 0x62C774D0, 32, NDPI_PROTOCOL_TOR },
  { 0x62C925BF, 32, NDPI_PROTOCOL_TOR },
  { 0x62C99217, 32, NDPI_PROTOCOL_TOR },
  { 0x62CEB470, 32, NDPI_PROTOCOL_TOR },
  { 0x62CEB64E, 32, NDPI_PROTOCOL_TOR },
  { 0x62D2A4C6, 32, NDPI_PROTOCOL_TOR },
  { 0x62D6F355, 32, NDPI_PROTOCOL_TOR },
  { 0x62D8A86C, 32, NDPI_PROTOCOL_TOR },
  { 0x62D99D4C, 32, NDPI_PROTOCOL_TOR },
  { 0x62DA3282, 32, NDPI_PROTOCOL_TOR },
  { 0x62DA372F, 32, NDPI_PROTOCOL_TOR },
  { 0x62E0DAEE, 32, NDPI_PROTOCOL_TOR },
  { 0x62E7895E, 32, NDPI_PROTOCOL_TOR },
  { 0x62E818A7, 32, NDPI_PROTOCOL_TOR },
  { 0x62EC4BEC, 32, NDPI_PROTOCOL_TOR },
  { 0x62F5A7CC, 32, NDPI_PROTOCOL_TOR },
  { 0x62F62CE0, 32, NDPI_PROTOCOL_TOR },
  { 0x62F81DE9, 32, NDPI_PROTOCOL_TOR },
  { 0x62FC8D6B, 32, NDPI_PROTOCOL_TOR },
  { 0x62FFC9AB, 32, NDPI_PROTOCOL_TOR },
  { 0x630615BE, 32, NDPI_PROTOCOL_TOR },
  { 0x633F1919, 32, NDPI_PROTOCOL_TOR },
  { 0x635AD476, 32, NDPI_PROTOCOL_TOR },
  { 0x635F8924, 32, NDPI_PROTOCOL_TOR },
  { 0x6363E834, 32, NDPI_PROTOCOL_TOR },
  { 0x6366B2AD, 32, NDPI_PROTOCOL_TOR },
  { 0x63E1049C, 32, NDPI_PROTOCOL_TOR },
  { 0x63E4AB0B, 32, NDPI_PROTOCOL_TOR },
  { 0x63EA2BA0, 32, NDPI_PROTOCOL_TOR },
  { 0x6424B8E6, 32, NDPI_PROTOCOL_TOR },
  { 0x6425681C, 32, NDPI_PROTOCOL_TOR },
  { 0x65339B42, 32, NDPI_PROTOCOL_TOR },
  { 0x6562AEE2, 32, NDPI_PROTOCOL_TOR },
  { 0x65634096, 32, NDPI_PROTOCOL_TOR },
  { 0x658CD912, 32, NDPI_PROTOCOL_TOR },
  { 0x658EC26D, 32, NDPI_PROTOCOL_TOR },
  { 0x65B090B8, 32, NDPI_PROTOCOL_TOR },
  { 0x65BB0480, 32, NDPI_PROTOCOL_TOR },
  { 0x6706D5C6, 32, NDPI_PROTOCOL_TOR },
  { 0x670AC532, 32, NDPI_PROTOCOL_TOR },
  { 0x670AC764, 32, NDPI_PROTOCOL_TOR },
  { 0x67101A47, 32, NDPI_PROTOCOL_TOR },
  { 0x67193810, 32, NDPI_PROTOCOL_TOR },
  { 0x67298435, 32, NDPI_PROTOCOL_TOR },
  { 0x67F05B07, 32, NDPI_PROTOCOL_TOR },
  { 0x67FAB895, 32, NDPI_PROTOCOL_TOR },
  { 0x68091CA1, 32, NDPI_PROTOCOL_TOR },
  { 0x6820195D, 32, NDPI_PROTOCOL_TOR },
  { 0x68218AAE, 32, NDPI_PROTOCOL_TOR },
  { 0x6828018F, 32, NDPI_PROTOCOL_TOR },
  { 0x68288AA6, 32, NDPI_PROTOCOL_TOR },
  { 0x6829028B, 32, NDPI_PROTOCOL_TOR },
  { 0x68311642, 32, NDPI_PROTOCOL_TOR },
  { 0x68804E6B, 32, NDPI_PROTOCOL_TOR },
  { 0x68804E6B, 32, NDPI_PROTOCOL_TOR },
  { 0x68804E6C, 32, NDPI_PROTOCOL_TOR },
  { 0x68804E6C, 32, NDPI_PROTOCOL_TOR },
  { 0x6880AB3E, 32, NDPI_PROTOCOL_TOR },
  { 0x6880E1CB, 32, NDPI_PROTOCOL_TOR },
  { 0x68821999, 32, NDPI_PROTOCOL_TOR },
  { 0x68830974, 32, NDPI_PROTOCOL_TOR },
  { 0x68830C8B, 32, NDPI_PROTOCOL_TOR },
  { 0x68830EAF, 32, NDPI_PROTOCOL_TOR },
  { 0x68831377, 32, NDPI_PROTOCOL_TOR },
  { 0x68831C36, 32, NDPI_PROTOCOL_TOR },
  { 0x68831E06, 32, NDPI_PROTOCOL_TOR },
  { 0x688322AA, 32, NDPI_PROTOCOL_TOR },
  { 0x688322AC, 32, NDPI_PROTOCOL_TOR },
  { 0x68832D66, 32, NDPI_PROTOCOL_TOR },
  { 0x6883335D, 32, NDPI_PROTOCOL_TOR },
  { 0x6883378D, 32, NDPI_PROTOCOL_TOR },
  { 0x688337B8, 32, NDPI_PROTOCOL_TOR },
  { 0x6883387F, 32, NDPI_PROTOCOL_TOR },
  { 0x68833A42, 32, NDPI_PROTOCOL_TOR },
  { 0x68833F50, 32, NDPI_PROTOCOL_TOR },
  { 0x68833F8F, 32, NDPI_PROTOCOL_TOR },
  { 0x688341E1, 32, NDPI_PROTOCOL_TOR },
  { 0x688342C2, 32, NDPI_PROTOCOL_TOR },
  { 0x68834956, 32, NDPI_PROTOCOL_TOR },
  { 0x68834ACF, 32, NDPI_PROTOCOL_TOR },
  { 0x68835F18, 32, NDPI_PROTOCOL_TOR },
  { 0x68836C07, 32, NDPI_PROTOCOL_TOR },
  { 0x68836ED5, 32, NDPI_PROTOCOL_TOR },
  { 0x6883722B, 32, NDPI_PROTOCOL_TOR },
  { 0x68837248, 32, NDPI_PROTOCOL_TOR },
  { 0x688375E7, 32, NDPI_PROTOCOL_TOR },
  { 0x68837B10, 32, NDPI_PROTOCOL_TOR },
  { 0x68837D54, 32, NDPI_PROTOCOL_TOR },
  { 0x6883811E, 32, NDPI_PROTOCOL_TOR },
  { 0x68838182, 32, NDPI_PROTOCOL_TOR },
  { 0x6883862F, 32, NDPI_PROTOCOL_TOR },
  { 0x68839A74, 32, NDPI_PROTOCOL_TOR },
  { 0x6883A6F3, 32, NDPI_PROTOCOL_TOR },
  { 0x6883AC2E, 32, NDPI_PROTOCOL_TOR },
  { 0x6883B5AE, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CC93, 32, NDPI_PROTOCOL_TOR },
  { 0x6883CE17, 32, NDPI_PROTOCOL_TOR },
  { 0x6883D523, 32, NDPI_PROTOCOL_TOR },
  { 0x6883E7F1, 32, NDPI_PROTOCOL_TOR },
  { 0x6883F0A8, 32, NDPI_PROTOCOL_TOR },
  { 0x6883F537, 32, NDPI_PROTOCOL_TOR },
  { 0x689C39C7, 32, NDPI_PROTOCOL_TOR },
  { 0x689C6F36, 32, NDPI_PROTOCOL_TOR },
  { 0x689CE01C, 32, NDPI_PROTOCOL_TOR },
  { 0x689CE053, 32, NDPI_PROTOCOL_TOR },
  { 0x689CEE74, 32, NDPI_PROTOCOL_TOR },
  { 0x689CFD47, 32, NDPI_PROTOCOL_TOR },
  { 0x68A2167C, 32, NDPI_PROTOCOL_TOR },
  { 0x68A762FD, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76304, 32, NDPI_PROTOCOL_TOR },
  { 0x68A7630C, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76458, 32, NDPI_PROTOCOL_TOR },
  { 0x68A764A8, 32, NDPI_PROTOCOL_TOR },
  { 0x68A766F4, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76734, 32, NDPI_PROTOCOL_TOR },
  { 0x68A7695C, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76A2D, 32, NDPI_PROTOCOL_TOR },
  { 0x68A76B8E, 32, NDPI_PROTOCOL_TOR },
  { 0x68A823A8, 32, NDPI_PROTOCOL_TOR },
  { 0x68AE61BA, 32, NDPI_PROTOCOL_TOR },
  { 0x68C81056, 32, NDPI_PROTOCOL_TOR },
  { 0x68C81056, 32, NDPI_PROTOCOL_TOR },
  { 0x68C812B6, 32, NDPI_PROTOCOL_TOR },
  { 0x68C812B6, 32, NDPI_PROTOCOL_TOR },
  { 0x68C8148E, 32, NDPI_PROTOCOL_TOR },
  { 0x68C81841, 32, NDPI_PROTOCOL_TOR },
  { 0x68CEC114, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF802A, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF846D, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF84C9, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF92C8, 32, NDPI_PROTOCOL_TOR },
  { 0x68CF940C, 32, NDPI_PROTOCOL_TOR },
  { 0x68DBB8A6, 32, NDPI_PROTOCOL_TOR },
  { 0x68DD4C83, 32, NDPI_PROTOCOL_TOR },
  { 0x68E0AF68, 32, NDPI_PROTOCOL_TOR },
  { 0x68E80163, 32, NDPI_PROTOCOL_TOR },
  { 0x68E80321, 32, NDPI_PROTOCOL_TOR },
  { 0x68E80323, 32, NDPI_PROTOCOL_TOR },
  { 0x68EADC47, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC0067, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC0658, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC084A, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC1197, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC191C, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC239C, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC26E7, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC27DB, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC2CD2, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC323E, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC3672, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC5353, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC5629, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC575A, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC5DE1, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC6452, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC6E0D, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC8E5D, 32, NDPI_PROTOCOL_TOR },
  { 0x68EC95F9, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECAE0E, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECB3DA, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECB3F0, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECB847, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECD5C1, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECE860, 32, NDPI_PROTOCOL_TOR },
  { 0x68ECFDEC, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8054, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8134, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8134, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED814E, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED818E, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED818E, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED834B, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED834B, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED836B, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8D6D, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED8DC1, 32, NDPI_PROTOCOL_TOR },
  { 0x68ED98C3, 32, NDPI_PROTOCOL_TOR },
  { 0x68F44B5B, 32, NDPI_PROTOCOL_TOR },
  { 0x68F4DFCC, 32, NDPI_PROTOCOL_TOR },
  { 0x68F5274A, 32, NDPI_PROTOCOL_TOR },
  { 0x68FBD208, 32, NDPI_PROTOCOL_TOR },
  { 0x699551A4, 32, NDPI_PROTOCOL_TOR },
  { 0x699AB5D4, 32, NDPI_PROTOCOL_TOR },
  { 0x69EDDE72, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91C19, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91C71, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91C71, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91CAA, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91D5D, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91EEE, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91F81, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB91F81, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB92697, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB9273A, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB9273A, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB930D6, 32, NDPI_PROTOCOL_TOR },
  { 0x6AB930D6, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA109A, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1228, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA12F2, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1892, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA18FE, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1C21, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1D04, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1D2A, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA1E34, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA7229, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA7541, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABA7541, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB23EC, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB24B7, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB259E, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB259E, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB26C6, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2974, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2B6E, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2D9C, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB2F11, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB3444, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB37EF, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB5EFE, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB5EFE, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB60FA, 32, NDPI_PROTOCOL_TOR },
  { 0x6ABB6773, 32, NDPI_PROTOCOL_TOR },
  { 0x6B021E0D, 32, NDPI_PROTOCOL_TOR },
  { 0x6B060491, 32, NDPI_PROTOCOL_TOR },
  { 0x6B14B34B, 32, NDPI_PROTOCOL_TOR },
  { 0x6B812529, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9614F1, 32, NDPI_PROTOCOL_TOR },
  { 0x6B961BC8, 32, NDPI_PROTOCOL_TOR },
  { 0x6B961F6B, 32, NDPI_PROTOCOL_TOR },
  { 0x6B962336, 32, NDPI_PROTOCOL_TOR },
  { 0x6B96268A, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9635B2, 32, NDPI_PROTOCOL_TOR },
  { 0x6B96AA3A, 32, NDPI_PROTOCOL_TOR },
  { 0x6B988F3E, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9B748F, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF15, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF15, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF16, 32, NDPI_PROTOCOL_TOR },
  { 0x6B9EFF16, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA150C3, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA151BB, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA151D0, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA154B9, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA19E11, 32, NDPI_PROTOCOL_TOR },
  { 0x6BA1B357, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA2047, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA3234, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA330E, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA41C5, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA4E2A, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA4F93, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5C89, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5CED, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5D0D, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5D20, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA5D75, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA60EB, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA676F, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA6CDE, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA72CC, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA78D6, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA8F75, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9607, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9950, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAA9ED4, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAABC9B, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAC021, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAC442, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAACC21, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAE84B, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF57F, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF6CC, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAF721, 32, NDPI_PROTOCOL_TOR },
  { 0x6BAAFBB6, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5A60B, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB5AE16, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB613F9, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB68374, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB68388, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB683CF, 32, NDPI_PROTOCOL_TOR },
  { 0x6BB683D3, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF2C9A, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF2ECC, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF3FB8, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF6245, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF6CCB, 32, NDPI_PROTOCOL_TOR },
  { 0x6BBF7EB8, 32, NDPI_PROTOCOL_TOR },
  { 0x6BC4142E, 32, NDPI_PROTOCOL_TOR },
  { 0x6BCB324B, 32, NDPI_PROTOCOL_TOR },
  { 0x6C009C8F, 32, NDPI_PROTOCOL_TOR },
  { 0x6C00C1EF, 32, NDPI_PROTOCOL_TOR },
  { 0x6C00CFF0, 32, NDPI_PROTOCOL_TOR },
  { 0x6C00DF0E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C071024, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0724B4, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0CB2EB, 32, NDPI_PROTOCOL_TOR },
  { 0x6C0E531F, 32, NDPI_PROTOCOL_TOR },
  { 0x6C137138, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1D6B46, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1D75F5, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1E388E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1E3970, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1F2805, 32, NDPI_PROTOCOL_TOR },
  { 0x6C1FDC6E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C203114, 32, NDPI_PROTOCOL_TOR },
  { 0x6C2D5D5E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C309E93, 32, NDPI_PROTOCOL_TOR },
  { 0x6C32EBB6, 32, NDPI_PROTOCOL_TOR },
  { 0x6C33B8DC, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3504D1, 32, NDPI_PROTOCOL_TOR },
  { 0x6C35822A, 32, NDPI_PROTOCOL_TOR },
  { 0x6C36A4AF, 32, NDPI_PROTOCOL_TOR },
  { 0x6C38BD9D, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3A90E8, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3B02D0, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3B0BE1, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA16F, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA1E3, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA457, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA539, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA646, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA6C7, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA7F0, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DA82C, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB16E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB1C3, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB22E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB233, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB2D8, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB3D8, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB691, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB6EC, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB91A, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DB988, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DBCB4, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DC563, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DC6A6, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DC6CF, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DC7B0, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DC7CA, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD0AB, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD150, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD27B, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD35E, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DD466, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DF237, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DFB84, 32, NDPI_PROTOCOL_TOR },
  { 0x6C3DFCED, 32, NDPI_PROTOCOL_TOR },
  { 0x6C45A572, 32, NDPI_PROTOCOL_TOR },
  { 0x6C59AF93, 32, NDPI_PROTOCOL_TOR },
  { 0x6C6FAA05, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA6A1BA, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA6A89E, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA6A8A7, 32, NDPI_PROTOCOL_TOR },
  { 0x6CA8033C, 32, NDPI_PROTOCOL_TOR },
  { 0x6CAA8A76, 32, NDPI_PROTOCOL_TOR },
  { 0x6CB49FFC, 32, NDPI_PROTOCOL_TOR },
  { 0x6CB9E23E, 32, NDPI_PROTOCOL_TOR },
  { 0x6CCC2E0E, 32, NDPI_PROTOCOL_TOR },
  { 0x6CD0E579, 32, NDPI_PROTOCOL_TOR },
  { 0x6CD20668, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF0B68C, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF72296, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF7F4CC, 32, NDPI_PROTOCOL_TOR },
  { 0x6CF857F2, 32, NDPI_PROTOCOL_TOR },
  { 0x6D00AA2D, 32, NDPI_PROTOCOL_TOR },
  { 0x6D00DC98, 32, NDPI_PROTOCOL_TOR },
  { 0x6D163429, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44AE3C, 32, NDPI_PROTOCOL_TOR },
  { 0x6D44BF85, 32, NDPI_PROTOCOL_TOR },
  { 0x6D454311, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4565A5, 32, NDPI_PROTOCOL_TOR },
  { 0x6D49345A, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4A0058, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4A9795, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC247, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC27C, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC3BE, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4AC865, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACC77, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACE0C, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4ACE15, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4BB84D, 32, NDPI_PROTOCOL_TOR },
  { 0x6D4BBD44, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5A17DD, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5AFAB0, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5B68E8, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5B6C94, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5B7013, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5B7DC3, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5E6002, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5FD279, 32, NDPI_PROTOCOL_TOR },
  { 0x6D5FD442, 32, NDPI_PROTOCOL_TOR },
  { 0x6D646686, 32, NDPI_PROTOCOL_TOR },
  { 0x6D64FC83, 32, NDPI_PROTOCOL_TOR },
  { 0x6D682CD1, 32, NDPI_PROTOCOL_TOR },
  { 0x6D696DA2, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6A38E4, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6B239A, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6CDE14, 32, NDPI_PROTOCOL_TOR },
  { 0x6D6F9E13, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78943C, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78AD30, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78B4F5, 32, NDPI_PROTOCOL_TOR },
  { 0x6D78B611, 32, NDPI_PROTOCOL_TOR },
  { 0x6D824D50, 32, NDPI_PROTOCOL_TOR },
  { 0x6D825345, 32, NDPI_PROTOCOL_TOR },
  { 0x6D984A8C, 32, NDPI_PROTOCOL_TOR },
  { 0x6D9BDAB1, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA1226E, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3E9A9, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA02, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA04, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA05, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA07, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA08, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EA09, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EBF6, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA3EBFC, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA4ECE7, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA78802, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA9001D, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA917CA, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA921A3, 32, NDPI_PROTOCOL_TOR },
  { 0x6DA92DE2, 32, NDPI_PROTOCOL_TOR },
  { 0x6DAD3BB4, 32, NDPI_PROTOCOL_TOR },
  { 0x6DB6971F, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBD0643, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBD834C, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBD8F96, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBDB40F, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBE4755, 32, NDPI_PROTOCOL_TOR },
  { 0x6DBE6DE4, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC074AE, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC0CFE9, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC16B54, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC18057, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC2D95A, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC41236, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC50D36, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC53F2D, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC95A10, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC9830B, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC99A8D, 32, NDPI_PROTOCOL_TOR },
  { 0x6DC9C2DB, 32, NDPI_PROTOCOL_TOR },
  { 0x6DCB6C42, 32, NDPI_PROTOCOL_TOR },
  { 0x6DCEBA61, 32, NDPI_PROTOCOL_TOR },
  { 0x6DD412CD, 32, NDPI_PROTOCOL_TOR },
  { 0x6DD414AD, 32, NDPI_PROTOCOL_TOR },
  { 0x6DDA7515, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE4963C, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6E02A, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6EC59, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6EC5F, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE6ECAD, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE97B2C, 32, NDPI_PROTOCOL_TOR },
  { 0x6DE97FE9, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEB32A3, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEC568A, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEF301A, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEF3098, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEF30AE, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEF3103, 32, NDPI_PROTOCOL_TOR },
  { 0x6DEF3C35, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF150E7, 32, NDPI_PROTOCOL_TOR },
  { 0x6DF63848, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFB8A1A, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFF2ED7, 32, NDPI_PROTOCOL_TOR },
  { 0x6DFF69AD, 32, NDPI_PROTOCOL_TOR },
  { 0x6E42E657, 32, NDPI_PROTOCOL_TOR },
  { 0x6E42E657, 32, NDPI_PROTOCOL_TOR },
  { 0x6E5D17AA, 32, NDPI_PROTOCOL_TOR },
  { 0x6EAE2B88, 32, NDPI_PROTOCOL_TOR },
  { 0x6EAFF9CA, 32, NDPI_PROTOCOL_TOR },
  { 0x6F458D7B, 32, NDPI_PROTOCOL_TOR },
  { 0x6F45A280, 32, NDPI_PROTOCOL_TOR },
  { 0x6F59A849, 32, NDPI_PROTOCOL_TOR },
  { 0x6F677B5E, 32, NDPI_PROTOCOL_TOR },
  { 0x6F67ACCD, 32, NDPI_PROTOCOL_TOR },
  { 0x6F76B165, 32, NDPI_PROTOCOL_TOR },
  { 0x6FF8167F, 32, NDPI_PROTOCOL_TOR },
  { 0x70769CA3, 32, NDPI_PROTOCOL_TOR },
  { 0x7078955A, 32, NDPI_PROTOCOL_TOR },
  { 0x707899D7, 32, NDPI_PROTOCOL_TOR },
  { 0x70CDFABD, 32, NDPI_PROTOCOL_TOR },
  { 0x71A37584, 32, NDPI_PROTOCOL_TOR },
  { 0x7225CECB, 32, NDPI_PROTOCOL_TOR },
  { 0x724DE973, 32, NDPI_PROTOCOL_TOR },
  { 0x72860615, 32, NDPI_PROTOCOL_TOR },
  { 0x72BD691E, 32, NDPI_PROTOCOL_TOR },
  { 0x7342A640, 32, NDPI_PROTOCOL_TOR },
  { 0x7346F182, 32, NDPI_PROTOCOL_TOR },
  { 0x73BB4A5B, 32, NDPI_PROTOCOL_TOR },
  { 0x73BB9A6B, 32, NDPI_PROTOCOL_TOR },
  { 0x75124BEB, 32, NDPI_PROTOCOL_TOR },
  { 0x751263F9, 32, NDPI_PROTOCOL_TOR },
  { 0x760C8552, 32, NDPI_PROTOCOL_TOR },
  { 0x768D03A4, 32, NDPI_PROTOCOL_TOR },
  { 0x76AC0D55, 32, NDPI_PROTOCOL_TOR },
  { 0x76C1C25F, 32, NDPI_PROTOCOL_TOR },
  { 0x76D0C22A, 32, NDPI_PROTOCOL_TOR },
  { 0x76D0F817, 32, NDPI_PROTOCOL_TOR },
  { 0x76D3C1BE, 32, NDPI_PROTOCOL_TOR },
  { 0x76D3C2E6, 32, NDPI_PROTOCOL_TOR },
  { 0x77092F46, 32, NDPI_PROTOCOL_TOR },
  { 0x77EDA418, 32, NDPI_PROTOCOL_TOR },
  { 0x77F64734, 32, NDPI_PROTOCOL_TOR },
  { 0x781DD933, 32, NDPI_PROTOCOL_TOR },
  { 0x78339DD3, 32, NDPI_PROTOCOL_TOR },
  { 0x7839A32E, 32, NDPI_PROTOCOL_TOR },
  { 0x783B2AC8, 32, NDPI_PROTOCOL_TOR },
  { 0x783BA789, 32, NDPI_PROTOCOL_TOR },
  { 0x784AE0A4, 32, NDPI_PROTOCOL_TOR },
  { 0x7890BEA2, 32, NDPI_PROTOCOL_TOR },
  { 0x7936AF32, 32, NDPI_PROTOCOL_TOR },
  { 0x794953C0, 32, NDPI_PROTOCOL_TOR },
  { 0x7954959D, 32, NDPI_PROTOCOL_TOR },
  { 0x79623AD3, 32, NDPI_PROTOCOL_TOR },
  { 0x79628113, 32, NDPI_PROTOCOL_TOR },
  { 0x7963582E, 32, NDPI_PROTOCOL_TOR },
  { 0x7963B8C8, 32, NDPI_PROTOCOL_TOR },
  { 0x7972B51D, 32, NDPI_PROTOCOL_TOR },
  { 0x797AA193, 32, NDPI_PROTOCOL_TOR },
  { 0x79D1E5D4, 32, NDPI_PROTOCOL_TOR },
  { 0x79D34C57, 32, NDPI_PROTOCOL_TOR },
  { 0x79D3C2E6, 32, NDPI_PROTOCOL_TOR },
  { 0x7A744433, 32, NDPI_PROTOCOL_TOR },
  { 0x7B01A089, 32, NDPI_PROTOCOL_TOR },
  { 0x7B64357A, 32, NDPI_PROTOCOL_TOR },
  { 0x7B6CE046, 32, NDPI_PROTOCOL_TOR },
  { 0x7BDDB10E, 32, NDPI_PROTOCOL_TOR },
  { 0x7C0DAC95, 32, NDPI_PROTOCOL_TOR },
  { 0x7C18F2DD, 32, NDPI_PROTOCOL_TOR },
  { 0x7C67D84F, 32, NDPI_PROTOCOL_TOR },
  { 0x7C6DE896, 32, NDPI_PROTOCOL_TOR },
  { 0x7C951525, 32, NDPI_PROTOCOL_TOR },
  { 0x7CA9666D, 32, NDPI_PROTOCOL_TOR },
  { 0x7CA981CA, 32, NDPI_PROTOCOL_TOR },
  { 0x7CF8F9F5, 32, NDPI_PROTOCOL_TOR },
  { 0x7CF8F9F7, 32, NDPI_PROTOCOL_TOR },
  { 0x7CF8F9FA, 32, NDPI_PROTOCOL_TOR },
  { 0x7CF8F9FD, 32, NDPI_PROTOCOL_TOR },
  { 0x7D1E5578, 32, NDPI_PROTOCOL_TOR },
  { 0x7D352C26, 32, NDPI_PROTOCOL_TOR },
  { 0x7D83BD18, 32, NDPI_PROTOCOL_TOR },
  { 0x7D83BD2C, 32, NDPI_PROTOCOL_TOR },
  { 0x7DECCCB2, 32, NDPI_PROTOCOL_TOR },
  { 0x7DFF021E, 32, NDPI_PROTOCOL_TOR },
  { 0x7E08CD97, 32, NDPI_PROTOCOL_TOR },
  { 0x7E460792, 32, NDPI_PROTOCOL_TOR },
  { 0x7E57F79D, 32, NDPI_PROTOCOL_TOR },
  { 0x8006E06B, 32, NDPI_PROTOCOL_TOR },
  { 0x800CB13B, 32, NDPI_PROTOCOL_TOR },
  { 0x800CE238, 32, NDPI_PROTOCOL_TOR },
  { 0x800CE238, 32, NDPI_PROTOCOL_TOR },
  { 0x800CE252, 32, NDPI_PROTOCOL_TOR },
  { 0x800CE252, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0022, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0022, 32, NDPI_PROTOCOL_TOR },
  { 0x801F0027, 32, NDPI_PROTOCOL_TOR },
  { 0x80270844, 32, NDPI_PROTOCOL_TOR },
  { 0x80278E14, 32, NDPI_PROTOCOL_TOR },
  { 0x80278E15, 32, NDPI_PROTOCOL_TOR },
  { 0x80348069, 32, NDPI_PROTOCOL_TOR },
  { 0x8034A014, 32, NDPI_PROTOCOL_TOR },
  { 0x80392F1E, 32, NDPI_PROTOCOL_TOR },
  { 0x803B1279, 32, NDPI_PROTOCOL_TOR },
  { 0x804490CE, 32, NDPI_PROTOCOL_TOR },
  { 0x80473391, 32, NDPI_PROTOCOL_TOR },
  { 0x804910C0, 32, NDPI_PROTOCOL_TOR },
  { 0x804F35F4, 32, NDPI_PROTOCOL_TOR },
  { 0x804FBA39, 32, NDPI_PROTOCOL_TOR },
  { 0x80752B5C, 32, NDPI_PROTOCOL_TOR },
  { 0x80752B61, 32, NDPI_PROTOCOL_TOR },
  { 0x80752B61, 32, NDPI_PROTOCOL_TOR },
  { 0x807F2860, 32, NDPI_PROTOCOL_TOR },
  { 0x8082CC5B, 32, NDPI_PROTOCOL_TOR },
  { 0x8087BD74, 32, NDPI_PROTOCOL_TOR },
  { 0x80AD374E, 32, NDPI_PROTOCOL_TOR },
  { 0x80B1AA5A, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7227A, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72305, 32, NDPI_PROTOCOL_TOR },
  { 0x80C723BF, 32, NDPI_PROTOCOL_TOR },
  { 0x80C729EE, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72A6C, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72C2E, 32, NDPI_PROTOCOL_TOR },
  { 0x80C72EDC, 32, NDPI_PROTOCOL_TOR },
  { 0x80C733D0, 32, NDPI_PROTOCOL_TOR },
  { 0x80C737CF, 32, NDPI_PROTOCOL_TOR },
  { 0x80C73947, 32, NDPI_PROTOCOL_TOR },
  { 0x80C73F21, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7404F, 32, NDPI_PROTOCOL_TOR },
  { 0x80C74471, 32, NDPI_PROTOCOL_TOR },
  { 0x80C748B6, 32, NDPI_PROTOCOL_TOR },
  { 0x80C74AE2, 32, NDPI_PROTOCOL_TOR },
  { 0x80C753BB, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7579B, 32, NDPI_PROTOCOL_TOR },
  { 0x80C75F79, 32, NDPI_PROTOCOL_TOR },
  { 0x80C75F7E, 32, NDPI_PROTOCOL_TOR },
  { 0x80C76AE6, 32, NDPI_PROTOCOL_TOR },
  { 0x80C77A68, 32, NDPI_PROTOCOL_TOR },
  { 0x80C77A76, 32, NDPI_PROTOCOL_TOR },
  { 0x80C77B13, 32, NDPI_PROTOCOL_TOR },
  { 0x80C782E3, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78407, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78548, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7859A, 32, NDPI_PROTOCOL_TOR },
  { 0x80C78BEC, 32, NDPI_PROTOCOL_TOR },
  { 0x80C79053, 32, NDPI_PROTOCOL_TOR },
  { 0x80C794F3, 32, NDPI_PROTOCOL_TOR },
  { 0x80C797C2, 32, NDPI_PROTOCOL_TOR },
  { 0x80C79A84, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7A56E, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7A5D4, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7A88E, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7AEF7, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7AF45, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7B364, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7B654, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7B73B, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7D4DC, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7D647, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7D9F3, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7E434, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7ECBE, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F0C1, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F24B, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7F4CE, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7FA9F, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7FCC5, 32, NDPI_PROTOCOL_TOR },
  { 0x80C7FD9C, 32, NDPI_PROTOCOL_TOR },
  { 0x80D002E9, 32, NDPI_PROTOCOL_TOR },
  { 0x80DF5C53, 32, NDPI_PROTOCOL_TOR },
  { 0x80E81239, 32, NDPI_PROTOCOL_TOR },
  { 0x80ED9D72, 32, NDPI_PROTOCOL_TOR },
  { 0x810A78C1, 32, NDPI_PROTOCOL_TOR },
  { 0x811583C0, 32, NDPI_PROTOCOL_TOR },
  { 0x81400893, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0706, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0706, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0707, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0707, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0708, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0708, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0727, 32, NDPI_PROTOCOL_TOR },
  { 0x817B0727, 32, NDPI_PROTOCOL_TOR },
  { 0x817FFED5, 32, NDPI_PROTOCOL_TOR },
  { 0x818200B7, 32, NDPI_PROTOCOL_TOR },
  { 0x8185081F, 32, NDPI_PROTOCOL_TOR },
  { 0x81BB3621, 32, NDPI_PROTOCOL_TOR },
  { 0x81F1A1FA, 32, NDPI_PROTOCOL_TOR },
  { 0x81F480A9, 32, NDPI_PROTOCOL_TOR },
  { 0x820FBD2D, 32, NDPI_PROTOCOL_TOR },
  { 0x82192C69, 32, NDPI_PROTOCOL_TOR },
  { 0x823FAD7E, 32, NDPI_PROTOCOL_TOR },
  { 0x824B51FB, 32, NDPI_PROTOCOL_TOR },
  { 0x824BB225, 32, NDPI_PROTOCOL_TOR },
  { 0x827B031B, 32, NDPI_PROTOCOL_TOR },
  { 0x827E8EAB, 32, NDPI_PROTOCOL_TOR },
  { 0x8284B17E, 32, NDPI_PROTOCOL_TOR },
  { 0x82950E1F, 32, NDPI_PROTOCOL_TOR },
  { 0x8295C80C, 32, NDPI_PROTOCOL_TOR },
  { 0x8295CB6B, 32, NDPI_PROTOCOL_TOR },
  { 0x8295DC7D, 32, NDPI_PROTOCOL_TOR },
  { 0x82B417E6, 32, NDPI_PROTOCOL_TOR },
  { 0x82B43F96, 32, NDPI_PROTOCOL_TOR },
  { 0x82B84B76, 32, NDPI_PROTOCOL_TOR },
  { 0x82FD157B, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF48A4, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF49CA, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF49CA, 32, NDPI_PROTOCOL_TOR },
  { 0x82FF8242, 32, NDPI_PROTOCOL_TOR },
  { 0x83488818, 32, NDPI_PROTOCOL_TOR },
  { 0x83488A0B, 32, NDPI_PROTOCOL_TOR },
  { 0x83AD8008, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC180E, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BC, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BD, 32, NDPI_PROTOCOL_TOR },
  { 0x83BC28BD, 32, NDPI_PROTOCOL_TOR },
  { 0x83D79EED, 32, NDPI_PROTOCOL_TOR },
  { 0x83D7A8F2, 32, NDPI_PROTOCOL_TOR },
  { 0x83D7ACD6, 32, NDPI_PROTOCOL_TOR },
  { 0x83D7B062, 32, NDPI_PROTOCOL_TOR },
  { 0x84D83602, 32, NDPI_PROTOCOL_TOR },
  { 0x84E69651, 32, NDPI_PROTOCOL_TOR },
  { 0x84F81E0C, 32, NDPI_PROTOCOL_TOR },
  { 0x84FBE6E3, 32, NDPI_PROTOCOL_TOR },
  { 0x86001A20, 32, NDPI_PROTOCOL_TOR },
  { 0x86036F77, 32, NDPI_PROTOCOL_TOR },
  { 0x8603C987, 32, NDPI_PROTOCOL_TOR },
  { 0x8603EA32, 32, NDPI_PROTOCOL_TOR },
  { 0x86227D25, 32, NDPI_PROTOCOL_TOR },
  { 0x86227D44, 32, NDPI_PROTOCOL_TOR },
  { 0x862293AF, 32, NDPI_PROTOCOL_TOR },
  { 0x8622D0E9, 32, NDPI_PROTOCOL_TOR },
  { 0x8631E0BC, 32, NDPI_PROTOCOL_TOR },
  { 0x865B4E8F, 32, NDPI_PROTOCOL_TOR },
  { 0x865D88B1, 32, NDPI_PROTOCOL_TOR },
  { 0x86604111, 32, NDPI_PROTOCOL_TOR },
  { 0x866370A8, 32, NDPI_PROTOCOL_TOR },
  { 0x8666C865, 32, NDPI_PROTOCOL_TOR },
  { 0x866A03FE, 32, NDPI_PROTOCOL_TOR },
  { 0x867703A4, 32, NDPI_PROTOCOL_TOR },
  { 0x8679405D, 32, NDPI_PROTOCOL_TOR },
  { 0x8679436A, 32, NDPI_PROTOCOL_TOR },
  { 0x86A95CDB, 32, NDPI_PROTOCOL_TOR },
  { 0x86E2441D, 32, NDPI_PROTOCOL_TOR },
  { 0x86F993AE, 32, NDPI_PROTOCOL_TOR },
  { 0x86FFEF3D, 32, NDPI_PROTOCOL_TOR },
  { 0x88A8C999, 32, NDPI_PROTOCOL_TOR },
  { 0x88F307AF, 32, NDPI_PROTOCOL_TOR },
  { 0x88F30E86, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3E072, 32, NDPI_PROTOCOL_TOR },
  { 0x88F3E072, 32, NDPI_PROTOCOL_TOR },
  { 0x898708E9, 32, NDPI_PROTOCOL_TOR },
  { 0x899306B0, 32, NDPI_PROTOCOL_TOR },
  { 0x89CD25DB, 32, NDPI_PROTOCOL_TOR },
  { 0x89CD7C23, 32, NDPI_PROTOCOL_TOR },
  { 0x89E0E221, 32, NDPI_PROTOCOL_TOR },
  { 0x89E23B7F, 32, NDPI_PROTOCOL_TOR },
  { 0x89E2952B, 32, NDPI_PROTOCOL_TOR },
  { 0x89F87A44, 32, NDPI_PROTOCOL_TOR },
  { 0x8A640AD1, 32, NDPI_PROTOCOL_TOR },
  { 0x8A6E2D26, 32, NDPI_PROTOCOL_TOR },
  { 0x8A807C37, 32, NDPI_PROTOCOL_TOR },
  { 0x8A80A9EC, 32, NDPI_PROTOCOL_TOR },
  { 0x8B0E0DEC, 32, NDPI_PROTOCOL_TOR },
  { 0x8B4E8DF7, 32, NDPI_PROTOCOL_TOR },
  { 0x8B5B466B, 32, NDPI_PROTOCOL_TOR },
  { 0x8C716E0B, 32, NDPI_PROTOCOL_TOR },
  { 0x8C795022, 32, NDPI_PROTOCOL_TOR },
  { 0x8C79502A, 32, NDPI_PROTOCOL_TOR },
  { 0x8CB4BEBF, 32, NDPI_PROTOCOL_TOR },
  { 0x8CBA4630, 32, NDPI_PROTOCOL_TOR },
  { 0x8CC0DA8B, 32, NDPI_PROTOCOL_TOR },
  { 0x8D0015F2, 32, NDPI_PROTOCOL_TOR },
  { 0x8D009B6D, 32, NDPI_PROTOCOL_TOR },
  { 0x8D00AF95, 32, NDPI_PROTOCOL_TOR },
  { 0x8D142144, 32, NDPI_PROTOCOL_TOR },
  { 0x8D142145, 32, NDPI_PROTOCOL_TOR },
  { 0x8D14214F, 32, NDPI_PROTOCOL_TOR },
  { 0x8D369FB8, 32, NDPI_PROTOCOL_TOR },
  { 0x8D466911, 32, NDPI_PROTOCOL_TOR },
  { 0x8D8A8A88, 32, NDPI_PROTOCOL_TOR },
  { 0x8D8A8DD0, 32, NDPI_PROTOCOL_TOR },
  { 0x8D8AC2E4, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA58A, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFA77A, 32, NDPI_PROTOCOL_TOR },
  { 0x8DFFBDA1, 32, NDPI_PROTOCOL_TOR },
  { 0x8E0420C4, 32, NDPI_PROTOCOL_TOR },
  { 0x8E0433E4, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04CF3B, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D0A7, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D519, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D571, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D726, 32, NDPI_PROTOCOL_TOR },
  { 0x8E04D757, 32, NDPI_PROTOCOL_TOR },
  { 0x8E36B0B2, 32, NDPI_PROTOCOL_TOR },
  { 0x8E69D044, 32, NDPI_PROTOCOL_TOR },
  { 0x8FB128C0, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0626, 32, NDPI_PROTOCOL_TOR },
  { 0x904C063B, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0849, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0B64, 32, NDPI_PROTOCOL_TOR },
  { 0x904C0E91, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1DD0, 32, NDPI_PROTOCOL_TOR },
  { 0x904C1EA7, 32, NDPI_PROTOCOL_TOR },
  { 0x904C25F2, 32, NDPI_PROTOCOL_TOR },
  { 0x904C27CA, 32, NDPI_PROTOCOL_TOR },
  { 0x904C2879, 32, NDPI_PROTOCOL_TOR },
  { 0x904C3225, 32, NDPI_PROTOCOL_TOR },
  { 0x904C357D, 32, NDPI_PROTOCOL_TOR },
  { 0x904C3635, 32, NDPI_PROTOCOL_TOR },
  { 0x904C4042, 32, NDPI_PROTOCOL_TOR },
  { 0x904C498C, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5044, 32, NDPI_PROTOCOL_TOR },
  { 0x904C5B87, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6007, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6439, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6E67, 32, NDPI_PROTOCOL_TOR },
  { 0x904C6E67, 32, NDPI_PROTOCOL_TOR },
  { 0x904C7055, 32, NDPI_PROTOCOL_TOR },
  { 0x904C7EB3, 32, NDPI_PROTOCOL_TOR },
  { 0x904C7FA5, 32, NDPI_PROTOCOL_TOR },
  { 0x904C8023, 32, NDPI_PROTOCOL_TOR },
  { 0x904C832A, 32, NDPI_PROTOCOL_TOR },
  { 0x904C95CB, 32, NDPI_PROTOCOL_TOR },
  { 0x904C9C65, 32, NDPI_PROTOCOL_TOR },
  { 0x904CA35D, 32, NDPI_PROTOCOL_TOR },
  { 0x904CB037, 32, NDPI_PROTOCOL_TOR },
  { 0x904CB6CA, 32, NDPI_PROTOCOL_TOR },
  { 0x904CC3E4, 32, NDPI_PROTOCOL_TOR },
  { 0x904CC728, 32, NDPI_PROTOCOL_TOR },
  { 0x904CCB75, 32, NDPI_PROTOCOL_TOR },
  { 0x904CF413, 32, NDPI_PROTOCOL_TOR },
  { 0x904CFD04, 32, NDPI_PROTOCOL_TOR },
  { 0x91DC000F, 32, NDPI_PROTOCOL_TOR },
  { 0x92002090, 32, NDPI_PROTOCOL_TOR },
  { 0x92002A3A, 32, NDPI_PROTOCOL_TOR },
  { 0x92002A6E, 32, NDPI_PROTOCOL_TOR },
  { 0x920048B4, 32, NDPI_PROTOCOL_TOR },
  { 0x920049B2, 32, NDPI_PROTOCOL_TOR },
  { 0x923434C7, 32, NDPI_PROTOCOL_TOR },
  { 0x9234419F, 32, NDPI_PROTOCOL_TOR },
  { 0x92344BB3, 32, NDPI_PROTOCOL_TOR },
  { 0x923490FC, 32, NDPI_PROTOCOL_TOR },
  { 0x92349273, 32, NDPI_PROTOCOL_TOR },
  { 0x925A1CB7, 32, NDPI_PROTOCOL_TOR },
  { 0x9273A850, 32, NDPI_PROTOCOL_TOR },
  { 0x92B915A6, 32, NDPI_PROTOCOL_TOR },
  { 0x92B983AF, 32, NDPI_PROTOCOL_TOR },
  { 0x92B983EF, 32, NDPI_PROTOCOL_TOR },
  { 0x92B988DF, 32, NDPI_PROTOCOL_TOR },
  { 0x92B98D39, 32, NDPI_PROTOCOL_TOR },
  { 0x92B98F90, 32, NDPI_PROTOCOL_TOR },
  { 0x92B996DB, 32, NDPI_PROTOCOL_TOR },
  { 0x92B99939, 32, NDPI_PROTOCOL_TOR },
  { 0x92B99FF1, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9A2EB, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B440, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B70D, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9B99A, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9BDC5, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FB5A, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FDCA, 32, NDPI_PROTOCOL_TOR },
  { 0x92B9FDCA, 32, NDPI_PROTOCOL_TOR },
  { 0x92FF39E4, 32, NDPI_PROTOCOL_TOR },
  { 0x93459FC4, 32, NDPI_PROTOCOL_TOR },
  { 0x93660115, 32, NDPI_PROTOCOL_TOR },
  { 0x9366D8F2, 32, NDPI_PROTOCOL_TOR },
  { 0x93AFBB8F, 32, NDPI_PROTOCOL_TOR },
  { 0x93DEA58B, 32, NDPI_PROTOCOL_TOR },
  { 0x93E5081A, 32, NDPI_PROTOCOL_TOR },
  { 0x946429FB, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB1431, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB2832, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB2BE9, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB2D87, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB431B, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB4566, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB4D64, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB53C4, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB5884, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB71E6, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB7DD3, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB809C, 32, NDPI_PROTOCOL_TOR },
  { 0x94FB97BD, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBBEE5, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBCE86, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBCF24, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBD7E9, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBD7F4, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBE30E, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBED4F, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBF597, 32, NDPI_PROTOCOL_TOR },
  { 0x94FBFEE5, 32, NDPI_PROTOCOL_TOR },
  { 0x9509001B, 32, NDPI_PROTOCOL_TOR },
  { 0x9509003B, 32, NDPI_PROTOCOL_TOR },
  { 0x9509003C, 32, NDPI_PROTOCOL_TOR },
  { 0x951436DA, 32, NDPI_PROTOCOL_TOR },
  { 0x958405BD, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9810, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9879, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9A92, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9D50, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9E7A, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9EE4, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9F57, 32, NDPI_PROTOCOL_TOR },
  { 0x959A9FAC, 32, NDPI_PROTOCOL_TOR },
  { 0x95ACC7F4, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2AB45, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2ADF7, 32, NDPI_PROTOCOL_TOR },
  { 0x95D2BAC6, 32, NDPI_PROTOCOL_TOR },
  { 0x95FF6DC9, 32, NDPI_PROTOCOL_TOR },
  { 0x96659DFA, 32, NDPI_PROTOCOL_TOR },
  { 0x968C0522, 32, NDPI_PROTOCOL_TOR },
  { 0x971B08A4, 32, NDPI_PROTOCOL_TOR },
  { 0x971DFD3F, 32, NDPI_PROTOCOL_TOR },
  { 0x971FA3B8, 32, NDPI_PROTOCOL_TOR },
  { 0x9741F79A, 32, NDPI_PROTOCOL_TOR },
  { 0x97507745, 32, NDPI_PROTOCOL_TOR },
  { 0x97507758, 32, NDPI_PROTOCOL_TOR },
  { 0x9750800C, 32, NDPI_PROTOCOL_TOR },
  { 0x9750A491, 32, NDPI_PROTOCOL_TOR },
  { 0x97E04B76, 32, NDPI_PROTOCOL_TOR },
  { 0x97E2D38D, 32, NDPI_PROTOCOL_TOR },
  { 0x97E5201B, 32, NDPI_PROTOCOL_TOR },
  { 0x97E65FF1, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC049E, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0506, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC061B, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0670, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC06C2, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC06C6, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC07B1, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0B72, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC0E61, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC160C, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC171F, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC172C, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC1839, 32, NDPI_PROTOCOL_TOR },
  { 0x97EC18E4, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDA43, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDD2C, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDE1B, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDE1B, 32, NDPI_PROTOCOL_TOR },
  { 0x97ECDED9, 32, NDPI_PROTOCOL_TOR },
  { 0x97FC2A46, 32, NDPI_PROTOCOL_TOR },
  { 0x99782A89, 32, NDPI_PROTOCOL_TOR },
  { 0x997925A6, 32, NDPI_PROTOCOL_TOR },
  { 0x997938DD, 32, NDPI_PROTOCOL_TOR },
  { 0x99793A49, 32, NDPI_PROTOCOL_TOR },
  { 0x997FFB43, 32, NDPI_PROTOCOL_TOR },
  { 0x9A23AFE1, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3C42, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3D62, 32, NDPI_PROTOCOL_TOR },
  { 0x9A7F3D8D, 32, NDPI_PROTOCOL_TOR },
  { 0x9B5EA7C4, 32, NDPI_PROTOCOL_TOR },
  { 0x9BD2EF58, 32, NDPI_PROTOCOL_TOR },
  { 0x9C38FAE3, 32, NDPI_PROTOCOL_TOR },
  { 0x9D0757B8, 32, NDPI_PROTOCOL_TOR },
  { 0x9D07CA47, 32, NDPI_PROTOCOL_TOR },
  { 0x9D07D224, 32, NDPI_PROTOCOL_TOR },
  { 0x9D07DEE2, 32, NDPI_PROTOCOL_TOR },
  { 0x9D0EF604, 32, NDPI_PROTOCOL_TOR },
  { 0x9E3AA97E, 32, NDPI_PROTOCOL_TOR },
  { 0x9E554D57, 32, NDPI_PROTOCOL_TOR },
  { 0x9EB53326, 32, NDPI_PROTOCOL_TOR },
  { 0x9EB552B2, 32, NDPI_PROTOCOL_TOR },
  { 0x9EB560E3, 32, NDPI_PROTOCOL_TOR },
  { 0x9EDE8F19, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD4B3, 32, NDPI_PROTOCOL_TOR },
  { 0x9EFFD729, 32, NDPI_PROTOCOL_TOR },
  { 0x9F94B55A, 32, NDPI_PROTOCOL_TOR },
  { 0xA0612F1E, 32, NDPI_PROTOCOL_TOR },
  { 0xA1357425, 32, NDPI_PROTOCOL_TOR },
  { 0xA1357898, 32, NDPI_PROTOCOL_TOR },
  { 0xA135A068, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D3D985, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D3E0E9, 32, NDPI_PROTOCOL_TOR },
  { 0xA2D813ED, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DA417E, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DA760C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DAD084, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DAE92B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DB02B1, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DC2FB8, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DC38BA, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCD94C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCDA6D, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DCF1DF, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DDC939, 32, NDPI_PROTOCOL_TOR },
  { 0xA2DEA01D, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F307B4, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F317DD, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F320CA, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F323FB, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F32725, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F328A1, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F33089, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F33543, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3354B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F33EEF, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F348C6, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3499C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F35F80, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F364E1, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3656E, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F367AE, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F371B6, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F37479, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F37734, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F377F6, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F37BDC, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F386E0, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F38B4E, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F38E6B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3969C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F396E5, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3971B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F39C7A, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3A25C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3F878, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F3FD76, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F418ED, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F419BA, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F419D6, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F41A09, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F41A9D, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F41D7C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F422A9, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F52912, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F5D9D0, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F5DC86, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F5DC8C, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F74807, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F7481B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C7, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C8, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748C9, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D4, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D5, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D8, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F748D9, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F7494A, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749CC, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F749CE, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F809ED, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F80B06, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F80BB0, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F88C65, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F88E67, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F88F29, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A033, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A053, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A090, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A097, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A1D5, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A3CA, 32, NDPI_PROTOCOL_TOR },
  { 0xA2F8A50E, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FAE9C2, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FAEA7D, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FB463A, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FB463A, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCCC3E, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCF079, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCF17B, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FCF20D, 32, NDPI_PROTOCOL_TOR },
  { 0xA2FE4436, 32, NDPI_PROTOCOL_TOR },
  { 0xA40FA707, 32, NDPI_PROTOCOL_TOR },
  { 0xA4272AFE, 32, NDPI_PROTOCOL_TOR },
  { 0xA57B94C7, 32, NDPI_PROTOCOL_TOR },
  { 0xA5FEFF10, 32, NDPI_PROTOCOL_TOR },
  { 0xA5FEFF10, 32, NDPI_PROTOCOL_TOR },
  { 0xA6460F0E, 32, NDPI_PROTOCOL_TOR },
  { 0xA6465E6A, 32, NDPI_PROTOCOL_TOR },
  { 0xA646CF02, 32, NDPI_PROTOCOL_TOR },
  { 0xA646D4B5, 32, NDPI_PROTOCOL_TOR },
  { 0xA64E0721, 32, NDPI_PROTOCOL_TOR },
  { 0xA65215C8, 32, NDPI_PROTOCOL_TOR },
  { 0xA6540737, 32, NDPI_PROTOCOL_TOR },
  { 0xA6540794, 32, NDPI_PROTOCOL_TOR },
  { 0xA7397143, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582348, 32, NDPI_PROTOCOL_TOR },
  { 0xA758283F, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582898, 32, NDPI_PROTOCOL_TOR },
  { 0xA75828C8, 32, NDPI_PROTOCOL_TOR },
  { 0xA75829BB, 32, NDPI_PROTOCOL_TOR },
  { 0xA75829C2, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582BF6, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582C32, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582C33, 32, NDPI_PROTOCOL_TOR },
  { 0xA7582C34, 32, NDPI_PROTOCOL_TOR },
  { 0xA7587066, 32, NDPI_PROTOCOL_TOR },
  { 0xA7587D43, 32, NDPI_PROTOCOL_TOR },
  { 0xA77202C0, 32, NDPI_PROTOCOL_TOR },
  { 0xA7720390, 32, NDPI_PROTOCOL_TOR },
  { 0xA77203A6, 32, NDPI_PROTOCOL_TOR },
  { 0xA772243E, 32, NDPI_PROTOCOL_TOR },
  { 0xA7722489, 32, NDPI_PROTOCOL_TOR },
  { 0xA77229D3, 32, NDPI_PROTOCOL_TOR },
  { 0xA77229D3, 32, NDPI_PROTOCOL_TOR },
  { 0xA77229D4, 32, NDPI_PROTOCOL_TOR },
  { 0xA77229D4, 32, NDPI_PROTOCOL_TOR },
  { 0xA772423D, 32, NDPI_PROTOCOL_TOR },
  { 0xA77243CC, 32, NDPI_PROTOCOL_TOR },
  { 0xA77243D4, 32, NDPI_PROTOCOL_TOR },
  { 0xA7724418, 32, NDPI_PROTOCOL_TOR },
  { 0xA7724726, 32, NDPI_PROTOCOL_TOR },
  { 0xA77247BD, 32, NDPI_PROTOCOL_TOR },
  { 0xA7726116, 32, NDPI_PROTOCOL_TOR },
  { 0xA772629A, 32, NDPI_PROTOCOL_TOR },
  { 0xA772712E, 32, NDPI_PROTOCOL_TOR },
  { 0xA7727130, 32, NDPI_PROTOCOL_TOR },
  { 0xA7727288, 32, NDPI_PROTOCOL_TOR },
  { 0xA77272D1, 32, NDPI_PROTOCOL_TOR },
  { 0xA7729864, 32, NDPI_PROTOCOL_TOR },
  { 0xA7A02CC2, 32, NDPI_PROTOCOL_TOR },
  { 0xA7A02CE2, 32, NDPI_PROTOCOL_TOR },
  { 0xA7A0A39A, 32, NDPI_PROTOCOL_TOR },
  { 0xA83ED9D8, 32, NDPI_PROTOCOL_TOR },
  { 0xA867C3FA, 32, NDPI_PROTOCOL_TOR },
  { 0xA896FB0F, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB91AF, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9238, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9239, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB935E, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9361, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9664, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9A60, 32, NDPI_PROTOCOL_TOR },
  { 0xA8EB9CA2, 32, NDPI_PROTOCOL_TOR },
  { 0xA9E57D1B, 32, NDPI_PROTOCOL_TOR },
  { 0xA9E57D1B, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4BA251, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4BA257, 32, NDPI_PROTOCOL_TOR },
  { 0xAA4BA3B4, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C109, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C114, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14D, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C14E, 32, NDPI_PROTOCOL_TOR },
  { 0xAB19C1EB, 32, NDPI_PROTOCOL_TOR },
  { 0xAB655D88, 32, NDPI_PROTOCOL_TOR },
  { 0xAC07A4C5, 32, NDPI_PROTOCOL_TOR },
  { 0xACF51678, 32, NDPI_PROTOCOL_TOR },
  { 0xACF520B9, 32, NDPI_PROTOCOL_TOR },
  { 0xACF520BA, 32, NDPI_PROTOCOL_TOR },
  { 0xACF521F9, 32, NDPI_PROTOCOL_TOR },
  { 0xACF52416, 32, NDPI_PROTOCOL_TOR },
  { 0xACF53C64, 32, NDPI_PROTOCOL_TOR },
  { 0xACF5DB85, 32, NDPI_PROTOCOL_TOR },
  { 0xACFE0D7C, 32, NDPI_PROTOCOL_TOR },
  { 0xAD08664C, 32, NDPI_PROTOCOL_TOR },
  { 0xAD0B116C, 32, NDPI_PROTOCOL_TOR },
  { 0xAD0D8D1C, 32, NDPI_PROTOCOL_TOR },
  { 0xAD10B454, 32, NDPI_PROTOCOL_TOR },
  { 0xAD12E604, 32, NDPI_PROTOCOL_TOR },
  { 0xAD16F0E2, 32, NDPI_PROTOCOL_TOR },
  { 0xAD172ADB, 32, NDPI_PROTOCOL_TOR },
  { 0xAD1C491B, 32, NDPI_PROTOCOL_TOR },
  { 0xAD2C23B2, 32, NDPI_PROTOCOL_TOR },
  { 0xAD2C3ACA, 32, NDPI_PROTOCOL_TOR },
  { 0xAD2DE436, 32, NDPI_PROTOCOL_TOR },
  { 0xAD304BF6, 32, NDPI_PROTOCOL_TOR },
  { 0xAD30B617, 32, NDPI_PROTOCOL_TOR },
  { 0xAD335037, 32, NDPI_PROTOCOL_TOR },
  { 0xAD33C620, 32, NDPI_PROTOCOL_TOR },
  { 0xAD36711E, 32, NDPI_PROTOCOL_TOR },
  { 0xAD40C757, 32, NDPI_PROTOCOL_TOR },
  { 0xAD427043, 32, NDPI_PROTOCOL_TOR },
  { 0xAD45B52A, 32, NDPI_PROTOCOL_TOR },
  { 0xAD469914, 32, NDPI_PROTOCOL_TOR },
  { 0xAD46DD71, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4717F9, 32, NDPI_PROTOCOL_TOR },
  { 0xAD479C14, 32, NDPI_PROTOCOL_TOR },
  { 0xAD49717D, 32, NDPI_PROTOCOL_TOR },
  { 0xAD4CA387, 32, NDPI_PROTOCOL_TOR },
  { 0xAD5980AC, 32, NDPI_PROTOCOL_TOR },
  { 0xADA0B4BD, 32, NDPI_PROTOCOL_TOR },
  { 0xADA103A9, 32, NDPI_PROTOCOL_TOR },
  { 0xADA48BC3, 32, NDPI_PROTOCOL_TOR },
  { 0xADA4CEB5, 32, NDPI_PROTOCOL_TOR },
  { 0xADA4DBFA, 32, NDPI_PROTOCOL_TOR },
  { 0xADA5F099, 32, NDPI_PROTOCOL_TOR },
  { 0xADA71245, 32, NDPI_PROTOCOL_TOR },
  { 0xADC769FE, 32, NDPI_PROTOCOL_TOR },
  { 0xADD0C4D7, 32, NDPI_PROTOCOL_TOR },
  { 0xADD0FBB2, 32, NDPI_PROTOCOL_TOR },
  { 0xADD56C74, 32, NDPI_PROTOCOL_TOR },
  { 0xADD5719B, 32, NDPI_PROTOCOL_TOR },
  { 0xADE45AE0, 32, NDPI_PROTOCOL_TOR },
  { 0xADE45B5B, 32, NDPI_PROTOCOL_TOR },
  { 0xADE65550, 32, NDPI_PROTOCOL_TOR },
  { 0xADE68199, 32, NDPI_PROTOCOL_TOR },
  { 0xADE683CF, 32, NDPI_PROTOCOL_TOR },
  { 0xADE683CF, 32, NDPI_PROTOCOL_TOR },
  { 0xADE686EE, 32, NDPI_PROTOCOL_TOR },
  { 0xADE68ABF, 32, NDPI_PROTOCOL_TOR },
  { 0xADE68E82, 32, NDPI_PROTOCOL_TOR },
  { 0xADE694EC, 32, NDPI_PROTOCOL_TOR },
  { 0xADE69504, 32, NDPI_PROTOCOL_TOR },
  { 0xADE69A5A, 32, NDPI_PROTOCOL_TOR },
  { 0xADE69AB8, 32, NDPI_PROTOCOL_TOR },
  { 0xADECF938, 32, NDPI_PROTOCOL_TOR },
  { 0xADECFAD3, 32, NDPI_PROTOCOL_TOR },
  { 0xADECFF8E, 32, NDPI_PROTOCOL_TOR },
  { 0xADEF4FD2, 32, NDPI_PROTOCOL_TOR },
  { 0xADF279C7, 32, NDPI_PROTOCOL_TOR },
  { 0xADF66823, 32, NDPI_PROTOCOL_TOR },
  { 0xADF6FE86, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED0A8, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED842, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED843, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED844, 32, NDPI_PROTOCOL_TOR },
  { 0xADFED845, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFC24D, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFC41E, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFCD71, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD1B5, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD2CD, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFD3AF, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFDA6A, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFDCAB, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFDD60, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE28E, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE455, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE459, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE486, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE8C0, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFE93C, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFED6B, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFED6B, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFEDA5, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF217, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF259, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF574, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF64E, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF6A2, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF7F7, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF812, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF869, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFF9DE, 32, NDPI_PROTOCOL_TOR },
  { 0xADFFFAF0, 32, NDPI_PROTOCOL_TOR },
  { 0xAE03A82A, 32, NDPI_PROTOCOL_TOR },
  { 0xAE064AC1, 32, NDPI_PROTOCOL_TOR },
  { 0xAE15F745, 32, NDPI_PROTOCOL_TOR },
  { 0xAE1D40A4, 32, NDPI_PROTOCOL_TOR },
  { 0xAE2DB58A, 32, NDPI_PROTOCOL_TOR },
  { 0xAE32F679, 32, NDPI_PROTOCOL_TOR },
  { 0xAE3E4833, 32, NDPI_PROTOCOL_TOR },
  { 0xAE3F713C, 32, NDPI_PROTOCOL_TOR },
  { 0xAE463C5C, 32, NDPI_PROTOCOL_TOR },
  { 0xAE475A25, 32, NDPI_PROTOCOL_TOR },
  { 0xAE5F6BA7, 32, NDPI_PROTOCOL_TOR },
  { 0xAE60D6AE, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6208CA, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6328BE, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6C43BC, 32, NDPI_PROTOCOL_TOR },
  { 0xAE6D6112, 32, NDPI_PROTOCOL_TOR },
  { 0xAE7E102D, 32, NDPI_PROTOCOL_TOR },
  { 0xAE886956, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8AC693, 32, NDPI_PROTOCOL_TOR },
  { 0xAE8FF3F7, 32, NDPI_PROTOCOL_TOR },
  { 0xAF648B8C, 32, NDPI_PROTOCOL_TOR },
  { 0xAF8741DE, 32, NDPI_PROTOCOL_TOR },
  { 0xB00901D3, 32, NDPI_PROTOCOL_TOR },
  { 0xB00904CE, 32, NDPI_PROTOCOL_TOR },
  { 0xB0090574, 32, NDPI_PROTOCOL_TOR },
  { 0xB0091051, 32, NDPI_PROTOCOL_TOR },
  { 0xB0091948, 32, NDPI_PROTOCOL_TOR },
  { 0xB00926C6, 32, NDPI_PROTOCOL_TOR },
  { 0xB0092E8D, 32, NDPI_PROTOCOL_TOR },
  { 0xB00932F0, 32, NDPI_PROTOCOL_TOR },
  { 0xB009368E, 32, NDPI_PROTOCOL_TOR },
  { 0xB0095425, 32, NDPI_PROTOCOL_TOR },
  { 0xB009558D, 32, NDPI_PROTOCOL_TOR },
  { 0xB0095AD7, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096708, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096714, 32, NDPI_PROTOCOL_TOR },
  { 0xB0096B68, 32, NDPI_PROTOCOL_TOR },
  { 0xB00977A7, 32, NDPI_PROTOCOL_TOR },
  { 0xB0097DD1, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098BFC, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098C6C, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098FC8, 32, NDPI_PROTOCOL_TOR },
  { 0xB0098FD0, 32, NDPI_PROTOCOL_TOR },
  { 0xB00991C2, 32, NDPI_PROTOCOL_TOR },
  { 0xB0099344, 32, NDPI_PROTOCOL_TOR },
  { 0xB00994B0, 32, NDPI_PROTOCOL_TOR },
  { 0xB0099D4D, 32, NDPI_PROTOCOL_TOR },
  { 0xB009B42F, 32, NDPI_PROTOCOL_TOR },
  { 0xB009C0AB, 32, NDPI_PROTOCOL_TOR },
  { 0xB009ED02, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C8, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C8, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C9, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63C9, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CA, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CA, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CB, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CB, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CC, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CC, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CD, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CD, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CE, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CE, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CF, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63CF, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D0, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D0, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D1, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A63D1, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A6BB4, 32, NDPI_PROTOCOL_TOR },
  { 0xB00A74A9, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AFA4F, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AFDDB, 32, NDPI_PROTOCOL_TOR },
  { 0xB00AFE87, 32, NDPI_PROTOCOL_TOR },
  { 0xB00C1D0C, 32, NDPI_PROTOCOL_TOR },
  { 0xB00C6B1E, 32, NDPI_PROTOCOL_TOR },
  { 0xB00E717E, 32, NDPI_PROTOCOL_TOR },
  { 0xB00F49B5, 32, NDPI_PROTOCOL_TOR },
  { 0xB00FBBA1, 32, NDPI_PROTOCOL_TOR },
  { 0xB01C0978, 32, NDPI_PROTOCOL_TOR },
  { 0xB01C0B2A, 32, NDPI_PROTOCOL_TOR },
  { 0xB01C1F79, 32, NDPI_PROTOCOL_TOR },
  { 0xB01C305E, 32, NDPI_PROTOCOL_TOR },
  { 0xB01C36D5, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F1C3F, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F2395, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F323D, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F4255, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7158, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7494, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F7827, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F989F, 32, NDPI_PROTOCOL_TOR },
  { 0xB01F9CC7, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FB509, 32, NDPI_PROTOCOL_TOR },
  { 0xB01FBF1A, 32, NDPI_PROTOCOL_TOR },
  { 0xB024237E, 32, NDPI_PROTOCOL_TOR },
  { 0xB0245D6B, 32, NDPI_PROTOCOL_TOR },
  { 0xB02496F6, 32, NDPI_PROTOCOL_TOR },
  { 0xB0249F29, 32, NDPI_PROTOCOL_TOR },
  { 0xB0268C0D, 32, NDPI_PROTOCOL_TOR },
  { 0xB03515A2, 32, NDPI_PROTOCOL_TOR },
  { 0xB0357FC2, 32, NDPI_PROTOCOL_TOR },
  { 0xB035E825, 32, NDPI_PROTOCOL_TOR },
  { 0xB038EC53, 32, NDPI_PROTOCOL_TOR },
  { 0xB038ECAD, 32, NDPI_PROTOCOL_TOR },
  { 0xB038ED5A, 32, NDPI_PROTOCOL_TOR },
  { 0xB038EDBF, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A59BC, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A60C7, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A61C9, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6462, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6711, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6A59, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A6AC0, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A7317, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A7816, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A799F, 32, NDPI_PROTOCOL_TOR },
  { 0xB03A9FAF, 32, NDPI_PROTOCOL_TOR },
  { 0xB03D89DD, 32, NDPI_PROTOCOL_TOR },
  { 0xB043AC1E, 32, NDPI_PROTOCOL_TOR },
  { 0xB049E604, 32, NDPI_PROTOCOL_TOR },
  { 0xB04D1A58, 32, NDPI_PROTOCOL_TOR },
  { 0xB04D226A, 32, NDPI_PROTOCOL_TOR },
  { 0xB04D2746, 32, NDPI_PROTOCOL_TOR },
  { 0xB04D29B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB05019F4, 32, NDPI_PROTOCOL_TOR },
  { 0xB063C782, 32, NDPI_PROTOCOL_TOR },
  { 0xB0678035, 32, NDPI_PROTOCOL_TOR },
  { 0xB06A3636, 32, NDPI_PROTOCOL_TOR },
  { 0xB06A6B2F, 32, NDPI_PROTOCOL_TOR },
  { 0xB06CA0F1, 32, NDPI_PROTOCOL_TOR },
  { 0xB06CA0F2, 32, NDPI_PROTOCOL_TOR },
  { 0xB06CA0FD, 32, NDPI_PROTOCOL_TOR },
  { 0xB072F82F, 32, NDPI_PROTOCOL_TOR },
  { 0xB0744531, 32, NDPI_PROTOCOL_TOR },
  { 0xB0746831, 32, NDPI_PROTOCOL_TOR },
  { 0xB075128D, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B065E, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B0665, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B1C1F, 32, NDPI_PROTOCOL_TOR },
  { 0xB07B1C22, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EF45B, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EFC0B, 32, NDPI_PROTOCOL_TOR },
  { 0xB07EFC0C, 32, NDPI_PROTOCOL_TOR },
  { 0xB0BCDE53, 32, NDPI_PROTOCOL_TOR },
  { 0xB0BD2641, 32, NDPI_PROTOCOL_TOR },
  { 0xB0BD77B6, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C17D30, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C20E92, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C62CC4, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C65C86, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C6642D, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C67537, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C7E07F, 32, NDPI_PROTOCOL_TOR },
  { 0xB0C7E590, 32, NDPI_PROTOCOL_TOR },
  { 0xB0D496A3, 32, NDPI_PROTOCOL_TOR },
  { 0xB0DD2E35, 32, NDPI_PROTOCOL_TOR },
  { 0xB0DECAC3, 32, NDPI_PROTOCOL_TOR },
  { 0xB0E2DAFF, 32, NDPI_PROTOCOL_TOR },
  { 0xB10648C6, 32, NDPI_PROTOCOL_TOR },
  { 0xB12F6D15, 32, NDPI_PROTOCOL_TOR },
  { 0xB15C1B98, 32, NDPI_PROTOCOL_TOR },
  { 0xB18D1209, 32, NDPI_PROTOCOL_TOR },
  { 0xB194ACC4, 32, NDPI_PROTOCOL_TOR },
  { 0xB1BC41E6, 32, NDPI_PROTOCOL_TOR },
  { 0xB1CD10C8, 32, NDPI_PROTOCOL_TOR },
  { 0xB2011DB1, 32, NDPI_PROTOCOL_TOR },
  { 0xB202DFF0, 32, NDPI_PROTOCOL_TOR },
  { 0xB202E307, 32, NDPI_PROTOCOL_TOR },
  { 0xB2031B59, 32, NDPI_PROTOCOL_TOR },
  { 0xB204CFB7, 32, NDPI_PROTOCOL_TOR },
  { 0xB2067327, 32, NDPI_PROTOCOL_TOR },
  { 0xB2070DE7, 32, NDPI_PROTOCOL_TOR },
  { 0xB20BA25E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2102D5A, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D038, 32, NDPI_PROTOCOL_TOR },
  { 0xB210D039, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA0B, 32, NDPI_PROTOCOL_TOR },
  { 0xB211AA13, 32, NDPI_PROTOCOL_TOR },
  { 0xB212106C, 32, NDPI_PROTOCOL_TOR },
  { 0xB21211CC, 32, NDPI_PROTOCOL_TOR },
  { 0xB21211EA, 32, NDPI_PROTOCOL_TOR },
  { 0xB21253D7, 32, NDPI_PROTOCOL_TOR },
  { 0xB2128308, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143710, 32, NDPI_PROTOCOL_TOR },
  { 0xB2143712, 32, NDPI_PROTOCOL_TOR },
  { 0xB2151456, 32, NDPI_PROTOCOL_TOR },
  { 0xB2157245, 32, NDPI_PROTOCOL_TOR },
  { 0xB21572B9, 32, NDPI_PROTOCOL_TOR },
  { 0xB2182081, 32, NDPI_PROTOCOL_TOR },
  { 0xB218CF5C, 32, NDPI_PROTOCOL_TOR },
  { 0xB21944AC, 32, NDPI_PROTOCOL_TOR },
  { 0xB21968A9, 32, NDPI_PROTOCOL_TOR },
  { 0xB2198DE6, 32, NDPI_PROTOCOL_TOR },
  { 0xB21A57B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB21A76A9, 32, NDPI_PROTOCOL_TOR },
  { 0xB21A8269, 32, NDPI_PROTOCOL_TOR },
  { 0xB21AB707, 32, NDPI_PROTOCOL_TOR },
  { 0xB21AC341, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B383A, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B78E5, 32, NDPI_PROTOCOL_TOR },
  { 0xB21B7ACB, 32, NDPI_PROTOCOL_TOR },
  { 0xB220225B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2202C9D, 32, NDPI_PROTOCOL_TOR },
  { 0xB2203E91, 32, NDPI_PROTOCOL_TOR },
  { 0xB22064D7, 32, NDPI_PROTOCOL_TOR },
  { 0xB220784B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2207A41, 32, NDPI_PROTOCOL_TOR },
  { 0xB2208FAF, 32, NDPI_PROTOCOL_TOR },
  { 0xB2208FAF, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B560, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B561, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B562, 32, NDPI_PROTOCOL_TOR },
  { 0xB220B563, 32, NDPI_PROTOCOL_TOR },
  { 0xB220D861, 32, NDPI_PROTOCOL_TOR },
  { 0xB220D892, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DBC5, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DC0C, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DC18, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DD97, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DDCF, 32, NDPI_PROTOCOL_TOR },
  { 0xB220DE15, 32, NDPI_PROTOCOL_TOR },
  { 0xB220EE9E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2212397, 32, NDPI_PROTOCOL_TOR },
  { 0xB22170AB, 32, NDPI_PROTOCOL_TOR },
  { 0xB22EA34B, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E0999, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E0E7F, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E0E97, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E102A, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E12D7, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E1384, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E1A53, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2520, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E27CA, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E2E07, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E3405, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E354B, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E36E3, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E38A3, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E3910, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E3A50, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E414D, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E4DB6, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E4E51, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E507C, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5660, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E56CE, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5A6F, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5D24, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E5EF3, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E60A0, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E64C1, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6892, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6DA4, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6E8D, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E6F30, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E7047, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E769A, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E83D8, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E9871, 32, NDPI_PROTOCOL_TOR },
  { 0xB23E9E9C, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EA3E3, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EA7B2, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EADCB, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EB2E4, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EB893, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EBA9B, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EBD4F, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC4B1, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC658, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC6D5, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC7E2, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EC927, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ECC5B, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ECC63, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED1FC, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED47B, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED986, 32, NDPI_PROTOCOL_TOR },
  { 0xB23ED9E9, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EDAA0, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EDE81, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EE525, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EE5D1, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EE707, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EEA99, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EEB68, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EEE78, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EF11E, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EF140, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EF877, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFB08, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFC52, 32, NDPI_PROTOCOL_TOR },
  { 0xB23EFCEA, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F00A1, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F1030, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F2E61, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F3D43, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F41B3, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F4AC4, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F4AF5, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F5E90, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F604F, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F6122, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F65C5, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F6E97, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F749D, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F91E2, 32, NDPI_PROTOCOL_TOR },
  { 0xB23F9A5D, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FA2D4, 32, NDPI_PROTOCOL_TOR },
  { 0xB23FD133, 32, NDPI_PROTOCOL_TOR },
  { 0xB24021FC, 32, NDPI_PROTOCOL_TOR },
  { 0xB246D353, 32, NDPI_PROTOCOL_TOR },
  { 0xB248584D, 32, NDPI_PROTOCOL_TOR },
  { 0xB249D276, 32, NDPI_PROTOCOL_TOR },
  { 0xB249D2F0, 32, NDPI_PROTOCOL_TOR },
  { 0xB24A67E4, 32, NDPI_PROTOCOL_TOR },
  { 0xB24D627C, 32, NDPI_PROTOCOL_TOR },
  { 0xB24D7B29, 32, NDPI_PROTOCOL_TOR },
  { 0xB24ED425, 32, NDPI_PROTOCOL_TOR },
  { 0xB24EEAC3, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8540, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8623, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F86B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F86B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F86C4, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F88E6, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8B11, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8B2E, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8D6C, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F8EE0, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F901C, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F901C, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9D24, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9D24, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9F93, 32, NDPI_PROTOCOL_TOR },
  { 0xB24F9FE0, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA039, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA198, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA1B1, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA1ED, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA1ED, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA3A9, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA515, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FA858, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FAAAD, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FAAB5, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FAAB5, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB060, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB072, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB0B9, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FB5E6, 32, NDPI_PROTOCOL_TOR },
  { 0xB24FBCD4, 32, NDPI_PROTOCOL_TOR },
  { 0xB2520865, 32, NDPI_PROTOCOL_TOR },
  { 0xB2522270, 32, NDPI_PROTOCOL_TOR },
  { 0xB2522871, 32, NDPI_PROTOCOL_TOR },
  { 0xB2524269, 32, NDPI_PROTOCOL_TOR },
  { 0xB2534549, 32, NDPI_PROTOCOL_TOR },
  { 0xB2560A58, 32, NDPI_PROTOCOL_TOR },
  { 0xB281AD8F, 32, NDPI_PROTOCOL_TOR },
  { 0xB289B71D, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C33AD, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C33AD, 32, NDPI_PROTOCOL_TOR },
  { 0xB28C6812, 32, NDPI_PROTOCOL_TOR },
  { 0xB28CC54B, 32, NDPI_PROTOCOL_TOR },
  { 0xB28E0705, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A23DD6, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A242D4, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C21E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C252, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C2D2, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A2C505, 32, NDPI_PROTOCOL_TOR },
  { 0xB2A746AA, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AA6FC2, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF83C2, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8A, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8A, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8D, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8D, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2AF8B8E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2BA743C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2BED2D1, 32, NDPI_PROTOCOL_TOR },
  { 0xB2BFC29E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C0BBAF, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C3EA94, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C7EAC0, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C861B6, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C8CBEE, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C8EE97, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C92FF5, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C98985, 32, NDPI_PROTOCOL_TOR },
  { 0xB2C9B19C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CA6B7B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CB9302, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CB9A4F, 32, NDPI_PROTOCOL_TOR },
  { 0xB2CBBF12, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D13297, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D13363, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D134A2, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D3238A, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D808F5, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D83B33, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D85C75, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9B820, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9B943, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9BB05, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9BB06, 32, NDPI_PROTOCOL_TOR },
  { 0xB2D9BB27, 32, NDPI_PROTOCOL_TOR },
  { 0xB2DBF5D6, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEDF43, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE084, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE16C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE19E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEE40C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EEED2C, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EF3CAC, 32, NDPI_PROTOCOL_TOR },
  { 0xB2EFB113, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FAF3D9, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FD60A6, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0615, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE08BB, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE0987, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1486, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1486, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE16E4, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE193E, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE19A5, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1AF4, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1C14, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1E56, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1FAD, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE1FD1, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE23E0, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE25C5, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2805, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2BF4, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2C5B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2C5B, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2C87, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2C87, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2CEA, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE2CEA, 32, NDPI_PROTOCOL_TOR },
  { 0xB2FE3765, 32, NDPI_PROTOCOL_TOR },
  { 0xB300C293, 32, NDPI_PROTOCOL_TOR },
  { 0xB32B8522, 32, NDPI_PROTOCOL_TOR },
  { 0xB36FE5E8, 32, NDPI_PROTOCOL_TOR },
  { 0xB3E8F4B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB4DE4452, 32, NDPI_PROTOCOL_TOR },
  { 0xB529C599, 32, NDPI_PROTOCOL_TOR },
  { 0xB529DB75, 32, NDPI_PROTOCOL_TOR },
  { 0xB52E9531, 32, NDPI_PROTOCOL_TOR },
  { 0xB5A073AC, 32, NDPI_PROTOCOL_TOR },
  { 0xB6A70430, 32, NDPI_PROTOCOL_TOR },
  { 0xB7574B02, 32, NDPI_PROTOCOL_TOR },
  { 0xB75806AD, 32, NDPI_PROTOCOL_TOR },
  { 0xB8129B07, 32, NDPI_PROTOCOL_TOR },
  { 0xB812D6D9, 32, NDPI_PROTOCOL_TOR },
  { 0xB8230910, 32, NDPI_PROTOCOL_TOR },
  { 0xB827A1D3, 32, NDPI_PROTOCOL_TOR },
  { 0xB8486A34, 32, NDPI_PROTOCOL_TOR },
  { 0xB84E9433, 32, NDPI_PROTOCOL_TOR },
  { 0xB85EE222, 32, NDPI_PROTOCOL_TOR },
  { 0xB8645406, 32, NDPI_PROTOCOL_TOR },
  { 0xB869CB85, 32, NDPI_PROTOCOL_TOR },
  { 0xB869DC18, 32, NDPI_PROTOCOL_TOR },
  { 0xB869EB44, 32, NDPI_PROTOCOL_TOR },
  { 0xB86A6DF4, 32, NDPI_PROTOCOL_TOR },
  { 0xB86AD762, 32, NDPI_PROTOCOL_TOR },
  { 0xB8944B0F, 32, NDPI_PROTOCOL_TOR },
  { 0xB89BBBCD, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A3447D, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A48472, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A4F401, 32, NDPI_PROTOCOL_TOR },
  { 0xB8A4F601, 32, NDPI_PROTOCOL_TOR },
  { 0xB8AA68F7, 32, NDPI_PROTOCOL_TOR },
  { 0xB8AF118B, 32, NDPI_PROTOCOL_TOR },
  { 0xB8AF2873, 32, NDPI_PROTOCOL_TOR },
  { 0xB8B07919, 32, NDPI_PROTOCOL_TOR },
  { 0xB8B705CB, 32, NDPI_PROTOCOL_TOR },
  { 0xB904E322, 32, NDPI_PROTOCOL_TOR },
  { 0xB9050983, 32, NDPI_PROTOCOL_TOR },
  { 0xB9053482, 32, NDPI_PROTOCOL_TOR },
  { 0xB905355D, 32, NDPI_PROTOCOL_TOR },
  { 0xB907944E, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EC83, 32, NDPI_PROTOCOL_TOR },
  { 0xB908ED1B, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EDD0, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EE42, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EE8B, 32, NDPI_PROTOCOL_TOR },
  { 0xB908EE8C, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A1DF7, 32, NDPI_PROTOCOL_TOR },
  { 0xB90A4750, 32, NDPI_PROTOCOL_TOR },
  { 0xB90BA670, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C0C85, 32, NDPI_PROTOCOL_TOR },
  { 0xB90C0E76, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D259E, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D2631, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D2684, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D26B9, 32, NDPI_PROTOCOL_TOR },
  { 0xB90D27C5, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1C6A, 32, NDPI_PROTOCOL_TOR },
  { 0xB90E1F3B, 32, NDPI_PROTOCOL_TOR },
  { 0xB90EB80D, 32, NDPI_PROTOCOL_TOR },
  { 0xB90EB9F0, 32, NDPI_PROTOCOL_TOR },
  { 0xB90FF47C, 32, NDPI_PROTOCOL_TOR },
  { 0xB9103C53, 32, NDPI_PROTOCOL_TOR },
  { 0xB9107C88, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AC9B, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AD54, 32, NDPI_PROTOCOL_TOR },
  { 0xB910AD56, 32, NDPI_PROTOCOL_TOR },
  { 0xB910C8B0, 32, NDPI_PROTOCOL_TOR },
  { 0xB910C91C, 32, NDPI_PROTOCOL_TOR },
  { 0xB911908A, 32, NDPI_PROTOCOL_TOR },
  { 0xB911B8E4, 32, NDPI_PROTOCOL_TOR },
  { 0xB9129404, 32, NDPI_PROTOCOL_TOR },
  { 0xB9135724, 32, NDPI_PROTOCOL_TOR },
  { 0xB9156432, 32, NDPI_PROTOCOL_TOR },
  { 0xB915671F, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D8A6, 32, NDPI_PROTOCOL_TOR },
  { 0xB915D908, 32, NDPI_PROTOCOL_TOR },
  { 0xB9163F22, 32, NDPI_PROTOCOL_TOR },
  { 0xB918EBCD, 32, NDPI_PROTOCOL_TOR },
  { 0xB919D8ED, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A7CB4, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C1C, 32, NDPI_PROTOCOL_TOR },
  { 0xB91A9C1D, 32, NDPI_PROTOCOL_TOR },
  { 0xB91BAF18, 32, NDPI_PROTOCOL_TOR },
  { 0xB91F644B, 32, NDPI_PROTOCOL_TOR },
  { 0xB9222102, 32, NDPI_PROTOCOL_TOR },
  { 0xB9246491, 32, NDPI_PROTOCOL_TOR },
  { 0xB92592AC, 32, NDPI_PROTOCOL_TOR },
  { 0xB925E2C5, 32, NDPI_PROTOCOL_TOR },
  { 0xB9262FE0, 32, NDPI_PROTOCOL_TOR },
  { 0xB928870A, 32, NDPI_PROTOCOL_TOR },
  { 0xB92DC039, 32, NDPI_PROTOCOL_TOR },
  { 0xB92DC069, 32, NDPI_PROTOCOL_TOR },
  { 0xB92DC0BC, 32, NDPI_PROTOCOL_TOR },
  { 0xB92DC1F2, 32, NDPI_PROTOCOL_TOR },
  { 0xB9310ED3, 32, NDPI_PROTOCOL_TOR },
  { 0xB932BFFA, 32, NDPI_PROTOCOL_TOR },
  { 0xB932E9E0, 32, NDPI_PROTOCOL_TOR },
  { 0xB935A306, 32, NDPI_PROTOCOL_TOR },
  { 0xB936EE88, 32, NDPI_PROTOCOL_TOR },
  { 0xB9385426, 32, NDPI_PROTOCOL_TOR },
  { 0xB9395219, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D8932, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D8932, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D8949, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D8949, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D942E, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9450, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D945D, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9474, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D948D, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D948E, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94B7, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94BD, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94C1, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D94E4, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D956D, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9574, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9576, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D9577, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D95B0, 32, NDPI_PROTOCOL_TOR },
  { 0xB93D95C1, 32, NDPI_PROTOCOL_TOR },
  { 0xB93FBC7C, 32, NDPI_PROTOCOL_TOR },
  { 0xB941C85D, 32, NDPI_PROTOCOL_TOR },
  { 0xB941CD12, 32, NDPI_PROTOCOL_TOR },
  { 0xB9453693, 32, NDPI_PROTOCOL_TOR },
  { 0xB9453744, 32, NDPI_PROTOCOL_TOR },
  { 0xB948B169, 32, NDPI_PROTOCOL_TOR },
  { 0xB948E86B, 32, NDPI_PROTOCOL_TOR },
  { 0xB948F791, 32, NDPI_PROTOCOL_TOR },
  { 0xB94B382C, 32, NDPI_PROTOCOL_TOR },
  { 0xB94B382C, 32, NDPI_PROTOCOL_TOR },
  { 0xB94B3874, 32, NDPI_PROTOCOL_TOR },
  { 0xB94B3874, 32, NDPI_PROTOCOL_TOR },
  { 0xB952C8E0, 32, NDPI_PROTOCOL_TOR },
  { 0xBA160C6E, 32, NDPI_PROTOCOL_TOR },
  { 0xBA1A4002, 32, NDPI_PROTOCOL_TOR },
  { 0xBA6B7BAE, 32, NDPI_PROTOCOL_TOR },
  { 0xBB3B6D26, 32, NDPI_PROTOCOL_TOR },
  { 0xBB3F6418, 32, NDPI_PROTOCOL_TOR },
  { 0xBB5F2203, 32, NDPI_PROTOCOL_TOR },
  { 0xBBD34A78, 32, NDPI_PROTOCOL_TOR },
  { 0xBBFEE732, 32, NDPI_PROTOCOL_TOR },
  { 0xBC0262D8, 32, NDPI_PROTOCOL_TOR },
  { 0xBC04F2B2, 32, NDPI_PROTOCOL_TOR },
  { 0xBC060D5B, 32, NDPI_PROTOCOL_TOR },
  { 0xBC06497F, 32, NDPI_PROTOCOL_TOR },
  { 0xBC18F4FF, 32, NDPI_PROTOCOL_TOR },
  { 0xBC208F85, 32, NDPI_PROTOCOL_TOR },
  { 0xBC20F2F4, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28209A, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2821D9, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2825C8, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2833E8, 32, NDPI_PROTOCOL_TOR },
  { 0xBC283512, 32, NDPI_PROTOCOL_TOR },
  { 0xBC283B50, 32, NDPI_PROTOCOL_TOR },
  { 0xBC283C8E, 32, NDPI_PROTOCOL_TOR },
  { 0xBC283CF2, 32, NDPI_PROTOCOL_TOR },
  { 0xBC284C73, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286345, 32, NDPI_PROTOCOL_TOR },
  { 0xBC286BCD, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2880F6, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2899F2, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28B34A, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28CE05, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28EBD7, 32, NDPI_PROTOCOL_TOR },
  { 0xBC28F839, 32, NDPI_PROTOCOL_TOR },
  { 0xBC2AFD0B, 32, NDPI_PROTOCOL_TOR },
  { 0xBC322E9A, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3CC333, 32, NDPI_PROTOCOL_TOR },
  { 0xBC3E5662, 32, NDPI_PROTOCOL_TOR },
  { 0xBC499110, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4DD834, 32, NDPI_PROTOCOL_TOR },
  { 0xBC4ED027, 32, NDPI_PROTOCOL_TOR },
  { 0xBC553281, 32, NDPI_PROTOCOL_TOR },
  { 0xBC57A8F9, 32, NDPI_PROTOCOL_TOR },
  { 0xBC5D117B, 32, NDPI_PROTOCOL_TOR },
  { 0xBC5DD54B, 32, NDPI_PROTOCOL_TOR },
  { 0xBC5FF78C, 32, NDPI_PROTOCOL_TOR },
  { 0xBC603CB8, 32, NDPI_PROTOCOL_TOR },
  { 0xBC607AC3, 32, NDPI_PROTOCOL_TOR },
  { 0xBC617F79, 32, NDPI_PROTOCOL_TOR },
  { 0xBC62D521, 32, NDPI_PROTOCOL_TOR },
  { 0xBC6450C9, 32, NDPI_PROTOCOL_TOR },
  { 0xBC67690F, 32, NDPI_PROTOCOL_TOR },
  { 0xBC676B47, 32, NDPI_PROTOCOL_TOR },
  { 0xBC6CD29D, 32, NDPI_PROTOCOL_TOR },
  { 0xBC6D5CC5, 32, NDPI_PROTOCOL_TOR },
  { 0xBC717278, 32, NDPI_PROTOCOL_TOR },
  { 0xBC728C79, 32, NDPI_PROTOCOL_TOR },
  { 0xBC769BEF, 32, NDPI_PROTOCOL_TOR },
  { 0xBC780C35, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78EBA5, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78EFF1, 32, NDPI_PROTOCOL_TOR },
  { 0xBC78FD27, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7A05A1, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7AD504, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7B2F13, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7C951D, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E5D51, 32, NDPI_PROTOCOL_TOR },
  { 0xBC7E5D5F, 32, NDPI_PROTOCOL_TOR },
  { 0xBC817CFA, 32, NDPI_PROTOCOL_TOR },
  { 0xBC860642, 32, NDPI_PROTOCOL_TOR },
  { 0xBC860C22, 32, NDPI_PROTOCOL_TOR },
  { 0xBC860CEC, 32, NDPI_PROTOCOL_TOR },
  { 0xBC864432, 32, NDPI_PROTOCOL_TOR },
  { 0xBC864BD3, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8653AB, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A01E5, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A01E5, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A0931, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A0931, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A09D0, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A09D0, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A110F, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A110F, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A5886, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A58A8, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A6574, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A6A8A, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A703C, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A70E2, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A7976, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A7DD1, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8A7DD1, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8D5359, 32, NDPI_PROTOCOL_TOR },
  { 0xBC8E70F6, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5033F, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5033F, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA519D2, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA51A0D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA51A0D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA53B2B, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA55E69, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA57B5F, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA57BF4, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA58822, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA58A8D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA58AB5, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA58AB5, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5919D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5A4A3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5A4A3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5C181, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5C88A, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5D59C, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5E828, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5EC12, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA5F1D8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA609DA, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA60CD4, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA60DE6, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61250, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA61286, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA6234D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA624A3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA625AD, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA625D7, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62B21, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62B3D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62BC8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62D23, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA62EAB, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63064, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA630B1, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63152, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA631B4, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63271, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63575, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA638B3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63C9E, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA63E18, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA73D86, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA745E0, 32, NDPI_PROTOCOL_TOR },
  { 0xBCA8225A, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAE49D9, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAE5D48, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAEA791, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAEB379, 32, NDPI_PROTOCOL_TOR },
  { 0xBCAED97F, 32, NDPI_PROTOCOL_TOR },
  { 0xBCB55D55, 32, NDPI_PROTOCOL_TOR },
  { 0xBCB7841D, 32, NDPI_PROTOCOL_TOR },
  { 0xBCBA10EC, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC02309, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC0A86E, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC1632B, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC1C8F8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC2C9AE, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC30886, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC348B3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCC3D1FD, 32, NDPI_PROTOCOL_TOR },
  { 0xBCCAFCC1, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD519EA, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD58F17, 32, NDPI_PROTOCOL_TOR },
  { 0xBCD65D16, 32, NDPI_PROTOCOL_TOR },
  { 0xBCDF3258, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE23EAE, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE294A1, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2957C, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2AB6F, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2ACAA, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2BB8A, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2BD35, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2BE71, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2BF12, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2C030, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2C5E0, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2C7A0, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2C8D8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2CEC8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2D6B1, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2D98E, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DC10, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DCE2, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2DDF3, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2E196, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2E396, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2E839, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2FA52, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2FDB5, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE2FE59, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE3C986, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE3E068, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE4234B, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE43194, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE63CF6, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE65B87, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE6A6EB, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE6DFB2, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE8B717, 32, NDPI_PROTOCOL_TOR },
  { 0xBCE94947, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF17195, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF17251, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18C77, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18C86, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18C94, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18D13, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18D15, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18D87, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF18DAA, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF423AB, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF64BB2, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF6CC43, 32, NDPI_PROTOCOL_TOR },
  { 0xBCF764B8, 32, NDPI_PROTOCOL_TOR },
  { 0xBCFF1E24, 32, NDPI_PROTOCOL_TOR },
  { 0xBCFF70E0, 32, NDPI_PROTOCOL_TOR },
  { 0xBD446D80, 32, NDPI_PROTOCOL_TOR },
  { 0xBDD4A056, 32, NDPI_PROTOCOL_TOR },
  { 0xBDF2D9EF, 32, NDPI_PROTOCOL_TOR },
  { 0xBE03A993, 32, NDPI_PROTOCOL_TOR },
  { 0xBE589587, 32, NDPI_PROTOCOL_TOR },
  { 0xBE78E41E, 32, NDPI_PROTOCOL_TOR },
  { 0xBE7B2D60, 32, NDPI_PROTOCOL_TOR },
  { 0xBE7B2F74, 32, NDPI_PROTOCOL_TOR },
  { 0xBEBD7608, 32, NDPI_PROTOCOL_TOR },
  { 0xBEC0A60C, 32, NDPI_PROTOCOL_TOR },
  { 0xBEE25D6B, 32, NDPI_PROTOCOL_TOR },
  { 0xBF151340, 32, NDPI_PROTOCOL_TOR },
  { 0xBF6502EB, 32, NDPI_PROTOCOL_TOR },
  { 0xBF6598A6, 32, NDPI_PROTOCOL_TOR },
  { 0xBFEFD3DC, 32, NDPI_PROTOCOL_TOR },
  { 0xC0009D29, 32, NDPI_PROTOCOL_TOR },
  { 0xC0031CF2, 32, NDPI_PROTOCOL_TOR },
  { 0xC0031EDF, 32, NDPI_PROTOCOL_TOR },
  { 0xC0039416, 32, NDPI_PROTOCOL_TOR },
  { 0xC003941B, 32, NDPI_PROTOCOL_TOR },
  { 0xC00396AA, 32, NDPI_PROTOCOL_TOR },
  { 0xC0039DD4, 32, NDPI_PROTOCOL_TOR },
  { 0xC003A076, 32, NDPI_PROTOCOL_TOR },
  { 0xC003A4E3, 32, NDPI_PROTOCOL_TOR },
  { 0xC003ACEC, 32, NDPI_PROTOCOL_TOR },
  { 0xC003AD58, 32, NDPI_PROTOCOL_TOR },
  { 0xC003B1A7, 32, NDPI_PROTOCOL_TOR },
  { 0xC003B426, 32, NDPI_PROTOCOL_TOR },
  { 0xC003C9E2, 32, NDPI_PROTOCOL_TOR },
  { 0xC003C9F9, 32, NDPI_PROTOCOL_TOR },
  { 0xC003D27D, 32, NDPI_PROTOCOL_TOR },
  { 0xC00C211A, 32, NDPI_PROTOCOL_TOR },
  { 0xC00C211B, 32, NDPI_PROTOCOL_TOR },
  { 0xC01E202C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0223B30, 32, NDPI_PROTOCOL_TOR },
  { 0xC0223F89, 32, NDPI_PROTOCOL_TOR },
  { 0xC022E022, 32, NDPI_PROTOCOL_TOR },
  { 0xC0264C03, 32, NDPI_PROTOCOL_TOR },
  { 0xC0266D90, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A7410, 32, NDPI_PROTOCOL_TOR },
  { 0xC02A74A1, 32, NDPI_PROTOCOL_TOR },
  { 0xC02BF408, 32, NDPI_PROTOCOL_TOR },
  { 0xC02BF408, 32, NDPI_PROTOCOL_TOR },
  { 0xC02BF42A, 32, NDPI_PROTOCOL_TOR },
  { 0xC02BF42A, 32, NDPI_PROTOCOL_TOR },
  { 0xC02C1E28, 32, NDPI_PROTOCOL_TOR },
  { 0xC0405266, 32, NDPI_PROTOCOL_TOR },
  { 0xC043DE05, 32, NDPI_PROTOCOL_TOR },
  { 0xC045177C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0455E39, 32, NDPI_PROTOCOL_TOR },
  { 0xC0479724, 32, NDPI_PROTOCOL_TOR },
  { 0xC047DAA0, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F524, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F589, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F589, 32, NDPI_PROTOCOL_TOR },
  { 0xC047F5D7, 32, NDPI_PROTOCOL_TOR },
  { 0xC049EC12, 32, NDPI_PROTOCOL_TOR },
  { 0xC049EF53, 32, NDPI_PROTOCOL_TOR },
  { 0xC051842E, 32, NDPI_PROTOCOL_TOR },
  { 0xC051DC5B, 32, NDPI_PROTOCOL_TOR },
  { 0xC051DDA2, 32, NDPI_PROTOCOL_TOR },
  { 0xC051F91F, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C1C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0571C52, 32, NDPI_PROTOCOL_TOR },
  { 0xC057E0BD, 32, NDPI_PROTOCOL_TOR },
  { 0xC05BEBE6, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F1A3A, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F1B8F, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F2889, 32, NDPI_PROTOCOL_TOR },
  { 0xC05F2CA9, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630289, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630289, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630620, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630852, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630B30, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630F7A, 32, NDPI_PROTOCOL_TOR },
  { 0xC0630FDC, 32, NDPI_PROTOCOL_TOR },
  { 0xC063259C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632B71, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632B9C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0632BCE, 32, NDPI_PROTOCOL_TOR },
  { 0xC063681B, 32, NDPI_PROTOCOL_TOR },
  { 0xC063914E, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639A18, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639A4B, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639A50, 32, NDPI_PROTOCOL_TOR },
  { 0xC0639AEA, 32, NDPI_PROTOCOL_TOR },
  { 0xC063A866, 32, NDPI_PROTOCOL_TOR },
  { 0xC063A93D, 32, NDPI_PROTOCOL_TOR },
  { 0xC063BA5E, 32, NDPI_PROTOCOL_TOR },
  { 0xC063C1C1, 32, NDPI_PROTOCOL_TOR },
  { 0xC063D48B, 32, NDPI_PROTOCOL_TOR },
  { 0xC063D497, 32, NDPI_PROTOCOL_TOR },
  { 0xC063F665, 32, NDPI_PROTOCOL_TOR },
  { 0xC063F7EA, 32, NDPI_PROTOCOL_TOR },
  { 0xC063FA8F, 32, NDPI_PROTOCOL_TOR },
  { 0xC07247DE, 32, NDPI_PROTOCOL_TOR },
  { 0xC0794208, 32, NDPI_PROTOCOL_TOR },
  { 0xC079AA4B, 32, NDPI_PROTOCOL_TOR },
  { 0xC07CFA53, 32, NDPI_PROTOCOL_TOR },
  { 0xC087A8FB, 32, NDPI_PROTOCOL_TOR },
  { 0xC0965E31, 32, NDPI_PROTOCOL_TOR },
  { 0xC0979A8E, 32, NDPI_PROTOCOL_TOR },
  { 0xC0999AF4, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B506F, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5365, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5736, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5874, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5D65, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5F7A, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5F7A, 32, NDPI_PROTOCOL_TOR },
  { 0xC09B5FDE, 32, NDPI_PROTOCOL_TOR },
  { 0xC09DC04F, 32, NDPI_PROTOCOL_TOR },
  { 0xC09DEFF3, 32, NDPI_PROTOCOL_TOR },
  { 0xC09DFD7D, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A0C16E, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A264D5, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A2650F, 32, NDPI_PROTOCOL_TOR },
  { 0xC0A3E033, 32, NDPI_PROTOCOL_TOR },
  { 0xC0AB3D72, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B82075, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B8502A, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B85175, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B851A0, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B85280, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B8555C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B858CF, 32, NDPI_PROTOCOL_TOR },
  { 0xC0B85E6F, 32, NDPI_PROTOCOL_TOR },
  { 0xC0BB6A92, 32, NDPI_PROTOCOL_TOR },
  { 0xC0C8EC20, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D28AA3, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D28AAB, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2C7B1, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2CC27, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2CEBD, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2E780, 32, NDPI_PROTOCOL_TOR },
  { 0xC0D2F0D9, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E28C77, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E38B12, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E38F11, 32, NDPI_PROTOCOL_TOR },
  { 0xC0E3E71B, 32, NDPI_PROTOCOL_TOR },
  { 0xC0EB4E13, 32, NDPI_PROTOCOL_TOR },
  { 0xC0EB4EDB, 32, NDPI_PROTOCOL_TOR },
  { 0xC0EDD411, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F158B5, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F183E9, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1863E, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F192D5, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F19438, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B238, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B41B, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B4A3, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1B57A, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C4B2, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C66A, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1C7D0, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1CAD6, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1CEAB, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D063, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D265, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1D878, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1E9CB, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1E9F2, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F1FC3F, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F37E51, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F9380B, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F93EB7, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F93F97, 32, NDPI_PROTOCOL_TOR },
  { 0xC0F93F9C, 32, NDPI_PROTOCOL_TOR },
  { 0xC0FC828E, 32, NDPI_PROTOCOL_TOR },
  { 0xC0FEA81A, 32, NDPI_PROTOCOL_TOR },
  { 0xC101C19C, 32, NDPI_PROTOCOL_TOR },
  { 0xC106DE6E, 32, NDPI_PROTOCOL_TOR },
  { 0xC107B1DF, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722B, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722D, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722E, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B722F, 32, NDPI_PROTOCOL_TOR },
  { 0xC10B8978, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA4F3, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA6C2, 32, NDPI_PROTOCOL_TOR },
  { 0xC10BA6C2, 32, NDPI_PROTOCOL_TOR },
  { 0xC10C4907, 32, NDPI_PROTOCOL_TOR },
  { 0xC10D6125, 32, NDPI_PROTOCOL_TOR },
  { 0xC10E9FCC, 32, NDPI_PROTOCOL_TOR },
  { 0xC117F4F4, 32, NDPI_PROTOCOL_TOR },
  { 0xC118D194, 32, NDPI_PROTOCOL_TOR },
  { 0xC118D27E, 32, NDPI_PROTOCOL_TOR },
  { 0xC119019D, 32, NDPI_PROTOCOL_TOR },
  { 0xC11CE446, 32, NDPI_PROTOCOL_TOR },
  { 0xC121D817, 32, NDPI_PROTOCOL_TOR },
  { 0xC1220201, 32, NDPI_PROTOCOL_TOR },
  { 0xC1233435, 32, NDPI_PROTOCOL_TOR },
  { 0xC12598C7, 32, NDPI_PROTOCOL_TOR },
  { 0xC12598F1, 32, NDPI_PROTOCOL_TOR },
  { 0xC1530139, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C56, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C57, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C58, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C59, 32, NDPI_PROTOCOL_TOR },
  { 0xC15A0C5A, 32, NDPI_PROTOCOL_TOR },
  { 0xC15FE4E8, 32, NDPI_PROTOCOL_TOR },
  { 0xC15FF2D5, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC23, 32, NDPI_PROTOCOL_TOR },
  { 0xC168DC36, 32, NDPI_PROTOCOL_TOR },
  { 0xC1698632, 32, NDPI_PROTOCOL_TOR },
  { 0xC169869C, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B131E, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B5538, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B5539, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B553D, 32, NDPI_PROTOCOL_TOR },
  { 0xC16B553E, 32, NDPI_PROTOCOL_TOR },
  { 0xC16E9D97, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F1A16, 32, NDPI_PROTOCOL_TOR },
  { 0xC16F8D6E, 32, NDPI_PROTOCOL_TOR },
  { 0xC188CC75, 32, NDPI_PROTOCOL_TOR },
  { 0xC189ADD9, 32, NDPI_PROTOCOL_TOR },
  { 0xC18A7603, 32, NDPI_PROTOCOL_TOR },
  { 0xC18A7608, 32, NDPI_PROTOCOL_TOR },
  { 0xC18AD865, 32, NDPI_PROTOCOL_TOR },
  { 0xC1960E3E, 32, NDPI_PROTOCOL_TOR },
  { 0xC196791A, 32, NDPI_PROTOCOL_TOR },
  { 0xC1967942, 32, NDPI_PROTOCOL_TOR },
  { 0xC19A0D98, 32, NDPI_PROTOCOL_TOR },
  { 0xC19D73FA, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A3DC8F, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A48535, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A4D955, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A744, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A745, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A746, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A747, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A748, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A749, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74A, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74B, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74C, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74D, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74E, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A74F, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A750, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A751, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A752, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A753, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A754, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A755, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A756, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A757, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A758, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A759, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A75A, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A75B, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A75C, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A75D, 32, NDPI_PROTOCOL_TOR },
  { 0xC1A6A75E, 32, NDPI_PROTOCOL_TOR },
  { 0xC1AE0614, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B69035, 32, NDPI_PROTOCOL_TOR },
  { 0xC1B763D5, 32, NDPI_PROTOCOL_TOR },
  { 0xC1BEA835, 32, NDPI_PROTOCOL_TOR },
  { 0xC1CB312E, 32, NDPI_PROTOCOL_TOR },
  { 0xC1DB24CF, 32, NDPI_PROTOCOL_TOR },
  { 0xC1E0A32B, 32, NDPI_PROTOCOL_TOR },
  { 0xC1F66F3E, 32, NDPI_PROTOCOL_TOR },
  { 0xC20EB3B8, 32, NDPI_PROTOCOL_TOR },
  { 0xC2173CFA, 32, NDPI_PROTOCOL_TOR },
  { 0xC230DA31, 32, NDPI_PROTOCOL_TOR },
  { 0xC2601297, 32, NDPI_PROTOCOL_TOR },
  { 0xC2680064, 32, NDPI_PROTOCOL_TOR },
  { 0xC26DCED4, 32, NDPI_PROTOCOL_TOR },
  { 0xC276346F, 32, NDPI_PROTOCOL_TOR },
  { 0xC276D253, 32, NDPI_PROTOCOL_TOR },
  { 0xC27EC6E4, 32, NDPI_PROTOCOL_TOR },
  { 0xC296A84F, 32, NDPI_PROTOCOL_TOR },
  { 0xC296A85F, 32, NDPI_PROTOCOL_TOR },
  { 0xC296A86C, 32, NDPI_PROTOCOL_TOR },
  { 0xC2A6A031, 32, NDPI_PROTOCOL_TOR },
  { 0xC313AE72, 32, NDPI_PROTOCOL_TOR },
  { 0xC313AE73, 32, NDPI_PROTOCOL_TOR },
  { 0xC31DA8CE, 32, NDPI_PROTOCOL_TOR },
  { 0xC3236D3D, 32, NDPI_PROTOCOL_TOR },
  { 0xC325BE55, 32, NDPI_PROTOCOL_TOR },
  { 0xC328B523, 32, NDPI_PROTOCOL_TOR },
  { 0xC32EB925, 32, NDPI_PROTOCOL_TOR },
  { 0xC3409582, 32, NDPI_PROTOCOL_TOR },
  { 0xC3474454, 32, NDPI_PROTOCOL_TOR },
  { 0xC3527C6F, 32, NDPI_PROTOCOL_TOR },
  { 0xC358543B, 32, NDPI_PROTOCOL_TOR },
  { 0xC35BED96, 32, NDPI_PROTOCOL_TOR },
  { 0xC36E061F, 32, NDPI_PROTOCOL_TOR },
  { 0xC36E09E8, 32, NDPI_PROTOCOL_TOR },
  { 0xC38AF902, 32, NDPI_PROTOCOL_TOR },
  { 0xC38CFE59, 32, NDPI_PROTOCOL_TOR },
  { 0xC3947CC7, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A057B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A05CD, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0937, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0A9B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0C42, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0D0A, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0D60, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0E28, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A0F75, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A2A65, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A40D6, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A411D, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A43E5, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4682, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4B54, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4BA5, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4DC8, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4E71, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A4E73, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A516C, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A516E, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A51E3, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A51F5, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5258, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A533C, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A57E7, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A5B8B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A610A, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6111, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A611B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A61A0, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6775, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6886, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6935, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6939, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6B56, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6B97, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6C4E, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6D1E, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6D34, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6D9D, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6DCB, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6DDD, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A6E4C, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7095, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A72B9, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A742B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A74E8, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A75A3, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A76AC, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7763, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A79C6, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A79EA, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7BDE, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7E2B, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7EA5, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A7FF6, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A803A, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A8097, 32, NDPI_PROTOCOL_TOR },
  { 0xC39A8879, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA671, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AA671, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AAF14, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AB416, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AD7F0, 32, NDPI_PROTOCOL_TOR },
  { 0xC39ADDED, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AE205, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AE93A, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AF076, 32, NDPI_PROTOCOL_TOR },
  { 0xC39AFB5E, 32, NDPI_PROTOCOL_TOR },
  { 0xC39FA2C2, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A6C926, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A97DE2, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A9C4BC, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A9CF36, 32, NDPI_PROTOCOL_TOR },
  { 0xC3A9D8BF, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B2B57B, 32, NDPI_PROTOCOL_TOR },
  { 0xC3B40BC4, 32, NDPI_PROTOCOL_TOR },
  { 0xC3BFE9DD, 32, NDPI_PROTOCOL_TOR },
  { 0xC3C6F2C2, 32, NDPI_PROTOCOL_TOR },
  { 0xC3CAD33B, 32, NDPI_PROTOCOL_TOR },
  { 0xC3D21DED, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E1D31A, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E42DB0, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E44B83, 32, NDPI_PROTOCOL_TOR },
  { 0xC3E6A853, 32, NDPI_PROTOCOL_TOR },
  { 0xC3EA9856, 32, NDPI_PROTOCOL_TOR },
  { 0xC3F25002, 32, NDPI_PROTOCOL_TOR },
  { 0xC3FAA3B1, 32, NDPI_PROTOCOL_TOR },
  { 0xC3FBFCE2, 32, NDPI_PROTOCOL_TOR },
  { 0xC4252C59, 32, NDPI_PROTOCOL_TOR },
  { 0xC55752E7, 32, NDPI_PROTOCOL_TOR },
  { 0xC5E7DDD3, 32, NDPI_PROTOCOL_TOR },
  { 0xC60C50BB, 32, NDPI_PROTOCOL_TOR },
  { 0xC60C5B69, 32, NDPI_PROTOCOL_TOR },
  { 0xC60C68D0, 32, NDPI_PROTOCOL_TOR },
  { 0xC60F4FC5, 32, NDPI_PROTOCOL_TOR },
  { 0xC61799A1, 32, NDPI_PROTOCOL_TOR },
  { 0xC617B141, 32, NDPI_PROTOCOL_TOR },
  { 0xC617BB9E, 32, NDPI_PROTOCOL_TOR },
  { 0xC617F7CC, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B447E, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B562B, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B562D, 32, NDPI_PROTOCOL_TOR },
  { 0xC61B6D24, 32, NDPI_PROTOCOL_TOR },
  { 0xC6257224, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E8E4A, 32, NDPI_PROTOCOL_TOR },
  { 0xC62E9933, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329148, 32, NDPI_PROTOCOL_TOR },
  { 0xC63291CF, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329228, 32, NDPI_PROTOCOL_TOR },
  { 0xC63292FC, 32, NDPI_PROTOCOL_TOR },
  { 0xC63293EF, 32, NDPI_PROTOCOL_TOR },
  { 0xC632957F, 32, NDPI_PROTOCOL_TOR },
  { 0xC63295A0, 32, NDPI_PROTOCOL_TOR },
  { 0xC632970A, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329766, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329811, 32, NDPI_PROTOCOL_TOR },
  { 0xC6329C4E, 32, NDPI_PROTOCOL_TOR },
  { 0xC632B758, 32, NDPI_PROTOCOL_TOR },
  { 0xC632BF5F, 32, NDPI_PROTOCOL_TOR },
  { 0xC632E716, 32, NDPI_PROTOCOL_TOR },
  { 0xC63482DA, 32, NDPI_PROTOCOL_TOR },
  { 0xC634A041, 32, NDPI_PROTOCOL_TOR },
  { 0xC634A090, 32, NDPI_PROTOCOL_TOR },
  { 0xC634C827, 32, NDPI_PROTOCOL_TOR },
  { 0xC634F4ED, 32, NDPI_PROTOCOL_TOR },
  { 0xC634F7A0, 32, NDPI_PROTOCOL_TOR },
  { 0xC634F7A2, 32, NDPI_PROTOCOL_TOR },
  { 0xC634F7F7, 32, NDPI_PROTOCOL_TOR },
  { 0xC634F7FA, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A601C, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6079, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A66EA, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6793, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6793, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6AF5, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6AF5, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6B34, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6B34, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6B35, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A6D52, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A73D2, 32, NDPI_PROTOCOL_TOR },
  { 0xC63A7FC9, 32, NDPI_PROTOCOL_TOR },
  { 0xC6475142, 32, NDPI_PROTOCOL_TOR },
  { 0xC648E7E9, 32, NDPI_PROTOCOL_TOR },
  { 0xC6493247, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A38BF, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3A10, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3ACE, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3C1A, 32, NDPI_PROTOCOL_TOR },
  { 0xC64A3E6B, 32, NDPI_PROTOCOL_TOR },
  { 0xC654A10C, 32, NDPI_PROTOCOL_TOR },
  { 0xC654F0E5, 32, NDPI_PROTOCOL_TOR },
  { 0xC654F96A, 32, NDPI_PROTOCOL_TOR },
  { 0xC6609B03, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623103, 32, NDPI_PROTOCOL_TOR },
  { 0xC6623495, 32, NDPI_PROTOCOL_TOR },
  { 0xC662358D, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649014, 32, NDPI_PROTOCOL_TOR },
  { 0xC664904B, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649470, 32, NDPI_PROTOCOL_TOR },
  { 0xC664947B, 32, NDPI_PROTOCOL_TOR },
  { 0xC664959F, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649B36, 32, NDPI_PROTOCOL_TOR },
  { 0xC6649BC2, 32, NDPI_PROTOCOL_TOR },
  { 0xC6697D25, 32, NDPI_PROTOCOL_TOR },
  { 0xC6697DB2, 32, NDPI_PROTOCOL_TOR },
  { 0xC669D0A4, 32, NDPI_PROTOCOL_TOR },
  { 0xC669DF92, 32, NDPI_PROTOCOL_TOR },
  { 0xC68F88ED, 32, NDPI_PROTOCOL_TOR },
  { 0xC693141D, 32, NDPI_PROTOCOL_TOR },
  { 0xC693174D, 32, NDPI_PROTOCOL_TOR },
  { 0xC69451A7, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A7895C, 32, NDPI_PROTOCOL_TOR },
  { 0xC6A78F95, 32, NDPI_PROTOCOL_TOR },
  { 0xC6B49609, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C74845, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C76BDC, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77079, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77231, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C775A4, 32, NDPI_PROTOCOL_TOR },
  { 0xC6C77A11, 32, NDPI_PROTOCOL_TOR },
  { 0xC6CD713B, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D36392, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37ABF, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37B5C, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37CD6, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37DF2, 32, NDPI_PROTOCOL_TOR },
  { 0xC6D37E53, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F464C8, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F46963, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53294, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C28, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53C93, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53CC2, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53E68, 32, NDPI_PROTOCOL_TOR },
  { 0xC6F53FE4, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FC9957, 32, NDPI_PROTOCOL_TOR },
  { 0xC6FC996B, 32, NDPI_PROTOCOL_TOR },
  { 0xC710BF3A, 32, NDPI_PROTOCOL_TOR },
  { 0xC71355FC, 32, NDPI_PROTOCOL_TOR },
  { 0xC713D5B0, 32, NDPI_PROTOCOL_TOR },
  { 0xC726567A, 32, NDPI_PROTOCOL_TOR },
  { 0xC73A530A, 32, NDPI_PROTOCOL_TOR },
  { 0xC7579AFF, 32, NDPI_PROTOCOL_TOR },
  { 0xC7737387, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF1, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF2, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF3, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF5, 32, NDPI_PROTOCOL_TOR },
  { 0xC773CDF8, 32, NDPI_PROTOCOL_TOR },
  { 0xC77FE240, 32, NDPI_PROTOCOL_TOR },
  { 0xC7A78088, 32, NDPI_PROTOCOL_TOR },
  { 0xC7A7A1C3, 32, NDPI_PROTOCOL_TOR },
  { 0xC7A7C679, 32, NDPI_PROTOCOL_TOR },
  { 0xC7BC649A, 32, NDPI_PROTOCOL_TOR },
  { 0xC7BCC235, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C173D1, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C1FD31, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3C116, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F83C, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F890, 32, NDPI_PROTOCOL_TOR },
  { 0xC7C3F9D4, 32, NDPI_PROTOCOL_TOR },
  { 0xC7CA151D, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FEEE2C, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FEEE34, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FEEE34, 32, NDPI_PROTOCOL_TOR },
  { 0xC7FFDF58, 32, NDPI_PROTOCOL_TOR },
  { 0xC811D20C, 32, NDPI_PROTOCOL_TOR },
  { 0xC8628B17, 32, NDPI_PROTOCOL_TOR },
  { 0xC86CEC4B, 32, NDPI_PROTOCOL_TOR },
  { 0xC8B55A41, 32, NDPI_PROTOCOL_TOR },
  { 0xC8DFD4D2, 32, NDPI_PROTOCOL_TOR },
  { 0xC906897F, 32, NDPI_PROTOCOL_TOR },
  { 0xC91BEB7F, 32, NDPI_PROTOCOL_TOR },
  { 0xC9AA12B7, 32, NDPI_PROTOCOL_TOR },
  { 0xC9D46CB8, 32, NDPI_PROTOCOL_TOR },
  { 0xC9DA72A2, 32, NDPI_PROTOCOL_TOR },
  { 0xCA07F408, 32, NDPI_PROTOCOL_TOR },
  { 0xCA3C4220, 32, NDPI_PROTOCOL_TOR },
  { 0xCA4A2C0F, 32, NDPI_PROTOCOL_TOR },
  { 0xCA536AB3, 32, NDPI_PROTOCOL_TOR },
  { 0xCA55E922, 32, NDPI_PROTOCOL_TOR },
  { 0xCAAB9C54, 32, NDPI_PROTOCOL_TOR },
  { 0xCAAC1039, 32, NDPI_PROTOCOL_TOR },
  { 0xCB56CAA7, 32, NDPI_PROTOCOL_TOR },
  { 0xCB56CD2E, 32, NDPI_PROTOCOL_TOR },
  { 0xCB6DE90F, 32, NDPI_PROTOCOL_TOR },
  { 0xCB71AC95, 32, NDPI_PROTOCOL_TOR },
  { 0xCB71AC98, 32, NDPI_PROTOCOL_TOR },
  { 0xCB71AC9A, 32, NDPI_PROTOCOL_TOR },
  { 0xCB7B3001, 32, NDPI_PROTOCOL_TOR },
  { 0xCB7E7B52, 32, NDPI_PROTOCOL_TOR },
  { 0xCB8A63DA, 32, NDPI_PROTOCOL_TOR },
  { 0xCB98C302, 32, NDPI_PROTOCOL_TOR },
  { 0xCB99CEA6, 32, NDPI_PROTOCOL_TOR },
  { 0xCBA16711, 32, NDPI_PROTOCOL_TOR },
  { 0xCBB2850B, 32, NDPI_PROTOCOL_TOR },
  { 0xCBCEEDC5, 32, NDPI_PROTOCOL_TOR },
  { 0xCBD9AD92, 32, NDPI_PROTOCOL_TOR },
  { 0xCC089C8E, 32, NDPI_PROTOCOL_TOR },
  { 0xCC093747, 32, NDPI_PROTOCOL_TOR },
  { 0xCC0B3283, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1025F4, 32, NDPI_PROTOCOL_TOR },
  { 0xCC11382A, 32, NDPI_PROTOCOL_TOR },
  { 0xCC11382A, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1B382D, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1B382D, 32, NDPI_PROTOCOL_TOR },
  { 0xCC1B3ACA, 32, NDPI_PROTOCOL_TOR },
  { 0xCC2D1E7A, 32, NDPI_PROTOCOL_TOR },
  { 0xCC2D1E7D, 32, NDPI_PROTOCOL_TOR },
  { 0xCC2DB6E2, 32, NDPI_PROTOCOL_TOR },
  { 0xCC534638, 32, NDPI_PROTOCOL_TOR },
  { 0xCC55BF1E, 32, NDPI_PROTOCOL_TOR },
  { 0xCC59C10A, 32, NDPI_PROTOCOL_TOR },
  { 0xCC7C5382, 32, NDPI_PROTOCOL_TOR },
  { 0xCC7C5382, 32, NDPI_PROTOCOL_TOR },
  { 0xCC7C5386, 32, NDPI_PROTOCOL_TOR },
  { 0xCC7C5386, 32, NDPI_PROTOCOL_TOR },
  { 0xCC91512D, 32, NDPI_PROTOCOL_TOR },
  { 0xCCC21D04, 32, NDPI_PROTOCOL_TOR },
  { 0xCCF67A48, 32, NDPI_PROTOCOL_TOR },
  { 0xCDA85485, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB973EA, 32, NDPI_PROTOCOL_TOR },
  { 0xCDB97A98, 32, NDPI_PROTOCOL_TOR },
  { 0xCE2876E5, 32, NDPI_PROTOCOL_TOR },
  { 0xCE374A00, 32, NDPI_PROTOCOL_TOR },
  { 0xCE374A01, 32, NDPI_PROTOCOL_TOR },
  { 0xCE48C698, 32, NDPI_PROTOCOL_TOR },
  { 0xCEAE7054, 32, NDPI_PROTOCOL_TOR },
  { 0xCEBE9906, 32, NDPI_PROTOCOL_TOR },
  { 0xCF268613, 32, NDPI_PROTOCOL_TOR },
  { 0xCF6CDABA, 32, NDPI_PROTOCOL_TOR },
  { 0xCF9E0F72, 32, NDPI_PROTOCOL_TOR },
  { 0xCFACD159, 32, NDPI_PROTOCOL_TOR },
  { 0xCFBD72D7, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC046FA, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC9DFC3, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC9DFC4, 32, NDPI_PROTOCOL_TOR },
  { 0xCFC9DFC5, 32, NDPI_PROTOCOL_TOR },
  { 0xCFE54199, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF44B8E, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF4526D, 32, NDPI_PROTOCOL_TOR },
  { 0xCFF4526D, 32, NDPI_PROTOCOL_TOR },
  { 0xD041B5BD, 32, NDPI_PROTOCOL_TOR },
  { 0xD0421E1B, 32, NDPI_PROTOCOL_TOR },
  { 0xD049CCE4, 32, NDPI_PROTOCOL_TOR },
  { 0xD04FD17C, 32, NDPI_PROTOCOL_TOR },
  { 0xD04FD34D, 32, NDPI_PROTOCOL_TOR },
  { 0xD0509A27, 32, NDPI_PROTOCOL_TOR },
  { 0xD0526625, 32, NDPI_PROTOCOL_TOR },
  { 0xD053DF22, 32, NDPI_PROTOCOL_TOR },
  { 0xD053DFE5, 32, NDPI_PROTOCOL_TOR },
  { 0xD0549BCD, 32, NDPI_PROTOCOL_TOR },
  { 0xD0549BF3, 32, NDPI_PROTOCOL_TOR },
  { 0xD0549BF7, 32, NDPI_PROTOCOL_TOR },
  { 0xD056FB58, 32, NDPI_PROTOCOL_TOR },
  { 0xD05B798E, 32, NDPI_PROTOCOL_TOR },
  { 0xD065161A, 32, NDPI_PROTOCOL_TOR },
  { 0xD06F2350, 32, NDPI_PROTOCOL_TOR },
  { 0xD1063507, 32, NDPI_PROTOCOL_TOR },
  { 0xD106441D, 32, NDPI_PROTOCOL_TOR },
  { 0xD10685EE, 32, NDPI_PROTOCOL_TOR },
  { 0xD111BF75, 32, NDPI_PROTOCOL_TOR },
  { 0xD12C72B2, 32, NDPI_PROTOCOL_TOR },
  { 0xD133A319, 32, NDPI_PROTOCOL_TOR },
  { 0xD133BFBE, 32, NDPI_PROTOCOL_TOR },
  { 0xD1709F3C, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC25, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC25, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC26, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC26, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC27, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC27, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC28, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC28, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC29, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC29, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC2A, 32, NDPI_PROTOCOL_TOR },
  { 0xD177BC2A, 32, NDPI_PROTOCOL_TOR },
  { 0xD17BA242, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E47E9, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E4854, 32, NDPI_PROTOCOL_TOR },
  { 0xD17E6907, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D23E8, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D242A, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D2ECC, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D328A, 32, NDPI_PROTOCOL_TOR },
  { 0xD18D34EF, 32, NDPI_PROTOCOL_TOR },
  { 0xD1942E81, 32, NDPI_PROTOCOL_TOR },
  { 0xD1942E82, 32, NDPI_PROTOCOL_TOR },
  { 0xD1942E82, 32, NDPI_PROTOCOL_TOR },
  { 0xD1945576, 32, NDPI_PROTOCOL_TOR },
  { 0xD19F8A13, 32, NDPI_PROTOCOL_TOR },
  { 0xD1A221CF, 32, NDPI_PROTOCOL_TOR },
  { 0xD1B5E383, 32, NDPI_PROTOCOL_TOR },
  { 0xD1D01A29, 32, NDPI_PROTOCOL_TOR },
  { 0xD1D04F05, 32, NDPI_PROTOCOL_TOR },
  { 0xD1D2D215, 32, NDPI_PROTOCOL_TOR },
  { 0xD1DE08C4, 32, NDPI_PROTOCOL_TOR },
  { 0xD1DE1EF1, 32, NDPI_PROTOCOL_TOR },
  { 0xD1FA02FE, 32, NDPI_PROTOCOL_TOR },
  { 0xD217021E, 32, NDPI_PROTOCOL_TOR },
  { 0xD23625E2, 32, NDPI_PROTOCOL_TOR },
  { 0xD2A6194E, 32, NDPI_PROTOCOL_TOR },
  { 0xD2C33DFC, 32, NDPI_PROTOCOL_TOR },
  { 0xD2D37ACC, 32, NDPI_PROTOCOL_TOR },
  { 0xD2FBD989, 32, NDPI_PROTOCOL_TOR },
  { 0xD31AF36D, 32, NDPI_PROTOCOL_TOR },
  { 0xD31C8EEF, 32, NDPI_PROTOCOL_TOR },
  { 0xD31FC4F8, 32, NDPI_PROTOCOL_TOR },
  { 0xD3CA291F, 32, NDPI_PROTOCOL_TOR },
  { 0xD407C247, 32, NDPI_PROTOCOL_TOR },
  { 0xD407DC06, 32, NDPI_PROTOCOL_TOR },
  { 0xD40A5604, 32, NDPI_PROTOCOL_TOR },
  { 0xD40CCB27, 32, NDPI_PROTOCOL_TOR },
  { 0xD41010B8, 32, NDPI_PROTOCOL_TOR },
  { 0xD4106821, 32, NDPI_PROTOCOL_TOR },
  { 0xD411664D, 32, NDPI_PROTOCOL_TOR },
  { 0xD41824CD, 32, NDPI_PROTOCOL_TOR },
  { 0xD41890BC, 32, NDPI_PROTOCOL_TOR },
  { 0xD421F581, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE209, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE3AC, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE3AC, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE445, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE459, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE5D1, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE5D1, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE745, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE784, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE80D, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE8F6, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FE97E, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEA54, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FEB57, 32, NDPI_PROTOCOL_TOR },
  { 0xD42FECDB, 32, NDPI_PROTOCOL_TOR },
  { 0xD4305435, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339C5A, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339C8F, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339C9E, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339C9E, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339F4E, 32, NDPI_PROTOCOL_TOR },
  { 0xD4339F72, 32, NDPI_PROTOCOL_TOR },
  { 0xD438D698, 32, NDPI_PROTOCOL_TOR },
  { 0xD4402044, 32, NDPI_PROTOCOL_TOR },
  { 0xD447EECB, 32, NDPI_PROTOCOL_TOR },
  { 0xD447F805, 32, NDPI_PROTOCOL_TOR },
  { 0xD447F945, 32, NDPI_PROTOCOL_TOR },
  { 0xD447F945, 32, NDPI_PROTOCOL_TOR },
  { 0xD447F981, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FC6D, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FC74, 32, NDPI_PROTOCOL_TOR },
  { 0xD447FDE2, 32, NDPI_PROTOCOL_TOR },
  { 0xD44AFEF3, 32, NDPI_PROTOCOL_TOR },
  { 0xD44DE210, 32, NDPI_PROTOCOL_TOR },
  { 0xD44DE2F5, 32, NDPI_PROTOCOL_TOR },
  { 0xD4532F5B, 32, NDPI_PROTOCOL_TOR },
  { 0xD45394CD, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539A21, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539A21, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539E05, 32, NDPI_PROTOCOL_TOR },
  { 0xD4539E14, 32, NDPI_PROTOCOL_TOR },
  { 0xD453A298, 32, NDPI_PROTOCOL_TOR },
  { 0xD453A7AF, 32, NDPI_PROTOCOL_TOR },
  { 0xD453AAFC, 32, NDPI_PROTOCOL_TOR },
  { 0xD453B07A, 32, NDPI_PROTOCOL_TOR },
  { 0xD453B07D, 32, NDPI_PROTOCOL_TOR },
  { 0xD453BECB, 32, NDPI_PROTOCOL_TOR },
  { 0xD4554F44, 32, NDPI_PROTOCOL_TOR },
  { 0xD4554F47, 32, NDPI_PROTOCOL_TOR },
  { 0xD45CDB0F, 32, NDPI_PROTOCOL_TOR },
  { 0xD467903A, 32, NDPI_PROTOCOL_TOR },
  { 0xD46A09CE, 32, NDPI_PROTOCOL_TOR },
  { 0xD46B9591, 32, NDPI_PROTOCOL_TOR },
  { 0xD4722F34, 32, NDPI_PROTOCOL_TOR },
  { 0xD472303A, 32, NDPI_PROTOCOL_TOR },
  { 0xD4726D21, 32, NDPI_PROTOCOL_TOR },
  { 0xD472FA12, 32, NDPI_PROTOCOL_TOR },
  { 0xD472FE5B, 32, NDPI_PROTOCOL_TOR },
  { 0xD4758F4A, 32, NDPI_PROTOCOL_TOR },
  { 0xD475B46B, 32, NDPI_PROTOCOL_TOR },
  { 0xD4763E03, 32, NDPI_PROTOCOL_TOR },
  { 0xD47CB453, 32, NDPI_PROTOCOL_TOR },
  { 0xD4810454, 32, NDPI_PROTOCOL_TOR },
  { 0xD48110B6, 32, NDPI_PROTOCOL_TOR },
  { 0xD4811AF6, 32, NDPI_PROTOCOL_TOR },
  { 0xD4812A09, 32, NDPI_PROTOCOL_TOR },
  { 0xD48132F6, 32, NDPI_PROTOCOL_TOR },
  { 0xD4813431, 32, NDPI_PROTOCOL_TOR },
  { 0xD495D15B, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F5B16, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F70C4, 32, NDPI_PROTOCOL_TOR },
  { 0xD49F8F53, 32, NDPI_PROTOCOL_TOR },
  { 0xD49FB1C6, 32, NDPI_PROTOCOL_TOR },
  { 0xD4A4EF79, 32, NDPI_PROTOCOL_TOR },
  { 0xD4B733DE, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BA59A2, 32, NDPI_PROTOCOL_TOR },
  { 0xD4BBC8AA, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C04A64, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C04A65, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C63318, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C6C924, 32, NDPI_PROTOCOL_TOR },
  { 0xD4C6E391, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E054E3, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E059FD, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E326F7, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E38BC3, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E3F876, 32, NDPI_PROTOCOL_TOR },
  { 0xD4E81D65, 32, NDPI_PROTOCOL_TOR },
  { 0xD4FAA0B2, 32, NDPI_PROTOCOL_TOR },
  { 0xD4FAA0BB, 32, NDPI_PROTOCOL_TOR },
  { 0xD5095DAE, 32, NDPI_PROTOCOL_TOR },
  { 0xD52C58EA, 32, NDPI_PROTOCOL_TOR },
  { 0xD52F2397, 32, NDPI_PROTOCOL_TOR },
  { 0xD52F4B43, 32, NDPI_PROTOCOL_TOR },
  { 0xD5317328, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D957D, 32, NDPI_PROTOCOL_TOR },
  { 0xD53D957E, 32, NDPI_PROTOCOL_TOR },
  { 0xD540E2E6, 32, NDPI_PROTOCOL_TOR },
  { 0xD5430E91, 32, NDPI_PROTOCOL_TOR },
  { 0xD54951D2, 32, NDPI_PROTOCOL_TOR },
  { 0xD5497087, 32, NDPI_PROTOCOL_TOR },
  { 0xD5582A31, 32, NDPI_PROTOCOL_TOR },
  { 0xD55F1536, 32, NDPI_PROTOCOL_TOR },
  { 0xD55F153B, 32, NDPI_PROTOCOL_TOR },
  { 0xD56B4D04, 32, NDPI_PROTOCOL_TOR },
  { 0xD56C6947, 32, NDPI_PROTOCOL_TOR },
  { 0xD56C69FD, 32, NDPI_PROTOCOL_TOR },
  { 0xD56CD7EE, 32, NDPI_PROTOCOL_TOR },
  { 0xD56FF097, 32, NDPI_PROTOCOL_TOR },
  { 0xD57086D3, 32, NDPI_PROTOCOL_TOR },
  { 0xD570C73F, 32, NDPI_PROTOCOL_TOR },
  { 0xD5713D6A, 32, NDPI_PROTOCOL_TOR },
  { 0xD5717790, 32, NDPI_PROTOCOL_TOR },
  { 0xD571D5BE, 32, NDPI_PROTOCOL_TOR },
  { 0xD5724869, 32, NDPI_PROTOCOL_TOR },
  { 0xD57293E0, 32, NDPI_PROTOCOL_TOR },
  { 0xD572966F, 32, NDPI_PROTOCOL_TOR },
  { 0xD572E864, 32, NDPI_PROTOCOL_TOR },
  { 0xD57F85A7, 32, NDPI_PROTOCOL_TOR },
  { 0xD57F921B, 32, NDPI_PROTOCOL_TOR },
  { 0xD585639C, 32, NDPI_PROTOCOL_TOR },
  { 0xD5856D29, 32, NDPI_PROTOCOL_TOR },
  { 0xD5856DA5, 32, NDPI_PROTOCOL_TOR },
  { 0xD5857B97, 32, NDPI_PROTOCOL_TOR },
  { 0xD58845ED, 32, NDPI_PROTOCOL_TOR },
  { 0xD5884715, 32, NDPI_PROTOCOL_TOR },
  { 0xD5884B2A, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885261, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885674, 32, NDPI_PROTOCOL_TOR },
  { 0xD58857F5, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885A9B, 32, NDPI_PROTOCOL_TOR },
  { 0xD5885CA9, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A653C, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A66D1, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A6E58, 32, NDPI_PROTOCOL_TOR },
  { 0xD58A71E8, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D8818, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D8D93, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D95E3, 32, NDPI_PROTOCOL_TOR },
  { 0xD58D9EED, 32, NDPI_PROTOCOL_TOR },
  { 0xD58E2E79, 32, NDPI_PROTOCOL_TOR },
  { 0xD58F7A02, 32, NDPI_PROTOCOL_TOR },
  { 0xD59B0490, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A3482F, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A348A2, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A54610, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A54F22, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A54FF3, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A55106, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A5551E, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A55546, 32, NDPI_PROTOCOL_TOR },
  { 0xD5A555F9, 32, NDPI_PROTOCOL_TOR },
  { 0xD5AFD83B, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B39EF1, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B73821, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B7388C, 32, NDPI_PROTOCOL_TOR },
  { 0xD5B9E355, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BA07E8, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BB54BE, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BB6FFE, 32, NDPI_PROTOCOL_TOR },
  { 0xD5BC77C9, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C489E3, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C5167C, 32, NDPI_PROTOCOL_TOR },
  { 0xD5C52469, 32, NDPI_PROTOCOL_TOR },
  { 0xD5D0BCCB, 32, NDPI_PROTOCOL_TOR },
  { 0xD5D3FC58, 32, NDPI_PROTOCOL_TOR },
  { 0xD5DE7461, 32, NDPI_PROTOCOL_TOR },
  { 0xD5E3FAF5, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFC519, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD329, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD414, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD6AF, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD8DE, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFD912, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFDA14, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFDA93, 32, NDPI_PROTOCOL_TOR },
  { 0xD5EFF9DB, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F05E3A, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F06C19, 32, NDPI_PROTOCOL_TOR },
  { 0xD5F53D3D, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FBBB37, 32, NDPI_PROTOCOL_TOR },
  { 0xD5FBC7AE, 32, NDPI_PROTOCOL_TOR },
  { 0xD80CC652, 32, NDPI_PROTOCOL_TOR },
  { 0xD80CC653, 32, NDPI_PROTOCOL_TOR },
  { 0xD80F0122, 32, NDPI_PROTOCOL_TOR },
  { 0xD8116382, 32, NDPI_PROTOCOL_TOR },
  { 0xD8116390, 32, NDPI_PROTOCOL_TOR },
  { 0xD811654F, 32, NDPI_PROTOCOL_TOR },
  { 0xD81169CB, 32, NDPI_PROTOCOL_TOR },
  { 0xD8116EE7, 32, NDPI_PROTOCOL_TOR },
  { 0xD818AEF5, 32, NDPI_PROTOCOL_TOR },
  { 0xD8425592, 32, NDPI_PROTOCOL_TOR },
  { 0xD873031A, 32, NDPI_PROTOCOL_TOR },
  { 0xD873063A, 32, NDPI_PROTOCOL_TOR },
  { 0xD892E107, 32, NDPI_PROTOCOL_TOR },
  { 0xD89A71F4, 32, NDPI_PROTOCOL_TOR },
  { 0xD8A13759, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BAC1C9, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BD9264, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BD9575, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BD9666, 32, NDPI_PROTOCOL_TOR },
  { 0xD8BD9718, 32, NDPI_PROTOCOL_TOR },
  { 0xD8C3851B, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DA860C, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DAD8C2, 32, NDPI_PROTOCOL_TOR },
  { 0xD8DD24F4, 32, NDPI_PROTOCOL_TOR },
  { 0xD8E6E69C, 32, NDPI_PROTOCOL_TOR },
  { 0xD8E6E6F7, 32, NDPI_PROTOCOL_TOR },
  { 0xD8F455D3, 32, NDPI_PROTOCOL_TOR },
  { 0xD90833AD, 32, NDPI_PROTOCOL_TOR },
  { 0xD90B39E2, 32, NDPI_PROTOCOL_TOR },
  { 0xD90B7727, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC7BE, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CC7D1, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCB2E, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCC59, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCC68, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CCC93, 32, NDPI_PROTOCOL_TOR },
  { 0xD90CD075, 32, NDPI_PROTOCOL_TOR },
  { 0xD90D4A29, 32, NDPI_PROTOCOL_TOR },
  { 0xD90DC505, 32, NDPI_PROTOCOL_TOR },
  { 0xD910B514, 32, NDPI_PROTOCOL_TOR },
  { 0xD910B614, 32, NDPI_PROTOCOL_TOR },
  { 0xD91318D8, 32, NDPI_PROTOCOL_TOR },
  { 0xD91318E9, 32, NDPI_PROTOCOL_TOR },
  { 0xD917011B, 32, NDPI_PROTOCOL_TOR },
  { 0xD91A1259, 32, NDPI_PROTOCOL_TOR },
  { 0xD91BB67D, 32, NDPI_PROTOCOL_TOR },
  { 0xD92287E1, 32, NDPI_PROTOCOL_TOR },
  { 0xD92287E7, 32, NDPI_PROTOCOL_TOR },
  { 0xD9251373, 32, NDPI_PROTOCOL_TOR },
  { 0xD92855C2, 32, NDPI_PROTOCOL_TOR },
  { 0xD928FEB1, 32, NDPI_PROTOCOL_TOR },
  { 0xD943154D, 32, NDPI_PROTOCOL_TOR },
  { 0xD945FE58, 32, NDPI_PROTOCOL_TOR },
  { 0xD946BD91, 32, NDPI_PROTOCOL_TOR },
  { 0xD946BF0D, 32, NDPI_PROTOCOL_TOR },
  { 0xD948141E, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB23C, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB532, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB538, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FB65F, 32, NDPI_PROTOCOL_TOR },
  { 0xD94FBE19, 32, NDPI_PROTOCOL_TOR },
  { 0xD954FBD5, 32, NDPI_PROTOCOL_TOR },
  { 0xD95597B5, 32, NDPI_PROTOCOL_TOR },
  { 0xD95EEEF5, 32, NDPI_PROTOCOL_TOR },
  { 0xD970833A, 32, NDPI_PROTOCOL_TOR },
  { 0xD97293F5, 32, NDPI_PROTOCOL_TOR },
  { 0xD972DA12, 32, NDPI_PROTOCOL_TOR },
  { 0xD9730A85, 32, NDPI_PROTOCOL_TOR },
  { 0xD9730A86, 32, NDPI_PROTOCOL_TOR },
  { 0xD97729D5, 32, NDPI_PROTOCOL_TOR },
  { 0xD97BFEEE, 32, NDPI_PROTOCOL_TOR },
  { 0xD98090A0, 32, NDPI_PROTOCOL_TOR },
  { 0xD991C735, 32, NDPI_PROTOCOL_TOR },
  { 0xD9924B24, 32, NDPI_PROTOCOL_TOR },
  { 0xD99454B4, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A0122D, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A013EC, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A05C43, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A07E32, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A083B0, 32, NDPI_PROTOCOL_TOR },
  { 0xD9A276FE, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AACD71, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACB392, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACBE13, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACBE13, 32, NDPI_PROTOCOL_TOR },
  { 0xD9ACFFE5, 32, NDPI_PROTOCOL_TOR },
  { 0xD9AD4A5B, 32, NDPI_PROTOCOL_TOR },
  { 0xD9BCEA09, 32, NDPI_PROTOCOL_TOR },
  { 0xD9BDC5F4, 32, NDPI_PROTOCOL_TOR },
  { 0xD9BF49C3, 32, NDPI_PROTOCOL_TOR },
  { 0xD9BF6813, 32, NDPI_PROTOCOL_TOR },
  { 0xD9BFF274, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C3AA91, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C504DC, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C553A2, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C556AD, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55B91, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55B91, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C55BA4, 32, NDPI_PROTOCOL_TOR },
  { 0xD9C5B52D, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D075D3, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D11257, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D27158, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D28C5F, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D2A52B, 32, NDPI_PROTOCOL_TOR },
  { 0xD9D39FA1, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E40B41, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E46874, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E76B72, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E94FC8, 32, NDPI_PROTOCOL_TOR },
  { 0xD9E94FC8, 32, NDPI_PROTOCOL_TOR },
  { 0xD9EA6B0B, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F595B7, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F63320, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F76904, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F7DE9C, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F7E61F, 32, NDPI_PROTOCOL_TOR },
  { 0xD9F9203E, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FBD765, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FD96F6, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FD9F48, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FE3DAC, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FE47CC, 32, NDPI_PROTOCOL_TOR },
  { 0xD9FEB60F, 32, NDPI_PROTOCOL_TOR },
  { 0xDAA1200E, 32, NDPI_PROTOCOL_TOR },
  { 0xDAE7EBDB, 32, NDPI_PROTOCOL_TOR },
  { 0xDAE868DC, 32, NDPI_PROTOCOL_TOR },
  { 0xDAE868DD, 32, NDPI_PROTOCOL_TOR },
  { 0xDAFAF536, 32, NDPI_PROTOCOL_TOR },
  { 0xDB4F067A, 32, NDPI_PROTOCOL_TOR },
  { 0xDB59C4CA, 32, NDPI_PROTOCOL_TOR },
  { 0xDB6DCB40, 32, NDPI_PROTOCOL_TOR },
  { 0xDB75CE2E, 32, NDPI_PROTOCOL_TOR },
  { 0xDB791014, 32, NDPI_PROTOCOL_TOR },
  { 0xDBA189F3, 32, NDPI_PROTOCOL_TOR },
  { 0xDBA4C22E, 32, NDPI_PROTOCOL_TOR },
  { 0xDBAD0E54, 32, NDPI_PROTOCOL_TOR },
  { 0xDC39428E, 32, NDPI_PROTOCOL_TOR },
  { 0xDC87FE3F, 32, NDPI_PROTOCOL_TOR },
  { 0xDC898752, 32, NDPI_PROTOCOL_TOR },
  { 0xDC9387F3, 32, NDPI_PROTOCOL_TOR },
  { 0xDC9DC3F3, 32, NDPI_PROTOCOL_TOR },
  { 0xDCE97BAC, 32, NDPI_PROTOCOL_TOR },
  { 0xDCE9AF0E, 32, NDPI_PROTOCOL_TOR },
  { 0xDCFD1CE1, 32, NDPI_PROTOCOL_TOR },
  { 0xDCFF85C3, 32, NDPI_PROTOCOL_TOR },
  { 0xDD7132CB, 32, NDPI_PROTOCOL_TOR },
  { 0xDD9E95C5, 32, NDPI_PROTOCOL_TOR },
  { 0xDE047C92, 32, NDPI_PROTOCOL_TOR },
  { 0xDE0C7C9A, 32, NDPI_PROTOCOL_TOR },
  { 0xDE7294F8, 32, NDPI_PROTOCOL_TOR },
  { 0xDEEB761A, 32, NDPI_PROTOCOL_TOR },
  { 0xDF1273E5, 32, NDPI_PROTOCOL_TOR },
  { 0xDF85F4CA, 32, NDPI_PROTOCOL_TOR },
  { 0xDFE57B41, 32, NDPI_PROTOCOL_TOR },

  /*
    Twitch ingestion servers :
    https://api.twitch.tv/kraken/ingests
    Edoardo Dominici edoaramis@gmail.com
  */
  { 0xB92ACC5D, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACC92, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACCA4, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACCCD, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACC30, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FE15, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FE19, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACD305, 32, NDPI_SERVICE_TWITCH },
  { 0xC0104616, 32, NDPI_SERVICE_TWITCH },
  { 0xC010461D, 32, NDPI_SERVICE_TWITCH },
  { 0xC0104650, 32, NDPI_SERVICE_TWITCH },
  { 0xC0104651, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FEA3, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FE87, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACD85, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACDA4, 32, NDPI_SERVICE_TWITCH },
  { 0xC010419A, 32, NDPI_SERVICE_TWITCH },
  { 0xC01041AD, 32, NDPI_SERVICE_TWITCH },
  { 0xC0104172, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACD68, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACD55, 32, NDPI_SERVICE_TWITCH },
  { 0xC0104219, 32, NDPI_SERVICE_TWITCH },
  { 0xC010421A, 32, NDPI_SERVICE_TWITCH },
  { 0xC010421B, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACD205, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACCB05, 32, NDPI_SERVICE_TWITCH },
  { 0xC010413C, 32, NDPI_SERVICE_TWITCH },
  { 0xC010413D, 32, NDPI_SERVICE_TWITCH },
  { 0xC010413E, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACD105, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACD005, 32, NDPI_SERVICE_TWITCH },
  { 0xBCACCA05, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACD06, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACD14, 32, NDPI_SERVICE_TWITCH },
  { 0xB92ACCF3, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F9C7, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F9C9, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F9CB, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBA4, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBA6, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBAA, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBB1, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBE8, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBE9, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBEA, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBEB, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBFB, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBFC, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBFD, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FBFE, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FF4B, 32, NDPI_SERVICE_TWITCH },
  { 0xC709FF4C, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F974, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F976, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F978, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F97D, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F985, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F986, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F987, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F98C, 32, NDPI_SERVICE_TWITCH },
  { 0xC709F9C5, 32, NDPI_SERVICE_TWITCH },

  /* Simet - 200.160.4.0/24 */
  { 0xC8A00400, 24, NDPI_SERVICE_SIMET },

  /*
    AnchorFree (Hotspot Shield)
    AnchorFree Inc. AFNETWORK-1 (NET-74-115-0-0-1) 74.115.0.0 - 74.115.7.255
  */
  { 0x4A730000, 21, NDPI_SERVICE_HOTSPOT_SHIELD },

  { 0x0, 0, 0 }
};

/* ****************************************************** */

/*
  Host-based match

  HTTP:  Server: field
  HTTPS: Server certificate name
*/

ndpi_protocol_match host_match[] = {
  { "amazon.",  			"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazon.com",  			"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { "images-amazon.com", 		"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazonaws.com",			"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { "amazon-adsystem.com",		"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { ".cloudfront.net",    		"Amazon",		NDPI_SERVICE_AMAZON, NDPI_PROTOCOL_ACCEPTABLE },
  { ".apple.com",			"Apple",		NDPI_SERVICE_APPLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".mzstatic.com",			"Apple",		NDPI_SERVICE_APPLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".icloud.com",			"AppleiCloud",		NDPI_SERVICE_APPLE_ICLOUD, NDPI_PROTOCOL_ACCEPTABLE },
  { "itunes.apple.com",			"AppleiTunes",		NDPI_SERVICE_APPLE_ITUNES, NDPI_PROTOCOL_FUN },
  { ".cnn.c",				"CNN",			NDPI_SERVICE_CNN, NDPI_PROTOCOL_FUN },
  { ".cnn.net",				"CNN",			NDPI_SERVICE_CNN, NDPI_PROTOCOL_FUN },
  { ".dropbox.com",			"DropBox",		NDPI_SERVICE_DROPBOX, NDPI_PROTOCOL_SAFE },
  { "log.getdropbox.com",		"DropBox",		NDPI_SERVICE_DROPBOX, NDPI_PROTOCOL_SAFE },
  { ".ebay.",				"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebay.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebaystatic.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebaydesc.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebayrtm.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebaystratus.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ebayimg.com",			"eBay",			NDPI_SERVICE_EBAY, NDPI_PROTOCOL_ACCEPTABLE },
  { ".facebook.com",			"Facebook",		NDPI_SERVICE_FACEBOOK, NDPI_PROTOCOL_FUN },
  { "fbstatic-a.akamaihd.net",		"Facebook",		NDPI_SERVICE_FACEBOOK, NDPI_PROTOCOL_FUN },
  { ".fbcdn.net",			"Facebook",		NDPI_SERVICE_FACEBOOK, NDPI_PROTOCOL_FUN },
  { "fbcdn-",				"Facebook",		NDPI_SERVICE_FACEBOOK, NDPI_PROTOCOL_FUN },      /* fbcdn-video-a-akamaihd.net */
  { ".facebook.net",			"Facebook",		NDPI_SERVICE_FACEBOOK, NDPI_PROTOCOL_FUN },
  { ".google.",				"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".gstatic.com",			"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".googlesyndication.com",		"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".googletagservices.com",		"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".2mdn.net",			"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".doubleclick.net",			"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE }, /* Ads */
  { "googleads.",			"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "google-analytics.",		"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "googleusercontent.",		"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "googleadservices.",		"Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "googleapis.com",	   	        "Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "ggpht.com",	   	        "Google",		NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "1e100.net",                        "Google",               NDPI_SERVICE_GOOGLE, NDPI_PROTOCOL_ACCEPTABLE },
  { "maps.google.",			"GoogleMaps",		NDPI_SERVICE_GOOGLE_MAPS, NDPI_PROTOCOL_ACCEPTABLE },
  { "maps.gstatic.com",			"GoogleMaps",		NDPI_SERVICE_GOOGLE_MAPS, NDPI_PROTOCOL_ACCEPTABLE },
  { ".gmail.",				"GMail",		NDPI_SERVICE_GMAIL, NDPI_PROTOCOL_SAFE },
  { "mail.google.",			"GMail",		NDPI_SERVICE_GMAIL, NDPI_PROTOCOL_SAFE },
  { ".last.fm",				"LastFM",		NDPI_SERVICE_LASTFM, NDPI_PROTOCOL_FUN },
  { "msn.com",				"MSN",			NDPI_SERVICE_MSN, NDPI_PROTOCOL_FUN },
  { "netflix.com",			"NetFlix",		NDPI_SERVICE_NETFLIX, NDPI_PROTOCOL_FUN	},
  { "nflxext.com",			"NetFlix",		NDPI_SERVICE_NETFLIX, NDPI_PROTOCOL_FUN	},
  { "nflximg.com",			"NetFlix",		NDPI_SERVICE_NETFLIX, NDPI_PROTOCOL_FUN },
  { "nflximg.net",			"NetFlix",		NDPI_SERVICE_NETFLIX, NDPI_PROTOCOL_FUN },
  { "nflxvideo.net",			"NetFlix",		NDPI_SERVICE_NETFLIX, NDPI_PROTOCOL_FUN },
  { ".skype.",				"Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeassets.",			"Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypedata.",			"Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeecs-", /* no final . */	"Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".skypeforbusiness.",       	"Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".lync.com",   	                "Skype",		NDPI_SERVICE_SKYPE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".tuenti.com",			"Tuenti",		NDPI_SERVICE_TUENTI, NDPI_PROTOCOL_ACCEPTABLE },
  { ".twttr.com",			"Twitter",		NDPI_SERVICE_TWITTER, NDPI_PROTOCOL_ACCEPTABLE },
  { "twitter.",				"Twitter",		NDPI_SERVICE_TWITTER, NDPI_PROTOCOL_ACCEPTABLE },
  { "twimg.com",			"Twitter",		NDPI_SERVICE_TWITTER, NDPI_PROTOCOL_ACCEPTABLE },
  { ".viber.com",			"Viber",		NDPI_SERVICE_VIBER, NDPI_PROTOCOL_ACCEPTABLE },
  { ".cdn.viber.com",			"Viber",		NDPI_SERVICE_VIBER, NDPI_PROTOCOL_ACCEPTABLE },  
  { "wikipedia.",			"Wikipedia",		NDPI_SERVICE_WIKIPEDIA, NDPI_PROTOCOL_ACCEPTABLE },
  { "wikimedia.",			"Wikipedia",		NDPI_SERVICE_WIKIPEDIA, NDPI_PROTOCOL_ACCEPTABLE },
  { "mediawiki.",			"Wikipedia",		NDPI_SERVICE_WIKIPEDIA, NDPI_PROTOCOL_ACCEPTABLE },
  { "wikimediafoundation.",		"Wikipedia",		NDPI_SERVICE_WIKIPEDIA, NDPI_PROTOCOL_ACCEPTABLE },
  { ".whatsapp.",			"WhatsApp",		NDPI_SERVICE_WHATSAPP, NDPI_PROTOCOL_ACCEPTABLE },
  { ".yahoo.",				"Yahoo",		NDPI_SERVICE_YAHOO, NDPI_PROTOCOL_ACCEPTABLE },
  { ".yimg.com",			"Yahoo",		NDPI_SERVICE_YAHOO, NDPI_PROTOCOL_ACCEPTABLE },
  { "yahooapis.",			"Yahoo",		NDPI_SERVICE_YAHOO, NDPI_PROTOCOL_ACCEPTABLE },
  { "youtube.",				"YouTube",		NDPI_SERVICE_YOUTUBE, NDPI_PROTOCOL_FUN },
  { ".googlevideo.com",			"YouTube",		NDPI_SERVICE_YOUTUBE, NDPI_PROTOCOL_FUN },
  { ".ytimg.com",			"YouTube",		NDPI_SERVICE_YOUTUBE, NDPI_PROTOCOL_FUN },
  { "youtube-nocookie.",		"YouTube",		NDPI_SERVICE_YOUTUBE, NDPI_PROTOCOL_FUN },
  { ".vevo.com",			"Vevo",			NDPI_SERVICE_VEVO,    NDPI_PROTOCOL_FUN },
  { ".spotify.",			"Spotify",		NDPI_PROTOCOL_SPOTIFY, NDPI_PROTOCOL_FUN },
  { ".pandora.com",			"Pandora",		NDPI_SERVICE_PANDORA,  NDPI_PROTOCOL_FUN },
  { ".torproject.org",                  "Tor",                  NDPI_PROTOCOL_TOR, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
  { "appmeutim.tim.com.br",             "TIM_Meu",              NDPI_SERVICE_TIMMEU, NDPI_PROTOCOL_ACCEPTABLE },
  { ".timtorcedor.com.br",              "Torcedor",             NDPI_SERVICE_TORCEDOR, NDPI_PROTOCOL_ACCEPTABLE },
  { ".kakao.com",                       "KakaoTalk",            NDPI_SERVICE_KAKAOTALK, NDPI_PROTOCOL_FUN },
  { "ttvnw.net",                        "Twitch",               NDPI_SERVICE_TWITCH, NDPI_PROTOCOL_FUN },
  { "static-cdn.jtvnw.net",             "Twitch",               NDPI_SERVICE_TWITCH, NDPI_PROTOCOL_FUN },
  { "www-cdn.jtvnw.net",                "Twitch",               NDPI_SERVICE_TWITCH, NDPI_PROTOCOL_FUN },
  { "quickplay.com",                    "QuickPlay",            NDPI_SERVICE_QUICKPLAY, NDPI_PROTOCOL_FUN },
  { "tim.com.br",                       "TIM",                  NDPI_SERVICE_TIM, NDPI_PROTOCOL_ACCEPTABLE },
  { "tim.it",                           "TIM",                  NDPI_SERVICE_TIM, NDPI_PROTOCOL_ACCEPTABLE },
  { ".qq.com",                          "QQ",                   NDPI_PROTOCOL_QQ, NDPI_PROTOCOL_FUN },
  { ".weibo.com",			"Weibo",        	NDPI_SERVICE_WEIBO, NDPI_PROTOCOL_FUN },
  { ".sinaimg.cn",			"Weibo",       		NDPI_SERVICE_WEIBO, NDPI_PROTOCOL_FUN },
  { ".sinajs.cn",			"Weibo",       		NDPI_SERVICE_WEIBO, NDPI_PROTOCOL_FUN },
  { ".sina.cn",				"Weibo",       		NDPI_SERVICE_WEIBO, NDPI_PROTOCOL_FUN },
  { ".sina.com.cn",			"Weibo",       		NDPI_SERVICE_WEIBO, NDPI_PROTOCOL_FUN },
  

  /* https://support.cipafilter.com/index.php?/Knowledgebase/Article/View/117/0/snapchat---how-to-block */
  { "feelinsonice.appspot.com",         "Snapchat",             NDPI_SERVICE_SNAPCHAT, NDPI_PROTOCOL_FUN },
  { "feelinsonice-hrd.appspot.com",     "Snapchat",             NDPI_SERVICE_SNAPCHAT, NDPI_PROTOCOL_FUN },
  { "feelinsonice.com",                 "Snapchat",             NDPI_SERVICE_SNAPCHAT, NDPI_PROTOCOL_FUN },

  /* Detected "instagram.c10r.facebook.com". Omitted "*amazonaws.com" and "*facebook.com" CDNs e.g. "ig-telegraph-shv-04-frc3.facebook.com" */
  { ".cdninstagram.com",                "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },
  { "instagram.",                       "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },
  { ".instagram.",                      "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },
  { "igcdn-photos-",                    "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },
  { "instagramimages-",                 "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },
  { "instagramstatic-",                 "Instagram",            NDPI_SERVICE_INSTAGRAM, NDPI_PROTOCOL_FUN },

  { ".waze.com",                        "Waze",                 NDPI_SERVICE_WAZE, NDPI_PROTOCOL_ACCEPTABLE },
  { "simet-",                           "Simet",                NDPI_SERVICE_SIMET, NDPI_PROTOCOL_ACCEPTABLE },
  { "opensignal.com",                   "OpenSignal",           NDPI_SERVICE_OPENSIGNAL, NDPI_PROTOCOL_ACCEPTABLE },
  { "99taxis.com",                      "99Taxi",               NDPI_SERVICE_99TAXI, NDPI_PROTOCOL_ACCEPTABLE },
  { "easytaxis.com",                    "EasyTaxi",             NDPI_SERVICE_EASYTAXI, NDPI_PROTOCOL_ACCEPTABLE },
  { ".globo.com",                       "GloboTV",              NDPI_SERVICE_GLOBOTV, NDPI_PROTOCOL_ACCEPTABLE },
  { ".glbimg.com",                      "GloboTV",              NDPI_SERVICE_GLOBOTV, NDPI_PROTOCOL_ACCEPTABLE },
  { "timsomdechamada.com.br",           "SomDeChamada",         NDPI_SERVICE_TIMSOMDECHAMADA, NDPI_PROTOCOL_ACCEPTABLE },
  { ".tim.acotelbr.com.br",             "TIM_Menu",             NDPI_SERVICE_TIMMENU, NDPI_PROTOCOL_ACCEPTABLE },
  { ".timbeta.com.br",                  "TIM_Beta",             NDPI_SERVICE_TIMBETA, NDPI_PROTOCOL_ACCEPTABLE },
  { "tim-geoportal.geoportal3d.com.br", "TIM_PortasAbertas",    NDPI_SERVICE_TIMPORTASABERTAS, NDPI_PROTOCOL_ACCEPTABLE },
  { ".m4u.com.br",                      "TIM_Recarga",          NDPI_SERVICE_TIMRECARGA, NDPI_PROTOCOL_ACCEPTABLE },
  { ".deezer.com",                      "Deezer",               NDPI_SERVICE_DEEZER, NDPI_PROTOCOL_ACCEPTABLE },

  { ".microsoft.com",                   "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },
  { "i-msdn.sec.s-msft.com",            "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },
  { "i2-msdn.sec.s-msft.com",           "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".webtrends.com",                   "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".msecnd.net",                      "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },
  { ".visualstudio.com",                "Microsoft",            NDPI_SERVICE_MICROSOFT, NDPI_PROTOCOL_ACCEPTABLE },  
  { "bn1301.storage.live.com",          "MS_OneDrive",          NDPI_SERVICE_MS_ONE_DRIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "skyapi.live.net",                  "MS_OneDrive",          NDPI_SERVICE_MS_ONE_DRIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "d.docs.live.net",                  "MS_OneDrive",          NDPI_SERVICE_MS_ONE_DRIVE, NDPI_PROTOCOL_ACCEPTABLE },
  { "update.microsoft.com",             "WindowsUpdate",        NDPI_SERVICE_WINDOWS_UPDATE, NDPI_PROTOCOL_ACCEPTABLE },
  { ".windowsupdate.com",               "WindowsUpdate",        NDPI_SERVICE_WINDOWS_UPDATE, NDPI_PROTOCOL_ACCEPTABLE },

  { "worldofwarcraft.com",              "WorldOfWarcraft",      NDPI_PROTOCOL_WORLDOFWARCRAFT, NDPI_PROTOCOL_FUN },
  { ".anchorfree.",                     "HotspotShield",        NDPI_SERVICE_HOTSPOT_SHIELD, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
  { "hotspotshield.com",                "HotspotShield",        NDPI_SERVICE_HOTSPOT_SHIELD, NDPI_PROTOCOL_POTENTIALLY_DANGEROUS },
  { ".webex.com",                       "Webex",                NDPI_PROTOCOL_WEBEX, NDPI_PROTOCOL_ACCEPTABLE },
  { ".ocsdomain.com",        		"OCS",          	NDPI_SERVICE_OCS, NDPI_PROTOCOL_FUN },
  { "ocs.fr",               		"OCS",   		NDPI_SERVICE_OCS, NDPI_PROTOCOL_FUN },   
  { ".ocs.fr",              		"OCS",       		NDPI_SERVICE_OCS, NDPI_PROTOCOL_FUN },
  { ".labgency.ws",        		"OCS",       		NDPI_SERVICE_OCS, NDPI_PROTOCOL_FUN },
  
  { "crl.microsoft.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-ocsp.verisign.com",	"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-aia.verisign.com", 	"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { "evsecure-crl.verisign.com", 	"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".omniroot.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".verisign.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".symcb.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".symcd.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".verisign.net",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".geotrust.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".entrust.net",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },
  { ".public-trust.com",       		"Office365",       	NDPI_SERVICE_OFFICE_365, NDPI_PROTOCOL_ACCEPTABLE },

  /* http://www.urlquery.net/report.php?id=1453233646161 */
  { "lifedom.top",       		"Cloudflare",       	NDPI_SERVICE_CLOUDFLARE, NDPI_PROTOCOL_ACCEPTABLE },
  { "coby.ns.cloudflare.com",  		"Cloudflare",       	NDPI_SERVICE_CLOUDFLARE, NDPI_PROTOCOL_ACCEPTABLE },
  { "amanda.ns.cloudflare.com",		"Cloudflare",       	NDPI_SERVICE_CLOUDFLARE, NDPI_PROTOCOL_ACCEPTABLE },

  { "d295hzzivaok4k.cloudfront.net",	"OpenDNS",       	NDPI_SERVICE_OPENDNS, NDPI_PROTOCOL_ACCEPTABLE },
  { ".opendns.com",			"OpenDNS",       	NDPI_SERVICE_OPENDNS, NDPI_PROTOCOL_ACCEPTABLE },

  

  { NULL, 0 }
};


/*
  Mime-type content match match
*/
ndpi_protocol_match content_match[] = {
  { "audio/mpeg",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "audio/x-mpeg",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "audio/mpeg3",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "audio/mp4a",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "video/mpeg",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "video/nsv",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "misc/ultravox",			NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "audio/ogg",			NULL,		        NDPI_CONTENT_OGG, NDPI_PROTOCOL_FUN },
  { "video/ogg",			NULL,		        NDPI_CONTENT_OGG, NDPI_PROTOCOL_FUN },
  { "application/ogg",			NULL,		        NDPI_CONTENT_OGG, NDPI_PROTOCOL_FUN },
  { "video/flv",			NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "video/x-flv",			NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "application/x-fcs",		NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "application/x-shockwave-flash",	NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_ACCEPTABLE },
  { "video/flash",			NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "application/flv",			NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "flv-application/octet-stream",	NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "application/futuresplash",		NULL,		        NDPI_CONTENT_FLASH, NDPI_PROTOCOL_FUN },
  { "video/quicktime",			NULL,		        NDPI_CONTENT_QUICKTIME, NDPI_PROTOCOL_FUN },
  { "video/mp4",			NULL,		        NDPI_CONTENT_QUICKTIME, NDPI_PROTOCOL_FUN },
  { "video/x-m4v",			NULL,		        NDPI_CONTENT_QUICKTIME, NDPI_PROTOCOL_FUN },
  { "audio/x-pn-realaudio",		NULL,		        NDPI_CONTENT_REALMEDIA, NDPI_PROTOCOL_FUN },
  { "application/vnd.rn-realmedia",	NULL,		        NDPI_CONTENT_REALMEDIA, NDPI_PROTOCOL_FUN },
  { "video/x-ms-",			NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "asf",			        NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "asx",			        NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "video/x-msvideo",			NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "audio/x-wav",			NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "application/vnd.ms.wms-hdr.asfv1",	NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "NSPlayer/",			NULL,		        NDPI_CONTENT_WINDOWSMEDIA, NDPI_PROTOCOL_FUN },
  { "application/x-mms-framed",		NULL,		        NDPI_CONTENT_MMS, NDPI_PROTOCOL_FUN },
  { "Xbox Live Client/",		NULL,		        NDPI_PROTOCOL_XBOX, NDPI_PROTOCOL_FUN },
  { "Windows-Update-Agent",		NULL,		        NDPI_SERVICE_WINDOWS_UPDATE, NDPI_PROTOCOL_ACCEPTABLE },
  { "audio/webm",			NULL,		        NDPI_CONTENT_WEBM, NDPI_PROTOCOL_FUN },
  { "video/webm",			NULL,		        NDPI_CONTENT_WEBM, NDPI_PROTOCOL_FUN },
  { "application/x-rtsp-tunnelled",	NULL,		        NDPI_PROTOCOL_RTSP, NDPI_PROTOCOL_FUN },
  { "application/vnd.apple.mpegurl",	NULL,		        NDPI_CONTENT_MPEG, NDPI_PROTOCOL_FUN },
  { "application/x-tar",		NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "application/octet-stream",		NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "application/mac-binary",		NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "/x-bzip",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "/x-gzip",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "/x-zip",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "/zip",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "binhex",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "/base64",				NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "application/gnutar",		NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  { "application/x-compressed",		NULL,		        NDPI_PROTOCOL_HTTP_DOWNLOAD, NDPI_PROTOCOL_ACCEPTABLE },
  
  { NULL, 0 }
};

/* ****************************************************** */

/*
  Tor
  The tor protocol uses SSL to contact peers so it could be exchanged with
  standard SSL. However the host names such as

  - www.fgd2iwya7vinfutj5wq5we.com
  - www.qbtxzhetq4s2f.com
  - www.fgd2iwya7vinfutj5wq5we.net

  In essence www.<name>.com|net

  To do things properly we should check if host name in the certificate
  exists or if the IP address of the SSL peer resolves to a name. Unfortunately
  for performance reasons we can't afford to do a DNS lookup in nDPI (however apps
  can do it if possible) and thus we have created a heuristic algorithm that tries
  to check the host name (in the SSL certificate) to see if it looks like a
  random name or a real name. We cannot use a dictionary (how can the kernel read a file?)
  and this we use bigrams distribution to decide if the string looks like a
  word or just random chars.

  http://www3.nd.edu/~busiforc/handouts/cryptography/Letter%20Frequencies.html
*/

static const char *ndpi_en_bigrams[] = {
  "aa", "ba", "ca", "da", "ea", "fa", "ga", "ha", "ia", "ja", "ka", "la", "ma", "na", "oa", "pa", "qa",
  "ra", "sa", "ta", "ua", "va", "wa", "xa", "ya", "za", "ab", "bb", "db", "eb", "fb", "gb", "hb", "ib",
  "kb", "lb", "mb", "nb", "ob", "pb", "rb", "sb", "tb", "ub", "wb", "yb", "ac", "bc", "cc", "dc", "ec",
  "fc", "gc", "hc", "ic", "kc", "lc", "mc", "nc", "oc", "pc", "rc", "sc", "tc", "uc", "wc", "xc", "yc",
  "ad", "bd", "cd", "dd", "ed", "fd", "gd", "hd", "id", "kd", "ld", "md", "nd", "od", "pd", "rd", "sd",
  "td", "ud", "wd", "xd", "yd", "zd", "ae", "be", "ce", "de", "ee", "fe", "ge", "he", "ie", "je", "ke",
  "le", "me", "ne", "oe", "pe", "re", "se", "te", "ue", "ve", "we", "xe", "ye", "ze", "af", "bf", "df",
  "ef", "ff", "gf", "hf", "if", "kf", "lf", "mf", "nf", "of", "pf", "rf", "sf", "tf", "uf", "wf", "xf",
  "yf", "zf", "ag", "bg", "dg", "eg", "fg", "gg", "hg", "ig", "kg", "lg", "ng", "og", "pg", "rg", "sg",
  "tg", "ug", "wg", "yg", "ah", "bh", "ch", "dh", "eh", "fh", "gh", "hh", "ih", "kh", "lh", "mh", "nh",
  "oh", "ph", "rh", "sh", "th", "uh", "wh", "xh", "yh", "ai", "bi", "ci", "di", "ei", "fi", "gi", "hi",
  "ii", "ji", "ki", "li", "mi", "ni", "oi", "pi", "qi", "ri", "si", "ti", "ui", "vi", "wi", "xi", "yi",
  "zi", "aj", "bj", "dj", "ej", "fj", "gj", "hj", "ij", "jj", "kj", "lj", "nj", "oj", "pj", "rj", "sj",
  "tj", "uj", "wj", "yj", "ak", "ck", "dk", "ek", "gk", "ik", "kk", "lk", "mk", "nk", "ok", "pk", "rk",
  "sk", "tk", "uk", "wk", "yk", "zk", "al", "bl", "cl", "dl", "el", "fl", "gl", "hl", "il", "kl", "ll",
  "ml", "nl", "ol", "pl", "rl", "sl", "tl", "ul", "vl", "wl", "xl", "yl", "zl", "am", "bm", "cm", "dm",
  "em", "fm", "gm", "hm", "im", "km", "lm", "mm", "nm", "om", "pm", "rm", "sm", "tm", "um", "wm", "xm",
  "ym", "zm", "an", "bn", "cn", "dn", "en", "fn", "gn", "hn", "in", "kn", "ln", "mn", "nn", "on", "pn",
  "rn", "sn", "tn", "un", "wn", "xn", "yn", "ao", "bo", "co", "do", "eo", "fo", "go", "ho", "io", "jo",
  "ko", "lo", "mo", "no", "oo", "po", "ro", "so", "to", "uo", "vo", "wo", "xo", "yo", "zo", "ap", "bp",
  "dp", "ep", "fp", "gp", "hp", "ip", "kp", "lp", "mp", "np", "op", "pp", "rp", "sp", "tp", "up", "wp",
  "xp", "yp", "zp", "aq", "cq", "dq", "eq", "hq", "iq", "nq", "oq", "qq", "rq", "sq", "uq", "xq", "ar",
  "br", "cr", "dr", "er", "fr", "gr", "hr", "ir", "kr", "lr", "mr", "nr", "or", "pr", "rr", "sr", "tr",
  "ur", "vr", "wr", "xr", "yr", "as", "bs", "cs", "ds", "es", "fs", "gs", "hs", "is", "ks", "ls", "ms",
  "ns", "os", "ps", "rs", "ss", "ts", "us", "vs", "ws", "xs", "ys", "at", "bt", "ct", "dt", "et", "ft",
  "gt", "ht", "it", "kt", "lt", "mt", "nt", "ot", "pt", "rt", "st", "tt", "ut", "wt", "xt", "yt", "zt",
  "au", "bu", "cu", "du", "eu", "fu", "gu", "hu", "iu", "ju", "ku", "lu", "mu", "nu", "ou", "pu", "qu",
  "ru", "su", "tu", "uu", "vu", "wu", "xu", "yu", "zu", "av", "bv", "dv", "ev", "iv", "lv", "mv", "nv",
  "ov", "rv", "sv", "tv", "uv", "vv", "zv", "aw", "bw", "dw", "ew", "fw", "gw", "hw", "iw", "kw", "lw",
  "mw", "nw", "ow", "pw", "rw", "sw", "tw", "uw", "ww", "xw", "yw", "zw", "ax", "ex", "ix", "nx", "ox",
  "rx", "ux", "xx", "yx", "ay", "by", "cy", "dy", "ey", "fy", "gy", "hy", "ky", "ly", "my", "ny", "oy",
  "py", "ry", "sy", "ty", "uy", "vy", "wy", "xy", "yy", "zy", "az", "bz", "cz", "dz", "ez", "gz", "iz",
  "lz", "nz", "oz", "pz", "rz", "tz", "uz", "zz", NULL };

static const char *ndpi_en_impossible_bigrams[] = {
  "bk", "bq", "bx", "cb", "cf", "cg", "cj", "cp", "cv", "cw", "cx", "dx", "fk", "fq", "fv", "fx", "ee",
  "fz", "gq", "gv", "gx", "hh", "hk", "hv", "hx", "hz", "iy", "jb", "jc", "jd", "jf", "jg", "jh", "jk",
  "jl", "jm", "jn", "jp", "jq", "jr", /* "js", */ "jt", "jv", "jw", "jx", "jy", "jz", "kg", "kq", "kv", "kx",
  "kz", "lq", "lx", "mg", "mj", "mq", "mx", "mz", "pq", "pv", "px", "qb", "qc", "qd", "qe", "qf", "ii",
  "qg", "qh", "qj", "qk", "ql", "qm", "qn", "qo", "qp", "qr", "qs", "qt", "qv", "qw", "qx", "qy", "uu",
  "qz", "sx", "sz", "tq", "tx", "vb", "vc", "vd", "vf", "vg", "vh", "vj", "vk", "vm", "vn", "vp", "bw",
  "vq", "vt", "vw", "vx", "vz", "wq", "wv", "wx", "wz", "xb", "xg", "xj", "xk", "xv", "xz", "xw", "yd", "yp",
  "yj", "yq", "yv", "yz", "yw", "zb", "zc", "zg", "zh", "zj", "zn", "zq", "zr", "zs", "zx", "wh", "wk",
  "wb", "zk", "kp", "zk", "xy",
  NULL };

