/*
 * Copyright (C) 2006-2015, Marvell International Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

/* Description:  This file defines system adaptation related information.
 */

#ifndef _mwl_sysadpt_h_
#define _mwl_sysadpt_h_

#define SYSADPT_MAX_NUM_CHANNELS       64

#define SYSADPT_MAX_DATA_RATES_G       14

#define SYSADPT_TX_POWER_LEVEL_TOTAL   16

#define SYSADPT_TX_WMM_QUEUES          4

#define SYSADPT_TX_AMPDU_QUEUES        4

#define SYSADPT_NUM_OF_AP              16

#define SYSADPT_TOTAL_TX_QUEUES        (SYSADPT_TX_WMM_QUEUES + \
					SYSADPT_NUM_OF_AP)

#define SYSADPT_TOTAL_HW_QUEUES        (SYSADPT_TX_WMM_QUEUES + \
					SYSADPT_TX_AMPDU_QUEUES)

#define SYSADPT_NUM_OF_DESC_DATA       (4 + SYSADPT_NUM_OF_AP)

#define SYSADPT_MAX_NUM_TX_DESC        256

#define SYSADPT_TX_QUEUE_LIMIT         1024

#define SYSADPT_DELAY_FREE_Q_LIMIT     SYSADPT_MAX_NUM_TX_DESC

#define SYSADPT_MAX_NUM_RX_DESC        256

#define SYSADPT_RECEIVE_LIMIT          64

#define SYSADPT_MAX_AGGR_SIZE          8192

#define SYSADPT_MIN_BYTES_HEADROOM     64

#define SYSADPT_AMPDU_PACKET_THRESHOLD 64

#define SYSADPT_AMSDU_MAX_SIZE         3300

#define SYSADPT_AMSDU_ALLOW_SIZE       1540

#define SYSADPT_AMSDU_FLUSH_TIME       500

#define SYSADPT_AMSDU_PACKET_THRESHOLD 10

#define SYSADPT_MAX_TID                8

#endif /* _mwl_sysadpt_h_ */
