%define contentdir %{_datadir}/netdata
%if 0%{?suse_version}
%define distro_post %service_add_post netdata.service
%define distro_preun %service_del_preun netdata.service
%define distro_postun %service_del_postun netdata.service
%define distro_buildrequires BuildRequires:\ systemd-rpm-macros
%else
%define distro_post %systemd_post netdata.service
%define distro_preun %systemd_preun netdata.service
%define distro_postun %systemd_postun_with_restart netdata.service
%define distro_buildrequires %{nil}
%endif

# This is temporary and should eventually be resolved. This bypasses
# the default rhel __os_install_post which throws a python compile
# error.
%define __os_install_post %{nil}

#
# Conditional build:
%bcond_without  systemd  # systemd
%bcond_with     nfacct   # build with nfacct plugin

%if 0%{?fedora} || 0%{?rhel} >= 7 || 0%{?suse_version} >= 1140
%else
%undefine	with_systemd
%endif

Summary:	Real-time performance monitoring, done right
Name:		netdata
Version:	1.5.0
Release:	1%{?dist}
License:	GPL v3+
Group:		Applications/System
Source0:	http://firehol.org/download/netdata/releases/v1.5.0/%{name}-1.5.0.tar.xz
URL:		http://my-netdata.io/
%distro_buildrequires
BuildRequires:	/usr/bin/autoconf
BuildRequires:	/usr/bin/automake
BuildRequires:	pkgconfig
BuildRequires:	xz
BuildRequires:	zlib-devel
BuildRequires:	libuuid-devel
Requires:	zlib
Requires:	libuuid
Requires(post): libcap
Recommends:	curl
Recommends:	iproute-tc
Recommends:	lm_sensors
Recommends:	nmap-ncat
Recommends:	nodejs
Recommends:	python
Recommends:	PyYAML
Recommends:	python2-PyMySQL
Recommends:	python2-psycopg2

# Packages can be found in the EPEL repo
%if %{with nfacct}
BuildRequires:	libmnl-devel
BuildRequires:	libnetfilter_acct-devel
Requires: libmnl
Requires: libnetfilter_acct
%endif

Requires(pre): /usr/sbin/groupadd
Requires(pre): /usr/sbin/useradd

%if %{with systemd}
%if 0%{?suse_version}
%{?systemd_requires}
%else
Requires(preun):  systemd-units
Requires(postun): systemd-units
Requires(post):   systemd-units
%endif
%else
Requires(post):   chkconfig
%endif

%description
netdata is the fastest way to visualize metrics. It is a resource
efficient, highly optimized system for collecting and visualizing any
type of realtime timeseries data, from CPU usage, disk activity, SQL
queries, API calls, web site visitors, etc.

netdata tries to visualize the truth of now, in its greatest detail,
so that you can get insights of what is happening now and what just
happened, on your systems and applications.

%prep
%setup -q

%build
./autogen.sh
%configure \
	--with-zlib \
	--with-math \
	%{?with_nfacct:--enable-plugin-nfacct} \
	--with-user=netdata
%{__make} %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%{__make} %{?_smp_mflags} DESTDIR=$RPM_BUILD_ROOT install

find $RPM_BUILD_ROOT -name .keep -delete

install -m 644 -p system/netdata.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
install -d $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -m 644 -p system/netdata.logrotate $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}

%if %{with systemd}
install -d $RPM_BUILD_ROOT%{_unitdir}
install -m 644 -p system/netdata.service $RPM_BUILD_ROOT%{_unitdir}/netdata.service
%else
# install SYSV init stuff
install -d $RPM_BUILD_ROOT/etc/rc.d/init.d
install -m755 system/netdata-init-d \
        $RPM_BUILD_ROOT/etc/rc.d/init.d/netdata
%endif

%if %{with systemd}
%pre
# Add the "netdata" user
/usr/sbin/groupadd -r netdata 2> /dev/null || :
/usr/sbin/useradd -c "netdata" -g netdata \
        -s /sbin/nologin -r -d %{contentdir} netdata 2> /dev/null || :

%post
%distro_post
setcap cap_dac_read,cap_sys_ptrace+ep /usr/libexec/netdata/plugins.d/apps.plugin || chmod 1755 /usr/libexec/netdata/plugins.d/apps.plugin

%preun
%distro_preun

%postun
%distro_postun
%else
%pre
# Add the "netdata" user
getent group netdata >/dev/null || groupadd -r netdata
getent group docker >/dev/null || groupadd -r docker
getent passwd netdata >/dev/null || \
  useradd -r -g netdata -G docker -s /sbin/nologin \
    -d %{contentdir} -c "netdata" netdata
exit 0

%post
setcap cap_dac_read,cap_sys_ptrace+ep /usr/libexec/netdata/plugins.d/apps.plugin || chmod 1755 /usr/libexec/netdata/plugins.d/apps.plugin
# Register the netdata service
/sbin/chkconfig --add netdata
# Only gets run on initial install (not upgrades or uninstalls)
if [ $1 = 1 ]; then
        # Start the netdata service
        /sbin/service netdata start
fi
exit 0

%preun
# Only gets run on uninstall (not upgrades)
if [ $1 = 0 ]; then
        /sbin/service netdata stop > /dev/null 2>&1
        /sbin/chkconfig --del netdata
fi
exit 0

%postun
# Only gets run on upgrade (not uninstalls)
if [ $1 != 0 ]; then
        /sbin/service netdata condrestart 2>&1 > /dev/null
fi
exit 0
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc README.md
%defattr(-,root,root)

%dir %{_sysconfdir}/%{name}

%config(noreplace) %{_sysconfdir}/%{name}/*.conf
%config(noreplace) %{_sysconfdir}/%{name}/charts.d/*.conf
%config(noreplace) %{_sysconfdir}/%{name}/health.d/*.conf
#%%config(noreplace) %{_sysconfdir}/%{name}/node.d/*.conf
%config(noreplace) %{_sysconfdir}/%{name}/python.d/*.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}

# To be eventually moved to %%_defaultdocdir
%{_sysconfdir}/%{name}/node.d/*.md

%caps(cap_dac_read_search,cap_sys_ptrace=ep) %{_libexecdir}/%{name}/plugins.d/apps.plugin

%{_libexecdir}/%{name}
%{_sbindir}/%{name}

%attr(0700,netdata,netdata) %dir %{_localstatedir}/cache/%{name}
%attr(0700,netdata,netdata) %dir %{_localstatedir}/log/%{name}
%attr(0700,netdata,netdata) %dir %{_localstatedir}/lib/%{name}

%dir %{_datadir}/%{name}
%dir %{_sysconfdir}/%{name}/health.d
%dir %{_sysconfdir}/%{name}/python.d

%if %{with systemd}
%{_unitdir}/netdata.service
%else
%{_sysconfdir}/rc.d/init.d/netdata
%endif

# Enforce 0644 for files and 0755 for directories
# for the netdata web directory
%defattr(0644,root,netdata,0755)
%{_datadir}/%{name}/web

%changelog
* Sun Jan 22 2017 Costa Tsaousis <costa@tsaousis.gr> - 1.5.0-1
- FreeBSD, MacOS, FreeNAS
- Backends support
- dozens of new and improved plugins
- dozens of new and improved alarms and notification methods
* Tue Oct 4 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.4.0-1
- the fastest netdata ever (with a better look too)!
- improved IoT and containers support!
- alarms improved in almost every way!
- Several more improvements, new features and bugfixes.
* Sun Aug 28 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.3.0-1
- netdata now has health monitoring
- netdata now generates badges
- netdata now has python plugins
- Several more improvements, new features and bugfixes.
* Tue Jul 26 2016 Jason Barnett <J@sonBarnett.com> - 1.2.0-2
- Added support for EL6
- Corrected several Requires statements
- Changed default to build without nfacct
- Removed --docdir from configure
* Mon May 16 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.2.0-1
- netdata is now 30% faster.
- netdata now has a registry (my-netdata menu on the dashboard).
- netdata now monitors Linux containers.
- Several more improvements, new features and bugfixes.
* Wed Apr 20 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.1.0-1
- Several new features (IPv6, SYNPROXY, Users, Users Groups).
- A lot of bug fixes and optimizations.
* Tue Mar 22 2016 Costa Tsaousis <costa@tsaousis.gr> - 1.0.0-1
- First public release.
* Sun Nov 15 2015 Alon Bar-Lev <alonbl@redhat.com> - 0.0.0-1
- Initial add.
