// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

/*
 * Tests for sampler deadlock regression. 
 * Issue https://github.com/joyent/node/issues/14576
 */

var assert = require('assert');
var cp = require('child_process');

var child = undefined;

if (process.platform !== 'win32') {
  process.on('SIGTERM', function() {
    if(child) {
      process.kill(child.pid, 'SIGKILL');
    }

    process.exit();
  });
}

var testScript = "var i = 0; function r() { if(++i > 25) return; " +
                 "setTimeout(r, 1); }; r();"
var nodeCmd = process.execPath + 
              ' --prof --nologfile_per_isolate' + 
              ' -e "' + testScript + '"';
var runs = 0;

function runTestScript() {
  child = cp.exec(nodeCmd, function(err, stdout, stderr) {
    if (++runs > 50) return;

    runTestScript();
  });
}

runTestScript();
