/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoLinkQualityMultiplier
implements Comparable<JsonInfoLinkQualityMultiplier> {
    private String route = "";
    private double multiplier = 0.0;

    public String getRoute() {
        return this.route;
    }

    @JsonProperty(value="route")
    public void setRoute(InetAddress route) {
        this.route = route == null ? "" : route.getHostAddress();
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    @JsonProperty(value="multiplier")
    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.route.hashCode();
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoLinkQualityMultiplier)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoLinkQualityMultiplier other) {
        if (other == null) {
            return -1;
        }
        int result = this.route.compareTo(other.route);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Double.compare(this.multiplier, other.multiplier);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoLinkQualityMultiplier [route=");
        builder.append(this.route);
        builder.append(", multiplier=");
        builder.append(this.multiplier);
        builder.append("]");
        return builder.toString();
    }
}

