/* header auto-generated by pidl */

#ifndef _PIDL_HEADER_wbint
#define _PIDL_HEADER_wbint

#include <stdint.h>

#include "libcli/util/ntstatus.h"

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/netlogon.h"
#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/idmap.h"
#ifndef _HEADER_wbint
#define _HEADER_wbint

struct wbint_TransID {
	enum id_type type;
	uint32_t domain_index;
	uint32_t rid;
	uint64_t unix_id;
};

struct wbint_TransIDArray {
	uint32_t num_ids;
	struct wbint_TransID *ids;/* [size_is(num_ids)] */
};

struct wbint_userinfo {
	const char *acct_name;/* [unique,charset(UTF8)] */
	const char *full_name;/* [charset(UTF8),unique] */
	const char *homedir;/* [unique,charset(UTF8)] */
	const char *shell;/* [charset(UTF8),unique] */
	uint64_t primary_gid;
	struct dom_sid user_sid;
	struct dom_sid group_sid;
}/* [public] */;

struct wbint_SidArray {
	uint32_t num_sids;
	struct dom_sid *sids;/* [size_is(num_sids)] */
}/* [public] */;

struct wbint_RidArray {
	uint32_t num_rids;
	uint32_t *rids;/* [size_is(num_rids)] */
}/* [public] */;

struct wbint_Principal {
	struct dom_sid sid;
	enum lsa_SidType type;
	const char *name;/* [unique,charset(UTF8)] */
}/* [public] */;

struct wbint_Principals {
	int32_t num_principals;
	struct wbint_Principal *principals;/* [size_is(num_principals)] */
}/* [public] */;

struct wbint_userinfos {
	uint32_t num_userinfos;
	struct wbint_userinfo *userinfos;/* [size_is(num_userinfos)] */
}/* [public] */;


struct wbint_Ping {
	struct {
		uint32_t in_data;
	} in;

	struct {
		uint32_t *out_data;/* [ref] */
	} out;

};


struct wbint_LookupSid {
	struct {
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		enum lsa_SidType *type;/* [ref] */
		const char **domain;/* [charset(UTF8),ref] */
		const char **name;/* [charset(UTF8),ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupSids {
	struct {
		struct lsa_SidArray *sids;/* [ref] */
	} in;

	struct {
		struct lsa_RefDomainList *domains;/* [ref] */
		struct lsa_TransNameArray *names;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupName {
	struct {
		const char *domain;/* [charset(UTF8),ref] */
		const char *name;/* [ref,charset(UTF8)] */
		uint32_t flags;
	} in;

	struct {
		enum lsa_SidType *type;/* [ref] */
		struct dom_sid *sid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Sid2Uid {
	struct {
		const char *dom_name;/* [charset(UTF8),unique] */
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		uint64_t *uid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Sid2Gid {
	struct {
		const char *dom_name;/* [charset(UTF8),unique] */
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		uint64_t *gid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Sids2UnixIDs {
	struct {
		struct lsa_RefDomainList *domains;/* [ref] */
		struct wbint_TransIDArray *ids;/* [ref] */
	} in;

	struct {
		struct wbint_TransIDArray *ids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Uid2Sid {
	struct {
		const char *dom_name;/* [unique,charset(UTF8)] */
		uint64_t uid;
	} in;

	struct {
		struct dom_sid *sid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_Gid2Sid {
	struct {
		const char *dom_name;/* [unique,charset(UTF8)] */
		uint64_t gid;
	} in;

	struct {
		struct dom_sid *sid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_AllocateUid {
	struct {
		uint64_t *uid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_AllocateGid {
	struct {
		uint64_t *gid;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QueryUser {
	struct {
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		struct wbint_userinfo *info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupUserAliases {
	struct {
		struct wbint_SidArray *sids;/* [ref] */
	} in;

	struct {
		struct wbint_RidArray *rids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupUserGroups {
	struct {
		struct dom_sid *sid;/* [ref] */
	} in;

	struct {
		struct wbint_SidArray *sids;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QuerySequenceNumber {
	struct {
		uint32_t *sequence;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupGroupMembers {
	struct {
		struct dom_sid *sid;/* [ref] */
		enum lsa_SidType type;
	} in;

	struct {
		struct wbint_Principals *members;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QueryUserList {
	struct {
		struct wbint_userinfos *users;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_QueryGroupList {
	struct {
		struct wbint_Principals *groups;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_DsGetDcName {
	struct {
		const char *domain_name;/* [ref,charset(UTF8)] */
		struct GUID *domain_guid;/* [unique] */
		const char *site_name;/* [unique,charset(UTF8)] */
		uint32_t flags;
	} in;

	struct {
		struct netr_DsRGetDCNameInfo **dc_info;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_LookupRids {
	struct {
		struct dom_sid *domain_sid;/* [ref] */
		struct wbint_RidArray *rids;/* [ref] */
	} in;

	struct {
		const char **domain_name;/* [ref,charset(UTF8)] */
		struct wbint_Principals *names;/* [ref] */
		NTSTATUS result;
	} out;

};


struct wbint_CheckMachineAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct wbint_ChangeMachineAccount {
	struct {
		NTSTATUS result;
	} out;

};


struct wbint_PingDc {
	struct {
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_wbint */
#endif /* _PIDL_HEADER_wbint */
