#ifndef _STATE_C
#define _STATE_C
#include "config.h"

/******************************************************************************
 *
 * state_list()
 *
 * list state entries
 *
 *****************************************************************************/

void state_list(void) {
	extern state_t *states;
	state_t *state;

	state = states;
	printf("=== STATE LIST ===\n");
	while(state) {
		printf("%d belongs to task %d\n", state->callid, (state->task) ? state->task->tid : 0);
		state = state->next;
	}
	printf("=== END OF STATE LIST ===\n");
}

int state_add(task_t *task, unsigned int callid, unsigned int test) {
	extern state_t *states;

	state_t *state, *newstate;

	newstate = malloc(sizeof(state_t));
	if (!newstate) {
		error(ERR_FATAL, "malloc() failed");
	}

	newstate->prev = NULL;
	newstate->next = NULL;
	newstate->task = task;
	newstate->callid = callid;
	newstate->test = test;

    if (states == NULL) {
        states = newstate;
    } else {
        state = states;
        while (state->next) {
            state = state->next;
        }
        state->next = newstate;
        newstate->prev = state;
		error(ERR_DEBUG, "new state added (tid %d): %d\n", task->tid, callid);
    }

	return 1;
}

/******************************************************************************
 *
 * state_remove_by_tid()
 *
 * remove all states belonging to a task id
 *
 *****************************************************************************/

void state_remove_by_tid(unsigned int tid) {

	extern state_t *states;
	state_t *state, *snext;

	state = states;
	while (state) {
		snext = state->next; /* save as it might be removed while running */
		if (state->task->tid == tid) {
			/* remove this state */
			state_remove(state);
		}
		state = snext;
	}

	return;
}

/******************************************************************************
 *
 * state_remove()
 *
 * remove a single state from the state list
 *
 *****************************************************************************/

void state_remove(state_t *destroy) {
	extern state_t *states;
	state_t *state, *prev, *next;

	state = states;
	while (state) {
		if (state == destroy)
			goto statefound;
		state = state->next;

	}
	return;
statefound:
    prev = state->prev;
    next = state->next;
    if (prev) prev->next = next;
    if (next) next->prev = prev;

    if (state == states) {
            /* head of list to be removed, so change to next */
            states = next;
    }
	free(destroy); /* free state that is not part of the list anymore */
	return;
}

state_t *state_lookup_by_callid(unsigned int callid) {
	extern state_t *states;

	state_t *state;
	assert(callid);

	state = states;
	while (state) {
		if (state->callid == callid)
			return state;
		else
			state = state->next;
	}
	return NULL;
}

task_t *state_lookup_task_by_callid(unsigned int callid) {

	extern state_t *states;

	state_t *state;

	state = states;
	while (state) {
		if (state->callid == callid)
			return (task_t *) state->task;
		else
			state = state->next;
	}
	return NULL;
}
#endif /* _STATE_C */
