/******************************************************************************
 *
 * stun.h - part of smap
 *
 * $Id: stun.h,v 1.2 2006-10-10 13:03:19 hscholz Exp $
 *
 *****************************************************************************/

#ifndef _STUN_H
#define _STUN_H

/* size of an empty STUN request */
#define STUN_REQ_LEN    20

/* STUN Message Types */
#define MT_BINDREQ  0x0001
#define MT_BINDRES  0x0101
#define MT_BINDERR  0x0111
#define MT_SHSEREQ  0x0002
#define MT_SHSERES  0x0102
#define MT_SHSEERR  0x0112

/* transaction ID is 128Bit */
#ifndef uint128_t
typedef struct { unsigned char octet[16]; } uint128_t;
#endif

typedef struct {
    uint16_t        msgType;
    uint16_t        msgLen;
    unsigned char   msgId[16];
} StunMessage;

/* STUN Attribute Types */
#define AT_MAPPED_ADDRESS       0x0001
#define AT_RESPONSE_ADDRESS     0x0002
#define AT_CHANGE_REQUEST       0x0003
#define AT_SOURCE_ADDRESS       0x0004
#define AT_CHANGED_ADDRESS      0x0005
#define AT_USERNAME             0x0006
#define AT_PASSWORD             0x0007
#define AT_MESSAGE_INTEGRITY    0x0008
#define AT_ERROR_CODE           0x0009
#define AT_UNKNOWN_ATTRIBUTES   0x000a
#define AT_REFLECTED_FROM       0x000b

typedef struct {
    uint16_t        attrType;
    uint16_t        attrLen;
    void            *attrval;
} StunAttribute;

/* (MAPPED|SOURCE)-ADDRESS attribute */
typedef struct {
    uint8_t     ignore;
    uint8_t     family;
    uint16_t    port;
    uint32_t    addr;
} StunAttrAddress;

/* CHANGED-ADDRESS attribute */
typedef struct {
    uint32_t    flags;
} StunAttrChangedAddress;
#define FLAG_CHANGE_IP      0x0100
#define FLAG_CHANGE_PORT    0x0010

#endif /* _STUN_H */
