/******************************************************************************
 *
 * transport_tls.c - TLS scanner part of smap
 *
 * $Id: transport_tls.c,v 1.1 2006-10-10 13:03:19 hscholz Exp $
 *****************************************************************************/
#ifndef _TRANSPORT_TLS_C
#define _TRANSPORT_TLS_C

#include "config.h"

/******************************************************************************
 *
 * tcp_syn()
 *
 * try a fast connect to a remote TCP port and return the port status:
 *
 *  1: port open (SYN, SYNACK, ACK)
 *  0: port closed (i.e. RST or ICMP error)
 * -1: timeout, assume closed
 *
 *****************************************************************************/

int tcp_syn (struct in_addr dst) {

    int sock, sockaddrlen, sockflags;
    fd_set fdset;
    struct timeval timeout;
    struct sockaddr_in sockaddr;


	sock = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (sock == -1) {
		if (DEBUG) perror("socket");
	return 0;
	}

	sockaddr.sin_family = PF_INET;
	sockaddr.sin_addr = dst;
	sockaddr.sin_port = htons(80);
	sockaddrlen = sizeof(sockaddr);

	/* set socket to non-blocking */
	sockflags = fcntl(sock, F_GETFL, 0);
	sockflags |= O_NONBLOCK;
	if (fcntl(sock, F_SETFL, sockflags) != 0) {
		if (DEBUG) perror("fcntl");
	}

	if (connect(sock, (const struct sockaddr *) &sockaddr, sockaddrlen) != 0) {
		/* it's quite usual to get EINPROGRESS so ignore it here */
		extern int errno;
		if (errno != EINPROGRESS) {
		if (DEBUG) perror("connect");
			close(sock);
			return 0;
		}
	}

	set_timeout(&timeout, config.timeout);
	FD_ZERO(&fdset);
	FD_SET(sock, &fdset);

	if (select(sock + 1, NULL, &fdset, NULL, &timeout) <= 0) {
		/* select returned <= 0 and thus an error */
		close(sock);
		return -1; /* timeout */
	} else {
		/* connect may be ok */
		int err, err_len;
		err_len = sizeof(err);

		if (getsockopt(sock, SOL_SOCKET, SO_ERROR, &err,
		(socklen_t*) &err_len) == 0) {
			if (err > 0) {
				/* received some error from inside getsockopt()
				* -> bail out */
				close(sock);
				return 0; /* received error */
			}
		}
	} /* end of select() */

	close(sock);
	return 1;   /* port open */
}

/******************************************************************************
 *
 * tls_test()
 *
 * FIXME
 *
 *****************************************************************************/
int tls_test(unsigned int requesttype, struct in_addr dst, char *res) {
	return 0;
}

#endif /* _TRANSPORT_TLS_C */
