#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xFD, 0x64, 0x87, 0xF6, 0xC7, 0xF8, 0x45, 0x8D, 0x04, 0x72, 
	0xAB, 0x25, 0xC7, 0xDB, 0x2D, 0x3F, 0x6E, 0xF1, 0xD3, 0xD7, 
	0xC8, 0x81, 0x9A, 0x68, 0xE4, 0xDA, 0x63, 0x72, 0x6B, 0xE7, 
	0x12, 0x31, 0x5A, 0x6B, 0x3C, 0x76, 0xCE, 0x6D, 0x9D, 0x1A, 
	0x2B, 0x4A, 0xA7, 0x61, 0xC1, 0x5C, 0xF4, 0x40, 0xBE, 0xFF, 
	0x15, 0x40, 0xC9, 0x5F, 0xFF, 0x77, 0x50, 0x11, 0x20, 0x5F, 
	0x3D, 0x0F, 0xB9, 0x4B, 0x0F, 0x36, 0x05, 0x39, 0x3C, 0x19, 
	0x35, 0x64, 0x1D, 0xD6, 0x46, 0x61, 0x7C, 0xD4, 0x8C, 0x62, 
	0xEB, 0x45, 0xC2, 0x78, 0xDD, 0x7E, 0x9B, 0x3F, 0xE7, 0xD7, 
	0x28, 0x4E, 0x18, 0x8F, 0xA6, 0x2B, 0x73, 0xC4, 0x84, 0xB4, 
	0xA0, 0x57, 0x3E, 0x05, 0x1D, 0x5E, 0x05, 0xF3, 0xEE, 0x29, 
	0x61, 0x43, 0xE7, 0x93, 0xC8, 0xF5, 0xC0, 0x1E, 0x26, 0x32, 
	0xE1, 0xA4, 0x3D, 0x9B, 0x2C, 0x22, 0xCE, 0xEC, 0x78, 0xD8, 
	0x01, 0xD6, 0xFA, 0x5A, 0x94, 0xF0, 0x27, 0x39, 0x76, 0xAF, 
	0x4F, 0xEA, 0x7C, 0xAA, 0xAF, 0x04, 0xF0, 0xCC, 0x69, 0x8F, 
	0x0E, 0x6D, 0x3A, 0x79, 0x0A, 0x2C, 0xE0, 0x7D, 0x73, 0x1B, 
	0xF1, 0x24, 0xF2, 0x66, 0x26, 0x48, 0x5C, 0x1B, 0x6C, 0xDB, 
	0x0F, 0x11, 0x2F, 0x66, 0x8A, 0xF5, 0x30, 0x8D, 0x69, 0xE2, 
	0x4E, 0x47, 0x07, 0x8F, 0xB8, 0x36, 0xA1, 0x5F, 0x88, 0xCC, 
	0xAA, 0xBA, 0xA7, 0x41, 0x87, 0xB4, 0x96, 0xAA, 0xA7, 0xA6, 
	0x89, 0x20, 0x51, 0xE3, 0x3A, 0xEA, 0xE1, 0x20, 0x4C, 0x11, 
	0x63, 0x00, 0xC2, 0x08, 0x4E, 0x07, 0x44, 0xFE, 0xE3, 0xB0, 
	0x65, 0xA1, 0xE0, 0x79, 0x43, 0x37, 0xFD, 0xB0, 0x96, 0x34, 
	0x2C, 0xEE, 0xC9, 0xD6, 0xD2, 0x2E, 0x0F, 0x57, 0xAA, 0x24, 
	0x62, 0x22, 0xA9, 0x47, 0xBB, 0xDC, 0x2C, 0x6C, 0xF7, 0x86, 
	0x43, 0xE4, 0x32, 0x99, 0xED, 0x03
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
