/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;

public class TestResult {
    protected List<TestFailure> fFailures = new ArrayList<TestFailure>();
    protected List<TestFailure> fErrors = new ArrayList<TestFailure>();
    protected List<TestListener> fListeners = new ArrayList<TestListener>();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public synchronized void addError(Test test, Throwable throwable) {
        this.fErrors.add(new TestFailure(test, throwable));
        for (TestListener testListener : this.cloneListeners()) {
            testListener.addError(test, throwable);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fFailures.add(new TestFailure(test, (Throwable)((Object)assertionFailedError)));
        for (TestListener testListener : this.cloneListeners()) {
            testListener.addFailure(test, assertionFailedError);
        }
    }

    public synchronized void addListener(TestListener testListener) {
        this.fListeners.add(testListener);
    }

    public synchronized void removeListener(TestListener testListener) {
        this.fListeners.remove(testListener);
    }

    private synchronized List<TestListener> cloneListeners() {
        ArrayList<TestListener> arrayList = new ArrayList<TestListener>();
        arrayList.addAll(this.fListeners);
        return arrayList;
    }

    public void endTest(Test test) {
        for (TestListener testListener : this.cloneListeners()) {
            testListener.endTest(test);
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration<TestFailure> errors() {
        return Collections.enumeration(this.fErrors);
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration<TestFailure> failures() {
        return Collections.enumeration(this.fFailures);
    }

    protected void run(final TestCase testCase) {
        this.startTest(testCase);
        Protectable protectable = new Protectable(){

            @Override
            public void protect() throws Throwable {
                testCase.runBare();
            }
        };
        this.runProtected(testCase, protectable);
        this.endTest(testCase);
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable protectable) {
        try {
            protectable.protect();
        }
        catch (AssertionFailedError assertionFailedError) {
            this.addFailure(test, assertionFailedError);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.addError(test, throwable);
        }
    }

    public synchronized boolean shouldStop() {
        return this.fStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTest(Test test) {
        int n = test.countTestCases();
        TestResult testResult = this;
        synchronized (testResult) {
            this.fRunTests += n;
        }
        for (TestListener testListener : this.cloneListeners()) {
            testListener.startTest(test);
        }
    }

    public synchronized void stop() {
        this.fStop = true;
    }

    public synchronized boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0;
    }
}

