/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.junit.experimental.max.CouldNotReadCoreException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class MaxHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Long> fDurations = new HashMap<String, Long>();
    private final Map<String, Long> fFailureTimestamps = new HashMap<String, Long>();
    private final File fHistoryStore;

    public static MaxHistory forFolder(File file) {
        if (file.exists()) {
            try {
                return MaxHistory.readHistory(file);
            }
            catch (CouldNotReadCoreException couldNotReadCoreException) {
                couldNotReadCoreException.printStackTrace();
                file.delete();
            }
        }
        return new MaxHistory(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static MaxHistory readHistory(File file) throws CouldNotReadCoreException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                MaxHistory maxHistory;
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                try {
                    maxHistory = (MaxHistory)objectInputStream.readObject();
                }
                catch (Throwable throwable) {
                    objectInputStream.close();
                    throw throwable;
                }
                objectInputStream.close();
                return maxHistory;
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            throw new CouldNotReadCoreException(exception);
        }
    }

    private MaxHistory(File file) {
        this.fHistoryStore = file;
    }

    private void save() throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.fHistoryStore));
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    Long getFailureTimestamp(Description description) {
        return this.fFailureTimestamps.get(description.toString());
    }

    void putTestFailureTimestamp(Description description, long l) {
        this.fFailureTimestamps.put(description.toString(), l);
    }

    boolean isNewTest(Description description) {
        return !this.fDurations.containsKey(description.toString());
    }

    Long getTestDuration(Description description) {
        return this.fDurations.get(description.toString());
    }

    void putTestDuration(Description description, long l) {
        this.fDurations.put(description.toString(), l);
    }

    public RunListener listener() {
        return new RememberingListener();
    }

    public Comparator<Description> testComparator() {
        return new TestComparator();
    }

    private class TestComparator
    implements Comparator<Description> {
        private TestComparator() {
        }

        @Override
        public int compare(Description description, Description description2) {
            if (MaxHistory.this.isNewTest(description)) {
                return -1;
            }
            if (MaxHistory.this.isNewTest(description2)) {
                return 1;
            }
            int n = this.getFailure(description2).compareTo(this.getFailure(description));
            return n != 0 ? n : MaxHistory.this.getTestDuration(description).compareTo(MaxHistory.this.getTestDuration(description2));
        }

        private Long getFailure(Description description) {
            Long l = MaxHistory.this.getFailureTimestamp(description);
            if (l == null) {
                return 0L;
            }
            return l;
        }
    }

    private final class RememberingListener
    extends RunListener {
        private long overallStart = System.currentTimeMillis();
        private Map<Description, Long> starts = new HashMap<Description, Long>();

        private RememberingListener() {
        }

        @Override
        public void testStarted(Description description) throws Exception {
            this.starts.put(description, System.nanoTime());
        }

        @Override
        public void testFinished(Description description) throws Exception {
            long l = System.nanoTime();
            long l2 = this.starts.get(description);
            MaxHistory.this.putTestDuration(description, l - l2);
        }

        @Override
        public void testFailure(Failure failure) throws Exception {
            MaxHistory.this.putTestFailureTimestamp(failure.getDescription(), this.overallStart);
        }

        @Override
        public void testRunFinished(Result result) throws Exception {
            MaxHistory.this.save();
        }
    }
}

