/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedExceptionMatcherBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ExpectedException
implements TestRule {
    private final ExpectedExceptionMatcherBuilder matcherBuilder = new ExpectedExceptionMatcherBuilder();
    private String missingExceptionMessage = "Expected test to throw %s";

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    @Deprecated
    public ExpectedException handleAssertionErrors() {
        return this;
    }

    @Deprecated
    public ExpectedException handleAssumptionViolatedExceptions() {
        return this;
    }

    public ExpectedException reportMissingExceptionWithMessage(String string) {
        this.missingExceptionMessage = string;
        return this;
    }

    @Override
    public Statement apply(Statement statement, Description description) {
        return new ExpectedExceptionStatement(statement);
    }

    public void expect(Matcher<?> matcher) {
        this.matcherBuilder.add(matcher);
    }

    public void expect(Class<? extends Throwable> clazz) {
        this.expect(CoreMatchers.instanceOf(clazz));
    }

    public void expectMessage(String string) {
        this.expectMessage((Matcher<String>)CoreMatchers.containsString((String)string));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expect(ThrowableMessageMatcher.hasMessage(matcher));
    }

    public void expectCause(Matcher<? extends Throwable> matcher) {
        this.expect(ThrowableCauseMatcher.hasCause(matcher));
    }

    private void handleException(Throwable throwable) throws Throwable {
        if (!this.isAnyExceptionExpected()) {
            throw throwable;
        }
        Assert.assertThat(throwable, this.matcherBuilder.build());
    }

    private boolean isAnyExceptionExpected() {
        return this.matcherBuilder.expectsThrowable();
    }

    private void failDueToMissingException() throws AssertionError {
        Assert.fail(this.missingExceptionMessage());
    }

    private String missingExceptionMessage() {
        String string = StringDescription.toString(this.matcherBuilder.build());
        return String.format(this.missingExceptionMessage, string);
    }

    private class ExpectedExceptionStatement
    extends Statement {
        private final Statement next;

        public ExpectedExceptionStatement(Statement statement) {
            this.next = statement;
        }

        @Override
        public void evaluate() throws Throwable {
            try {
                this.next.evaluate();
            }
            catch (Throwable throwable) {
                ExpectedException.this.handleException(throwable);
                return;
            }
            if (ExpectedException.this.isAnyExceptionExpected()) {
                ExpectedException.this.failDueToMissingException();
            }
        }
    }
}

