/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Description
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Pattern METHOD_AND_CLASS_NAME_PATTERN = Pattern.compile("([\\s\\S]*)\\((.*)\\)");
    public static final Description EMPTY = new Description(null, "No Tests", new Annotation[0]);
    public static final Description TEST_MECHANISM = new Description(null, "Test mechanism", new Annotation[0]);
    private final Collection<Description> fChildren = new ConcurrentLinkedQueue<Description>();
    private final String fDisplayName;
    private final Serializable fUniqueId;
    private final Annotation[] fAnnotations;
    private volatile Class<?> fTestClass;

    public static Description createSuiteDescription(String string, Annotation ... annotationArray) {
        return new Description(null, string, annotationArray);
    }

    public static Description createSuiteDescription(String string, Serializable serializable, Annotation ... annotationArray) {
        return new Description(null, string, serializable, annotationArray);
    }

    public static Description createTestDescription(String string, String string2, Annotation ... annotationArray) {
        return new Description(null, Description.formatDisplayName(string2, string), annotationArray);
    }

    public static Description createTestDescription(Class<?> clazz, String string, Annotation ... annotationArray) {
        return new Description(clazz, Description.formatDisplayName(string, clazz.getName()), annotationArray);
    }

    public static Description createTestDescription(Class<?> clazz, String string) {
        return new Description(clazz, Description.formatDisplayName(string, clazz.getName()), new Annotation[0]);
    }

    public static Description createTestDescription(String string, String string2, Serializable serializable) {
        return new Description(null, Description.formatDisplayName(string2, string), serializable, new Annotation[0]);
    }

    private static String formatDisplayName(String string, String string2) {
        return String.format("%s(%s)", string, string2);
    }

    public static Description createSuiteDescription(Class<?> clazz) {
        return new Description(clazz, clazz.getName(), clazz.getAnnotations());
    }

    private Description(Class<?> clazz, String string, Annotation ... annotationArray) {
        this(clazz, string, (Serializable)((Object)string), annotationArray);
    }

    private Description(Class<?> clazz, String string, Serializable serializable, Annotation ... annotationArray) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The display name must not be empty.");
        }
        if (serializable == null) {
            throw new IllegalArgumentException("The unique id must not be null.");
        }
        this.fTestClass = clazz;
        this.fDisplayName = string;
        this.fUniqueId = serializable;
        this.fAnnotations = annotationArray;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public void addChild(Description description) {
        this.fChildren.add(description);
    }

    public ArrayList<Description> getChildren() {
        return new ArrayList<Description>(this.fChildren);
    }

    public boolean isSuite() {
        return !this.isTest();
    }

    public boolean isTest() {
        return this.fChildren.isEmpty();
    }

    public int testCount() {
        if (this.isTest()) {
            return 1;
        }
        int n = 0;
        for (Description description : this.fChildren) {
            n += description.testCount();
        }
        return n;
    }

    public int hashCode() {
        return this.fUniqueId.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Description)) {
            return false;
        }
        Description description = (Description)object;
        return this.fUniqueId.equals(description.fUniqueId);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public Description childlessCopy() {
        return new Description(this.fTestClass, this.fDisplayName, this.fAnnotations);
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        for (Annotation annotation : this.fAnnotations) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return (T)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    public Collection<Annotation> getAnnotations() {
        return Arrays.asList(this.fAnnotations);
    }

    public Class<?> getTestClass() {
        if (this.fTestClass != null) {
            return this.fTestClass;
        }
        String string = this.getClassName();
        if (string == null) {
            return null;
        }
        try {
            this.fTestClass = Class.forName(string, false, this.getClass().getClassLoader());
            return this.fTestClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String getClassName() {
        return this.fTestClass != null ? this.fTestClass.getName() : this.methodAndClassNamePatternGroupOrDefault(2, this.toString());
    }

    public String getMethodName() {
        return this.methodAndClassNamePatternGroupOrDefault(1, null);
    }

    private String methodAndClassNamePatternGroupOrDefault(int n, String string) {
        Matcher matcher = METHOD_AND_CLASS_NAME_PATTERN.matcher(this.toString());
        return matcher.matches() ? matcher.group(n) : string;
    }
}

