/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.internal.MethodSorter;
import org.junit.runners.model.Annotatable;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;

public class TestClass
implements Annotatable {
    private static final FieldComparator FIELD_COMPARATOR = new FieldComparator();
    private static final MethodComparator METHOD_COMPARATOR = new MethodComparator();
    private final Class<?> clazz;
    private final Map<Class<? extends Annotation>, List<FrameworkMethod>> methodsForAnnotations;
    private final Map<Class<? extends Annotation>, List<FrameworkField>> fieldsForAnnotations;

    public TestClass(Class<?> clazz) {
        this.clazz = clazz;
        if (clazz != null && clazz.getConstructors().length > 1) {
            throw new IllegalArgumentException("Test class can only have one constructor");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        this.scanAnnotatedMembers(linkedHashMap, linkedHashMap2);
        this.methodsForAnnotations = TestClass.makeDeeplyUnmodifiable(linkedHashMap);
        this.fieldsForAnnotations = TestClass.makeDeeplyUnmodifiable(linkedHashMap2);
    }

    protected void scanAnnotatedMembers(Map<Class<? extends Annotation>, List<FrameworkMethod>> map, Map<Class<? extends Annotation>, List<FrameworkField>> map2) {
        for (Class<?> clazz : TestClass.getSuperClasses(this.clazz)) {
            for (Method method : MethodSorter.getDeclaredMethods(clazz)) {
                TestClass.addToAnnotationLists(new FrameworkMethod(method), map);
            }
            for (AccessibleObject accessibleObject : TestClass.getSortedDeclaredFields(clazz)) {
                TestClass.addToAnnotationLists(new FrameworkField((Field)accessibleObject), map2);
            }
        }
    }

    private static Field[] getSortedDeclaredFields(Class<?> clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        Arrays.sort(fieldArray, FIELD_COMPARATOR);
        return fieldArray;
    }

    protected static <T extends FrameworkMember<T>> void addToAnnotationLists(T object, Map<Class<? extends Annotation>, List<T>> map) {
        for (Annotation annotation : object.getAnnotations()) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            List<T> list = TestClass.getAnnotatedMembers(map, clazz, true);
            if (((FrameworkMember)object).isShadowedBy(list)) {
                return;
            }
            if (TestClass.runsTopToBottom(clazz)) {
                list.add(0, object);
                continue;
            }
            list.add(object);
        }
    }

    private static <T extends FrameworkMember<T>> Map<Class<? extends Annotation>, List<T>> makeDeeplyUnmodifiable(Map<Class<? extends Annotation>, List<T>> map) {
        LinkedHashMap<Class<? extends Annotation>, List<T>> linkedHashMap = new LinkedHashMap<Class<? extends Annotation>, List<T>>();
        for (Map.Entry<Class<Annotation>, List<T>> entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    public List<FrameworkMethod> getAnnotatedMethods() {
        List<FrameworkMethod> list = this.collectValues(this.methodsForAnnotations);
        Collections.sort(list, METHOD_COMPARATOR);
        return list;
    }

    public List<FrameworkMethod> getAnnotatedMethods(Class<? extends Annotation> clazz) {
        return Collections.unmodifiableList(TestClass.getAnnotatedMembers(this.methodsForAnnotations, clazz, false));
    }

    public List<FrameworkField> getAnnotatedFields() {
        return this.collectValues(this.fieldsForAnnotations);
    }

    public List<FrameworkField> getAnnotatedFields(Class<? extends Annotation> clazz) {
        return Collections.unmodifiableList(TestClass.getAnnotatedMembers(this.fieldsForAnnotations, clazz, false));
    }

    private <T> List<T> collectValues(Map<?, List<T>> map) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        for (List<T> list : map.values()) {
            linkedHashSet.addAll(list);
        }
        return new ArrayList(linkedHashSet);
    }

    private static <T> List<T> getAnnotatedMembers(Map<Class<? extends Annotation>, List<T>> map, Class<? extends Annotation> clazz, boolean bl) {
        List<T> list;
        if (!map.containsKey(clazz) && bl) {
            map.put(clazz, new ArrayList());
        }
        return (list = map.get(clazz)) == null ? Collections.emptyList() : list;
    }

    private static boolean runsTopToBottom(Class<? extends Annotation> clazz) {
        return clazz.equals(Before.class) || clazz.equals(BeforeClass.class);
    }

    private static List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public Class<?> getJavaClass() {
        return this.clazz;
    }

    public String getName() {
        if (this.clazz == null) {
            return "null";
        }
        return this.clazz.getName();
    }

    public Constructor<?> getOnlyConstructor() {
        Constructor<?>[] constructorArray = this.clazz.getConstructors();
        Assert.assertEquals(1L, constructorArray.length);
        return constructorArray[0];
    }

    @Override
    public Annotation[] getAnnotations() {
        if (this.clazz == null) {
            return new Annotation[0];
        }
        return this.clazz.getAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (this.clazz == null) {
            return null;
        }
        return this.clazz.getAnnotation(clazz);
    }

    public <T> List<T> getAnnotatedFieldValues(Object object, Class<? extends Annotation> clazz, Class<T> clazz2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (FrameworkField frameworkField : this.getAnnotatedFields(clazz)) {
            try {
                Object object2 = frameworkField.get(object);
                if (!clazz2.isInstance(object2)) continue;
                arrayList.add(clazz2.cast(object2));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("How did getFields return a field we couldn't access?", illegalAccessException);
            }
        }
        return arrayList;
    }

    public <T> List<T> getAnnotatedMethodValues(Object object, Class<? extends Annotation> clazz, Class<T> clazz2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (FrameworkMethod frameworkMethod : this.getAnnotatedMethods(clazz)) {
            try {
                if (!clazz2.isAssignableFrom(frameworkMethod.getReturnType())) continue;
                Object object2 = frameworkMethod.invokeExplosively(object, new Object[0]);
                arrayList.add(clazz2.cast(object2));
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Exception in " + frameworkMethod.getName(), throwable);
            }
        }
        return arrayList;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.clazz.getModifiers());
    }

    public boolean isANonStaticInnerClass() {
        return this.clazz.isMemberClass() && !Modifier.isStatic(this.clazz.getModifiers());
    }

    public int hashCode() {
        return this.clazz == null ? 0 : this.clazz.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TestClass testClass = (TestClass)object;
        return this.clazz == testClass.clazz;
    }

    private static class MethodComparator
    implements Comparator<FrameworkMethod> {
        private MethodComparator() {
        }

        @Override
        public int compare(FrameworkMethod frameworkMethod, FrameworkMethod frameworkMethod2) {
            return MethodSorter.NAME_ASCENDING.compare(frameworkMethod.getMethod(), frameworkMethod2.getMethod());
        }
    }

    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field field, Field field2) {
            return field.getName().compareTo(field2.getName());
        }
    }
}

