/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.parameterized;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.parameterized.TestWithParameters;

public class BlockJUnit4ClassRunnerWithParameters
extends BlockJUnit4ClassRunner {
    private final Object[] parameters;
    private final String name;

    public BlockJUnit4ClassRunnerWithParameters(TestWithParameters testWithParameters) throws InitializationError {
        super(testWithParameters.getTestClass().getJavaClass());
        this.parameters = testWithParameters.getParameters().toArray(new Object[testWithParameters.getParameters().size()]);
        this.name = testWithParameters.getName();
    }

    @Override
    public Object createTest() throws Exception {
        if (this.fieldsAreAnnotated()) {
            return this.createTestUsingFieldInjection();
        }
        return this.createTestUsingConstructorInjection();
    }

    private Object createTestUsingConstructorInjection() throws Exception {
        return this.getTestClass().getOnlyConstructor().newInstance(this.parameters);
    }

    private Object createTestUsingFieldInjection() throws Exception {
        List<FrameworkField> list = this.getAnnotatedFieldsByParameter();
        if (list.size() != this.parameters.length) {
            throw new Exception("Wrong number of parameters and @Parameter fields. @Parameter fields counted: " + list.size() + ", available parameters: " + this.parameters.length + ".");
        }
        Object obj = this.getTestClass().getJavaClass().newInstance();
        for (FrameworkField frameworkField : list) {
            Field field = frameworkField.getField();
            Parameterized.Parameter parameter = field.getAnnotation(Parameterized.Parameter.class);
            int n = parameter.value();
            try {
                field.set(obj, this.parameters[n]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Exception(this.getTestClass().getName() + ": Trying to set " + field.getName() + " with the value " + this.parameters[n] + " that is not the right type (" + this.parameters[n].getClass().getSimpleName() + " instead of " + field.getType().getSimpleName() + ").", illegalArgumentException);
            }
        }
        return obj;
    }

    @Override
    protected String getName() {
        return this.name;
    }

    @Override
    protected String testName(FrameworkMethod frameworkMethod) {
        return frameworkMethod.getName() + this.getName();
    }

    @Override
    protected void validateConstructor(List<Throwable> list) {
        this.validateOnlyOneConstructor(list);
        if (this.fieldsAreAnnotated()) {
            this.validateZeroArgConstructor(list);
        }
    }

    @Override
    protected void validateFields(List<Throwable> list) {
        super.validateFields(list);
        if (this.fieldsAreAnnotated()) {
            List<FrameworkField> list2 = this.getAnnotatedFieldsByParameter();
            int[] nArray = new int[list2.size()];
            for (FrameworkField frameworkField : list2) {
                int n = frameworkField.getField().getAnnotation(Parameterized.Parameter.class).value();
                if (n < 0 || n > list2.size() - 1) {
                    list.add(new Exception("Invalid @Parameter value: " + n + ". @Parameter fields counted: " + list2.size() + ". Please use an index between 0 and " + (list2.size() - 1) + "."));
                    continue;
                }
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                if (n == 0) {
                    list.add(new Exception("@Parameter(" + i + ") is never used."));
                    continue;
                }
                if (n <= 1) continue;
                list.add(new Exception("@Parameter(" + i + ") is used more than once (" + n + ")."));
            }
        }
    }

    @Override
    protected Statement classBlock(RunNotifier runNotifier) {
        return this.childrenInvoker(runNotifier);
    }

    @Override
    protected Annotation[] getRunnerAnnotations() {
        return new Annotation[0];
    }

    private List<FrameworkField> getAnnotatedFieldsByParameter() {
        return this.getTestClass().getAnnotatedFields(Parameterized.Parameter.class);
    }

    private boolean fieldsAreAnnotated() {
        return !this.getAnnotatedFieldsByParameter().isEmpty();
    }
}

