/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private String fName;

    public TestCase() {
        this.fName = null;
    }

    public TestCase(String string) {
        this.fName = string;
    }

    @Override
    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult testResult = this.createResult();
        this.run(testResult);
        return testResult;
    }

    @Override
    public void run(TestResult testResult) {
        testResult.run(this);
    }

    public void runBare() throws Throwable {
        Throwable throwable = null;
        this.setUp();
        try {
            this.runTest();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            block13: {
                try {
                    this.tearDown();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block13;
                    throwable = throwable3;
                }
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    protected void runTest() throws Throwable {
        TestCase.assertNotNull("TestCase.fName cannot be null", this.fName);
        Method method = null;
        try {
            method = this.getClass().getMethod(this.fName, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            TestCase.fail("Method \"" + this.fName + "\" not found");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            TestCase.fail("Method \"" + this.fName + "\" should be public");
        }
        try {
            method.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.fillInStackTrace();
            throw invocationTargetException.getTargetException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.fillInStackTrace();
            throw illegalAccessException;
        }
    }

    public static void assertTrue(String string, boolean bl) {
        Assert.assertTrue(string, bl);
    }

    public static void assertTrue(boolean bl) {
        Assert.assertTrue(bl);
    }

    public static void assertFalse(String string, boolean bl) {
        Assert.assertFalse(string, bl);
    }

    public static void assertFalse(boolean bl) {
        Assert.assertFalse(bl);
    }

    public static void fail(String string) {
        Assert.fail(string);
    }

    public static void fail() {
        Assert.fail();
    }

    public static void assertEquals(String string, Object object, Object object2) {
        Assert.assertEquals(string, object, object2);
    }

    public static void assertEquals(Object object, Object object2) {
        Assert.assertEquals(object, object2);
    }

    public static void assertEquals(String string, String string2, String string3) {
        Assert.assertEquals(string, string2, string3);
    }

    public static void assertEquals(String string, String string2) {
        Assert.assertEquals(string, string2);
    }

    public static void assertEquals(String string, double d, double d2, double d3) {
        Assert.assertEquals(string, d, d2, d3);
    }

    public static void assertEquals(double d, double d2, double d3) {
        Assert.assertEquals(d, d2, d3);
    }

    public static void assertEquals(String string, float f, float f2, float f3) {
        Assert.assertEquals(string, f, f2, f3);
    }

    public static void assertEquals(float f, float f2, float f3) {
        Assert.assertEquals(f, f2, f3);
    }

    public static void assertEquals(String string, long l, long l2) {
        Assert.assertEquals(string, l, l2);
    }

    public static void assertEquals(long l, long l2) {
        Assert.assertEquals(l, l2);
    }

    public static void assertEquals(String string, boolean bl, boolean bl2) {
        Assert.assertEquals(string, bl, bl2);
    }

    public static void assertEquals(boolean bl, boolean bl2) {
        Assert.assertEquals(bl, bl2);
    }

    public static void assertEquals(String string, byte by, byte by2) {
        Assert.assertEquals(string, by, by2);
    }

    public static void assertEquals(byte by, byte by2) {
        Assert.assertEquals(by, by2);
    }

    public static void assertEquals(String string, char c, char c2) {
        Assert.assertEquals(string, c, c2);
    }

    public static void assertEquals(char c, char c2) {
        Assert.assertEquals(c, c2);
    }

    public static void assertEquals(String string, short s, short s2) {
        Assert.assertEquals(string, s, s2);
    }

    public static void assertEquals(short s, short s2) {
        Assert.assertEquals(s, s2);
    }

    public static void assertEquals(String string, int n, int n2) {
        Assert.assertEquals(string, n, n2);
    }

    public static void assertEquals(int n, int n2) {
        Assert.assertEquals(n, n2);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object);
    }

    public static void assertNotNull(String string, Object object) {
        Assert.assertNotNull(string, object);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object);
    }

    public static void assertNull(String string, Object object) {
        Assert.assertNull(string, object);
    }

    public static void assertSame(String string, Object object, Object object2) {
        Assert.assertSame(string, object, object2);
    }

    public static void assertSame(Object object, Object object2) {
        Assert.assertSame(object, object2);
    }

    public static void assertNotSame(String string, Object object, Object object2) {
        Assert.assertNotSame(string, object, object2);
    }

    public static void assertNotSame(Object object, Object object2) {
        Assert.assertNotSame(object, object2);
    }

    public static void failSame(String string) {
        Assert.failSame(string);
    }

    public static void failNotSame(String string, Object object, Object object2) {
        Assert.failNotSame(string, object, object2);
    }

    public static void failNotEquals(String string, Object object, Object object2) {
        Assert.failNotEquals(string, object, object2);
    }

    public static String format(String string, Object object, Object object2) {
        return Assert.format(string, object, object2);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String string) {
        this.fName = string;
    }
}

