/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AssumptionViolatedException;

public class Assume {
    public static void assumeTrue(boolean bl) {
        Assume.assumeThat(bl, CoreMatchers.is((Object)true));
    }

    public static void assumeFalse(boolean bl) {
        Assume.assumeTrue(!bl);
    }

    public static void assumeTrue(String string, boolean bl) {
        if (!bl) {
            throw new AssumptionViolatedException(string);
        }
    }

    public static void assumeFalse(String string, boolean bl) {
        Assume.assumeTrue(string, !bl);
    }

    public static void assumeNotNull(Object ... objectArray) {
        Assume.assumeThat(Arrays.asList(objectArray), CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()));
    }

    public static <T> void assumeThat(T t, Matcher<T> matcher) {
        if (!matcher.matches(t)) {
            throw new AssumptionViolatedException(t, matcher);
        }
    }

    public static <T> void assumeThat(String string, T t, Matcher<T> matcher) {
        if (!matcher.matches(t)) {
            throw new AssumptionViolatedException(string, t, matcher);
        }
    }

    public static void assumeNoException(Throwable throwable) {
        Assume.assumeThat(throwable, CoreMatchers.nullValue());
    }

    public static void assumeNoException(String string, Throwable throwable) {
        Assume.assumeThat(string, throwable, CoreMatchers.nullValue());
    }
}

