/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Computer;
import org.junit.runner.Runner;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.RunnerScheduler;

public class ParallelComputer
extends Computer {
    private final boolean classes;
    private final boolean methods;

    public ParallelComputer(boolean bl, boolean bl2) {
        this.classes = bl;
        this.methods = bl2;
    }

    public static Computer classes() {
        return new ParallelComputer(true, false);
    }

    public static Computer methods() {
        return new ParallelComputer(false, true);
    }

    private static Runner parallelize(Runner runner) {
        if (runner instanceof ParentRunner) {
            ((ParentRunner)runner).setScheduler(new RunnerScheduler(){
                private final ExecutorService fService = Executors.newCachedThreadPool();

                @Override
                public void schedule(Runnable runnable) {
                    this.fService.submit(runnable);
                }

                @Override
                public void finished() {
                    try {
                        this.fService.shutdown();
                        this.fService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace(System.err);
                    }
                }
            });
        }
        return runner;
    }

    @Override
    public Runner getSuite(RunnerBuilder runnerBuilder, Class<?>[] classArray) throws InitializationError {
        Runner runner = super.getSuite(runnerBuilder, classArray);
        return this.classes ? ParallelComputer.parallelize(runner) : runner;
    }

    @Override
    protected Runner getRunner(RunnerBuilder runnerBuilder, Class<?> clazz) throws Throwable {
        Runner runner = super.getRunner(runnerBuilder, clazz);
        return this.methods ? ParallelComputer.parallelize(runner) : runner;
    }
}

