/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.max;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.TestSuite;
import org.junit.experimental.max.MaxHistory;
import org.junit.internal.requests.SortingRequest;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class MaxCore {
    private static final String MALFORMED_JUNIT_3_TEST_CLASS_PREFIX = "malformed JUnit 3 test class: ";
    private final MaxHistory history;

    @Deprecated
    public static MaxCore forFolder(String string) {
        return MaxCore.storedLocally(new File(string));
    }

    public static MaxCore storedLocally(File file) {
        return new MaxCore(file);
    }

    private MaxCore(File file) {
        this.history = MaxHistory.forFolder(file);
    }

    public Result run(Class<?> clazz) {
        return this.run(Request.aClass(clazz));
    }

    public Result run(Request request) {
        return this.run(request, new JUnitCore());
    }

    public Result run(Request request, JUnitCore jUnitCore) {
        jUnitCore.addListener(this.history.listener());
        return jUnitCore.run(this.sortRequest(request).getRunner());
    }

    public Request sortRequest(Request request) {
        if (request instanceof SortingRequest) {
            return request;
        }
        List<Description> list = this.findLeaves(request);
        Collections.sort(list, this.history.testComparator());
        return this.constructLeafRequest(list);
    }

    private Request constructLeafRequest(List<Description> list) {
        final ArrayList<Runner> arrayList = new ArrayList<Runner>();
        for (Description description : list) {
            arrayList.add(this.buildRunner(description));
        }
        return new Request(){

            @Override
            public Runner getRunner() {
                try {
                    return new Suite((Class)null, arrayList){};
                }
                catch (InitializationError initializationError) {
                    return new ErrorReportingRunner(null, initializationError);
                }
            }
        };
    }

    private Runner buildRunner(Description description) {
        if (description.toString().equals("TestSuite with 0 tests")) {
            return Suite.emptySuite();
        }
        if (description.toString().startsWith(MALFORMED_JUNIT_3_TEST_CLASS_PREFIX)) {
            return new JUnit38ClassRunner(new TestSuite(this.getMalformedTestClass(description)));
        }
        Class<?> clazz = description.getTestClass();
        if (clazz == null) {
            throw new RuntimeException("Can't build a runner from description [" + description + "]");
        }
        String string = description.getMethodName();
        if (string == null) {
            return Request.aClass(clazz).getRunner();
        }
        return Request.method(clazz, string).getRunner();
    }

    private Class<?> getMalformedTestClass(Description description) {
        try {
            return Class.forName(description.toString().replace(MALFORMED_JUNIT_3_TEST_CLASS_PREFIX, ""));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public List<Description> sortedLeavesForTest(Request request) {
        return this.findLeaves(this.sortRequest(request));
    }

    private List<Description> findLeaves(Request request) {
        ArrayList<Description> arrayList = new ArrayList<Description>();
        this.findLeaves(null, request.getRunner().getDescription(), arrayList);
        return arrayList;
    }

    private void findLeaves(Description description, Description description2, List<Description> list) {
        if (description2.getChildren().isEmpty()) {
            if (description2.toString().equals("warning(junit.framework.TestSuite$1)")) {
                list.add(Description.createSuiteDescription(MALFORMED_JUNIT_3_TEST_CLASS_PREFIX + description, new Annotation[0]));
            } else {
                list.add(description2);
            }
        } else {
            for (Description description3 : description2.getChildren()) {
                this.findLeaves(description2, description3, list);
            }
        }
    }
}

