/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.FailedBefore;
import org.junit.internal.runners.TestMethod;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.TestTimedOutException;

@Deprecated
public class MethodRoadie {
    private final Object test;
    private final RunNotifier notifier;
    private final Description description;
    private TestMethod testMethod;

    public MethodRoadie(Object object, TestMethod testMethod, RunNotifier runNotifier, Description description) {
        this.test = object;
        this.notifier = runNotifier;
        this.description = description;
        this.testMethod = testMethod;
    }

    public void run() {
        if (this.testMethod.isIgnored()) {
            this.notifier.fireTestIgnored(this.description);
            return;
        }
        this.notifier.fireTestStarted(this.description);
        try {
            long l = this.testMethod.getTimeout();
            if (l > 0L) {
                this.runWithTimeout(l);
            } else {
                this.runTest();
            }
        }
        finally {
            this.notifier.fireTestFinished(this.description);
        }
    }

    private void runWithTimeout(final long l) {
        this.runBeforesThenTestThenAfters(new Runnable(){

            @Override
            public void run() {
                ExecutorService executorService = Executors.newSingleThreadExecutor();
                Callable<Object> callable = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        MethodRoadie.this.runTestMethod();
                        return null;
                    }
                };
                Future<Object> future = executorService.submit(callable);
                executorService.shutdown();
                try {
                    boolean bl = executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        executorService.shutdownNow();
                    }
                    future.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    MethodRoadie.this.addFailure(new TestTimedOutException(l, TimeUnit.MILLISECONDS));
                }
                catch (Exception exception) {
                    MethodRoadie.this.addFailure(exception);
                }
            }
        });
    }

    public void runTest() {
        this.runBeforesThenTestThenAfters(new Runnable(){

            @Override
            public void run() {
                MethodRoadie.this.runTestMethod();
            }
        });
    }

    public void runBeforesThenTestThenAfters(Runnable runnable) {
        try {
            this.runBefores();
            runnable.run();
        }
        catch (FailedBefore failedBefore) {
        }
        catch (Exception exception) {
            throw new RuntimeException("test should never throw an exception to this level");
        }
        finally {
            this.runAfters();
        }
    }

    protected void runTestMethod() {
        try {
            this.testMethod.invoke(this.test);
            if (this.testMethod.expectsException()) {
                this.addFailure((Throwable)((Object)new AssertionError((Object)("Expected exception: " + this.testMethod.getExpectedException().getName()))));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof AssumptionViolatedException) {
                return;
            }
            if (!this.testMethod.expectsException()) {
                this.addFailure(throwable);
            } else if (this.testMethod.isUnexpected(throwable)) {
                String string = "Unexpected exception, expected<" + this.testMethod.getExpectedException().getName() + "> but was<" + throwable.getClass().getName() + ">";
                this.addFailure(new Exception(string, throwable));
            }
        }
        catch (Throwable throwable) {
            this.addFailure(throwable);
        }
    }

    private void runBefores() throws FailedBefore {
        try {
            try {
                List<Method> list = this.testMethod.getBefores();
                for (Method method : list) {
                    method.invoke(this.test, new Object[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
        catch (AssumptionViolatedException assumptionViolatedException) {
            throw new FailedBefore();
        }
        catch (Throwable throwable) {
            this.addFailure(throwable);
            throw new FailedBefore();
        }
    }

    private void runAfters() {
        List<Method> list = this.testMethod.getAfters();
        for (Method method : list) {
            try {
                method.invoke(this.test, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.addFailure(invocationTargetException.getTargetException());
            }
            catch (Throwable throwable) {
                this.addFailure(throwable);
            }
        }
    }

    protected void addFailure(Throwable throwable) {
        this.notifier.fireTestFailure(new Failure(this.description, throwable));
    }
}

