/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;

public class FailOnTimeout
extends Statement {
    private final Statement originalStatement;
    private final TimeUnit timeUnit;
    private final long timeout;
    private final boolean lookForStuckThread;
    private volatile ThreadGroup threadGroup = null;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public FailOnTimeout(Statement statement, long l) {
        this(FailOnTimeout.builder().withTimeout(l, TimeUnit.MILLISECONDS), statement);
    }

    private FailOnTimeout(Builder builder, Statement statement) {
        this.originalStatement = statement;
        this.timeout = builder.timeout;
        this.timeUnit = builder.unit;
        this.lookForStuckThread = builder.lookForStuckThread;
    }

    @Override
    public void evaluate() throws Throwable {
        CallableStatement callableStatement = new CallableStatement();
        FutureTask<Throwable> futureTask = new FutureTask<Throwable>(callableStatement);
        this.threadGroup = new ThreadGroup("FailOnTimeoutGroup");
        Thread thread = new Thread(this.threadGroup, futureTask, "Time-limited test");
        thread.setDaemon(true);
        thread.start();
        callableStatement.awaitStarted();
        Throwable throwable = this.getResult(futureTask, thread);
        if (throwable != null) {
            throw throwable;
        }
    }

    private Throwable getResult(FutureTask<Throwable> futureTask, Thread thread) {
        try {
            if (this.timeout > 0L) {
                return futureTask.get(this.timeout, this.timeUnit);
            }
            return futureTask.get();
        }
        catch (InterruptedException interruptedException) {
            return interruptedException;
        }
        catch (ExecutionException executionException) {
            return executionException.getCause();
        }
        catch (TimeoutException timeoutException) {
            return this.createTimeoutException(thread);
        }
    }

    private Exception createTimeoutException(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        Thread thread2 = this.lookForStuckThread ? this.getStuckThread(thread) : null;
        TestTimedOutException testTimedOutException = new TestTimedOutException(this.timeout, this.timeUnit);
        if (stackTraceElementArray != null) {
            testTimedOutException.setStackTrace(stackTraceElementArray);
            thread.interrupt();
        }
        if (thread2 != null) {
            Exception exception = new Exception("Appears to be stuck in thread " + thread2.getName());
            exception.setStackTrace(this.getStackTrace(thread2));
            return new MultipleFailureException(Arrays.asList(testTimedOutException, exception));
        }
        return testTimedOutException;
    }

    private StackTraceElement[] getStackTrace(Thread thread) {
        try {
            return thread.getStackTrace();
        }
        catch (SecurityException securityException) {
            return new StackTraceElement[0];
        }
    }

    private Thread getStuckThread(Thread thread) {
        if (this.threadGroup == null) {
            return null;
        }
        Thread[] threadArray = this.getThreadArray(this.threadGroup);
        if (threadArray == null) {
            return null;
        }
        Thread thread2 = null;
        long l = 0L;
        for (Thread thread3 : threadArray) {
            if (thread3.getState() != Thread.State.RUNNABLE) continue;
            long l2 = this.cpuTime(thread3);
            if (thread2 != null && l2 <= l) continue;
            thread2 = thread3;
            l = l2;
        }
        return thread2 == thread ? null : thread2;
    }

    private Thread[] getThreadArray(ThreadGroup threadGroup) {
        Thread[] threadArray;
        int n;
        int n2 = threadGroup.activeCount();
        int n3 = 0;
        for (int i = Math.max(n2 * 2, 100); (n = threadGroup.enumerate(threadArray = new Thread[i])) >= i; i += 100) {
            if (++n3 < 5) continue;
            return null;
        }
        return this.copyThreads(threadArray, n);
    }

    private Thread[] copyThreads(Thread[] threadArray, int n) {
        int n2 = Math.min(n, threadArray.length);
        Thread[] threadArray2 = new Thread[n2];
        for (int i = 0; i < n2; ++i) {
            threadArray2[i] = threadArray[i];
        }
        return threadArray2;
    }

    private long cpuTime(Thread thread) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeSupported()) {
            try {
                return threadMXBean.getThreadCpuTime(thread.getId());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private class CallableStatement
    implements Callable<Throwable> {
        private final CountDownLatch startLatch = new CountDownLatch(1);

        private CallableStatement() {
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.startLatch.countDown();
                FailOnTimeout.this.originalStatement.evaluate();
            }
            catch (Exception exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }

        public void awaitStarted() throws InterruptedException {
            this.startLatch.await();
        }
    }

    public static class Builder {
        private boolean lookForStuckThread = false;
        private long timeout = 0L;
        private TimeUnit unit = TimeUnit.SECONDS;

        private Builder() {
        }

        public Builder withTimeout(long l, TimeUnit timeUnit) {
            if (l < 0L) {
                throw new IllegalArgumentException("timeout must be non-negative");
            }
            if (timeUnit == null) {
                throw new NullPointerException("TimeUnit cannot be null");
            }
            this.timeout = l;
            this.unit = timeUnit;
            return this;
        }

        public Builder withLookingForStuckThread(boolean bl) {
            this.lookForStuckThread = bl;
            return this;
        }

        public FailOnTimeout build(Statement statement) {
            if (statement == null) {
                throw new NullPointerException("statement cannot be null");
            }
            return new FailOnTimeout(this, statement);
        }
    }
}

