/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import java.util.concurrent.TimeUnit;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class Stopwatch
implements TestRule {
    private final Clock clock;
    private volatile long startNanos;
    private volatile long endNanos;

    public Stopwatch() {
        this(new Clock());
    }

    Stopwatch(Clock clock) {
        this.clock = clock;
    }

    public long runtime(TimeUnit timeUnit) {
        return timeUnit.convert(this.getNanos(), TimeUnit.NANOSECONDS);
    }

    protected void succeeded(long l, Description description) {
    }

    protected void failed(long l, Throwable throwable, Description description) {
    }

    protected void skipped(long l, AssumptionViolatedException assumptionViolatedException, Description description) {
    }

    protected void finished(long l, Description description) {
    }

    private long getNanos() {
        if (this.startNanos == 0L) {
            throw new IllegalStateException("Test has not started");
        }
        long l = this.endNanos;
        if (l == 0L) {
            l = this.clock.nanoTime();
        }
        return l - this.startNanos;
    }

    private void starting() {
        this.startNanos = this.clock.nanoTime();
        this.endNanos = 0L;
    }

    private void stopping() {
        this.endNanos = this.clock.nanoTime();
    }

    @Override
    public final Statement apply(Statement statement, Description description) {
        return new InternalWatcher().apply(statement, description);
    }

    static class Clock {
        Clock() {
        }

        public long nanoTime() {
            return System.nanoTime();
        }
    }

    private class InternalWatcher
    extends TestWatcher {
        private InternalWatcher() {
        }

        @Override
        protected void starting(Description description) {
            Stopwatch.this.starting();
        }

        @Override
        protected void finished(Description description) {
            Stopwatch.this.finished(Stopwatch.this.getNanos(), description);
        }

        @Override
        protected void succeeded(Description description) {
            Stopwatch.this.stopping();
            Stopwatch.this.succeeded(Stopwatch.this.getNanos(), description);
        }

        @Override
        protected void failed(Throwable throwable, Description description) {
            Stopwatch.this.stopping();
            Stopwatch.this.failed(Stopwatch.this.getNanos(), throwable, description);
        }

        @Override
        protected void skipped(AssumptionViolatedException assumptionViolatedException, Description description) {
            Stopwatch.this.stopping();
            Stopwatch.this.skipped(Stopwatch.this.getNanos(), assumptionViolatedException, description);
        }
    }
}

