/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (tcpprep_opts.c)
 *
 *  It has been AutoGen-ed
 *  From the definitions    tcpprep_opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 41:0:16 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the tcpprep author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The tcpprep program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2000-2016 Aaron Turner and Fred Klassen, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  tcpprep is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  tcpprep is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __doxygen__
#define OPTION_CODE_COMPILE 1
#include "tcpprep_opts.h"
#include <sys/types.h>

#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;
#define zCopyright      (tcpprep_opt_strs+0)
#define zLicenseDescrip (tcpprep_opt_strs+279)

/*
 *  global included definitions
 */
#include "defines.h"
#include "common.h"
#include "config.h"
#include "tcpprep.h"
#include <stdlib.h>
#include <string.h>
#include "tcpprep_api.h"
extern tcpprep_t *tcpprep;


#ifndef NULL
#  define NULL 0
#endif

/**
 *  static const strings for tcpprep options
 */
static char const tcpprep_opt_strs[3076] =
/*     0 */ "tcpprep (tcpprep)\n"
            "Copyright (C) 2000-2016 Aaron Turner and Fred Klassen, all rights reserved.\n"
            "This is free software. It is licensed for use, modification and\n"
            "redistribution under the terms of the GNU General Public License,\n"
            "version 3 or later <http://gnu.org/licenses/gpl.html>\n\0"
/*   279 */ "tcpprep is free software: you can redistribute it and/or modify it under\n"
            "the terms of the GNU General Public License as published by the Free\n"
            "Software Foundation, either version 3 of the License, or (at your option)\n"
            "any later version.\n\n"
            "tcpprep is distributed in the hope that it will be useful, but WITHOUT ANY\n"
            "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n"
            "FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more\n"
            "details.\n\n"
            "You should have received a copy of the GNU General Public License along\n"
            "with this program.  If not, see <http://www.gnu.org/licenses/>.\n\0"
/*   882 */ "Enable debugging output\0"
/*   906 */ "DBUG\0"
/*   911 */ "dbug\0"
/*   916 */ "Auto-split mode\0"
/*   932 */ "AUTO\0"
/*   937 */ "auto\0"
/*   942 */ "CIDR-split mode\0"
/*   958 */ "CIDR\0"
/*   963 */ "cidr\0"
/*   968 */ "Regex-split mode\0"
/*   985 */ "REGEX\0"
/*   991 */ "regex\0"
/*   997 */ "Port-split mode\0"
/*  1013 */ "PORT\0"
/*  1018 */ "port\0"
/*  1023 */ "Source MAC split mode\0"
/*  1045 */ "MAC\0"
/*  1049 */ "mac\0"
/*  1053 */ "Matches to be client instead of server\0"
/*  1092 */ "REVERSE\0"
/*  1100 */ "reverse\0"
/*  1108 */ "Embeded cache file comment\0"
/*  1135 */ "COMMENT\0"
/*  1143 */ "comment\0"
/*  1151 */ "Do not embed any cache file comment\0"
/*  1187 */ "NO_ARG_COMMENT\0"
/*  1202 */ "no-arg-comment\0"
/*  1217 */ "Include only packets matching rule\0"
/*  1252 */ "INCLUDE\0"
/*  1260 */ "include\0"
/*  1268 */ "Exclude any packet matching this rule\0"
/*  1306 */ "EXCLUDE\0"
/*  1314 */ "exclude\0"
/*  1322 */ "Output cache file\0"
/*  1340 */ "CACHEFILE\0"
/*  1350 */ "cachefile\0"
/*  1360 */ "Input pcap file to process\0"
/*  1387 */ "PCAP\0"
/*  1392 */ "pcap\0"
/*  1397 */ "Print embedded comment in the specified cache file\0"
/*  1448 */ "PRINT_COMMENT\0"
/*  1462 */ "print-comment\0"
/*  1476 */ "Print basic info from the specified cache file\0"
/*  1523 */ "PRINT_INFO\0"
/*  1534 */ "print-info\0"
/*  1545 */ "Print statistical information about the specified cache file\0"
/*  1606 */ "PRINT_STATS\0"
/*  1618 */ "print-stats\0"
/*  1630 */ "Load services file for server ports\0"
/*  1666 */ "SERVICES\0"
/*  1675 */ "services\0"
/*  1684 */ "Send non-IP traffic out server interface\0"
/*  1725 */ "NONIP\0"
/*  1731 */ "nonip\0"
/*  1737 */ "Ratio of client to server packets\0"
/*  1771 */ "RATIO\0"
/*  1777 */ "ratio\0"
/*  1783 */ "2.0\0"
/*  1787 */ "Minimum network mask length in auto mode\0"
/*  1828 */ "MINMASK\0"
/*  1836 */ "minmask\0"
/*  1844 */ "Maximum network mask length in auto mode\0"
/*  1885 */ "MAXMASK\0"
/*  1893 */ "maxmask\0"
/*  1901 */ "Print decoded packets via tcpdump to STDOUT\0"
/*  1945 */ "VERBOSE\0"
/*  1953 */ "verbose\0"
/*  1961 */ "Arguments passed to tcpdump decoder\0"
/*  1997 */ "DECODE\0"
/*  2004 */ "decode\0"
/*  2011 */ "Print version information\0"
/*  2037 */ "VERSION\0"
/*  2045 */ "version\0"
/*  2053 */ "Display less usage information and exit\0"
/*  2093 */ "LESS_HELP\0"
/*  2103 */ "less-help\0"
/*  2113 */ "display extended usage information and exit\0"
/*  2157 */ "help\0"
/*  2162 */ "extended usage information passed thru pager\0"
/*  2207 */ "more-help\0"
/*  2217 */ "save the option state to a config file\0"
/*  2256 */ "save-opts\0"
/*  2266 */ "load options from a config file\0"
/*  2298 */ "LOAD_OPTS\0"
/*  2308 */ "no-load-opts\0"
/*  2321 */ "no\0"
/*  2324 */ "TCPPREP\0"
/*  2332 */ "tcpprep (tcpprep) - Create a tcpreplay cache cache file from a pcap file.\n"
            "Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]...\n\0"
/*  2464 */ "$$/\0"
/*  2468 */ ".tcppreprc\0"
/*  2479 */ "tcpreplay-users@lists.sourceforge.net\0"
/*  2517 */ "tcpprep is a 'pcap(3)' file pre-processor which creates a cache file which\n"
            "provides \"rules\" for 'tcprewrite(1)' and 'tcpreplay(1)' on how to process\n"
            "and send packets.\n\0"
/*  2685 */ "The basic operation of tcpreplay is to resend all packets from the input\n"
            "file(s) out a single file.  Tcpprep processes a pcap file and applies a set\n"
            "of user-specified rules to create a cache file which tells tcpreplay wether\n"
            "or not to send each packet and which interface the packet should be sent\n"
            "out of.\n\n"
            "For more details, please see the Tcpreplay Manual at:\n"
            "http://tcpreplay.appneta.com\n";

/**
 *  dbug option description:
 */
#ifdef DEBUG
/** Descriptive text for the dbug option */
#define DBUG_DESC      (tcpprep_opt_strs+882)
/** Upper-cased name for the dbug option */
#define DBUG_NAME      (tcpprep_opt_strs+906)
/** Name string for the dbug option */
#define DBUG_name      (tcpprep_opt_strs+911)
/** The compiled in default value for the dbug option argument */
#define DBUG_DFT_ARG   ((char const*)0)
/** Compiled in flag settings for the dbug option */
#define DBUG_FLAGS     (OPTST_DISABLED | OPTST_IMM \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

#else   /* disable dbug */
#define DBUG_FLAGS     (OPTST_OMITTED | OPTST_NO_INIT)
#define DBUG_DFT_ARG   NULL
#define DBUG_NAME      NULL
#define DBUG_DESC      NULL
#define DBUG_name      NULL
#endif  /* DEBUG */

/**
 *  auto option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the auto option */
#define AUTO_DESC      (tcpprep_opt_strs+916)
/** Upper-cased name for the auto option */
#define AUTO_NAME      (tcpprep_opt_strs+932)
/** Name string for the auto option */
#define AUTO_name      (tcpprep_opt_strs+937)
/** Other options that appear in conjunction with the auto option */
static int const aAutoCantList[] = {
    INDEX_OPT_CIDR,
    INDEX_OPT_PORT,
    INDEX_OPT_REGEX,
    INDEX_OPT_MAC, NO_EQUIVALENT };
/** Compiled in flag settings for the auto option */
#define AUTO_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  cidr option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the cidr option */
#define CIDR_DESC      (tcpprep_opt_strs+942)
/** Upper-cased name for the cidr option */
#define CIDR_NAME      (tcpprep_opt_strs+958)
/** Name string for the cidr option */
#define CIDR_name      (tcpprep_opt_strs+963)
/** Other options that appear in conjunction with the cidr option */
static int const aCidrCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_PORT,
    INDEX_OPT_REGEX,
    INDEX_OPT_MAC, NO_EQUIVALENT };
/** Compiled in flag settings for the cidr option */
#define CIDR_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  regex option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the regex option */
#define REGEX_DESC      (tcpprep_opt_strs+968)
/** Upper-cased name for the regex option */
#define REGEX_NAME      (tcpprep_opt_strs+985)
/** Name string for the regex option */
#define REGEX_name      (tcpprep_opt_strs+991)
/** Other options that appear in conjunction with the regex option */
static int const aRegexCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_PORT,
    INDEX_OPT_CIDR,
    INDEX_OPT_MAC, NO_EQUIVALENT };
/** Compiled in flag settings for the regex option */
#define REGEX_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  port option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the port option */
#define PORT_DESC      (tcpprep_opt_strs+997)
/** Upper-cased name for the port option */
#define PORT_NAME      (tcpprep_opt_strs+1013)
/** Name string for the port option */
#define PORT_name      (tcpprep_opt_strs+1018)
/** Other options that appear in conjunction with the port option */
static int const aPortCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_REGEX,
    INDEX_OPT_CIDR,
    INDEX_OPT_MAC, NO_EQUIVALENT };
/** Compiled in flag settings for the port option */
#define PORT_FLAGS     (OPTST_DISABLED)

/**
 *  mac option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the mac option */
#define MAC_DESC      (tcpprep_opt_strs+1023)
/** Upper-cased name for the mac option */
#define MAC_NAME      (tcpprep_opt_strs+1045)
/** Name string for the mac option */
#define MAC_name      (tcpprep_opt_strs+1049)
/** Other options that appear in conjunction with the mac option */
static int const aMacCantList[] = {
    INDEX_OPT_AUTO,
    INDEX_OPT_REGEX,
    INDEX_OPT_CIDR,
    INDEX_OPT_PORT, NO_EQUIVALENT };
/** Compiled in flag settings for the mac option */
#define MAC_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  reverse option description:
 */
/** Descriptive text for the reverse option */
#define REVERSE_DESC      (tcpprep_opt_strs+1053)
/** Upper-cased name for the reverse option */
#define REVERSE_NAME      (tcpprep_opt_strs+1092)
/** Name string for the reverse option */
#define REVERSE_name      (tcpprep_opt_strs+1100)
/** Compiled in flag settings for the reverse option */
#define REVERSE_FLAGS     (OPTST_DISABLED)

/**
 *  comment option description:
 */
/** Descriptive text for the comment option */
#define COMMENT_DESC      (tcpprep_opt_strs+1108)
/** Upper-cased name for the comment option */
#define COMMENT_NAME      (tcpprep_opt_strs+1135)
/** Name string for the comment option */
#define COMMENT_name      (tcpprep_opt_strs+1143)
/** Compiled in flag settings for the comment option */
#define COMMENT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  no-arg-comment option description:
 */
/** Descriptive text for the no-arg-comment option */
#define NO_ARG_COMMENT_DESC      (tcpprep_opt_strs+1151)
/** Upper-cased name for the no-arg-comment option */
#define NO_ARG_COMMENT_NAME      (tcpprep_opt_strs+1187)
/** Name string for the no-arg-comment option */
#define NO_ARG_COMMENT_name      (tcpprep_opt_strs+1202)
/** Compiled in flag settings for the no-arg-comment option */
#define NO_ARG_COMMENT_FLAGS     (OPTST_DISABLED)

/**
 *  include option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the include option */
#define INCLUDE_DESC      (tcpprep_opt_strs+1217)
/** Upper-cased name for the include option */
#define INCLUDE_NAME      (tcpprep_opt_strs+1252)
/** Name string for the include option */
#define INCLUDE_name      (tcpprep_opt_strs+1260)
/** Other options that appear in conjunction with the include option */
static int const aIncludeCantList[] = {
    INDEX_OPT_EXCLUDE, NO_EQUIVALENT };
/** Compiled in flag settings for the include option */
#define INCLUDE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  exclude option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the exclude option */
#define EXCLUDE_DESC      (tcpprep_opt_strs+1268)
/** Upper-cased name for the exclude option */
#define EXCLUDE_NAME      (tcpprep_opt_strs+1306)
/** Name string for the exclude option */
#define EXCLUDE_name      (tcpprep_opt_strs+1314)
/** Other options that appear in conjunction with the exclude option */
static int const aExcludeCantList[] = {
    INDEX_OPT_INCLUDE, NO_EQUIVALENT };
/** Compiled in flag settings for the exclude option */
#define EXCLUDE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  cachefile option description:
 */
/** Descriptive text for the cachefile option */
#define CACHEFILE_DESC      (tcpprep_opt_strs+1322)
/** Upper-cased name for the cachefile option */
#define CACHEFILE_NAME      (tcpprep_opt_strs+1340)
/** Name string for the cachefile option */
#define CACHEFILE_name      (tcpprep_opt_strs+1350)
/** Compiled in flag settings for the cachefile option */
#define CACHEFILE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  pcap option description:
 */
/** Descriptive text for the pcap option */
#define PCAP_DESC      (tcpprep_opt_strs+1360)
/** Upper-cased name for the pcap option */
#define PCAP_NAME      (tcpprep_opt_strs+1387)
/** Name string for the pcap option */
#define PCAP_name      (tcpprep_opt_strs+1392)
/** Compiled in flag settings for the pcap option */
#define PCAP_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  print-comment option description:
 */
/** Descriptive text for the print-comment option */
#define PRINT_COMMENT_DESC      (tcpprep_opt_strs+1397)
/** Upper-cased name for the print-comment option */
#define PRINT_COMMENT_NAME      (tcpprep_opt_strs+1448)
/** Name string for the print-comment option */
#define PRINT_COMMENT_name      (tcpprep_opt_strs+1462)
/** Compiled in flag settings for the print-comment option */
#define PRINT_COMMENT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  print-info option description:
 */
/** Descriptive text for the print-info option */
#define PRINT_INFO_DESC      (tcpprep_opt_strs+1476)
/** Upper-cased name for the print-info option */
#define PRINT_INFO_NAME      (tcpprep_opt_strs+1523)
/** Name string for the print-info option */
#define PRINT_INFO_name      (tcpprep_opt_strs+1534)
/** Compiled in flag settings for the print-info option */
#define PRINT_INFO_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  print-stats option description:
 */
/** Descriptive text for the print-stats option */
#define PRINT_STATS_DESC      (tcpprep_opt_strs+1545)
/** Upper-cased name for the print-stats option */
#define PRINT_STATS_NAME      (tcpprep_opt_strs+1606)
/** Name string for the print-stats option */
#define PRINT_STATS_name      (tcpprep_opt_strs+1618)
/** Compiled in flag settings for the print-stats option */
#define PRINT_STATS_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  services option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the services option */
#define SERVICES_DESC      (tcpprep_opt_strs+1630)
/** Upper-cased name for the services option */
#define SERVICES_NAME      (tcpprep_opt_strs+1666)
/** Name string for the services option */
#define SERVICES_name      (tcpprep_opt_strs+1675)
/** Other options that are required by the services option */
static int const aServicesMustList[] = {
    INDEX_OPT_PORT, NO_EQUIVALENT };
/** Compiled in flag settings for the services option */
#define SERVICES_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  nonip option description:
 */
/** Descriptive text for the nonip option */
#define NONIP_DESC      (tcpprep_opt_strs+1684)
/** Upper-cased name for the nonip option */
#define NONIP_NAME      (tcpprep_opt_strs+1725)
/** Name string for the nonip option */
#define NONIP_name      (tcpprep_opt_strs+1731)
/** Compiled in flag settings for the nonip option */
#define NONIP_FLAGS     (OPTST_DISABLED)

/**
 *  ratio option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the ratio option */
#define RATIO_DESC      (tcpprep_opt_strs+1737)
/** Upper-cased name for the ratio option */
#define RATIO_NAME      (tcpprep_opt_strs+1771)
/** Name string for the ratio option */
#define RATIO_name      (tcpprep_opt_strs+1777)
/** The compiled in default value for the ratio option argument */
#define RATIO_DFT_ARG   (tcpprep_opt_strs+1783)
/** Other options that are required by the ratio option */
static int const aRatioMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
/** Compiled in flag settings for the ratio option */
#define RATIO_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  minmask option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the minmask option */
#define MINMASK_DESC      (tcpprep_opt_strs+1787)
/** Upper-cased name for the minmask option */
#define MINMASK_NAME      (tcpprep_opt_strs+1828)
/** Name string for the minmask option */
#define MINMASK_name      (tcpprep_opt_strs+1836)
/** The compiled in default value for the minmask option argument */
#define MINMASK_DFT_ARG   ((char const*)30)
/** Other options that are required by the minmask option */
static int const aMinmaskMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
/** Compiled in flag settings for the minmask option */
#define MINMASK_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  maxmask option description with
 *  "Must also have options" and "Incompatible options":
 */
/** Descriptive text for the maxmask option */
#define MAXMASK_DESC      (tcpprep_opt_strs+1844)
/** Upper-cased name for the maxmask option */
#define MAXMASK_NAME      (tcpprep_opt_strs+1885)
/** Name string for the maxmask option */
#define MAXMASK_name      (tcpprep_opt_strs+1893)
/** The compiled in default value for the maxmask option argument */
#define MAXMASK_DFT_ARG   ((char const*)8)
/** Other options that are required by the maxmask option */
static int const aMaxmaskMustList[] = {
    INDEX_OPT_AUTO, NO_EQUIVALENT };
/** Compiled in flag settings for the maxmask option */
#define MAXMASK_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  verbose option description:
 */
#ifdef ENABLE_VERBOSE
/** Descriptive text for the verbose option */
#define VERBOSE_DESC      (tcpprep_opt_strs+1901)
/** Upper-cased name for the verbose option */
#define VERBOSE_NAME      (tcpprep_opt_strs+1945)
/** Name string for the verbose option */
#define VERBOSE_name      (tcpprep_opt_strs+1953)
/** Compiled in flag settings for the verbose option */
#define VERBOSE_FLAGS     (OPTST_DISABLED | OPTST_IMM)

#else   /* disable verbose */
#define VERBOSE_FLAGS     (OPTST_OMITTED | OPTST_NO_INIT)
#define VERBOSE_NAME      NULL
#define VERBOSE_DESC      NULL
#define VERBOSE_name      NULL
#endif  /* ENABLE_VERBOSE */

/**
 *  decode option description with
 *  "Must also have options" and "Incompatible options":
 */
#ifdef ENABLE_VERBOSE
/** Descriptive text for the decode option */
#define DECODE_DESC      (tcpprep_opt_strs+1961)
/** Upper-cased name for the decode option */
#define DECODE_NAME      (tcpprep_opt_strs+1997)
/** Name string for the decode option */
#define DECODE_name      (tcpprep_opt_strs+2004)
/** Other options that are required by the decode option */
static int const aDecodeMustList[] = {
    INDEX_OPT_VERBOSE, NO_EQUIVALENT };
/** Compiled in flag settings for the decode option */
#define DECODE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

#else   /* disable decode */
#define DECODE_FLAGS     (OPTST_OMITTED | OPTST_NO_INIT)
#define aDecodeMustList   NULL
#define DECODE_NAME      NULL
#define DECODE_DESC      NULL
#define DECODE_name      NULL
#endif  /* ENABLE_VERBOSE */

/**
 *  version option description:
 */
/** Descriptive text for the version option */
#define VERSION_DESC      (tcpprep_opt_strs+2011)
/** Upper-cased name for the version option */
#define VERSION_NAME      (tcpprep_opt_strs+2037)
/** Name string for the version option */
#define VERSION_name      (tcpprep_opt_strs+2045)
/** Compiled in flag settings for the version option */
#define VERSION_FLAGS     (OPTST_DISABLED)

/**
 *  less-help option description:
 */
/** Descriptive text for the less-help option */
#define LESS_HELP_DESC      (tcpprep_opt_strs+2053)
/** Upper-cased name for the less-help option */
#define LESS_HELP_NAME      (tcpprep_opt_strs+2093)
/** Name string for the less-help option */
#define LESS_HELP_name      (tcpprep_opt_strs+2103)
/** Compiled in flag settings for the less-help option */
#define LESS_HELP_FLAGS     (OPTST_DISABLED | OPTST_IMM)

/*
 *  Help/More_Help option descriptions:
 */
#define HELP_DESC       (tcpprep_opt_strs+2113)
#define HELP_name       (tcpprep_opt_strs+2157)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (tcpprep_opt_strs+2162)
#define MORE_HELP_name  (tcpprep_opt_strs+2207)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  HELP_DESC
#define MORE_HELP_name  HELP_name
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#define SAVE_OPTS_DESC  (tcpprep_opt_strs+2217)
#define SAVE_OPTS_name  (tcpprep_opt_strs+2256)
#define LOAD_OPTS_DESC     (tcpprep_opt_strs+2266)
#define LOAD_OPTS_NAME     (tcpprep_opt_strs+2298)
#define NO_LOAD_OPTS_name  (tcpprep_opt_strs+2308)
#define LOAD_OPTS_pfx      (tcpprep_opt_strs+2321)
#define LOAD_OPTS_name     (NO_LOAD_OPTS_name + 3)
/**
 *  Declare option callback procedures
 */
#ifdef DEBUG
  static tOptProc doOptDbug;
#else /* not DEBUG */
# define doOptDbug NULL
#endif /* def/not DEBUG */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doOptAuto,           doOptCidr,           doOptComment,
    doOptExclude,        doOptInclude,        doOptLess_Help,
    doOptMac,            doOptMaxmask,        doOptMinmask,
    doOptNo_Arg_Comment, doOptNonip,          doOptPort,
    doOptRegex,          doOptServices,       doOptVersion,
    doUsageOpt;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Define the tcpprep Option Descriptions.
 * This is an array of OPTION_CT entries, one for each
 * option that the tcpprep program responds to.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, VALUE_OPT_DBUG,
     /* equiv idx, value */ 0, VALUE_OPT_DBUG,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DBUG_FLAGS, 0,
     /* last opt argumnt */ { DBUG_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptDbug,
     /* desc, NAME, name */ DBUG_DESC, DBUG_NAME, DBUG_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_AUTO,
     /* equiv idx, value */ 1, VALUE_OPT_AUTO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ AUTO_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --auto */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aAutoCantList,
     /* option proc      */ doOptAuto,
     /* desc, NAME, name */ AUTO_DESC, AUTO_NAME, AUTO_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_CIDR,
     /* equiv idx, value */ 2, VALUE_OPT_CIDR,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CIDR_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --cidr */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aCidrCantList,
     /* option proc      */ doOptCidr,
     /* desc, NAME, name */ CIDR_DESC, CIDR_NAME, CIDR_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_REGEX,
     /* equiv idx, value */ 3, VALUE_OPT_REGEX,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ REGEX_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --regex */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aRegexCantList,
     /* option proc      */ doOptRegex,
     /* desc, NAME, name */ REGEX_DESC, REGEX_NAME, REGEX_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_PORT,
     /* equiv idx, value */ 4, VALUE_OPT_PORT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PORT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --port */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aPortCantList,
     /* option proc      */ doOptPort,
     /* desc, NAME, name */ PORT_DESC, PORT_NAME, PORT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_MAC,
     /* equiv idx, value */ 5, VALUE_OPT_MAC,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MAC_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --mac */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aMacCantList,
     /* option proc      */ doOptMac,
     /* desc, NAME, name */ MAC_DESC, MAC_NAME, MAC_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 6, VALUE_OPT_REVERSE,
     /* equiv idx, value */ 6, VALUE_OPT_REVERSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ REVERSE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --reverse */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ REVERSE_DESC, REVERSE_NAME, REVERSE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 7, VALUE_OPT_COMMENT,
     /* equiv idx, value */ 7, VALUE_OPT_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --comment */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptComment,
     /* desc, NAME, name */ COMMENT_DESC, COMMENT_NAME, COMMENT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_NO_ARG_COMMENT,
     /* equiv idx, value */ 8, VALUE_OPT_NO_ARG_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NO_ARG_COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --no-arg-comment */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptNo_Arg_Comment,
     /* desc, NAME, name */ NO_ARG_COMMENT_DESC, NO_ARG_COMMENT_NAME, NO_ARG_COMMENT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_INCLUDE,
     /* equiv idx, value */ 9, VALUE_OPT_INCLUDE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ INCLUDE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --include */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aIncludeCantList,
     /* option proc      */ doOptInclude,
     /* desc, NAME, name */ INCLUDE_DESC, INCLUDE_NAME, INCLUDE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_EXCLUDE,
     /* equiv idx, value */ 10, VALUE_OPT_EXCLUDE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ EXCLUDE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --exclude */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, aExcludeCantList,
     /* option proc      */ doOptExclude,
     /* desc, NAME, name */ EXCLUDE_DESC, EXCLUDE_NAME, EXCLUDE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_CACHEFILE,
     /* equiv idx, value */ 11, VALUE_OPT_CACHEFILE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ CACHEFILE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --cachefile */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ CACHEFILE_DESC, CACHEFILE_NAME, CACHEFILE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 12, VALUE_OPT_PCAP,
     /* equiv idx, value */ 12, VALUE_OPT_PCAP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PCAP_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --pcap */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ PCAP_DESC, PCAP_NAME, PCAP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 13, VALUE_OPT_PRINT_COMMENT,
     /* equiv idx, value */ 13, VALUE_OPT_PRINT_COMMENT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_COMMENT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --print-comment */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ PRINT_COMMENT_DESC, PRINT_COMMENT_NAME, PRINT_COMMENT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 14, VALUE_OPT_PRINT_INFO,
     /* equiv idx, value */ 14, VALUE_OPT_PRINT_INFO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_INFO_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --print-info */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ PRINT_INFO_DESC, PRINT_INFO_NAME, PRINT_INFO_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 15, VALUE_OPT_PRINT_STATS,
     /* equiv idx, value */ 15, VALUE_OPT_PRINT_STATS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ PRINT_STATS_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --print-stats */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ PRINT_STATS_DESC, PRINT_STATS_NAME, PRINT_STATS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 16, VALUE_OPT_SERVICES,
     /* equiv idx, value */ 16, VALUE_OPT_SERVICES,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SERVICES_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --services */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aServicesMustList, NULL,
     /* option proc      */ doOptServices,
     /* desc, NAME, name */ SERVICES_DESC, SERVICES_NAME, SERVICES_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 17, VALUE_OPT_NONIP,
     /* equiv idx, value */ 17, VALUE_OPT_NONIP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NONIP_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --nonip */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptNonip,
     /* desc, NAME, name */ NONIP_DESC, NONIP_NAME, NONIP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 18, VALUE_OPT_RATIO,
     /* equiv idx, value */ 18, VALUE_OPT_RATIO,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ RATIO_FLAGS, 0,
     /* last opt argumnt */ { RATIO_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aRatioMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ RATIO_DESC, RATIO_NAME, RATIO_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 19, VALUE_OPT_MINMASK,
     /* equiv idx, value */ 19, VALUE_OPT_MINMASK,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MINMASK_FLAGS, 0,
     /* last opt argumnt */ { MINMASK_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aMinmaskMustList, NULL,
     /* option proc      */ doOptMinmask,
     /* desc, NAME, name */ MINMASK_DESC, MINMASK_NAME, MINMASK_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 20, VALUE_OPT_MAXMASK,
     /* equiv idx, value */ 20, VALUE_OPT_MAXMASK,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MAXMASK_FLAGS, 0,
     /* last opt argumnt */ { MAXMASK_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aMaxmaskMustList, NULL,
     /* option proc      */ doOptMaxmask,
     /* desc, NAME, name */ MAXMASK_DESC, MAXMASK_NAME, MAXMASK_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 21, VALUE_OPT_VERBOSE,
     /* equiv idx, value */ 21, VALUE_OPT_VERBOSE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERBOSE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --verbose */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ VERBOSE_DESC, VERBOSE_NAME, VERBOSE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 22, VALUE_OPT_DECODE,
     /* equiv idx, value */ 22, VALUE_OPT_DECODE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DECODE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --decode */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ aDecodeMustList, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DECODE_DESC, DECODE_NAME, DECODE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 23, VALUE_OPT_VERSION,
     /* equiv idx, value */ 23, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VERSION_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --version */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptVersion,
     /* desc, NAME, name */ VERSION_DESC, VERSION_NAME, VERSION_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 24, VALUE_OPT_LESS_HELP,
     /* equiv idx, value */ 24, VALUE_OPT_LESS_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ LESS_HELP_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --less-help */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptLess_Help,
     /* desc, NAME, name */ LESS_HELP_DESC, LESS_HELP_NAME, LESS_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, AOUSE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, AOUSE_MORE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_SAVE_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                       | OPTST_ARG_OPTIONAL | OPTST_NO_INIT, AOUSE_SAVE_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SAVE_OPTS_DESC, NULL, SAVE_OPTS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_LOAD_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
			  | OPTST_DISABLE_IMM, AOUSE_LOAD_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ LOAD_OPTS_DESC, LOAD_OPTS_NAME, LOAD_OPTS_name,
     /* disablement strs */ NO_LOAD_OPTS_name, LOAD_OPTS_pfx }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/** Reference to the upper cased version of tcpprep. */
#define zPROGNAME       (tcpprep_opt_strs+2324)
/** Reference to the title line for tcpprep usage. */
#define zUsageTitle     (tcpprep_opt_strs+2332)
/** tcpprep configuration file name. */
#define zRcName         (tcpprep_opt_strs+2468)
/** Directories to search for tcpprep config files. */
static char const * const apzHomeList[2] = {
    tcpprep_opt_strs+2464,
    NULL };
/** The tcpprep program bug email address. */
#define zBugsAddr       (tcpprep_opt_strs+2479)
/** Clarification/explanation of what tcpprep does. */
#define zExplain        (tcpprep_opt_strs+2517)
/** Extra detail explaining what tcpprep does. */
#define zDetail         (tcpprep_opt_strs+2685)
/** The full version string for tcpprep. */
#define zFullVersion    (NULL)
/* extracted from optcode.tlib near line 364 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

#define tcpprep_full_usage (NULL)
#define tcpprep_short_usage (NULL)

#endif /* not defined __doxygen__ */

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the optionUsage function.
 *
 * @param[in] opts the AutoOpts option description structure
 * @param[in] od   the descriptor for the "help" (usage) option.
 * @noreturn
 */
static void
doUsageOpt(tOptions * opts, tOptDesc * od)
{
    int ex_code;
    ex_code = TCPPREP_EXIT_SUCCESS;
    optionUsage(&tcpprepOptions, ex_code);
    /* NOTREACHED */
    exit(1);
    (void)opts;
    (void)od;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the dbug option, when DEBUG is #define-d.
 * If configured with --enable-debug, then you can specify a verbosity
 * level for debugging output.  Higher numbers increase verbosity.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
#ifdef DEBUG
static void
doOptDbug(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static struct {long rmin, rmax;} const rng[1] = {
        { 0, 5 } };
    int  ix;

    if (pOptions <= OPTPROC_EMIT_LIMIT)
        goto emit_ranges;
    optionNumericVal(pOptions, pOptDesc);

    for (ix = 0; ix < 1; ix++) {
        if (pOptDesc->optArg.argInt < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (pOptDesc->optArg.argInt == rng[ix].rmin)
            return;
        if (rng[ix].rmax == LONG_MIN)
            continue;
        if (pOptDesc->optArg.argInt <= rng[ix].rmax)
            return;
    }

    option_usage_fp = stderr;

 emit_ranges:
    optionShowRange(pOptions, pOptDesc, (void *)rng, 1);
}
#endif /* defined DEBUG */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the auto option.
 * Tcpprep will try to automatically determine the primary function of hosts
 * based on the traffic captured and classify each host as client or server.
 * In order to do so, you must provide a hint to tcpprep as to how to search
 * for clients and servers.  Valid hints are:
 *
 * @table @bullet
 * @item
 * @var{bridge}
 * Bridge mode processes each packet to try to determine if the sender is a
 * client or server.  Once all the packets are processed, the results are weighed
 * according to the server/client ratio (@samp{--ratio}) and systems are assigned an
 * interface.  If tcpprep is unable to determine what role a system plays, tcpprep
 * will abort.
 * @item
 * @var{router}
 * Router mode works just like bridge mode, except that after weighing is done,
 * systems which are undetermined are considered a server if they fall inside a
 * network known to contain other servers.  Router has a greater chance of
 * successfully splitting clients and servers but is not 100% foolproof.
 * @item
 * @var{client}
 * Client mode works just like bridge mode, except that unclassified systems are
 * treated as clients.  Client mode should always complete successfully.
 * @item
 * @var{server}
 * Server mode works just like bridge mode, except that unclassified systems are
 * treated as servers.  Server mode should always complete successfully.
 * @item
 * @var{first}
 * First mode works by looking at the first time each IP is seen in the SRC and DST
 * fields in the IP header.  If the host is first seen in the SRC field, it is a
 * client and if it's first seen in the DST field, it is marked as a server.   This
 * effectively replicates the processing of the tomahawk test tool.  First
 * mode should always complete successfully.
 * @end table
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptAuto(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 113 */

    tcpprep->options->mode = AUTO_MODE;
    if (strcmp(OPT_ARG(AUTO), "bridge") == 0) {
        tcpprep->options->automode = BRIDGE_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "router") == 0) {
        tcpprep->options->automode = ROUTER_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "client") == 0) {
        tcpprep->options->automode = CLIENT_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "server") == 0) {
        tcpprep->options->automode = SERVER_MODE;
    }
    else if (strcmp(OPT_ARG(AUTO), "first") == 0) {
        tcpprep->options->automode = FIRST_MODE;
    }
    else {
        errx(-1, "Invalid auto mode type: %s", OPT_ARG(AUTO));
    }
    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the cidr option.
 * Specify a comma delimited list of CIDR netblocks to match against
 * the source IP of each packet.  Packets matching any of the CIDR's
 * are classified as servers.
 *
 * IPv4 Example:
 * @example
 * --cidr=192.168.0.0/16,172.16.0.0/12,10.0.0.0/8
 * @end example
 * IPv6 Example:
 * @example
 * --cidr=[::ffff:0:0/96],[fe80::/16]
 * @end example
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptCidr(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 185 */

    char *cidr = safe_strdup(OPT_ARG(CIDR));
    tcpprep->options->mode = CIDR_MODE;
    if (!parse_cidr(&tcpprep->options->cidrdata, cidr, ","))
        errx(-1, "Unable to parse CIDR map: %s", OPT_ARG(CIDR));
    free(cidr);

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the regex option.
 * Specify a regular expression to match against the source IP of each
 * packet.  Packets matching the regex are classified as servers.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptRegex(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 220 */

    int regex_error;
    char ebuf[EBUF_SIZE];

    tcpprep->options->mode = REGEX_MODE;
    if ((regex_error = regcomp(&tcpprep->options->preg, OPT_ARG(REGEX), 
        REG_EXTENDED|REG_NOSUB))) {
        regerror(regex_error, &tcpprep->options->preg, ebuf, EBUF_SIZE);
        errx(-1, "Unable to compile regex: %s", ebuf);
    }

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the port option.
 * Specifies that TCP and UDP traffic over IPv4 and IPv6 should be classified
 * as client or server based upon the destination port of the header.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptPort(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 248 */

    tcpprep->options->mode = PORT_MODE;

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the mac option.
 * Specify a list of MAC addresses to match against the source MAC
 * of each packet.  Packets matching one of the values are classified
 * as servers.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptMac(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 269 */

    tcpprep->options->mode = MAC_MODE;
    tcpprep->options->maclist = safe_strdup(OPT_ARG(MAC));
    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the comment option.
 * Specify a comment to be imbedded within the output cache file and later
 * viewed.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptComment(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 300 */

    /* our comment_len is only 16bit - myargs[] */
    if (strlen(OPT_ARG(COMMENT)) > ((1 << 16) - 1 - MYARGS_LEN))
                errx(-1, "Comment length %zu is longer then max allowed (%d)", 
                strlen(OPT_ARG(COMMENT)), (1 << 16) - 1 - MYARGS_LEN);

    /* save the comment */
    tcpprep->options->comment = (char *)safe_malloc(strlen(OPT_ARG(COMMENT)) + 1);
    strcpy(tcpprep->options->comment, OPT_ARG(COMMENT));

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the no-arg-comment option.
 * By default, tcpprep includes the arguments passed on the command line
 * in the cache file comment (in addition to any user specified --comment).
 * If for some reason you do not wish to include this, specify this option.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptNo_Arg_Comment(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 322 */

tcpprep->options->nocomment = 1;
    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the include option.
 * Override default of processing all packets stored in the capture file and only
 * send/edit packets which match the provided rule.  Rules can be one of:
 *
 * @table @bullet
 * @item S:<CIDR1>,...
 * - Source IP must match specified IPv4/v6 CIDR(s)
 * @item D:<CIDR1>,...
 * - Destination IP must match specified IPv4/v6 CIDR(s)
 * @item B:<CIDR1>,...
 * - Both source and destination IP must match specified IPv4/v6 CIDR(s)
 * @item E:<CIDR1>,...
 * - Either IP must match specified IPv4/v6 CIDR(s)
 * @item P:<LIST>
 * - Must be one of the listed packets where the list
 * corresponds to the packet number in the capture file.
 * @example
 * -x P:1-5,9,15,72-
 * @end example
 * would process packets 1 thru 5, the 9th and 15th packet, and packets 72 until the
 * end of the file
 * @item F:'<bpf>'
 * - BPF filter.  See the @file{tcpdump(8)} man page for syntax.
 * @end table
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptInclude(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 342 */

    char *include;

    include = safe_strdup(OPT_ARG(INCLUDE));
    tcpprep->options->xX.mode = xX_MODE_INCLUDE;

    if ((tcpprep->options->xX.mode = parse_xX_str(&tcpprep->options->xX, include, &tcpprep->options->bpf)) == xXError)
        errx(-1, "Unable to parse include/exclude rule: %s", OPT_ARG(INCLUDE));

    free(include);

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the exclude option.
 * Override default of processing all packets stored in the capture file and only
 * send/edit packets which do NOT match the provided rule.  Rules can be one of:
 *
 * @table @bullet
 * @item S:<CIDR1>,...
 * - Source IP must not match specified IPv4/v6 CIDR(s)
 * @item D:<CIDR1>,...
 * - Destination IP must not match specified IPv4/v6 CIDR(s)
 * @item B:<CIDR1>,...
 * - Both source and destination IP must not match specified IPv4/v6 CIDR(s)
 * @item E:<CIDR1>,...
 * - Either IP must not match specified IPv4/v6 CIDR(s)
 * @item P:<LIST>
 * - Must not be one of the listed packets where the list
 * corresponds to the packet number in the capture file.
 * @example
 * -x P:1-5,9,15,72-
 * @end example
 * would skip packets 1 thru 5, the 9th and 15th packet, and packets 72 until the
 * end of the file
 * @end table
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptExclude(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 389 */

    char *exclude;

    exclude = safe_strdup(OPT_ARG(EXCLUDE));
    tcpprep->options->xX.mode = xX_MODE_EXCLUDE;

    if ((tcpprep->options->xX.mode = parse_xX_str(&tcpprep->options->xX, exclude, &tcpprep->options->bpf)) == xXError)
        errx(-1, "Unable to parse include/exclude rule: %s", OPT_ARG(EXCLUDE));

    free(exclude);

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the services option.
 * Uses a list of ports used by servers in the same format as of /etc/services:
 * <service_name>        <port>/<protocol> # comment
 *
 * Example:
 * http            80/tcp
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptServices(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 486 */
    parse_services(OPT_ARG(SERVICES), &tcpprep->options->services);

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the nonip option.
 * By default, non-IP traffic which can not be classified as client
 * or server is classified as "client".  Specifiying @samp{--nonip}
 * will reclassify non-IP traffic as "server".  Note that the meaning
 * of this flag is reversed if @samp{--reverse} is used.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptNonip(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 497 */

    tcpprep->options->nonip = DIR_SERVER;

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the minmask option.
 * By default, auto modes use a minimum network mask length of 30 bits
 * to build networks containing clients and servers.  This allows you
 * to override this value.  Larger values will increase performance but
 * may provide inaccurate results.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptMinmask(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static struct {long rmin, rmax;} const rng[1] = {
        { 0, 32 } };
    int  ix;

    if (pOptions <= OPTPROC_EMIT_LIMIT)
        goto emit_ranges;
    optionNumericVal(pOptions, pOptDesc);

    for (ix = 0; ix < 1; ix++) {
        if (pOptDesc->optArg.argInt < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (pOptDesc->optArg.argInt == rng[ix].rmin)
            return;
        if (rng[ix].rmax == LONG_MIN)
            continue;
        if (pOptDesc->optArg.argInt <= rng[ix].rmax)
            return;
    }

    option_usage_fp = stderr;

 emit_ranges:
    optionShowRange(pOptions, pOptDesc, (void *)rng, 1);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the maxmask option.
 * By default, auto modes use a maximum network mask length of 8 bits
 * to build networks containing clients and servers.  This allows you
 * to override this value.  Larger values will decrease performance
 * and accuracy but will provide greater chance of success.
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptMaxmask(tOptions* pOptions, tOptDesc* pOptDesc)
{
    static struct {long rmin, rmax;} const rng[1] = {
        { 0, 32 } };
    int  ix;

    if (pOptions <= OPTPROC_EMIT_LIMIT)
        goto emit_ranges;
    optionNumericVal(pOptions, pOptDesc);

    for (ix = 0; ix < 1; ix++) {
        if (pOptDesc->optArg.argInt < rng[ix].rmin)
            continue;  /* ranges need not be ordered. */
        if (pOptDesc->optArg.argInt == rng[ix].rmin)
            return;
        if (rng[ix].rmax == LONG_MIN)
            continue;
        if (pOptDesc->optArg.argInt <= rng[ix].rmax)
            return;
    }

    option_usage_fp = stderr;

 emit_ranges:
    optionShowRange(pOptions, pOptDesc, (void *)rng, 1);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the version option.
 *
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptVersion(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 598 */

    fprintf(stderr, "tcpprep version: %s (build %s)", VERSION, git_version());
#ifdef DEBUG
    fprintf(stderr, " (debug)");
#endif
    fprintf(stderr, "\n");
    fprintf(stderr, "Copyright 2013-2016 by Fred Klassen <tcpreplay at appneta dot com> - AppNeta\n");
    fprintf(stderr, "Copyright 2000-2012 by Aaron Turner <aturner at synfin dot net>\n");
    fprintf(stderr, "The entire Tcpreplay Suite is licensed under the GPLv3\n");
    fprintf(stderr, "Cache file supported: %s\n", CACHEVERSION);
#ifdef HAVE_LIBDNET
    fprintf(stderr, "Compiled against libdnet: %s\n", LIBDNET_VERSION);
#else
    fprintf(stderr, "Not compiled with libdnet.\n");
#endif
#ifdef HAVE_WINPCAP
    fprintf(stderr, "Compiled against winpcap: %s\n", get_pcap_version());
#elif defined HAVE_PF_RING_PCAP
    fprintf(stderr, "Compiled against PF_RING libpcap: %s\n", get_pcap_version());
#else
    fprintf(stderr, "Compiled against libpcap: %s\n", get_pcap_version());
#endif
#ifdef ENABLE_64BITS
    fprintf(stderr, "64 bit packet counters: enabled\n");
#else
    fprintf(stderr, "64 bit packet counters: disabled\n");
#endif
#ifdef ENABLE_VERBOSE
    fprintf(stderr, "Verbose printing via tcpdump: enabled\n");
#else
    fprintf(stderr, "Verbose printing via tcpdump: disabled\n");
#endif
    exit(0);

    (void)pOptDesc;
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the less-help option.
 *
 * @param[in] pOptions the tcpprep options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptLess_Help(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from tcpprep_opts.def, line 642 */

    USAGE(EXIT_FAILURE);

    (void)pOptDesc;
    (void)pOptions;
}
/* extracted from optmain.tlib near line 1245 */

/**
 * The directory containing the data associated with tcpprep.
 */
#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

/**
 * Information about the person or institution that packaged tcpprep
 * for the current distribution.
 */
#ifndef  WITH_PACKAGER
# define tcpprep_packager_info NULL
#else
/** Packager information for tcpprep. */
static char const tcpprep_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport tcpprep bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif
#ifndef __doxygen__

#endif /* __doxygen__ */
/**
 * The option definitions for tcpprep.  The one structure that
 * binds them all.
 */
tOptions tcpprepOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_NO_ARGS
    + OPTPROC_GNUUSAGE ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      INDEX_OPT_SAVE_OPTS, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    29 /* full option count */, 25 /* user option count */,
    tcpprep_full_usage, tcpprep_short_usage,
    NULL, NULL,
    PKGDATADIR, tcpprep_packager_info
};

#if ENABLE_NLS
/**
 * This code is designed to translate translatable option text for the
 * tcpprep program.  These translations happen upon entry
 * to optionProcess().
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#ifdef HAVE_DCGETTEXT
# include <gettext.h>
#endif
#include <autoopts/usage-txt.h>

static char * AO_gettext(char const * pz);
static void   coerce_it(void ** s);

/**
 * AutoGen specific wrapper function for gettext.  It relies on the macro _()
 * to convert from English to the target language, then strdup-duplicates the
 * result string.  It tries the "libopts" domain first, then whatever has been
 * set via the \a textdomain(3) call.
 *
 * @param[in] pz the input text used as a lookup key.
 * @returns the translated text (if there is one),
 *   or the original text (if not).
 */
static char *
AO_gettext(char const * pz)
{
    char * res;
    if (pz == NULL)
        return NULL;
#ifdef HAVE_DCGETTEXT
    /*
     * While processing the option_xlateable_txt data, try to use the
     * "libopts" domain.  Once we switch to the option descriptor data,
     * do *not* use that domain.
     */
    if (option_xlateable_txt.field_ct != 0) {
        res = dgettext("libopts", pz);
        if (res == pz)
            res = (char *)(void *)_(pz);
    } else
        res = (char *)(void *)_(pz);
#else
    res = (char *)(void *)_(pz);
#endif
    if (res == pz)
        return res;
    res = strdup(res);
    if (res == NULL) {
        fputs(_("No memory for duping translated strings\n"), stderr);
        exit(TCPPREP_EXIT_FAILURE);
    }
    return res;
}

/**
 * All the pointers we use are marked "* const", but they are stored in
 * writable memory.  Coerce the mutability and set the pointer.
 */
static void coerce_it(void ** s) { *s = AO_gettext(*s);
}

/**
 * Translate all the translatable strings in the tcpprepOptions
 * structure defined above.  This is done only once.
 */
static void
translate_option_strings(void)
{
    tOptions * const opts = &tcpprepOptions;

    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_xlateable_txt.field_ct != 0) {
        /*
         *  Do the translations.  The first pointer follows the field count
         *  field.  The field count field is the size of a pointer.
         */
        char ** ppz = (char**)(void*)&(option_xlateable_txt);
        int     ix  = option_xlateable_txt.field_ct;

        do {
            ppz++; /* skip over field_ct */
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
        /* prevent re-translation and disable "libopts" domain lookup */
        option_xlateable_txt.field_ct = 0;

        coerce_it((void*)&(opts->pzCopyright));
        coerce_it((void*)&(opts->pzCopyNotice));
        coerce_it((void*)&(opts->pzFullVersion));
        coerce_it((void*)&(opts->pzUsageTitle));
        coerce_it((void*)&(opts->pzExplain));
        coerce_it((void*)&(opts->pzDetail));
        {
            tOptDesc * od = opts->pOptDesc;
            for (ix = opts->optCt; ix > 0; ix--, od++)
                coerce_it((void*)&(od->pzText));
        }
    }
}
#endif /* ENABLE_NLS */

#ifdef DO_NOT_COMPILE_THIS_CODE_IT_IS_FOR_GETTEXT
/** I18N function strictly for xgettext.  Do not compile. */
static void bogus_function(void) {
  /* TRANSLATORS:

     The following dummy function was crated solely so that xgettext can
     extract the correct strings.  These strings are actually referenced
     by a field name in the tcpprepOptions structure noted in the
     comments below.  The literal text is defined in tcpprep_opt_strs.
   
     NOTE: the strings below are segmented with respect to the source string
     tcpprep_opt_strs.  The strings above are handed off for translation
     at run time a paragraph at a time.  Consequently, they are presented here
     for translation a paragraph at a time.
   
     ALSO: often the description for an option will reference another option
     by name.  These are set off with apostrophe quotes (I hope).  Do not
     translate option names.
   */
  /* referenced via tcpprepOptions.pzCopyright */
  puts(_("tcpprep (tcpprep)\n\
Copyright (C) 2000-2016 Aaron Turner and Fred Klassen, all rights reserved.\n\
This is free software. It is licensed for use, modification and\n\
redistribution under the terms of the GNU General Public License,\n\
version 3 or later <http://gnu.org/licenses/gpl.html>\n"));

  /* referenced via tcpprepOptions.pzCopyNotice */
  puts(_("tcpprep is free software: you can redistribute it and/or modify it under\n\
the terms of the GNU General Public License as published by the Free\n\
Software Foundation, either version 3 of the License, or (at your option)\n\
any later version.\n\n"));
  puts(_("tcpprep is distributed in the hope that it will be useful, but WITHOUT ANY\n\
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n\
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more\n\
details.\n\n"));
  puts(_("You should have received a copy of the GNU General Public License along\n\
with this program.  If not, see <http://www.gnu.org/licenses/>.\n"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Enable debugging output"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Auto-split mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("CIDR-split mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Regex-split mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Port-split mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Source MAC split mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Matches to be client instead of server"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Embeded cache file comment"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Do not embed any cache file comment"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Include only packets matching rule"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Exclude any packet matching this rule"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Output cache file"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Input pcap file to process"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Print embedded comment in the specified cache file"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Print basic info from the specified cache file"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Print statistical information about the specified cache file"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Load services file for server ports"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Send non-IP traffic out server interface"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Ratio of client to server packets"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Minimum network mask length in auto mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Maximum network mask length in auto mode"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Print decoded packets via tcpdump to STDOUT"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Arguments passed to tcpdump decoder"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Print version information"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("Display less usage information and exit"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("display extended usage information and exit"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("extended usage information passed thru pager"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("save the option state to a config file"));

  /* referenced via tcpprepOptions.pOptDesc->pzText */
  puts(_("load options from a config file"));

  /* referenced via tcpprepOptions.pzUsageTitle */
  puts(_("tcpprep (tcpprep) - Create a tcpreplay cache cache file from a pcap file.\n\
Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]...\n"));

  /* referenced via tcpprepOptions.pzExplain */
  puts(_("tcpprep is a 'pcap(3)' file pre-processor which creates a cache file which\n\
provides \"rules\" for 'tcprewrite(1)' and 'tcpreplay(1)' on how to process\n\
and send packets.\n"));

  /* referenced via tcpprepOptions.pzDetail */
  puts(_("The basic operation of tcpreplay is to resend all packets from the input\n\
file(s) out a single file.  Tcpprep processes a pcap file and applies a set\n\
of user-specified rules to create a cache file which tells tcpreplay wether\n\
or not to send each packet and which interface the packet should be sent\n\
out of.\n\n"));
  puts(_("For more details, please see the Tcpreplay Manual at:\n\
http://tcpreplay.appneta.com\n"));

  /* referenced via tcpprepOptions.pzFullUsage */
  puts(_("<<<NOT-FOUND>>>"));

  /* referenced via tcpprepOptions.pzShortUsage */
  puts(_("<<<NOT-FOUND>>>"));
  /* LIBOPTS-MESSAGES: */
#line 67 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 93 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 53 "../init.c"
  puts(_("AutoOpts function called without option descriptor\n"));
#line 90 "../init.c"
  puts(_("\tThis exceeds the compiled library version:  "));
#line 88 "../init.c"
  puts(_("Automated Options Processing Error!\n"
       "\t%s called AutoOpts function with structure version %d:%d:%d.\n"));
#line 80 "../autoopts.c"
  puts(_("realloc of %d bytes at 0x%p failed\n"));
#line 92 "../init.c"
  puts(_("\tThis is less than the minimum library version:  "));
#line 121 "../version.c"
  puts(_("Automated Options version %s\n"
       "\tCopyright (C) 1999-2014 by Bruce Korb - all rights reserved\n"));
#line 82 "../makeshell.c"
  puts(_("(AutoOpts bug):  %s.\n"));
#line 90 "../reset.c"
  puts(_("optionResetOpt() called, but reset-option not configured"));
#line 292 "../usage.c"
  puts(_("could not locate the 'help' option"));
#line 336 "../autoopts.c"
  puts(_("optionProcess() was called with invalid data"));
#line 748 "../usage.c"
  puts(_("invalid argument type specified"));
#line 598 "../find.c"
  puts(_("defaulted to option with optional arg"));
#line 76 "../alias.c"
  puts(_("aliasing option is out of range."));
#line 234 "../enum.c"
  puts(_("%s error:  the keyword '%s' is ambiguous for %s\n"));
#line 108 "../find.c"
  puts(_("  The following options match:\n"));
#line 293 "../find.c"
  puts(_("%s: ambiguous option name: %s (matches %d options)\n"));
#line 161 "../check.c"
  puts(_("%s: Command line arguments required\n"));
#line 43 "../alias.c"
  puts(_("%d %s%s options allowed\n"));
#line 89 "../makeshell.c"
  puts(_("%s error %d (%s) calling %s for '%s'\n"));
#line 301 "../makeshell.c"
  puts(_("interprocess pipe"));
#line 168 "../version.c"
  puts(_("error: version option argument '%c' invalid.  Use:\n"
       "\t'v' - version only\n"
       "\t'c' - version and copyright\n"
       "\t'n' - version and full copyright notice\n"));
#line 58 "../check.c"
  puts(_("%s error:  the '%s' and '%s' options conflict\n"));
#line 217 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 430 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 38 "../alias.c"
  puts(_("-equivalence"));
#line 469 "../find.c"
  puts(_("%s: illegal option -- %c\n"));
#line 110 "../reset.c"
  puts(_("%s: illegal option -- %c\n"));
#line 271 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 755 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 118 "../reset.c"
  puts(_("%s: illegal option -- %s\n"));
#line 335 "../find.c"
  puts(_("%s: unknown vendor extension option -- %s\n"));
#line 159 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 169 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 747 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 1081 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 385 "../find.c"
  puts(_("%s: invalid option name: %s\n"));
#line 527 "../find.c"
  puts(_("%s: The '%s' option requires an argument.\n"));
#line 156 "../autoopts.c"
  puts(_("(AutoOpts bug):  Equivalenced option '%s' was equivalenced to both\n"
       "\t'%s' and '%s'."));
#line 94 "../check.c"
  puts(_("%s error:  The %s option is required\n"));
#line 632 "../find.c"
  puts(_("%s: The '%s' option cannot have an argument.\n"));
#line 151 "../check.c"
  puts(_("%s: Command line arguments are not allowed.\n"));
#line 535 "../save.c"
  puts(_("error %d (%s) creating %s\n"));
#line 234 "../enum.c"
  puts(_("%s error:  '%s' does not match any %s keywords.\n"));
#line 93 "../reset.c"
  puts(_("%s error: The '%s' option requires an argument.\n"));
#line 184 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 238 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 143 "../restore.c"
  puts(_("%s error: no saved option state\n"));
#line 231 "../autoopts.c"
  puts(_("'%s' is not a command line option.\n"));
#line 111 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable date/time.\n"));
#line 132 "../save.c"
  puts(_("'%s' not defined\n"));
#line 50 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable time duration.\n"));
#line 92 "../check.c"
  puts(_("%s error:  The %s option must appear %d times.\n"));
#line 164 "../numeric.c"
  puts(_("%s error:  '%s' is not a recognizable number.\n"));
#line 200 "../enum.c"
  puts(_("%s error:  %s exceeds %s keyword count\n"));
#line 330 "../usage.c"
  puts(_("Try '%s %s' for more information.\n"));
#line 45 "../alias.c"
  puts(_("one %s%s option allowed\n"));
#line 203 "../makeshell.c"
  puts(_("standard output"));
#line 938 "../makeshell.c"
  puts(_("standard output"));
#line 274 "../usage.c"
  puts(_("standard output"));
#line 415 "../usage.c"
  puts(_("standard output"));
#line 625 "../usage.c"
  puts(_("standard output"));
#line 175 "../version.c"
  puts(_("standard output"));
#line 274 "../usage.c"
  puts(_("standard error"));
#line 415 "../usage.c"
  puts(_("standard error"));
#line 625 "../usage.c"
  puts(_("standard error"));
#line 175 "../version.c"
  puts(_("standard error"));
#line 203 "../makeshell.c"
  puts(_("write"));
#line 938 "../makeshell.c"
  puts(_("write"));
#line 273 "../usage.c"
  puts(_("write"));
#line 414 "../usage.c"
  puts(_("write"));
#line 624 "../usage.c"
  puts(_("write"));
#line 174 "../version.c"
  puts(_("write"));
#line 60 "../numeric.c"
  puts(_("%s error:  %s option value %ld is out of range.\n"));
#line 44 "../check.c"
  puts(_("%s error:  %s option requires the %s option\n"));
#line 131 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 183 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 237 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 256 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 534 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
  /* END-LIBOPTS-MESSAGES */

  /* USAGE-TEXT: */
#line 873 "../usage.c"
  puts(_("\t\t\t\t- an alternate for '%s'\n"));
#line 1148 "../usage.c"
  puts(_("Version, usage and configuration options:"));
#line 924 "../usage.c"
  puts(_("\t\t\t\t- default option for unnamed options\n"));
#line 837 "../usage.c"
  puts(_("\t\t\t\t- disabled as '--%s'\n"));
#line 1117 "../usage.c"
  puts(_(" --- %-14s %s\n"));
#line 1115 "../usage.c"
  puts(_("This option has been disabled"));
#line 864 "../usage.c"
  puts(_("\t\t\t\t- enabled by default\n"));
#line 40 "../alias.c"
  puts(_("%s error:  only "));
#line 1194 "../usage.c"
  puts(_(" - examining environment variables named %s_*\n"));
#line 168 "../file.c"
  puts(_("\t\t\t\t- file must not pre-exist\n"));
#line 172 "../file.c"
  puts(_("\t\t\t\t- file must pre-exist\n"));
#line 380 "../usage.c"
  puts(_("Options are specified by doubled hyphens and their name or by a single\n"
       "hyphen and the flag character.\n"));
#line 916 "../makeshell.c"
  puts(_("\n"
       "= = = = = = = =\n\n"
       "This incarnation of genshell will produce\n"
       "a shell script to parse the options for %s:\n\n"));
#line 166 "../enum.c"
  puts(_("  or an integer mask with any of the lower %d bits set\n"));
#line 897 "../usage.c"
  puts(_("\t\t\t\t- is a set membership option\n"));
#line 918 "../usage.c"
  puts(_("\t\t\t\t- must appear between %d and %d times\n"));
#line 382 "../usage.c"
  puts(_("Options are specified by single or double hyphens and their name.\n"));
#line 904 "../usage.c"
  puts(_("\t\t\t\t- may appear multiple times\n"));
#line 891 "../usage.c"
  puts(_("\t\t\t\t- may not be preset\n"));
#line 1309 "../usage.c"
  puts(_("   Arg Option-Name    Description\n"));
#line 1245 "../usage.c"
  puts(_("  Flg Arg Option-Name    Description\n"));
#line 1303 "../usage.c"
  puts(_("  Flg Arg Option-Name    Description\n"));
#line 1304 "../usage.c"
  puts(_(" %3s %s"));
#line 1310 "../usage.c"
  puts(_(" %3s %s"));
#line 387 "../usage.c"
  puts(_("The '-#<number>' option may omit the hash char\n"));
#line 383 "../usage.c"
  puts(_("All arguments are named options.\n"));
#line 971 "../usage.c"
  puts(_(" - reading file %s"));
#line 409 "../usage.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 100 "../version.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 129 "../version.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 903 "../usage.c"
  puts(_("\t\t\t\t- may NOT appear - preset only\n"));
#line 944 "../usage.c"
  puts(_("\n"
       "The following option preset mechanisms are supported:\n"));
#line 1192 "../usage.c"
  puts(_("\n"
       "The following option preset mechanisms are supported:\n"));
#line 682 "../usage.c"
  puts(_("prohibits these options:\n"));
#line 677 "../usage.c"
  puts(_("prohibits the option '%s'\n"));
#line 81 "../numeric.c"
  puts(_("%s%ld to %ld"));
#line 79 "../numeric.c"
  puts(_("%sgreater than or equal to %ld"));
#line 75 "../numeric.c"
  puts(_("%s%ld exactly"));
#line 68 "../numeric.c"
  puts(_("%sit must lie in one of the ranges:\n"));
#line 68 "../numeric.c"
  puts(_("%sit must be in the range:\n"));
#line 88 "../numeric.c"
  puts(_(", or\n"));
#line 66 "../numeric.c"
  puts(_("%sis scalable with a suffix: k/K/m/M/g/G/t/T\n"));
#line 77 "../numeric.c"
  puts(_("%sless than or equal to %ld"));
#line 390 "../usage.c"
  puts(_("Operands and options may be intermixed.  They will be reordered.\n"));
#line 652 "../usage.c"
  puts(_("requires the option '%s'\n"));
#line 655 "../usage.c"
  puts(_("requires these options:\n"));
#line 1321 "../usage.c"
  puts(_("   Arg Option-Name   Req?  Description\n"));
#line 1315 "../usage.c"
  puts(_("  Flg Arg Option-Name   Req?  Description\n"));
#line 167 "../enum.c"
  puts(_("or you may use a numeric representation.  Preceding these with a '!'\n"
       "will clear the bits, specifying 'none' will clear all bits, and 'all'\n"
       "will set them all.  Multiple entries may be passed as an option\n"
       "argument list.\n"));
#line 910 "../usage.c"
  puts(_("\t\t\t\t- may appear up to %d times\n"));
#line 77 "../enum.c"
  puts(_("The valid \"%s\" option keywords are:\n"));
#line 1152 "../usage.c"
  puts(_("The next option supports vendor supported extra options:"));
#line 773 "../usage.c"
  puts(_("These additional options are:"));
  /* END-USAGE-TEXT */
}
#endif /* uncompilable code */
#ifdef  __cplusplus
}
#endif
/* tcpprep_opts.c ends here */
