"use strict";

var Cylon = require("cylon");

Cylon.robot({
  connections: {
    arduino: { adaptor: "firmata", port: "/dev/ttyACM0" }
  },

  devices: {
    sensor: {
      driver: "ir-range-sensor",
      pin: 0,
      upperLimit: 400,
      lowerLimit: 100,
      model: "gp2y0a41sk0f"
    }
  },

  work: function(my) {
    var highest,
    lowest;

    my.sensor.on("analogRead", function(val) {
      console.log("Analor Read Value ===>", val);
      if (highest === undefined) {
        highest = val;
      }

      if (lowest === undefined) {
        lowest = val;
      }

      highest = (val > highest) ? val : highest;
      lowest = (val < lowest) ? val : lowest;

      console.log("Highest IR Range Value read: ", highest);
      console.log("Lowest IR Range Value read: ", lowest);

      console.log("Range in CM =>", my.sensor.rangeCm());
      console.log("Range in Inches =>", my.sensor.range());
    });

    my.sensor.on("upperLimit", function(val) {
      console.log("Upper limit reached ===> " + val);
    });

    my.sensor.on("lowerLimit", function(val) {
      console.log("Lower limit reached ===> " + val);
    });
  }

}).start();
