local utl = require "luci.util"
local sys = require "luci.sys"
local fs  = require "nixio.fs"
local ip  = require "luci.ip"
local nw  = require "luci.model.network"

local s, m
m = Map("hninpop", translate("hninpop"))

s = m:section(TypedSection, "default")
s.anonymous = true
s.addremove = false
s:tab("update", translate("软件更新"))

-- 版本号比较函数
local function version_compare(v1, v2)
    local function split_version(version)
        local t = {}
        for num in version:gmatch("([^.]+)") do
            table.insert(t, tonumber(num))
        end
        return t
    end

    local v1_parts = split_version(v1)
    local v2_parts = split_version(v2)
    local length = math.max(#v1_parts, #v2_parts)

    for i = 1, length do
        local num1 = v1_parts[i] or 0
        local num2 = v2_parts[i] or 0

        if num1 > num2 then
            return true  -- v1 is greater
        elseif num1 < num2 then
            return false  -- v2 is greater
        end
    end

    return false  -- versions are equal
end

-- 执行命令并返回输出
local function exec_command(command)
    local handle = io.popen(command)
    local result = handle:read("*a")
    handle:close()
    return result:gsub("\n", ""):gsub("-", ".")
end

-- 获取当前版本号
local version = exec_command("opkg list-installed | grep luci-app-hninpop | awk '{print $3}'")
if version == "" then
    version = "1-0.0"
end

local update_check = s:taboption("update", Button, "_update_check", translate("检查更新"))
update_check.inputtitle = translate("检查更新")
update_check.inputstyle = "apply"

function update_check.write(self, section)
    luci.sys.exec("opkg update")
    luci.http.redirect(luci.dispatcher.build_url("admin", "hninpop", "update"))
end

local current_version = s:taboption("update", DummyValue, "_version", translate("当前版本"))
current_version.default = version
current_version.rawhtml = true

-- 获取新版本号
local new_version = exec_command("opkg list | grep hninpop | awk '{print $3}'")

if new_version ~= "" then
    local new_version_display = s:taboption("update", DummyValue, "_new_version", translate("最新版本"))
    new_version_display.default = new_version
    new_version_display.rawhtml = true

    if version_compare(new_version, version) then
        local update_button = s:taboption("update", Button, "_update", translate("更新"), translate("更新后需重启设备"))
        update_button.inputtitle = translate("更新")
        update_button.inputstyle = "apply"
        
        function update_button.write(self, section)
            sys.exec("opkg install luci-app-hninpop")
            luci.http.redirect(luci.dispatcher.build_url("admin", "system", "reboot"))
        end
    end

    local update_log = exec_command("opkg list luci-app-hninpop | awk '{ for (i=5; i<=NF; i++) printf $i \" \" }'")
    local update_log_display = s:taboption("update", DummyValue, "_update_log", translate("更新日志"))
    update_log_display.default = update_log
    update_log_display.rawhtml = true
end

return m
