#ifndef CTCS_H
#define CTCS_H

#include "def.h"
#include <sys/types.h>

#ifdef WINDOWS
#include <Winsock2.h>
#else
#include <unistd.h>
#include <netdb.h>   // Solaris defines MAXHOSTNAMELEN here.
#include <stdio.h>   // autoconf manual: Darwin + others prereq for stdlib.h
#include <stdlib.h>  // autoconf manual: Darwin prereq for sys/socket.h
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/param.h>
#endif

#include <inttypes.h>
#include <time.h>

#include "bttypes.h"
#include "bufio.h"
#include "tracker.h"

#define CTCS_BUFSIZE (200+MAXPATHLEN)
#define CTCS_PASS_SIZE 21

struct ctstatus {
  dt_rate_t dlrate, ulrate, dlimit, ulimit;

  ctstatus(){
    dlrate=ulrate=dlimit=ulimit = 0;
  }
};

class Ctcs
{
 private:
  char m_host[MAXHOSTNAMELEN];
  int m_port;
  char m_pass[CTCS_PASS_SIZE];
  int m_protocol;

  struct sockaddr_in m_sin;

  dt_trackerstatus_t m_status;

  time_t m_interval;
  time_t m_last_timestamp;
  time_t m_sent_ctstatus_time;
  time_t m_statustime;

  SOCKET m_sock;
  BufIo in_buffer;
  BufIo out_buffer;
  struct ctstatus m_ctstatus;
  int m_sent_ctstatus;
  int m_sent_ctbw;

  int _s2sin(const char *h, int p, struct sockaddr_in *psin);
  int SendMessage(const char *buf);
  char *ConfigMsg(const char *name, const char *type, const char *range,
    const char *value, const char *short_desc, const char *long_desc);

  friend void CfgCTCS(Config<const char *> *config);

 public:
  Ctcs();
  ~Ctcs();

  void Reset(time_t new_interval);
  int Connect();
  int CheckMessage();
  int Send_Protocol();
  int Send_Auth();
  int Send_Torrent(const unsigned char *peerid, const char *torrent);
  int Report_Status();
  int Send_Status();
  int Send_bw();
  int Send_Config();
  int Set_Config(const char *msgbuf);
  int Send_Detail();
  int Send_Peers();
  int Send_Info(int sev, const char *info);
  int IntervalCheck(fd_set *rfdp, fd_set *wfdp);
  int SocketReady(fd_set *rfdp, fd_set *wfdp, int *nfds,
    fd_set *rfdnextp, fd_set *wfdnextp);

  SOCKET GetSocket() const { return m_sock; }
  unsigned char GetStatus() const { return m_status; }
};

extern Ctcs CTCS;

#endif  // CTCS_H

