#ifndef _DRV_TAPI_VXWORKS_H
#define _DRV_TAPI_VXWORKS_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_tapi_vxworks.h
   This file contains the declarations of the vxworks specific driver functions.
*/

/* ============================= */
/* Global Includes               */
/* ============================= */

/* VxWorks Includes*/

#include <vxworks.h>

#include <drv/intrCtl/ppc860Intr.h>
/*#include <drv/multi/ppc860Siu.h>
#include <drv/multi/ppc860Cpm.h>
#include <drv/sio/ppc860Sio.h>*/
#include <drv/timer/timerDev.h>

#include <selectLib.h>
/*#include <arch/ppc/ivPpc.h>*/
#include <iosLib.h>
#include <stdio.h>
#include <time.h>
#include <taskLib.h>
#include <cacheLib.h>
#include <logLib.h>
#include <intLib.h>
#include <string.h>
#include <sys/ioctl.h>
/* include message queues support of vxworks. */
#include <msgQLib.h>

/* functions macros */

#ifndef GetImmr
   #define GetImmr()                         vxImmrGet()
#endif
#define IMAP_ADDR                            vxImmrGet()


/* ============================= */
/* Macros & Definitions          */
/* ============================= */
/** Definitions for select queues. */
/** Returned by select() to indicate that the fd is ready to writing. */
#define  TAPI_OS_SYSWRITE  0x00000002
/** Returned by select() to indicate that the fd is ready for reading. */
#define  TAPI_OS_SYSREAD   0x00000001

/** Determine if the current state is in interrupt or task context. */
#define TAPI_OS_IN_INTERRUPT() \
   ((intContext() == TRUE) ? IFX_TRUE : IFX_FALSE)

/** Returns the magic number of IOCTL command.
\param iocmd - ioctl command of which magic number is decoded */
#define IFXOX_IO_GETMAGIC(iocmd) \
          (((iocmd) >> 8) & 0xFF)

#ifndef TAPI_OS_ThreadPriorityModify
   #define TAPI_OS_ThreadPriorityModify(prio) \
         taskPrioritySet(taskIdSelf(), prio)
#endif /* TAPI_OS_ThreadPriorityModify */

#define TAPI_OS_ThreadKill(pThrCntrl)

/** lock/take the mutex but be interruptable by signals.
    Difference to IFXOS_MutexLock is that the sleep is also interrupted when
    a signal is received by the sleeping thread.
    This concept is not available on VxWorks. So the normal get() is used.
\param mutex - mutex handle
*/
#define TAPI_OS_LOCK_GET_INTERRUPTIBLE    TAPI_OS_LockGet


/* ============================= */
/* Global Structures             */
/* ============================= */

/* ============================= */
/* Global function declaration   */
/* ============================= */

/*IMPORT IFX_uint32_t vxImmrGet(void);*/


#endif /* _DRV_TAPI_VXWORKS_H */
