#ifndef _DRV_VMMC_INIT_H
#define _DRV_VMMC_INIT_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************
   Module      : drv_vmmc_init.h
*******************************************************************************/

/* ============================= */
/* Includes                      */
/* ============================= */
#include "drv_vmmc_api.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* Global Types                  */
/* ============================= */

/* ============================= */
/* Global variable declaration   */
/* ============================= */
extern const IFX_char_t DRV_VMMC_WHATVERSION[];
#ifdef HAVE_CONFIG_H
extern const IFX_char_t DRV_VMMC_WHICHCONFIG[];
#endif /* HAVE_CONFIG_H */

/* ============================= */
/* Global function declaration   */
/* ============================= */

extern IFX_int32_t   VMMC_ChipAccessInit (VMMC_DEVICE *pDev);

extern IFX_uint32_t  TAPI_LL_Phone_Get_Capabilities (IFX_TAPI_LL_DEV_t *pLLDev);
extern IFX_return_t  TAPI_LL_Phone_Get_Capability_List (IFX_TAPI_LL_DEV_t *pLLDev,
                                                        IFX_TAPI_CAP_t *pCapList);
extern IFX_int32_t   TAPI_LL_Phone_Check_Capability (IFX_TAPI_LL_DEV_t *pLLDev,
                                                     IFX_TAPI_CAP_t *pCapList);
extern IFX_int32_t   VMMC_AddCaps (VMMC_DEVICE *pDev);

extern IFX_int32_t   VMMC_GetDevice (IFX_uint16_t nr, VMMC_DEVICE** pDev);

extern IFX_return_t  VMMC_Get_FwCap (VMMC_DEVICE *pDev);
extern IFX_int32_t   VMMC_DeviceDriverStart(IFX_void_t);
extern IFX_void_t    VMMC_DeviceDriverStop(IFX_void_t);

#endif /* _DRV_VMMC_INIT_H */
