/* attention, this file was automatically generated by swig and Perl scripts*/
/** \file
   DSL CPE CLI, autogen access CLI functions implementation
*/

#include "dsl_cpe_control.h"
#include "drv_dsl_cpe_api_ioctl.h"
#include "drv_dsl_cpe_api.h"

#ifdef INCLUDE_DSL_CPE_CLI_SUPPORT

/** \addtogroup DSL_CPE_CLI
 @{ */

#undef DSL_CCA_DBG_BLOCK
#define DSL_CCA_DBG_BLOCK DSL_CCA_DBG_CLI

extern const char *sFailureReturn;

#ifdef DSL_CLI_LOCAL
#undef DSL_CLI_LOCAL
#endif
#define DSL_CLI_LOCAL static


static const DSL_char_t g_sAcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AutobootCtrlSet_t nCommand" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_CTRL_STOP = 0" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_CTRL_START = 1" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_CTRL_RESTART = 2" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_CTRL_CONTINUE = 3" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_AUTOBOOT_CONTROL_SET

   Long Form: AutobootControlSet

   Short Form: acs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AutobootCtrlSet_t nCommand


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_AutobootControlSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_AutobootControl_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nCommand);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_AUTOBOOT_CONTROL_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sAsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AutobootStatGet_t nStatus" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_STOPPED = 0" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_STARTING = 1" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_RUNNING = 2" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_FW_WAIT = 3" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_CONFIG_WRITE_WAIT = 4" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_LINK_ACTIVATE_WAIT = 5" DSL_CPE_CRLF
   "   DSL_AUTOBOOT_STATUS_RESTART_WAIT = 6" DSL_CPE_CRLF
   "- DSL_FirmwareRequestType_t nFirmwareRequestType" DSL_CPE_CRLF
   "   DSL_FW_REQUEST_NA = 0" DSL_CPE_CRLF
   "   DSL_FW_REQUEST_ADSL = 1" DSL_CPE_CRLF
   "   DSL_FW_REQUEST_VDSL = 2" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_AUTOBOOT_STATUS_GET

   Long Form: AutobootStatusGet

   Short Form: asg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AutobootStatGet_t nStatus

   \ref DSL_FirmwareRequestType_t nFirmwareRequestType


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_AutobootStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_AutobootStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_AUTOBOOT_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nStatus=%d nFirmwareRequestType=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nStatus, pData.data.nFirmwareRequestType);
   }

   return 0;
}


static const DSL_char_t g_sLsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_LineStateValue_t nLineState (hex)" DSL_CPE_CRLF
   "   DSL_LINESTATE_NOT_INITIALIZED = 0x00000000" DSL_CPE_CRLF
   "   DSL_LINESTATE_EXCEPTION = 0x00000001" DSL_CPE_CRLF
   "   DSL_LINESTATE_NOT_UPDATED = 0x00000010" DSL_CPE_CRLF
   "   DSL_LINESTATE_IDLE_REQUEST = 0x000000FF" DSL_CPE_CRLF
   "   DSL_LINESTATE_IDLE = 0x00000100" DSL_CPE_CRLF
   "   DSL_LINESTATE_SILENT_REQUEST = 0x000001FF" DSL_CPE_CRLF
   "   DSL_LINESTATE_SILENT = 0x00000200" DSL_CPE_CRLF
   "   DSL_LINESTATE_HANDSHAKE = 0x00000300" DSL_CPE_CRLF
   "   DSL_LINESTATE_BONDING_CLR = 0x00000310" DSL_CPE_CRLF
   "   DSL_LINESTATE_FULL_INIT = 0x00000380" DSL_CPE_CRLF
   "   DSL_LINESTATE_SHORT_INIT_ENTRY = 0x000003C0" DSL_CPE_CRLF
   "   DSL_LINESTATE_DISCOVERY = 0x00000400" DSL_CPE_CRLF
   "   DSL_LINESTATE_TRAINING = 0x00000500" DSL_CPE_CRLF
   "   DSL_LINESTATE_ANALYSIS = 0x00000600" DSL_CPE_CRLF
   "   DSL_LINESTATE_EXCHANGE = 0x00000700" DSL_CPE_CRLF
   "   DSL_LINESTATE_SHOWTIME_NO_SYNC = 0x00000800" DSL_CPE_CRLF
   "   DSL_LINESTATE_SHOWTIME_TC_SYNC = 0x00000801" DSL_CPE_CRLF
   "   DSL_LINESTATE_FASTRETRAIN = 0x00000900" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOWPOWER_L2 = 0x00000A00" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOOPDIAGNOSTIC_ACTIVE = 0x00000B00" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOOPDIAGNOSTIC_DATA_EXCHANGE = 0x00000B10" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOOPDIAGNOSTIC_DATA_REQUEST = 0x00000B20" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOOPDIAGNOSTIC_COMPLETE = 0x00000C00" DSL_CPE_CRLF
   "   DSL_LINESTATE_RESYNC = 0x00000D00" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST = 0x01000000" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST_LOOP = 0x01000001" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST_REVERB = 0x01000010" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST_MEDLEY = 0x01000020" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST_SHOWTIME_LOCK = 0x01000030" DSL_CPE_CRLF
   "   DSL_LINESTATE_TEST_QUIET = 0x01000040" DSL_CPE_CRLF
   "   DSL_LINESTATE_LOWPOWER_L3 = 0x02000000" DSL_CPE_CRLF
   "   DSL_LINESTATE_UNKNOWN = 0x03000000" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_STATE_GET

   Long Form: LineStateGet

   Short Form: lsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_LineStateValue_t nLineState (hex)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineStateGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineState_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_STATE_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nLineState=0x%x" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nLineState);
   }

   return 0;
}


static const DSL_char_t g_sLfcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bTrellisEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bBitswapEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bReTxEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bVirtualNoiseSupport" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_FEATURE_CONFIG_SET

   Long Form: LineFeatureConfigSet

   Short Form: lfcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_boolean_t bTrellisEnable

   \ref DSL_boolean_t bBitswapEnable

   \ref DSL_boolean_t bReTxEnable

   \ref DSL_boolean_t bVirtualNoiseSupport


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineFeatureConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineFeature_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 5, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d %d %d %d", &pData.nDirection, &pData.data.bTrellisEnable, &pData.data.bBitswapEnable, &pData.data.bReTxEnable, &pData.data.bVirtualNoiseSupport);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_FEATURE_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}

#if defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sLfcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bTrellisEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bBitswapEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bReTxEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bVirtualNoiseSupport" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_FEATURE_CONFIG_GET

   Long Form: LineFeatureConfigGet

   Short Form: lfcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_boolean_t bTrellisEnable

   \ref DSL_boolean_t bBitswapEnable

   \ref DSL_boolean_t bReTxEnable

   \ref DSL_boolean_t bVirtualNoiseSupport


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineFeatureConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineFeature_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_FEATURE_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d bTrellisEnable=%d bBitswapEnable=%d bReTxEnable=%d bVirtualNoiseSupport=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.bTrellisEnable, pData.data.bBitswapEnable, pData.data.bReTxEnable, pData.data.bVirtualNoiseSupport);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sLfsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bTrellisEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bBitswapEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bReTxEnable" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bVirtualNoiseSupport" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_FEATURE_STATUS_GET

   Long Form: LineFeatureStatusGet

   Short Form: lfsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_boolean_t bTrellisEnable

   \ref DSL_boolean_t bBitswapEnable

   \ref DSL_boolean_t bReTxEnable

   \ref DSL_boolean_t bVirtualNoiseSupport


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineFeatureStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineFeature_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_FEATURE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d bTrellisEnable=%d bBitswapEnable=%d bReTxEnable=%d bVirtualNoiseSupport=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.bTrellisEnable, pData.data.bBitswapEnable, pData.data.bReTxEnable, pData.data.bVirtualNoiseSupport);
   }

   return 0;
}

#if defined(INCLUDE_DSL_FRAMING_PARAMETERS)

static const DSL_char_t g_sFpsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint16_t nTp" DSL_CPE_CRLF
   "- DSL_uint16_t nMp" DSL_CPE_CRLF
   "- DSL_uint16_t nSEQ" DSL_CPE_CRLF
   "- DSL_uint16_t nBP" DSL_CPE_CRLF
   "- DSL_uint16_t nMSGC" DSL_CPE_CRLF
   "- DSL_uint16_t nMSGLP" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_FRAMING_PARAMETER_STATUS_GET

   Long Form: FramingParameterStatusGet

   Short Form: fpsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint16_t nTp

   \ref DSL_uint16_t nMp

   \ref DSL_uint16_t nSEQ

   \ref DSL_uint16_t nBP

   \ref DSL_uint16_t nMSGC

   \ref DSL_uint16_t nMSGLP


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_FramingParameterStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_FramingParameterStatus_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_FRAMING_PARAMETER_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nTp=%hu nMp=%hu nSEQ=%hu nBP=%hu nMSGC=%hu nMSGLP=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nTp, pData.data.nMp, pData.data.nSEQ, pData.data.nBP, pData.data.nMSGC, pData.data.nMSGLP);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_FRAMING_PARAMETERS) */

#if !defined(DSL_CPE_DEBUG_DISABLE)

static const DSL_char_t g_sDmls[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_debugModules_t nDbgModule" DSL_CPE_CRLF
   "   DSL_DBG_NO_BLOCK = 0" DSL_CPE_CRLF
   "   DSL_DBG_CPE_API = 1" DSL_CPE_CRLF
   "   DSL_DBG_G997 = 2" DSL_CPE_CRLF
   "   DSL_DBG_PM = 3" DSL_CPE_CRLF
   "   DSL_DBG_MIB = 4" DSL_CPE_CRLF
   "   DSL_DBG_CEOC = 5" DSL_CPE_CRLF
   "   DSL_DBG_LED = 6" DSL_CPE_CRLF
   "   DSL_DBG_SAR = 7" DSL_CPE_CRLF
   "   DSL_DBG_DEVICE = 8" DSL_CPE_CRLF
   "   DSL_DBG_AUTOBOOT_THREAD = 9" DSL_CPE_CRLF
   "   DSL_DBG_OS = 10" DSL_CPE_CRLF
   "   DSL_DBG_CALLBACK = 11" DSL_CPE_CRLF
   "   DSL_DBG_MESSAGE_DUMP = 12" DSL_CPE_CRLF
   "   DSL_DBG_LOW_LEVEL_DRIVER = 13" DSL_CPE_CRLF
   "- DSL_debugLevels_t nDbgLevel" DSL_CPE_CRLF
   "   DSL_DBG_NONE = 0x00" DSL_CPE_CRLF
   "   DSL_DBG_PRN = 0x01" DSL_CPE_CRLF
   "   DSL_DBG_ERR = 0x02" DSL_CPE_CRLF
   "   DSL_DBG_WRN = 0x40" DSL_CPE_CRLF
   "   DSL_DBG_MSG = 0x80" DSL_CPE_CRLF
   "   DSL_DBG_LOCAL = 0xFF" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_DBG_MODULE_LEVEL_SET

   Long Form: DbgModuleLevelSet

   Short Form: dmls

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_debugModules_t nDbgModule

   \ref DSL_debugLevels_t nDbgLevel


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_DBG_ModuleLevelSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_DBG_ModuleLevel_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.data.nDbgModule, &pData.data.nDbgLevel);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_DBG_MODULE_LEVEL_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sDmlg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_debugModules_t nDbgModule" DSL_CPE_CRLF
   "   DSL_DBG_NO_BLOCK = 0" DSL_CPE_CRLF
   "   DSL_DBG_CPE_API = 1" DSL_CPE_CRLF
   "   DSL_DBG_G997 = 2" DSL_CPE_CRLF
   "   DSL_DBG_PM = 3" DSL_CPE_CRLF
   "   DSL_DBG_MIB = 4" DSL_CPE_CRLF
   "   DSL_DBG_CEOC = 5" DSL_CPE_CRLF
   "   DSL_DBG_LED = 6" DSL_CPE_CRLF
   "   DSL_DBG_SAR = 7" DSL_CPE_CRLF
   "   DSL_DBG_DEVICE = 8" DSL_CPE_CRLF
   "   DSL_DBG_AUTOBOOT_THREAD = 9" DSL_CPE_CRLF
   "   DSL_DBG_OS = 10" DSL_CPE_CRLF
   "   DSL_DBG_CALLBACK = 11" DSL_CPE_CRLF
   "   DSL_DBG_MESSAGE_DUMP = 12" DSL_CPE_CRLF
   "   DSL_DBG_LOW_LEVEL_DRIVER = 13" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_debugLevels_t nDbgLevel" DSL_CPE_CRLF
   "   DSL_DBG_NONE = 0x00" DSL_CPE_CRLF
   "   DSL_DBG_PRN = 0x01" DSL_CPE_CRLF
   "   DSL_DBG_ERR = 0x02" DSL_CPE_CRLF
   "   DSL_DBG_WRN = 0x40" DSL_CPE_CRLF
   "   DSL_DBG_MSG = 0x80" DSL_CPE_CRLF
   "   DSL_DBG_LOCAL = 0xFF" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_DBG_MODULE_LEVEL_GET

   Long Form: DbgModuleLevelGet

   Short Form: dmlg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_debugModules_t nDbgModule


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_debugLevels_t nDbgLevel


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_DBG_ModuleLevelGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_DBG_ModuleLevel_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nDbgModule);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_DBG_MODULE_LEVEL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDbgLevel=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nDbgLevel);
   }

   return 0;
}

#endif /* !defined(DSL_CPE_DEBUG_DISABLE) */

static const DSL_char_t g_sTmcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_TestModeControlSet_t nTestMode" DSL_CPE_CRLF
   "   DSL_TESTMODE_DISABLE = 0" DSL_CPE_CRLF
   "   DSL_TESTMODE_SHOWTIME_LOCK = 1" DSL_CPE_CRLF
   "   DSL_TESTMODE_QUIET = 2" DSL_CPE_CRLF
   "   DSL_TESTMODE_TRAINING_LOCK = 3" DSL_CPE_CRLF
   "   DSL_TESTMODE_LOCK = 4" DSL_CPE_CRLF
   "   DSL_TESTMODE_UNLOCK = 5" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_TEST_MODE_CONTROL_SET

   Long Form: TestModeControlSet

   Short Form: tmcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_TestModeControlSet_t nTestMode


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_TestModeControlSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_TestModeControl_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nTestMode);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_TEST_MODE_CONTROL_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#if defined(INCLUDE_DSL_SYSTEM_INTERFACE)

static const DSL_char_t g_sSics[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_TcLayerSelection_t nTcLayer" DSL_CPE_CRLF
   "   DSL_TC_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_TC_ATM = 1" DSL_CPE_CRLF
   "   DSL_TC_EFM = 2" DSL_CPE_CRLF
   "   DSL_TC_HDLC = 3" DSL_CPE_CRLF
   "   DSL_TC_AUTO = 4" DSL_CPE_CRLF
   "   DSL_TC_EFM_FORCED = 5" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_SystemInterfaceSelection_t nSystemIf" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UTOPIA = 1" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_POSPHY = 2" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_MII = 3" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNDEFINED = 4" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_SYSTEM_INTERFACE_CONFIG_SET

   Long Form: SystemInterfaceConfigSet

   Short Form: sics

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_TcLayerSelection_t nTcLayer

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)

   \ref DSL_SystemInterfaceSelection_t nSystemIf


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_SystemInterfaceConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_SystemInterfaceConfig_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %xu %xu %d", &pData.data.nTcLayer, &pData.data.nEfmTcConfigUs, &pData.data.nEfmTcConfigDs, &pData.data.nSystemIf);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_SYSTEM_INTERFACE_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) */

#if defined(INCLUDE_DSL_SYSTEM_INTERFACE) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sSicg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_TcLayerSelection_t nTcLayer" DSL_CPE_CRLF
   "   DSL_TC_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_TC_ATM = 1" DSL_CPE_CRLF
   "   DSL_TC_EFM = 2" DSL_CPE_CRLF
   "   DSL_TC_HDLC = 3" DSL_CPE_CRLF
   "   DSL_TC_AUTO = 4" DSL_CPE_CRLF
   "   DSL_TC_EFM_FORCED = 5" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_SystemInterfaceSelection_t nSystemIf" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UTOPIA = 1" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_POSPHY = 2" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_MII = 3" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNDEFINED = 4" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_SYSTEM_INTERFACE_CONFIG_GET

   Long Form: SystemInterfaceConfigGet

   Short Form: sicg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_TcLayerSelection_t nTcLayer

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)

   \ref DSL_SystemInterfaceSelection_t nSystemIf


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_SystemInterfaceConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_SystemInterfaceConfig_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_SYSTEM_INTERFACE_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nTcLayer=%d nEfmTcConfigUs=0x%x nEfmTcConfigDs=0x%x nSystemIf=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nTcLayer, pData.data.nEfmTcConfigUs, pData.data.nEfmTcConfigDs, pData.data.nSystemIf);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) && defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sEsmcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_EventType_t nEventType" DSL_CPE_CRLF
   "   DSL_EVENT_I_LINE_FAILURES = 0" DSL_CPE_CRLF
   "   DSL_EVENT_I_DATA_PATH_FAILURES = 1" DSL_CPE_CRLF
   "   DSL_EVENT_I_LINE_THRESHOLD_CROSSING = 2" DSL_CPE_CRLF
   "   DSL_EVENT_I_CHANNEL_THRESHOLD_CROSSING = 3" DSL_CPE_CRLF
   "   DSL_EVENT_I_DATA_PATH_THRESHOLD_CROSSING = 4" DSL_CPE_CRLF
   "   DSL_EVENT_I_RETX_THRESHOLD_CROSSING = 5" DSL_CPE_CRLF
   "   DSL_EVENT_I_CHANNEL_DATARATE_SHIFT_THRESHOLD_CROSSING = 6" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINIT_FAILURE = 7" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_STATE = 8" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_POWERMANAGEMENT_STATE = 9" DSL_CPE_CRLF
   "   DSL_EVENT_S_CHANNEL_DATARATE = 10" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_ERROR = 11" DSL_CPE_CRLF
   "   DSL_EVENT_S_INIT_READY = 12" DSL_CPE_CRLF
   "   DSL_EVENT_S_FE_INVENTORY_AVAILABLE = 13" DSL_CPE_CRLF
   "   DSL_EVENT_S_SYSTEM_STATUS = 14" DSL_CPE_CRLF
   "   DSL_EVENT_S_PM_SYNC = 15" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_TRANSMISSION_STATUS = 16" DSL_CPE_CRLF
   "   DSL_EVENT_S_SHOWTIME_LOGGING = 17" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_REQUEST = 18" DSL_CPE_CRLF
   "   DSL_EVENT_S_SNMP_MESSAGE_AVAILABLE = 19" DSL_CPE_CRLF
   "   DSL_EVENT_S_SYSTEM_INTERFACE_STATUS = 20" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_DOWNLOAD_STATUS = 21" DSL_CPE_CRLF
   "   DSL_EVENT_S_AUTOBOOT_STATUS = 22" DSL_CPE_CRLF
   "- DSL_boolean_t bMask" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_EVENT_STATUS_MASK_CONFIG_SET

   Long Form: EventStatusMaskConfigSet

   Short Form: esmcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_EventType_t nEventType

   \ref DSL_boolean_t bMask


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_EventStatusMaskConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_EventStatusMask_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.data.nEventType, &pData.data.bMask);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_EVENT_STATUS_MASK_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#if defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sEsmcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_EventType_t nEventType" DSL_CPE_CRLF
   "   DSL_EVENT_I_LINE_FAILURES = 0" DSL_CPE_CRLF
   "   DSL_EVENT_I_DATA_PATH_FAILURES = 1" DSL_CPE_CRLF
   "   DSL_EVENT_I_LINE_THRESHOLD_CROSSING = 2" DSL_CPE_CRLF
   "   DSL_EVENT_I_CHANNEL_THRESHOLD_CROSSING = 3" DSL_CPE_CRLF
   "   DSL_EVENT_I_DATA_PATH_THRESHOLD_CROSSING = 4" DSL_CPE_CRLF
   "   DSL_EVENT_I_RETX_THRESHOLD_CROSSING = 5" DSL_CPE_CRLF
   "   DSL_EVENT_I_CHANNEL_DATARATE_SHIFT_THRESHOLD_CROSSING = 6" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINIT_FAILURE = 7" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_STATE = 8" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_POWERMANAGEMENT_STATE = 9" DSL_CPE_CRLF
   "   DSL_EVENT_S_CHANNEL_DATARATE = 10" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_ERROR = 11" DSL_CPE_CRLF
   "   DSL_EVENT_S_INIT_READY = 12" DSL_CPE_CRLF
   "   DSL_EVENT_S_FE_INVENTORY_AVAILABLE = 13" DSL_CPE_CRLF
   "   DSL_EVENT_S_SYSTEM_STATUS = 14" DSL_CPE_CRLF
   "   DSL_EVENT_S_PM_SYNC = 15" DSL_CPE_CRLF
   "   DSL_EVENT_S_LINE_TRANSMISSION_STATUS = 16" DSL_CPE_CRLF
   "   DSL_EVENT_S_SHOWTIME_LOGGING = 17" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_REQUEST = 18" DSL_CPE_CRLF
   "   DSL_EVENT_S_SNMP_MESSAGE_AVAILABLE = 19" DSL_CPE_CRLF
   "   DSL_EVENT_S_SYSTEM_INTERFACE_STATUS = 20" DSL_CPE_CRLF
   "   DSL_EVENT_S_FIRMWARE_DOWNLOAD_STATUS = 21" DSL_CPE_CRLF
   "   DSL_EVENT_S_AUTOBOOT_STATUS = 22" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bMask" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_EVENT_STATUS_MASK_CONFIG_GET

   Long Form: EventStatusMaskConfigGet

   Short Form: esmcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_EventType_t nEventType


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bMask


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_EventStatusMaskConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_EventStatusMask_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nEventType);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_EVENT_STATUS_MASK_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"bMask=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.bMask);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sTmsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_TestModeControlSet_t nTestMode" DSL_CPE_CRLF
   "   DSL_TESTMODE_DISABLE = 0" DSL_CPE_CRLF
   "   DSL_TESTMODE_SHOWTIME_LOCK = 1" DSL_CPE_CRLF
   "   DSL_TESTMODE_QUIET = 2" DSL_CPE_CRLF
   "   DSL_TESTMODE_TRAINING_LOCK = 3" DSL_CPE_CRLF
   "   DSL_TESTMODE_LOCK = 4" DSL_CPE_CRLF
   "   DSL_TESTMODE_UNLOCK = 5" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_TEST_MODE_STATUS_GET

   Long Form: TestModeStatusGet

   Short Form: tmsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_TestModeControlSet_t nTestMode


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_TestModeStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_TestModeStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_TEST_MODE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nTestMode=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nTestMode);
   }

   return 0;
}

#if defined(INCLUDE_DSL_SYSTEM_INTERFACE)

static const DSL_char_t g_sSisg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_TcLayerSelection_t nTcLayer" DSL_CPE_CRLF
   "   DSL_TC_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_TC_ATM = 1" DSL_CPE_CRLF
   "   DSL_TC_EFM = 2" DSL_CPE_CRLF
   "   DSL_TC_HDLC = 3" DSL_CPE_CRLF
   "   DSL_TC_AUTO = 4" DSL_CPE_CRLF
   "   DSL_TC_EFM_FORCED = 5" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)" DSL_CPE_CRLF
   "   DSL_EMF_TC_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_EMF_TC_NORMAL = 0x00000001" DSL_CPE_CRLF
   "   DSL_EMF_TC_PRE_EMPTION = 0x00000002" DSL_CPE_CRLF
   "   DSL_EMF_TC_SHORT_PACKETS = 0x00000004" DSL_CPE_CRLF
   "- DSL_SystemInterfaceSelection_t nSystemIf" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNKNOWN = 0" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UTOPIA = 1" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_POSPHY = 2" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_MII = 3" DSL_CPE_CRLF
   "   DSL_SYSTEMIF_UNDEFINED = 4" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_SYSTEM_INTERFACE_STATUS_GET

   Long Form: SystemInterfaceStatusGet

   Short Form: sisg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_TcLayerSelection_t nTcLayer

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigUs (hex)

   \ref DSL_BF_EfmTcConfig_t nEfmTcConfigDs (hex)

   \ref DSL_SystemInterfaceSelection_t nSystemIf


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_SystemInterfaceStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_SystemInterfaceStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_SYSTEM_INTERFACE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nTcLayer=%d nEfmTcConfigUs=0x%x nEfmTcConfigDs=0x%x nSystemIf=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nTcLayer, pData.data.nEfmTcConfigUs, pData.data.nEfmTcConfigDs, pData.data.nSystemIf);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) */

static const DSL_char_t g_sIsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bEventActivation" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_BF_ResourceActivationType_t nResourceActivationMask" DSL_CPE_CRLF
   "   DSL_RESOURCE_ACTIVATION_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_RESOURCE_ACTIVATION_SNMP = 0x00000001" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_INSTANCE_STATUS_GET

   Long Form: InstanceStatusGet

   Short Form: isg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bEventActivation

   \ref DSL_BF_ResourceActivationType_t nResourceActivationMask


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_InstanceStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_InstanceStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_INSTANCE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"bEventActivation=%d nResourceActivationMask=0x%x" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.bEventActivation, pData.data.nResourceActivationMask);
   }

   return 0;
}

#if defined(INCLUDE_DSL_CPE_MISC_LINE_STATUS)

static const DSL_char_t g_sMlsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_MiscLineStatusSelector_t nStatusSelector" DSL_CPE_CRLF
   "   DSL_MLS_ATTNDR_CODING_GAIN_DS = 0" DSL_CPE_CRLF
   "   DSL_MLS_ATTNDR_MAX_BITS_PER_SYMBOL_DS = 1" DSL_CPE_CRLF
   "   DSL_MLS_DUAL_LATENCY_ON_US = 2" DSL_CPE_CRLF
   "   DSL_MLS_DUAL_LATENCY_ON_DS = 3" DSL_CPE_CRLF
   "   DSL_MLS_INIT_SNR_DS = 4" DSL_CPE_CRLF
   "   DSL_MLS_NOMPSD_US = 5" DSL_CPE_CRLF
   "   DSL_MLS_NOMPSD_DS = 6" DSL_CPE_CRLF
   "   DSL_MLS_LINE_RATE_US = 7" DSL_CPE_CRLF
   "   DSL_MLS_LINE_RATE_DS = 8" DSL_CPE_CRLF
   "   DSL_MLS_NET_RATE_US = 9" DSL_CPE_CRLF
   "   DSL_MLS_NET_RATE_DS = 10" DSL_CPE_CRLF
   "   DSL_MLS_TOTAL_DATA_RATE_US = 11" DSL_CPE_CRLF
   "   DSL_MLS_TOTAL_DATA_RATE_DS = 12" DSL_CPE_CRLF
   "   DSL_MLS_AGGREGATE_DATA_RATE_US = 13" DSL_CPE_CRLF
   "   DSL_MLS_AGGREGATE_DATA_RATE_DS = 14" DSL_CPE_CRLF
   "   DSL_MLS_MIN_INP_IP_LP0_DS = 15" DSL_CPE_CRLF
   "   DSL_MLS_MIN_INP_FP_LP1_DS = 16" DSL_CPE_CRLF
   "   DSL_MLS_ATT_AGGREGATE_DATA_RATE_US = 17" DSL_CPE_CRLF
   "   DSL_MLS_ATT_AGGREGATE_DATA_RATE_DS = 18" DSL_CPE_CRLF
   "   DSL_MLS_ATT_LINE_DATA_RATE_US = 19" DSL_CPE_CRLF
   "   DSL_MLS_ATT_LINE_DATA_RATE_DS = 20" DSL_CPE_CRLF
   "   DSL_MLS_ATT_TOTAL_DATA_RATE_US = 21" DSL_CPE_CRLF
   "   DSL_MLS_ATT_TOTAL_DATA_RATE_DS = 22" DSL_CPE_CRLF
   "   DSL_MLS_MASK_ANNEX_M_J_US = 23" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_int32_t nStatusValue" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_MISC_LINE_STATUS_GET

   Long Form: MiscLineStatusGet

   Short Form: mlsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_MiscLineStatusSelector_t nStatusSelector


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_int32_t nStatusValue


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_MiscLineStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_MiscLineStatus_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nStatusSelector);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_MISC_LINE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nStatusValue=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nStatusValue);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CPE_MISC_LINE_STATUS) */

static const DSL_char_t g_sLocs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_LineOptionsSelector_t nConfigSelector" DSL_CPE_CRLF
   "   DSL_OPT_NOISE_MARGIN_DELTA_DS = 0" DSL_CPE_CRLF
   "   DSL_ERASURE_DECODING_TYPE_DS = 1" DSL_CPE_CRLF
   "   DSL_TRUST_ME_BIT = 2" DSL_CPE_CRLF
   "   DSL_INBAND_SPECTRAL_SHAPING_US = 3" DSL_CPE_CRLF
   "- DSL_int32_t nConfigValue" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_OPTIONS_CONFIG_SET

   Long Form: LineOptionsConfigSet

   Short Form: locs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_LineOptionsSelector_t nConfigSelector

   \ref DSL_int32_t nConfigValue


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineOptionsConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineOptionsConfig_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.data.nConfigSelector, &pData.data.nConfigValue);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_OPTIONS_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#if defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sLocg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_LineOptionsSelector_t nConfigSelector" DSL_CPE_CRLF
   "   DSL_OPT_NOISE_MARGIN_DELTA_DS = 0" DSL_CPE_CRLF
   "   DSL_ERASURE_DECODING_TYPE_DS = 1" DSL_CPE_CRLF
   "   DSL_TRUST_ME_BIT = 2" DSL_CPE_CRLF
   "   DSL_INBAND_SPECTRAL_SHAPING_US = 3" DSL_CPE_CRLF
   "- DSL_int32_t nConfigValue" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_LINE_OPTIONS_CONFIG_GET

   Long Form: LineOptionsConfigGet

   Short Form: locg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_LineOptionsSelector_t nConfigSelector

   \ref DSL_int32_t nConfigValue


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_LineOptionsConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_LineOptionsConfig_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_LINE_OPTIONS_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nConfigSelector=%d nConfigValue=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nConfigSelector, pData.data.nConfigValue);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sG997lacs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_LDSF_t nLDSF" DSL_CPE_CRLF
   "   DSL_G997_INHIBIT_LDSF = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_LDSF = 1" DSL_CPE_CRLF
   "   DSL_G997_AUTO_LDSF = 2" DSL_CPE_CRLF
   "- DSL_G997_ACSF_t nACSF" DSL_CPE_CRLF
   "   DSL_G997_INHIBIT_ACSF = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_ACSF = 1" DSL_CPE_CRLF
   "- DSL_G997_StartupMode_t nStartupMode" DSL_CPE_CRLF
   "   DSL_G997_NORMAL_STARTUP = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_SHORT_STARTUP = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_ACTIVATE_CONFIG_SET

   Long Form: G997_LineActivateConfigSet

   Short Form: g997lacs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_LDSF_t nLDSF

   \ref DSL_G997_ACSF_t nACSF

   \ref DSL_G997_StartupMode_t nStartupMode


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineActivateConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineActivate_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d %d", &pData.data.nLDSF, &pData.data.nACSF, &pData.data.nStartupMode);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_ACTIVATE_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#if defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sG997lacg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_LDSF_t nLDSF" DSL_CPE_CRLF
   "   DSL_G997_INHIBIT_LDSF = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_LDSF = 1" DSL_CPE_CRLF
   "   DSL_G997_AUTO_LDSF = 2" DSL_CPE_CRLF
   "- DSL_G997_ACSF_t nACSF" DSL_CPE_CRLF
   "   DSL_G997_INHIBIT_ACSF = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_ACSF = 1" DSL_CPE_CRLF
   "- DSL_G997_StartupMode_t nStartupMode" DSL_CPE_CRLF
   "   DSL_G997_NORMAL_STARTUP = 0" DSL_CPE_CRLF
   "   DSL_G997_FORCE_SHORT_STARTUP = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_ACTIVATE_CONFIG_GET

   Long Form: G997_LineActivateConfigGet

   Short Form: g997lacg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_LDSF_t nLDSF

   \ref DSL_G997_ACSF_t nACSF

   \ref DSL_G997_StartupMode_t nStartupMode


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineActivateConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineActivate_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_ACTIVATE_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nLDSF=%d nACSF=%d nStartupMode=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nLDSF, pData.data.nACSF, pData.data.nStartupMode);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_G997_ALARM)

static const DSL_char_t g_sG997cdrtcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nDataRateThresholdUpshift" DSL_CPE_CRLF
   "- DSL_uint32_t nDataRateThresholdDownshift" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_SET

   Long Form: G997_ChannelDataRateThresholdConfigSet

   Short Form: g997cdrtcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint32_t nDataRateThresholdUpshift

   \ref DSL_uint32_t nDataRateThresholdDownshift


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997ChannelDataRateThresholdConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_ChannelDataRateThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u %u", &pData.nChannel, &pData.nDirection, &pData.data.nDataRateThresholdUpshift, &pData.data.nDataRateThresholdDownshift);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sG997cdrtcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nDataRateThresholdUpshift" DSL_CPE_CRLF
   "- DSL_uint32_t nDataRateThresholdDownshift" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_GET

   Long Form: G997_ChannelDataRateThresholdConfigGet

   Short Form: g997cdrtcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint32_t nDataRateThresholdUpshift

   \ref DSL_uint32_t nDataRateThresholdDownshift


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997ChannelDataRateThresholdConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_ChannelDataRateThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_CHANNEL_DATA_RATE_THRESHOLD_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nDataRateThresholdUpshift=%u nDataRateThresholdDownshift=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nDataRateThresholdUpshift, pData.data.nDataRateThresholdDownshift);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sG997ltsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_LineTransmission_t nLineTransmissionStatus" DSL_CPE_CRLF
   "   DSL_G997_LINE_TRANSMISSION_AVAILABLE = 0" DSL_CPE_CRLF
   "   DSL_G997_LINE_TRANSMISSION_NOT_AVAILABLE = 1" DSL_CPE_CRLF
   "   DSL_G997_LINE_TRANSMISSION_NOT_SUPPORTED = 2" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_TRANSMISSION_STATUS_GET

   Long Form: G997_LineTransmissionStatusGet

   Short Form: g997ltsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_LineTransmission_t nLineTransmissionStatus


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineTransmissionStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineTransmissionStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_TRANSMISSION_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nLineTransmissionStatus=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nLineTransmissionStatus);
   }

   return 0;
}

#if defined(INCLUDE_DSL_G997_STATUS)

static const DSL_char_t g_sG997lisg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_LineInit_t nLineInitStatus" DSL_CPE_CRLF
   "   LINIT_SUCCESSFUL = 0" DSL_CPE_CRLF
   "   LINIT_CONFIG_ERROR = 1" DSL_CPE_CRLF
   "   LINIT_CONFIG_NOT_FEASIBLE = 2" DSL_CPE_CRLF
   "   LINIT_COMMUNICATION_PROBLEM = 3" DSL_CPE_CRLF
   "   LINIT_NO_PEER_XTU = 4" DSL_CPE_CRLF
   "   LINIT_UNKNOWN = 5" DSL_CPE_CRLF
   "- DSL_G997_LineInitSubStatus_t nLineInitSubStatus" DSL_CPE_CRLF
   "   LINIT_SUB_NONE = 0" DSL_CPE_CRLF
   "   LINIT_SUB_UNKNOWN = 1" DSL_CPE_CRLF
   "   LINIT_SUB_NO_COMMON_MODE = 2" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_INIT_STATUS_GET

   Long Form: G997_LineInitStatusGet

   Short Form: g997lisg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_LineInit_t nLineInitStatus

   \ref DSL_G997_LineInitSubStatus_t nLineInitSubStatus


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineInitStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineInitStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_INIT_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nLineInitStatus=%d nLineInitSubStatus=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nLineInitStatus, pData.data.nLineInitSubStatus);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_STATUS) */

static const DSL_char_t g_sG997lsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_DeltDataType_t nDeltDataType" DSL_CPE_CRLF
   "   DSL_DELT_DATA_DIAGNOSTICS = 0" DSL_CPE_CRLF
   "   DSL_DELT_DATA_SHOWTIME = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_int16_t LATN" DSL_CPE_CRLF
   "- DSL_int16_t SATN" DSL_CPE_CRLF
   "- DSL_int16_t SNR" DSL_CPE_CRLF
   "- DSL_uint32_t ATTNDR" DSL_CPE_CRLF
   "- DSL_int16_t ACTPS" DSL_CPE_CRLF
   "- DSL_int16_t ACTATP" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_STATUS_GET

   Long Form: G997_LineStatusGet

   Short Form: g997lsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_DeltDataType_t nDeltDataType


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_int16_t LATN

   \ref DSL_int16_t SATN

   \ref DSL_int16_t SNR

   \ref DSL_uint32_t ATTNDR

   \ref DSL_int16_t ACTPS

   \ref DSL_int16_t ACTATP


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineStatus_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.nDirection, &pData.nDeltDataType);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d LATN=%hd SATN=%hd SNR=%hd ATTNDR=%u ACTPS=%hd ACTATP=%hd" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.LATN, pData.data.SATN, pData.data.SNR, pData.data.ATTNDR, pData.data.ACTPS, pData.data.ACTATP);
   }

   return 0;
}


static const DSL_char_t g_sG997csg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint32_t ActualDataRate" DSL_CPE_CRLF
   "- DSL_uint32_t PreviousDataRate" DSL_CPE_CRLF
   "- DSL_uint32_t ActualInterleaveDelay" DSL_CPE_CRLF
   "- DSL_uint8_t ActualImpulseNoiseProtection" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_CHANNEL_STATUS_GET

   Long Form: G997_ChannelStatusGet

   Short Form: g997csg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint32_t ActualDataRate

   \ref DSL_uint32_t PreviousDataRate

   \ref DSL_uint32_t ActualInterleaveDelay

   \ref DSL_uint8_t ActualImpulseNoiseProtection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997ChannelStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_ChannelStatus_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_CHANNEL_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d ActualDataRate=%u PreviousDataRate=%u ActualInterleaveDelay=%u ActualImpulseNoiseProtection=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.ActualDataRate, pData.data.PreviousDataRate, pData.data.ActualInterleaveDelay, pData.data.ActualImpulseNoiseProtection);
   }

   return 0;
}


static const DSL_char_t g_sG997pmsft[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_PowerManagementStateForce_t nPowerManagementState" DSL_CPE_CRLF
   "   DSL_G997_PMSF_L3_TO_L0 = 0" DSL_CPE_CRLF
   "   DSL_G997_PMSF_L0_TO_L2 = 2" DSL_CPE_CRLF
   "   DSL_G997_PMSF_LX_TO_L3 = 3" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_POWER_MANAGEMENT_STATE_FORCED_TRIGGER

   Long Form: G997_PowerManagementStateForcedTrigger

   Short Form: g997pmsft

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_PowerManagementStateForce_t nPowerManagementState


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997PowerManagementStateForcedTrigger(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_PowerManagementStateForcedTrigger_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nPowerManagementState);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_POWER_MANAGEMENT_STATE_FORCED_TRIGGER, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sG997pmsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_G997_PowerManagement_t nPowerManagementStatus" DSL_CPE_CRLF
   "   DSL_G997_PMS_NA = -1" DSL_CPE_CRLF
   "   DSL_G997_PMS_L0 = 0" DSL_CPE_CRLF
   "   DSL_G997_PMS_L1 = 1" DSL_CPE_CRLF
   "   DSL_G997_PMS_L2 = 2" DSL_CPE_CRLF
   "   DSL_G997_PMS_L3 = 3" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_POWER_MANAGEMENT_STATUS_GET

   Long Form: G997_PowerManagementStatusGet

   Short Form: g997pmsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_G997_PowerManagement_t nPowerManagementStatus


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997PowerManagementStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_PowerManagementStatus_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_POWER_MANAGEMENT_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nPowerManagementStatus=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nPowerManagementStatus);
   }

   return 0;
}

#if defined(INCLUDE_DSL_G997_STATUS)

static const DSL_char_t g_sG997lstg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint16_t nLastStateTransmitted" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LAST_STATE_TRANSMITTED_GET

   Long Form: G997_LastStateTransmittedGet

   Short Form: g997lstg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint16_t nLastStateTransmitted


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LastStateTransmittedGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LastStateTransmitted_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LAST_STATE_TRANSMITTED_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nLastStateTransmitted=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nLastStateTransmitted);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_STATUS) */

#if defined(INCLUDE_DSL_G997_ALARM)

static const DSL_char_t g_sG997amlfcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_LineFailures_t nLineFailures" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LPR = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOF = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOS = 0x00000004" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOM = 0x00000008" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOL = 0x00000010" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_ESE = 0x00000020" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_SET

   Long Form: G997_AlarmMaskLineFailuresConfigSet

   Short Form: g997amlfcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_LineFailures_t nLineFailures


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997AlarmMaskLineFailuresConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.nDirection, &pData.data.nLineFailures);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sG997amlfcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_LineFailures_t nLineFailures" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LPR = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOF = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOS = 0x00000004" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOM = 0x00000008" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOL = 0x00000010" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_ESE = 0x00000020" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_GET

   Long Form: G997_AlarmMaskLineFailuresConfigGet

   Short Form: g997amlfcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_LineFailures_t nLineFailures


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997AlarmMaskLineFailuresConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_ALARM_MASK_LINE_FAILURES_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nLineFailures=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nLineFailures);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sG997lfsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_LineFailures_t nLineFailures" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LPR = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOF = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOS = 0x00000004" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOM = 0x00000008" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_LOL = 0x00000010" DSL_CPE_CRLF
   "   DSL_G997_LINEFAILURE_ESE = 0x00000020" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_LINE_FAILURES_STATUS_GET

   Long Form: G997_LineFailuresStatusGet

   Short Form: g997lfsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_LineFailures_t nLineFailures


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997LineFailuresStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_LineFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_LINE_FAILURES_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nLineFailures=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nLineFailures);
   }

   return 0;
}

#if defined(INCLUDE_DSL_G997_ALARM)

static const DSL_char_t g_sG997amdpfcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_NCD = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_LCD = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_OOS = 0x00000004" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_SET

   Long Form: G997_AlarmMaskDataPathFailuresConfigSet

   Short Form: g997amdpfcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997AlarmMaskDataPathFailuresConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_DataPathFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %xu", &pData.nChannel, &pData.nDirection, &pData.data.nDataPathFailures);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sG997amdpfcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_NCD = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_LCD = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_OOS = 0x00000004" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_GET

   Long Form: G997_AlarmMaskDataPathFailuresConfigGet

   Short Form: g997amdpfcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997AlarmMaskDataPathFailuresConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_DataPathFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_ALARM_MASK_DATA_PATH_FAILURES_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nDataPathFailures=0x%x" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nDataPathFailures);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */

static const DSL_char_t g_sG997dpfsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_CLEANED = 0x00000000" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_NCD = 0x00000001" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_LCD = 0x00000002" DSL_CPE_CRLF
   "   DSL_G997_DATAPATHFAILURE_OOS = 0x00000004" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_DATA_PATH_FAILURES_STATUS_GET

   Long Form: G997_DataPathFailuresStatusGet

   Short Form: g997dpfsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_G997_BF_DataPathFailures_t nDataPathFailures (hex)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997DataPathFailuresStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_DataPathFailures_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_DATA_PATH_FAILURES_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nDataPathFailures=0x%x" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nDataPathFailures);
   }

   return 0;
}

#if defined(INCLUDE_DSL_G997_FRAMING_PARAMETERS)

static const DSL_char_t g_sG997fpsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint16_t nNFEC" DSL_CPE_CRLF
   "- DSL_uint16_t nRFEC" DSL_CPE_CRLF
   "- DSL_uint16_t nLSYMB" DSL_CPE_CRLF
   "- DSL_uint16_t nINTLVDEPTH" DSL_CPE_CRLF
   "- DSL_uint16_t nINTLVBLOCK" DSL_CPE_CRLF
   "- DSL_uint8_t nLPATH" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_FRAMING_PARAMETER_STATUS_GET

   Long Form: G997_FramingParameterStatusGet

   Short Form: g997fpsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint16_t nNFEC

   \ref DSL_uint16_t nRFEC

   \ref DSL_uint16_t nLSYMB

   \ref DSL_uint16_t nINTLVDEPTH

   \ref DSL_uint16_t nINTLVBLOCK

   \ref DSL_uint8_t nLPATH


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997FramingParameterStatusGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_FramingParameterStatus_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_FRAMING_PARAMETER_STATUS_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nNFEC=%hu nRFEC=%hu nLSYMB=%hu nINTLVDEPTH=%hu nINTLVBLOCK=%hu nLPATH=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nNFEC, pData.data.nRFEC, pData.data.nLSYMB, pData.data.nINTLVDEPTH, pData.data.nINTLVBLOCK, pData.data.nLPATH);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_G997_FRAMING_PARAMETERS) */

#if defined(INCLUDE_DSL_DELT)

static const DSL_char_t g_sG997dhsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_DeltDataType_t nDeltDataType" DSL_CPE_CRLF
   "   DSL_DELT_DATA_DIAGNOSTICS = 0" DSL_CPE_CRLF
   "   DSL_DELT_DATA_SHOWTIME = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_uint16_t nDeltHlinScale" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_DELT_HLIN_SCALE_GET

   Long Form: G997_DeltHlinScaleGet

   Short Form: g997dhsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_DeltDataType_t nDeltDataType


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_uint16_t nDeltHlinScale


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997DeltHlinScaleGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_DeltHlinScale_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.nDirection, &pData.nDeltDataType);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_DELT_HLIN_SCALE_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nDeltHlinScale=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nDeltHlinScale);
   }

   return 0;
}


static const DSL_char_t g_sG997dfr[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_DELT_FREE_RESOURCES

   Long Form: G997_DeltFreeResources

   Short Form: g997dfr

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997DeltFreeResources(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_DeltFreeResources_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_DELT_FREE_RESOURCES, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_DELT) */

static const DSL_char_t g_sG997racs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_G997_RA_MODE_t RA_MODE" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_AT_INIT = 2" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_DYNAMIC = 3" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_DYNAMIC_SOS = 4" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_RATE_ADAPTATION_CONFIG_SET

   Long Form: G997_RateAdaptationConfigSet

   Short Form: g997racs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_G997_RA_MODE_t RA_MODE


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997RateAdaptationConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_RateAdaptationConfig_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d", &pData.nDirection, &pData.data.RA_MODE);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_RATE_ADAPTATION_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}

#if defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sG997racg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_AccessDir_t nDirection" DSL_CPE_CRLF
   "   DSL_UPSTREAM = 0" DSL_CPE_CRLF
   "   DSL_DOWNSTREAM = 1" DSL_CPE_CRLF
   "- DSL_G997_RA_MODE_t RA_MODE" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_AT_INIT = 2" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_DYNAMIC = 3" DSL_CPE_CRLF
   "   DSL_G997_RA_MODE_DYNAMIC_SOS = 4" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_G997_RATE_ADAPTATION_CONFIG_GET

   Long Form: G997_RateAdaptationConfigGet

   Short Form: g997racg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_AccessDir_t nDirection

   \ref DSL_G997_RA_MODE_t RA_MODE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_G997RateAdaptationConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_G997_RateAdaptationConfig_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_G997_RATE_ADAPTATION_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d RA_MODE=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.RA_MODE);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmlshs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_HISTORY_STATS_15MIN_GET

   Long Form: PM_LineSecHistoryStats15MinGet

   Short Form: pmlshs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmlshs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_HISTORY_STATS_1DAY_GET

   Long Form: PM_LineSecHistoryStats1DayGet

   Short Form: pmlshs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmlsc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_COUNTERS_15MIN_GET

   Long Form: PM_LineSecCounters15MinGet

   Short Form: pmlsc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}


static const DSL_char_t g_sPmlsc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_COUNTERS_1DAY_GET

   Long Form: PM_LineSecCounters1DayGet

   Short Form: pmlsc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmlsctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_COUNTERS_TOTAL_GET

   Long Form: PM_LineSecCountersTotalGet

   Short Form: pmlsctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nElapsedTime=%u bValid=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmlst15ms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_SET

   Long Form: PM_LineSecThresholds15MinSet

   Short Form: pmlst15ms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecThresholds15MinSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 6, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u %u %u %u %u", &pData.nDirection, &pData.data.nES, &pData.data.nSES, &pData.data.nLOSS, &pData.data.nUAS, &pData.data.nLOFS);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmlst1ds[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_SET

   Long Form: PM_LineSecThresholds1DaySet

   Short Form: pmlst1ds

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecThresholds1DaySet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 6, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u %u %u %u %u", &pData.nDirection, &pData.data.nES, &pData.data.nSES, &pData.data.nLOSS, &pData.data.nUAS, &pData.data.nLOFS);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmlst15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_GET

   Long Form: PM_LineSecThresholds15MinGet

   Short Form: pmlst15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecThresholds15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_THRESHOLDS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}


static const DSL_char_t g_sPmlst1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_GET

   Long Form: PM_LineSecThresholds1DayGet

   Short Form: pmlst1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecThresholds1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_THRESHOLDS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmlihs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_HISTORY_STATS_15MIN_GET

   Long Form: PM_LineInitHistoryStats15MinGet

   Short Form: pmlihs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStats_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmlihs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_HISTORY_STATS_1DAY_GET

   Long Form: PM_LineInitHistoryStats1DayGet

   Short Form: pmlihs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStats_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmlic15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_COUNTERS_15MIN_GET

   Long Form: PM_LineInitCounters15MinGet

   Short Form: pmlic15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%u", &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}


static const DSL_char_t g_sPmlic1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_COUNTERS_1DAY_GET

   Long Form: PM_LineInitCounters1DayGet

   Short Form: pmlic1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%u", &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmlictg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_COUNTERS_TOTAL_GET

   Long Form: PM_LineInitCountersTotalGet

   Short Form: pmlictg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitCountersTotal_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nElapsedTime=%u bValid=%d nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.total.nElapsedTime, pData.total.bValid, pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmlit15ms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_SET

   Long Form: PM_LineInitThresholds15MinSet

   Short Form: pmlit15ms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitThresholds15MinSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%u %u %u %u", &pData.data.nFullInits, &pData.data.nFailedFullInits, &pData.data.nShortInits, &pData.data.nFailedShortInits);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sPmlit1ds[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_SET

   Long Form: PM_LineInitThresholds1DaySet

   Short Form: pmlit1ds

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitThresholds1DaySet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%u %u %u %u", &pData.data.nFullInits, &pData.data.nFailedFullInits, &pData.data.nShortInits, &pData.data.nFailedShortInits);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sPmlit15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_GET

   Long Form: PM_LineInitThresholds15MinGet

   Short Form: pmlit15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitThresholds15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitThreshold_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_THRESHOLDS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}


static const DSL_char_t g_sPmlit1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_GET

   Long Form: PM_LineInitThresholds1DayGet

   Short Form: pmlit1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitThresholds1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitThreshold_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_THRESHOLDS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmchs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_HISTORY_STATS_15MIN_GET

   Long Form: PM_ChannelHistoryStats15MinGet

   Short Form: pmchs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmchs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_HISTORY_STATS_1DAY_GET

   Long Form: PM_ChannelHistoryStats1DayGet

   Short Form: pmchs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmcc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_COUNTERS_15MIN_GET

   Long Form: PM_ChannelCounters15MinGet

   Short Form: pmcc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}


static const DSL_char_t g_sPmcc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_COUNTERS_1DAY_GET

   Long Form: PM_ChannelCounters1DayGet

   Short Form: pmcc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmcctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_COUNTERS_TOTAL_GET

   Long Form: PM_ChannelCountersTotalGet

   Short Form: pmcctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nElapsedTime=%u bValid=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmct15ms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_SET

   Long Form: PM_ChannelThresholds15MinSet

   Short Form: pmct15ms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelThresholds15MinSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u %u", &pData.nChannel, &pData.nDirection, &pData.data.nCodeViolations, &pData.data.nFEC);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmct1ds[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_SET

   Long Form: PM_ChannelThresholds1DaySet

   Short Form: pmct1ds

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelThresholds1DaySet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u %u", &pData.nChannel, &pData.nDirection, &pData.data.nCodeViolations, &pData.data.nFEC);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmct15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_GET

   Long Form: PM_ChannelThresholds15MinGet

   Short Form: pmct15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelThresholds15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_THRESHOLDS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}


static const DSL_char_t g_sPmct1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_GET

   Long Form: PM_ChannelThresholds1DayGet

   Short Form: pmct1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelThresholds1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_THRESHOLDS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmdphs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_HISTORY_STATS_15MIN_GET

   Long Form: PM_DataPathHistoryStats15MinGet

   Short Form: pmdphs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmdphs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_HISTORY_STATS_1DAY_GET

   Long Form: PM_DataPathHistoryStats1DayGet

   Short Form: pmdphs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmdpc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_COUNTERS_15MIN_GET

   Long Form: PM_DataPathCounters15MinGet

   Short Form: pmdpc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}


static const DSL_char_t g_sPmdpc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_COUNTERS_1DAY_GET

   Long Form: PM_DataPathCounters1DayGet

   Short Form: pmdpc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmdpctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_COUNTERS_TOTAL_GET

   Long Form: PM_DataPathCountersTotalGet

   Short Form: pmdpctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nElapsedTime=%u bValid=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmdpt15ms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_SET

   Long Form: PM_DataPathThresholds15MinSet

   Short Form: pmdpt15ms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathThresholds15MinSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 12, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u %u %u %u %u %u %u %u %u %u", &pData.nChannel, &pData.nDirection, &pData.data.nHEC, &pData.data.nTotalCells, &pData.data.nUserTotalCells, &pData.data.nIBE, &pData.data.nCRC_P, &pData.data.nCRCP_P, &pData.data.nCV_P, &pData.data.nCVP_P, &pData.data.nTxUserTotalCells, &pData.data.nTxIBE);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmdpt1ds[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_SET

   Long Form: PM_DataPathThresholds1DaySet

   Short Form: pmdpt1ds

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathThresholds1DaySet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 12, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u %u %u %u %u %u %u %u %u %u", &pData.nChannel, &pData.nDirection, &pData.data.nHEC, &pData.data.nTotalCells, &pData.data.nUserTotalCells, &pData.data.nIBE, &pData.data.nCRC_P, &pData.data.nCRCP_P, &pData.data.nCV_P, &pData.data.nCVP_P, &pData.data.nTxUserTotalCells, &pData.data.nTxIBE);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmdpt15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_GET

   Long Form: PM_DataPathThresholds15MinGet

   Short Form: pmdpt15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathThresholds15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_THRESHOLDS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}


static const DSL_char_t g_sPmdpt1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_GET

   Long Form: PM_DataPathThresholds1DayGet

   Short Form: pmdpt1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathThresholds1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_THRESHOLDS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPm15meet[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bOneDayElapsed" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_15MIN_ELAPSED_EXT_TRIGGER

   Long Form: PM_15MinElapsedExtTrigger

   Short Form: pm15meet

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bOneDayElapsed


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_15MinElapsedExtTrigger(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ElapsedExtTrigger_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.bOneDayElapsed);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_15MIN_ELAPSED_EXT_TRIGGER, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sPmetr[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_ELAPSED_TIME_RESET

   Long Form: PM_ElapsedTimeReset

   Short Form: pmetr

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ElapsedTimeReset(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ElapsedTimeReset_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_ELAPSED_TIME_RESET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sPmsms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_PM_SyncModeType_t nMode" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_FREE = 0" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_SYS_TIME = 1" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_EXTERNAL = 2" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_SYNC_MODE_SET

   Long Form: PM_SyncModeSet

   Short Form: pmsms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_PM_SyncModeType_t nMode


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_SyncModeSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_SyncMode_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.data.nMode);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_SYNC_MODE_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}


static const DSL_char_t g_sPmbms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bActivate" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPmTick" DSL_CPE_CRLF
   "- DSL_uint32_t nPm15Min" DSL_CPE_CRLF
   "- DSL_uint32_t nPm15MinPerDay" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_BURNIN_MODE_SET

   Long Form: PM_BurninModeSet

   Short Form: pmbms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bActivate

   \ref DSL_uint32_t nPmTick

   \ref DSL_uint32_t nPm15Min

   \ref DSL_uint32_t nPm15MinPerDay


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_BurninModeSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_BurninMode_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 4, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u %u %u", &pData.data.bActivate, &pData.data.nMode.nPmTick, &pData.data.nMode.nPm15Min, &pData.data.nMode.nPm15MinPerDay);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_BURNIN_MODE_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmlscsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nES" DSL_CPE_CRLF
   "- DSL_uint32_t nSES" DSL_CPE_CRLF
   "- DSL_uint32_t nLOSS" DSL_CPE_CRLF
   "- DSL_uint32_t nUAS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOFS" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_SEC_COUNTERS_SHOWTIME_GET

   Long Form: PM_LineSecCountersShowtimeGet

   Short Form: pmlscsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nES

   \ref DSL_uint32_t nSES

   \ref DSL_uint32_t nLOSS

   \ref DSL_uint32_t nUAS

   \ref DSL_uint32_t nLOFS


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineSecCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineSecCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_SEC_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nES=%u nSES=%u nLOSS=%u nUAS=%u nLOFS=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nES, pData.data.nSES, pData.data.nLOSS, pData.data.nUAS, pData.data.nLOFS);
   }

   return 0;
}


static const DSL_char_t g_sPmlicsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedFullInits" DSL_CPE_CRLF
   "- DSL_uint32_t nShortInits" DSL_CPE_CRLF
   "- DSL_uint32_t nFailedShortInits" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_INIT_COUNTERS_SHOWTIME_GET

   Long Form: PM_LineInitCountersShowtimeGet

   Short Form: pmlicsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nFullInits

   \ref DSL_uint32_t nFailedFullInits

   \ref DSL_uint32_t nShortInits

   \ref DSL_uint32_t nFailedShortInits


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineInitCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineInitCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%u", &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_INIT_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nFullInits=%u nFailedFullInits=%u nShortInits=%u nFailedShortInits=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nFullInits, pData.data.nFailedFullInits, pData.data.nShortInits, pData.data.nFailedShortInits);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmccsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nCodeViolations" DSL_CPE_CRLF
   "- DSL_uint32_t nFEC" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_GET

   Long Form: PM_ChannelCountersShowtimeGet

   Short Form: pmccsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nCodeViolations

   \ref DSL_uint32_t nFEC


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ChannelCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ChannelCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CHANNEL_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nCodeViolations=%u nFEC=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nCodeViolations, pData.data.nFEC);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmdpcsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHEC" DSL_CPE_CRLF
   "- DSL_uint32_t nTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nIBE" DSL_CPE_CRLF
   "- DSL_uint32_t nCRC_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCRCP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCV_P" DSL_CPE_CRLF
   "- DSL_uint32_t nCVP_P" DSL_CPE_CRLF
   "- DSL_uint32_t nTxUserTotalCells" DSL_CPE_CRLF
   "- DSL_uint32_t nTxIBE" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_COUNTERS_SHOWTIME_GET

   Long Form: PM_DataPathCountersShowtimeGet

   Short Form: pmdpcsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nHEC

   \ref DSL_uint32_t nTotalCells

   \ref DSL_uint32_t nUserTotalCells

   \ref DSL_uint32_t nIBE

   \ref DSL_uint32_t nCRC_P

   \ref DSL_uint32_t nCRCP_P

   \ref DSL_uint32_t nCV_P

   \ref DSL_uint32_t nCVP_P

   \ref DSL_uint32_t nTxUserTotalCells

   \ref DSL_uint32_t nTxIBE


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nHEC=%u nTotalCells=%u nUserTotalCells=%u nIBE=%u nCRC_P=%u nCRCP_P=%u nCV_P=%u nCVP_P=%u nTxUserTotalCells=%u nTxIBE=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nHEC, pData.data.nTotalCells, pData.data.nUserTotalCells, pData.data.nIBE, pData.data.nCRC_P, pData.data.nCRCP_P, pData.data.nCV_P, pData.data.nCVP_P, pData.data.nTxUserTotalCells, pData.data.nTxIBE);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sPmcg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bNePollingOff" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bFePollingOff" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint8_t nBasicUpdateCycle" DSL_CPE_CRLF
   "- DSL_uint8_t nFeUpdateCycleFactor" DSL_CPE_CRLF
   "- DSL_uint8_t nFeUpdateCycleFactorL2" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CONFIG_GET

   Long Form: PM_ConfigGet

   Short Form: pmcg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bNePollingOff

   \ref DSL_boolean_t bFePollingOff

   \ref DSL_uint8_t nBasicUpdateCycle

   \ref DSL_uint8_t nFeUpdateCycleFactor

   \ref DSL_uint8_t nFeUpdateCycleFactorL2


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ConfigGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_Config_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CONFIG_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"bNePollingOff=%d bFePollingOff=%d nBasicUpdateCycle=%hu nFeUpdateCycleFactor=%hu nFeUpdateCycleFactorL2=%hu" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.bNePollingOff, pData.data.bFePollingOff, pData.data.nBasicUpdateCycle, pData.data.nFeUpdateCycleFactor, pData.data.nFeUpdateCycleFactorL2);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) && defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG)

static const DSL_char_t g_sPmcs[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_boolean_t bNePollingOff" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_boolean_t bFePollingOff" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint8_t nBasicUpdateCycle" DSL_CPE_CRLF
   "- DSL_uint8_t nFeUpdateCycleFactor" DSL_CPE_CRLF
   "- DSL_uint8_t nFeUpdateCycleFactorL2" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_CONFIG_SET

   Long Form: PM_ConfigSet

   Short Form: pmcs

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_boolean_t bNePollingOff

   \ref DSL_boolean_t bFePollingOff

   \ref DSL_uint8_t nBasicUpdateCycle

   \ref DSL_uint8_t nFeUpdateCycleFactor

   \ref DSL_uint8_t nFeUpdateCycleFactorL2


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_ConfigSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_Config_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 5, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %d %bu %bu %bu", &pData.data.bNePollingOff, &pData.data.bFePollingOff, &pData.data.nBasicUpdateCycle, &pData.data.nFeUpdateCycleFactor, &pData.data.nFeUpdateCycleFactorL2);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_CONFIG_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmlesc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nLOS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOF" DSL_CPE_CRLF
   "- DSL_uint32_t nLPR" DSL_CPE_CRLF
   "- DSL_uint32_t nLOM" DSL_CPE_CRLF
   "- DSL_uint32_t nSosSuccess" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_15MIN_GET

   Long Form: PM_LineEventShowtimeCounters15MinGet

   Short Form: pmlesc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nLOS

   \ref DSL_uint32_t nLOF

   \ref DSL_uint32_t nLPR

   \ref DSL_uint32_t nLOM

   \ref DSL_uint32_t nSosSuccess


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineEventShowtimeCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nLOS=%u nLOF=%u nLPR=%u nLOM=%u nSosSuccess=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nLOS, pData.data.nLOF, pData.data.nLPR, pData.data.nLOM, pData.data.nSosSuccess);
   }

   return 0;
}


static const DSL_char_t g_sPmlesc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nLOS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOF" DSL_CPE_CRLF
   "- DSL_uint32_t nLPR" DSL_CPE_CRLF
   "- DSL_uint32_t nLOM" DSL_CPE_CRLF
   "- DSL_uint32_t nSosSuccess" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_1DAY_GET

   Long Form: PM_LineEventShowtimeCounters1DayGet

   Short Form: pmlesc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nLOS

   \ref DSL_uint32_t nLOF

   \ref DSL_uint32_t nLPR

   \ref DSL_uint32_t nLOM

   \ref DSL_uint32_t nSosSuccess


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineEventShowtimeCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nLOS=%u nLOF=%u nLPR=%u nLOM=%u nSosSuccess=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nLOS, pData.data.nLOF, pData.data.nLPR, pData.data.nLOM, pData.data.nSosSuccess);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmlescsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nLOS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOF" DSL_CPE_CRLF
   "- DSL_uint32_t nLPR" DSL_CPE_CRLF
   "- DSL_uint32_t nLOM" DSL_CPE_CRLF
   "- DSL_uint32_t nSosSuccess" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_SHOWTIME_GET

   Long Form: PM_LineEventShowtimeCountersShowtimeGet

   Short Form: pmlescsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nLOS

   \ref DSL_uint32_t nLOF

   \ref DSL_uint32_t nLPR

   \ref DSL_uint32_t nLOM

   \ref DSL_uint32_t nSosSuccess


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineEventShowtimeCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nLOS=%u nLOF=%u nLPR=%u nLOM=%u nSosSuccess=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nLOS, pData.data.nLOF, pData.data.nLPR, pData.data.nLOM, pData.data.nSosSuccess);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmlesctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nLOS" DSL_CPE_CRLF
   "- DSL_uint32_t nLOF" DSL_CPE_CRLF
   "- DSL_uint32_t nLPR" DSL_CPE_CRLF
   "- DSL_uint32_t nLOM" DSL_CPE_CRLF
   "- DSL_uint32_t nSosSuccess" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_TOTAL_GET

   Long Form: PM_LineEventShowtimeCountersTotalGet

   Short Form: pmlesctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nLOS

   \ref DSL_uint32_t nLOF

   \ref DSL_uint32_t nLPR

   \ref DSL_uint32_t nLOM

   \ref DSL_uint32_t nSosSuccess


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_LineEventShowtimeCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nElapsedTime=%u bValid=%d nLOS=%u nLOF=%u nLPR=%u nLOM=%u nSosSuccess=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nLOS, pData.data.nLOF, pData.data.nLPR, pData.data.nLOM, pData.data.nSosSuccess);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmleshs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_15MIN_GET

   Long Form: PM_LineEventShowtimeHistoryStats15MinGet

   Short Form: pmleshs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmleshs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_1DAY_GET

   Long Form: PM_LineEventShowtimeHistoryStats1DayGet

   Short Form: pmleshs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_LineEventShowtimeHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_LINE_EVENT_SHOWTIME_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmdpfc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nNCD" DSL_CPE_CRLF
   "- DSL_uint32_t nLCD" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_15MIN_GET

   Long Form: PM_DataPathFailureCounters15MinGet

   Short Form: pmdpfc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nNCD

   \ref DSL_uint32_t nLCD


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathFailureCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nNCD=%u nLCD=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nNCD, pData.data.nLCD);
   }

   return 0;
}


static const DSL_char_t g_sPmdpfc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nNCD" DSL_CPE_CRLF
   "- DSL_uint32_t nLCD" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_1DAY_GET

   Long Form: PM_DataPathFailureCounters1DayGet

   Short Form: pmdpfc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nNCD

   \ref DSL_uint32_t nLCD


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathFailureCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nNCD=%u nLCD=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nNCD, pData.data.nLCD);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmdpfcsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nNCD" DSL_CPE_CRLF
   "- DSL_uint32_t nLCD" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_SHOWTIME_GET

   Long Form: PM_DataPathFailureCountersShowtimeGet

   Short Form: pmdpfcsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nNCD

   \ref DSL_uint32_t nLCD


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathFailureCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 3, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d %u", &pData.nChannel, &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nNCD=%u nLCD=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nNCD, pData.data.nLCD);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmdpfctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nNCD" DSL_CPE_CRLF
   "- DSL_uint32_t nLCD" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_TOTAL_GET

   Long Form: PM_DataPathFailureCountersTotalGet

   Short Form: pmdpfctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nNCD

   \ref DSL_uint32_t nLCD


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_DataPathFailureCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nElapsedTime=%u bValid=%d nNCD=%u nLCD=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nNCD, pData.data.nLCD);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmdpfhs15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_15MIN_GET

   Long Form: PM_DataPathFailureHistoryStats15MinGet

   Short Form: pmdpfhs15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmdpfhs1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_uint8_t nChannel" DSL_CPE_CRLF
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_1DAY_GET

   Long Form: PM_DataPathFailureHistoryStats1DayGet

   Short Form: pmdpfhs1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_uint8_t nChannel

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_DataPathFailureHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsChDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%bu %d", &pData.nChannel, &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_DATA_PATH_FAILURE_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nChannel=%hu nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nChannel, pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)

static const DSL_char_t g_sPmrtc15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_COUNTERS_15MIN_GET

   Long Form: PM_ReTxCounters15MinGet

   Short Form: pmrtc15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxCounters15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_COUNTERS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}


static const DSL_char_t g_sPmrtc1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_COUNTERS_1DAY_GET

   Long Form: PM_ReTxCounters1DayGet

   Short Form: pmrtc1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxCounters1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_COUNTERS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)

static const DSL_char_t g_sPmrtcsg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nHistoryInterval" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_uint8_t nNumber" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_COUNTERS_SHOWTIME_GET

   Long Form: PM_ReTxCountersShowtimeGet

   Short Form: pmrtcsg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nHistoryInterval

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_uint8_t nNumber

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxCountersShowtimeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxCounters_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 2, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u", &pData.nDirection, &pData.nHistoryInterval);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_COUNTERS_SHOWTIME_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nHistoryInterval=%u nElapsedTime=%u nNumber=%hu bValid=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.nHistoryInterval, pData.interval.nElapsedTime, pData.interval.nNumber, pData.interval.bValid, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)

static const DSL_char_t g_sPmrtctg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nElapsedTime" DSL_CPE_CRLF
   "- DSL_boolean_t bValid" DSL_CPE_CRLF
   "   DSL_FALSE = 0" DSL_CPE_CRLF
   "   DSL_TRUE = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_COUNTERS_TOTAL_GET

   Long Form: PM_ReTxCountersTotalGet

   Short Form: pmrtctg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nElapsedTime

   \ref DSL_boolean_t bValid

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxCountersTotalGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxCountersTotal_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_COUNTERS_TOTAL_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nElapsedTime=%u bValid=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.total.nElapsedTime, pData.total.bValid, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmrths15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_HISTORY_STATS_15MIN_GET

   Long Form: PM_ReTxHistoryStats15MinGet

   Short Form: pmrths15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxHistoryStats15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_HISTORY_STATS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}


static const DSL_char_t g_sPmrths1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevIvs" DSL_CPE_CRLF
   "- DSL_uint32_t nPrevInvalidIvs" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_HISTORY_STATS_1DAY_GET

   Long Form: PM_ReTxHistoryStats1DayGet

   Short Form: pmrths1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nPrevIvs

   \ref DSL_uint32_t nPrevInvalidIvs


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxHistoryStats1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_HistoryStatsDir_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_HISTORY_STATS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nPrevIvs=%u nPrevInvalidIvs=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nPrevIvs, pData.data.nPrevInvalidIvs);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)

static const DSL_char_t g_sPmrtt15mg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_THRESHOLDS_15MIN_GET

   Long Form: PM_ReTxThresholds15MinGet

   Short Form: pmrtt15mg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxThresholds15MinGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_THRESHOLDS_15MIN_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}


static const DSL_char_t g_sPmrtt15ms[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_THRESHOLDS_15MIN_SET

   Long Form: PM_ReTxThresholds15MinSet

   Short Form: pmrtt15ms

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxThresholds15MinSet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 5, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u %u %u %u", &pData.nDirection, &pData.data.nRxCorruptedTotal, &pData.data.nRxUncorrectedProtected, &pData.data.nRxRetransmitted, &pData.data.nRxCorrected);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_THRESHOLDS_15MIN_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}


static const DSL_char_t g_sPmrtt1dg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_THRESHOLDS_1DAY_GET

   Long Form: PM_ReTxThresholds1DayGet

   Short Form: pmrtt1dg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxThresholds1DayGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 1, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d", &pData.nDirection);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_THRESHOLDS_1DAY_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d nRxCorruptedTotal=%u nRxUncorrectedProtected=%u nRxRetransmitted=%u nRxCorrected=%u" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection, pData.data.nRxCorruptedTotal, pData.data.nRxUncorrectedProtected, pData.data.nRxRetransmitted, pData.data.nRxCorrected);
   }

   return 0;
}


static const DSL_char_t g_sPmrtt1ds[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Input Parameter" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorruptedTotal" DSL_CPE_CRLF
   "- DSL_uint32_t nRxUncorrectedProtected" DSL_CPE_CRLF
   "- DSL_uint32_t nRxRetransmitted" DSL_CPE_CRLF
   "- DSL_uint32_t nRxCorrected" DSL_CPE_CRLF
   DSL_CPE_CRLF
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_XTUDir_t nDirection" DSL_CPE_CRLF
   "   DSL_NEAR_END = 0" DSL_CPE_CRLF
   "   DSL_FAR_END = 1" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_RETX_THRESHOLDS_1DAY_SET

   Long Form: PM_ReTxThresholds1DaySet

   Short Form: pmrtt1ds

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection

   \ref DSL_uint32_t nRxCorruptedTotal

   \ref DSL_uint32_t nRxUncorrectedProtected

   \ref DSL_uint32_t nRxRetransmitted

   \ref DSL_uint32_t nRxCorrected


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_XTUDir_t nDirection


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_RetxThresholds1DaySet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_ReTxThreshold_t pData;

   if (DSL_CPE_CLI_CheckParamNumber(pCommands, 5, DSL_CLI_EQUALS) == DSL_FALSE)
   {
      return -1;
   }

   DSL_CPE_sscanf (pCommands, "%d %u %u %u %u", &pData.nDirection, &pData.data.nRxCorruptedTotal, &pData.data.nRxUncorrectedProtected, &pData.data.nRxRetransmitted, &pData.data.nRxCorrected);

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_RETX_THRESHOLDS_1DAY_SET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nDirection=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.nDirection);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) && defined(INCLUDE_DSL_CONFIG_GET)

static const DSL_char_t g_sPmsmg[] =
#ifndef DSL_CPE_DEBUG_DISABLE
   "Long Form: %s" DSL_CPE_CRLF
   "Short Form: %s" DSL_CPE_CRLF
   DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "Input Parameter" DSL_CPE_CRLF
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
   DSL_CPE_CRLF
#endif
   "Output Parameter" DSL_CPE_CRLF
   "- DSL_Error_t nReturn" DSL_CPE_CRLF
#if (DSL_CPE_MAX_DEVICE_NUMBER > 1)
   "- DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)" DSL_CPE_CRLF
#endif
   "- DSL_PM_SyncModeType_t nMode" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_FREE = 0" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_SYS_TIME = 1" DSL_CPE_CRLF
   "   DSL_PM_SYNC_MODE_EXTERNAL = 2" DSL_CPE_CRLF
   DSL_CPE_CRLF "";
#else
   "";
#endif

/**
   CLI command for IOCTL: \ref DSL_FIO_PM_SYNC_MODE_GET

   Long Form: PM_SyncModeGet

   Short Form: pmsmg

   Input Parameter

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)


   Output Parameter

   \ref DSL_Error_t nReturn

   \ref DSL_uint32_t nDevice (optional, not used in the 'backward compatible' mode)

   \ref DSL_PM_SyncModeType_t nMode


   \param fd - device file descriptor
   \param pCommands - input CLI command parameter(s)
   \param out - output CLI command parameter(s)

   \ingroup DSL_CPE_CLI
*/
DSL_CLI_LOCAL DSL_int_t DSL_CPE_CLI_PM_SyncModeGet(
   DSL_int_t fd,
   DSL_char_t *pCommands,
   DSL_CPE_File_t *out)
{
   DSL_int_t ret = 0;
   DSL_PM_SyncMode_t pData;

   ret = DSL_CPE_Ioctl (fd, DSL_FIO_PM_SYNC_MODE_GET, (int) &pData);

   if ((ret < 0) && (pData.accessCtl.nReturn < DSL_SUCCESS))
   {
      DSL_CPE_FPrintf (out, sFailureReturn, DSL_CPE_RET_VAL(pData.accessCtl.nReturn));
   }
   else
   {
      DSL_CPE_FPrintf(out, DSL_CPE_RET"nMode=%d" DSL_CPE_CRLF, DSL_CPE_RET_VAL(pData.accessCtl.nReturn), pData.data.nMode);
   }

   return 0;
}

#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) && defined(INCLUDE_DSL_CONFIG_GET) */

/** Register autogenerated commands */

DSL_void_t DSL_CPE_CLI_AutogenCommandsRegister (DSL_void_t)
{
   /* Common functionalities */
   DSL_CPE_CLI_CMD_ADD_COMM ("acs", "AutobootControlSet", DSL_CPE_CLI_AutobootControlSet, g_sAcs);
   DSL_CPE_CLI_CMD_ADD_COMM ("asg", "AutobootStatusGet", DSL_CPE_CLI_AutobootStatusGet, g_sAsg);
   DSL_CPE_CLI_CMD_ADD_COMM ("lsg", "LineStateGet", DSL_CPE_CLI_LineStateGet, g_sLsg);
   DSL_CPE_CLI_CMD_ADD_COMM ("lfcs", "LineFeatureConfigSet", DSL_CPE_CLI_LineFeatureConfigSet, g_sLfcs);
#if defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("lfcg", "LineFeatureConfigGet", DSL_CPE_CLI_LineFeatureConfigGet, g_sLfcg);
#endif /* defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("lfsg", "LineFeatureStatusGet", DSL_CPE_CLI_LineFeatureStatusGet, g_sLfsg);
#if defined(INCLUDE_DSL_FRAMING_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("fpsg", "FramingParameterStatusGet", DSL_CPE_CLI_FramingParameterStatusGet, g_sFpsg);
#endif /* defined(INCLUDE_DSL_FRAMING_PARAMETERS) */

#if !defined(DSL_CPE_DEBUG_DISABLE)
   DSL_CPE_CLI_CMD_ADD_COMM ("dmls", "DbgModuleLevelSet", DSL_CPE_CLI_DBG_ModuleLevelSet, g_sDmls);
   DSL_CPE_CLI_CMD_ADD_COMM ("dmlg", "DbgModuleLevelGet", DSL_CPE_CLI_DBG_ModuleLevelGet, g_sDmlg);
#endif /* !defined(DSL_CPE_DEBUG_DISABLE) */
   DSL_CPE_CLI_CMD_ADD_COMM ("tmcs", "TestModeControlSet", DSL_CPE_CLI_TestModeControlSet, g_sTmcs);
#if defined(INCLUDE_DSL_SYSTEM_INTERFACE)
   DSL_CPE_CLI_CMD_ADD_COMM ("sics", "SystemInterfaceConfigSet", DSL_CPE_CLI_SystemInterfaceConfigSet, g_sSics);
#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) */

#if defined(INCLUDE_DSL_SYSTEM_INTERFACE) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("sicg", "SystemInterfaceConfigGet", DSL_CPE_CLI_SystemInterfaceConfigGet, g_sSicg);
#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) && defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("esmcs", "EventStatusMaskConfigSet", DSL_CPE_CLI_EventStatusMaskConfigSet, g_sEsmcs);
#if defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("esmcg", "EventStatusMaskConfigGet", DSL_CPE_CLI_EventStatusMaskConfigGet, g_sEsmcg);
#endif /* defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("tmsg", "TestModeStatusGet", DSL_CPE_CLI_TestModeStatusGet, g_sTmsg);
#if defined(INCLUDE_DSL_SYSTEM_INTERFACE)
   DSL_CPE_CLI_CMD_ADD_COMM ("sisg", "SystemInterfaceStatusGet", DSL_CPE_CLI_SystemInterfaceStatusGet, g_sSisg);
#endif /* defined(INCLUDE_DSL_SYSTEM_INTERFACE) */
   DSL_CPE_CLI_CMD_ADD_COMM ("isg", "InstanceStatusGet", DSL_CPE_CLI_InstanceStatusGet, g_sIsg);
#if defined(INCLUDE_DSL_CPE_MISC_LINE_STATUS)
   DSL_CPE_CLI_CMD_ADD_COMM ("mlsg", "MiscLineStatusGet", DSL_CPE_CLI_MiscLineStatusGet, g_sMlsg);
#endif /* defined(INCLUDE_DSL_CPE_MISC_LINE_STATUS) */
   DSL_CPE_CLI_CMD_ADD_COMM ("locs", "LineOptionsConfigSet", DSL_CPE_CLI_LineOptionsConfigSet, g_sLocs);
#if defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("locg", "LineOptionsConfigGet", DSL_CPE_CLI_LineOptionsConfigGet, g_sLocg);
#endif /* defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lacs", "G997_LineActivateConfigSet", DSL_CPE_CLI_G997LineActivateConfigSet, g_sG997lacs);
#if defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lacg", "G997_LineActivateConfigGet", DSL_CPE_CLI_G997LineActivateConfigGet, g_sG997lacg);
#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_G997_ALARM)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997cdrtcs", "G997_ChannelDataRateThresholdConfigSet", DSL_CPE_CLI_G997ChannelDataRateThresholdConfigSet, g_sG997cdrtcs);
#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997cdrtcg", "G997_ChannelDataRateThresholdConfigGet", DSL_CPE_CLI_G997ChannelDataRateThresholdConfigGet, g_sG997cdrtcg);
#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997ltsg", "G997_LineTransmissionStatusGet", DSL_CPE_CLI_G997LineTransmissionStatusGet, g_sG997ltsg);
#if defined(INCLUDE_DSL_G997_STATUS)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lisg", "G997_LineInitStatusGet", DSL_CPE_CLI_G997LineInitStatusGet, g_sG997lisg);
#endif /* defined(INCLUDE_DSL_G997_STATUS) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lsg", "G997_LineStatusGet", DSL_CPE_CLI_G997LineStatusGet, g_sG997lsg);
   DSL_CPE_CLI_CMD_ADD_COMM ("g997csg", "G997_ChannelStatusGet", DSL_CPE_CLI_G997ChannelStatusGet, g_sG997csg);
   DSL_CPE_CLI_CMD_ADD_COMM ("g997pmsft", "G997_PowerManagementStateForcedTrigger", DSL_CPE_CLI_G997PowerManagementStateForcedTrigger, g_sG997pmsft);
   DSL_CPE_CLI_CMD_ADD_COMM ("g997pmsg", "G997_PowerManagementStatusGet", DSL_CPE_CLI_G997PowerManagementStatusGet, g_sG997pmsg);
#if defined(INCLUDE_DSL_G997_STATUS)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lstg", "G997_LastStateTransmittedGet", DSL_CPE_CLI_G997LastStateTransmittedGet, g_sG997lstg);
#endif /* defined(INCLUDE_DSL_G997_STATUS) */

#if defined(INCLUDE_DSL_G997_ALARM)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997amlfcs", "G997_AlarmMaskLineFailuresConfigSet", DSL_CPE_CLI_G997AlarmMaskLineFailuresConfigSet, g_sG997amlfcs);
#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997amlfcg", "G997_AlarmMaskLineFailuresConfigGet", DSL_CPE_CLI_G997AlarmMaskLineFailuresConfigGet, g_sG997amlfcg);
#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997lfsg", "G997_LineFailuresStatusGet", DSL_CPE_CLI_G997LineFailuresStatusGet, g_sG997lfsg);
#if defined(INCLUDE_DSL_G997_ALARM)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997amdpfcs", "G997_AlarmMaskDataPathFailuresConfigSet", DSL_CPE_CLI_G997AlarmMaskDataPathFailuresConfigSet, g_sG997amdpfcs);
#endif /* defined(INCLUDE_DSL_G997_ALARM) */

#if defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997amdpfcg", "G997_AlarmMaskDataPathFailuresConfigGet", DSL_CPE_CLI_G997AlarmMaskDataPathFailuresConfigGet, g_sG997amdpfcg);
#endif /* defined(INCLUDE_DSL_G997_ALARM) && defined(INCLUDE_DSL_CONFIG_GET) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997dpfsg", "G997_DataPathFailuresStatusGet", DSL_CPE_CLI_G997DataPathFailuresStatusGet, g_sG997dpfsg);
#if defined(INCLUDE_DSL_G997_FRAMING_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997fpsg", "G997_FramingParameterStatusGet", DSL_CPE_CLI_G997FramingParameterStatusGet, g_sG997fpsg);
#endif /* defined(INCLUDE_DSL_G997_FRAMING_PARAMETERS) */

#if defined(INCLUDE_DSL_DELT)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997dhsg", "G997_DeltHlinScaleGet", DSL_CPE_CLI_G997DeltHlinScaleGet, g_sG997dhsg);
   DSL_CPE_CLI_CMD_ADD_COMM ("g997dfr", "G997_DeltFreeResources", DSL_CPE_CLI_G997DeltFreeResources, g_sG997dfr);
#endif /* defined(INCLUDE_DSL_DELT) */
   DSL_CPE_CLI_CMD_ADD_COMM ("g997racs", "G997_RateAdaptationConfigSet", DSL_CPE_CLI_G997RateAdaptationConfigSet, g_sG997racs);
#if defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("g997racg", "G997_RateAdaptationConfigGet", DSL_CPE_CLI_G997RateAdaptationConfigGet, g_sG997racg);
#endif /* defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlshs15mg", "PM_LineSecHistoryStats15MinGet", DSL_CPE_CLI_PM_LineSecHistoryStats15MinGet, g_sPmlshs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlshs1dg", "PM_LineSecHistoryStats1DayGet", DSL_CPE_CLI_PM_LineSecHistoryStats1DayGet, g_sPmlshs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlsc15mg", "PM_LineSecCounters15MinGet", DSL_CPE_CLI_PM_LineSecCounters15MinGet, g_sPmlsc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlsc1dg", "PM_LineSecCounters1DayGet", DSL_CPE_CLI_PM_LineSecCounters1DayGet, g_sPmlsc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlsctg", "PM_LineSecCountersTotalGet", DSL_CPE_CLI_PM_LineSecCountersTotalGet, g_sPmlsctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlst15ms", "PM_LineSecThresholds15MinSet", DSL_CPE_CLI_PM_LineSecThresholds15MinSet, g_sPmlst15ms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlst1ds", "PM_LineSecThresholds1DaySet", DSL_CPE_CLI_PM_LineSecThresholds1DaySet, g_sPmlst1ds);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlst15mg", "PM_LineSecThresholds15MinGet", DSL_CPE_CLI_PM_LineSecThresholds15MinGet, g_sPmlst15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlst1dg", "PM_LineSecThresholds1DayGet", DSL_CPE_CLI_PM_LineSecThresholds1DayGet, g_sPmlst1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlihs15mg", "PM_LineInitHistoryStats15MinGet", DSL_CPE_CLI_PM_LineInitHistoryStats15MinGet, g_sPmlihs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlihs1dg", "PM_LineInitHistoryStats1DayGet", DSL_CPE_CLI_PM_LineInitHistoryStats1DayGet, g_sPmlihs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlic15mg", "PM_LineInitCounters15MinGet", DSL_CPE_CLI_PM_LineInitCounters15MinGet, g_sPmlic15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlic1dg", "PM_LineInitCounters1DayGet", DSL_CPE_CLI_PM_LineInitCounters1DayGet, g_sPmlic1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlictg", "PM_LineInitCountersTotalGet", DSL_CPE_CLI_PM_LineInitCountersTotalGet, g_sPmlictg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlit15ms", "PM_LineInitThresholds15MinSet", DSL_CPE_CLI_PM_LineInitThresholds15MinSet, g_sPmlit15ms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlit1ds", "PM_LineInitThresholds1DaySet", DSL_CPE_CLI_PM_LineInitThresholds1DaySet, g_sPmlit1ds);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlit15mg", "PM_LineInitThresholds15MinGet", DSL_CPE_CLI_PM_LineInitThresholds15MinGet, g_sPmlit15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlit1dg", "PM_LineInitThresholds1DayGet", DSL_CPE_CLI_PM_LineInitThresholds1DayGet, g_sPmlit1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_LINE_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmchs15mg", "PM_ChannelHistoryStats15MinGet", DSL_CPE_CLI_PM_ChannelHistoryStats15MinGet, g_sPmchs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmchs1dg", "PM_ChannelHistoryStats1DayGet", DSL_CPE_CLI_PM_ChannelHistoryStats1DayGet, g_sPmchs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmcc15mg", "PM_ChannelCounters15MinGet", DSL_CPE_CLI_PM_ChannelCounters15MinGet, g_sPmcc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmcc1dg", "PM_ChannelCounters1DayGet", DSL_CPE_CLI_PM_ChannelCounters1DayGet, g_sPmcc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmcctg", "PM_ChannelCountersTotalGet", DSL_CPE_CLI_PM_ChannelCountersTotalGet, g_sPmcctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmct15ms", "PM_ChannelThresholds15MinSet", DSL_CPE_CLI_PM_ChannelThresholds15MinSet, g_sPmct15ms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmct1ds", "PM_ChannelThresholds1DaySet", DSL_CPE_CLI_PM_ChannelThresholds1DaySet, g_sPmct1ds);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmct15mg", "PM_ChannelThresholds15MinGet", DSL_CPE_CLI_PM_ChannelThresholds15MinGet, g_sPmct15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmct1dg", "PM_ChannelThresholds1DayGet", DSL_CPE_CLI_PM_ChannelThresholds1DayGet, g_sPmct1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdphs15mg", "PM_DataPathHistoryStats15MinGet", DSL_CPE_CLI_PM_DataPathHistoryStats15MinGet, g_sPmdphs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdphs1dg", "PM_DataPathHistoryStats1DayGet", DSL_CPE_CLI_PM_DataPathHistoryStats1DayGet, g_sPmdphs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpc15mg", "PM_DataPathCounters15MinGet", DSL_CPE_CLI_PM_DataPathCounters15MinGet, g_sPmdpc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpc1dg", "PM_DataPathCounters1DayGet", DSL_CPE_CLI_PM_DataPathCounters1DayGet, g_sPmdpc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpctg", "PM_DataPathCountersTotalGet", DSL_CPE_CLI_PM_DataPathCountersTotalGet, g_sPmdpctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpt15ms", "PM_DataPathThresholds15MinSet", DSL_CPE_CLI_PM_DataPathThresholds15MinSet, g_sPmdpt15ms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpt1ds", "PM_DataPathThresholds1DaySet", DSL_CPE_CLI_PM_DataPathThresholds1DaySet, g_sPmdpt1ds);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpt15mg", "PM_DataPathThresholds15MinGet", DSL_CPE_CLI_PM_DataPathThresholds15MinGet, g_sPmdpt15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpt1dg", "PM_DataPathThresholds1DayGet", DSL_CPE_CLI_PM_DataPathThresholds1DayGet, g_sPmdpt1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pm15meet", "PM_15MinElapsedExtTrigger", DSL_CPE_CLI_PM_15MinElapsedExtTrigger, g_sPm15meet);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmetr", "PM_ElapsedTimeReset", DSL_CPE_CLI_PM_ElapsedTimeReset, g_sPmetr);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmsms", "PM_SyncModeSet", DSL_CPE_CLI_PM_SyncModeSet, g_sPmsms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmbms", "PM_BurninModeSet", DSL_CPE_CLI_PM_BurninModeSet, g_sPmbms);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlscsg", "PM_LineSecCountersShowtimeGet", DSL_CPE_CLI_PM_LineSecCountersShowtimeGet, g_sPmlscsg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlicsg", "PM_LineInitCountersShowtimeGet", DSL_CPE_CLI_PM_LineInitCountersShowtimeGet, g_sPmlicsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmccsg", "PM_ChannelCountersShowtimeGet", DSL_CPE_CLI_PM_ChannelCountersShowtimeGet, g_sPmccsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CHANNEL_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpcsg", "PM_DataPathCountersShowtimeGet", DSL_CPE_CLI_PM_DataPathCountersShowtimeGet, g_sPmdpcsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmcg", "PM_ConfigGet", DSL_CPE_CLI_PM_ConfigGet, g_sPmcg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) && defined(INCLUDE_DSL_CONFIG_GET) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmcs", "PM_ConfigSet", DSL_CPE_CLI_PM_ConfigSet, g_sPmcs);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_CONFIG) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlesc15mg", "PM_LineEventShowtimeCounters15MinGet", DSL_CPE_CLI_PM_LineEventShowtimeCounters15MinGet, g_sPmlesc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlesc1dg", "PM_LineEventShowtimeCounters1DayGet", DSL_CPE_CLI_PM_LineEventShowtimeCounters1DayGet, g_sPmlesc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlescsg", "PM_LineEventShowtimeCountersShowtimeGet", DSL_CPE_CLI_PM_LineEventShowtimeCountersShowtimeGet, g_sPmlescsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmlesctg", "PM_LineEventShowtimeCountersTotalGet", DSL_CPE_CLI_PM_LineEventShowtimeCountersTotalGet, g_sPmlesctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmleshs15mg", "PM_LineEventShowtimeHistoryStats15MinGet", DSL_CPE_CLI_PM_LineEventShowtimeHistoryStats15MinGet, g_sPmleshs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmleshs1dg", "PM_LineEventShowtimeHistoryStats1DayGet", DSL_CPE_CLI_PM_LineEventShowtimeHistoryStats1DayGet, g_sPmleshs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_LINE_EVENT_SHOWTIME_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfc15mg", "PM_DataPathFailureCounters15MinGet", DSL_CPE_CLI_PM_DataPathFailureCounters15MinGet, g_sPmdpfc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfc1dg", "PM_DataPathFailureCounters1DayGet", DSL_CPE_CLI_PM_DataPathFailureCounters1DayGet, g_sPmdpfc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfcsg", "PM_DataPathFailureCountersShowtimeGet", DSL_CPE_CLI_PM_DataPathFailureCountersShowtimeGet, g_sPmdpfcsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfctg", "PM_DataPathFailureCountersTotalGet", DSL_CPE_CLI_PM_DataPathFailureCountersTotalGet, g_sPmdpfctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfhs15mg", "PM_DataPathFailureHistoryStats15MinGet", DSL_CPE_CLI_PM_DataPathFailureHistoryStats15MinGet, g_sPmdpfhs15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmdpfhs1dg", "PM_DataPathFailureHistoryStats1DayGet", DSL_CPE_CLI_PM_DataPathFailureHistoryStats1DayGet, g_sPmdpfhs1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_DATA_PATH_FAILURE_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtc15mg", "PM_ReTxCounters15MinGet", DSL_CPE_CLI_PM_RetxCounters15MinGet, g_sPmrtc15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtc1dg", "PM_ReTxCounters1DayGet", DSL_CPE_CLI_PM_RetxCounters1DayGet, g_sPmrtc1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtcsg", "PM_ReTxCountersShowtimeGet", DSL_CPE_CLI_PM_RetxCountersShowtimeGet, g_sPmrtcsg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_SHOWTIME_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtctg", "PM_ReTxCountersTotalGet", DSL_CPE_CLI_PM_RetxCountersTotalGet, g_sPmrtctg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_TOTAL_COUNTERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrths15mg", "PM_ReTxHistoryStats15MinGet", DSL_CPE_CLI_PM_RetxHistoryStats15MinGet, g_sPmrths15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrths1dg", "PM_ReTxHistoryStats1DayGet", DSL_CPE_CLI_PM_RetxHistoryStats1DayGet, g_sPmrths1dg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_HISTORY) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtt15mg", "PM_ReTxThresholds15MinGet", DSL_CPE_CLI_PM_RetxThresholds15MinGet, g_sPmrtt15mg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtt15ms", "PM_ReTxThresholds15MinSet", DSL_CPE_CLI_PM_RetxThresholds15MinSet, g_sPmrtt15ms);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtt1dg", "PM_ReTxThresholds1DayGet", DSL_CPE_CLI_PM_RetxThresholds1DayGet, g_sPmrtt1dg);
   DSL_CPE_CLI_CMD_ADD_COMM ("pmrtt1ds", "PM_ReTxThresholds1DaySet", DSL_CPE_CLI_PM_RetxThresholds1DaySet, g_sPmrtt1ds);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_RETX_COUNTERS) && defined(INCLUDE_DSL_CPE_PM_RETX_THRESHOLDS) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) */

#if defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) && defined(INCLUDE_DSL_CONFIG_GET)
   DSL_CPE_CLI_CMD_ADD_COMM ("pmsmg", "PM_SyncModeGet", DSL_CPE_CLI_PM_SyncModeGet, g_sPmsmg);
#endif /* defined(INCLUDE_DSL_PM) && defined(INCLUDE_DSL_CPE_PM_OPTIONAL_PARAMETERS) && defined(INCLUDE_DSL_CONFIG_GET) */

}

#endif /* INCLUDE_DSL_CPE_CLI_SUPPORT */
