# Use --define 'nossl 1' on the command line to disable SSL detection
%{!?nossl:%define SSL 1}
%{?nossl:%define SSL 0}

%define name curl
%define version -
%define release 1%{!?nossl:ssl}

%define curlroot %{_builddir}/%{name}-%{version}

Summary: get a file from a FTP or HTTP server.
Name: %{name}
Version: %{version}
Release: %{release}
License: MIT/X derivate
Vendor: Daniel Stenberg <Daniel.Stenberg@haxx.se>
Group: Applications/Internet
Source: %{name}-%{version}.tar.bz2
URL: https://curl.haxx.se/
Provides: curl
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prefix: %{_prefix}

%description
curl is a client to get documents/files from servers, using any of the
supported protocols.  The command is designed to work without user
interaction or any kind of interactivity.

curl offers many useful tricks like proxy support, user authentication,
ftp upload, HTTP post, file transfer resume and more.

%if %{SSL} == 1
Note: this version is compiled with SSL support.
%else
Note: this version is compiled without SSL support.
%endif

%package	devel
Summary:	Development files for the curl libary
Group:		Development/Libraries
%if %{SSL} == 1
Requires: openssl >= 0.9.5
%endif
Requires:	curl = %{version}
Provides:	curl-devel

%description devel
libcurl is the core engine of curl; this packages contains all the
libs, headers, and manual pages to develop applications using libcurl.

%define DEFCC xlc

%prep
rm -rf %{curlroot}
%setup -q

%build

# Use the default compiler for this platform - gcc otherwise
if [[ -z "$CC" ]]
then
    if test "X`type %{DEFCC} 2>/dev/null`" != 'X'; then
       export CC=%{DEFCC}
    else
       export CC=gcc
    fi
fi

cd %{curlroot} && (if [ -f configure.in ]; then mv -f configure.in configure.in.
rpm; fi)

./configure --prefix=%{prefix} \
%if %{SSL} == 1
        --with-ssl
%else
        --without-ssl
%endif

make

%install
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}
make DESTDIR=%{buildroot} install-strip

( cd $RPM_BUILD_ROOT   # same as %{buildroot}

 for dir in bin include
 do
    mkdir -p usr/$dir
    cd usr/$dir
    ln -sf ../..%{prefix}/$dir/* .
    cd -
 done

 mkdir -p usr/lib
 cd usr/lib
 ln -sf ../..%{prefix}/lib/* .
 cd -
)

%clean
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}

%files
%defattr(-,root,root)
%attr(0755,root,root) %{_bindir}/curl
%attr(0644,root,root) %{_mandir}/man1/curl.1*
%attr(0644,root,root) %{_mandir}/man1/mk-ca-bundle.1
%{_libdir}/libcurl.a
%if %{SSL} == 1
%{_datadir}/curl/curl-ca-bundle.crt
%endif
%doc CHANGES COPYING README RELEASE-NOTES
%doc docs/BUGS docs/CONTRIBUTE docs/FAQ docs/FEATURES docs/HISTORY
%doc docs/INSTALL docs/KNOWN_BUGS
%doc docs/MANUAL docs/RESOURCES docs/THANKS docs/VERSIONS docs/TODO
%doc docs/TheArtOfHttpScripting
%if %{SSL} == 1
%doc docs/SSLCERTS
%endif
/usr/bin/curl
/usr/lib/libcurl.a

%files devel
%defattr(-,root,root)
%attr(0755,root,root) %{_bindir}/curl-config
%attr(0644,root,root) %{_mandir}/man1/curl-config.1*
%attr(0644,root,root) %{_mandir}/man1/mk-ca-bundle.1
%attr(0644,root,root) %{_mandir}/man3/*
%attr(0644,root,root) %{_includedir}/curl/*
%{_libdir}/libcurl.la
%doc docs/BINDINGS docs/INTERNALS docs/LICENSE-MIXING
/usr/bin/curl-config
/usr/include/curl
