/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.48
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _CLKCTRL_H
#define _CLKCTRL_H  1

#include "regs.h"

#ifndef REGS_CLKCTRL_BASE
#define REGS_CLKCTRL_BASE (REGS_BASE + 0x40000)
#endif

/*
 * HW_CLKCTRL_PLL0CTRL0 - System PLL0, System/USB0 PLL Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1       : 17;
        unsigned POWER        :  1;
        unsigned EN_USB_CLKS  :  1;
        unsigned RSRVD3       :  1;
        unsigned DIV_SEL      :  2;
        unsigned RSRVD4       :  2;
        unsigned CP_SEL       :  2;
        unsigned RSRVD5       :  2;
        unsigned LFR_SEL      :  2;
        unsigned RSRVD6       :  2;
    } B;
} hw_clkctrl_pll0ctrl0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_PLL0CTRL0 register
 */
#define HW_CLKCTRL_PLL0CTRL0_ADDR         (REGS_CLKCTRL_BASE + 0x0)
#define HW_CLKCTRL_PLL0CTRL0_SET_ADDR     (HW_CLKCTRL_PLL0CTRL0_ADDR + 4)
#define HW_CLKCTRL_PLL0CTRL0_CLR_ADDR     (HW_CLKCTRL_PLL0CTRL0_ADDR + 8)
#define HW_CLKCTRL_PLL0CTRL0_TOG_ADDR     (HW_CLKCTRL_PLL0CTRL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLL0CTRL0           (*(volatile hw_clkctrl_pll0ctrl0_t *) HW_CLKCTRL_PLL0CTRL0_ADDR)
#define HW_CLKCTRL_PLL0CTRL0_RD()      (HW_CLKCTRL_PLL0CTRL0.U)
#define HW_CLKCTRL_PLL0CTRL0_WR(v)     (HW_CLKCTRL_PLL0CTRL0.U = (v))
#define HW_CLKCTRL_PLL0CTRL0_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL0CTRL0_SET_ADDR) = (v))
#define HW_CLKCTRL_PLL0CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL0CTRL0_CLR_ADDR) = (v))
#define HW_CLKCTRL_PLL0CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL0CTRL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_PLL0CTRL0 bitfields
 */
/* --- Register HW_CLKCTRL_PLL0CTRL0, field RSRVD6 */

#define BP_CLKCTRL_PLL0CTRL0_RSRVD6      30
#define BM_CLKCTRL_PLL0CTRL0_RSRVD6      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLL0CTRL0_RSRVD6(v)   ((((reg32_t) v) << 30) & BM_CLKCTRL_PLL0CTRL0_RSRVD6)
#else
#define BF_CLKCTRL_PLL0CTRL0_RSRVD6(v)   (((v) << 30) & BM_CLKCTRL_PLL0CTRL0_RSRVD6)
#endif
/* --- Register HW_CLKCTRL_PLL0CTRL0, field LFR_SEL */

#define BP_CLKCTRL_PLL0CTRL0_LFR_SEL      28
#define BM_CLKCTRL_PLL0CTRL0_LFR_SEL      0x30000000

#define BF_CLKCTRL_PLL0CTRL0_LFR_SEL(v)   (((v) << 28) & BM_CLKCTRL_PLL0CTRL0_LFR_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL0_LFR_SEL(v)   BF_CS1(CLKCTRL_PLL0CTRL0, LFR_SEL, v)
#endif

#define BV_CLKCTRL_PLL0CTRL0_LFR_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL0CTRL0_LFR_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLL0CTRL0_LFR_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLL0CTRL0_LFR_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL0CTRL0, field RSRVD5 */

#define BP_CLKCTRL_PLL0CTRL0_RSRVD5      26
#define BM_CLKCTRL_PLL0CTRL0_RSRVD5      0x0C000000

#define BF_CLKCTRL_PLL0CTRL0_RSRVD5(v)   (((v) << 26) & BM_CLKCTRL_PLL0CTRL0_RSRVD5)
/* --- Register HW_CLKCTRL_PLL0CTRL0, field CP_SEL */

#define BP_CLKCTRL_PLL0CTRL0_CP_SEL      24
#define BM_CLKCTRL_PLL0CTRL0_CP_SEL      0x03000000

#define BF_CLKCTRL_PLL0CTRL0_CP_SEL(v)   (((v) << 24) & BM_CLKCTRL_PLL0CTRL0_CP_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL0_CP_SEL(v)   BF_CS1(CLKCTRL_PLL0CTRL0, CP_SEL, v)
#endif

#define BV_CLKCTRL_PLL0CTRL0_CP_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL0CTRL0_CP_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLL0CTRL0_CP_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLL0CTRL0_CP_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL0CTRL0, field RSRVD4 */

#define BP_CLKCTRL_PLL0CTRL0_RSRVD4      22
#define BM_CLKCTRL_PLL0CTRL0_RSRVD4      0x00C00000

#define BF_CLKCTRL_PLL0CTRL0_RSRVD4(v)   (((v) << 22) & BM_CLKCTRL_PLL0CTRL0_RSRVD4)
/* --- Register HW_CLKCTRL_PLL0CTRL0, field DIV_SEL */

#define BP_CLKCTRL_PLL0CTRL0_DIV_SEL      20
#define BM_CLKCTRL_PLL0CTRL0_DIV_SEL      0x00300000

#define BF_CLKCTRL_PLL0CTRL0_DIV_SEL(v)   (((v) << 20) & BM_CLKCTRL_PLL0CTRL0_DIV_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL0_DIV_SEL(v)   BF_CS1(CLKCTRL_PLL0CTRL0, DIV_SEL, v)
#endif

#define BV_CLKCTRL_PLL0CTRL0_DIV_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL0CTRL0_DIV_SEL__LOWER      0x1
#define BV_CLKCTRL_PLL0CTRL0_DIV_SEL__LOWEST     0x2
#define BV_CLKCTRL_PLL0CTRL0_DIV_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL0CTRL0, field RSRVD3 */

#define BP_CLKCTRL_PLL0CTRL0_RSRVD3      19
#define BM_CLKCTRL_PLL0CTRL0_RSRVD3      0x00080000

#define BF_CLKCTRL_PLL0CTRL0_RSRVD3(v)   (((v) << 19) & BM_CLKCTRL_PLL0CTRL0_RSRVD3)
/* --- Register HW_CLKCTRL_PLL0CTRL0, field EN_USB_CLKS */

#define BP_CLKCTRL_PLL0CTRL0_EN_USB_CLKS      18
#define BM_CLKCTRL_PLL0CTRL0_EN_USB_CLKS      0x00040000

#define BF_CLKCTRL_PLL0CTRL0_EN_USB_CLKS(v)   (((v) << 18) & BM_CLKCTRL_PLL0CTRL0_EN_USB_CLKS)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL0_EN_USB_CLKS(v)   BF_CS1(CLKCTRL_PLL0CTRL0, EN_USB_CLKS, v)
#endif

/* --- Register HW_CLKCTRL_PLL0CTRL0, field POWER */

#define BP_CLKCTRL_PLL0CTRL0_POWER      17
#define BM_CLKCTRL_PLL0CTRL0_POWER      0x00020000

#define BF_CLKCTRL_PLL0CTRL0_POWER(v)   (((v) << 17) & BM_CLKCTRL_PLL0CTRL0_POWER)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL0_POWER(v)   BF_CS1(CLKCTRL_PLL0CTRL0, POWER, v)
#endif

/* --- Register HW_CLKCTRL_PLL0CTRL0, field RSRVD1 */

#define BP_CLKCTRL_PLL0CTRL0_RSRVD1      0
#define BM_CLKCTRL_PLL0CTRL0_RSRVD1      0x0001FFFF

#define BF_CLKCTRL_PLL0CTRL0_RSRVD1(v)   (((v) << 0) & BM_CLKCTRL_PLL0CTRL0_RSRVD1)


/*
 * HW_CLKCTRL_PLL0CTRL1 - System PLL0, System/USB0 PLL Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOCK_COUNT  : 16;
        unsigned RSRVD1      : 14;
        unsigned FORCE_LOCK  :  1;
        unsigned LOCK        :  1;
    } B;
} hw_clkctrl_pll0ctrl1_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_PLL0CTRL1 register
 */
#define HW_CLKCTRL_PLL0CTRL1_ADDR         (REGS_CLKCTRL_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLL0CTRL1           (*(volatile hw_clkctrl_pll0ctrl1_t *) HW_CLKCTRL_PLL0CTRL1_ADDR)
#define HW_CLKCTRL_PLL0CTRL1_RD()      (HW_CLKCTRL_PLL0CTRL1.U)
#define HW_CLKCTRL_PLL0CTRL1_WR(v)     (HW_CLKCTRL_PLL0CTRL1.U = (v))
#define HW_CLKCTRL_PLL0CTRL1_SET(v)    (HW_CLKCTRL_PLL0CTRL1_WR(HW_CLKCTRL_PLL0CTRL1_RD() |  (v)))
#define HW_CLKCTRL_PLL0CTRL1_CLR(v)    (HW_CLKCTRL_PLL0CTRL1_WR(HW_CLKCTRL_PLL0CTRL1_RD() & ~(v)))
#define HW_CLKCTRL_PLL0CTRL1_TOG(v)    (HW_CLKCTRL_PLL0CTRL1_WR(HW_CLKCTRL_PLL0CTRL1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_PLL0CTRL1 bitfields
 */
/* --- Register HW_CLKCTRL_PLL0CTRL1, field LOCK */

#define BP_CLKCTRL_PLL0CTRL1_LOCK      31
#define BM_CLKCTRL_PLL0CTRL1_LOCK      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLL0CTRL1_LOCK(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PLL0CTRL1_LOCK)
#else
#define BF_CLKCTRL_PLL0CTRL1_LOCK(v)   (((v) << 31) & BM_CLKCTRL_PLL0CTRL1_LOCK)
#endif
/* --- Register HW_CLKCTRL_PLL0CTRL1, field FORCE_LOCK */

#define BP_CLKCTRL_PLL0CTRL1_FORCE_LOCK      30
#define BM_CLKCTRL_PLL0CTRL1_FORCE_LOCK      0x40000000

#define BF_CLKCTRL_PLL0CTRL1_FORCE_LOCK(v)   (((v) << 30) & BM_CLKCTRL_PLL0CTRL1_FORCE_LOCK)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL0CTRL1_FORCE_LOCK(v)   BF_CS1(CLKCTRL_PLL0CTRL1, FORCE_LOCK, v)
#endif

/* --- Register HW_CLKCTRL_PLL0CTRL1, field RSRVD1 */

#define BP_CLKCTRL_PLL0CTRL1_RSRVD1      16
#define BM_CLKCTRL_PLL0CTRL1_RSRVD1      0x3FFF0000

#define BF_CLKCTRL_PLL0CTRL1_RSRVD1(v)   (((v) << 16) & BM_CLKCTRL_PLL0CTRL1_RSRVD1)
/* --- Register HW_CLKCTRL_PLL0CTRL1, field LOCK_COUNT */

#define BP_CLKCTRL_PLL0CTRL1_LOCK_COUNT      0
#define BM_CLKCTRL_PLL0CTRL1_LOCK_COUNT      0x0000FFFF

#define BF_CLKCTRL_PLL0CTRL1_LOCK_COUNT(v)   (((v) << 0) & BM_CLKCTRL_PLL0CTRL1_LOCK_COUNT)


/*
 * HW_CLKCTRL_PLL1CTRL0 - System PLL1, USB1 PLL Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1       : 17;
        unsigned POWER        :  1;
        unsigned EN_USB_CLKS  :  1;
        unsigned RSRVD3       :  1;
        unsigned DIV_SEL      :  2;
        unsigned RSRVD4       :  2;
        unsigned CP_SEL       :  2;
        unsigned RSRVD5       :  2;
        unsigned LFR_SEL      :  2;
        unsigned RSRVD6       :  1;
        unsigned CLKGATEEMI   :  1;
    } B;
} hw_clkctrl_pll1ctrl0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_PLL1CTRL0 register
 */
#define HW_CLKCTRL_PLL1CTRL0_ADDR         (REGS_CLKCTRL_BASE + 0x20)
#define HW_CLKCTRL_PLL1CTRL0_SET_ADDR     (HW_CLKCTRL_PLL1CTRL0_ADDR + 4)
#define HW_CLKCTRL_PLL1CTRL0_CLR_ADDR     (HW_CLKCTRL_PLL1CTRL0_ADDR + 8)
#define HW_CLKCTRL_PLL1CTRL0_TOG_ADDR     (HW_CLKCTRL_PLL1CTRL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLL1CTRL0           (*(volatile hw_clkctrl_pll1ctrl0_t *) HW_CLKCTRL_PLL1CTRL0_ADDR)
#define HW_CLKCTRL_PLL1CTRL0_RD()      (HW_CLKCTRL_PLL1CTRL0.U)
#define HW_CLKCTRL_PLL1CTRL0_WR(v)     (HW_CLKCTRL_PLL1CTRL0.U = (v))
#define HW_CLKCTRL_PLL1CTRL0_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL1CTRL0_SET_ADDR) = (v))
#define HW_CLKCTRL_PLL1CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL1CTRL0_CLR_ADDR) = (v))
#define HW_CLKCTRL_PLL1CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL1CTRL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_PLL1CTRL0 bitfields
 */
/* --- Register HW_CLKCTRL_PLL1CTRL0, field CLKGATEEMI */

#define BP_CLKCTRL_PLL1CTRL0_CLKGATEEMI      31
#define BM_CLKCTRL_PLL1CTRL0_CLKGATEEMI      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLL1CTRL0_CLKGATEEMI(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PLL1CTRL0_CLKGATEEMI)
#else
#define BF_CLKCTRL_PLL1CTRL0_CLKGATEEMI(v)   (((v) << 31) & BM_CLKCTRL_PLL1CTRL0_CLKGATEEMI)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_CLKGATEEMI(v)   BF_CS1(CLKCTRL_PLL1CTRL0, CLKGATEEMI, v)
#endif

/* --- Register HW_CLKCTRL_PLL1CTRL0, field RSRVD6 */

#define BP_CLKCTRL_PLL1CTRL0_RSRVD6      30
#define BM_CLKCTRL_PLL1CTRL0_RSRVD6      0x40000000

#define BF_CLKCTRL_PLL1CTRL0_RSRVD6(v)   (((v) << 30) & BM_CLKCTRL_PLL1CTRL0_RSRVD6)
/* --- Register HW_CLKCTRL_PLL1CTRL0, field LFR_SEL */

#define BP_CLKCTRL_PLL1CTRL0_LFR_SEL      28
#define BM_CLKCTRL_PLL1CTRL0_LFR_SEL      0x30000000

#define BF_CLKCTRL_PLL1CTRL0_LFR_SEL(v)   (((v) << 28) & BM_CLKCTRL_PLL1CTRL0_LFR_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_LFR_SEL(v)   BF_CS1(CLKCTRL_PLL1CTRL0, LFR_SEL, v)
#endif

#define BV_CLKCTRL_PLL1CTRL0_LFR_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL1CTRL0_LFR_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLL1CTRL0_LFR_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLL1CTRL0_LFR_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL1CTRL0, field RSRVD5 */

#define BP_CLKCTRL_PLL1CTRL0_RSRVD5      26
#define BM_CLKCTRL_PLL1CTRL0_RSRVD5      0x0C000000

#define BF_CLKCTRL_PLL1CTRL0_RSRVD5(v)   (((v) << 26) & BM_CLKCTRL_PLL1CTRL0_RSRVD5)
/* --- Register HW_CLKCTRL_PLL1CTRL0, field CP_SEL */

#define BP_CLKCTRL_PLL1CTRL0_CP_SEL      24
#define BM_CLKCTRL_PLL1CTRL0_CP_SEL      0x03000000

#define BF_CLKCTRL_PLL1CTRL0_CP_SEL(v)   (((v) << 24) & BM_CLKCTRL_PLL1CTRL0_CP_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_CP_SEL(v)   BF_CS1(CLKCTRL_PLL1CTRL0, CP_SEL, v)
#endif

#define BV_CLKCTRL_PLL1CTRL0_CP_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL1CTRL0_CP_SEL__TIMES_2    0x1
#define BV_CLKCTRL_PLL1CTRL0_CP_SEL__TIMES_05   0x2
#define BV_CLKCTRL_PLL1CTRL0_CP_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL1CTRL0, field RSRVD4 */

#define BP_CLKCTRL_PLL1CTRL0_RSRVD4      22
#define BM_CLKCTRL_PLL1CTRL0_RSRVD4      0x00C00000

#define BF_CLKCTRL_PLL1CTRL0_RSRVD4(v)   (((v) << 22) & BM_CLKCTRL_PLL1CTRL0_RSRVD4)
/* --- Register HW_CLKCTRL_PLL1CTRL0, field DIV_SEL */

#define BP_CLKCTRL_PLL1CTRL0_DIV_SEL      20
#define BM_CLKCTRL_PLL1CTRL0_DIV_SEL      0x00300000

#define BF_CLKCTRL_PLL1CTRL0_DIV_SEL(v)   (((v) << 20) & BM_CLKCTRL_PLL1CTRL0_DIV_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_DIV_SEL(v)   BF_CS1(CLKCTRL_PLL1CTRL0, DIV_SEL, v)
#endif

#define BV_CLKCTRL_PLL1CTRL0_DIV_SEL__DEFAULT    0x0
#define BV_CLKCTRL_PLL1CTRL0_DIV_SEL__LOWER      0x1
#define BV_CLKCTRL_PLL1CTRL0_DIV_SEL__LOWEST     0x2
#define BV_CLKCTRL_PLL1CTRL0_DIV_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_PLL1CTRL0, field RSRVD3 */

#define BP_CLKCTRL_PLL1CTRL0_RSRVD3      19
#define BM_CLKCTRL_PLL1CTRL0_RSRVD3      0x00080000

#define BF_CLKCTRL_PLL1CTRL0_RSRVD3(v)   (((v) << 19) & BM_CLKCTRL_PLL1CTRL0_RSRVD3)
/* --- Register HW_CLKCTRL_PLL1CTRL0, field EN_USB_CLKS */

#define BP_CLKCTRL_PLL1CTRL0_EN_USB_CLKS      18
#define BM_CLKCTRL_PLL1CTRL0_EN_USB_CLKS      0x00040000

#define BF_CLKCTRL_PLL1CTRL0_EN_USB_CLKS(v)   (((v) << 18) & BM_CLKCTRL_PLL1CTRL0_EN_USB_CLKS)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_EN_USB_CLKS(v)   BF_CS1(CLKCTRL_PLL1CTRL0, EN_USB_CLKS, v)
#endif

/* --- Register HW_CLKCTRL_PLL1CTRL0, field POWER */

#define BP_CLKCTRL_PLL1CTRL0_POWER      17
#define BM_CLKCTRL_PLL1CTRL0_POWER      0x00020000

#define BF_CLKCTRL_PLL1CTRL0_POWER(v)   (((v) << 17) & BM_CLKCTRL_PLL1CTRL0_POWER)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL0_POWER(v)   BF_CS1(CLKCTRL_PLL1CTRL0, POWER, v)
#endif

/* --- Register HW_CLKCTRL_PLL1CTRL0, field RSRVD1 */

#define BP_CLKCTRL_PLL1CTRL0_RSRVD1      0
#define BM_CLKCTRL_PLL1CTRL0_RSRVD1      0x0001FFFF

#define BF_CLKCTRL_PLL1CTRL0_RSRVD1(v)   (((v) << 0) & BM_CLKCTRL_PLL1CTRL0_RSRVD1)


/*
 * HW_CLKCTRL_PLL1CTRL1 - System PLL1, USB1 PLL Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned LOCK_COUNT  : 16;
        unsigned RSRVD1      : 14;
        unsigned FORCE_LOCK  :  1;
        unsigned LOCK        :  1;
    } B;
} hw_clkctrl_pll1ctrl1_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_PLL1CTRL1 register
 */
#define HW_CLKCTRL_PLL1CTRL1_ADDR         (REGS_CLKCTRL_BASE + 0x30)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLL1CTRL1           (*(volatile hw_clkctrl_pll1ctrl1_t *) HW_CLKCTRL_PLL1CTRL1_ADDR)
#define HW_CLKCTRL_PLL1CTRL1_RD()      (HW_CLKCTRL_PLL1CTRL1.U)
#define HW_CLKCTRL_PLL1CTRL1_WR(v)     (HW_CLKCTRL_PLL1CTRL1.U = (v))
#define HW_CLKCTRL_PLL1CTRL1_SET(v)    (HW_CLKCTRL_PLL1CTRL1_WR(HW_CLKCTRL_PLL1CTRL1_RD() |  (v)))
#define HW_CLKCTRL_PLL1CTRL1_CLR(v)    (HW_CLKCTRL_PLL1CTRL1_WR(HW_CLKCTRL_PLL1CTRL1_RD() & ~(v)))
#define HW_CLKCTRL_PLL1CTRL1_TOG(v)    (HW_CLKCTRL_PLL1CTRL1_WR(HW_CLKCTRL_PLL1CTRL1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_PLL1CTRL1 bitfields
 */
/* --- Register HW_CLKCTRL_PLL1CTRL1, field LOCK */

#define BP_CLKCTRL_PLL1CTRL1_LOCK      31
#define BM_CLKCTRL_PLL1CTRL1_LOCK      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLL1CTRL1_LOCK(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PLL1CTRL1_LOCK)
#else
#define BF_CLKCTRL_PLL1CTRL1_LOCK(v)   (((v) << 31) & BM_CLKCTRL_PLL1CTRL1_LOCK)
#endif
/* --- Register HW_CLKCTRL_PLL1CTRL1, field FORCE_LOCK */

#define BP_CLKCTRL_PLL1CTRL1_FORCE_LOCK      30
#define BM_CLKCTRL_PLL1CTRL1_FORCE_LOCK      0x40000000

#define BF_CLKCTRL_PLL1CTRL1_FORCE_LOCK(v)   (((v) << 30) & BM_CLKCTRL_PLL1CTRL1_FORCE_LOCK)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL1CTRL1_FORCE_LOCK(v)   BF_CS1(CLKCTRL_PLL1CTRL1, FORCE_LOCK, v)
#endif

/* --- Register HW_CLKCTRL_PLL1CTRL1, field RSRVD1 */

#define BP_CLKCTRL_PLL1CTRL1_RSRVD1      16
#define BM_CLKCTRL_PLL1CTRL1_RSRVD1      0x3FFF0000

#define BF_CLKCTRL_PLL1CTRL1_RSRVD1(v)   (((v) << 16) & BM_CLKCTRL_PLL1CTRL1_RSRVD1)
/* --- Register HW_CLKCTRL_PLL1CTRL1, field LOCK_COUNT */

#define BP_CLKCTRL_PLL1CTRL1_LOCK_COUNT      0
#define BM_CLKCTRL_PLL1CTRL1_LOCK_COUNT      0x0000FFFF

#define BF_CLKCTRL_PLL1CTRL1_LOCK_COUNT(v)   (((v) << 0) & BM_CLKCTRL_PLL1CTRL1_LOCK_COUNT)


/*
 * HW_CLKCTRL_PLL2CTRL0 - System PLL2, Ethernet PLL Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1           : 23;
        unsigned POWER            :  1;
        unsigned CP_SEL           :  2;
        unsigned HOLD_RING_OFF_B  :  1;
        unsigned RSRVD2           :  1;
        unsigned LFR_SEL          :  2;
        unsigned RSRVD3           :  1;
        unsigned CLKGATE          :  1;
    } B;
} hw_clkctrl_pll2ctrl0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_PLL2CTRL0 register
 */
#define HW_CLKCTRL_PLL2CTRL0_ADDR         (REGS_CLKCTRL_BASE + 0x40)
#define HW_CLKCTRL_PLL2CTRL0_SET_ADDR     (HW_CLKCTRL_PLL2CTRL0_ADDR + 4)
#define HW_CLKCTRL_PLL2CTRL0_CLR_ADDR     (HW_CLKCTRL_PLL2CTRL0_ADDR + 8)
#define HW_CLKCTRL_PLL2CTRL0_TOG_ADDR     (HW_CLKCTRL_PLL2CTRL0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_PLL2CTRL0           (*(volatile hw_clkctrl_pll2ctrl0_t *) HW_CLKCTRL_PLL2CTRL0_ADDR)
#define HW_CLKCTRL_PLL2CTRL0_RD()      (HW_CLKCTRL_PLL2CTRL0.U)
#define HW_CLKCTRL_PLL2CTRL0_WR(v)     (HW_CLKCTRL_PLL2CTRL0.U = (v))
#define HW_CLKCTRL_PLL2CTRL0_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL2CTRL0_SET_ADDR) = (v))
#define HW_CLKCTRL_PLL2CTRL0_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL2CTRL0_CLR_ADDR) = (v))
#define HW_CLKCTRL_PLL2CTRL0_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_PLL2CTRL0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_PLL2CTRL0 bitfields
 */
/* --- Register HW_CLKCTRL_PLL2CTRL0, field CLKGATE */

#define BP_CLKCTRL_PLL2CTRL0_CLKGATE      31
#define BM_CLKCTRL_PLL2CTRL0_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_PLL2CTRL0_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_PLL2CTRL0_CLKGATE)
#else
#define BF_CLKCTRL_PLL2CTRL0_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_PLL2CTRL0_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL2CTRL0_CLKGATE(v)   BF_CS1(CLKCTRL_PLL2CTRL0, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_PLL2CTRL0, field RSRVD3 */

#define BP_CLKCTRL_PLL2CTRL0_RSRVD3      30
#define BM_CLKCTRL_PLL2CTRL0_RSRVD3      0x40000000

#define BF_CLKCTRL_PLL2CTRL0_RSRVD3(v)   (((v) << 30) & BM_CLKCTRL_PLL2CTRL0_RSRVD3)
/* --- Register HW_CLKCTRL_PLL2CTRL0, field LFR_SEL */

#define BP_CLKCTRL_PLL2CTRL0_LFR_SEL      28
#define BM_CLKCTRL_PLL2CTRL0_LFR_SEL      0x30000000

#define BF_CLKCTRL_PLL2CTRL0_LFR_SEL(v)   (((v) << 28) & BM_CLKCTRL_PLL2CTRL0_LFR_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL2CTRL0_LFR_SEL(v)   BF_CS1(CLKCTRL_PLL2CTRL0, LFR_SEL, v)
#endif

/* --- Register HW_CLKCTRL_PLL2CTRL0, field RSRVD2 */

#define BP_CLKCTRL_PLL2CTRL0_RSRVD2      27
#define BM_CLKCTRL_PLL2CTRL0_RSRVD2      0x08000000

#define BF_CLKCTRL_PLL2CTRL0_RSRVD2(v)   (((v) << 27) & BM_CLKCTRL_PLL2CTRL0_RSRVD2)
/* --- Register HW_CLKCTRL_PLL2CTRL0, field HOLD_RING_OFF_B */

#define BP_CLKCTRL_PLL2CTRL0_HOLD_RING_OFF_B      26
#define BM_CLKCTRL_PLL2CTRL0_HOLD_RING_OFF_B      0x04000000

#define BF_CLKCTRL_PLL2CTRL0_HOLD_RING_OFF_B(v)   (((v) << 26) & BM_CLKCTRL_PLL2CTRL0_HOLD_RING_OFF_B)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL2CTRL0_HOLD_RING_OFF_B(v)   BF_CS1(CLKCTRL_PLL2CTRL0, HOLD_RING_OFF_B, v)
#endif

/* --- Register HW_CLKCTRL_PLL2CTRL0, field CP_SEL */

#define BP_CLKCTRL_PLL2CTRL0_CP_SEL      24
#define BM_CLKCTRL_PLL2CTRL0_CP_SEL      0x03000000

#define BF_CLKCTRL_PLL2CTRL0_CP_SEL(v)   (((v) << 24) & BM_CLKCTRL_PLL2CTRL0_CP_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL2CTRL0_CP_SEL(v)   BF_CS1(CLKCTRL_PLL2CTRL0, CP_SEL, v)
#endif

/* --- Register HW_CLKCTRL_PLL2CTRL0, field POWER */

#define BP_CLKCTRL_PLL2CTRL0_POWER      23
#define BM_CLKCTRL_PLL2CTRL0_POWER      0x00800000

#define BF_CLKCTRL_PLL2CTRL0_POWER(v)   (((v) << 23) & BM_CLKCTRL_PLL2CTRL0_POWER)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_PLL2CTRL0_POWER(v)   BF_CS1(CLKCTRL_PLL2CTRL0, POWER, v)
#endif

/* --- Register HW_CLKCTRL_PLL2CTRL0, field RSRVD1 */

#define BP_CLKCTRL_PLL2CTRL0_RSRVD1      0
#define BM_CLKCTRL_PLL2CTRL0_RSRVD1      0x007FFFFF

#define BF_CLKCTRL_PLL2CTRL0_RSRVD1(v)   (((v) << 0) & BM_CLKCTRL_PLL2CTRL0_RSRVD1)


/*
 * HW_CLKCTRL_CPU - CPU Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_CPU           :  6;
        unsigned RSRVD1            :  4;
        unsigned DIV_CPU_FRAC_EN   :  1;
        unsigned RSRVD2            :  1;
        unsigned INTERRUPT_WAIT    :  1;
        unsigned RSRVD3            :  3;
        unsigned DIV_XTAL          : 10;
        unsigned DIV_XTAL_FRAC_EN  :  1;
        unsigned RSRVD4            :  1;
        unsigned BUSY_REF_CPU      :  1;
        unsigned BUSY_REF_XTAL     :  1;
        unsigned RSRVD5            :  2;
    } B;
} hw_clkctrl_cpu_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_CPU register
 */
#define HW_CLKCTRL_CPU_ADDR         (REGS_CLKCTRL_BASE + 0x50)
#define HW_CLKCTRL_CPU_SET_ADDR     (HW_CLKCTRL_CPU_ADDR + 4)
#define HW_CLKCTRL_CPU_CLR_ADDR     (HW_CLKCTRL_CPU_ADDR + 8)
#define HW_CLKCTRL_CPU_TOG_ADDR     (HW_CLKCTRL_CPU_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_CPU           (*(volatile hw_clkctrl_cpu_t *) HW_CLKCTRL_CPU_ADDR)
#define HW_CLKCTRL_CPU_RD()      (HW_CLKCTRL_CPU.U)
#define HW_CLKCTRL_CPU_WR(v)     (HW_CLKCTRL_CPU.U = (v))
#define HW_CLKCTRL_CPU_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_SET_ADDR) = (v))
#define HW_CLKCTRL_CPU_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_CLR_ADDR) = (v))
#define HW_CLKCTRL_CPU_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CPU_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_CPU bitfields
 */
/* --- Register HW_CLKCTRL_CPU, field RSRVD5 */

#define BP_CLKCTRL_CPU_RSRVD5      30
#define BM_CLKCTRL_CPU_RSRVD5      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_CPU_RSRVD5(v)   ((((reg32_t) v) << 30) & BM_CLKCTRL_CPU_RSRVD5)
#else
#define BF_CLKCTRL_CPU_RSRVD5(v)   (((v) << 30) & BM_CLKCTRL_CPU_RSRVD5)
#endif
/* --- Register HW_CLKCTRL_CPU, field BUSY_REF_XTAL */

#define BP_CLKCTRL_CPU_BUSY_REF_XTAL      29
#define BM_CLKCTRL_CPU_BUSY_REF_XTAL      0x20000000

#define BF_CLKCTRL_CPU_BUSY_REF_XTAL(v)   (((v) << 29) & BM_CLKCTRL_CPU_BUSY_REF_XTAL)
/* --- Register HW_CLKCTRL_CPU, field BUSY_REF_CPU */

#define BP_CLKCTRL_CPU_BUSY_REF_CPU      28
#define BM_CLKCTRL_CPU_BUSY_REF_CPU      0x10000000

#define BF_CLKCTRL_CPU_BUSY_REF_CPU(v)   (((v) << 28) & BM_CLKCTRL_CPU_BUSY_REF_CPU)
/* --- Register HW_CLKCTRL_CPU, field RSRVD4 */

#define BP_CLKCTRL_CPU_RSRVD4      27
#define BM_CLKCTRL_CPU_RSRVD4      0x08000000

#define BF_CLKCTRL_CPU_RSRVD4(v)   (((v) << 27) & BM_CLKCTRL_CPU_RSRVD4)
/* --- Register HW_CLKCTRL_CPU, field DIV_XTAL_FRAC_EN */

#define BP_CLKCTRL_CPU_DIV_XTAL_FRAC_EN      26
#define BM_CLKCTRL_CPU_DIV_XTAL_FRAC_EN      0x04000000

#define BF_CLKCTRL_CPU_DIV_XTAL_FRAC_EN(v)   (((v) << 26) & BM_CLKCTRL_CPU_DIV_XTAL_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_XTAL_FRAC_EN(v)   BF_CS1(CLKCTRL_CPU, DIV_XTAL_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_CPU, field DIV_XTAL */

#define BP_CLKCTRL_CPU_DIV_XTAL      16
#define BM_CLKCTRL_CPU_DIV_XTAL      0x03FF0000

#define BF_CLKCTRL_CPU_DIV_XTAL(v)   (((v) << 16) & BM_CLKCTRL_CPU_DIV_XTAL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_XTAL(v)   BF_CS1(CLKCTRL_CPU, DIV_XTAL, v)
#endif

/* --- Register HW_CLKCTRL_CPU, field RSRVD3 */

#define BP_CLKCTRL_CPU_RSRVD3      13
#define BM_CLKCTRL_CPU_RSRVD3      0x0000E000

#define BF_CLKCTRL_CPU_RSRVD3(v)   (((v) << 13) & BM_CLKCTRL_CPU_RSRVD3)
/* --- Register HW_CLKCTRL_CPU, field INTERRUPT_WAIT */

#define BP_CLKCTRL_CPU_INTERRUPT_WAIT      12
#define BM_CLKCTRL_CPU_INTERRUPT_WAIT      0x00001000

#define BF_CLKCTRL_CPU_INTERRUPT_WAIT(v)   (((v) << 12) & BM_CLKCTRL_CPU_INTERRUPT_WAIT)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_INTERRUPT_WAIT(v)   BF_CS1(CLKCTRL_CPU, INTERRUPT_WAIT, v)
#endif

/* --- Register HW_CLKCTRL_CPU, field RSRVD2 */

#define BP_CLKCTRL_CPU_RSRVD2      11
#define BM_CLKCTRL_CPU_RSRVD2      0x00000800

#define BF_CLKCTRL_CPU_RSRVD2(v)   (((v) << 11) & BM_CLKCTRL_CPU_RSRVD2)
/* --- Register HW_CLKCTRL_CPU, field DIV_CPU_FRAC_EN */

#define BP_CLKCTRL_CPU_DIV_CPU_FRAC_EN      10
#define BM_CLKCTRL_CPU_DIV_CPU_FRAC_EN      0x00000400

#define BF_CLKCTRL_CPU_DIV_CPU_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_CPU_DIV_CPU_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_CPU_FRAC_EN(v)   BF_CS1(CLKCTRL_CPU, DIV_CPU_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_CPU, field RSRVD1 */

#define BP_CLKCTRL_CPU_RSRVD1      6
#define BM_CLKCTRL_CPU_RSRVD1      0x000003C0

#define BF_CLKCTRL_CPU_RSRVD1(v)   (((v) << 6) & BM_CLKCTRL_CPU_RSRVD1)
/* --- Register HW_CLKCTRL_CPU, field DIV_CPU */

#define BP_CLKCTRL_CPU_DIV_CPU      0
#define BM_CLKCTRL_CPU_DIV_CPU      0x0000003F

#define BF_CLKCTRL_CPU_DIV_CPU(v)   (((v) << 0) & BM_CLKCTRL_CPU_DIV_CPU)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CPU_DIV_CPU(v)   BF_CS1(CLKCTRL_CPU, DIV_CPU, v)
#endif



/*
 * HW_CLKCTRL_HBUS - AHB, APBH Bus Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV                    :  5;
        unsigned DIV_FRAC_EN            :  1;
        unsigned RSRVD1                 : 10;
        unsigned SLOW_DIV               :  3;
        unsigned AUTO_CLEAR_DIV_ENABLE  :  1;
        unsigned ASM_ENABLE             :  1;
        unsigned CPU_INSTR_AS_ENABLE    :  1;
        unsigned CPU_DATA_AS_ENABLE     :  1;
        unsigned TRAFFIC_AS_ENABLE      :  1;
        unsigned TRAFFIC_JAM_AS_ENABLE  :  1;
        unsigned APBXDMA_AS_ENABLE      :  1;
        unsigned APBHDMA_AS_ENABLE      :  1;
        unsigned ASM_EMIPORT_AS_ENABLE  :  1;
        unsigned RSRVD2                 :  1;
        unsigned PXP_AS_ENABLE          :  1;
        unsigned DCP_AS_ENABLE          :  1;
        unsigned ASM_BUSY               :  1;
    } B;
} hw_clkctrl_hbus_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_HBUS register
 */
#define HW_CLKCTRL_HBUS_ADDR         (REGS_CLKCTRL_BASE + 0x60)
#define HW_CLKCTRL_HBUS_SET_ADDR     (HW_CLKCTRL_HBUS_ADDR + 4)
#define HW_CLKCTRL_HBUS_CLR_ADDR     (HW_CLKCTRL_HBUS_ADDR + 8)
#define HW_CLKCTRL_HBUS_TOG_ADDR     (HW_CLKCTRL_HBUS_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_HBUS           (*(volatile hw_clkctrl_hbus_t *) HW_CLKCTRL_HBUS_ADDR)
#define HW_CLKCTRL_HBUS_RD()      (HW_CLKCTRL_HBUS.U)
#define HW_CLKCTRL_HBUS_WR(v)     (HW_CLKCTRL_HBUS.U = (v))
#define HW_CLKCTRL_HBUS_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_SET_ADDR) = (v))
#define HW_CLKCTRL_HBUS_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_CLR_ADDR) = (v))
#define HW_CLKCTRL_HBUS_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_HBUS_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_HBUS bitfields
 */
/* --- Register HW_CLKCTRL_HBUS, field ASM_BUSY */

#define BP_CLKCTRL_HBUS_ASM_BUSY      31
#define BM_CLKCTRL_HBUS_ASM_BUSY      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_HBUS_ASM_BUSY(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_HBUS_ASM_BUSY)
#else
#define BF_CLKCTRL_HBUS_ASM_BUSY(v)   (((v) << 31) & BM_CLKCTRL_HBUS_ASM_BUSY)
#endif
/* --- Register HW_CLKCTRL_HBUS, field DCP_AS_ENABLE */

#define BP_CLKCTRL_HBUS_DCP_AS_ENABLE      30
#define BM_CLKCTRL_HBUS_DCP_AS_ENABLE      0x40000000

#define BF_CLKCTRL_HBUS_DCP_AS_ENABLE(v)   (((v) << 30) & BM_CLKCTRL_HBUS_DCP_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DCP_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, DCP_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field PXP_AS_ENABLE */

#define BP_CLKCTRL_HBUS_PXP_AS_ENABLE      29
#define BM_CLKCTRL_HBUS_PXP_AS_ENABLE      0x20000000

#define BF_CLKCTRL_HBUS_PXP_AS_ENABLE(v)   (((v) << 29) & BM_CLKCTRL_HBUS_PXP_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_PXP_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, PXP_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field RSRVD2 */

#define BP_CLKCTRL_HBUS_RSRVD2      28
#define BM_CLKCTRL_HBUS_RSRVD2      0x10000000

#define BF_CLKCTRL_HBUS_RSRVD2(v)   (((v) << 28) & BM_CLKCTRL_HBUS_RSRVD2)
/* --- Register HW_CLKCTRL_HBUS, field ASM_EMIPORT_AS_ENABLE */

#define BP_CLKCTRL_HBUS_ASM_EMIPORT_AS_ENABLE      27
#define BM_CLKCTRL_HBUS_ASM_EMIPORT_AS_ENABLE      0x08000000

#define BF_CLKCTRL_HBUS_ASM_EMIPORT_AS_ENABLE(v)   (((v) << 27) & BM_CLKCTRL_HBUS_ASM_EMIPORT_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_ASM_EMIPORT_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, ASM_EMIPORT_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field APBHDMA_AS_ENABLE */

#define BP_CLKCTRL_HBUS_APBHDMA_AS_ENABLE      26
#define BM_CLKCTRL_HBUS_APBHDMA_AS_ENABLE      0x04000000

#define BF_CLKCTRL_HBUS_APBHDMA_AS_ENABLE(v)   (((v) << 26) & BM_CLKCTRL_HBUS_APBHDMA_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_APBHDMA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, APBHDMA_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field APBXDMA_AS_ENABLE */

#define BP_CLKCTRL_HBUS_APBXDMA_AS_ENABLE      25
#define BM_CLKCTRL_HBUS_APBXDMA_AS_ENABLE      0x02000000

#define BF_CLKCTRL_HBUS_APBXDMA_AS_ENABLE(v)   (((v) << 25) & BM_CLKCTRL_HBUS_APBXDMA_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_APBXDMA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, APBXDMA_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field TRAFFIC_JAM_AS_ENABLE */

#define BP_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE      24
#define BM_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE      0x01000000

#define BF_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE(v)   (((v) << 24) & BM_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, TRAFFIC_JAM_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field TRAFFIC_AS_ENABLE */

#define BP_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE      23
#define BM_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE      0x00800000

#define BF_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE(v)   (((v) << 23) & BM_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, TRAFFIC_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field CPU_DATA_AS_ENABLE */

#define BP_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE      22
#define BM_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE      0x00400000

#define BF_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE(v)   (((v) << 22) & BM_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, CPU_DATA_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field CPU_INSTR_AS_ENABLE */

#define BP_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE      21
#define BM_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE      0x00200000

#define BF_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE(v)   (((v) << 21) & BM_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, CPU_INSTR_AS_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field ASM_ENABLE */

#define BP_CLKCTRL_HBUS_ASM_ENABLE      20
#define BM_CLKCTRL_HBUS_ASM_ENABLE      0x00100000

#define BF_CLKCTRL_HBUS_ASM_ENABLE(v)   (((v) << 20) & BM_CLKCTRL_HBUS_ASM_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_ASM_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, ASM_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field AUTO_CLEAR_DIV_ENABLE */

#define BP_CLKCTRL_HBUS_AUTO_CLEAR_DIV_ENABLE      19
#define BM_CLKCTRL_HBUS_AUTO_CLEAR_DIV_ENABLE      0x00080000

#define BF_CLKCTRL_HBUS_AUTO_CLEAR_DIV_ENABLE(v)   (((v) << 19) & BM_CLKCTRL_HBUS_AUTO_CLEAR_DIV_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_AUTO_CLEAR_DIV_ENABLE(v)   BF_CS1(CLKCTRL_HBUS, AUTO_CLEAR_DIV_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field SLOW_DIV */

#define BP_CLKCTRL_HBUS_SLOW_DIV      16
#define BM_CLKCTRL_HBUS_SLOW_DIV      0x00070000

#define BF_CLKCTRL_HBUS_SLOW_DIV(v)   (((v) << 16) & BM_CLKCTRL_HBUS_SLOW_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_SLOW_DIV(v)   BF_CS1(CLKCTRL_HBUS, SLOW_DIV, v)
#endif

#define BV_CLKCTRL_HBUS_SLOW_DIV__BY1   0x0
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY2   0x1
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY4   0x2
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY8   0x3
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY16  0x4
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY32  0x5

/* --- Register HW_CLKCTRL_HBUS, field RSRVD1 */

#define BP_CLKCTRL_HBUS_RSRVD1      6
#define BM_CLKCTRL_HBUS_RSRVD1      0x0000FFC0

#define BF_CLKCTRL_HBUS_RSRVD1(v)   (((v) << 6) & BM_CLKCTRL_HBUS_RSRVD1)
/* --- Register HW_CLKCTRL_HBUS, field DIV_FRAC_EN */

#define BP_CLKCTRL_HBUS_DIV_FRAC_EN      5
#define BM_CLKCTRL_HBUS_DIV_FRAC_EN      0x00000020

#define BF_CLKCTRL_HBUS_DIV_FRAC_EN(v)   (((v) << 5) & BM_CLKCTRL_HBUS_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_HBUS, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_HBUS, field DIV */

#define BP_CLKCTRL_HBUS_DIV      0
#define BM_CLKCTRL_HBUS_DIV      0x0000001F

#define BF_CLKCTRL_HBUS_DIV(v)   (((v) << 0) & BM_CLKCTRL_HBUS_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HBUS_DIV(v)   BF_CS1(CLKCTRL_HBUS, DIV, v)
#endif



/*
 * HW_CLKCTRL_XBUS - APBX Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV                    : 10;
        unsigned DIV_FRAC_EN            :  1;
        unsigned AUTO_CLEAR_DIV_ENABLE  :  1;
        unsigned RSRVD1                 : 19;
        unsigned BUSY                   :  1;
    } B;
} hw_clkctrl_xbus_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_XBUS register
 */
#define HW_CLKCTRL_XBUS_ADDR         (REGS_CLKCTRL_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_XBUS           (*(volatile hw_clkctrl_xbus_t *) HW_CLKCTRL_XBUS_ADDR)
#define HW_CLKCTRL_XBUS_RD()      (HW_CLKCTRL_XBUS.U)
#define HW_CLKCTRL_XBUS_WR(v)     (HW_CLKCTRL_XBUS.U = (v))
#define HW_CLKCTRL_XBUS_SET(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() |  (v)))
#define HW_CLKCTRL_XBUS_CLR(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() & ~(v)))
#define HW_CLKCTRL_XBUS_TOG(v)    (HW_CLKCTRL_XBUS_WR(HW_CLKCTRL_XBUS_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_XBUS bitfields
 */
/* --- Register HW_CLKCTRL_XBUS, field BUSY */

#define BP_CLKCTRL_XBUS_BUSY      31
#define BM_CLKCTRL_XBUS_BUSY      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_XBUS_BUSY(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_XBUS_BUSY)
#else
#define BF_CLKCTRL_XBUS_BUSY(v)   (((v) << 31) & BM_CLKCTRL_XBUS_BUSY)
#endif
/* --- Register HW_CLKCTRL_XBUS, field RSRVD1 */

#define BP_CLKCTRL_XBUS_RSRVD1      12
#define BM_CLKCTRL_XBUS_RSRVD1      0x7FFFF000

#define BF_CLKCTRL_XBUS_RSRVD1(v)   (((v) << 12) & BM_CLKCTRL_XBUS_RSRVD1)
/* --- Register HW_CLKCTRL_XBUS, field AUTO_CLEAR_DIV_ENABLE */

#define BP_CLKCTRL_XBUS_AUTO_CLEAR_DIV_ENABLE      11
#define BM_CLKCTRL_XBUS_AUTO_CLEAR_DIV_ENABLE      0x00000800

#define BF_CLKCTRL_XBUS_AUTO_CLEAR_DIV_ENABLE(v)   (((v) << 11) & BM_CLKCTRL_XBUS_AUTO_CLEAR_DIV_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XBUS_AUTO_CLEAR_DIV_ENABLE(v)   BF_CS1(CLKCTRL_XBUS, AUTO_CLEAR_DIV_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_XBUS, field DIV_FRAC_EN */

#define BP_CLKCTRL_XBUS_DIV_FRAC_EN      10
#define BM_CLKCTRL_XBUS_DIV_FRAC_EN      0x00000400

#define BF_CLKCTRL_XBUS_DIV_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_XBUS_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XBUS_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_XBUS, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_XBUS, field DIV */

#define BP_CLKCTRL_XBUS_DIV      0
#define BM_CLKCTRL_XBUS_DIV      0x000003FF

#define BF_CLKCTRL_XBUS_DIV(v)   (((v) << 0) & BM_CLKCTRL_XBUS_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XBUS_DIV(v)   BF_CS1(CLKCTRL_XBUS, DIV, v)
#endif



/*
 * HW_CLKCTRL_XTAL - XTAL Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_UART            :  2;
        unsigned RSRVD1              : 24;
        unsigned TIMROT_CLK32K_GATE  :  1;
        unsigned RSRVD2              :  2;
        unsigned PWM_CLK24M_GATE     :  1;
        unsigned RSRVD3              :  1;
        unsigned UART_CLK_GATE       :  1;
    } B;
} hw_clkctrl_xtal_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_XTAL register
 */
#define HW_CLKCTRL_XTAL_ADDR         (REGS_CLKCTRL_BASE + 0x80)
#define HW_CLKCTRL_XTAL_SET_ADDR     (HW_CLKCTRL_XTAL_ADDR + 4)
#define HW_CLKCTRL_XTAL_CLR_ADDR     (HW_CLKCTRL_XTAL_ADDR + 8)
#define HW_CLKCTRL_XTAL_TOG_ADDR     (HW_CLKCTRL_XTAL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_XTAL           (*(volatile hw_clkctrl_xtal_t *) HW_CLKCTRL_XTAL_ADDR)
#define HW_CLKCTRL_XTAL_RD()      (HW_CLKCTRL_XTAL.U)
#define HW_CLKCTRL_XTAL_WR(v)     (HW_CLKCTRL_XTAL.U = (v))
#define HW_CLKCTRL_XTAL_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_SET_ADDR) = (v))
#define HW_CLKCTRL_XTAL_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_CLR_ADDR) = (v))
#define HW_CLKCTRL_XTAL_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_XTAL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_XTAL bitfields
 */
/* --- Register HW_CLKCTRL_XTAL, field UART_CLK_GATE */

#define BP_CLKCTRL_XTAL_UART_CLK_GATE      31
#define BM_CLKCTRL_XTAL_UART_CLK_GATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_XTAL_UART_CLK_GATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_XTAL_UART_CLK_GATE)
#else
#define BF_CLKCTRL_XTAL_UART_CLK_GATE(v)   (((v) << 31) & BM_CLKCTRL_XTAL_UART_CLK_GATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_UART_CLK_GATE(v)   BF_CS1(CLKCTRL_XTAL, UART_CLK_GATE, v)
#endif

/* --- Register HW_CLKCTRL_XTAL, field RSRVD3 */

#define BP_CLKCTRL_XTAL_RSRVD3      30
#define BM_CLKCTRL_XTAL_RSRVD3      0x40000000

#define BF_CLKCTRL_XTAL_RSRVD3(v)   (((v) << 30) & BM_CLKCTRL_XTAL_RSRVD3)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_RSRVD3(v)   BF_CS1(CLKCTRL_XTAL, RSRVD3, v)
#endif

/* --- Register HW_CLKCTRL_XTAL, field PWM_CLK24M_GATE */

#define BP_CLKCTRL_XTAL_PWM_CLK24M_GATE      29
#define BM_CLKCTRL_XTAL_PWM_CLK24M_GATE      0x20000000

#define BF_CLKCTRL_XTAL_PWM_CLK24M_GATE(v)   (((v) << 29) & BM_CLKCTRL_XTAL_PWM_CLK24M_GATE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_PWM_CLK24M_GATE(v)   BF_CS1(CLKCTRL_XTAL, PWM_CLK24M_GATE, v)
#endif

/* --- Register HW_CLKCTRL_XTAL, field RSRVD2 */

#define BP_CLKCTRL_XTAL_RSRVD2      27
#define BM_CLKCTRL_XTAL_RSRVD2      0x18000000

#define BF_CLKCTRL_XTAL_RSRVD2(v)   (((v) << 27) & BM_CLKCTRL_XTAL_RSRVD2)
/* --- Register HW_CLKCTRL_XTAL, field TIMROT_CLK32K_GATE */

#define BP_CLKCTRL_XTAL_TIMROT_CLK32K_GATE      26
#define BM_CLKCTRL_XTAL_TIMROT_CLK32K_GATE      0x04000000

#define BF_CLKCTRL_XTAL_TIMROT_CLK32K_GATE(v)   (((v) << 26) & BM_CLKCTRL_XTAL_TIMROT_CLK32K_GATE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_TIMROT_CLK32K_GATE(v)   BF_CS1(CLKCTRL_XTAL, TIMROT_CLK32K_GATE, v)
#endif

/* --- Register HW_CLKCTRL_XTAL, field RSRVD1 */

#define BP_CLKCTRL_XTAL_RSRVD1      2
#define BM_CLKCTRL_XTAL_RSRVD1      0x03FFFFFC

#define BF_CLKCTRL_XTAL_RSRVD1(v)   (((v) << 2) & BM_CLKCTRL_XTAL_RSRVD1)
/* --- Register HW_CLKCTRL_XTAL, field DIV_UART */

#define BP_CLKCTRL_XTAL_DIV_UART      0
#define BM_CLKCTRL_XTAL_DIV_UART      0x00000003

#define BF_CLKCTRL_XTAL_DIV_UART(v)   (((v) << 0) & BM_CLKCTRL_XTAL_DIV_UART)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_XTAL_DIV_UART(v)   BF_CS1(CLKCTRL_XTAL, DIV_UART, v)
#endif



/*
 * HW_CLKCTRL_SSP0 - Synchronous Serial Port0 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  9;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 19;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_ssp0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SSP0 register
 */
#define HW_CLKCTRL_SSP0_ADDR         (REGS_CLKCTRL_BASE + 0x90)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SSP0           (*(volatile hw_clkctrl_ssp0_t *) HW_CLKCTRL_SSP0_ADDR)
#define HW_CLKCTRL_SSP0_RD()      (HW_CLKCTRL_SSP0.U)
#define HW_CLKCTRL_SSP0_WR(v)     (HW_CLKCTRL_SSP0.U = (v))
#define HW_CLKCTRL_SSP0_SET(v)    (HW_CLKCTRL_SSP0_WR(HW_CLKCTRL_SSP0_RD() |  (v)))
#define HW_CLKCTRL_SSP0_CLR(v)    (HW_CLKCTRL_SSP0_WR(HW_CLKCTRL_SSP0_RD() & ~(v)))
#define HW_CLKCTRL_SSP0_TOG(v)    (HW_CLKCTRL_SSP0_WR(HW_CLKCTRL_SSP0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SSP0 bitfields
 */
/* --- Register HW_CLKCTRL_SSP0, field CLKGATE */

#define BP_CLKCTRL_SSP0_CLKGATE      31
#define BM_CLKCTRL_SSP0_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SSP0_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SSP0_CLKGATE)
#else
#define BF_CLKCTRL_SSP0_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SSP0_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP0_CLKGATE(v)   BF_CS1(CLKCTRL_SSP0, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SSP0, field RSRVD2 */

#define BP_CLKCTRL_SSP0_RSRVD2      30
#define BM_CLKCTRL_SSP0_RSRVD2      0x40000000

#define BF_CLKCTRL_SSP0_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SSP0_RSRVD2)
/* --- Register HW_CLKCTRL_SSP0, field BUSY */

#define BP_CLKCTRL_SSP0_BUSY      29
#define BM_CLKCTRL_SSP0_BUSY      0x20000000

#define BF_CLKCTRL_SSP0_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SSP0_BUSY)
/* --- Register HW_CLKCTRL_SSP0, field RSRVD1 */

#define BP_CLKCTRL_SSP0_RSRVD1      10
#define BM_CLKCTRL_SSP0_RSRVD1      0x1FFFFC00

#define BF_CLKCTRL_SSP0_RSRVD1(v)   (((v) << 10) & BM_CLKCTRL_SSP0_RSRVD1)
/* --- Register HW_CLKCTRL_SSP0, field DIV_FRAC_EN */

#define BP_CLKCTRL_SSP0_DIV_FRAC_EN      9
#define BM_CLKCTRL_SSP0_DIV_FRAC_EN      0x00000200

#define BF_CLKCTRL_SSP0_DIV_FRAC_EN(v)   (((v) << 9) & BM_CLKCTRL_SSP0_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP0_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SSP0, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SSP0, field DIV */

#define BP_CLKCTRL_SSP0_DIV      0
#define BM_CLKCTRL_SSP0_DIV      0x000001FF

#define BF_CLKCTRL_SSP0_DIV(v)   (((v) << 0) & BM_CLKCTRL_SSP0_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP0_DIV(v)   BF_CS1(CLKCTRL_SSP0, DIV, v)
#endif



/*
 * HW_CLKCTRL_SSP1 - Synchronous Serial Port1 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  9;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 19;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_ssp1_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SSP1 register
 */
#define HW_CLKCTRL_SSP1_ADDR         (REGS_CLKCTRL_BASE + 0xa0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SSP1           (*(volatile hw_clkctrl_ssp1_t *) HW_CLKCTRL_SSP1_ADDR)
#define HW_CLKCTRL_SSP1_RD()      (HW_CLKCTRL_SSP1.U)
#define HW_CLKCTRL_SSP1_WR(v)     (HW_CLKCTRL_SSP1.U = (v))
#define HW_CLKCTRL_SSP1_SET(v)    (HW_CLKCTRL_SSP1_WR(HW_CLKCTRL_SSP1_RD() |  (v)))
#define HW_CLKCTRL_SSP1_CLR(v)    (HW_CLKCTRL_SSP1_WR(HW_CLKCTRL_SSP1_RD() & ~(v)))
#define HW_CLKCTRL_SSP1_TOG(v)    (HW_CLKCTRL_SSP1_WR(HW_CLKCTRL_SSP1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SSP1 bitfields
 */
/* --- Register HW_CLKCTRL_SSP1, field CLKGATE */

#define BP_CLKCTRL_SSP1_CLKGATE      31
#define BM_CLKCTRL_SSP1_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SSP1_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SSP1_CLKGATE)
#else
#define BF_CLKCTRL_SSP1_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SSP1_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP1_CLKGATE(v)   BF_CS1(CLKCTRL_SSP1, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SSP1, field RSRVD2 */

#define BP_CLKCTRL_SSP1_RSRVD2      30
#define BM_CLKCTRL_SSP1_RSRVD2      0x40000000

#define BF_CLKCTRL_SSP1_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SSP1_RSRVD2)
/* --- Register HW_CLKCTRL_SSP1, field BUSY */

#define BP_CLKCTRL_SSP1_BUSY      29
#define BM_CLKCTRL_SSP1_BUSY      0x20000000

#define BF_CLKCTRL_SSP1_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SSP1_BUSY)
/* --- Register HW_CLKCTRL_SSP1, field RSRVD1 */

#define BP_CLKCTRL_SSP1_RSRVD1      10
#define BM_CLKCTRL_SSP1_RSRVD1      0x1FFFFC00

#define BF_CLKCTRL_SSP1_RSRVD1(v)   (((v) << 10) & BM_CLKCTRL_SSP1_RSRVD1)
/* --- Register HW_CLKCTRL_SSP1, field DIV_FRAC_EN */

#define BP_CLKCTRL_SSP1_DIV_FRAC_EN      9
#define BM_CLKCTRL_SSP1_DIV_FRAC_EN      0x00000200

#define BF_CLKCTRL_SSP1_DIV_FRAC_EN(v)   (((v) << 9) & BM_CLKCTRL_SSP1_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP1_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SSP1, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SSP1, field DIV */

#define BP_CLKCTRL_SSP1_DIV      0
#define BM_CLKCTRL_SSP1_DIV      0x000001FF

#define BF_CLKCTRL_SSP1_DIV(v)   (((v) << 0) & BM_CLKCTRL_SSP1_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP1_DIV(v)   BF_CS1(CLKCTRL_SSP1, DIV, v)
#endif



/*
 * HW_CLKCTRL_SSP2 - Synchronous Serial Port2 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  9;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 19;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_ssp2_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SSP2 register
 */
#define HW_CLKCTRL_SSP2_ADDR         (REGS_CLKCTRL_BASE + 0xb0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SSP2           (*(volatile hw_clkctrl_ssp2_t *) HW_CLKCTRL_SSP2_ADDR)
#define HW_CLKCTRL_SSP2_RD()      (HW_CLKCTRL_SSP2.U)
#define HW_CLKCTRL_SSP2_WR(v)     (HW_CLKCTRL_SSP2.U = (v))
#define HW_CLKCTRL_SSP2_SET(v)    (HW_CLKCTRL_SSP2_WR(HW_CLKCTRL_SSP2_RD() |  (v)))
#define HW_CLKCTRL_SSP2_CLR(v)    (HW_CLKCTRL_SSP2_WR(HW_CLKCTRL_SSP2_RD() & ~(v)))
#define HW_CLKCTRL_SSP2_TOG(v)    (HW_CLKCTRL_SSP2_WR(HW_CLKCTRL_SSP2_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SSP2 bitfields
 */
/* --- Register HW_CLKCTRL_SSP2, field CLKGATE */

#define BP_CLKCTRL_SSP2_CLKGATE      31
#define BM_CLKCTRL_SSP2_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SSP2_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SSP2_CLKGATE)
#else
#define BF_CLKCTRL_SSP2_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SSP2_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP2_CLKGATE(v)   BF_CS1(CLKCTRL_SSP2, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SSP2, field RSRVD2 */

#define BP_CLKCTRL_SSP2_RSRVD2      30
#define BM_CLKCTRL_SSP2_RSRVD2      0x40000000

#define BF_CLKCTRL_SSP2_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SSP2_RSRVD2)
/* --- Register HW_CLKCTRL_SSP2, field BUSY */

#define BP_CLKCTRL_SSP2_BUSY      29
#define BM_CLKCTRL_SSP2_BUSY      0x20000000

#define BF_CLKCTRL_SSP2_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SSP2_BUSY)
/* --- Register HW_CLKCTRL_SSP2, field RSRVD1 */

#define BP_CLKCTRL_SSP2_RSRVD1      10
#define BM_CLKCTRL_SSP2_RSRVD1      0x1FFFFC00

#define BF_CLKCTRL_SSP2_RSRVD1(v)   (((v) << 10) & BM_CLKCTRL_SSP2_RSRVD1)
/* --- Register HW_CLKCTRL_SSP2, field DIV_FRAC_EN */

#define BP_CLKCTRL_SSP2_DIV_FRAC_EN      9
#define BM_CLKCTRL_SSP2_DIV_FRAC_EN      0x00000200

#define BF_CLKCTRL_SSP2_DIV_FRAC_EN(v)   (((v) << 9) & BM_CLKCTRL_SSP2_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP2_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SSP2, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SSP2, field DIV */

#define BP_CLKCTRL_SSP2_DIV      0
#define BM_CLKCTRL_SSP2_DIV      0x000001FF

#define BF_CLKCTRL_SSP2_DIV(v)   (((v) << 0) & BM_CLKCTRL_SSP2_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP2_DIV(v)   BF_CS1(CLKCTRL_SSP2, DIV, v)
#endif



/*
 * HW_CLKCTRL_SSP3 - Synchronous Serial Port3 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  9;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 19;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_ssp3_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SSP3 register
 */
#define HW_CLKCTRL_SSP3_ADDR         (REGS_CLKCTRL_BASE + 0xc0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SSP3           (*(volatile hw_clkctrl_ssp3_t *) HW_CLKCTRL_SSP3_ADDR)
#define HW_CLKCTRL_SSP3_RD()      (HW_CLKCTRL_SSP3.U)
#define HW_CLKCTRL_SSP3_WR(v)     (HW_CLKCTRL_SSP3.U = (v))
#define HW_CLKCTRL_SSP3_SET(v)    (HW_CLKCTRL_SSP3_WR(HW_CLKCTRL_SSP3_RD() |  (v)))
#define HW_CLKCTRL_SSP3_CLR(v)    (HW_CLKCTRL_SSP3_WR(HW_CLKCTRL_SSP3_RD() & ~(v)))
#define HW_CLKCTRL_SSP3_TOG(v)    (HW_CLKCTRL_SSP3_WR(HW_CLKCTRL_SSP3_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SSP3 bitfields
 */
/* --- Register HW_CLKCTRL_SSP3, field CLKGATE */

#define BP_CLKCTRL_SSP3_CLKGATE      31
#define BM_CLKCTRL_SSP3_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SSP3_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SSP3_CLKGATE)
#else
#define BF_CLKCTRL_SSP3_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SSP3_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP3_CLKGATE(v)   BF_CS1(CLKCTRL_SSP3, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SSP3, field RSRVD2 */

#define BP_CLKCTRL_SSP3_RSRVD2      30
#define BM_CLKCTRL_SSP3_RSRVD2      0x40000000

#define BF_CLKCTRL_SSP3_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SSP3_RSRVD2)
/* --- Register HW_CLKCTRL_SSP3, field BUSY */

#define BP_CLKCTRL_SSP3_BUSY      29
#define BM_CLKCTRL_SSP3_BUSY      0x20000000

#define BF_CLKCTRL_SSP3_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SSP3_BUSY)
/* --- Register HW_CLKCTRL_SSP3, field RSRVD1 */

#define BP_CLKCTRL_SSP3_RSRVD1      10
#define BM_CLKCTRL_SSP3_RSRVD1      0x1FFFFC00

#define BF_CLKCTRL_SSP3_RSRVD1(v)   (((v) << 10) & BM_CLKCTRL_SSP3_RSRVD1)
/* --- Register HW_CLKCTRL_SSP3, field DIV_FRAC_EN */

#define BP_CLKCTRL_SSP3_DIV_FRAC_EN      9
#define BM_CLKCTRL_SSP3_DIV_FRAC_EN      0x00000200

#define BF_CLKCTRL_SSP3_DIV_FRAC_EN(v)   (((v) << 9) & BM_CLKCTRL_SSP3_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP3_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SSP3, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SSP3, field DIV */

#define BP_CLKCTRL_SSP3_DIV      0
#define BM_CLKCTRL_SSP3_DIV      0x000001FF

#define BF_CLKCTRL_SSP3_DIV(v)   (((v) << 0) & BM_CLKCTRL_SSP3_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SSP3_DIV(v)   BF_CS1(CLKCTRL_SSP3, DIV, v)
#endif



/*
 * HW_CLKCTRL_GPMI - General-Purpose Media Interface Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 10;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 18;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_gpmi_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_GPMI register
 */
#define HW_CLKCTRL_GPMI_ADDR         (REGS_CLKCTRL_BASE + 0xd0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_GPMI           (*(volatile hw_clkctrl_gpmi_t *) HW_CLKCTRL_GPMI_ADDR)
#define HW_CLKCTRL_GPMI_RD()      (HW_CLKCTRL_GPMI.U)
#define HW_CLKCTRL_GPMI_WR(v)     (HW_CLKCTRL_GPMI.U = (v))
#define HW_CLKCTRL_GPMI_SET(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() |  (v)))
#define HW_CLKCTRL_GPMI_CLR(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() & ~(v)))
#define HW_CLKCTRL_GPMI_TOG(v)    (HW_CLKCTRL_GPMI_WR(HW_CLKCTRL_GPMI_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_GPMI bitfields
 */
/* --- Register HW_CLKCTRL_GPMI, field CLKGATE */

#define BP_CLKCTRL_GPMI_CLKGATE      31
#define BM_CLKCTRL_GPMI_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_GPMI_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_GPMI_CLKGATE)
#else
#define BF_CLKCTRL_GPMI_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_GPMI_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_CLKGATE(v)   BF_CS1(CLKCTRL_GPMI, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_GPMI, field RSRVD2 */

#define BP_CLKCTRL_GPMI_RSRVD2      30
#define BM_CLKCTRL_GPMI_RSRVD2      0x40000000

#define BF_CLKCTRL_GPMI_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_GPMI_RSRVD2)
/* --- Register HW_CLKCTRL_GPMI, field BUSY */

#define BP_CLKCTRL_GPMI_BUSY      29
#define BM_CLKCTRL_GPMI_BUSY      0x20000000

#define BF_CLKCTRL_GPMI_BUSY(v)   (((v) << 29) & BM_CLKCTRL_GPMI_BUSY)
/* --- Register HW_CLKCTRL_GPMI, field RSRVD1 */

#define BP_CLKCTRL_GPMI_RSRVD1      11
#define BM_CLKCTRL_GPMI_RSRVD1      0x1FFFF800

#define BF_CLKCTRL_GPMI_RSRVD1(v)   (((v) << 11) & BM_CLKCTRL_GPMI_RSRVD1)
/* --- Register HW_CLKCTRL_GPMI, field DIV_FRAC_EN */

#define BP_CLKCTRL_GPMI_DIV_FRAC_EN      10
#define BM_CLKCTRL_GPMI_DIV_FRAC_EN      0x00000400

#define BF_CLKCTRL_GPMI_DIV_FRAC_EN(v)   (((v) << 10) & BM_CLKCTRL_GPMI_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_GPMI, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_GPMI, field DIV */

#define BP_CLKCTRL_GPMI_DIV      0
#define BM_CLKCTRL_GPMI_DIV      0x000003FF

#define BF_CLKCTRL_GPMI_DIV(v)   (((v) << 0) & BM_CLKCTRL_GPMI_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_GPMI_DIV(v)   BF_CS1(CLKCTRL_GPMI, DIV, v)
#endif



/*
 * HW_CLKCTRL_SPDIF - SPDIF Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD    : 31;
        unsigned CLKGATE  :  1;
    } B;
} hw_clkctrl_spdif_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SPDIF register
 */
#define HW_CLKCTRL_SPDIF_ADDR         (REGS_CLKCTRL_BASE + 0xe0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SPDIF           (*(volatile hw_clkctrl_spdif_t *) HW_CLKCTRL_SPDIF_ADDR)
#define HW_CLKCTRL_SPDIF_RD()      (HW_CLKCTRL_SPDIF.U)
#define HW_CLKCTRL_SPDIF_WR(v)     (HW_CLKCTRL_SPDIF.U = (v))
#define HW_CLKCTRL_SPDIF_SET(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() |  (v)))
#define HW_CLKCTRL_SPDIF_CLR(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() & ~(v)))
#define HW_CLKCTRL_SPDIF_TOG(v)    (HW_CLKCTRL_SPDIF_WR(HW_CLKCTRL_SPDIF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SPDIF bitfields
 */
/* --- Register HW_CLKCTRL_SPDIF, field CLKGATE */

#define BP_CLKCTRL_SPDIF_CLKGATE      31
#define BM_CLKCTRL_SPDIF_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SPDIF_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SPDIF_CLKGATE)
#else
#define BF_CLKCTRL_SPDIF_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SPDIF_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SPDIF_CLKGATE(v)   BF_CS1(CLKCTRL_SPDIF, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SPDIF, field RSRVD */

#define BP_CLKCTRL_SPDIF_RSRVD      0
#define BM_CLKCTRL_SPDIF_RSRVD      0x7FFFFFFF

#define BF_CLKCTRL_SPDIF_RSRVD(v)   (((v) << 0) & BM_CLKCTRL_SPDIF_RSRVD)


/*
 * HW_CLKCTRL_EMI - EMI Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV_EMI            :  6;
        unsigned RSRVD1             :  2;
        unsigned DIV_XTAL           :  4;
        unsigned RSRVD2             :  4;
        unsigned DCC_RESYNC_ENABLE  :  1;
        unsigned BUSY_DCC_RESYNC    :  1;
        unsigned RSRVD3             :  8;
        unsigned BUSY_SYNC_MODE     :  1;
        unsigned BUSY_REF_CPU       :  1;
        unsigned BUSY_REF_EMI       :  1;
        unsigned BUSY_REF_XTAL      :  1;
        unsigned SYNC_MODE_EN       :  1;
        unsigned CLKGATE            :  1;
    } B;
} hw_clkctrl_emi_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_EMI register
 */
#define HW_CLKCTRL_EMI_ADDR         (REGS_CLKCTRL_BASE + 0xf0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_EMI           (*(volatile hw_clkctrl_emi_t *) HW_CLKCTRL_EMI_ADDR)
#define HW_CLKCTRL_EMI_RD()      (HW_CLKCTRL_EMI.U)
#define HW_CLKCTRL_EMI_WR(v)     (HW_CLKCTRL_EMI.U = (v))
#define HW_CLKCTRL_EMI_SET(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() |  (v)))
#define HW_CLKCTRL_EMI_CLR(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() & ~(v)))
#define HW_CLKCTRL_EMI_TOG(v)    (HW_CLKCTRL_EMI_WR(HW_CLKCTRL_EMI_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_EMI bitfields
 */
/* --- Register HW_CLKCTRL_EMI, field CLKGATE */

#define BP_CLKCTRL_EMI_CLKGATE      31
#define BM_CLKCTRL_EMI_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_EMI_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_EMI_CLKGATE)
#else
#define BF_CLKCTRL_EMI_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_EMI_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_CLKGATE(v)   BF_CS1(CLKCTRL_EMI, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_EMI, field SYNC_MODE_EN */

#define BP_CLKCTRL_EMI_SYNC_MODE_EN      30
#define BM_CLKCTRL_EMI_SYNC_MODE_EN      0x40000000

#define BF_CLKCTRL_EMI_SYNC_MODE_EN(v)   (((v) << 30) & BM_CLKCTRL_EMI_SYNC_MODE_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_SYNC_MODE_EN(v)   BF_CS1(CLKCTRL_EMI, SYNC_MODE_EN, v)
#endif

/* --- Register HW_CLKCTRL_EMI, field BUSY_REF_XTAL */

#define BP_CLKCTRL_EMI_BUSY_REF_XTAL      29
#define BM_CLKCTRL_EMI_BUSY_REF_XTAL      0x20000000

#define BF_CLKCTRL_EMI_BUSY_REF_XTAL(v)   (((v) << 29) & BM_CLKCTRL_EMI_BUSY_REF_XTAL)
/* --- Register HW_CLKCTRL_EMI, field BUSY_REF_EMI */

#define BP_CLKCTRL_EMI_BUSY_REF_EMI      28
#define BM_CLKCTRL_EMI_BUSY_REF_EMI      0x10000000

#define BF_CLKCTRL_EMI_BUSY_REF_EMI(v)   (((v) << 28) & BM_CLKCTRL_EMI_BUSY_REF_EMI)
/* --- Register HW_CLKCTRL_EMI, field BUSY_REF_CPU */

#define BP_CLKCTRL_EMI_BUSY_REF_CPU      27
#define BM_CLKCTRL_EMI_BUSY_REF_CPU      0x08000000

#define BF_CLKCTRL_EMI_BUSY_REF_CPU(v)   (((v) << 27) & BM_CLKCTRL_EMI_BUSY_REF_CPU)
/* --- Register HW_CLKCTRL_EMI, field BUSY_SYNC_MODE */

#define BP_CLKCTRL_EMI_BUSY_SYNC_MODE      26
#define BM_CLKCTRL_EMI_BUSY_SYNC_MODE      0x04000000

#define BF_CLKCTRL_EMI_BUSY_SYNC_MODE(v)   (((v) << 26) & BM_CLKCTRL_EMI_BUSY_SYNC_MODE)
/* --- Register HW_CLKCTRL_EMI, field RSRVD3 */

#define BP_CLKCTRL_EMI_RSRVD3      18
#define BM_CLKCTRL_EMI_RSRVD3      0x03FC0000

#define BF_CLKCTRL_EMI_RSRVD3(v)   (((v) << 18) & BM_CLKCTRL_EMI_RSRVD3)
/* --- Register HW_CLKCTRL_EMI, field BUSY_DCC_RESYNC */

#define BP_CLKCTRL_EMI_BUSY_DCC_RESYNC      17
#define BM_CLKCTRL_EMI_BUSY_DCC_RESYNC      0x00020000

#define BF_CLKCTRL_EMI_BUSY_DCC_RESYNC(v)   (((v) << 17) & BM_CLKCTRL_EMI_BUSY_DCC_RESYNC)
/* --- Register HW_CLKCTRL_EMI, field DCC_RESYNC_ENABLE */

#define BP_CLKCTRL_EMI_DCC_RESYNC_ENABLE      16
#define BM_CLKCTRL_EMI_DCC_RESYNC_ENABLE      0x00010000

#define BF_CLKCTRL_EMI_DCC_RESYNC_ENABLE(v)   (((v) << 16) & BM_CLKCTRL_EMI_DCC_RESYNC_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DCC_RESYNC_ENABLE(v)   BF_CS1(CLKCTRL_EMI, DCC_RESYNC_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_EMI, field RSRVD2 */

#define BP_CLKCTRL_EMI_RSRVD2      12
#define BM_CLKCTRL_EMI_RSRVD2      0x0000F000

#define BF_CLKCTRL_EMI_RSRVD2(v)   (((v) << 12) & BM_CLKCTRL_EMI_RSRVD2)
/* --- Register HW_CLKCTRL_EMI, field DIV_XTAL */

#define BP_CLKCTRL_EMI_DIV_XTAL      8
#define BM_CLKCTRL_EMI_DIV_XTAL      0x00000F00

#define BF_CLKCTRL_EMI_DIV_XTAL(v)   (((v) << 8) & BM_CLKCTRL_EMI_DIV_XTAL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DIV_XTAL(v)   BF_CS1(CLKCTRL_EMI, DIV_XTAL, v)
#endif

/* --- Register HW_CLKCTRL_EMI, field RSRVD1 */

#define BP_CLKCTRL_EMI_RSRVD1      6
#define BM_CLKCTRL_EMI_RSRVD1      0x000000C0

#define BF_CLKCTRL_EMI_RSRVD1(v)   (((v) << 6) & BM_CLKCTRL_EMI_RSRVD1)
/* --- Register HW_CLKCTRL_EMI, field DIV_EMI */

#define BP_CLKCTRL_EMI_DIV_EMI      0
#define BM_CLKCTRL_EMI_DIV_EMI      0x0000003F

#define BF_CLKCTRL_EMI_DIV_EMI(v)   (((v) << 0) & BM_CLKCTRL_EMI_DIV_EMI)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_EMI_DIV_EMI(v)   BF_CS1(CLKCTRL_EMI, DIV_EMI, v)
#endif



/*
 * HW_CLKCTRL_SAIF0 - SAIF0 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 16;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 12;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_saif0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SAIF0 register
 */
#define HW_CLKCTRL_SAIF0_ADDR         (REGS_CLKCTRL_BASE + 0x100)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SAIF0           (*(volatile hw_clkctrl_saif0_t *) HW_CLKCTRL_SAIF0_ADDR)
#define HW_CLKCTRL_SAIF0_RD()      (HW_CLKCTRL_SAIF0.U)
#define HW_CLKCTRL_SAIF0_WR(v)     (HW_CLKCTRL_SAIF0.U = (v))
#define HW_CLKCTRL_SAIF0_SET(v)    (HW_CLKCTRL_SAIF0_WR(HW_CLKCTRL_SAIF0_RD() |  (v)))
#define HW_CLKCTRL_SAIF0_CLR(v)    (HW_CLKCTRL_SAIF0_WR(HW_CLKCTRL_SAIF0_RD() & ~(v)))
#define HW_CLKCTRL_SAIF0_TOG(v)    (HW_CLKCTRL_SAIF0_WR(HW_CLKCTRL_SAIF0_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SAIF0 bitfields
 */
/* --- Register HW_CLKCTRL_SAIF0, field CLKGATE */

#define BP_CLKCTRL_SAIF0_CLKGATE      31
#define BM_CLKCTRL_SAIF0_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SAIF0_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SAIF0_CLKGATE)
#else
#define BF_CLKCTRL_SAIF0_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SAIF0_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF0_CLKGATE(v)   BF_CS1(CLKCTRL_SAIF0, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SAIF0, field RSRVD2 */

#define BP_CLKCTRL_SAIF0_RSRVD2      30
#define BM_CLKCTRL_SAIF0_RSRVD2      0x40000000

#define BF_CLKCTRL_SAIF0_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SAIF0_RSRVD2)
/* --- Register HW_CLKCTRL_SAIF0, field BUSY */

#define BP_CLKCTRL_SAIF0_BUSY      29
#define BM_CLKCTRL_SAIF0_BUSY      0x20000000

#define BF_CLKCTRL_SAIF0_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SAIF0_BUSY)
/* --- Register HW_CLKCTRL_SAIF0, field RSRVD1 */

#define BP_CLKCTRL_SAIF0_RSRVD1      17
#define BM_CLKCTRL_SAIF0_RSRVD1      0x1FFE0000

#define BF_CLKCTRL_SAIF0_RSRVD1(v)   (((v) << 17) & BM_CLKCTRL_SAIF0_RSRVD1)
/* --- Register HW_CLKCTRL_SAIF0, field DIV_FRAC_EN */

#define BP_CLKCTRL_SAIF0_DIV_FRAC_EN      16
#define BM_CLKCTRL_SAIF0_DIV_FRAC_EN      0x00010000

#define BF_CLKCTRL_SAIF0_DIV_FRAC_EN(v)   (((v) << 16) & BM_CLKCTRL_SAIF0_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF0_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SAIF0, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SAIF0, field DIV */

#define BP_CLKCTRL_SAIF0_DIV      0
#define BM_CLKCTRL_SAIF0_DIV      0x0000FFFF

#define BF_CLKCTRL_SAIF0_DIV(v)   (((v) << 0) & BM_CLKCTRL_SAIF0_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF0_DIV(v)   (HW_CLKCTRL_SAIF0.B.DIV = (v))
#endif



/*
 * HW_CLKCTRL_SAIF1 - SAIF1 Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 16;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 12;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_saif1_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_SAIF1 register
 */
#define HW_CLKCTRL_SAIF1_ADDR         (REGS_CLKCTRL_BASE + 0x110)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_SAIF1           (*(volatile hw_clkctrl_saif1_t *) HW_CLKCTRL_SAIF1_ADDR)
#define HW_CLKCTRL_SAIF1_RD()      (HW_CLKCTRL_SAIF1.U)
#define HW_CLKCTRL_SAIF1_WR(v)     (HW_CLKCTRL_SAIF1.U = (v))
#define HW_CLKCTRL_SAIF1_SET(v)    (HW_CLKCTRL_SAIF1_WR(HW_CLKCTRL_SAIF1_RD() |  (v)))
#define HW_CLKCTRL_SAIF1_CLR(v)    (HW_CLKCTRL_SAIF1_WR(HW_CLKCTRL_SAIF1_RD() & ~(v)))
#define HW_CLKCTRL_SAIF1_TOG(v)    (HW_CLKCTRL_SAIF1_WR(HW_CLKCTRL_SAIF1_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_SAIF1 bitfields
 */
/* --- Register HW_CLKCTRL_SAIF1, field CLKGATE */

#define BP_CLKCTRL_SAIF1_CLKGATE      31
#define BM_CLKCTRL_SAIF1_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_SAIF1_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_SAIF1_CLKGATE)
#else
#define BF_CLKCTRL_SAIF1_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_SAIF1_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF1_CLKGATE(v)   BF_CS1(CLKCTRL_SAIF1, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_SAIF1, field RSRVD2 */

#define BP_CLKCTRL_SAIF1_RSRVD2      30
#define BM_CLKCTRL_SAIF1_RSRVD2      0x40000000

#define BF_CLKCTRL_SAIF1_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_SAIF1_RSRVD2)
/* --- Register HW_CLKCTRL_SAIF1, field BUSY */

#define BP_CLKCTRL_SAIF1_BUSY      29
#define BM_CLKCTRL_SAIF1_BUSY      0x20000000

#define BF_CLKCTRL_SAIF1_BUSY(v)   (((v) << 29) & BM_CLKCTRL_SAIF1_BUSY)
/* --- Register HW_CLKCTRL_SAIF1, field RSRVD1 */

#define BP_CLKCTRL_SAIF1_RSRVD1      17
#define BM_CLKCTRL_SAIF1_RSRVD1      0x1FFE0000

#define BF_CLKCTRL_SAIF1_RSRVD1(v)   (((v) << 17) & BM_CLKCTRL_SAIF1_RSRVD1)
/* --- Register HW_CLKCTRL_SAIF1, field DIV_FRAC_EN */

#define BP_CLKCTRL_SAIF1_DIV_FRAC_EN      16
#define BM_CLKCTRL_SAIF1_DIV_FRAC_EN      0x00010000

#define BF_CLKCTRL_SAIF1_DIV_FRAC_EN(v)   (((v) << 16) & BM_CLKCTRL_SAIF1_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF1_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_SAIF1, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_SAIF1, field DIV */

#define BP_CLKCTRL_SAIF1_DIV      0
#define BM_CLKCTRL_SAIF1_DIV      0x0000FFFF

#define BF_CLKCTRL_SAIF1_DIV(v)   (((v) << 0) & BM_CLKCTRL_SAIF1_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_SAIF1_DIV(v)   (HW_CLKCTRL_SAIF1.B.DIV = (v))
#endif



/*
 * HW_CLKCTRL_DIS_LCDIF - CLK_DIS_LCDIF Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          : 13;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 15;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_dis_lcdif_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_DIS_LCDIF register
 */
#define HW_CLKCTRL_DIS_LCDIF_ADDR         (REGS_CLKCTRL_BASE + 0x120)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_DIS_LCDIF           (*(volatile hw_clkctrl_dis_lcdif_t *) HW_CLKCTRL_DIS_LCDIF_ADDR)
#define HW_CLKCTRL_DIS_LCDIF_RD()      (HW_CLKCTRL_DIS_LCDIF.U)
#define HW_CLKCTRL_DIS_LCDIF_WR(v)     (HW_CLKCTRL_DIS_LCDIF.U = (v))
#define HW_CLKCTRL_DIS_LCDIF_SET(v)    (HW_CLKCTRL_DIS_LCDIF_WR(HW_CLKCTRL_DIS_LCDIF_RD() |  (v)))
#define HW_CLKCTRL_DIS_LCDIF_CLR(v)    (HW_CLKCTRL_DIS_LCDIF_WR(HW_CLKCTRL_DIS_LCDIF_RD() & ~(v)))
#define HW_CLKCTRL_DIS_LCDIF_TOG(v)    (HW_CLKCTRL_DIS_LCDIF_WR(HW_CLKCTRL_DIS_LCDIF_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_DIS_LCDIF bitfields
 */
/* --- Register HW_CLKCTRL_DIS_LCDIF, field CLKGATE */

#define BP_CLKCTRL_DIS_LCDIF_CLKGATE      31
#define BM_CLKCTRL_DIS_LCDIF_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_DIS_LCDIF_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_DIS_LCDIF_CLKGATE)
#else
#define BF_CLKCTRL_DIS_LCDIF_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_DIS_LCDIF_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_DIS_LCDIF_CLKGATE(v)   BF_CS1(CLKCTRL_DIS_LCDIF, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_DIS_LCDIF, field RSRVD2 */

#define BP_CLKCTRL_DIS_LCDIF_RSRVD2      30
#define BM_CLKCTRL_DIS_LCDIF_RSRVD2      0x40000000

#define BF_CLKCTRL_DIS_LCDIF_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_DIS_LCDIF_RSRVD2)
/* --- Register HW_CLKCTRL_DIS_LCDIF, field BUSY */

#define BP_CLKCTRL_DIS_LCDIF_BUSY      29
#define BM_CLKCTRL_DIS_LCDIF_BUSY      0x20000000

#define BF_CLKCTRL_DIS_LCDIF_BUSY(v)   (((v) << 29) & BM_CLKCTRL_DIS_LCDIF_BUSY)
/* --- Register HW_CLKCTRL_DIS_LCDIF, field RSRVD1 */

#define BP_CLKCTRL_DIS_LCDIF_RSRVD1      14
#define BM_CLKCTRL_DIS_LCDIF_RSRVD1      0x1FFFC000

#define BF_CLKCTRL_DIS_LCDIF_RSRVD1(v)   (((v) << 14) & BM_CLKCTRL_DIS_LCDIF_RSRVD1)
/* --- Register HW_CLKCTRL_DIS_LCDIF, field DIV_FRAC_EN */

#define BP_CLKCTRL_DIS_LCDIF_DIV_FRAC_EN      13
#define BM_CLKCTRL_DIS_LCDIF_DIV_FRAC_EN      0x00002000

#define BF_CLKCTRL_DIS_LCDIF_DIV_FRAC_EN(v)   (((v) << 13) & BM_CLKCTRL_DIS_LCDIF_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_DIS_LCDIF_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_DIS_LCDIF, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_DIS_LCDIF, field DIV */

#define BP_CLKCTRL_DIS_LCDIF_DIV      0
#define BM_CLKCTRL_DIS_LCDIF_DIV      0x00001FFF

#define BF_CLKCTRL_DIS_LCDIF_DIV(v)   (((v) << 0) & BM_CLKCTRL_DIS_LCDIF_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_DIS_LCDIF_DIV(v)   BF_CS1(CLKCTRL_DIS_LCDIF, DIV, v)
#endif



/*
 * HW_CLKCTRL_ETM - ETM Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIV          :  7;
        unsigned DIV_FRAC_EN  :  1;
        unsigned RSRVD1       : 21;
        unsigned BUSY         :  1;
        unsigned RSRVD2       :  1;
        unsigned CLKGATE      :  1;
    } B;
} hw_clkctrl_etm_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_ETM register
 */
#define HW_CLKCTRL_ETM_ADDR         (REGS_CLKCTRL_BASE + 0x130)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_ETM           (*(volatile hw_clkctrl_etm_t *) HW_CLKCTRL_ETM_ADDR)
#define HW_CLKCTRL_ETM_RD()      (HW_CLKCTRL_ETM.U)
#define HW_CLKCTRL_ETM_WR(v)     (HW_CLKCTRL_ETM.U = (v))
#define HW_CLKCTRL_ETM_SET(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() |  (v)))
#define HW_CLKCTRL_ETM_CLR(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() & ~(v)))
#define HW_CLKCTRL_ETM_TOG(v)    (HW_CLKCTRL_ETM_WR(HW_CLKCTRL_ETM_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_ETM bitfields
 */
/* --- Register HW_CLKCTRL_ETM, field CLKGATE */

#define BP_CLKCTRL_ETM_CLKGATE      31
#define BM_CLKCTRL_ETM_CLKGATE      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_ETM_CLKGATE(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_ETM_CLKGATE)
#else
#define BF_CLKCTRL_ETM_CLKGATE(v)   (((v) << 31) & BM_CLKCTRL_ETM_CLKGATE)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_CLKGATE(v)   BF_CS1(CLKCTRL_ETM, CLKGATE, v)
#endif

/* --- Register HW_CLKCTRL_ETM, field RSRVD2 */

#define BP_CLKCTRL_ETM_RSRVD2      30
#define BM_CLKCTRL_ETM_RSRVD2      0x40000000

#define BF_CLKCTRL_ETM_RSRVD2(v)   (((v) << 30) & BM_CLKCTRL_ETM_RSRVD2)
/* --- Register HW_CLKCTRL_ETM, field BUSY */

#define BP_CLKCTRL_ETM_BUSY      29
#define BM_CLKCTRL_ETM_BUSY      0x20000000

#define BF_CLKCTRL_ETM_BUSY(v)   (((v) << 29) & BM_CLKCTRL_ETM_BUSY)
/* --- Register HW_CLKCTRL_ETM, field RSRVD1 */

#define BP_CLKCTRL_ETM_RSRVD1      8
#define BM_CLKCTRL_ETM_RSRVD1      0x1FFFFF00

#define BF_CLKCTRL_ETM_RSRVD1(v)   (((v) << 8) & BM_CLKCTRL_ETM_RSRVD1)
/* --- Register HW_CLKCTRL_ETM, field DIV_FRAC_EN */

#define BP_CLKCTRL_ETM_DIV_FRAC_EN      7
#define BM_CLKCTRL_ETM_DIV_FRAC_EN      0x00000080

#define BF_CLKCTRL_ETM_DIV_FRAC_EN(v)   (((v) << 7) & BM_CLKCTRL_ETM_DIV_FRAC_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_DIV_FRAC_EN(v)   BF_CS1(CLKCTRL_ETM, DIV_FRAC_EN, v)
#endif

/* --- Register HW_CLKCTRL_ETM, field DIV */

#define BP_CLKCTRL_ETM_DIV      0
#define BM_CLKCTRL_ETM_DIV      0x0000007F

#define BF_CLKCTRL_ETM_DIV(v)   (((v) << 0) & BM_CLKCTRL_ETM_DIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ETM_DIV(v)   BF_CS1(CLKCTRL_ETM, DIV, v)
#endif



/*
 * HW_CLKCTRL_ENET - ENET Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD0            : 16;
        unsigned RESET_BY_SW       :  1;
        unsigned RESET_BY_SW_CHIP  :  1;
        unsigned CLK_OUT_EN        :  1;
        unsigned TIME_SEL          :  2;
        unsigned DIV_TIME          :  6;
        unsigned BUSY_TIME         :  1;
        unsigned RSRVD1            :  1;
        unsigned STATUS            :  1;
        unsigned DISABLE           :  1;
        unsigned SLEEP             :  1;
    } B;
} hw_clkctrl_enet_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_ENET register
 */
#define HW_CLKCTRL_ENET_ADDR         (REGS_CLKCTRL_BASE + 0x140)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_ENET           (*(volatile hw_clkctrl_enet_t *) HW_CLKCTRL_ENET_ADDR)
#define HW_CLKCTRL_ENET_RD()      (HW_CLKCTRL_ENET.U)
#define HW_CLKCTRL_ENET_WR(v)     (HW_CLKCTRL_ENET.U = (v))
#define HW_CLKCTRL_ENET_SET(v)    (HW_CLKCTRL_ENET_WR(HW_CLKCTRL_ENET_RD() |  (v)))
#define HW_CLKCTRL_ENET_CLR(v)    (HW_CLKCTRL_ENET_WR(HW_CLKCTRL_ENET_RD() & ~(v)))
#define HW_CLKCTRL_ENET_TOG(v)    (HW_CLKCTRL_ENET_WR(HW_CLKCTRL_ENET_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_ENET bitfields
 */
/* --- Register HW_CLKCTRL_ENET, field SLEEP */

#define BP_CLKCTRL_ENET_SLEEP      31
#define BM_CLKCTRL_ENET_SLEEP      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_ENET_SLEEP(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_ENET_SLEEP)
#else
#define BF_CLKCTRL_ENET_SLEEP(v)   (((v) << 31) & BM_CLKCTRL_ENET_SLEEP)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_SLEEP(v)   BF_CS1(CLKCTRL_ENET, SLEEP, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field DISABLE */

#define BP_CLKCTRL_ENET_DISABLE      30
#define BM_CLKCTRL_ENET_DISABLE      0x40000000

#define BF_CLKCTRL_ENET_DISABLE(v)   (((v) << 30) & BM_CLKCTRL_ENET_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_DISABLE(v)   BF_CS1(CLKCTRL_ENET, DISABLE, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field STATUS */

#define BP_CLKCTRL_ENET_STATUS      29
#define BM_CLKCTRL_ENET_STATUS      0x20000000

#define BF_CLKCTRL_ENET_STATUS(v)   (((v) << 29) & BM_CLKCTRL_ENET_STATUS)
/* --- Register HW_CLKCTRL_ENET, field RSRVD1 */

#define BP_CLKCTRL_ENET_RSRVD1      28
#define BM_CLKCTRL_ENET_RSRVD1      0x10000000

#define BF_CLKCTRL_ENET_RSRVD1(v)   (((v) << 28) & BM_CLKCTRL_ENET_RSRVD1)
/* --- Register HW_CLKCTRL_ENET, field BUSY_TIME */

#define BP_CLKCTRL_ENET_BUSY_TIME      27
#define BM_CLKCTRL_ENET_BUSY_TIME      0x08000000

#define BF_CLKCTRL_ENET_BUSY_TIME(v)   (((v) << 27) & BM_CLKCTRL_ENET_BUSY_TIME)
/* --- Register HW_CLKCTRL_ENET, field DIV_TIME */

#define BP_CLKCTRL_ENET_DIV_TIME      21
#define BM_CLKCTRL_ENET_DIV_TIME      0x07E00000

#define BF_CLKCTRL_ENET_DIV_TIME(v)   (((v) << 21) & BM_CLKCTRL_ENET_DIV_TIME)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_DIV_TIME(v)   BF_CS1(CLKCTRL_ENET, DIV_TIME, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field TIME_SEL */

#define BP_CLKCTRL_ENET_TIME_SEL      19
#define BM_CLKCTRL_ENET_TIME_SEL      0x00180000

#define BF_CLKCTRL_ENET_TIME_SEL(v)   (((v) << 19) & BM_CLKCTRL_ENET_TIME_SEL)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_TIME_SEL(v)   BF_CS1(CLKCTRL_ENET, TIME_SEL, v)
#endif

#define BV_CLKCTRL_ENET_TIME_SEL__XTAL       0x0
#define BV_CLKCTRL_ENET_TIME_SEL__PLL        0x1
#define BV_CLKCTRL_ENET_TIME_SEL__RMII_CLK   0x2
#define BV_CLKCTRL_ENET_TIME_SEL__UNDEFINED  0x3

/* --- Register HW_CLKCTRL_ENET, field CLK_OUT_EN */

#define BP_CLKCTRL_ENET_CLK_OUT_EN      18
#define BM_CLKCTRL_ENET_CLK_OUT_EN      0x00040000

#define BF_CLKCTRL_ENET_CLK_OUT_EN(v)   (((v) << 18) & BM_CLKCTRL_ENET_CLK_OUT_EN)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_CLK_OUT_EN(v)   BF_CS1(CLKCTRL_ENET, CLK_OUT_EN, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field RESET_BY_SW_CHIP */

#define BP_CLKCTRL_ENET_RESET_BY_SW_CHIP      17
#define BM_CLKCTRL_ENET_RESET_BY_SW_CHIP      0x00020000

#define BF_CLKCTRL_ENET_RESET_BY_SW_CHIP(v)   (((v) << 17) & BM_CLKCTRL_ENET_RESET_BY_SW_CHIP)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_RESET_BY_SW_CHIP(v)   BF_CS1(CLKCTRL_ENET, RESET_BY_SW_CHIP, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field RESET_BY_SW */

#define BP_CLKCTRL_ENET_RESET_BY_SW      16
#define BM_CLKCTRL_ENET_RESET_BY_SW      0x00010000

#define BF_CLKCTRL_ENET_RESET_BY_SW(v)   (((v) << 16) & BM_CLKCTRL_ENET_RESET_BY_SW)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_ENET_RESET_BY_SW(v)   BF_CS1(CLKCTRL_ENET, RESET_BY_SW, v)
#endif

/* --- Register HW_CLKCTRL_ENET, field RSRVD0 */

#define BP_CLKCTRL_ENET_RSRVD0      0
#define BM_CLKCTRL_ENET_RSRVD0      0x0000FFFF

#define BF_CLKCTRL_ENET_RSRVD0(v)   (((v) << 0) & BM_CLKCTRL_ENET_RSRVD0)


/*
 * HW_CLKCTRL_HSADC - HSADC Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1   : 28;
        unsigned FREQDIV  :  2;
        unsigned RESETB   :  1;
        unsigned RSRVD2   :  1;
    } B;
} hw_clkctrl_hsadc_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_HSADC register
 */
#define HW_CLKCTRL_HSADC_ADDR         (REGS_CLKCTRL_BASE + 0x150)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_HSADC           (*(volatile hw_clkctrl_hsadc_t *) HW_CLKCTRL_HSADC_ADDR)
#define HW_CLKCTRL_HSADC_RD()      (HW_CLKCTRL_HSADC.U)
#define HW_CLKCTRL_HSADC_WR(v)     (HW_CLKCTRL_HSADC.U = (v))
#define HW_CLKCTRL_HSADC_SET(v)    (HW_CLKCTRL_HSADC_WR(HW_CLKCTRL_HSADC_RD() |  (v)))
#define HW_CLKCTRL_HSADC_CLR(v)    (HW_CLKCTRL_HSADC_WR(HW_CLKCTRL_HSADC_RD() & ~(v)))
#define HW_CLKCTRL_HSADC_TOG(v)    (HW_CLKCTRL_HSADC_WR(HW_CLKCTRL_HSADC_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_HSADC bitfields
 */
/* --- Register HW_CLKCTRL_HSADC, field RSRVD2 */

#define BP_CLKCTRL_HSADC_RSRVD2      31
#define BM_CLKCTRL_HSADC_RSRVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_HSADC_RSRVD2(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_HSADC_RSRVD2)
#else
#define BF_CLKCTRL_HSADC_RSRVD2(v)   (((v) << 31) & BM_CLKCTRL_HSADC_RSRVD2)
#endif
/* --- Register HW_CLKCTRL_HSADC, field RESETB */

#define BP_CLKCTRL_HSADC_RESETB      30
#define BM_CLKCTRL_HSADC_RESETB      0x40000000

#define BF_CLKCTRL_HSADC_RESETB(v)   (((v) << 30) & BM_CLKCTRL_HSADC_RESETB)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HSADC_RESETB(v)   BF_CS1(CLKCTRL_HSADC, RESETB, v)
#endif

/* --- Register HW_CLKCTRL_HSADC, field FREQDIV */

#define BP_CLKCTRL_HSADC_FREQDIV      28
#define BM_CLKCTRL_HSADC_FREQDIV      0x30000000

#define BF_CLKCTRL_HSADC_FREQDIV(v)   (((v) << 28) & BM_CLKCTRL_HSADC_FREQDIV)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_HSADC_FREQDIV(v)   BF_CS1(CLKCTRL_HSADC, FREQDIV, v)
#endif

/* --- Register HW_CLKCTRL_HSADC, field RSRVD1 */

#define BP_CLKCTRL_HSADC_RSRVD1      0
#define BM_CLKCTRL_HSADC_RSRVD1      0x0FFFFFFF

#define BF_CLKCTRL_HSADC_RSRVD1(v)   (((v) << 0) & BM_CLKCTRL_HSADC_RSRVD1)


/*
 * HW_CLKCTRL_FLEXCAN - FLEXCAN Clock Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1       : 27;
        unsigned CAN1_STATUS  :  1;
        unsigned STOP_CAN1    :  1;
        unsigned CAN0_STATUS  :  1;
        unsigned STOP_CAN0    :  1;
        unsigned RSRVD2       :  1;
    } B;
} hw_clkctrl_flexcan_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_FLEXCAN register
 */
#define HW_CLKCTRL_FLEXCAN_ADDR         (REGS_CLKCTRL_BASE + 0x160)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_FLEXCAN           (*(volatile hw_clkctrl_flexcan_t *) HW_CLKCTRL_FLEXCAN_ADDR)
#define HW_CLKCTRL_FLEXCAN_RD()      (HW_CLKCTRL_FLEXCAN.U)
#define HW_CLKCTRL_FLEXCAN_WR(v)     (HW_CLKCTRL_FLEXCAN.U = (v))
#define HW_CLKCTRL_FLEXCAN_SET(v)    (HW_CLKCTRL_FLEXCAN_WR(HW_CLKCTRL_FLEXCAN_RD() |  (v)))
#define HW_CLKCTRL_FLEXCAN_CLR(v)    (HW_CLKCTRL_FLEXCAN_WR(HW_CLKCTRL_FLEXCAN_RD() & ~(v)))
#define HW_CLKCTRL_FLEXCAN_TOG(v)    (HW_CLKCTRL_FLEXCAN_WR(HW_CLKCTRL_FLEXCAN_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_FLEXCAN bitfields
 */
/* --- Register HW_CLKCTRL_FLEXCAN, field RSRVD2 */

#define BP_CLKCTRL_FLEXCAN_RSRVD2      31
#define BM_CLKCTRL_FLEXCAN_RSRVD2      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_FLEXCAN_RSRVD2(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_FLEXCAN_RSRVD2)
#else
#define BF_CLKCTRL_FLEXCAN_RSRVD2(v)   (((v) << 31) & BM_CLKCTRL_FLEXCAN_RSRVD2)
#endif
/* --- Register HW_CLKCTRL_FLEXCAN, field STOP_CAN0 */

#define BP_CLKCTRL_FLEXCAN_STOP_CAN0      30
#define BM_CLKCTRL_FLEXCAN_STOP_CAN0      0x40000000

#define BF_CLKCTRL_FLEXCAN_STOP_CAN0(v)   (((v) << 30) & BM_CLKCTRL_FLEXCAN_STOP_CAN0)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FLEXCAN_STOP_CAN0(v)   BF_CS1(CLKCTRL_FLEXCAN, STOP_CAN0, v)
#endif

/* --- Register HW_CLKCTRL_FLEXCAN, field CAN0_STATUS */

#define BP_CLKCTRL_FLEXCAN_CAN0_STATUS      29
#define BM_CLKCTRL_FLEXCAN_CAN0_STATUS      0x20000000

#define BF_CLKCTRL_FLEXCAN_CAN0_STATUS(v)   (((v) << 29) & BM_CLKCTRL_FLEXCAN_CAN0_STATUS)
/* --- Register HW_CLKCTRL_FLEXCAN, field STOP_CAN1 */

#define BP_CLKCTRL_FLEXCAN_STOP_CAN1      28
#define BM_CLKCTRL_FLEXCAN_STOP_CAN1      0x10000000

#define BF_CLKCTRL_FLEXCAN_STOP_CAN1(v)   (((v) << 28) & BM_CLKCTRL_FLEXCAN_STOP_CAN1)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FLEXCAN_STOP_CAN1(v)   BF_CS1(CLKCTRL_FLEXCAN, STOP_CAN1, v)
#endif

/* --- Register HW_CLKCTRL_FLEXCAN, field CAN1_STATUS */

#define BP_CLKCTRL_FLEXCAN_CAN1_STATUS      27
#define BM_CLKCTRL_FLEXCAN_CAN1_STATUS      0x08000000

#define BF_CLKCTRL_FLEXCAN_CAN1_STATUS(v)   (((v) << 27) & BM_CLKCTRL_FLEXCAN_CAN1_STATUS)
/* --- Register HW_CLKCTRL_FLEXCAN, field RSRVD1 */

#define BP_CLKCTRL_FLEXCAN_RSRVD1      0
#define BM_CLKCTRL_FLEXCAN_RSRVD1      0x07FFFFFF

#define BF_CLKCTRL_FLEXCAN_RSRVD1(v)   (((v) << 0) & BM_CLKCTRL_FLEXCAN_RSRVD1)


/*
 * HW_CLKCTRL_FRAC0 - Fractional Clock Control Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned CPUFRAC     :  6;
        unsigned CPU_STABLE  :  1;
        unsigned CLKGATECPU  :  1;
        unsigned EMIFRAC     :  6;
        unsigned EMI_STABLE  :  1;
        unsigned CLKGATEEMI  :  1;
        unsigned IO1FRAC     :  6;
        unsigned IO1_STABLE  :  1;
        unsigned CLKGATEIO1  :  1;
        unsigned IO0FRAC     :  6;
        unsigned IO0_STABLE  :  1;
        unsigned CLKGATEIO0  :  1;
    } B;
} hw_clkctrl_frac0_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_FRAC0 register
 */
#define HW_CLKCTRL_FRAC0_ADDR         (REGS_CLKCTRL_BASE + 0x1b0)
#define HW_CLKCTRL_FRAC0_SET_ADDR     (HW_CLKCTRL_FRAC0_ADDR + 4)
#define HW_CLKCTRL_FRAC0_CLR_ADDR     (HW_CLKCTRL_FRAC0_ADDR + 8)
#define HW_CLKCTRL_FRAC0_TOG_ADDR     (HW_CLKCTRL_FRAC0_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_FRAC0           (*(volatile hw_clkctrl_frac0_t *) HW_CLKCTRL_FRAC0_ADDR)
#define HW_CLKCTRL_FRAC0_RD()      (HW_CLKCTRL_FRAC0.U)
#define HW_CLKCTRL_FRAC0_WR(v)     (HW_CLKCTRL_FRAC0.U = (v))
#define HW_CLKCTRL_FRAC0_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC0_SET_ADDR) = (v))
#define HW_CLKCTRL_FRAC0_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC0_CLR_ADDR) = (v))
#define HW_CLKCTRL_FRAC0_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC0_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_FRAC0 bitfields
 */
/* --- Register HW_CLKCTRL_FRAC0, field CLKGATEIO0 */

#define BP_CLKCTRL_FRAC0_CLKGATEIO0      31
#define BM_CLKCTRL_FRAC0_CLKGATEIO0      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_FRAC0_CLKGATEIO0(v)   ((((reg32_t) v) << 31) & BM_CLKCTRL_FRAC0_CLKGATEIO0)
#else
#define BF_CLKCTRL_FRAC0_CLKGATEIO0(v)   (((v) << 31) & BM_CLKCTRL_FRAC0_CLKGATEIO0)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_CLKGATEIO0(v)   BF_CS1(CLKCTRL_FRAC0, CLKGATEIO0, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field IO0_STABLE */

#define BP_CLKCTRL_FRAC0_IO0_STABLE      30
#define BM_CLKCTRL_FRAC0_IO0_STABLE      0x40000000

#define BF_CLKCTRL_FRAC0_IO0_STABLE(v)   (((v) << 30) & BM_CLKCTRL_FRAC0_IO0_STABLE)
/* --- Register HW_CLKCTRL_FRAC0, field IO0FRAC */

#define BP_CLKCTRL_FRAC0_IO0FRAC      24
#define BM_CLKCTRL_FRAC0_IO0FRAC      0x3F000000

#define BF_CLKCTRL_FRAC0_IO0FRAC(v)   (((v) << 24) & BM_CLKCTRL_FRAC0_IO0FRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_IO0FRAC(v)   BF_CS1(CLKCTRL_FRAC0, IO0FRAC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field CLKGATEIO1 */

#define BP_CLKCTRL_FRAC0_CLKGATEIO1      23
#define BM_CLKCTRL_FRAC0_CLKGATEIO1      0x00800000

#define BF_CLKCTRL_FRAC0_CLKGATEIO1(v)   (((v) << 23) & BM_CLKCTRL_FRAC0_CLKGATEIO1)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_CLKGATEIO1(v)   BF_CS1(CLKCTRL_FRAC0, CLKGATEIO1, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field IO1_STABLE */

#define BP_CLKCTRL_FRAC0_IO1_STABLE      22
#define BM_CLKCTRL_FRAC0_IO1_STABLE      0x00400000

#define BF_CLKCTRL_FRAC0_IO1_STABLE(v)   (((v) << 22) & BM_CLKCTRL_FRAC0_IO1_STABLE)
/* --- Register HW_CLKCTRL_FRAC0, field IO1FRAC */

#define BP_CLKCTRL_FRAC0_IO1FRAC      16
#define BM_CLKCTRL_FRAC0_IO1FRAC      0x003F0000

#define BF_CLKCTRL_FRAC0_IO1FRAC(v)   (((v) << 16) & BM_CLKCTRL_FRAC0_IO1FRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_IO1FRAC(v)   BF_CS1(CLKCTRL_FRAC0, IO1FRAC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field CLKGATEEMI */

#define BP_CLKCTRL_FRAC0_CLKGATEEMI      15
#define BM_CLKCTRL_FRAC0_CLKGATEEMI      0x00008000

#define BF_CLKCTRL_FRAC0_CLKGATEEMI(v)   (((v) << 15) & BM_CLKCTRL_FRAC0_CLKGATEEMI)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_CLKGATEEMI(v)   BF_CS1(CLKCTRL_FRAC0, CLKGATEEMI, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field EMI_STABLE */

#define BP_CLKCTRL_FRAC0_EMI_STABLE      14
#define BM_CLKCTRL_FRAC0_EMI_STABLE      0x00004000

#define BF_CLKCTRL_FRAC0_EMI_STABLE(v)   (((v) << 14) & BM_CLKCTRL_FRAC0_EMI_STABLE)
/* --- Register HW_CLKCTRL_FRAC0, field EMIFRAC */

#define BP_CLKCTRL_FRAC0_EMIFRAC      8
#define BM_CLKCTRL_FRAC0_EMIFRAC      0x00003F00

#define BF_CLKCTRL_FRAC0_EMIFRAC(v)   (((v) << 8) & BM_CLKCTRL_FRAC0_EMIFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_EMIFRAC(v)   BF_CS1(CLKCTRL_FRAC0, EMIFRAC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field CLKGATECPU */

#define BP_CLKCTRL_FRAC0_CLKGATECPU      7
#define BM_CLKCTRL_FRAC0_CLKGATECPU      0x00000080

#define BF_CLKCTRL_FRAC0_CLKGATECPU(v)   (((v) << 7) & BM_CLKCTRL_FRAC0_CLKGATECPU)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_CLKGATECPU(v)   BF_CS1(CLKCTRL_FRAC0, CLKGATECPU, v)
#endif

/* --- Register HW_CLKCTRL_FRAC0, field CPU_STABLE */

#define BP_CLKCTRL_FRAC0_CPU_STABLE      6
#define BM_CLKCTRL_FRAC0_CPU_STABLE      0x00000040

#define BF_CLKCTRL_FRAC0_CPU_STABLE(v)   (((v) << 6) & BM_CLKCTRL_FRAC0_CPU_STABLE)
/* --- Register HW_CLKCTRL_FRAC0, field CPUFRAC */

#define BP_CLKCTRL_FRAC0_CPUFRAC      0
#define BM_CLKCTRL_FRAC0_CPUFRAC      0x0000003F

#define BF_CLKCTRL_FRAC0_CPUFRAC(v)   (((v) << 0) & BM_CLKCTRL_FRAC0_CPUFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC0_CPUFRAC(v)   BF_CS1(CLKCTRL_FRAC0, CPUFRAC, v)
#endif



/*
 * HW_CLKCTRL_FRAC1 - Fractional Clock Control Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PIXFRAC       :  6;
        unsigned PIX_STABLE    :  1;
        unsigned CLKGATEPIX    :  1;
        unsigned HSADCFRAC     :  6;
        unsigned HSADC_STABLE  :  1;
        unsigned CLKGATEHSADC  :  1;
        unsigned GPMIFRAC      :  6;
        unsigned GPMI_STABLE   :  1;
        unsigned CLKGATEGPMI   :  1;
        unsigned RSRVD2        :  8;
    } B;
} hw_clkctrl_frac1_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_FRAC1 register
 */
#define HW_CLKCTRL_FRAC1_ADDR         (REGS_CLKCTRL_BASE + 0x1c0)
#define HW_CLKCTRL_FRAC1_SET_ADDR     (HW_CLKCTRL_FRAC1_ADDR + 4)
#define HW_CLKCTRL_FRAC1_CLR_ADDR     (HW_CLKCTRL_FRAC1_ADDR + 8)
#define HW_CLKCTRL_FRAC1_TOG_ADDR     (HW_CLKCTRL_FRAC1_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_FRAC1           (*(volatile hw_clkctrl_frac1_t *) HW_CLKCTRL_FRAC1_ADDR)
#define HW_CLKCTRL_FRAC1_RD()      (HW_CLKCTRL_FRAC1.U)
#define HW_CLKCTRL_FRAC1_WR(v)     (HW_CLKCTRL_FRAC1.U = (v))
#define HW_CLKCTRL_FRAC1_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_SET_ADDR) = (v))
#define HW_CLKCTRL_FRAC1_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_CLR_ADDR) = (v))
#define HW_CLKCTRL_FRAC1_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_FRAC1_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_FRAC1 bitfields
 */
/* --- Register HW_CLKCTRL_FRAC1, field RSRVD2 */

#define BP_CLKCTRL_FRAC1_RSRVD2      24
#define BM_CLKCTRL_FRAC1_RSRVD2      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_FRAC1_RSRVD2(v)   ((((reg32_t) v) << 24) & BM_CLKCTRL_FRAC1_RSRVD2)
#else
#define BF_CLKCTRL_FRAC1_RSRVD2(v)   (((v) << 24) & BM_CLKCTRL_FRAC1_RSRVD2)
#endif
/* --- Register HW_CLKCTRL_FRAC1, field CLKGATEGPMI */

#define BP_CLKCTRL_FRAC1_CLKGATEGPMI      23
#define BM_CLKCTRL_FRAC1_CLKGATEGPMI      0x00800000

#define BF_CLKCTRL_FRAC1_CLKGATEGPMI(v)   (((v) << 23) & BM_CLKCTRL_FRAC1_CLKGATEGPMI)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_CLKGATEGPMI(v)   BF_CS1(CLKCTRL_FRAC1, CLKGATEGPMI, v)
#endif

/* --- Register HW_CLKCTRL_FRAC1, field GPMI_STABLE */

#define BP_CLKCTRL_FRAC1_GPMI_STABLE      22
#define BM_CLKCTRL_FRAC1_GPMI_STABLE      0x00400000

#define BF_CLKCTRL_FRAC1_GPMI_STABLE(v)   (((v) << 22) & BM_CLKCTRL_FRAC1_GPMI_STABLE)
/* --- Register HW_CLKCTRL_FRAC1, field GPMIFRAC */

#define BP_CLKCTRL_FRAC1_GPMIFRAC      16
#define BM_CLKCTRL_FRAC1_GPMIFRAC      0x003F0000

#define BF_CLKCTRL_FRAC1_GPMIFRAC(v)   (((v) << 16) & BM_CLKCTRL_FRAC1_GPMIFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_GPMIFRAC(v)   BF_CS1(CLKCTRL_FRAC1, GPMIFRAC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC1, field CLKGATEHSADC */

#define BP_CLKCTRL_FRAC1_CLKGATEHSADC      15
#define BM_CLKCTRL_FRAC1_CLKGATEHSADC      0x00008000

#define BF_CLKCTRL_FRAC1_CLKGATEHSADC(v)   (((v) << 15) & BM_CLKCTRL_FRAC1_CLKGATEHSADC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_CLKGATEHSADC(v)   BF_CS1(CLKCTRL_FRAC1, CLKGATEHSADC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC1, field HSADC_STABLE */

#define BP_CLKCTRL_FRAC1_HSADC_STABLE      14
#define BM_CLKCTRL_FRAC1_HSADC_STABLE      0x00004000

#define BF_CLKCTRL_FRAC1_HSADC_STABLE(v)   (((v) << 14) & BM_CLKCTRL_FRAC1_HSADC_STABLE)
/* --- Register HW_CLKCTRL_FRAC1, field HSADCFRAC */

#define BP_CLKCTRL_FRAC1_HSADCFRAC      8
#define BM_CLKCTRL_FRAC1_HSADCFRAC      0x00003F00

#define BF_CLKCTRL_FRAC1_HSADCFRAC(v)   (((v) << 8) & BM_CLKCTRL_FRAC1_HSADCFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_HSADCFRAC(v)   BF_CS1(CLKCTRL_FRAC1, HSADCFRAC, v)
#endif

/* --- Register HW_CLKCTRL_FRAC1, field CLKGATEPIX */

#define BP_CLKCTRL_FRAC1_CLKGATEPIX      7
#define BM_CLKCTRL_FRAC1_CLKGATEPIX      0x00000080

#define BF_CLKCTRL_FRAC1_CLKGATEPIX(v)   (((v) << 7) & BM_CLKCTRL_FRAC1_CLKGATEPIX)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_CLKGATEPIX(v)   BF_CS1(CLKCTRL_FRAC1, CLKGATEPIX, v)
#endif

/* --- Register HW_CLKCTRL_FRAC1, field PIX_STABLE */

#define BP_CLKCTRL_FRAC1_PIX_STABLE      6
#define BM_CLKCTRL_FRAC1_PIX_STABLE      0x00000040

#define BF_CLKCTRL_FRAC1_PIX_STABLE(v)   (((v) << 6) & BM_CLKCTRL_FRAC1_PIX_STABLE)
/* --- Register HW_CLKCTRL_FRAC1, field PIXFRAC */

#define BP_CLKCTRL_FRAC1_PIXFRAC      0
#define BM_CLKCTRL_FRAC1_PIXFRAC      0x0000003F

#define BF_CLKCTRL_FRAC1_PIXFRAC(v)   (((v) << 0) & BM_CLKCTRL_FRAC1_PIXFRAC)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_FRAC1_PIXFRAC(v)   BF_CS1(CLKCTRL_FRAC1, PIXFRAC, v)
#endif



/*
 * HW_CLKCTRL_CLKSEQ - Clock Frequency Sequence Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BYPASS_SAIF0      :  1;
        unsigned BYPASS_SAIF1      :  1;
        unsigned BYPASS_GPMI       :  1;
        unsigned BYPASS_SSP0       :  1;
        unsigned BYPASS_SSP1       :  1;
        unsigned BYPASS_SSP2       :  1;
        unsigned BYPASS_SSP3       :  1;
        unsigned BYPASS_EMI        :  1;
        unsigned BYPASS_ETM        :  1;
        unsigned RSRVD2            :  5;
        unsigned BYPASS_DIS_LCDIF  :  1;
        unsigned RSRVD1            :  3;
        unsigned BYPASS_CPU        :  1;
        unsigned RSRVD0            : 13;
    } B;
} hw_clkctrl_clkseq_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_CLKSEQ register
 */
#define HW_CLKCTRL_CLKSEQ_ADDR         (REGS_CLKCTRL_BASE + 0x1d0)
#define HW_CLKCTRL_CLKSEQ_SET_ADDR     (HW_CLKCTRL_CLKSEQ_ADDR + 4)
#define HW_CLKCTRL_CLKSEQ_CLR_ADDR     (HW_CLKCTRL_CLKSEQ_ADDR + 8)
#define HW_CLKCTRL_CLKSEQ_TOG_ADDR     (HW_CLKCTRL_CLKSEQ_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_CLKSEQ           (*(volatile hw_clkctrl_clkseq_t *) HW_CLKCTRL_CLKSEQ_ADDR)
#define HW_CLKCTRL_CLKSEQ_RD()      (HW_CLKCTRL_CLKSEQ.U)
#define HW_CLKCTRL_CLKSEQ_WR(v)     (HW_CLKCTRL_CLKSEQ.U = (v))
#define HW_CLKCTRL_CLKSEQ_SET(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_SET_ADDR) = (v))
#define HW_CLKCTRL_CLKSEQ_CLR(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_CLR_ADDR) = (v))
#define HW_CLKCTRL_CLKSEQ_TOG(v)    ((*(volatile reg32_t *) HW_CLKCTRL_CLKSEQ_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_CLKSEQ bitfields
 */
/* --- Register HW_CLKCTRL_CLKSEQ, field RSRVD0 */

#define BP_CLKCTRL_CLKSEQ_RSRVD0      19
#define BM_CLKCTRL_CLKSEQ_RSRVD0      0xFFF80000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_CLKSEQ_RSRVD0(v)   ((((reg32_t) v) << 19) & BM_CLKCTRL_CLKSEQ_RSRVD0)
#else
#define BF_CLKCTRL_CLKSEQ_RSRVD0(v)   (((v) << 19) & BM_CLKCTRL_CLKSEQ_RSRVD0)
#endif
/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_CPU */

#define BP_CLKCTRL_CLKSEQ_BYPASS_CPU      18
#define BM_CLKCTRL_CLKSEQ_BYPASS_CPU      0x00040000

#define BF_CLKCTRL_CLKSEQ_BYPASS_CPU(v)   (((v) << 18) & BM_CLKCTRL_CLKSEQ_BYPASS_CPU)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_CPU(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_CPU, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field RSRVD1 */

#define BP_CLKCTRL_CLKSEQ_RSRVD1      15
#define BM_CLKCTRL_CLKSEQ_RSRVD1      0x00038000

#define BF_CLKCTRL_CLKSEQ_RSRVD1(v)   (((v) << 15) & BM_CLKCTRL_CLKSEQ_RSRVD1)
/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_DIS_LCDIF */

#define BP_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF      14
#define BM_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF      0x00004000

#define BF_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF(v)   (((v) << 14) & BM_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_DIS_LCDIF, v)
#endif

#define BV_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF__BYPASS  0x1
#define BV_CLKCTRL_CLKSEQ_BYPASS_DIS_LCDIF__PFD     0x0

/* --- Register HW_CLKCTRL_CLKSEQ, field RSRVD2 */

#define BP_CLKCTRL_CLKSEQ_RSRVD2      9
#define BM_CLKCTRL_CLKSEQ_RSRVD2      0x00003E00

#define BF_CLKCTRL_CLKSEQ_RSRVD2(v)   (((v) << 9) & BM_CLKCTRL_CLKSEQ_RSRVD2)
/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_ETM */

#define BP_CLKCTRL_CLKSEQ_BYPASS_ETM      8
#define BM_CLKCTRL_CLKSEQ_BYPASS_ETM      0x00000100

#define BF_CLKCTRL_CLKSEQ_BYPASS_ETM(v)   (((v) << 8) & BM_CLKCTRL_CLKSEQ_BYPASS_ETM)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_ETM(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_ETM, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_EMI */

#define BP_CLKCTRL_CLKSEQ_BYPASS_EMI      7
#define BM_CLKCTRL_CLKSEQ_BYPASS_EMI      0x00000080

#define BF_CLKCTRL_CLKSEQ_BYPASS_EMI(v)   (((v) << 7) & BM_CLKCTRL_CLKSEQ_BYPASS_EMI)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_EMI(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_EMI, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SSP3 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SSP3      6
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP3      0x00000040

#define BF_CLKCTRL_CLKSEQ_BYPASS_SSP3(v)   (((v) << 6) & BM_CLKCTRL_CLKSEQ_BYPASS_SSP3)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SSP3(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SSP3, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SSP2 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SSP2      5
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP2      0x00000020

#define BF_CLKCTRL_CLKSEQ_BYPASS_SSP2(v)   (((v) << 5) & BM_CLKCTRL_CLKSEQ_BYPASS_SSP2)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SSP2(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SSP2, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SSP1 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SSP1      4
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP1      0x00000010

#define BF_CLKCTRL_CLKSEQ_BYPASS_SSP1(v)   (((v) << 4) & BM_CLKCTRL_CLKSEQ_BYPASS_SSP1)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SSP1(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SSP1, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SSP0 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SSP0      3
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP0      0x00000008

#define BF_CLKCTRL_CLKSEQ_BYPASS_SSP0(v)   (((v) << 3) & BM_CLKCTRL_CLKSEQ_BYPASS_SSP0)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SSP0(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SSP0, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_GPMI */

#define BP_CLKCTRL_CLKSEQ_BYPASS_GPMI      2
#define BM_CLKCTRL_CLKSEQ_BYPASS_GPMI      0x00000004

#define BF_CLKCTRL_CLKSEQ_BYPASS_GPMI(v)   (((v) << 2) & BM_CLKCTRL_CLKSEQ_BYPASS_GPMI)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_GPMI(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_GPMI, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SAIF1 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SAIF1      1
#define BM_CLKCTRL_CLKSEQ_BYPASS_SAIF1      0x00000002

#define BF_CLKCTRL_CLKSEQ_BYPASS_SAIF1(v)   (((v) << 1) & BM_CLKCTRL_CLKSEQ_BYPASS_SAIF1)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SAIF1(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SAIF1, v)
#endif

/* --- Register HW_CLKCTRL_CLKSEQ, field BYPASS_SAIF0 */

#define BP_CLKCTRL_CLKSEQ_BYPASS_SAIF0      0
#define BM_CLKCTRL_CLKSEQ_BYPASS_SAIF0      0x00000001

#define BF_CLKCTRL_CLKSEQ_BYPASS_SAIF0(v)   (((v) << 0) & BM_CLKCTRL_CLKSEQ_BYPASS_SAIF0)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_CLKSEQ_BYPASS_SAIF0(v)   BF_CS1(CLKCTRL_CLKSEQ, BYPASS_SAIF0, v)
#endif



/*
 * HW_CLKCTRL_RESET - System Reset Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned DIG                    :  1;
        unsigned CHIP                   :  1;
        unsigned THERMAL_RESET_DEFAULT  :  1;
        unsigned THERMAL_RESET_ENABLE   :  1;
        unsigned EXTERNAL_RESET_ENABLE  :  1;
        unsigned WDOG_POR_DISABLE       :  1;
        unsigned RSRVD                  : 26;
    } B;
} hw_clkctrl_reset_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_RESET register
 */
#define HW_CLKCTRL_RESET_ADDR         (REGS_CLKCTRL_BASE + 0x1e0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_RESET           (*(volatile hw_clkctrl_reset_t *) HW_CLKCTRL_RESET_ADDR)
#define HW_CLKCTRL_RESET_RD()      (HW_CLKCTRL_RESET.U)
#define HW_CLKCTRL_RESET_WR(v)     (HW_CLKCTRL_RESET.U = (v))
#define HW_CLKCTRL_RESET_SET(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() |  (v)))
#define HW_CLKCTRL_RESET_CLR(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() & ~(v)))
#define HW_CLKCTRL_RESET_TOG(v)    (HW_CLKCTRL_RESET_WR(HW_CLKCTRL_RESET_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_CLKCTRL_RESET bitfields
 */
/* --- Register HW_CLKCTRL_RESET, field RSRVD */

#define BP_CLKCTRL_RESET_RSRVD      6
#define BM_CLKCTRL_RESET_RSRVD      0xFFFFFFC0

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_RESET_RSRVD(v)   ((((reg32_t) v) << 6) & BM_CLKCTRL_RESET_RSRVD)
#else
#define BF_CLKCTRL_RESET_RSRVD(v)   (((v) << 6) & BM_CLKCTRL_RESET_RSRVD)
#endif
/* --- Register HW_CLKCTRL_RESET, field WDOG_POR_DISABLE */

#define BP_CLKCTRL_RESET_WDOG_POR_DISABLE      5
#define BM_CLKCTRL_RESET_WDOG_POR_DISABLE      0x00000020

#define BF_CLKCTRL_RESET_WDOG_POR_DISABLE(v)   (((v) << 5) & BM_CLKCTRL_RESET_WDOG_POR_DISABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_WDOG_POR_DISABLE(v)   BF_CS1(CLKCTRL_RESET, WDOG_POR_DISABLE, v)
#endif

/* --- Register HW_CLKCTRL_RESET, field EXTERNAL_RESET_ENABLE */

#define BP_CLKCTRL_RESET_EXTERNAL_RESET_ENABLE      4
#define BM_CLKCTRL_RESET_EXTERNAL_RESET_ENABLE      0x00000010

#define BF_CLKCTRL_RESET_EXTERNAL_RESET_ENABLE(v)   (((v) << 4) & BM_CLKCTRL_RESET_EXTERNAL_RESET_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_EXTERNAL_RESET_ENABLE(v)   BF_CS1(CLKCTRL_RESET, EXTERNAL_RESET_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_RESET, field THERMAL_RESET_ENABLE */

#define BP_CLKCTRL_RESET_THERMAL_RESET_ENABLE      3
#define BM_CLKCTRL_RESET_THERMAL_RESET_ENABLE      0x00000008

#define BF_CLKCTRL_RESET_THERMAL_RESET_ENABLE(v)   (((v) << 3) & BM_CLKCTRL_RESET_THERMAL_RESET_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_THERMAL_RESET_ENABLE(v)   BF_CS1(CLKCTRL_RESET, THERMAL_RESET_ENABLE, v)
#endif

/* --- Register HW_CLKCTRL_RESET, field THERMAL_RESET_DEFAULT */

#define BP_CLKCTRL_RESET_THERMAL_RESET_DEFAULT      2
#define BM_CLKCTRL_RESET_THERMAL_RESET_DEFAULT      0x00000004

#define BF_CLKCTRL_RESET_THERMAL_RESET_DEFAULT(v)   (((v) << 2) & BM_CLKCTRL_RESET_THERMAL_RESET_DEFAULT)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_THERMAL_RESET_DEFAULT(v)   BF_CS1(CLKCTRL_RESET, THERMAL_RESET_DEFAULT, v)
#endif

/* --- Register HW_CLKCTRL_RESET, field CHIP */

#define BP_CLKCTRL_RESET_CHIP      1
#define BM_CLKCTRL_RESET_CHIP      0x00000002

#define BF_CLKCTRL_RESET_CHIP(v)   (((v) << 1) & BM_CLKCTRL_RESET_CHIP)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_CHIP(v)   BF_CS1(CLKCTRL_RESET, CHIP, v)
#endif

/* --- Register HW_CLKCTRL_RESET, field DIG */

#define BP_CLKCTRL_RESET_DIG      0
#define BM_CLKCTRL_RESET_DIG      0x00000001

#define BF_CLKCTRL_RESET_DIG(v)   (((v) << 0) & BM_CLKCTRL_RESET_DIG)
#ifndef __LANGUAGE_ASM__
#define BW_CLKCTRL_RESET_DIG(v)   BF_CS1(CLKCTRL_RESET, DIG, v)
#endif



/*
 * HW_CLKCTRL_STATUS - ClkCtrl Status
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD      : 30;
        unsigned CPU_LIMIT  :  2;
    } B;
} hw_clkctrl_status_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_STATUS register
 */
#define HW_CLKCTRL_STATUS_ADDR         (REGS_CLKCTRL_BASE + 0x1f0)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_STATUS           (*(volatile hw_clkctrl_status_t *) HW_CLKCTRL_STATUS_ADDR)
#define HW_CLKCTRL_STATUS_RD()      (HW_CLKCTRL_STATUS.U)
#endif


/*
 * constants & macros for individual HW_CLKCTRL_STATUS bitfields
 */
/* --- Register HW_CLKCTRL_STATUS, field CPU_LIMIT */

#define BP_CLKCTRL_STATUS_CPU_LIMIT      30
#define BM_CLKCTRL_STATUS_CPU_LIMIT      0xC0000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_STATUS_CPU_LIMIT(v)   ((((reg32_t) v) << 30) & BM_CLKCTRL_STATUS_CPU_LIMIT)
#else
#define BF_CLKCTRL_STATUS_CPU_LIMIT(v)   (((v) << 30) & BM_CLKCTRL_STATUS_CPU_LIMIT)
#endif
/* --- Register HW_CLKCTRL_STATUS, field RSRVD */

#define BP_CLKCTRL_STATUS_RSRVD      0
#define BM_CLKCTRL_STATUS_RSRVD      0x3FFFFFFF

#define BF_CLKCTRL_STATUS_RSRVD(v)   (((v) << 0) & BM_CLKCTRL_STATUS_RSRVD)


/*
 * HW_CLKCTRL_VERSION - ClkCtrl Version
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_clkctrl_version_t;
#endif

/*
 * constants & macros for entire HW_CLKCTRL_VERSION register
 */
#define HW_CLKCTRL_VERSION_ADDR         (REGS_CLKCTRL_BASE + 0x200)

#ifndef __LANGUAGE_ASM__
#define HW_CLKCTRL_VERSION           (*(volatile hw_clkctrl_version_t *) HW_CLKCTRL_VERSION_ADDR)
#define HW_CLKCTRL_VERSION_RD()      (HW_CLKCTRL_VERSION.U)
#endif


/*
 * constants & macros for individual HW_CLKCTRL_VERSION bitfields
 */
/* --- Register HW_CLKCTRL_VERSION, field MAJOR */

#define BP_CLKCTRL_VERSION_MAJOR      24
#define BM_CLKCTRL_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_CLKCTRL_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_CLKCTRL_VERSION_MAJOR)
#else
#define BF_CLKCTRL_VERSION_MAJOR(v)   (((v) << 24) & BM_CLKCTRL_VERSION_MAJOR)
#endif
/* --- Register HW_CLKCTRL_VERSION, field MINOR */

#define BP_CLKCTRL_VERSION_MINOR      16
#define BM_CLKCTRL_VERSION_MINOR      0x00FF0000

#define BF_CLKCTRL_VERSION_MINOR(v)   (((v) << 16) & BM_CLKCTRL_VERSION_MINOR)
/* --- Register HW_CLKCTRL_VERSION, field STEP */

#define BP_CLKCTRL_VERSION_STEP      0
#define BM_CLKCTRL_VERSION_STEP      0x0000FFFF

#define BF_CLKCTRL_VERSION_STEP(v)   (((v) << 0) & BM_CLKCTRL_VERSION_STEP)

#endif /* _CLKCTRL_H */

////////////////////////////////////////////////////////////////////////////////
