/*
 * Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

 * WARNING!  THIS FILE IS AUTOMATICALLY GENERATED FROM XML.
 *                DO NOT MODIFY THIS FILE DIRECTLY.
 *
 * Xml Revision: 1.50
 *
 * Template revision: 26195
 *
 *
 * The following naming conventions are followed in this file.
 *      XX_<module>_<regname>_<field>
 *
 * XX specifies the define / macro class
 *      HW pertains to a register
 *      BM indicates a Bit Mask
 *      BF indicates a Bit Field macro
 *
 * <module> is the hardware module name which can be any of the following...
 *      USB20 (Note when there is more than one copy of a given module, the
 *      module name includes a number starting from 0 for the first instance
 *      of that module)
 *
 * <regname> is the specific register within that module
 *
 * <field> is the specific bitfield within that <module>_<register>
 *
 * We also define the following...
 *      hw_<module>_<regname>_t is typedef of anonymous union
 *
 */

#ifndef _ICOLL_H
#define _ICOLL_H  1

#include "regs.h"

#ifndef REGS_ICOLL_BASE
#define REGS_ICOLL_BASE (REGS_BASE + 0x0)
#endif

/*
 * HW_ICOLL_VECTOR - Interrupt Collector Interrupt Vector Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1     :  2;
        unsigned IRQVECTOR  : 30;
    } B;
} hw_icoll_vector_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_VECTOR register
 */
#define HW_ICOLL_VECTOR_ADDR         (REGS_ICOLL_BASE + 0x0)
#define HW_ICOLL_VECTOR_SET_ADDR     (HW_ICOLL_VECTOR_ADDR + 4)
#define HW_ICOLL_VECTOR_CLR_ADDR     (HW_ICOLL_VECTOR_ADDR + 8)
#define HW_ICOLL_VECTOR_TOG_ADDR     (HW_ICOLL_VECTOR_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_VECTOR           (*(volatile hw_icoll_vector_t *) HW_ICOLL_VECTOR_ADDR)
#define HW_ICOLL_VECTOR_RD()      (HW_ICOLL_VECTOR.U)
#define HW_ICOLL_VECTOR_WR(v)     (HW_ICOLL_VECTOR.U = (v))
#define HW_ICOLL_VECTOR_SET(v)    ((*(volatile reg32_t *) HW_ICOLL_VECTOR_SET_ADDR) = (v))
#define HW_ICOLL_VECTOR_CLR(v)    ((*(volatile reg32_t *) HW_ICOLL_VECTOR_CLR_ADDR) = (v))
#define HW_ICOLL_VECTOR_TOG(v)    ((*(volatile reg32_t *) HW_ICOLL_VECTOR_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_ICOLL_VECTOR bitfields
 */
/* --- Register HW_ICOLL_VECTOR, field IRQVECTOR */

#define BP_ICOLL_VECTOR_IRQVECTOR      2
#define BM_ICOLL_VECTOR_IRQVECTOR      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_VECTOR_IRQVECTOR(v)   ((((reg32_t) v) << 2) & BM_ICOLL_VECTOR_IRQVECTOR)
#else
#define BF_ICOLL_VECTOR_IRQVECTOR(v)   (((v) << 2) & BM_ICOLL_VECTOR_IRQVECTOR)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_VECTOR_IRQVECTOR(v)   BF_CS1(ICOLL_VECTOR, IRQVECTOR, v)
#endif

/* --- Register HW_ICOLL_VECTOR, field RSRVD1 */

#define BP_ICOLL_VECTOR_RSRVD1      0
#define BM_ICOLL_VECTOR_RSRVD1      0x00000003

#define BF_ICOLL_VECTOR_RSRVD1(v)   (((v) << 0) & BM_ICOLL_VECTOR_RSRVD1)


/*
 * HW_ICOLL_LEVELACK - Interrupt Collector Level Acknowledge Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned IRQLEVELACK  :  4;
        unsigned RSRVD1       : 28;
    } B;
} hw_icoll_levelack_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_LEVELACK register
 */
#define HW_ICOLL_LEVELACK_ADDR         (REGS_ICOLL_BASE + 0x10)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_LEVELACK           (*(volatile hw_icoll_levelack_t *) HW_ICOLL_LEVELACK_ADDR)
#define HW_ICOLL_LEVELACK_RD()      (HW_ICOLL_LEVELACK.U)
#define HW_ICOLL_LEVELACK_WR(v)     (HW_ICOLL_LEVELACK.U = (v))
#define HW_ICOLL_LEVELACK_SET(v)    (HW_ICOLL_LEVELACK_WR(HW_ICOLL_LEVELACK_RD() |  (v)))
#define HW_ICOLL_LEVELACK_CLR(v)    (HW_ICOLL_LEVELACK_WR(HW_ICOLL_LEVELACK_RD() & ~(v)))
#define HW_ICOLL_LEVELACK_TOG(v)    (HW_ICOLL_LEVELACK_WR(HW_ICOLL_LEVELACK_RD() ^  (v)))
#endif


/*
 * constants & macros for individual HW_ICOLL_LEVELACK bitfields
 */
/* --- Register HW_ICOLL_LEVELACK, field RSRVD1 */

#define BP_ICOLL_LEVELACK_RSRVD1      4
#define BM_ICOLL_LEVELACK_RSRVD1      0xFFFFFFF0

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_LEVELACK_RSRVD1(v)   ((((reg32_t) v) << 4) & BM_ICOLL_LEVELACK_RSRVD1)
#else
#define BF_ICOLL_LEVELACK_RSRVD1(v)   (((v) << 4) & BM_ICOLL_LEVELACK_RSRVD1)
#endif
/* --- Register HW_ICOLL_LEVELACK, field IRQLEVELACK */

#define BP_ICOLL_LEVELACK_IRQLEVELACK      0
#define BM_ICOLL_LEVELACK_IRQLEVELACK      0x0000000F

#define BF_ICOLL_LEVELACK_IRQLEVELACK(v)   (((v) << 0) & BM_ICOLL_LEVELACK_IRQLEVELACK)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_LEVELACK_IRQLEVELACK(v)   BF_CS1(ICOLL_LEVELACK, IRQLEVELACK, v)
#endif

#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL0 0x1
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL1 0x2
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL2 0x4
#define BV_ICOLL_LEVELACK_IRQLEVELACK__LEVEL3 0x8



/*
 * HW_ICOLL_CTRL - Interrupt Collector Control Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1            : 16;
        unsigned IRQ_FINAL_ENABLE  :  1;
        unsigned FIQ_FINAL_ENABLE  :  1;
        unsigned ARM_RSE_MODE      :  1;
        unsigned NO_NESTING        :  1;
        unsigned BYPASS_FSM        :  1;
        unsigned VECTOR_PITCH      :  3;
        unsigned RSRVD3            :  6;
        unsigned CLKGATE           :  1;
        unsigned SFTRST            :  1;
    } B;
} hw_icoll_ctrl_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_CTRL register
 */
#define HW_ICOLL_CTRL_ADDR         (REGS_ICOLL_BASE + 0x20)
#define HW_ICOLL_CTRL_SET_ADDR     (HW_ICOLL_CTRL_ADDR + 4)
#define HW_ICOLL_CTRL_CLR_ADDR     (HW_ICOLL_CTRL_ADDR + 8)
#define HW_ICOLL_CTRL_TOG_ADDR     (HW_ICOLL_CTRL_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_CTRL           (*(volatile hw_icoll_ctrl_t *) HW_ICOLL_CTRL_ADDR)
#define HW_ICOLL_CTRL_RD()      (HW_ICOLL_CTRL.U)
#define HW_ICOLL_CTRL_WR(v)     (HW_ICOLL_CTRL.U = (v))
#define HW_ICOLL_CTRL_SET(v)    ((*(volatile reg32_t *) HW_ICOLL_CTRL_SET_ADDR) = (v))
#define HW_ICOLL_CTRL_CLR(v)    ((*(volatile reg32_t *) HW_ICOLL_CTRL_CLR_ADDR) = (v))
#define HW_ICOLL_CTRL_TOG(v)    ((*(volatile reg32_t *) HW_ICOLL_CTRL_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_ICOLL_CTRL bitfields
 */
/* --- Register HW_ICOLL_CTRL, field SFTRST */

#define BP_ICOLL_CTRL_SFTRST      31
#define BM_ICOLL_CTRL_SFTRST      0x80000000

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_CTRL_SFTRST(v)   ((((reg32_t) v) << 31) & BM_ICOLL_CTRL_SFTRST)
#else
#define BF_ICOLL_CTRL_SFTRST(v)   (((v) << 31) & BM_ICOLL_CTRL_SFTRST)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_SFTRST(v)   BF_CS1(ICOLL_CTRL, SFTRST, v)
#endif

#define BV_ICOLL_CTRL_SFTRST__RUN      0x0
#define BV_ICOLL_CTRL_SFTRST__IN_RESET 0x1

/* --- Register HW_ICOLL_CTRL, field CLKGATE */

#define BP_ICOLL_CTRL_CLKGATE      30
#define BM_ICOLL_CTRL_CLKGATE      0x40000000

#define BF_ICOLL_CTRL_CLKGATE(v)   (((v) << 30) & BM_ICOLL_CTRL_CLKGATE)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_CLKGATE(v)   BF_CS1(ICOLL_CTRL, CLKGATE, v)
#endif

#define BV_ICOLL_CTRL_CLKGATE__RUN       0x0
#define BV_ICOLL_CTRL_CLKGATE__NO_CLOCKS 0x1

/* --- Register HW_ICOLL_CTRL, field RSRVD3 */

#define BP_ICOLL_CTRL_RSRVD3      24
#define BM_ICOLL_CTRL_RSRVD3      0x3F000000

#define BF_ICOLL_CTRL_RSRVD3(v)   (((v) << 24) & BM_ICOLL_CTRL_RSRVD3)
/* --- Register HW_ICOLL_CTRL, field VECTOR_PITCH */

#define BP_ICOLL_CTRL_VECTOR_PITCH      21
#define BM_ICOLL_CTRL_VECTOR_PITCH      0x00E00000

#define BF_ICOLL_CTRL_VECTOR_PITCH(v)   (((v) << 21) & BM_ICOLL_CTRL_VECTOR_PITCH)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_VECTOR_PITCH(v)   BF_CS1(ICOLL_CTRL, VECTOR_PITCH, v)
#endif

#define BV_ICOLL_CTRL_VECTOR_PITCH__DEFAULT_BY4 0x0
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY4         0x1
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY8         0x2
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY12        0x3
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY16        0x4
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY20        0x5
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY24        0x6
#define BV_ICOLL_CTRL_VECTOR_PITCH__BY28        0x7

/* --- Register HW_ICOLL_CTRL, field BYPASS_FSM */

#define BP_ICOLL_CTRL_BYPASS_FSM      20
#define BM_ICOLL_CTRL_BYPASS_FSM      0x00100000

#define BF_ICOLL_CTRL_BYPASS_FSM(v)   (((v) << 20) & BM_ICOLL_CTRL_BYPASS_FSM)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_BYPASS_FSM(v)   BF_CS1(ICOLL_CTRL, BYPASS_FSM, v)
#endif

#define BV_ICOLL_CTRL_BYPASS_FSM__NORMAL 0x0
#define BV_ICOLL_CTRL_BYPASS_FSM__BYPASS 0x1

/* --- Register HW_ICOLL_CTRL, field NO_NESTING */

#define BP_ICOLL_CTRL_NO_NESTING      19
#define BM_ICOLL_CTRL_NO_NESTING      0x00080000

#define BF_ICOLL_CTRL_NO_NESTING(v)   (((v) << 19) & BM_ICOLL_CTRL_NO_NESTING)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_NO_NESTING(v)   BF_CS1(ICOLL_CTRL, NO_NESTING, v)
#endif

#define BV_ICOLL_CTRL_NO_NESTING__NORMAL  0x0
#define BV_ICOLL_CTRL_NO_NESTING__NO_NEST 0x1

/* --- Register HW_ICOLL_CTRL, field ARM_RSE_MODE */

#define BP_ICOLL_CTRL_ARM_RSE_MODE      18
#define BM_ICOLL_CTRL_ARM_RSE_MODE      0x00040000

#define BF_ICOLL_CTRL_ARM_RSE_MODE(v)   (((v) << 18) & BM_ICOLL_CTRL_ARM_RSE_MODE)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_ARM_RSE_MODE(v)   BF_CS1(ICOLL_CTRL, ARM_RSE_MODE, v)
#endif

/* --- Register HW_ICOLL_CTRL, field FIQ_FINAL_ENABLE */

#define BP_ICOLL_CTRL_FIQ_FINAL_ENABLE      17
#define BM_ICOLL_CTRL_FIQ_FINAL_ENABLE      0x00020000

#define BF_ICOLL_CTRL_FIQ_FINAL_ENABLE(v)   (((v) << 17) & BM_ICOLL_CTRL_FIQ_FINAL_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_FIQ_FINAL_ENABLE(v)   BF_CS1(ICOLL_CTRL, FIQ_FINAL_ENABLE, v)
#endif

#define BV_ICOLL_CTRL_FIQ_FINAL_ENABLE__DISABLE 0x0
#define BV_ICOLL_CTRL_FIQ_FINAL_ENABLE__ENABLE  0x1

/* --- Register HW_ICOLL_CTRL, field IRQ_FINAL_ENABLE */

#define BP_ICOLL_CTRL_IRQ_FINAL_ENABLE      16
#define BM_ICOLL_CTRL_IRQ_FINAL_ENABLE      0x00010000

#define BF_ICOLL_CTRL_IRQ_FINAL_ENABLE(v)   (((v) << 16) & BM_ICOLL_CTRL_IRQ_FINAL_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_CTRL_IRQ_FINAL_ENABLE(v)   BF_CS1(ICOLL_CTRL, IRQ_FINAL_ENABLE, v)
#endif

#define BV_ICOLL_CTRL_IRQ_FINAL_ENABLE__DISABLE 0x0
#define BV_ICOLL_CTRL_IRQ_FINAL_ENABLE__ENABLE  0x1

/* --- Register HW_ICOLL_CTRL, field RSRVD1 */

#define BP_ICOLL_CTRL_RSRVD1      0
#define BM_ICOLL_CTRL_RSRVD1      0x0000FFFF

#define BF_ICOLL_CTRL_RSRVD1(v)   (((v) << 0) & BM_ICOLL_CTRL_RSRVD1)


/*
 * HW_ICOLL_VBASE - Interrupt Collector Interrupt Vector Base Address Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RSRVD1         :  2;
        unsigned TABLE_ADDRESS  : 30;
    } B;
} hw_icoll_vbase_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_VBASE register
 */
#define HW_ICOLL_VBASE_ADDR         (REGS_ICOLL_BASE + 0x40)
#define HW_ICOLL_VBASE_SET_ADDR     (HW_ICOLL_VBASE_ADDR + 4)
#define HW_ICOLL_VBASE_CLR_ADDR     (HW_ICOLL_VBASE_ADDR + 8)
#define HW_ICOLL_VBASE_TOG_ADDR     (HW_ICOLL_VBASE_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_VBASE           (*(volatile hw_icoll_vbase_t *) HW_ICOLL_VBASE_ADDR)
#define HW_ICOLL_VBASE_RD()      (HW_ICOLL_VBASE.U)
#define HW_ICOLL_VBASE_WR(v)     (HW_ICOLL_VBASE.U = (v))
#define HW_ICOLL_VBASE_SET(v)    ((*(volatile reg32_t *) HW_ICOLL_VBASE_SET_ADDR) = (v))
#define HW_ICOLL_VBASE_CLR(v)    ((*(volatile reg32_t *) HW_ICOLL_VBASE_CLR_ADDR) = (v))
#define HW_ICOLL_VBASE_TOG(v)    ((*(volatile reg32_t *) HW_ICOLL_VBASE_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_ICOLL_VBASE bitfields
 */
/* --- Register HW_ICOLL_VBASE, field TABLE_ADDRESS */

#define BP_ICOLL_VBASE_TABLE_ADDRESS      2
#define BM_ICOLL_VBASE_TABLE_ADDRESS      0xFFFFFFFC

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_VBASE_TABLE_ADDRESS(v)   ((((reg32_t) v) << 2) & BM_ICOLL_VBASE_TABLE_ADDRESS)
#else
#define BF_ICOLL_VBASE_TABLE_ADDRESS(v)   (((v) << 2) & BM_ICOLL_VBASE_TABLE_ADDRESS)
#endif
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_VBASE_TABLE_ADDRESS(v)   BF_CS1(ICOLL_VBASE, TABLE_ADDRESS, v)
#endif

/* --- Register HW_ICOLL_VBASE, field RSRVD1 */

#define BP_ICOLL_VBASE_RSRVD1      0
#define BM_ICOLL_VBASE_RSRVD1      0x00000003

#define BF_ICOLL_VBASE_RSRVD1(v)   (((v) << 0) & BM_ICOLL_VBASE_RSRVD1)


/*
 * HW_ICOLL_STAT - Interrupt Collector Status Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VECTOR_NUMBER  :  7;
        unsigned RSRVD1         : 25;
    } B;
} hw_icoll_stat_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_STAT register
 */
#define HW_ICOLL_STAT_ADDR         (REGS_ICOLL_BASE + 0x70)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_STAT           (*(volatile hw_icoll_stat_t *) HW_ICOLL_STAT_ADDR)
#define HW_ICOLL_STAT_RD()      (HW_ICOLL_STAT.U)
#endif


/*
 * constants & macros for individual HW_ICOLL_STAT bitfields
 */
/* --- Register HW_ICOLL_STAT, field RSRVD1 */

#define BP_ICOLL_STAT_RSRVD1      7
#define BM_ICOLL_STAT_RSRVD1      0xFFFFFF80

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_STAT_RSRVD1(v)   ((((reg32_t) v) << 7) & BM_ICOLL_STAT_RSRVD1)
#else
#define BF_ICOLL_STAT_RSRVD1(v)   (((v) << 7) & BM_ICOLL_STAT_RSRVD1)
#endif
/* --- Register HW_ICOLL_STAT, field VECTOR_NUMBER */

#define BP_ICOLL_STAT_VECTOR_NUMBER      0
#define BM_ICOLL_STAT_VECTOR_NUMBER      0x0000007F

#define BF_ICOLL_STAT_VECTOR_NUMBER(v)   (((v) << 0) & BM_ICOLL_STAT_VECTOR_NUMBER)


/*
 *  multi-register-define name HW_ICOLL_RAWn
 *              base 0x000000A0
 *              count 4
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned RAW_IRQS  : 32;
    } B;
} hw_icoll_rawn_t;
#endif

    /*
     * constants & macros for entire HW_ICOLL_RAWn multi-register
     */
    #define HW_ICOLL_RAWn_COUNT        4
    #define HW_ICOLL_RAWn_ADDR(n)      (REGS_ICOLL_BASE + 0xa0 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_ICOLL_RAWn(n)           (*(volatile hw_icoll_rawn_t *) HW_ICOLL_RAWn_ADDR(n))
    #define HW_ICOLL_RAWn_RD(n)        (HW_ICOLL_RAWn(n).U)
    #endif


/*
 * constants & macros for individual HW_ICOLL_RAWn multi-register bitfields
 */
/* --- Register HW_ICOLL_RAWn, field RAW_IRQS */

#define BP_ICOLL_RAWn_RAW_IRQS      0
#define BM_ICOLL_RAWn_RAW_IRQS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_RAWn_RAW_IRQS(v)   ((reg32_t) v)
#else
#define BF_ICOLL_RAWn_RAW_IRQS(v)   (v)
#endif


/*
 *  multi-register-define name HW_ICOLL_INTERRUPTn
 *              base 0x00000120
 *              count 128
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned PRIORITY  :  2;
        unsigned ENABLE    :  1;
        unsigned SOFTIRQ   :  1;
        unsigned ENFIQ     :  1;
        unsigned RSRVD1    : 27;
    } B;
} hw_icoll_interruptn_t;
#endif

    /*
     * constants & macros for entire HW_ICOLL_INTERRUPTn multi-register
     */
    #define HW_ICOLL_INTERRUPTn_COUNT        128
    #define HW_ICOLL_INTERRUPTn_ADDR(n)      (REGS_ICOLL_BASE + 0x120 + ((n) * 0x10))
    #define HW_ICOLL_INTERRUPTn_SET_ADDR(n)  (HW_ICOLL_INTERRUPTn_ADDR(n) + 4)
    #define HW_ICOLL_INTERRUPTn_CLR_ADDR(n)  (HW_ICOLL_INTERRUPTn_ADDR(n) + 8)
    #define HW_ICOLL_INTERRUPTn_TOG_ADDR(n)  (HW_ICOLL_INTERRUPTn_ADDR(n) + 12)

    #ifndef __LANGUAGE_ASM__
    #define HW_ICOLL_INTERRUPTn(n)           (*(volatile hw_icoll_interruptn_t *) HW_ICOLL_INTERRUPTn_ADDR(n))
    #define HW_ICOLL_INTERRUPTn_RD(n)        (HW_ICOLL_INTERRUPTn(n).U)
    #define HW_ICOLL_INTERRUPTn_WR(n, v)     (HW_ICOLL_INTERRUPTn(n).U = (v))
    #define HW_ICOLL_INTERRUPTn_SET(n, v)    ((*(volatile reg32_t *) HW_ICOLL_INTERRUPTn_SET_ADDR(n)) = (v))
    #define HW_ICOLL_INTERRUPTn_CLR(n, v)    ((*(volatile reg32_t *) HW_ICOLL_INTERRUPTn_CLR_ADDR(n)) = (v))
    #define HW_ICOLL_INTERRUPTn_TOG(n, v)    ((*(volatile reg32_t *) HW_ICOLL_INTERRUPTn_TOG_ADDR(n)) = (v))
    #endif


/*
 * constants & macros for individual HW_ICOLL_INTERRUPTn multi-register bitfields
 */
/* --- Register HW_ICOLL_INTERRUPTn, field RSRVD1 */

#define BP_ICOLL_INTERRUPTn_RSRVD1      5
#define BM_ICOLL_INTERRUPTn_RSRVD1      0xFFFFFFE0

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_INTERRUPTn_RSRVD1(v)   ((((reg32_t) v) << 5) & BM_ICOLL_INTERRUPTn_RSRVD1)
#else
#define BF_ICOLL_INTERRUPTn_RSRVD1(v)   (((v) << 5) & BM_ICOLL_INTERRUPTn_RSRVD1)
#endif
/* --- Register HW_ICOLL_INTERRUPTn, field ENFIQ */

#define BP_ICOLL_INTERRUPTn_ENFIQ      4
#define BM_ICOLL_INTERRUPTn_ENFIQ      0x00000010

#define BF_ICOLL_INTERRUPTn_ENFIQ(v)   (((v) << 4) & BM_ICOLL_INTERRUPTn_ENFIQ)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_INTERRUPTn_ENFIQ(n, v)  BF_CS1n(ICOLL_INTERRUPTn, n, ENFIQ, v)
#endif

#define BV_ICOLL_INTERRUPTn_ENFIQ__DISABLE 0x0
#define BV_ICOLL_INTERRUPTn_ENFIQ__ENABLE  0x1

/* --- Register HW_ICOLL_INTERRUPTn, field SOFTIRQ */

#define BP_ICOLL_INTERRUPTn_SOFTIRQ      3
#define BM_ICOLL_INTERRUPTn_SOFTIRQ      0x00000008

#define BF_ICOLL_INTERRUPTn_SOFTIRQ(v)   (((v) << 3) & BM_ICOLL_INTERRUPTn_SOFTIRQ)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_INTERRUPTn_SOFTIRQ(n, v)  BF_CS1n(ICOLL_INTERRUPTn, n, SOFTIRQ, v)
#endif

#define BV_ICOLL_INTERRUPTn_SOFTIRQ__NO_INTERRUPT    0x0
#define BV_ICOLL_INTERRUPTn_SOFTIRQ__FORCE_INTERRUPT 0x1

/* --- Register HW_ICOLL_INTERRUPTn, field ENABLE */

#define BP_ICOLL_INTERRUPTn_ENABLE      2
#define BM_ICOLL_INTERRUPTn_ENABLE      0x00000004

#define BF_ICOLL_INTERRUPTn_ENABLE(v)   (((v) << 2) & BM_ICOLL_INTERRUPTn_ENABLE)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_INTERRUPTn_ENABLE(n, v)  BF_CS1n(ICOLL_INTERRUPTn, n, ENABLE, v)
#endif

#define BV_ICOLL_INTERRUPTn_ENABLE__DISABLE 0x0
#define BV_ICOLL_INTERRUPTn_ENABLE__ENABLE  0x1

/* --- Register HW_ICOLL_INTERRUPTn, field PRIORITY */

#define BP_ICOLL_INTERRUPTn_PRIORITY      0
#define BM_ICOLL_INTERRUPTn_PRIORITY      0x00000003

#define BF_ICOLL_INTERRUPTn_PRIORITY(v)   (((v) << 0) & BM_ICOLL_INTERRUPTn_PRIORITY)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_INTERRUPTn_PRIORITY(n, v)  BF_CS1n(ICOLL_INTERRUPTn, n, PRIORITY, v)
#endif

#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL0 0x0
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL1 0x1
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL2 0x2
#define BV_ICOLL_INTERRUPTn_PRIORITY__LEVEL3 0x3



/*
 * HW_ICOLL_DEBUG - Interrupt Collector Debug Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VECTOR_FSM         : 10;
        unsigned RSRVD1             :  6;
        unsigned IRQ                :  1;
        unsigned FIQ                :  1;
        unsigned RSRVD2             :  2;
        unsigned REQUESTS_BY_LEVEL  :  4;
        unsigned LEVEL_REQUESTS     :  4;
        unsigned INSERVICE          :  4;
    } B;
} hw_icoll_debug_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_DEBUG register
 */
#define HW_ICOLL_DEBUG_ADDR         (REGS_ICOLL_BASE + 0x1120)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_DEBUG           (*(volatile hw_icoll_debug_t *) HW_ICOLL_DEBUG_ADDR)
#define HW_ICOLL_DEBUG_RD()      (HW_ICOLL_DEBUG.U)
#endif


/*
 * constants & macros for individual HW_ICOLL_DEBUG bitfields
 */
/* --- Register HW_ICOLL_DEBUG, field INSERVICE */

#define BP_ICOLL_DEBUG_INSERVICE      28
#define BM_ICOLL_DEBUG_INSERVICE      0xF0000000

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_DEBUG_INSERVICE(v)   ((((reg32_t) v) << 28) & BM_ICOLL_DEBUG_INSERVICE)
#else
#define BF_ICOLL_DEBUG_INSERVICE(v)   (((v) << 28) & BM_ICOLL_DEBUG_INSERVICE)
#endif
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL0 0x1
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL1 0x2
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL2 0x4
#define BV_ICOLL_DEBUG_INSERVICE__LEVEL3 0x8

/* --- Register HW_ICOLL_DEBUG, field LEVEL_REQUESTS */

#define BP_ICOLL_DEBUG_LEVEL_REQUESTS      24
#define BM_ICOLL_DEBUG_LEVEL_REQUESTS      0x0F000000

#define BF_ICOLL_DEBUG_LEVEL_REQUESTS(v)   (((v) << 24) & BM_ICOLL_DEBUG_LEVEL_REQUESTS)
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL0 0x1
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL1 0x2
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL2 0x4
#define BV_ICOLL_DEBUG_LEVEL_REQUESTS__LEVEL3 0x8

/* --- Register HW_ICOLL_DEBUG, field REQUESTS_BY_LEVEL */

#define BP_ICOLL_DEBUG_REQUESTS_BY_LEVEL      20
#define BM_ICOLL_DEBUG_REQUESTS_BY_LEVEL      0x00F00000

#define BF_ICOLL_DEBUG_REQUESTS_BY_LEVEL(v)   (((v) << 20) & BM_ICOLL_DEBUG_REQUESTS_BY_LEVEL)
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL0 0x1
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL1 0x2
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL2 0x4
#define BV_ICOLL_DEBUG_REQUESTS_BY_LEVEL__LEVEL3 0x8

/* --- Register HW_ICOLL_DEBUG, field RSRVD2 */

#define BP_ICOLL_DEBUG_RSRVD2      18
#define BM_ICOLL_DEBUG_RSRVD2      0x000C0000

#define BF_ICOLL_DEBUG_RSRVD2(v)   (((v) << 18) & BM_ICOLL_DEBUG_RSRVD2)
/* --- Register HW_ICOLL_DEBUG, field FIQ */

#define BP_ICOLL_DEBUG_FIQ      17
#define BM_ICOLL_DEBUG_FIQ      0x00020000

#define BF_ICOLL_DEBUG_FIQ(v)   (((v) << 17) & BM_ICOLL_DEBUG_FIQ)
#define BV_ICOLL_DEBUG_FIQ__NO_FIQ_REQUESTED 0x0
#define BV_ICOLL_DEBUG_FIQ__FIQ_REQUESTED    0x1

/* --- Register HW_ICOLL_DEBUG, field IRQ */

#define BP_ICOLL_DEBUG_IRQ      16
#define BM_ICOLL_DEBUG_IRQ      0x00010000

#define BF_ICOLL_DEBUG_IRQ(v)   (((v) << 16) & BM_ICOLL_DEBUG_IRQ)
#define BV_ICOLL_DEBUG_IRQ__NO_IRQ_REQUESTED 0x0
#define BV_ICOLL_DEBUG_IRQ__IRQ_REQUESTED    0x1

/* --- Register HW_ICOLL_DEBUG, field RSRVD1 */

#define BP_ICOLL_DEBUG_RSRVD1      10
#define BM_ICOLL_DEBUG_RSRVD1      0x0000FC00

#define BF_ICOLL_DEBUG_RSRVD1(v)   (((v) << 10) & BM_ICOLL_DEBUG_RSRVD1)
/* --- Register HW_ICOLL_DEBUG, field VECTOR_FSM */

#define BP_ICOLL_DEBUG_VECTOR_FSM      0
#define BM_ICOLL_DEBUG_VECTOR_FSM      0x000003FF

#define BF_ICOLL_DEBUG_VECTOR_FSM(v)   (((v) << 0) & BM_ICOLL_DEBUG_VECTOR_FSM)
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_IDLE         0x000
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE1  0x001
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE2  0x002
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_PENDING      0x004
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE3  0x008
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE4  0x010
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING1 0x020
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING2 0x040
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_ISR_RUNNING3 0x080
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE5  0x100
#define BV_ICOLL_DEBUG_VECTOR_FSM__FSM_MULTICYCLE6  0x200



/*
 * HW_ICOLL_DBGREAD0 - Interrupt Collector Debug Read Register 0
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_icoll_dbgread0_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_DBGREAD0 register
 */
#define HW_ICOLL_DBGREAD0_ADDR         (REGS_ICOLL_BASE + 0x1130)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_DBGREAD0           (*(volatile hw_icoll_dbgread0_t *) HW_ICOLL_DBGREAD0_ADDR)
#define HW_ICOLL_DBGREAD0_RD()      (HW_ICOLL_DBGREAD0.U)
#endif


/*
 * constants & macros for individual HW_ICOLL_DBGREAD0 bitfields
 */
/* --- Register HW_ICOLL_DBGREAD0, field VALUE */

#define BP_ICOLL_DBGREAD0_VALUE      0
#define BM_ICOLL_DBGREAD0_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_DBGREAD0_VALUE(v)   ((reg32_t) v)
#else
#define BF_ICOLL_DBGREAD0_VALUE(v)   (v)
#endif


/*
 * HW_ICOLL_DBGREAD1 - Interrupt Collector Debug Read Register 1
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned VALUE  : 32;
    } B;
} hw_icoll_dbgread1_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_DBGREAD1 register
 */
#define HW_ICOLL_DBGREAD1_ADDR         (REGS_ICOLL_BASE + 0x1140)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_DBGREAD1           (*(volatile hw_icoll_dbgread1_t *) HW_ICOLL_DBGREAD1_ADDR)
#define HW_ICOLL_DBGREAD1_RD()      (HW_ICOLL_DBGREAD1.U)
#endif


/*
 * constants & macros for individual HW_ICOLL_DBGREAD1 bitfields
 */
/* --- Register HW_ICOLL_DBGREAD1, field VALUE */

#define BP_ICOLL_DBGREAD1_VALUE      0
#define BM_ICOLL_DBGREAD1_VALUE      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_DBGREAD1_VALUE(v)   ((reg32_t) v)
#else
#define BF_ICOLL_DBGREAD1_VALUE(v)   (v)
#endif


/*
 * HW_ICOLL_DBGFLAG - Interrupt Collector Debug Flag Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned FLAG    : 16;
        unsigned RSRVD1  : 16;
    } B;
} hw_icoll_dbgflag_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_DBGFLAG register
 */
#define HW_ICOLL_DBGFLAG_ADDR         (REGS_ICOLL_BASE + 0x1150)
#define HW_ICOLL_DBGFLAG_SET_ADDR     (HW_ICOLL_DBGFLAG_ADDR + 4)
#define HW_ICOLL_DBGFLAG_CLR_ADDR     (HW_ICOLL_DBGFLAG_ADDR + 8)
#define HW_ICOLL_DBGFLAG_TOG_ADDR     (HW_ICOLL_DBGFLAG_ADDR + 12)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_DBGFLAG           (*(volatile hw_icoll_dbgflag_t *) HW_ICOLL_DBGFLAG_ADDR)
#define HW_ICOLL_DBGFLAG_RD()      (HW_ICOLL_DBGFLAG.U)
#define HW_ICOLL_DBGFLAG_WR(v)     (HW_ICOLL_DBGFLAG.U = (v))
#define HW_ICOLL_DBGFLAG_SET(v)    ((*(volatile reg32_t *) HW_ICOLL_DBGFLAG_SET_ADDR) = (v))
#define HW_ICOLL_DBGFLAG_CLR(v)    ((*(volatile reg32_t *) HW_ICOLL_DBGFLAG_CLR_ADDR) = (v))
#define HW_ICOLL_DBGFLAG_TOG(v)    ((*(volatile reg32_t *) HW_ICOLL_DBGFLAG_TOG_ADDR) = (v))
#endif


/*
 * constants & macros for individual HW_ICOLL_DBGFLAG bitfields
 */
/* --- Register HW_ICOLL_DBGFLAG, field RSRVD1 */

#define BP_ICOLL_DBGFLAG_RSRVD1      16
#define BM_ICOLL_DBGFLAG_RSRVD1      0xFFFF0000

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_DBGFLAG_RSRVD1(v)   ((((reg32_t) v) << 16) & BM_ICOLL_DBGFLAG_RSRVD1)
#else
#define BF_ICOLL_DBGFLAG_RSRVD1(v)   (((v) << 16) & BM_ICOLL_DBGFLAG_RSRVD1)
#endif
/* --- Register HW_ICOLL_DBGFLAG, field FLAG */

#define BP_ICOLL_DBGFLAG_FLAG      0
#define BM_ICOLL_DBGFLAG_FLAG      0x0000FFFF

#define BF_ICOLL_DBGFLAG_FLAG(v)   (((v) << 0) & BM_ICOLL_DBGFLAG_FLAG)
#ifndef __LANGUAGE_ASM__
#define BW_ICOLL_DBGFLAG_FLAG(v)   (HW_ICOLL_DBGFLAG.B.FLAG = (v))
#endif



/*
 *  multi-register-define name HW_ICOLL_DBGREQUESTn
 *              base 0x00001160
 *              count 4
 *              offset 0x10
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned BITS  : 32;
    } B;
} hw_icoll_dbgrequestn_t;
#endif

    /*
     * constants & macros for entire HW_ICOLL_DBGREQUESTn multi-register
     */
    #define HW_ICOLL_DBGREQUESTn_COUNT        4
    #define HW_ICOLL_DBGREQUESTn_ADDR(n)      (REGS_ICOLL_BASE + 0x1160 + ((n) * 0x10))

    #ifndef __LANGUAGE_ASM__
    #define HW_ICOLL_DBGREQUESTn(n)           (*(volatile hw_icoll_dbgrequestn_t *) HW_ICOLL_DBGREQUESTn_ADDR(n))
    #define HW_ICOLL_DBGREQUESTn_RD(n)        (HW_ICOLL_DBGREQUESTn(n).U)
    #endif


/*
 * constants & macros for individual HW_ICOLL_DBGREQUESTn multi-register bitfields
 */
/* --- Register HW_ICOLL_DBGREQUESTn, field BITS */

#define BP_ICOLL_DBGREQUESTn_BITS      0
#define BM_ICOLL_DBGREQUESTn_BITS      0xFFFFFFFF

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_DBGREQUESTn_BITS(v)   ((reg32_t) v)
#else
#define BF_ICOLL_DBGREQUESTn_BITS(v)   (v)
#endif


/*
 * HW_ICOLL_VERSION - Interrupt Collector Version Register
 */
#ifndef __LANGUAGE_ASM__
typedef union
{
    reg32_t  U;
    struct
    {
        unsigned STEP   : 16;
        unsigned MINOR  :  8;
        unsigned MAJOR  :  8;
    } B;
} hw_icoll_version_t;
#endif

/*
 * constants & macros for entire HW_ICOLL_VERSION register
 */
#define HW_ICOLL_VERSION_ADDR         (REGS_ICOLL_BASE + 0x11e0)

#ifndef __LANGUAGE_ASM__
#define HW_ICOLL_VERSION           (*(volatile hw_icoll_version_t *) HW_ICOLL_VERSION_ADDR)
#define HW_ICOLL_VERSION_RD()      (HW_ICOLL_VERSION.U)
#endif


/*
 * constants & macros for individual HW_ICOLL_VERSION bitfields
 */
/* --- Register HW_ICOLL_VERSION, field MAJOR */

#define BP_ICOLL_VERSION_MAJOR      24
#define BM_ICOLL_VERSION_MAJOR      0xFF000000

#ifndef __LANGUAGE_ASM__
#define BF_ICOLL_VERSION_MAJOR(v)   ((((reg32_t) v) << 24) & BM_ICOLL_VERSION_MAJOR)
#else
#define BF_ICOLL_VERSION_MAJOR(v)   (((v) << 24) & BM_ICOLL_VERSION_MAJOR)
#endif
/* --- Register HW_ICOLL_VERSION, field MINOR */

#define BP_ICOLL_VERSION_MINOR      16
#define BM_ICOLL_VERSION_MINOR      0x00FF0000

#define BF_ICOLL_VERSION_MINOR(v)   (((v) << 16) & BM_ICOLL_VERSION_MINOR)
/* --- Register HW_ICOLL_VERSION, field STEP */

#define BP_ICOLL_VERSION_STEP      0
#define BM_ICOLL_VERSION_STEP      0x0000FFFF

#define BF_ICOLL_VERSION_STEP(v)   (((v) << 0) & BM_ICOLL_VERSION_STEP)

#endif /* _ICOLL_H */

////////////////////////////////////////////////////////////////////////////////
