/* lcdgrilo.c generated by valac 0.32.0, the Vala compiler
 * generated from lcdgrilo.vala, do not modify */

/*   FILE: lcdgrilo.vala -- A simple DAAP music player
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 27 November 2013
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <gee.h>
#include <grilo.h>
#include <termios.h>
#include <unistd.h>
#include <gobject/gvaluecollector.h>


#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_STACK (stack_get_type ())
#define STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STACK, Stack))
#define STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STACK, StackClass))
#define IS_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STACK))
#define IS_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STACK))
#define STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STACK, StackClass))

typedef struct _Stack Stack;
typedef struct _StackClass StackClass;

#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_STATE_CHOOSE_SOURCE (state_choose_source_get_type ())
#define STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSource))
#define STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))
#define IS_STATE_CHOOSE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_SOURCE))
#define IS_STATE_CHOOSE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_SOURCE))
#define STATE_CHOOSE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_SOURCE, StateChooseSourceClass))

typedef struct _StateChooseSource StateChooseSource;
typedef struct _StateChooseSourceClass StateChooseSourceClass;
typedef struct _ParamSpecLCDPlayer ParamSpecLCDPlayer;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _lcd_player_unref0(var) ((var == NULL) ? NULL : (var = (lcd_player_unref (var), NULL)))

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};

struct _LCDPlayerPrivate {
	Stack* _stateStack;
	GMainLoop* loop;
	GeeArrayList* sources;
};

struct _ParamSpecLCDPlayer {
	GParamSpec parent_instance;
};


extern gboolean no_pifacecad;
gboolean no_pifacecad = FALSE;
extern gchar* tag;
gchar* tag = NULL;
static gpointer lcd_player_parent_class = NULL;

#define LIGHTS_OUT_SECONDS ((guint) 10)
#define SWITCH_POLL_MILLISECONDS ((guint) 1)
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType stack_get_type (void) G_GNUC_CONST;
GType state_get_type (void) G_GNUC_CONST;
#define LCD_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LCD_PLAYER, LCDPlayerPrivate))
enum  {
	LCD_PLAYER_DUMMY_PROPERTY
};
void lcd_player_source_added_cb (LCDPlayer* self, GrlSource* source);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
Stack* lcd_player_get_stateStack (LCDPlayer* self);
gpointer stack_peek (Stack* self);
void state_print_selected (State* self);
void lcd_player_source_removed_cb (LCDPlayer* self, GrlSource* source);
LCDPlayer* lcd_player_new (void);
LCDPlayer* lcd_player_construct (GType object_type);
static void _lcd_player_source_added_cb_grl_registry_source_added (GrlRegistry* _sender, GrlSource* source, gpointer self);
static void _lcd_player_source_removed_cb_grl_registry_source_removed (GrlRegistry* _sender, GrlSource* source, gpointer self);
Stack* stack_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
Stack* stack_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void lcd_player_set_stateStack (LCDPlayer* self, Stack* value);
static gboolean ___lambda7_ (LCDPlayer* self);
static gboolean ____lambda7__gsource_func (gpointer self);
void stack_push (Stack* self, gconstpointer item);
StateChooseSource* state_choose_source_new (GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
StateChooseSource* state_choose_source_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GeeArrayList* sources);
GType state_choose_source_get_type (void) G_GNUC_CONST;
static void lcd_player_finalize (LCDPlayer* obj);
gint _vala_main (gchar** args, int args_length1);
static gint _vala_array_length (gpointer array);

const GOptionEntry options[3] = {{"no-pifacecad", 'n', 0, G_OPTION_ARG_NONE, &no_pifacecad, "Do not try to use PiFace CAD for I/O", NULL}, {"tag", 't', (gint) G_OPTION_ARG_NONE, G_OPTION_ARG_STRING, &tag, "Only show sources with the following tag", NULL}, {NULL}};

static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void lcd_player_source_added_cb (LCDPlayer* self, GrlSource* source) {
	GrlSource* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	GeeArrayList* _tmp7_ = NULL;
	GrlSource* _tmp8_ = NULL;
	Stack* _tmp9_ = NULL;
	Stack* _tmp10_ = NULL;
	gpointer _tmp11_ = NULL;
	State* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = source;
	_tmp1_ = grl_source_supported_operations (_tmp0_);
	if ((_tmp1_ & GRL_OP_BROWSE) == ((guint) 0)) {
		return;
	}
	_tmp2_ = tag;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		GrlSource* _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		_tmp3_ = tag;
		_tmp4_ = source;
		_tmp6_ = _tmp5_ = grl_source_get_tags (_tmp4_);
		if (!_vala_string_array_contains (_tmp6_, _vala_array_length (_tmp5_), _tmp3_)) {
			return;
		}
	}
	_tmp7_ = self->priv->sources;
	_tmp8_ = source;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->_stateStack;
	if (_tmp9_ == NULL) {
		return;
	}
	_tmp10_ = self->priv->_stateStack;
	_tmp11_ = stack_peek (_tmp10_);
	_tmp12_ = (State*) _tmp11_;
	state_print_selected (_tmp12_);
	_g_object_unref0 (_tmp12_);
}


void lcd_player_source_removed_cb (LCDPlayer* self, GrlSource* source) {
	GeeArrayList* _tmp0_ = NULL;
	GrlSource* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->sources;
	_tmp1_ = source;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lcd_player_source_added_cb_grl_registry_source_added (GrlRegistry* _sender, GrlSource* source, gpointer self) {
	lcd_player_source_added_cb ((LCDPlayer*) self, source);
}


static void _lcd_player_source_removed_cb_grl_registry_source_removed (GrlRegistry* _sender, GrlSource* source, gpointer self) {
	lcd_player_source_removed_cb ((LCDPlayer*) self, source);
}


static gboolean ___lambda7_ (LCDPlayer* self) {
	gboolean result = FALSE;
	pifacecad_lcd_backlight_off ();
	result = FALSE;
	return result;
}


static gboolean ____lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda7_ ((LCDPlayer*) self);
	return result;
}


LCDPlayer* lcd_player_construct (GType object_type) {
	LCDPlayer* self = NULL;
	GrlRegistry* registry = NULL;
	GrlRegistry* _tmp0_ = NULL;
	GrlRegistry* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	GMainLoop* _tmp7_ = NULL;
	GstElement* _tmp8_ = NULL;
	GstElement* _tmp9_ = NULL;
	Stack* _tmp10_ = NULL;
	Stack* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	Stack* _tmp13_ = NULL;
	GMainLoop* _tmp14_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	StateChooseSource* _tmp16_ = NULL;
	StateChooseSource* _tmp17_ = NULL;
	GMainLoop* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (LCDPlayer*) g_type_create_instance (object_type);
	_tmp0_ = grl_registry_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	registry = _tmp1_;
	g_signal_connect (registry, "source-added", (GCallback) _lcd_player_source_added_cb_grl_registry_source_added, self);
	g_signal_connect (registry, "source-removed", (GCallback) _lcd_player_source_removed_cb_grl_registry_source_removed, self);
	{
		grl_registry_load_all_plugins (registry, FALSE, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e->message;
		g_error ("lcdgrilo.vala:78: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = tag;
	if (_tmp3_ == NULL) {
		{
			grl_registry_activate_plugin_by_id (registry, "grl-daap", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e->message;
			g_error ("lcdgrilo.vala:87: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (registry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	} else {
		{
			grl_registry_activate_all_plugins (registry);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_error ("lcdgrilo.vala:93: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (registry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp7_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp7_;
	_tmp8_ = gst_element_factory_make ("playbin", "play");
	if (_tmp8_ != NULL) {
		g_object_ref_sink (_tmp8_);
	}
	_g_object_unref0 (self->element);
	self->element = _tmp8_;
	_tmp9_ = self->element;
	((GstObject*) _tmp9_)->flags = (guint32) (0x00000002 | 0x00000010);
	_tmp10_ = stack_new (TYPE_STATE, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_tmp11_ = _tmp10_;
	lcd_player_set_stateStack (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = no_pifacecad;
	if (!_tmp12_) {
		pifacecad_open ();
		pifacecad_lcd_backlight_on ();
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, LIGHTS_OUT_SECONDS, ____lambda7__gsource_func, lcd_player_ref (self), lcd_player_unref);
	}
	_tmp13_ = self->priv->_stateStack;
	_tmp14_ = self->priv->loop;
	_tmp15_ = self->priv->sources;
	_tmp16_ = state_choose_source_new (_tmp14_, self, _tmp15_);
	_tmp17_ = _tmp16_;
	stack_push (_tmp13_, (State*) _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->loop;
	g_main_loop_run (_tmp18_);
	_tmp19_ = no_pifacecad;
	if (!_tmp19_) {
		pifacecad_close ();
	}
	_g_object_unref0 (registry);
	return self;
}


LCDPlayer* lcd_player_new (void) {
	return lcd_player_construct (TYPE_LCD_PLAYER);
}


Stack* lcd_player_get_stateStack (LCDPlayer* self) {
	Stack* result;
	Stack* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stateStack;
	result = _tmp0_;
	return result;
}


void lcd_player_set_stateStack (LCDPlayer* self, Stack* value) {
	Stack* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_stateStack);
	self->priv->_stateStack = _tmp1_;
}


static void value_lcd_player_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_lcd_player_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		lcd_player_unref (value->data[0].v_pointer);
	}
}


static void value_lcd_player_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = lcd_player_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_lcd_player_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_lcd_player_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		LCDPlayer* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = lcd_player_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_lcd_player_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	LCDPlayer** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = lcd_player_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecLCDPlayer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_LCD_PLAYER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_lcd_player (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER), NULL);
	return value->data[0].v_pointer;
}


void value_set_lcd_player (GValue* value, gpointer v_object) {
	LCDPlayer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		lcd_player_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_player_unref (old);
	}
}


void value_take_lcd_player (GValue* value, gpointer v_object) {
	LCDPlayer* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_LCD_PLAYER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_LCD_PLAYER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		lcd_player_unref (old);
	}
}


static void lcd_player_class_init (LCDPlayerClass * klass) {
	lcd_player_parent_class = g_type_class_peek_parent (klass);
	((LCDPlayerClass *) klass)->finalize = lcd_player_finalize;
	g_type_class_add_private (klass, sizeof (LCDPlayerPrivate));
}


static void lcd_player_instance_init (LCDPlayer * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = LCD_PLAYER_GET_PRIVATE (self);
	self->priv->_stateStack = NULL;
	_tmp0_ = gee_array_list_new (grl_source_get_type (), NULL, NULL, NULL, NULL, NULL);
	self->priv->sources = _tmp0_;
	self->ref_count = 1;
}


static void lcd_player_finalize (LCDPlayer* obj) {
	LCDPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LCD_PLAYER, LCDPlayer);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_stateStack);
	_g_object_unref0 (self->element);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->sources);
}


GType lcd_player_get_type (void) {
	static volatile gsize lcd_player_type_id__volatile = 0;
	if (g_once_init_enter (&lcd_player_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_lcd_player_init, value_lcd_player_free_value, value_lcd_player_copy_value, value_lcd_player_peek_pointer, "p", value_lcd_player_collect_value, "p", value_lcd_player_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (LCDPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lcd_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LCDPlayer), 0, (GInstanceInitFunc) lcd_player_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType lcd_player_type_id;
		lcd_player_type_id = g_type_register_fundamental (g_type_fundamental_next (), "LCDPlayer", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&lcd_player_type_id__volatile, lcd_player_type_id);
	}
	return lcd_player_type_id__volatile;
}


gpointer lcd_player_ref (gpointer instance) {
	LCDPlayer* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void lcd_player_unref (gpointer instance) {
	LCDPlayer* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		LCD_PLAYER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	struct termios old_tio = {0};
	struct termios new_tio = {0};
	struct termios _tmp2_ = {0};
	struct termios _tmp3_ = {0};
	tcflag_t _tmp4_ = {0};
	struct termios _tmp5_ = {0};
	LCDPlayer* _tmp6_ = NULL;
	LCDPlayer* _tmp7_ = NULL;
	struct termios _tmp8_ = {0};
	GError * _inner_error_ = NULL;
	gst_init (&args_length1, &args);
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_ = NULL;
		_tmp0_ = g_option_context_new ("- Media player");
		opt_context = _tmp0_;
		g_option_context_set_help_enabled (opt_context, TRUE);
		grl_init (&args_length1, &args);
		g_option_context_add_main_entries (opt_context, options, NULL);
		g_option_context_parse (opt_context, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e->message;
		g_error ("lcdgrilo.vala:136: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	tcgetattr (STDIN_FILENO, &_tmp2_);
	old_tio = _tmp2_;
	_tmp3_ = old_tio;
	new_tio = _tmp3_;
	_tmp4_ = new_tio.c_lflag;
	new_tio.c_lflag = _tmp4_ & ((~ICANON) & (~ECHO));
	_tmp5_ = new_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp5_);
	_tmp6_ = lcd_player_new ();
	_tmp7_ = _tmp6_;
	_lcd_player_unref0 (_tmp7_);
	_tmp8_ = old_tio;
	tcsetattr (STDIN_FILENO, TCSANOW, &_tmp8_);
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



