/* state-choose-category.c generated by valac 0.32.0, the Vala compiler
 * generated from state-choose-category.vala, do not modify */

/*   FILE: state-choose-category.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <grilo.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CATEGORY_TYPE (category_type_get_type ())

#define TYPE_CATEGORY (category_get_type ())
typedef struct _Category Category;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;

#define TYPE_STATE_CHOOSE_CATEGORY (state_choose_category_get_type ())
#define STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategory))
#define STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))
#define IS_STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_CATEGORY))
#define IS_STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_CATEGORY))
#define STATE_CHOOSE_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))

typedef struct _StateChooseCategory StateChooseCategory;
typedef struct _StateChooseCategoryClass StateChooseCategoryClass;
typedef struct _StateChooseCategoryPrivate StateChooseCategoryPrivate;

#define STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER (state_choose_category_child_media_list_builder_get_type ())
#define STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, StateChooseCategoryChildMediaListBuilder))
#define STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, StateChooseCategoryChildMediaListBuilderClass))
#define STATE_CHOOSE_CATEGORY_IS_CHILD_MEDIA_LIST_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER))
#define STATE_CHOOSE_CATEGORY_IS_CHILD_MEDIA_LIST_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER))
#define STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, StateChooseCategoryChildMediaListBuilderClass))

typedef struct _StateChooseCategoryChildMediaListBuilder StateChooseCategoryChildMediaListBuilder;
typedef struct _StateChooseCategoryChildMediaListBuilderClass StateChooseCategoryChildMediaListBuilderClass;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _state_choose_category_child_media_list_builder_unref0(var) ((var == NULL) ? NULL : (var = (state_choose_category_child_media_list_builder_unref (var), NULL)))
#define _category_free0(var) ((var == NULL) ? NULL : (var = (category_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_STATE_CONNECTING (state_connecting_get_type ())
#define STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CONNECTING, StateConnecting))
#define STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CONNECTING, StateConnectingClass))
#define IS_STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CONNECTING))
#define IS_STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CONNECTING))
#define STATE_CONNECTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CONNECTING, StateConnectingClass))

typedef struct _StateConnecting StateConnecting;
typedef struct _StateConnectingClass StateConnectingClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_STATE_PLAY (state_play_get_type ())
#define STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_PLAY, StatePlay))
#define STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_PLAY, StatePlayClass))
#define IS_STATE_PLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_PLAY))
#define IS_STATE_PLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_PLAY))
#define STATE_PLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_PLAY, StatePlayClass))

typedef struct _StatePlay StatePlay;
typedef struct _StatePlayClass StatePlayClass;
typedef struct _StateChooseCategoryChildMediaListBuilderPrivate StateChooseCategoryChildMediaListBuilderPrivate;
typedef struct _StateChooseCategoryParamSpecChildMediaListBuilder StateChooseCategoryParamSpecChildMediaListBuilder;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CATEGORY_TYPE_BOX,
	CATEGORY_TYPE_MORE,
	CATEGORY_TYPE_TRACK,
	CATEGORY_TYPE_PLAYALL
} CategoryType;

struct _Category {
	CategoryType type;
	GrlMedia* media;
};

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StateChooseCategory {
	State parent_instance;
	StateChooseCategoryPrivate * priv;
};

struct _StateChooseCategoryClass {
	StateClass parent_class;
};

struct _StateChooseCategoryPrivate {
	gint page;
	GrlMedia* parent_selection;
	GMainLoop* loop;
	GrlSource* source;
	GeeArrayList* categories;
	gint current;
	GrlMedia* canary;
	GeeArrayList* media;
	StateChooseCategoryChildMediaListBuilder* child_media_list_builder;
};

struct _StateChooseCategoryChildMediaListBuilder {
	GTypeInstance parent_instance;
	volatile int ref_count;
	StateChooseCategoryChildMediaListBuilderPrivate * priv;
};

struct _StateChooseCategoryChildMediaListBuilderClass {
	GTypeClass parent_class;
	void (*finalize) (StateChooseCategoryChildMediaListBuilder *self);
};

struct _StateChooseCategoryChildMediaListBuilderPrivate {
	StateChooseCategory* state;
	guint count;
};

struct _StateChooseCategoryParamSpecChildMediaListBuilder {
	GParamSpec parent_instance;
};

typedef gchar* (*StateChooseCategoryGetFunc) (GrlMedia* media, void* user_data);

static gpointer state_choose_category_parent_class = NULL;
static gpointer state_choose_category_child_media_list_builder_parent_class = NULL;

#define PAGE_SIZE 100
GType category_type_get_type (void) G_GNUC_CONST;
GType category_get_type (void) G_GNUC_CONST;
Category* category_dup (const Category* self);
void category_free (Category* self);
void category_copy (const Category* self, Category* dest);
void category_destroy (Category* self);
void category_init (Category *self, CategoryType type, GrlMedia* media);
GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
GType state_choose_category_get_type (void) G_GNUC_CONST;
static gpointer state_choose_category_child_media_list_builder_ref (gpointer instance);
static void state_choose_category_child_media_list_builder_unref (gpointer instance);
static GParamSpec* state_choose_category_param_spec_child_media_list_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void state_choose_category_value_set_child_media_list_builder (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void state_choose_category_value_take_child_media_list_builder (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer state_choose_category_value_get_child_media_list_builder (const GValue* value) G_GNUC_UNUSED;
static GType state_choose_category_child_media_list_builder_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define STATE_CHOOSE_CATEGORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryPrivate))
enum  {
	STATE_CHOOSE_CATEGORY_DUMMY_PROPERTY
};
void state_choose_category_add_media (StateChooseCategory* self, GrlMedia* media);
StateChooseCategory* state_choose_category_new (GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection);
StateChooseCategory* state_choose_category_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection);
State* state_construct (GType object_type);
void state_choose_category_build_menu (StateChooseCategory* self);
void state_print_selected (State* self);
static void state_choose_category_real_print_selected (State* base);
void state_output (State* self, const gchar* str);
static void state_choose_category_real_seekback (State* base);
static void state_choose_category_real_seekforward (State* base);
static void state_choose_category_real_next (State* base);
static void state_choose_category_real_previous (State* base);
static State* state_choose_category_real_transition (State* base);
static StateChooseCategoryChildMediaListBuilder* state_choose_category_child_media_list_builder_new (StateChooseCategory* state);
static StateChooseCategoryChildMediaListBuilder* state_choose_category_child_media_list_builder_construct (GType object_type, StateChooseCategory* state);
static void state_choose_category_child_media_list_builder_browse_cb (StateChooseCategoryChildMediaListBuilder* self, GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, GError* _error_);
static void _state_choose_category_child_media_list_builder_browse_cb_grl_source_result_cb (GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, gpointer self, GError* _error_);
StateConnecting* state_connecting_new (GMainLoop* loop, LCDPlayer* player, const gchar* source_name, State* next_state);
StateConnecting* state_connecting_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, const gchar* source_name, State* next_state);
GType state_connecting_get_type (void) G_GNUC_CONST;
static gint ___lambda5_ (StateChooseCategory* self, GrlMedia* m1, GrlMedia* m2);
static gint ____lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
GType state_play_get_type (void) G_GNUC_CONST;
StatePlay* state_play_get_instance (GMainLoop* loop, LCDPlayer* player, GeeArrayList* playlist);
#define STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, StateChooseCategoryChildMediaListBuilderPrivate))
enum  {
	STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_DUMMY_PROPERTY
};
static gint ___lambda4_ (StateChooseCategoryChildMediaListBuilder* self, GrlMedia* m1, GrlMedia* m2);
static gint ____lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
void state_connected_cb (State* self, GrlSource* source);
static void state_choose_category_child_media_list_builder_finalize (StateChooseCategoryChildMediaListBuilder* obj);
static void state_choose_category_finalize (GObject* obj);


GType category_type_get_type (void) {
	static volatile gsize category_type_type_id__volatile = 0;
	if (g_once_init_enter (&category_type_type_id__volatile)) {
		static const GEnumValue values[] = {{CATEGORY_TYPE_BOX, "CATEGORY_TYPE_BOX", "box"}, {CATEGORY_TYPE_MORE, "CATEGORY_TYPE_MORE", "more"}, {CATEGORY_TYPE_TRACK, "CATEGORY_TYPE_TRACK", "track"}, {CATEGORY_TYPE_PLAYALL, "CATEGORY_TYPE_PLAYALL", "playall"}, {0, NULL, NULL}};
		GType category_type_type_id;
		category_type_type_id = g_enum_register_static ("CategoryType", values);
		g_once_init_leave (&category_type_type_id__volatile, category_type_type_id);
	}
	return category_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void category_init (Category *self, CategoryType type, GrlMedia* media) {
	CategoryType _tmp0_ = 0;
	GrlMedia* _tmp1_ = NULL;
	GrlMedia* _tmp2_ = NULL;
	memset (self, 0, sizeof (Category));
	_tmp0_ = type;
	(*self).type = _tmp0_;
	_tmp1_ = media;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 ((*self).media);
	(*self).media = _tmp2_;
}


void category_copy (const Category* self, Category* dest) {
	CategoryType _tmp0_ = 0;
	GrlMedia* _tmp1_ = NULL;
	GrlMedia* _tmp2_ = NULL;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).media;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 ((*dest).media);
	(*dest).media = _tmp2_;
}


void category_destroy (Category* self) {
	_g_object_unref0 ((*self).media);
}


Category* category_dup (const Category* self) {
	Category* dup;
	dup = g_new0 (Category, 1);
	category_copy (self, dup);
	return dup;
}


void category_free (Category* self) {
	category_destroy (self);
	g_free (self);
}


GType category_get_type (void) {
	static volatile gsize category_type_id__volatile = 0;
	if (g_once_init_enter (&category_type_id__volatile)) {
		GType category_type_id;
		category_type_id = g_boxed_type_register_static ("Category", (GBoxedCopyFunc) category_dup, (GBoxedFreeFunc) category_free);
		g_once_init_leave (&category_type_id__volatile, category_type_id);
	}
	return category_type_id__volatile;
}


void state_choose_category_add_media (StateChooseCategory* self, GrlMedia* media) {
	GeeArrayList* _tmp0_ = NULL;
	GrlMedia* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (media != NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = media;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, _tmp1_);
}


static gpointer _g_main_loop_ref0 (gpointer self) {
	return self ? g_main_loop_ref (self) : NULL;
}


StateChooseCategory* state_choose_category_construct (GType object_type, GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection) {
	StateChooseCategory * self = NULL;
	GMainLoop* _tmp0_ = NULL;
	GMainLoop* _tmp1_ = NULL;
	LCDPlayer* _tmp2_ = NULL;
	GrlSource* _tmp3_ = NULL;
	GrlSource* _tmp4_ = NULL;
	GrlMedia* _tmp5_ = NULL;
	GrlMedia* _tmp6_ = NULL;
	g_return_val_if_fail (loop != NULL, NULL);
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (StateChooseCategory*) state_construct (object_type);
	_tmp0_ = loop;
	_tmp1_ = _g_main_loop_ref0 (_tmp0_);
	_g_main_loop_unref0 (self->priv->loop);
	self->priv->loop = _tmp1_;
	_tmp2_ = player;
	((State*) self)->player = _tmp2_;
	_tmp3_ = source;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp4_;
	_tmp5_ = parent_selection;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->parent_selection);
	self->priv->parent_selection = _tmp6_;
	return self;
}


StateChooseCategory* state_choose_category_new (GMainLoop* loop, LCDPlayer* player, GrlSource* source, GrlMedia* parent_selection) {
	return state_choose_category_construct (TYPE_STATE_CHOOSE_CATEGORY, loop, player, source, parent_selection);
}


void state_choose_category_build_menu (StateChooseCategory* self) {
	gboolean have_media = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gboolean _tmp24_ = FALSE;
	GrlMedia* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	have_media = FALSE;
	_tmp0_ = gee_array_list_new (TYPE_CATEGORY, (GBoxedCopyFunc) category_dup, category_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->categories);
	self->priv->categories = _tmp0_;
	{
		GeeArrayList* _m_list = NULL;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		gint _m_size = 0;
		GeeArrayList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _m_index = 0;
		_tmp1_ = self->priv->media;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_m_list = _tmp2_;
		_tmp3_ = _m_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_m_size = _tmp5_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			GrlMedia* m = NULL;
			GeeArrayList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GrlMedia* _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			_tmp6_ = _m_index;
			_m_index = _tmp6_ + 1;
			_tmp7_ = _m_index;
			_tmp8_ = _m_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _m_list;
			_tmp10_ = _m_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			m = (GrlMedia*) _tmp11_;
			_tmp12_ = m;
			_tmp13_ = grl_media_is_container (_tmp12_);
			if (_tmp13_) {
				GeeArrayList* _tmp14_ = NULL;
				GrlMedia* _tmp15_ = NULL;
				Category _tmp16_ = {0};
				Category _tmp17_ = {0};
				Category _tmp18_ = {0};
				_tmp14_ = self->priv->categories;
				_tmp15_ = m;
				category_init (&_tmp16_, CATEGORY_TYPE_BOX, _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, &_tmp18_);
				category_destroy (&_tmp17_);
			} else {
				GeeArrayList* _tmp19_ = NULL;
				GrlMedia* _tmp20_ = NULL;
				Category _tmp21_ = {0};
				Category _tmp22_ = {0};
				Category _tmp23_ = {0};
				have_media = TRUE;
				_tmp19_ = self->priv->categories;
				_tmp20_ = m;
				category_init (&_tmp21_, CATEGORY_TYPE_TRACK, _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp23_);
				category_destroy (&_tmp22_);
			}
			_g_object_unref0 (m);
		}
		_g_object_unref0 (_m_list);
	}
	_tmp24_ = have_media;
	if (TRUE == _tmp24_) {
		GeeArrayList* _tmp25_ = NULL;
		Category _tmp26_ = {0};
		Category _tmp27_ = {0};
		Category _tmp28_ = {0};
		_tmp25_ = self->priv->categories;
		category_init (&_tmp26_, CATEGORY_TYPE_PLAYALL, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		gee_abstract_list_insert ((GeeAbstractList*) _tmp25_, 0, &_tmp28_);
		category_destroy (&_tmp27_);
	}
	_tmp29_ = self->priv->canary;
	if (NULL != _tmp29_) {
		GeeArrayList* _tmp30_ = NULL;
		Category _tmp31_ = {0};
		Category _tmp32_ = {0};
		Category _tmp33_ = {0};
		_tmp30_ = self->priv->categories;
		category_init (&_tmp31_, CATEGORY_TYPE_MORE, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, &_tmp33_);
		category_destroy (&_tmp32_);
	}
	state_print_selected ((State*) self);
}


static void state_choose_category_real_print_selected (State* base) {
	StateChooseCategory * self;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	Category* _tmp3_ = NULL;
	CategoryType _tmp4_ = 0;
	CategoryType _tmp5_ = 0;
	self = (StateChooseCategory*) base;
	_tmp0_ = self->priv->categories;
	_tmp1_ = self->priv->current;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
	_tmp3_ = (Category*) _tmp2_;
	_tmp4_ = (*_tmp3_).type;
	_tmp5_ = _tmp4_;
	_category_free0 (_tmp3_);
	switch (_tmp5_) {
		case CATEGORY_TYPE_BOX:
		{
			GeeArrayList* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gpointer _tmp8_ = NULL;
			Category* _tmp9_ = NULL;
			GrlMedia* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			_tmp6_ = self->priv->categories;
			_tmp7_ = self->priv->current;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _tmp7_);
			_tmp9_ = (Category*) _tmp8_;
			_tmp10_ = (*_tmp9_).media;
			_tmp11_ = grl_media_get_title (_tmp10_);
			state_output ((State*) self, _tmp11_);
			_category_free0 (_tmp9_);
			break;
		}
		case CATEGORY_TYPE_TRACK:
		{
			GString* builder = NULL;
			GString* _tmp12_ = NULL;
			GeeArrayList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			Category* _tmp16_ = NULL;
			GrlMedia* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			GString* _tmp32_ = NULL;
			GeeArrayList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			Category* _tmp36_ = NULL;
			GrlMedia* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			GString* _tmp39_ = NULL;
			const gchar* _tmp40_ = NULL;
			_tmp12_ = g_string_new ("");
			builder = _tmp12_;
			_tmp13_ = self->priv->categories;
			_tmp14_ = self->priv->current;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			_tmp16_ = (Category*) _tmp15_;
			_tmp17_ = (*_tmp16_).media;
			_tmp18_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, grl_media_get_type ());
			_category_free0 (_tmp16_);
			if (_tmp18_) {
				gint track = 0;
				GeeArrayList* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gpointer _tmp21_ = NULL;
				Category* _tmp22_ = NULL;
				GrlMedia* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				_tmp19_ = self->priv->categories;
				_tmp20_ = self->priv->current;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
				_tmp22_ = (Category*) _tmp21_;
				_tmp23_ = (*_tmp22_).media;
				_tmp24_ = grl_media_get_track_number (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, grl_media_get_type (), GrlMedia));
				_tmp25_ = _tmp24_;
				_category_free0 (_tmp22_);
				track = _tmp25_;
				_tmp26_ = track;
				if (_tmp26_ != 0) {
					GString* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_ = NULL;
					GString* _tmp31_ = NULL;
					_tmp27_ = builder;
					_tmp28_ = track;
					_tmp29_ = g_strdup_printf ("%i", _tmp28_);
					_tmp30_ = _tmp29_;
					g_string_append (_tmp27_, _tmp30_);
					_g_free0 (_tmp30_);
					_tmp31_ = builder;
					g_string_append (_tmp31_, ". ");
				}
			}
			_tmp32_ = builder;
			_tmp33_ = self->priv->categories;
			_tmp34_ = self->priv->current;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _tmp34_);
			_tmp36_ = (Category*) _tmp35_;
			_tmp37_ = (*_tmp36_).media;
			_tmp38_ = grl_media_get_title (_tmp37_);
			g_string_append (_tmp32_, _tmp38_);
			_category_free0 (_tmp36_);
			_tmp39_ = builder;
			_tmp40_ = _tmp39_->str;
			state_output ((State*) self, _tmp40_);
			_g_string_free0 (builder);
			break;
		}
		case CATEGORY_TYPE_MORE:
		{
			state_output ((State*) self, "More...");
			break;
		}
		case CATEGORY_TYPE_PLAYALL:
		{
			state_output ((State*) self, "Play all");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void state_choose_category_real_seekback (State* base) {
	StateChooseCategory * self;
	self = (StateChooseCategory*) base;
}


static void state_choose_category_real_seekforward (State* base) {
	StateChooseCategory * self;
	self = (StateChooseCategory*) base;
}


static void state_choose_category_real_next (State* base) {
	StateChooseCategory * self;
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = (StateChooseCategory*) base;
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->categories;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->current = (_tmp0_ + 1) % _tmp3_;
	state_print_selected ((State*) self);
}


static void state_choose_category_real_previous (State* base) {
	StateChooseCategory * self;
	gint _tmp0_ = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	self = (StateChooseCategory*) base;
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->categories;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->categories;
	_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	self->priv->current = ((_tmp0_ + _tmp3_) - 1) % _tmp6_;
	state_print_selected ((State*) self);
}


static void _state_choose_category_child_media_list_builder_browse_cb_grl_source_result_cb (GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, gpointer self, GError* _error_) {
	state_choose_category_child_media_list_builder_browse_cb ((StateChooseCategoryChildMediaListBuilder*) self, source, operation_id, media, remaining, _error_);
}


static gint ___lambda5_ (StateChooseCategory* self, GrlMedia* m1, GrlMedia* m2) {
	gint result = 0;
	GrlMedia* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GrlMedia* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (m1 != NULL, 0);
	g_return_val_if_fail (m2 != NULL, 0);
	_tmp0_ = m1;
	_tmp1_ = grl_media_get_track_number (_tmp0_);
	_tmp2_ = m2;
	_tmp3_ = grl_media_get_track_number (_tmp2_);
	result = _tmp1_ - _tmp3_;
	return result;
}


static gint ____lambda5__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = ___lambda5_ ((StateChooseCategory*) self, (GrlMedia*) a, (GrlMedia*) b);
	return result;
}


static State* state_choose_category_real_transition (State* base) {
	StateChooseCategory * self;
	State* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	Category* _tmp3_ = NULL;
	CategoryType _tmp4_ = 0;
	CategoryType _tmp5_ = 0;
	self = (StateChooseCategory*) base;
	_tmp0_ = self->priv->categories;
	_tmp1_ = self->priv->current;
	_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, _tmp1_);
	_tmp3_ = (Category*) _tmp2_;
	_tmp4_ = (*_tmp3_).type;
	_tmp5_ = _tmp4_;
	_category_free0 (_tmp3_);
	switch (_tmp5_) {
		case CATEGORY_TYPE_BOX:
		{
			GList* keys = NULL;
			GrlKeyID _tmp6_ = 0U;
			GrlKeyID _tmp7_ = 0U;
			GrlKeyID _tmp8_ = 0U;
			GrlKeyID _tmp9_ = 0U;
			GrlKeyID _tmp10_ = 0U;
			GList* _tmp11_ = NULL;
			GrlCaps* caps = NULL;
			GrlSource* _tmp12_ = NULL;
			GrlCaps* _tmp13_ = NULL;
			GrlCaps* _tmp14_ = NULL;
			GrlOperationOptions* options = NULL;
			GrlCaps* _tmp15_ = NULL;
			GrlOperationOptions* _tmp16_ = NULL;
			StateChooseCategory* next_state = NULL;
			GMainLoop* _tmp17_ = NULL;
			LCDPlayer* _tmp18_ = NULL;
			GrlSource* _tmp19_ = NULL;
			GeeArrayList* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gpointer _tmp22_ = NULL;
			Category* _tmp23_ = NULL;
			GrlMedia* _tmp24_ = NULL;
			StateChooseCategory* _tmp25_ = NULL;
			StateChooseCategory* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			GrlOperationOptions* _tmp28_ = NULL;
			StateChooseCategory* _tmp29_ = NULL;
			StateChooseCategoryChildMediaListBuilder* _tmp30_ = NULL;
			GrlSource* _tmp31_ = NULL;
			GeeArrayList* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gpointer _tmp34_ = NULL;
			Category* _tmp35_ = NULL;
			GrlMedia* _tmp36_ = NULL;
			GList* _tmp37_ = NULL;
			GrlOperationOptions* _tmp38_ = NULL;
			StateChooseCategoryChildMediaListBuilder* _tmp39_ = NULL;
			GMainLoop* _tmp40_ = NULL;
			LCDPlayer* _tmp41_ = NULL;
			GeeArrayList* _tmp42_ = NULL;
			gint _tmp43_ = 0;
			gpointer _tmp44_ = NULL;
			Category* _tmp45_ = NULL;
			GrlMedia* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			StateChooseCategory* _tmp48_ = NULL;
			StateConnecting* _tmp49_ = NULL;
			State* _tmp50_ = NULL;
			_tmp6_ = GRL_METADATA_KEY_ALBUM;
			_tmp7_ = GRL_METADATA_KEY_ARTIST;
			_tmp8_ = GRL_METADATA_KEY_TITLE;
			_tmp9_ = GRL_METADATA_KEY_TRACK_NUMBER;
			_tmp10_ = GRL_METADATA_KEY_URL;
			_tmp11_ = grl_metadata_key_list_new (_tmp6_, _tmp7_, _tmp8_, _tmp9_, _tmp10_, NULL);
			keys = _tmp11_;
			_tmp12_ = self->priv->source;
			_tmp13_ = grl_source_get_caps (_tmp12_, GRL_OP_BROWSE);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			caps = _tmp14_;
			_tmp15_ = caps;
			_tmp16_ = grl_operation_options_new (_tmp15_);
			options = _tmp16_;
			_tmp17_ = self->priv->loop;
			_tmp18_ = ((State*) self)->player;
			_tmp19_ = self->priv->source;
			_tmp20_ = self->priv->categories;
			_tmp21_ = self->priv->current;
			_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
			_tmp23_ = (Category*) _tmp22_;
			_tmp24_ = (*_tmp23_).media;
			_tmp25_ = state_choose_category_new (_tmp17_, _tmp18_, _tmp19_, _tmp24_);
			_tmp26_ = _tmp25_;
			_category_free0 (_tmp23_);
			next_state = _tmp26_;
			_tmp27_ = self->priv->page;
			self->priv->page = _tmp27_ + 1;
			_tmp28_ = options;
			grl_operation_options_set_count (_tmp28_, PAGE_SIZE);
			_tmp29_ = next_state;
			_tmp30_ = state_choose_category_child_media_list_builder_new (_tmp29_);
			_state_choose_category_child_media_list_builder_unref0 (self->priv->child_media_list_builder);
			self->priv->child_media_list_builder = _tmp30_;
			_tmp31_ = self->priv->source;
			_tmp32_ = self->priv->categories;
			_tmp33_ = self->priv->current;
			_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
			_tmp35_ = (Category*) _tmp34_;
			_tmp36_ = (*_tmp35_).media;
			_tmp37_ = keys;
			_tmp38_ = options;
			_tmp39_ = self->priv->child_media_list_builder;
			grl_source_browse (_tmp31_, _tmp36_, _tmp37_, _tmp38_, _state_choose_category_child_media_list_builder_browse_cb_grl_source_result_cb, _tmp39_);
			_category_free0 (_tmp35_);
			_tmp40_ = self->priv->loop;
			_tmp41_ = ((State*) self)->player;
			_tmp42_ = self->priv->categories;
			_tmp43_ = self->priv->current;
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _tmp43_);
			_tmp45_ = (Category*) _tmp44_;
			_tmp46_ = (*_tmp45_).media;
			_tmp47_ = grl_media_get_title (_tmp46_);
			_tmp48_ = next_state;
			_tmp49_ = state_connecting_new (_tmp40_, _tmp41_, _tmp47_, (State*) _tmp48_);
			_tmp50_ = (State*) _tmp49_;
			_category_free0 (_tmp45_);
			result = _tmp50_;
			_g_object_unref0 (next_state);
			_g_object_unref0 (options);
			_g_object_unref0 (caps);
			_g_list_free0 (keys);
			return result;
		}
		case CATEGORY_TYPE_MORE:
		{
			GeeArrayList* _tmp51_ = NULL;
			GeeArrayList* _tmp52_ = NULL;
			gint _tmp53_ = 0;
			gpointer _tmp54_ = NULL;
			Category* _tmp55_ = NULL;
			GList* keys = NULL;
			GrlKeyID _tmp56_ = 0U;
			GrlKeyID _tmp57_ = 0U;
			GrlKeyID _tmp58_ = 0U;
			GrlKeyID _tmp59_ = 0U;
			GrlKeyID _tmp60_ = 0U;
			GList* _tmp61_ = NULL;
			GrlCaps* caps = NULL;
			GrlSource* _tmp62_ = NULL;
			GrlCaps* _tmp63_ = NULL;
			GrlCaps* _tmp64_ = NULL;
			GrlOperationOptions* options = NULL;
			GrlCaps* _tmp65_ = NULL;
			GrlOperationOptions* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			GrlOperationOptions* _tmp68_ = NULL;
			gint _tmp69_ = 0;
			GrlOperationOptions* _tmp70_ = NULL;
			StateChooseCategoryChildMediaListBuilder* _tmp71_ = NULL;
			GrlSource* _tmp72_ = NULL;
			GrlMedia* _tmp73_ = NULL;
			GList* _tmp74_ = NULL;
			GrlOperationOptions* _tmp75_ = NULL;
			StateChooseCategoryChildMediaListBuilder* _tmp76_ = NULL;
			GMainLoop* _tmp77_ = NULL;
			LCDPlayer* _tmp78_ = NULL;
			GrlMedia* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
			StateConnecting* _tmp81_ = NULL;
			_tmp51_ = self->priv->categories;
			_tmp52_ = self->priv->categories;
			_tmp53_ = self->priv->current;
			_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp52_, _tmp53_);
			_tmp55_ = (Category*) _tmp54_;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp51_, _tmp55_);
			_category_free0 (_tmp55_);
			_tmp56_ = GRL_METADATA_KEY_ALBUM;
			_tmp57_ = GRL_METADATA_KEY_ARTIST;
			_tmp58_ = GRL_METADATA_KEY_TITLE;
			_tmp59_ = GRL_METADATA_KEY_TRACK_NUMBER;
			_tmp60_ = GRL_METADATA_KEY_URL;
			_tmp61_ = grl_metadata_key_list_new (_tmp56_, _tmp57_, _tmp58_, _tmp59_, _tmp60_, NULL);
			keys = _tmp61_;
			_tmp62_ = self->priv->source;
			_tmp63_ = grl_source_get_caps (_tmp62_, GRL_OP_BROWSE);
			_tmp64_ = _g_object_ref0 (_tmp63_);
			caps = _tmp64_;
			_tmp65_ = caps;
			_tmp66_ = grl_operation_options_new (_tmp65_);
			options = _tmp66_;
			_tmp67_ = self->priv->page;
			self->priv->page = _tmp67_ + 1;
			_tmp68_ = options;
			_tmp69_ = self->priv->page;
			grl_operation_options_set_skip (_tmp68_, (guint) (PAGE_SIZE * _tmp69_));
			_tmp70_ = options;
			grl_operation_options_set_count (_tmp70_, PAGE_SIZE);
			_tmp71_ = state_choose_category_child_media_list_builder_new (self);
			_state_choose_category_child_media_list_builder_unref0 (self->priv->child_media_list_builder);
			self->priv->child_media_list_builder = _tmp71_;
			_tmp72_ = self->priv->source;
			_tmp73_ = self->priv->parent_selection;
			_tmp74_ = keys;
			_tmp75_ = options;
			_tmp76_ = self->priv->child_media_list_builder;
			grl_source_browse (_tmp72_, _tmp73_, _tmp74_, _tmp75_, _state_choose_category_child_media_list_builder_browse_cb_grl_source_result_cb, _tmp76_);
			_tmp77_ = self->priv->loop;
			_tmp78_ = ((State*) self)->player;
			_tmp79_ = self->priv->parent_selection;
			_tmp80_ = grl_media_get_title (_tmp79_);
			_tmp81_ = state_connecting_new (_tmp77_, _tmp78_, _tmp80_, (State*) self);
			result = (State*) _tmp81_;
			_g_object_unref0 (options);
			_g_object_unref0 (caps);
			_g_list_free0 (keys);
			return result;
		}
		case CATEGORY_TYPE_PLAYALL:
		{
			GeeArrayList* playlist = NULL;
			GeeArrayList* _tmp82_ = NULL;
			GeeArrayList* _tmp97_ = NULL;
			GMainLoop* _tmp98_ = NULL;
			LCDPlayer* _tmp99_ = NULL;
			GeeArrayList* _tmp100_ = NULL;
			StatePlay* _tmp101_ = NULL;
			State* _tmp102_ = NULL;
			_tmp82_ = gee_array_list_new (grl_media_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
			playlist = _tmp82_;
			{
				GeeArrayList* _m_list = NULL;
				GeeArrayList* _tmp83_ = NULL;
				GeeArrayList* _tmp84_ = NULL;
				gint _m_size = 0;
				GeeArrayList* _tmp85_ = NULL;
				gint _tmp86_ = 0;
				gint _tmp87_ = 0;
				gint _m_index = 0;
				_tmp83_ = self->priv->media;
				_tmp84_ = _g_object_ref0 (_tmp83_);
				_m_list = _tmp84_;
				_tmp85_ = _m_list;
				_tmp86_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp85_);
				_tmp87_ = _tmp86_;
				_m_size = _tmp87_;
				_m_index = -1;
				while (TRUE) {
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					GrlMedia* m = NULL;
					GeeArrayList* _tmp91_ = NULL;
					gint _tmp92_ = 0;
					gpointer _tmp93_ = NULL;
					GrlMedia* _tmp94_ = NULL;
					_tmp88_ = _m_index;
					_m_index = _tmp88_ + 1;
					_tmp89_ = _m_index;
					_tmp90_ = _m_size;
					if (!(_tmp89_ < _tmp90_)) {
						break;
					}
					_tmp91_ = _m_list;
					_tmp92_ = _m_index;
					_tmp93_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _tmp92_);
					m = (GrlMedia*) _tmp93_;
					_tmp94_ = m;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp94_, grl_media_get_type ())) {
						GeeArrayList* _tmp95_ = NULL;
						GrlMedia* _tmp96_ = NULL;
						_tmp95_ = playlist;
						_tmp96_ = m;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp95_, G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, grl_media_get_type (), GrlMedia));
					}
					_g_object_unref0 (m);
				}
				_g_object_unref0 (_m_list);
			}
			_tmp97_ = playlist;
			gee_list_sort ((GeeList*) _tmp97_, ____lambda5__gcompare_data_func, g_object_ref (self), g_object_unref);
			_tmp98_ = self->priv->loop;
			_tmp99_ = ((State*) self)->player;
			_tmp100_ = playlist;
			_tmp101_ = state_play_get_instance (_tmp98_, _tmp99_, _tmp100_);
			_tmp102_ = _g_object_ref0 ((State*) _tmp101_);
			result = _tmp102_;
			_g_object_unref0 (playlist);
			return result;
		}
		case CATEGORY_TYPE_TRACK:
		{
			GeeArrayList* playlist = NULL;
			GeeArrayList* _tmp103_ = NULL;
			GeeArrayList* _tmp104_ = NULL;
			gint _tmp105_ = 0;
			gpointer _tmp106_ = NULL;
			Category* _tmp107_ = NULL;
			GrlMedia* _tmp108_ = NULL;
			GeeArrayList* _tmp109_ = NULL;
			GeeArrayList* _tmp110_ = NULL;
			gint _tmp111_ = 0;
			gpointer _tmp112_ = NULL;
			Category* _tmp113_ = NULL;
			GrlMedia* _tmp114_ = NULL;
			GMainLoop* _tmp115_ = NULL;
			LCDPlayer* _tmp116_ = NULL;
			GeeArrayList* _tmp117_ = NULL;
			StatePlay* _tmp118_ = NULL;
			State* _tmp119_ = NULL;
			_tmp103_ = gee_array_list_new (grl_media_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
			playlist = _tmp103_;
			_tmp104_ = self->priv->categories;
			_tmp105_ = self->priv->current;
			_tmp106_ = gee_abstract_list_get ((GeeAbstractList*) _tmp104_, _tmp105_);
			_tmp107_ = (Category*) _tmp106_;
			_tmp108_ = (*_tmp107_).media;
			_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, grl_media_get_type ()), "categories[current].media is Grl.Media");
			_category_free0 (_tmp107_);
			_tmp109_ = playlist;
			_tmp110_ = self->priv->categories;
			_tmp111_ = self->priv->current;
			_tmp112_ = gee_abstract_list_get ((GeeAbstractList*) _tmp110_, _tmp111_);
			_tmp113_ = (Category*) _tmp112_;
			_tmp114_ = (*_tmp113_).media;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, grl_media_get_type (), GrlMedia));
			_category_free0 (_tmp113_);
			_tmp115_ = self->priv->loop;
			_tmp116_ = ((State*) self)->player;
			_tmp117_ = playlist;
			_tmp118_ = state_play_get_instance (_tmp115_, _tmp116_, _tmp117_);
			_tmp119_ = _g_object_ref0 ((State*) _tmp118_);
			result = _tmp119_;
			_g_object_unref0 (playlist);
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static StateChooseCategoryChildMediaListBuilder* state_choose_category_child_media_list_builder_construct (GType object_type, StateChooseCategory* state) {
	StateChooseCategoryChildMediaListBuilder* self = NULL;
	StateChooseCategory* _tmp0_ = NULL;
	StateChooseCategory* _tmp1_ = NULL;
	g_return_val_if_fail (state != NULL, NULL);
	self = (StateChooseCategoryChildMediaListBuilder*) g_type_create_instance (object_type);
	_tmp0_ = state;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp1_;
	return self;
}


static StateChooseCategoryChildMediaListBuilder* state_choose_category_child_media_list_builder_new (StateChooseCategory* state) {
	return state_choose_category_child_media_list_builder_construct (STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, state);
}


static gint ___lambda4_ (StateChooseCategoryChildMediaListBuilder* self, GrlMedia* m1, GrlMedia* m2) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	GrlMedia* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (m1 != NULL, 0);
	g_return_val_if_fail (m2 != NULL, 0);
	_tmp1_ = m1;
	_tmp2_ = grl_media_is_audio (_tmp1_);
	if (_tmp2_) {
		GrlMedia* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = m2;
		_tmp4_ = grl_media_is_audio (_tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GrlMedia* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		GrlMedia* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp5_ = m1;
		_tmp6_ = grl_media_get_track_number (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, grl_media_get_type (), GrlMedia));
		_tmp7_ = m2;
		_tmp8_ = grl_media_get_track_number (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, grl_media_get_type (), GrlMedia));
		result = _tmp6_ - _tmp8_;
		return result;
	} else {
		GCompareFunc _tmp9_ = NULL;
		GrlMedia* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GrlMedia* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp9_ = g_strcmp0;
		_tmp10_ = m1;
		_tmp11_ = grl_media_get_title (_tmp10_);
		_tmp12_ = m2;
		_tmp13_ = grl_media_get_title (_tmp12_);
		_tmp14_ = _tmp9_ (_tmp11_, _tmp13_);
		result = _tmp14_;
		return result;
	}
}


static gint ____lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = ___lambda4_ ((StateChooseCategoryChildMediaListBuilder*) self, (GrlMedia*) a, (GrlMedia*) b);
	return result;
}


static void state_choose_category_child_media_list_builder_browse_cb (StateChooseCategoryChildMediaListBuilder* self, GrlSource* source, guint operation_id, GrlMedia* media, guint remaining, GError* _error_) {
	guint _tmp0_ = 0U;
	GError* _tmp1_ = NULL;
	GrlMedia* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	StateChooseCategory* _tmp4_ = NULL;
	GrlMedia* _tmp5_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp18_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->count;
	_vala_assert (_tmp0_ <= ((guint) PAGE_SIZE), "count <= PAGE_SIZE");
	_tmp1_ = _error_;
	if (NULL != _tmp1_) {
		_g_object_unref0 (media);
		return;
	}
	_tmp2_ = media;
	if (NULL == _tmp2_) {
		_g_object_unref0 (media);
		return;
	}
	_tmp3_ = self->priv->count;
	self->priv->count = _tmp3_ + 1;
	_tmp4_ = self->priv->state;
	_tmp5_ = _tmp4_->priv->canary;
	if (NULL != _tmp5_) {
		StateChooseCategory* _tmp6_ = NULL;
		GeeArrayList* _tmp7_ = NULL;
		StateChooseCategory* _tmp8_ = NULL;
		GrlMedia* _tmp9_ = NULL;
		StateChooseCategory* _tmp10_ = NULL;
		_tmp6_ = self->priv->state;
		_tmp7_ = _tmp6_->priv->media;
		_tmp8_ = self->priv->state;
		_tmp9_ = _tmp8_->priv->canary;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp9_);
		_tmp10_ = self->priv->state;
		_g_object_unref0 (_tmp10_->priv->canary);
		_tmp10_->priv->canary = NULL;
	}
	_tmp11_ = self->priv->count;
	if (_tmp11_ == ((guint) PAGE_SIZE)) {
		StateChooseCategory* _tmp12_ = NULL;
		GrlMedia* _tmp13_ = NULL;
		GrlMedia* _tmp14_ = NULL;
		_tmp12_ = self->priv->state;
		_tmp13_ = media;
		_tmp14_ = _g_object_ref0 (_tmp13_);
		_g_object_unref0 (_tmp12_->priv->canary);
		_tmp12_->priv->canary = _tmp14_;
	} else {
		StateChooseCategory* _tmp15_ = NULL;
		GeeArrayList* _tmp16_ = NULL;
		GrlMedia* _tmp17_ = NULL;
		_tmp15_ = self->priv->state;
		_tmp16_ = _tmp15_->priv->media;
		_tmp17_ = media;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp17_);
	}
	_tmp18_ = remaining;
	if (((guint) 0) == _tmp18_) {
		StateChooseCategory* _tmp19_ = NULL;
		GeeArrayList* _tmp20_ = NULL;
		StateChooseCategory* _tmp21_ = NULL;
		GrlSource* _tmp22_ = NULL;
		_tmp19_ = self->priv->state;
		_tmp20_ = _tmp19_->priv->media;
		gee_list_sort ((GeeList*) _tmp20_, ____lambda4__gcompare_data_func, state_choose_category_child_media_list_builder_ref (self), state_choose_category_child_media_list_builder_unref);
		_tmp21_ = self->priv->state;
		_tmp22_ = source;
		state_connected_cb ((State*) _tmp21_, _tmp22_);
	}
	_g_object_unref0 (media);
}


static void state_choose_category_value_child_media_list_builder_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void state_choose_category_value_child_media_list_builder_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		state_choose_category_child_media_list_builder_unref (value->data[0].v_pointer);
	}
}


static void state_choose_category_value_child_media_list_builder_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = state_choose_category_child_media_list_builder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer state_choose_category_value_child_media_list_builder_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* state_choose_category_value_child_media_list_builder_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		StateChooseCategoryChildMediaListBuilder* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = state_choose_category_child_media_list_builder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* state_choose_category_value_child_media_list_builder_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	StateChooseCategoryChildMediaListBuilder** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = state_choose_category_child_media_list_builder_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* state_choose_category_param_spec_child_media_list_builder (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	StateChooseCategoryParamSpecChildMediaListBuilder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer state_choose_category_value_get_child_media_list_builder (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER), NULL);
	return value->data[0].v_pointer;
}


static void state_choose_category_value_set_child_media_list_builder (GValue* value, gpointer v_object) {
	StateChooseCategoryChildMediaListBuilder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		state_choose_category_child_media_list_builder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		state_choose_category_child_media_list_builder_unref (old);
	}
}


static void state_choose_category_value_take_child_media_list_builder (GValue* value, gpointer v_object) {
	StateChooseCategoryChildMediaListBuilder* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		state_choose_category_child_media_list_builder_unref (old);
	}
}


static void state_choose_category_child_media_list_builder_class_init (StateChooseCategoryChildMediaListBuilderClass * klass) {
	state_choose_category_child_media_list_builder_parent_class = g_type_class_peek_parent (klass);
	((StateChooseCategoryChildMediaListBuilderClass *) klass)->finalize = state_choose_category_child_media_list_builder_finalize;
	g_type_class_add_private (klass, sizeof (StateChooseCategoryChildMediaListBuilderPrivate));
}


static void state_choose_category_child_media_list_builder_instance_init (StateChooseCategoryChildMediaListBuilder * self) {
	self->priv = STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_GET_PRIVATE (self);
	self->priv->count = (guint) 0;
	self->ref_count = 1;
}


static void state_choose_category_child_media_list_builder_finalize (StateChooseCategoryChildMediaListBuilder* obj) {
	StateChooseCategoryChildMediaListBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STATE_CHOOSE_CATEGORY_TYPE_CHILD_MEDIA_LIST_BUILDER, StateChooseCategoryChildMediaListBuilder);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->state);
}


static GType state_choose_category_child_media_list_builder_get_type (void) {
	static volatile gsize state_choose_category_child_media_list_builder_type_id__volatile = 0;
	if (g_once_init_enter (&state_choose_category_child_media_list_builder_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { state_choose_category_value_child_media_list_builder_init, state_choose_category_value_child_media_list_builder_free_value, state_choose_category_value_child_media_list_builder_copy_value, state_choose_category_value_child_media_list_builder_peek_pointer, "p", state_choose_category_value_child_media_list_builder_collect_value, "p", state_choose_category_value_child_media_list_builder_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (StateChooseCategoryChildMediaListBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_choose_category_child_media_list_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StateChooseCategoryChildMediaListBuilder), 0, (GInstanceInitFunc) state_choose_category_child_media_list_builder_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType state_choose_category_child_media_list_builder_type_id;
		state_choose_category_child_media_list_builder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "StateChooseCategoryChildMediaListBuilder", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&state_choose_category_child_media_list_builder_type_id__volatile, state_choose_category_child_media_list_builder_type_id);
	}
	return state_choose_category_child_media_list_builder_type_id__volatile;
}


static gpointer state_choose_category_child_media_list_builder_ref (gpointer instance) {
	StateChooseCategoryChildMediaListBuilder* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void state_choose_category_child_media_list_builder_unref (gpointer instance) {
	StateChooseCategoryChildMediaListBuilder* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		STATE_CHOOSE_CATEGORY_CHILD_MEDIA_LIST_BUILDER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void state_choose_category_class_init (StateChooseCategoryClass * klass) {
	state_choose_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StateChooseCategoryPrivate));
	((StateClass *) klass)->print_selected = state_choose_category_real_print_selected;
	((StateClass *) klass)->seekback = state_choose_category_real_seekback;
	((StateClass *) klass)->seekforward = state_choose_category_real_seekforward;
	((StateClass *) klass)->next = state_choose_category_real_next;
	((StateClass *) klass)->previous = state_choose_category_real_previous;
	((StateClass *) klass)->transition = state_choose_category_real_transition;
	G_OBJECT_CLASS (klass)->finalize = state_choose_category_finalize;
}


static void state_choose_category_instance_init (StateChooseCategory * self) {
	GeeArrayList* _tmp0_ = NULL;
	self->priv = STATE_CHOOSE_CATEGORY_GET_PRIVATE (self);
	self->priv->page = 0;
	self->priv->current = 0;
	self->priv->canary = NULL;
	_tmp0_ = gee_array_list_new (grl_media_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->media = _tmp0_;
}


static void state_choose_category_finalize (GObject* obj) {
	StateChooseCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategory);
	_g_object_unref0 (self->priv->parent_selection);
	_g_main_loop_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->categories);
	_g_object_unref0 (self->priv->canary);
	_g_object_unref0 (self->priv->media);
	_state_choose_category_child_media_list_builder_unref0 (self->priv->child_media_list_builder);
	G_OBJECT_CLASS (state_choose_category_parent_class)->finalize (obj);
}


GType state_choose_category_get_type (void) {
	static volatile gsize state_choose_category_type_id__volatile = 0;
	if (g_once_init_enter (&state_choose_category_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StateChooseCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_choose_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StateChooseCategory), 0, (GInstanceInitFunc) state_choose_category_instance_init, NULL };
		GType state_choose_category_type_id;
		state_choose_category_type_id = g_type_register_static (TYPE_STATE, "StateChooseCategory", &g_define_type_info, 0);
		g_once_init_leave (&state_choose_category_type_id__volatile, state_choose_category_type_id);
	}
	return state_choose_category_type_id__volatile;
}



