/* state.c generated by valac 0.32.0, the Vala compiler
 * generated from state.vala, do not modify */

/*   FILE: state.vala -- A state machine implementing lcdgrilo's menu
 * AUTHOR: W. Michael Petullo <mike@flyn.org>
 *   DATE: 01 December 2013 
 *
 * Copyright (c) 2013 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* The PiFace CAD provides the following inputs:
 *   From left to right:
 *     Button 0 = 0
 *     Button 1 = 1
 *     Button 2 = 2
 *     Button 3 = 3
 *     Button 4 = 4
 *   Rocker switch:
 *     Select     = 5
 *     Rock left  = 6
 *     Rock right = 7
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>
#include <stdio.h>
#include <unistd.h>
#include <grilo.h>


#define TYPE_SWITCH_NUMBER (switch_number_get_type ())

#define TYPE_STATE (state_get_type ())
#define STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE, State))
#define STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE, StateClass))
#define IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE))
#define IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE))
#define STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE, StateClass))

typedef struct _State State;
typedef struct _StateClass StateClass;
typedef struct _StatePrivate StatePrivate;

#define TYPE_LCD_PLAYER (lcd_player_get_type ())
#define LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LCD_PLAYER, LCDPlayer))
#define LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LCD_PLAYER, LCDPlayerClass))
#define IS_LCD_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LCD_PLAYER))
#define IS_LCD_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LCD_PLAYER))
#define LCD_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LCD_PLAYER, LCDPlayerClass))

typedef struct _LCDPlayer LCDPlayer;
typedef struct _LCDPlayerClass LCDPlayerClass;
typedef struct _LCDPlayerPrivate LCDPlayerPrivate;

#define TYPE_STACK (stack_get_type ())
#define STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STACK, Stack))
#define STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STACK, StackClass))
#define IS_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STACK))
#define IS_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STACK))
#define STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STACK, StackClass))

typedef struct _Stack Stack;
typedef struct _StackClass StackClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))

#define TYPE_STATE_CONNECTING (state_connecting_get_type ())
#define STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CONNECTING, StateConnecting))
#define STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CONNECTING, StateConnectingClass))
#define IS_STATE_CONNECTING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CONNECTING))
#define IS_STATE_CONNECTING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CONNECTING))
#define STATE_CONNECTING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CONNECTING, StateConnectingClass))

typedef struct _StateConnecting StateConnecting;
typedef struct _StateConnectingClass StateConnectingClass;

#define TYPE_STATE_CHOOSE_CATEGORY (state_choose_category_get_type ())
#define STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategory))
#define STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))
#define IS_STATE_CHOOSE_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATE_CHOOSE_CATEGORY))
#define IS_STATE_CHOOSE_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATE_CHOOSE_CATEGORY))
#define STATE_CHOOSE_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategoryClass))

typedef struct _StateChooseCategory StateChooseCategory;
typedef struct _StateChooseCategoryClass StateChooseCategoryClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SWITCH_NUMBER_SWITCH_STOP = 0,
	SWITCH_NUMBER_SWITCH_SEEKBACK = 1,
	SWITCH_NUMBER_SWITCH_PAUSE_PLAY = 2,
	SWITCH_NUMBER_SWITCH_SEEKFORWARD = 3,
	SWITCH_NUMBER_SWITCH_ESCAPE = 4,
	SWITCH_NUMBER_SWITCH_SELECT = 5,
	SWITCH_NUMBER_SWITCH_LEFT = 6,
	SWITCH_NUMBER_SWITCH_RIGHT = 7
} SwitchNumber;

struct _State {
	GObject parent_instance;
	StatePrivate * priv;
	LCDPlayer* player;
};

struct _StateClass {
	GObjectClass parent_class;
	void (*print_selected) (State* self);
	void (*seekback) (State* self);
	void (*seekforward) (State* self);
	void (*next) (State* self);
	void (*previous) (State* self);
	State* (*transition) (State* self);
};

struct _StatePrivate {
	guint lights_out_timeout_id;
	guint8* lastSwitchState;
	gint lastSwitchState_length1;
	gint _lastSwitchState_size_;
};

struct _LCDPlayer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	LCDPlayerPrivate * priv;
	GstElement* element;
};

struct _LCDPlayerClass {
	GTypeClass parent_class;
	void (*finalize) (LCDPlayer *self);
};


static gpointer state_parent_class = NULL;
static gboolean state_initialized;
static gboolean state_initialized = FALSE;
static guint state_output_shift;
static guint state_output_shift = (guint) 0;
static gchar* state_output_str;
static gchar* state_output_str = NULL;
extern gboolean no_pifacecad;

GType switch_number_get_type (void) G_GNUC_CONST;
GType state_get_type (void) G_GNUC_CONST;
gpointer lcd_player_ref (gpointer instance);
void lcd_player_unref (gpointer instance);
GParamSpec* param_spec_lcd_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_lcd_player (GValue* value, gpointer v_object);
void value_take_lcd_player (GValue* value, gpointer v_object);
gpointer value_get_lcd_player (const GValue* value);
GType lcd_player_get_type (void) G_GNUC_CONST;
#define STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STATE, StatePrivate))
enum  {
	STATE_DUMMY_PROPERTY
};
void state_print_selected (State* self);
static void state_real_print_selected (State* self);
void state_stop (State* self);
GType stack_get_type (void) G_GNUC_CONST;
Stack* lcd_player_get_stateStack (LCDPlayer* self);
gpointer stack_peek (Stack* self);
void state_seekback (State* self);
static void state_real_seekback (State* self);
void state_seekforward (State* self);
static void state_real_seekforward (State* self);
void state_next (State* self);
static void state_real_next (State* self);
void state_previous (State* self);
static void state_real_previous (State* self);
State* state_transition (State* self);
static State* state_real_transition (State* self);
State* state_construct (GType object_type);
void state_register_handlers (State* self);
static void state_start_output (State* self);
void state_pause_play (State* self);
void state_output (State* self, const gchar* str);
gboolean state_check_keyboard (State* self, GIOChannel* channel, GIOCondition condition);
static void state_do_input (State* self, guint8 op);
static gboolean state_render_output (State* self);
static gboolean _state_render_output_gsource_func (gpointer self);
gboolean state_lights_out (State* self);
static gboolean _state_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
#define SWITCH_POLL_MILLISECONDS ((guint) 1)
gboolean state_check_switches (State* self);
static gboolean _state_check_switches_gsource_func (gpointer self);
static void state_do_stop (State* self);
static void state_do_seekback (State* self);
static void state_do_pause_play (State* self);
static void state_do_seekforward (State* self);
static void state_do_escape (State* self);
static void state_do_left (State* self);
static void state_do_right (State* self);
static void state_do_select (State* self);
#define LIGHTS_OUT_SECONDS ((guint) 10)
static gboolean _state_lights_out_gsource_func (gpointer self);
gsize stack_size (Stack* self);
gpointer stack_pop (Stack* self);
void stack_push (Stack* self, gconstpointer item);
void state_connected_cb (State* self, GrlSource* source);
GType state_connecting_get_type (void) G_GNUC_CONST;
GType state_choose_category_get_type (void) G_GNUC_CONST;
void state_choose_category_build_menu (StateChooseCategory* self);
static void state_finalize (GObject* obj);


GType switch_number_get_type (void) {
	static volatile gsize switch_number_type_id__volatile = 0;
	if (g_once_init_enter (&switch_number_type_id__volatile)) {
		static const GEnumValue values[] = {{SWITCH_NUMBER_SWITCH_STOP, "SWITCH_NUMBER_SWITCH_STOP", "switch-stop"}, {SWITCH_NUMBER_SWITCH_SEEKBACK, "SWITCH_NUMBER_SWITCH_SEEKBACK", "switch-seekback"}, {SWITCH_NUMBER_SWITCH_PAUSE_PLAY, "SWITCH_NUMBER_SWITCH_PAUSE_PLAY", "switch-pause-play"}, {SWITCH_NUMBER_SWITCH_SEEKFORWARD, "SWITCH_NUMBER_SWITCH_SEEKFORWARD", "switch-seekforward"}, {SWITCH_NUMBER_SWITCH_ESCAPE, "SWITCH_NUMBER_SWITCH_ESCAPE", "switch-escape"}, {SWITCH_NUMBER_SWITCH_SELECT, "SWITCH_NUMBER_SWITCH_SELECT", "switch-select"}, {SWITCH_NUMBER_SWITCH_LEFT, "SWITCH_NUMBER_SWITCH_LEFT", "switch-left"}, {SWITCH_NUMBER_SWITCH_RIGHT, "SWITCH_NUMBER_SWITCH_RIGHT", "switch-right"}, {0, NULL, NULL}};
		GType switch_number_type_id;
		switch_number_type_id = g_enum_register_static ("SwitchNumber", values);
		g_once_init_leave (&switch_number_type_id__volatile, switch_number_type_id);
	}
	return switch_number_type_id__volatile;
}


static void state_real_print_selected (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_print_selected'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void state_print_selected (State* self) {
	g_return_if_fail (self != NULL);
	STATE_GET_CLASS (self)->print_selected (self);
}


void state_stop (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	LCDPlayer* _tmp2_ = NULL;
	Stack* _tmp3_ = NULL;
	Stack* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	State* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = _tmp0_->element;
	gst_element_set_state (_tmp1_, GST_STATE_NULL);
	_tmp2_ = self->player;
	_tmp3_ = lcd_player_get_stateStack (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = stack_peek (_tmp4_);
	_tmp6_ = (State*) _tmp5_;
	state_print_selected (_tmp6_);
	_g_object_unref0 (_tmp6_);
}


static void state_real_seekback (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_seekback'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void state_seekback (State* self) {
	g_return_if_fail (self != NULL);
	STATE_GET_CLASS (self)->seekback (self);
}


static void state_real_seekforward (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_seekforward'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void state_seekforward (State* self) {
	g_return_if_fail (self != NULL);
	STATE_GET_CLASS (self)->seekforward (self);
}


static void state_real_next (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_next'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void state_next (State* self) {
	g_return_if_fail (self != NULL);
	STATE_GET_CLASS (self)->next (self);
}


static void state_real_previous (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_previous'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void state_previous (State* self) {
	g_return_if_fail (self != NULL);
	STATE_GET_CLASS (self)->previous (self);
}


static State* state_real_transition (State* self) {
	g_critical ("Type `%s' does not implement abstract method `state_transition'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


State* state_transition (State* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return STATE_GET_CLASS (self)->transition (self);
}


State* state_construct (GType object_type) {
	State * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (State*) g_object_new (object_type, NULL);
	_tmp0_ = state_initialized;
	if (FALSE == _tmp0_) {
		state_register_handlers (self);
		state_start_output (self);
		state_initialized = TRUE;
	}
	return self;
}


void state_pause_play (State* self) {
	GstState state = 0;
	LCDPlayer* _tmp0_ = NULL;
	GstElement* _tmp1_ = NULL;
	GstState _tmp2_ = 0;
	GstState _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = _tmp0_->element;
	gst_element_get_state (_tmp1_, &_tmp2_, NULL, (GstClockTime) 0);
	state = _tmp2_;
	_tmp3_ = state;
	if (GST_STATE_PLAYING == _tmp3_) {
		LCDPlayer* _tmp4_ = NULL;
		GstElement* _tmp5_ = NULL;
		_tmp4_ = self->player;
		_tmp5_ = _tmp4_->element;
		gst_element_set_state (_tmp5_, GST_STATE_PAUSED);
		state_output (self, "Paused");
	} else {
		GstState _tmp6_ = 0;
		_tmp6_ = state;
		if (GST_STATE_PAUSED == _tmp6_) {
			LCDPlayer* _tmp7_ = NULL;
			GstElement* _tmp8_ = NULL;
			LCDPlayer* _tmp9_ = NULL;
			Stack* _tmp10_ = NULL;
			Stack* _tmp11_ = NULL;
			gpointer _tmp12_ = NULL;
			State* _tmp13_ = NULL;
			_tmp7_ = self->player;
			_tmp8_ = _tmp7_->element;
			gst_element_set_state (_tmp8_, GST_STATE_PLAYING);
			_tmp9_ = self->player;
			_tmp10_ = lcd_player_get_stateStack (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = stack_peek (_tmp11_);
			_tmp13_ = (State*) _tmp12_;
			state_print_selected (_tmp13_);
			_g_object_unref0 (_tmp13_);
		}
	}
}


gboolean state_check_keyboard (State* self, GIOChannel* channel, GIOCondition condition) {
	gboolean result = FALSE;
	gchar* c = NULL;
	gchar* _tmp0_ = NULL;
	gint c_length1 = 0;
	gint _c_size_ = 0;
	GIOCondition _tmp1_ = 0;
	gchar* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar _tmp18_ = '\0';
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	_tmp0_ = g_new0 (gchar, 1);
	c = _tmp0_;
	c_length1 = 1;
	_c_size_ = c_length1;
	_tmp1_ = condition;
	if (_tmp1_ == G_IO_HUP) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "Standard in closed?\n");
		result = FALSE;
		c = (g_free (c), NULL);
		return result;
	}
	{
		gsize length = 0UL;
		GIOStatus status = 0;
		GIOChannel* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gsize _tmp5_ = 0UL;
		GIOStatus _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		GIOStatus _tmp8_ = 0;
		length = (gsize) -1;
		_tmp3_ = channel;
		_tmp4_ = c;
		_tmp4__length1 = c_length1;
		_tmp6_ = g_io_channel_read_chars (_tmp3_, _tmp4_, _tmp4__length1, &_tmp5_, &_inner_error_);
		length = _tmp5_;
		status = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch4_g_io_channel_error;
			}
			if (_inner_error_->domain == G_CONVERT_ERROR) {
				goto __catch4_g_convert_error;
			}
			c = (g_free (c), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp8_ = status;
		if (_tmp8_ == G_IO_STATUS_EOF) {
			_tmp7_ = TRUE;
		} else {
			gsize _tmp9_ = 0UL;
			_tmp9_ = length;
			_tmp7_ = _tmp9_ != ((gsize) 1);
		}
		if (_tmp7_) {
			FILE* _tmp10_ = NULL;
			_tmp10_ = stderr;
			fprintf (_tmp10_, "Standard in closed?\n");
			result = FALSE;
			c = (g_free (c), NULL);
			return result;
		}
	}
	goto __finally4;
	__catch4_g_io_channel_error:
	{
		GError* e = NULL;
		FILE* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "IOChannelError: %s\n", _tmp13_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	goto __finally4;
	__catch4_g_convert_error:
	{
		GError* e = NULL;
		FILE* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = stderr;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		fprintf (_tmp14_, "ConvertError: %s\n", _tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		c = (g_free (c), NULL);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		c = (g_free (c), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp17_ = c;
	_tmp17__length1 = c_length1;
	_tmp18_ = _tmp17_[0];
	switch (_tmp18_) {
		case 'z':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_STOP);
			break;
		}
		case 'q':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_SEEKBACK);
			break;
		}
		case 'w':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_SEEKFORWARD);
			break;
		}
		case ' ':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_PAUSE_PLAY);
			break;
		}
		case 'a':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_LEFT);
			break;
		}
		case 's':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_RIGHT);
			break;
		}
		case '\n':
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_SELECT);
			break;
		}
		case 0x1b:
		{
			state_do_input (self, (guint8) SWITCH_NUMBER_SWITCH_ESCAPE);
			break;
		}
		default:
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = no_pifacecad;
			if (!_tmp19_) {
				g_warning ("state.vala:153: Invalid key pressed");
			} else {
				FILE* _tmp20_ = NULL;
				FILE* _tmp21_ = NULL;
				FILE* _tmp22_ = NULL;
				FILE* _tmp23_ = NULL;
				FILE* _tmp24_ = NULL;
				FILE* _tmp25_ = NULL;
				FILE* _tmp26_ = NULL;
				FILE* _tmp27_ = NULL;
				FILE* _tmp28_ = NULL;
				_tmp20_ = stderr;
				fprintf (_tmp20_, "Valid keys are:\n");
				_tmp21_ = stderr;
				fprintf (_tmp21_, "  'z'     (stop)\n");
				_tmp22_ = stderr;
				fprintf (_tmp22_, "  'q'     (seek backward)\n");
				_tmp23_ = stderr;
				fprintf (_tmp23_, "  'w'     (seek forward)\n");
				_tmp24_ = stderr;
				fprintf (_tmp24_, "  ' '     (pause/play)\n");
				_tmp25_ = stderr;
				fprintf (_tmp25_, "  'a'     (left)\n");
				_tmp26_ = stderr;
				fprintf (_tmp26_, "  's'     (right)\n");
				_tmp27_ = stderr;
				fprintf (_tmp27_, "  'enter' (select)\n");
				_tmp28_ = stderr;
				fprintf (_tmp28_, "  'esc'   (escape)\n");
			}
			break;
		}
	}
	result = TRUE;
	c = (g_free (c), NULL);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean state_render_output (State* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	pifacecad_lcd_clear ();
	_tmp0_ = state_output_str;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 15) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = state_output_str;
		pifacecad_lcd_write (_tmp3_);
	} else {
		GString* builder = NULL;
		GString* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		guint rest = 0U;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		guint cutoff = 0U;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GString* _tmp24_ = NULL;
		GString* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		guint _tmp27_ = 0U;
		guint _tmp28_ = 0U;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		GString* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		guint _tmp33_ = 0U;
		guint _tmp34_ = 0U;
		guint _tmp35_ = 0U;
		_tmp4_ = g_string_new ("");
		builder = _tmp4_;
		_tmp6_ = state_output_str;
		_tmp7_ = strlen (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 30) {
			_tmp5_ = 15;
		} else {
			const gchar* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			_tmp9_ = state_output_str;
			_tmp10_ = strlen (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_ - 15;
		}
		rest = (guint) _tmp5_;
		_tmp13_ = state_output_str;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > 30) {
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			_tmp16_ = state_output_str;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp12_ = _tmp18_ - 30;
		} else {
			_tmp12_ = 0;
		}
		cutoff = (guint) _tmp12_;
		_tmp19_ = builder;
		_tmp20_ = state_output_str;
		_tmp21_ = state_output_shift;
		_tmp22_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) 15);
		_tmp23_ = _tmp22_;
		g_string_append (_tmp19_, _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = builder;
		g_string_append (_tmp24_, "\n ");
		_tmp25_ = builder;
		_tmp26_ = state_output_str;
		_tmp27_ = state_output_shift;
		_tmp28_ = rest;
		_tmp29_ = string_substring (_tmp26_, (glong) (15 + _tmp27_), (glong) _tmp28_);
		_tmp30_ = _tmp29_;
		g_string_append (_tmp25_, _tmp30_);
		_g_free0 (_tmp30_);
		_tmp31_ = builder;
		_tmp32_ = _tmp31_->str;
		pifacecad_lcd_write (_tmp32_);
		_tmp34_ = state_output_shift;
		_tmp35_ = cutoff;
		if (_tmp34_ < _tmp35_) {
			guint _tmp36_ = 0U;
			_tmp36_ = state_output_shift;
			_tmp33_ = _tmp36_ + 1;
		} else {
			_tmp33_ = (guint) 0;
		}
		state_output_shift = _tmp33_;
		_g_string_free0 (builder);
	}
	result = TRUE;
	return result;
}


static gboolean _state_render_output_gsource_func (gpointer self) {
	gboolean result;
	result = state_render_output ((State*) self);
	return result;
}


static void state_start_output (State* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 750, _state_render_output_gsource_func, g_object_ref (self), g_object_unref);
	}
}


void state_output (State* self, const gchar* str) {
	FILE* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = stdout;
	_tmp1_ = str;
	fprintf (_tmp0_, "%s\n", _tmp1_);
	state_output_shift = (guint) 0;
	_tmp2_ = str;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (state_output_str);
	state_output_str = _tmp3_;
	_tmp4_ = no_pifacecad;
	if (!_tmp4_) {
		state_render_output (self);
	}
}


gboolean state_lights_out (State* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("state.vala:212: Lights out.\n");
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		pifacecad_lcd_backlight_off ();
	}
	self->priv->lights_out_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean _state_check_keyboard_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = state_check_keyboard ((State*) self, source, condition);
	return result;
}


static gboolean _state_check_switches_gsource_func (gpointer self) {
	gboolean result;
	result = state_check_switches ((State*) self);
	return result;
}


void state_register_handlers (State* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GIOChannel* channel = NULL;
		GIOChannel* _tmp0_ = NULL;
		_tmp0_ = g_io_channel_unix_new (STDIN_FILENO);
		channel = _tmp0_;
		g_io_channel_set_encoding (channel, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_io_channel_unref0 (channel);
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch5_g_io_channel_error;
			}
			_g_io_channel_unref0 (channel);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		g_io_add_watch (channel, G_IO_IN, _state_check_keyboard_gio_func, self);
		g_timeout_add_full (G_PRIORITY_DEFAULT, SWITCH_POLL_MILLISECONDS, _state_check_switches_gsource_func, g_object_ref (self), g_object_unref);
		_g_io_channel_unref0 (channel);
	}
	goto __finally5;
	__catch5_g_io_channel_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("state.vala:227: Channel error initializing state");
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean state_check_switches (State* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		{
			guint8 _switch_ = 0U;
			_switch_ = (guint8) 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					guint8 _tmp3_ = 0U;
					guint8 current = 0U;
					guint8 _tmp4_ = 0U;
					guint8 _tmp5_ = 0U;
					gboolean _tmp6_ = FALSE;
					guint8 _tmp7_ = 0U;
					guint8* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					guint8 _tmp13_ = 0U;
					guint8 _tmp14_ = 0U;
					guint8 _tmp15_ = 0U;
					if (!_tmp1_) {
						guint8 _tmp2_ = 0U;
						_tmp2_ = _switch_;
						_switch_ = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = _switch_;
					if (!(((gint) _tmp3_) < 8)) {
						break;
					}
					_tmp4_ = _switch_;
					_tmp5_ = pifacecad_read_switch (_tmp4_);
					current = _tmp5_;
					_tmp7_ = current;
					if (0 == ((gint) _tmp7_)) {
						guint8* _tmp8_ = NULL;
						gint _tmp8__length1 = 0;
						guint8 _tmp9_ = 0U;
						guint8 _tmp10_ = 0U;
						_tmp8_ = self->priv->lastSwitchState;
						_tmp8__length1 = self->priv->lastSwitchState_length1;
						_tmp9_ = _switch_;
						_tmp10_ = _tmp8_[_tmp9_];
						_tmp6_ = 1 == ((gint) _tmp10_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						guint8 _tmp11_ = 0U;
						_tmp11_ = _switch_;
						state_do_input (self, _tmp11_);
					}
					_tmp12_ = self->priv->lastSwitchState;
					_tmp12__length1 = self->priv->lastSwitchState_length1;
					_tmp13_ = _switch_;
					_tmp14_ = current;
					_tmp12_[_tmp13_] = _tmp14_;
					_tmp15_ = _tmp12_[_tmp13_];
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean _state_lights_out_gsource_func (gpointer self) {
	gboolean result;
	result = state_lights_out ((State*) self);
	return result;
}


static void state_do_input (State* self, guint8 op) {
	gboolean _tmp0_ = FALSE;
	guint8 _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = no_pifacecad;
	if (!_tmp0_) {
		pifacecad_lcd_backlight_on ();
	}
	_tmp1_ = op;
	switch (_tmp1_) {
		case SWITCH_NUMBER_SWITCH_STOP:
		{
			state_do_stop (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_SEEKBACK:
		{
			state_do_seekback (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_PAUSE_PLAY:
		{
			state_do_pause_play (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_SEEKFORWARD:
		{
			state_do_seekforward (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_ESCAPE:
		{
			state_do_escape (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_LEFT:
		{
			state_do_left (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_RIGHT:
		{
			state_do_right (self);
			break;
		}
		case SWITCH_NUMBER_SWITCH_SELECT:
		{
			state_do_select (self);
			break;
		}
		default:
		{
			g_warning ("state.vala:278: Invalid button pressed");
			break;
		}
	}
	_tmp2_ = self->priv->lights_out_timeout_id;
	if (((guint) 0) != _tmp2_) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->lights_out_timeout_id;
		g_source_remove (_tmp3_);
	}
	_tmp4_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, LIGHTS_OUT_SECONDS, _state_lights_out_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->lights_out_timeout_id = _tmp4_;
}


static void state_do_stop (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_stop (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_seekback (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_seekback (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_pause_play (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_pause_play (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_seekforward (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_seekforward (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_escape (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gsize _tmp3_ = 0UL;
	LCDPlayer* _tmp9_ = NULL;
	Stack* _tmp10_ = NULL;
	Stack* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	State* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_size (_tmp2_);
	if (_tmp3_ > ((gsize) 1)) {
		LCDPlayer* _tmp4_ = NULL;
		Stack* _tmp5_ = NULL;
		Stack* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		State* _tmp8_ = NULL;
		_tmp4_ = self->player;
		_tmp5_ = lcd_player_get_stateStack (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = stack_pop (_tmp6_);
		_tmp8_ = (State*) _tmp7_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp9_ = self->player;
	_tmp10_ = lcd_player_get_stateStack (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = stack_peek (_tmp11_);
	_tmp13_ = (State*) _tmp12_;
	state_print_selected (_tmp13_);
	_g_object_unref0 (_tmp13_);
}


static void state_do_left (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_previous (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_right (State* self) {
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	state_next (_tmp4_);
	_g_object_unref0 (_tmp4_);
}


static void state_do_select (State* self) {
	State* next = NULL;
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	State* _tmp5_ = NULL;
	State* _tmp6_ = NULL;
	LCDPlayer* _tmp7_ = NULL;
	Stack* _tmp8_ = NULL;
	Stack* _tmp9_ = NULL;
	gpointer _tmp10_ = NULL;
	State* _tmp11_ = NULL;
	State* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_peek (_tmp2_);
	_tmp4_ = (State*) _tmp3_;
	_tmp5_ = state_transition (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	next = _tmp6_;
	_tmp7_ = self->player;
	_tmp8_ = lcd_player_get_stateStack (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = stack_peek (_tmp9_);
	_tmp11_ = (State*) _tmp10_;
	_tmp12_ = next;
	_tmp13_ = _tmp11_ != _tmp12_;
	_g_object_unref0 (_tmp11_);
	if (_tmp13_) {
		LCDPlayer* _tmp14_ = NULL;
		Stack* _tmp15_ = NULL;
		Stack* _tmp16_ = NULL;
		State* _tmp17_ = NULL;
		_tmp14_ = self->player;
		_tmp15_ = lcd_player_get_stateStack (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = next;
		stack_push (_tmp16_, _tmp17_);
	}
	_g_object_unref0 (next);
}


void state_connected_cb (State* self, GrlSource* source) {
	State* state = NULL;
	LCDPlayer* _tmp0_ = NULL;
	Stack* _tmp1_ = NULL;
	Stack* _tmp2_ = NULL;
	gpointer _tmp3_ = NULL;
	State* _tmp4_ = NULL;
	StateChooseCategory* next_state = NULL;
	State* _tmp5_ = NULL;
	State* _tmp6_ = NULL;
	StateChooseCategory* _tmp7_ = NULL;
	StateChooseCategory* _tmp8_ = NULL;
	LCDPlayer* _tmp9_ = NULL;
	Stack* _tmp10_ = NULL;
	Stack* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	State* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->player;
	_tmp1_ = lcd_player_get_stateStack (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = stack_pop (_tmp2_);
	state = (State*) _tmp3_;
	_tmp4_ = state;
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_STATE_CONNECTING), "state is StateConnecting");
	_tmp5_ = state;
	_tmp6_ = state_transition (_tmp5_);
	next_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_STATE_CHOOSE_CATEGORY, StateChooseCategory);
	_tmp7_ = next_state;
	state_choose_category_build_menu (_tmp7_);
	_tmp8_ = next_state;
	_tmp9_ = self->player;
	_tmp10_ = lcd_player_get_stateStack (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = stack_peek (_tmp11_);
	_tmp13_ = (State*) _tmp12_;
	_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_STATE, State) != _tmp13_;
	_g_object_unref0 (_tmp13_);
	if (_tmp14_) {
		LCDPlayer* _tmp15_ = NULL;
		Stack* _tmp16_ = NULL;
		Stack* _tmp17_ = NULL;
		StateChooseCategory* _tmp18_ = NULL;
		_tmp15_ = self->player;
		_tmp16_ = lcd_player_get_stateStack (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = next_state;
		stack_push (_tmp17_, (State*) _tmp18_);
	}
	_g_object_unref0 (next_state);
	_g_object_unref0 (state);
}


static void state_class_init (StateClass * klass) {
	gchar* _tmp0_ = NULL;
	state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StatePrivate));
	((StateClass *) klass)->print_selected = state_real_print_selected;
	((StateClass *) klass)->seekback = state_real_seekback;
	((StateClass *) klass)->seekforward = state_real_seekforward;
	((StateClass *) klass)->next = state_real_next;
	((StateClass *) klass)->previous = state_real_previous;
	((StateClass *) klass)->transition = state_real_transition;
	G_OBJECT_CLASS (klass)->finalize = state_finalize;
	_tmp0_ = g_strdup ("");
	state_output_str = _tmp0_;
}


static void state_instance_init (State * self) {
	guint8* _tmp0_ = NULL;
	self->priv = STATE_GET_PRIVATE (self);
	self->priv->lights_out_timeout_id = (guint) 0;
	_tmp0_ = g_new0 (guint8, 8);
	_tmp0_[0] = (guint8) 1;
	_tmp0_[1] = (guint8) 1;
	_tmp0_[2] = (guint8) 1;
	_tmp0_[3] = (guint8) 1;
	_tmp0_[4] = (guint8) 1;
	_tmp0_[5] = (guint8) 1;
	_tmp0_[6] = (guint8) 1;
	_tmp0_[7] = (guint8) 1;
	self->priv->lastSwitchState = _tmp0_;
	self->priv->lastSwitchState_length1 = 8;
	self->priv->_lastSwitchState_size_ = self->priv->lastSwitchState_length1;
}


static void state_finalize (GObject* obj) {
	State * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATE, State);
	self->priv->lastSwitchState = (g_free (self->priv->lastSwitchState), NULL);
	G_OBJECT_CLASS (state_parent_class)->finalize (obj);
}


GType state_get_type (void) {
	static volatile gsize state_type_id__volatile = 0;
	if (g_once_init_enter (&state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (State), 0, (GInstanceInitFunc) state_instance_init, NULL };
		GType state_type_id;
		state_type_id = g_type_register_static (G_TYPE_OBJECT, "State", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&state_type_id__volatile, state_type_id);
	}
	return state_type_id__volatile;
}



