/*
 * lispd_config.h
 *
 * This file is part of LISP Mobile Node Implementation.
 * Handle lispd command line and config file
 * Parse command line args using gengetopt.
 * Handle config file with libconfuse.
 *
 * Copyright (C) 2011 Cisco Systems, Inc, 2011. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Please send any bug reports or fixes you make to the email address(es):
 *    LISP-MN developers <devel@lispmob.org>
 *
 * Written or modified by:
 *    David Meyer       <dmm@cisco.com>
 *    Preethi Natarajan <prenatar@cisco.com>
 *    Lorand Jakab      <ljakab@ac.upc.edu>
 *    Alberto Rodriguez Natal <arnatal@ac.upc.edu>
 *
 */

#ifndef LISPD_CONFIG_H_
#define LISPD_CONFIG_H_

#define CONF_FILE_NAME  "lispd.conf"


/*
 *  Get command line args and set up whatever is needed
 */
int handle_lispd_command_line(int argc, char **argv);



#ifdef OPENWRT

/* Parse OpenWRT UCI config file */

int handle_uci_lispd_config_file(char *uci_conf_file_path);

#else

/*
 *  Parse config file and set up whatever is needed
 */
int handle_lispd_config_file(char * lispdconf_conf_file);

#endif



#endif /*LISPD_CONFIG_H_*/
