#include <lua.h>
#include <lauxlib.h>
#include "sha2.h"

/**
*  @param: an arbitrary binary string.
*  @return: an SHA-256 hash string.
*/
static int sha256(lua_State *L) {
	size_t l;
	unsigned char buf[SHA256_DIGEST_STRING_LENGTH];
	const char *s = luaL_checklstring(L, 1, &l);
	SHA256_Data(s, l, buf);
	lua_pushlstring(L, buf, SHA256_DIGEST_STRING_LENGTH - 1);
	return 1;
}

/**
*  @param: an arbitrary binary string.
*  @return: an SHA-384 hash string.
*/
static int sha384(lua_State *L) {
	size_t l;
	unsigned char buf[SHA384_DIGEST_STRING_LENGTH];
	const char *s = luaL_checklstring(L, 1, &l);
	SHA384_Data(s, l, buf);
	lua_pushlstring(L, buf, SHA384_DIGEST_STRING_LENGTH - 1);
	return 1;
}

/**
*  @param: an arbitrary binary string.
*  @return: an SHA-512 hash string.
*/
static int sha512(lua_State *L) {
	size_t l;
	unsigned char buf[SHA512_DIGEST_STRING_LENGTH];
	const char *s = luaL_checklstring(L, 1, &l);
	SHA512_Data(s, l, buf);
	lua_pushlstring(L, buf, SHA512_DIGEST_STRING_LENGTH - 1);
	return 1;
}

/*
** Assumes the table is on top of the stack.
*/
static void set_info (lua_State *L) {
	lua_pushliteral (L, "_VERSION");
	lua_pushliteral (L, "sha2 0.1.0");
	lua_settable (L, -3);
}

static struct luaL_reg reg[] = {
	{"sha256", sha256},
	{"sha384", sha384},
	{"sha512", sha512},
	{NULL, NULL}
};

int luaopen_sha2(lua_State *L) {
	luaL_openlib(L, "sha2", reg, 0);
	set_info (L);
	return 1;
}

